/**
 * @author Abhishek Chouhan
 * 
 */
Ext.define('Academia.view.reports.admission.dashboard.ApplicationSummaryGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.applicationsummarygrid',
	store : 'reports.admission.ApplicationSummaryStore',
	border : true,
	cls: 'enqgridsummarycls',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	tbar:['->',{
		xtype: 'splitbutton',
		itemId: 'btnExportToPDFJasper',
		cls: 'CustomToolbarBtnExport',
		iconCls:'export-pdf-icon',
		menu: [{
			text: getAdmissionTranslation('EXPORT_CURRENT_PAGE'),
			itemId: 'exportPDFCurrentPage'
		}]
	},{
		xtype: 'splitbutton',
		itemId: 'btnExportToExcelJasper',
		cls: 'CustomToolbarBtnExport',
		iconCls:'export-excel-icon',
		menu: [{
			text: getAdmissionTranslation('EXPORT_CURRENT_PAGE'),
			itemId: 'exportExcelCurrentPage'
		}]
	}],
	features: [{
		id: 'group',
		ftype: 'groupingsummary',
		groupHeaderTpl: '{name}',
		hideGroupedHeader: false,
		enableGroupingMenu: true
	},{
		ftype: 'summary',
		dock: 'bottom'
	}],	
	columns: [{
		text: getEnquiryTranslation('ACADEMY_LOCATION'),
		flex: 1.41,
		tdCls: 'task',
		dock:'top',
		sortable: true,
		dataIndex: 'programName',
		hideable: false,
		align:'center',
		summaryType: 'count',
		summaryRenderer: function(value, summaryData, dataIndex) {
			var text = "Total";
			if(dataIndex.internalId.indexOf('summary') > 0){
				text = getAdmissionTranslation('GRAND_TOTAL');
			}
			return text;//((value === 0 || value > 1) ?  text + value : text + 1);
		}
	},{
		text: getAdmissionTranslation('TOTAL_APPLICATIONS'),
		flex: 1,
		sortable: true,
		dataIndex: 'totalApplications',
		summaryType: 'sum',
		align:'center',
	},{
		text: getAdmissionTranslation('TOTAL_SUCCESSFUL_APPROVED_APPLICATIONS'),
		flex: 1,
		sortable: true,
		dataIndex: 'totalSuccessFulApplications',
		summaryType: 'sum',
		align:'center',
	},{
		text: getAdmissionTranslation('TOTAL_UNSUCCESSFUL_REJECTED_WITHDRAWN_APPLICATIONS'),
		flex: 1.1,
		sortable: true,
		dataIndex: 'totalUnSuccessFulApplications',
		summaryType: 'sum'
	},{
		text: getAdmissionTranslation('APPLICANT_ASSESSMENT'),
		flex: 1,
		sortable: true,
		dataIndex: 'applicantInAssessment',
		summaryType: 'sum'
	},{
		text: getAdmissionTranslation('CONVERSTION_PERCENTAGE_FROM_LOADS'),
		flex: 1,
		sortable: true,
		dataIndex: 'conversionPercentageLeads',
		align:'center',
		summaryType: 'sum',
		summaryRenderer: function(value, summaryData, data) {
			var totalConv = 0;
			var totalConSuccessFulApplications = data.get('totalConvertedEnq');
			var totalEnquiry = data.get('totalEnquiry');
			if(data.internalId.indexOf('summary') > 0){
				var range = this.getStore().getRange();
				range.forEach(function(obj){
					totalConv = totalConv+obj.get('totalEnquiry');
				});
			} else {
				totalConv = data.get('totalEnquiry');
			}
			if(totalConv!=0){
				var conversionPercentage = (totalConSuccessFulApplications/totalConv)*100;
			}
			if(!isNullOrEmpty(conversionPercentage)){
				return conversionPercentage.toFixed(2) + "%" ;
			} else {
				return '';
			}
		},
		renderer:function(val,rec,e){
			if(!isNullOrEmpty(val)){
				return val.toFixed(2) + "%" ;
			} else {
				return '';
			}
		},
	},{
		text: getAdmissionTranslation('WM_OF_SUCCESSFULL_APPROVED_APPLICATIONS'),
		flex: 1.1,
		sortable: true,
		dataIndex: 'wMofSuccessfulApplications',
		align:'center',
		summaryType: 'sum'
	},{
		text: getAdmissionTranslation('TARGET_FOR_TOTAL_SUCCESSFUL_APPROVED_APPLICATIONS'),
		flex: 1,
		sortable: true,
		dataIndex: 'targetTotalSuccessfullApplications',
		align:'center',
		summaryType: 'sum'
	}, {
		text: getAdmissionTranslation('PER_TARGET_FOR_TOTAL_SUCCESSFUL_APPROVED_APPLICATIONS'),
		flex: 1,
		sortable: true,
		dataIndex: 'percentageTotalApplications',
		align:'center',
		summaryType: 'sum',
		//renderer  : Ext.util.Format.numberRenderer('0.00'),
		renderer:function(val,rec,e){
			if(!isNullOrEmpty(val)){
				return val.toFixed(2) + "%" ;
			} else {
				return '';
			}
		},
		summaryRenderer: function(value, summaryData, data) {
			var totalSuccessFulApplicationcessFulApplications = data.get('totalSuccessFulApplications');
			var targetTotalSuccessfullApplications = data.get('targetTotalSuccessfullApplications');
			if(targetTotalSuccessfullApplications!=0){
				var perOfTargetForAdmissions = (totalSuccessFulApplicationcessFulApplications/targetTotalSuccessfullApplications)*100;
			}
			if(!isNullOrEmpty(perOfTargetForAdmissions)){
				return perOfTargetForAdmissions.toFixed(2) + "%" ;
			} else {
				return '';
			}
		},
	}, {
		text: getAdmissionTranslation('YOY_VARIANCE_TOTAL_APPLICATIONS_TARGET_TO_DATE'),
		flex: 1,
		sortable: true,
		dataIndex: 'yoyvariancetltd',
		align:'center',
		//summaryType: 'sum',
		//renderer  : Ext.util.Format.numberRenderer('0.00'),
		renderer:function(val,rec,e){
			if(!isNullOrEmpty(val)){
				return val.toFixed(2) + "%" ;
			} else {
				return '';
			}
		},
		summaryRenderer: function(value, summaryData, data) {
			var totalYOY = 0;
			var totalSuccessFulApp = data.get('totalSuccessFulApplications');
			var previousTotalApplication = data.get('previousTotalApplications');
			if(data.internalId.indexOf('summary') > 0){
				var range = this.getStore().getRange();
				range.forEach(function(obj){
					totalYOY = totalYOY+obj.get('previousTotalApplications');
				});
			} else {
				totalYOY = data.get('previousTotalApplications');
			}
			if(totalYOY!=0){
				var perOfYOY = ((totalSuccessFulApp-totalYOY)/totalYOY)*100;
			}
			if(!isNullOrEmpty(perOfYOY)){
				return perOfYOY.toFixed(2) + "%" ;
			} else {
				return '';
			}
		}
	},{
		text: getAdmissionTranslation('TOTAL_ENQUIRY'),
		flex: 1,
		sortable: true,
		dataIndex: 'totalEnquiry',
		summaryType: 'sum',
		hideMode:'display'
	},{
		text: getAdmissionTranslation('PREVIOUS_YEAR_TOTAL_APPLICATIONS'),
		flex: 1,
		hidden:true,
		sortable: true,
		dataIndex: 'previousTotalApplications',
		summaryType: 'sum',
		hideMode:'display'
	},{
		text: getAdmissionTranslation('TOTAL_CONVERTED_ENQ'),
		flex: 1,
		sortable: true,
		dataIndex: 'totalConvertedEnq',
		summaryType: 'sum',
		hideMode:'display'
	}]
});