/**
 * @author Harsh.Nagra

 */
Ext.define('Academia.view.reports.admission.dashboard.applicationStaticsGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.applicationstaticsgrid',
    title:getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
    store: 'reports.admission.ApplicationStatisticsByAcademies',
    border: true,
    autoScroll: false,
    refreshStoreData: true,
    frame: false,
    //width : 1300,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
	 features: [{
	        ftype: 'summary',
	        showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
	    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    columns: [{
        header:  '-',
        dataIndex: 'name',
        flex: 1,
        sortable: true,
        summaryRenderer: function(value, summaryData, dataIndex) {
	          return getFeeAndPaymentCommonTranslation('GRAND_TOTAL');
	      }
    },{
        header: 'Count',
        dataIndex: 'count',
        flex: 1,
        sortable: true,
        summaryType: 'sum',
        summaryRenderer: function(val, rec) {
                return val;
        }
    }]
});