/**
 * This view is used for faculty request closure rate 
 * @author Pravin.Surve
 */

Ext.define('Academia.view.reports.faculty.FacultyRequestClosureRateView', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.facultyrequestclosurerateview',
    title: getServiceRequestTranslation('REQUEST_CLOSURE_RATE'),
    cls: 'panelNoSpace',
    autoScroll: true,
    items: [{
        xtype: 'facultydashboardcommonsearchform',
        itemId: 'facultyRequestClosureRateSearchForm'
    }, {
    	xtype: 'form',
    	frame: true,
    	items:[{
            xtype: 'columnchartreport',
            itemId: 'facultyRequestClosureRateChart',
            width: 700,
            minHeight: 500,
            maxHeight: 1000,
            columnWidth: 50,
            columnColor: 'orange',
            store: 'Academia.store.reports.servicerequest.RequestClosureRateStore',
            xAxesNumericField: 'count',
            xAxesNumericTitle: getServiceRequestTranslation('NUMBER_OF_REQUEST'),
            yAxesCategoryField: 'property',
            yAxesCategoryTitle: getServiceRequestTranslation('CLOSED_IN_DAYS')
        }]
    }]
});