/**
 * This view is used for the Extra curr.activity report quick search form.
 * @author Trupti.Paoneker
 */
Ext.define('Academia.view.reports.student.personaldetail.ExtraCurrActivityReportQuickSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.extracurractivityreportquicksearchform',
    frame: false,
    cls:'customSearchPanel', 
    height: '30%',
    layout: 'vbox',
    standardSubmit: false,
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('ADMISSION_NUMBER'),
            name: 'ADMISSION_CODE'
        }, {
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('STUDENT_ID'),
            name: 'STUDENT_CODE'

        },{
            xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('SELECT_NAME'),
            store: 'common.SelectNameComboStore',
            editable: false,
            queryMode: 'local',
            name: 'selectedNameField',
            itemId: 'selectedNameField',
            valueField: 'id',
            displayField: 'value',
            value: 'FIRST_NAME'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('FIRST_NAME'),
            itemId: 'selectedName',
            name: 'FIRST_NAME'
        }, {
            xtype: 'customcombobox',
            name: 'PROGRAM_ID',
            itemId: 'program',
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
            //editable: false,
            valueField: 'id',
            displayField: 'valueCode',
            queryParam:'programName',
            allowBlank: true,
            minChars:3,
			typeAhead:false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection:true,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.ProgramByAcAndLoIdStore');
                    combo.bindStore(store);
                }
            },
               listConfig: {
                   listeners: {
                       beforeshow: function(picker) {
                       picker.minWidth = picker.up('combobox').getSize().width;
                       }
                      },
                       loadingText: getCommonTranslation('SEARCHING'),
                       emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                       getInnerTpl: function() {
                       return '<div class="search-item">' +
                      '{code} / {value}'+
                      '</div>';
                       }
                    }
        }, {
            xtype: 'customcombobox',
            name: 'BATCH_ID',
            itemId: 'batch',
            //queryMode: 'remote',
            fieldLabel: getPersonModuleTranslation('BATCH'),
            disabled:true,
            editable: false,
            displayField: 'value',
            valueField: 'id',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
                    combo.bindStore(store);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            itemId:'period',
            disabled:true,
            editable: false,
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            fieldLabel: getPersonModuleTranslation('PERIOD'),
            name: 'PERIOD_ID',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
                    combo.bindStore(store);
                }
            }
        }/*{
            xtype: 'customcombobox',
            name: 'COURSE_ID',
            itemId: 'course',
            fieldLabel: getPersonModuleTranslation('COURSE'),
            editable: false,
            valueField: 'courseId',
            displayField: 'courseName',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.admission.applications.admissionAndMidTermAdmission.MidTermAdmMainCourseGridStore');
                    combo.bindStore(store);
                }
            }
        }*/, {
            xtype: 'customcombobox',
            name: 'SECTION_ID',
            itemId: 'section',
            fieldLabel: getPersonModuleTranslation('SECTION'),
            editable: false,
            disabled:true,
            /* valueField: 'id',
            displayField: 'value',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.coursetransaction.sectionmanagement.SectionMultiSelect');
                    combo.bindStore(store);
                }
            }*/
            valueField: 'sectionId',
            displayField: 'sectionCode',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.attendance.SectionAndFacultyByPeriodID');
                    combo.bindStore(store);
                }
            }
        },{
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('SPECIFIC_ACTIVITY'),
            name: 'SPECIFIC_ACTIVITY'

        }]
    },  {
        xtype: 'fieldcontainer',
        width: 'auto',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchButtonId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        },{
            xtype: 'button',
            text: getCommonTranslation('CLEAR_SEARCH'),
            itemId: 'clearSearchBtn',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]

    }]

});