/**
 * This view is used for the Siblings report quick search form.
 * @author Trupti.Paoneker
 */
Ext.define('Academia.view.reports.student.personaldetail.SiblingsReportQuickSearchForm', {
	extend: 'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.siblingsreportquicksearchform',
	frame: false,
	cls:'customSearchPanel', 
	height: '30%',
	layout: 'vbox',
	standardSubmit: false,
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 460
		},
		items: [{
			xtype : 'multiselectcombofield',
			name : 'ACADEMY_LOCATION_ID',
			itemId:'academyLocationId',
			autoloadStore: false,
			width: 460,
			fieldLabel : getAdmissionTranslation('ACADEMY_LOCATION'),
			store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
			valueField : 'id',
			displayField : 'value',
			queryParam:'qry',
			minChars:3,
			typeAhead:true,
			matchFieldWidth:true,
			cls:'receiptHeaderMultiselect',
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			style:{
				marginTop:'10px'
			},
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							if(items.length==0)
								Ext.select('.x-boundlist-item').elements[0].hidden = true;
							else {
								try {
									Ext.select('.x-boundlist-item').elements[0].hidden = false;
								} catch(e) {}
							}
				        });
				    }
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}]
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype : 'customcombobox',
			fieldLabel : getEnquiryTranslation('INTAKE_YEAR'),
			name : 'INTAKE_YEAR_ID',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
			width:226,
			forceSelection:true,
            editable: false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.IntakeYearStore');
					combo.bindStore(store)
				}
			}
	 	},{
			xtype: 'customcombobox',
			name:'ADMISSION_ID',
			itemId:'studentId',
			store: 'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameAdmissionCodeBySmartSearch',
			fieldLabel : getCommonTranslation('STUDENT_ADMISSION_ID_CODE_NAME'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			width:460,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value} / {code}' +
					'</div>';
				}
			},
			listeners:{
				afterrender: function(fld){
					var store = fld.getStore();
					var form = fld.up('siblingsreportquicksearchform');
					var academyLocationIdFld = form.down('#academyLocationId');
					
					store.on('beforeload', function(){
						var academyLocationIds = '';
						var academyLocationIdFldValue = academyLocationIdFld.getValue();
						if(!isNullOrEmpty(academyLocationIdFldValue) && (typeof academyLocationIdFldValue == "number" || academyLocationIdFldValue.length && academyLocationIdFldValue[0] != '')){
							if(typeof academyLocationIdFldValue[0] == "object"){
								var alIdsArray = Ext.Array.pluck(Ext.Array.pluck(academyLocationIdFldValue, 'data'),'id');
								academyLocationIds = alIdsArray.join();
							}
							else if(typeof academyLocationIdFldValue == "number"){
								academyLocationIds = academyLocationIdFldValue;
							}
							else{
								academyLocationIds = academyLocationIdFldValue.join();
							}
						}
						store.getProxy().extraParams.academyLocationIds = academyLocationIds;
					});
				}
			}
		}]
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'customcombobox',
			name:'PROGRAM_ID',
			store: 'program.ProgramByGroupIdStore',
			itemId:'program',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'qry',
			minChars:3,
			allowBlank: true,
			matchFieldWidth:true,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+ 
					'</div>';
				}
			}

		},{
			xtype: 'customcombobox',
			name: 'BATCH_ID',
			itemId: 'batch',
			disabled:true,
			fieldLabel: getPersonModuleTranslation('BATCH'),
			editable: false,
			displayField: 'value',
			valueField: 'id',
			listeners: {
				render: function(combo) {
					var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
					combo.bindStore(store);
				}
			}
		},{
			xtype: 'customcombobox',
			itemId:'period',
			disabled:true,
			editable: false,
			displayField: 'value',
			valueField: 'id',
			queryMode: 'local',
			fieldLabel: getPersonModuleTranslation('PERIOD'),
			name: 'PERIOD_ID',
			listeners: {
				render: function(combo) {
					var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
					combo.bindStore(store);
				}
			}
		}]
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'customcombobox',
			name: 'SECTION_ID',
			itemId: 'section',
			disabled:true,
			fieldLabel: getPersonModuleTranslation('SECTION'),
			editable: false,
			valueField: 'sectionId',
			displayField: 'sectionCode',
			listeners: {
				render: function(combo) {
					var store = Ext.create('Academia.store.attendance.SectionAndFacultyByPeriodID');
					combo.bindStore(store);
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'SIBLING_ID',
			itemId:'sibling',
			hidden:false,
			fieldLabel: getFeeAndPaymentCommonTranslation('SIBLING_ID_NAME'),
			store: 'feeandpayment.managebill.Student',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode}/{studentName}' +
					'</div>';
				}
			}
		}]
	}, {
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchButtonId',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('CLEAR_SEARCH'),
			itemId: 'clearSearchBtn',
			buttonAlign: 'right',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
			//formBind : true
		}]

	}]

});