/**
 * @author Pritam.Patil
 * This is used for student Exit quick search Form
 */
Ext.define('Academia.view.reports.student.personaldetail.StudentExitSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.studentexitsearchform',
    frame: true,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },	
        items: [{
            xtype: 'multiselectcombofield',
            name: 'programs',
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
            labelAlign: 'top',
            store: 'Academia.store.common.ProgramsByAcademyIdLocationId',
            displayField: 'valueCode',
            valueField: 'id',
          //  queryMode: 'local',
           // autoload: false,
            width: 200,
            itemId: 'programComboField',
            queryParam:'qry',
            minChars:3,
			typeAhead:true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection:true,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.ProgramsByAcademyIdLocationId');
                    combo.bindStore(store);
                }
            }, listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                    picker.minWidth = picker.up('combobox').getSize().width;
                    }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function() {
                    return '<div class="search-item">' +
                    '{code} / {value}'+
                    '</div>';
                    }
                    }
        }, {
            xtype: 'multiselectcombofield',
            name: 'batches',
            fieldLabel: getServiceRequestTranslation('BATCH'),
            labelAlign: 'top',
            store: 'Academia.store.common.BatchesByProgramId',
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            width: 200,
            itemId: 'batchComboField'
        },{
            xtype: 'multiselectcombofield',
            name: 'sections',
            fieldLabel: getServiceRequestTranslation('SECTION'),
            store: 'coursetransaction.sectionmanagement.SectionMultiSelect',
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            width: 200,
            itemId: 'sectionComboField'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'multiselectcombofield',
            name: 'academyIds',
            autoloadStore : false,
            inputHeight: '30px',
            fieldLabel: getCommonTranslation('ACADAMY'),
            store: 'reports.student.ExitAcademyStore',
            displayField: 'value',
            valueField: 'id',
            editable: false,
            autoload: false,
            height: '30px',
            queryMode: 'local',
            itemId: 'academyCombo'
        }, {
            xtype: 'multiselectcombofield',
            name: 'locationsId',
            inputHeight: '30px',
            fieldLabel: getCommonTranslation('LOCATION'),
            store: 'reports.student.ExitLocationStore',
            displayField: 'value',
            autoloadStore : false,
            valueField: 'id',
            height: '30px',
            autoload: false,
            editable: false,
            queryMode: 'local',
            itemId: 'locationCombo'
        }, {
            xtype: 'customcombobox',
            name: 'entityName',
            itemId: 'typeOfExitId',
            fieldLabel: getServiceRequestTranslation('TYPE_OF_EXIT'),
            displayField: 'value',
            valueField: 'id',
            allowBlank: false,
            queryMode: 'local',
            // autoload: false,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.reports.student.TypeOfExits');
                    combo.bindStore(store);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: 'isReasonFilter',
            itemId: 'reasonForExitId',
            fieldLabel: getServiceRequestTranslation('REASON_FOR_EXIT'),
            displayField: 'value',
            valueField: 'id',
           // queryMode: 'local',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.reports.student.ReasonForExits');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'datefield',
            itemId: 'startDate',
            fieldLabel: getServiceRequestTranslation('START_DATE'),
            name: 'startDate',
          //  vtype: 'daterange',
           // endDateField: 'endDate',
           // maxValue: new Date(),
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            editable: false
        }, {
            xtype: 'datefield',
            name: 'endDate',
            itemId: 'endDate',
            fieldLabel: getServiceRequestTranslation('END_DATE'),
           // vtype: 'daterange',
            //startDateField: 'startDate',
          //  maxValue: new Date(),
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            editable: false
        }]
    }, {
        xtype: 'fieldcontainer',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchButtonId',
            buttonAlign: 'left',
            disabled : true,
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});