/**
 * Bhartendu Bhaskar
 */
Ext.define('Academia.view.resourceavailability.ResourceAvailabilityReportFilter', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.resourceavailabilityreportfilter',
    plugins: "formlabelrequired",
    autoScroll: true,
    frame: false,
    cls: 'customSearchPanel',
    layout: 'vbox',
    method: 'POST',
    standardSubmit: false,
    items: [{
        xtype: 'fieldcontainer',
        defaults: {
            labelAlign: 'top'
        },
        items: [{
            xtype: 'radiogroup',
            itemId: 'selectionTypeItemId',
            defaults: {
                flex: 1
            },
            items: [{
                boxLabel: getProgramandcourseTranslation('MASTER_TIME_TABLE'),
                name: 'resourceViewType',
                inputValue: 'masterTimetable',
                checked: true
            }, {
                boxLabel: getProgramandcourseTranslation('DETAIL_TIME_TABLE'),
                name: 'resourceViewType',
                inputValue: 'detailedTimetable',
            }]
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
                xtype: 'multiselectcombofield',
                name: 'academyLocationId',
                itemId: 'academyLocationItemId',
                fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
                autoloadStore: false,
                width: 460,
                store: 'facilitiesresources.resourcebooking.AcademyLocationListByUserStore',
                cls:'multiBrandCampusCls',
                displayField: 'value',
                valueField: 'id',
                allowBlank: false,
                queryParam: 'nameOrCode',
                minChars: 3,
                typeAhead: true,
                triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
                enableKeyEvents: 'true',
                hideTrigger: false,
                forceSelection: true,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                listConfig: {
                    listeners: {
                        beforeshow: function(picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;
                        },
                        afterRender: function(combo) {
                            combo.getStore().on("load", function(store, items) {
                                if (items.length == 0)
                                    Ext.select('.x-boundlist-item').elements[0].hidden = true;
                                else
                                    Ext.select('.x-boundlist-item').elements[0].hidden = false;
                            });
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function() {
                        return '<div class="search-item">' +
                            '{code}' +
                            '</div>';
                    }
                }
            }]
    }, {
        xtype: 'fieldcontainer',
        defaults: {
            labelAlign: 'top'
        },
        items: [{
            xtype: 'radiogroup',
            disabled: true,
            itemId: 'roomFacultyTypeItemId',
            defaults: {
                flex: 1
            },
            items: [{
                boxLabel: getCommonTranslation('ROOM'),
                name: 'roomFacultyType',
                inputValue: 'room',
                checked: true
            }, {
                boxLabel: getCommonTranslation('USER'),
                name: 'roomFacultyType',
                inputValue: 'faculty'
            }]
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'roomId',
            itemId: 'roomItemId',
            fieldLabel: getCourseTxCommonTranslation('Room'),
            store: 'resourceutilization.ResourcesStore',
            displayField: 'code',
            valueField: 'id',
            queryParam: 'name',
            minChars: 3,
            disabled: true,
            typeAhead: true,
            queryMode: 'remote',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    },
                    afterRender: function(combo) {
                        combo.getStore().on("load", function(store, items) {
                            if (items.length == 0)
                                Ext.select('.x-boundlist-item').elements[0].hidden = true;
                            else
                                Ext.select('.x-boundlist-item').elements[0].hidden = false;
                        });
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{code}' +
                        '</div>';
                }
            }
        }, {
			xtype: 'multiselectcombofield',
			name: 'faculty',
			itemId: 'facultyItemId',
			fieldLabel: getCommonTranslation('USER'),
			autoloadStore: false,
			width: 226,
			store : 'program.programDetails.programBatches.courseParameter.FacultyCombo',
			displayField : 'valueCode',
			valueField : 'id',
			queryParam:'nameOrCode',
			minChars:3,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			queryMode:'remote',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							if(items.length==0)
								Ext.select('.x-boundlist-item').elements[0].hidden = true;
							else
								Ext.select('.x-boundlist-item').elements[0].hidden = false;
						});
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'weekDayId',
            itemId: 'weekDayItemId',
            fieldLabel: getProgramandcourseTranslation('WEEKDAY'),
            store: 'transport.serviceRoute.WeekDays',
            displayField: 'value',
            valueField: 'id',
            typeAhead: true,
            disabled: true,
            editable: false,
            forceSelection: true
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getProgramandcourseTranslation('FROM_DATE'),
            name: 'fromDate',
            itemId: 'fromDateItemId',
            format: CONSTANTS.DATE_FORMAT,
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            endDateField: 'toDateItemId',
            disabled: true,
            hidden: true,
            allowBlank: false,
            vtype: 'daterange',
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        }, {
            xtype: 'datefield',
            fieldLabel: getProgramandcourseTranslation('TO_DATE'),
            name: 'toDate',
            itemId: 'toDateItemId',
            format: CONSTANTS.DATE_FORMAT,
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            startDateField: 'fromDateItemId',
            disabled: true,
            hidden: true,
            allowBlank: false,
            vtype: 'daterange',
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        }]
    },{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype : 'timefield',
			name : 'fromTime',		
			itemId : 'fromTimeItemId',			
			fieldLabel:getProgramandcourseTranslation('START_TIME'),
			format:'g:i A',
			submitFormat : CONSTANTS.DISPLAY_TIME_FORMAT,
			vtype: 'timerange',
			endTimeField : 'toTimeItemId',
			listeners: {
				render: function(field) {
					return timeFormatRender(field);
				}
			}
		},{
			xtype : 'timefield',
			name : 'toTime',		
			itemId : 'toTimeItemId',			
			fieldLabel:getProgramandcourseTranslation('END_TIME'),
			format:'g:i A',
			submitFormat : CONSTANTS.DISPLAY_TIME_FORMAT,
			vtype: 'timerange',
			startTimeField :'fromTimeItemId',
			listeners: {
				render: function(field) {
					return timeFormatRender(field);
				}
			}
		}]
	}, {
        xtype: 'fieldcontainer',
        width: '100%',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchBtnResourceAvailabilityReportFilterItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCourseTxCommonTranslation('RESET'),
            itemId: 'resetBtnResourceAvailabilityReportFilterItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});