/**
 * @author raghavendra soni
 */
Ext.define('Academia.view.salesandadmissionreport.SalesAndAdmissionReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.salesandadmissionreportgrid',
	store: 'reports.salesandadmissionreport.SalesAndAdmissionReportListStore',
	title: getAdmissionTranslation('SALES_AND_ADMISSION_REPORT_GRID'),
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	}/*,
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store :  'reports.salesandadmissionreport.SalesAndAdmissionReportListStore',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}]*/,
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);

		grid.tbar=['->',{
			xtype: 'splitbutton',
			itemId: 'btnExportToPDFJasper',
			cls: 'CustomToolbarBtnExport',
			iconCls:'export-pdf-icon',
			menu: [{
				text: getAdmissionTranslation('EXPORT_CURRENT_PAGE'),
				itemId: 'exportPDFCurrentPage'
			}]
		},{
			xtype: 'splitbutton',
			itemId: 'btnExportToExcelJasper',
			cls: 'CustomToolbarBtnExport',
			iconCls:'export-excel-icon',
			menu: [{
				text: getAdmissionTranslation('EXPORT_CURRENT_PAGE'),
				itemId: 'exportExcelCurrentPage'
			}]
		}];

		grid.columns= [{
			header : getCommonTranslation('ACADEMIESTABTEXT'),
			dataIndex : 'academyName',
			flex : .2,
			sortable: false,
			renderer:function(value,meta,record){
				return '<span style="float: left;font-weight: bold;">'+value+'</span>';                        
			}
		},{
			header : getCommonTranslation('INTAKE_YEAR'),
			//dataIndex : 'candidateId',
			sortable: false,
			flex : .2
		},{
			header : getCommonTranslation('REPORT_HEADER'),
			//dataIndex : 'formNo',
			sortable: false,
			flex : .2
		},{
			header : getCommonTranslation('LEADS'),
			//dataIndex : 'name',
			sortable: false,
			flex : .2
		}, {
			header :getCommonTranslation('APPLICATIONS'),
			//dataIndex : 'programName',
			sortable: false,
			flex : .2
		}, {
			header :getCommonTranslation('APPROVED_APPLICATIONS'),
			//dataIndex : 'programName',
			sortable: false,
			flex : .2
		}, {
			header :getCommonTranslation('ENROLMENTS'),
			//dataIndex : 'programName',
			sortable: false,
    		flex : .2
		}];
		this.callParent(arguments);   
	},
	plugins: [{
		ptype: 'overriderowexpander',
		pluginId: 'salesAndAdmissionReportRowExpander',
		rowBodyTpl: ['<table style="width:100%;">',
			'<tr>',
			'<td style="width:14%;text-align:left;">&nbsp;</td>',
			'<td style="width:86%;text-align:left;" colspan="6">',
			'<table style="border:1px solid #666; width:100%;border-collapse: collapse;" border="1">',
			'<tr>',
			'<td style="padding:5px;width:16.66%;text-align:left;font-weight:bold;" colspan="2">{currIntakeYr}</td>',
			'<td style="padding:5px;width:16.66%;text-align:left;">{currLeads}</td>',
			'<td style="padding:5px;width:16.66%;text-align:left;">{currAp}</td>',
			'<td style="padding:5px;width:16.66%;text-align:left;">{currAprvd_ap}</td>',
			'<td style="padding:5px;width:16.66%;text-align:left;">{currEnrol}</td>',
			'</tr>',
			'<tr>',
			'<td style="padding:5px;width:16.66%;text-align:left;">&nbsp;</td>',
			'<td style="padding:5px;width:16.66%;text-align:left;">% of Leads</td>',
			'<td style="padding:5px;width:16.66%;text-align:left;">&nbsp;</td>', 
			'<td style="padding:5px;width:16.66%;text-align:left;">{perc_leads_ap}</td>', 
			'<td style="padding:5px;width:16.66%;text-align:left;">{perc_leads_aprvd_ap}</td>', 
			'<td style="padding:5px;width:16.66%;text-align:left;">{perc_leads_enrol}</td>',
			'</tr>',
			'<tr>',
			'<td style="padding:5px;width:16.66%;text-align:left;">&nbsp;</td>',
			'<td style="padding:5px;width:16.66%;text-align:left;">% of Prior Stage</td>',
			'<td style="padding:5px;width:16.66%;text-align:left;">&nbsp;</td>', 
			'<td style="padding:5px;width:16.66%;text-align:left;">{perc_prev_stg_ap}</td>', 
			'<td style="padding:5px;width:16.66%;text-align:left;">{perc_prev_stg_aprvd_ap}</td>', 
			'<td style="padding:5px;width:16.66%;text-align:left;">{perc_prev_stg_enrol}</td>',
			'</tr>',
			'</table>',
			'</td>',
			'</tr>',
			'<tr>',
			'<td style="width:100%;text-align:left;" colspan="7">&nbsp;</td>',
			'</tr>',
			'<tr>',
			'<td style="width:14%;text-align:left;">&nbsp;</td>',
			'<td style="width:86%;text-align:left;" colspan="6">',
			'<table style="border:1px solid #666; width:100%;border-collapse: collapse;" border="1">',
			'<tr>',
			'<td style="padding:5px;width:16.66%;text-align:left;font-weight:bold;" colspan="2">{prevIntakeYr}</td>',
			'<td style="padding:5px;width:16.66%;text-align:left;">{prevLeads}</td>',
			'<td style="padding:5px;width:16.66%;text-align:left;">{prevAp}</td>',
			'<td style="padding:5px;width:16.66%;text-align:left;">{prevAprvdAp}</td>',
			'<td style="padding:5px;width:16.66%;text-align:left;">{prevEnrol}</td>',
			'</tr>',
			'<tr>',
			'<td style="padding:5px;width:16.66%;text-align:left;">&nbsp;</td>',
			'<td style="padding:5px;width:16.66%;text-align:left;">% of Leads</td>',
			'<td style="padding:5px;width:16.66%;text-align:left;">&nbsp;</td>', 
			'<td style="padding:5px;width:16.66%;text-align:left;">{prev_perc_leads_ap}</td>', 
			'<td style="padding:5px;width:16.66%;text-align:left;">{prev_perc_leads_aprvd_ap}</td>', 
			'<td style="padding:5px;width:16.66%;text-align:left;">{prev_perc_leads_enrol}</td>',
			'</tr>',
			'<tr>',
			'<td style="padding:5px;width:16.66%;text-align:left;">&nbsp;</td>',
			'<td style="padding:5px;width:16.66%;text-align:left;">% of Prior Stage</td>',
			'<td style="padding:5px;width:16.66%;text-align:left;">&nbsp;</td>', 
			'<td style="padding:5px;width:16.66%;text-align:left;">{prev_perc_prev_stg_ap}</td>', 
			'<td style="padding:5px;width:16.66%;text-align:left;">{prev_perc_prev_stg_aprvd_ap}</td>', 
			'<td style="padding:5px;width:16.66%;text-align:left;">{prev_perc_prev_stg_enrol}</td>',
			'</tr>',
			'</table>',
			'</td>',
			'</tr>',
			'<tr>',
			'<td style="width:100%;text-align:left;" colspan="7">&nbsp;</td>',
			'</tr>',
			'<tr>',
			'<td style="width:14%;text-align:left;">&nbsp;</td>',
			'<td style="width:86%;text-align:left;" colspan="6">',
			'<table style="border:1px solid #666; width:100%;border-collapse: collapse;" border="1">',
			'<tr>',
			'<td style="padding:5px;width:16.66%;text-align:left;">&nbsp;</td>',
			'<td style="padding:5px;width:16.66%;text-align:left;">Absolute # Change</td>',
			'<td style="padding:5px;width:16.66%;text-align:left;">{abs_chng_leads}</td>', 
			'<td style="padding:5px;width:16.66%;text-align:left;">{abs_chng_ap}</td>', 
			'<td style="padding:5px;width:16.66%;text-align:left;">{abs_chng_aprvd_ap}</td>', 
			'<td style="padding:5px;width:16.66%;text-align:left;">{abs_chng_enrol}</td>',
			'</tr>',
			'<tr>',
			'<td style="padding:5px;width:16.66%;text-align:left;">&nbsp;</td>',
			'<td style="padding:5px;width:16.66%;text-align:left;">Absolute % Change</td>',
			'<td style="padding:5px;width:16.66%;text-align:left;">{abs_perc_chng_leads}</td>', 
			'<td style="padding:5px;width:16.66%;text-align:left;">{abs_perc_chng_ap}</td>', 
			'<td style="padding:5px;width:16.66%;text-align:left;">{abs_perc_chng_aprvd_ap}</td>', 
			'<td style="padding:5px;width:16.66%;text-align:left;">{abs_perc_chng_enrol}</td>',
			'</tr>',
			'</table>',
			'</td>',
			'</tr>',
			'</table>']
	}]
});

Ext.define("App.OverridePluginRowExpander", {
	alias: "plugin.overriderowexpander",
	extend: "Ext.grid.plugin.RowExpander",
	
	isCollapsed: function (rowIdx) {
		var me = this,
		rowNode = me.view.getNode(rowIdx),
		row = Ext.fly(rowNode, '_rowExpander');
		return row.hasCls(me.rowCollapsedCls)
	},

	expand: function (rowIdx) {
		if (this.isCollapsed(rowIdx) == true) {
			this.toggleRow(rowIdx, this.grid.getStore().getAt(rowIdx));
		}
	},

	expandAll: function () {
		for (i = 0; i < this.grid.getStore().data.length; i++) {
			this.expand(i);
		}
	}
});