/**
 * sumit sharma 
 */
/**
 * @author Vishal Joshi
 */
Ext.define('Academia.view.scholarship.poetmaster.PoetMasterGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.poetmastergrid',
	store: 'poet.PoetMasterListGridStore',
	title: getCommonTranslation('POET_MASTER_LIST'), 
	border: true,
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'poetmasterstructure':1
		}
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			//store : 'sgappointment.sgappointment.SGAppointmentGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {

		var grid=this; 
		var store =Ext.create('Academia.store.poet.PoetMasterListGridStore');
		//var store=Ext.create('Academia.store.sgappointment.sgappointment.SGAppointmentGridStore');
		grid.addExportToolBarItems(grid);
		Ext.apply(this, {
			store: store        
		});

		this.callParent(arguments);
		var custompagingtoolbar=grid.down('custompagingtoolbar');
		if(custompagingtoolbar){
			custompagingtoolbar.bindStore(store);        	
		}     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH,
		disabled: true
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation("VIEW"),
		iconCls: 'view-icon',
		disabled: true
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH,
		disabled: true
	}],
	columns: [{
			header:  getCommonTranslation('PROJECT_NUMBER'), 
			dataIndex: 'projectNumber',
			flex:.1,
			sortable:true
		},{
			header:  getCommonTranslation('PROJECT_NAME'), 
			dataIndex: 'projectName',
			flex:.1,
			sortable:true
		},{
			header:  getCommonTranslation('PROJECT_ID'), 
			dataIndex: 'projectId', 
			flex:.1,
			sortable:true
		},{
			header:  getCommonTranslation('POET_FEE_HEAD'), 
			dataIndex: 'feeHeadName', 
			flex:.1,
			sortable:true,
			/*renderer:function(date) {
				return dateRender(date);
			}*/
		}]
});

