/**
 * @author Vyabha Thakur
 */
Ext.define('Academia.view.scholarship.scholarshipmaster.IntellimaliGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.intellimaligrid',
	//store: 'scholarships.IntellimaliGridStore',
	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	border: true,
	reserveScrollbar:true,
	refreshStoreData:true,
	frame:false,
	margin:0,
	isGridConfigurable: true,
	selType:'checkboxmodel',
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'intellimaliscreen': 1
		}
	},
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'scholarships.IntellimaliGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		disabled: true
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon',
		disabled: true
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		disabled:true
	} ],
	columns: [{
		header:  getCommonTranslation('SEQUENCE_NUM'),
		dataIndex: 'sequenceNumber',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('STUDENT_ID_NAME'),
		dataIndex: 'student',
		flex:1,
		sortable:true,
		renderer:function(value,metadata,record){
			if(!isNullOrEmpty(record)){
				return record.data.student.code+'/'+record.data.student.value;
			}else{
				return  '';
			}
		}
	},{
		header:  getCommonTranslation('ACCOUNTING_YEAR'),
		dataIndex: 'accountingYear',
		flex:1,
		sortable:true,
		renderer:function(value,metadata,record){
			if(!isNullOrEmpty(record)){
				return record.data.accountingYear.value;
			}else{
				return  '';
			}
		}
	},{
		header:  getCommonTranslation('INSTITUTE'),
		dataIndex: 'instituteCSM',
		flex:1,
		sortable:true,
		renderer:function(value,metadata,record){
			if(!isNullOrEmpty(record)){
				return record.data.instituteCSM.code;
			}else{
				return  '';
			}
		}
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'program',
		flex:1,
		sortable:true,
		renderer:function(value,metadata,record){
			if(!isNullOrEmpty(record)){
				return record.data.program.code+'/'+record.data.program.value;
			}else{
				return  '';
			}
		}
	},{
		header:  getCommonTranslation('SCHOLARSHIP_ID_NAME'),
		flex:1.5,
		dataIndex: 'scholarship',
		sortable:true,
		renderer:function(value,metadata,record){
			if(!isNullOrEmpty(value)){
				return value.code+'/'+value.value;
			}else{
				return '';
			}
		}
	},{
		header:  getCommonTranslation('FUND_ALLOCATION'),
		flex:1,
		dataIndex: 'fundAllocation',
		sortable:false 
	},{
		header:  getCommonTranslation('TRANSACTION_TYPE'),
		flex:1,
		sortable:false,
		dataIndex: 'transactionType'
			
	},
	{
		header:  getCommonTranslation('ALLOWANCE_PROPOSED'),
		flex:1,
		dataIndex: 'allowanceProposed',
		sortable:true,
		renderer:function(value,metadata,record){
			if(!isNullOrEmpty(value)){
				return value.value;
			}else{
				return '';
			}
		}
		
	},
	{
		header:  getCommonTranslation('CREATED_BY'),
		flex:1,
		dataIndex: 'createdBy',
		sortable:true,
		renderer:function(value,metadata,record){
			if(!isNullOrEmpty(value)){
				return value.code+'/'+value.value;
			}else{
				return '';
			}
		}
	},
	{
		header:  getCommonTranslation('AMOUNT'),
		flex:1,
		dataIndex: 'totalAmount',
		renderer: function (value) {
            return Ext.util.Format.number(value, '0.00'); // Format to 2 decimal places
        },
		sortable:true
	},{
		header:  getCommonTranslation('TRANSACTION_DATE'),
		flex:1,
		dataIndex: 'transactionDate',
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	},
	{
		header:  getCommonTranslation('STATUS'),
		flex:1,
		sortable:true,
		dataIndex: 'transactionStatus',
		renderer:function(value,meta,record){
			if(value=="PROCESSED"){
				return "Processed"
			}else if(value == "PENDING"){
				return "Pending";
			}else {
				return "Pending";
			}
		}
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.scholarships.IntellimaliGridStore');
	}
});