/**
 * @author priyanshi sharma
 *  
 */
Ext.define('Academia.view.scholarshipRequest.ExecutionDetailsScholarshipForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.executiondetailsscholarshipform',
    title : getCommonTranslation('EXECUTION_DETAIL'),
    collapsible: true,
    frame : true,
    defaults:{
    	    	width:'100%'
    	   },
      layout:'vbox',
    style :{
    	marginLeft : '16px',
    },
    autoScroll: true,
			items : [{
				xtype: 'fieldcontainer',
				cls:'hideTotalRecord',
				items : [{
		        	xtype:'grid',
		        	itemId:'executionGrid',
		        	border: true,
					hidden:true,
					cls:'folloupGridCls',
					viewConfig: {
						stripeRows: CONSTANTS.STRIPEROWS
					},
		        	store: {
		                fields: ['raiseRequestReviewerName', 'executionDate', 'reviewerRequestStatus', 'followUpRemark'],
		                autoLoad: false,
		            	proxy:{
		            	type:'rest',
		            		api:{
		            		    read:SERVERURL.PATH_GET_SCHOLARSHIPOFFICER_EXECUTION_DETAIL
		            		}
		            	}
		            },
		        	columns: [
		        	    {
		        	    	header:  getCommonTranslation('REVIEWED_BY'),
		        			dataIndex:'raiseRequestReviewerName',
		        			flex:.1,
		        			sortable:true,
		        	    },
		        	    {
		        	    	header:  getCommonTranslation('REVIEW_DATE'),
		        			dataIndex:'executionDate',
		        			flex:.1,
		        			sortable:true,
		        			renderer: function(value,metaData,record) {
		        				if(!Ext.isEmpty(value)) {
		        					return dateRender(value);
		        				}
		        				return value
		        			}
		        	    },
		        	    {
		        	    	header:  getCommonTranslation('STATUS'),
		        			dataIndex:'reviewerRequestStatus',
		        			flex:.1,
		        			sortable:true,
		        			renderer:function(value,meta,record){
		        				if(!isNullOrEmpty(value)) {
		        					switch(value) {
		        					  case 'ASSIGNED':
		        						  return getCommonTranslation("ASSIGNED_TO_LINE_MANAGER");
		        					    break;
		        					  case 'APPROVED':
		        						  return getCommonTranslation("APPROVED_BY_LINE_MANAGER");
		        					    break;
		        					  case 'REASSIGNED':
		        						  return getCommonTranslation("RE_ASSIGNED_TO_ADMIN");
		        					    break;
		        					  case 'REJECTED':
		        					  case 'REJECTED_BO':
		        						  return getCommonTranslation("REJECTED");
		        					    break;
		        					  case 'CLOSED':
		        						  return getCommonTranslation("AWARD_ACTIVATION_PENDING");
		        					    break;
		        					  case 'RESUBMITTED':
		        						  return getCommonTranslation("RE_ASSIGNED_TO_ADMIN");
		        					    break;
		        					  default:
		        						  break;
		        					}
		        					
		        				} 
		        				return value;
		        			} 
		        	    },
		        	    {
		        	    	header:  getFeeAndPaymentCommonTranslation('REMARK'),
		        			dataIndex:'followUpRemark',
		        			flex:.1,
		        			sortable:true,
		    				maxLength:1000
		        	    }
		        	]
		        }]
			},{
				xtype: 'fieldcontainer',
		        layout: {
		            type: 'hbox'
		        },
		        defaults: {
		            width: 226,
		            labelAlign: 'top'
		        },
				items : [{
		        	xtype: 'displayfield',
		        	fieldLabel: getCommonTranslation('USER_NAME'),
		        	itemId: 'executionUserName',
		        	name: 'executionUserName',
				},{
		        	xtype: 'datefield',
		        	fieldLabel: getCommonTranslation('REQUEST_EXECUTED_ON'),
		        	itemId: 'executionReqExecutedOn',
		        	name: 'executionReqExecutedOn',
		        	editable: false,
		        	hideTrigger:true,
		        	listeners: {
		        		render: function(field) {
		        			field = dateFormatRender(field);						
		        			field.setValue(new Date());
		        		}
		        	},
				}]
			},{
				xtype: 'fieldcontainer',
		        layout: {
		        	width: 226,
		        },
		        defaults: {
					   labelAlign: 'top',
					   width: 360,
			        },
		        items : [{
		        	xtype:'textarea',
		        	fieldLabel : getCommonTranslation('FOLLOW_UP_REMARKS'),
		        	itemId: 'executionFollowUpRemarks',
		        	name:'executionFollowUpRemarks',
					maxLength:1000,
					fieldStyle: 'border: 1px solid #d9d9d9 !important;'
		        }]
			},{
				xtype: 'fieldcontainer',
				itemId:'executionDeclarationContainerId',
				hidden:true,
		        layout: {
		            type: 'hbox'
		        },
		        items : [{
		        	xtype:'checkbox',
		        	itemId: 'executionDeclaration',
		        	name:'executionDeclaration',
		        },{
		        	xtype:'displayfield',
		        	itemId: 'executionDeclarationText',
		        	name:'executionDeclarationText',
		        	width: 900,
		        	cls:'declarationFieldCls',
		        	value:getCommonTranslation('DECLARATION_FOR_SCHOLARSHIP_OFFICER_1')+'<br><br>'+getCommonTranslation('DECLARATION_FOR_SCHOLARSHIP_OFFICER_2'),
		        }]
			}]
});