/**
 * @author Sandeep.Pal
 */
Ext.define('Academia.view.servicerequest.StudentPortalStudentRequestGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentportalstudentrequestgrid',
	store: 'servicerequest.studentservicerequest.StudentPortalStudentRequestStore',
	title: getServiceRequestTranslation('ALL_REQUEST'),
	border: true,
	refreshStoreData:true,
	//isGridConfigurable: true,
	//enableColumnHide: false,
	frame: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	tbar: [{
		xtype: 'button',
		itemId: 'raiseRequestBtn',
		text: getCommonTranslation('RAISE_REQUEST'),
		tooltip: getCommonTranslation('RAISE_REQUEST')
	},{
		xtype: 'button',
		itemId: 'uploadDocumentBtn',
		text: getCommonTranslation('UPLOAD_DOCUMENTS'),
		tooltip: getCommonTranslation('UPLOAD_DOCUMENTS'),
		disabled:true
	},{
		xtype: 'button',
        itemId: 'quickCommentToStudentId',
        disabled: true,
        text: getFeeAndPaymentCommonTranslation('QUICK_COMMENT'),
        tooltip: getFeeAndPaymentCommonTranslation('QUICK_COMMENT')
	}],
	dockedItems: [{
		xtype: 'toolbar',
		dock: 'bottom',
		itemId : 'dockedItemId',
		items: [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store: 'servicerequest.studentservicerequest.StudentPortalStudentRequestStore',
			emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo: true
		}]
	}],
	initComponent: function() {
		var grid = this;
		grid.addExportToolBarItems(grid, true);
		this.callParent(arguments);
	},
	columns: [{
		header: getCommonTranslation('REQUEST_ID'),
		dataIndex: 'requestId',
		flex: 1,
		sortable: true,
		renderer : function(value){
			if(value){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header: getCommonTranslation('REQUEST_BY'),
		dataIndex: 'requestBy',
		flex: 1,
		sortable: true
	},{
		header: getCommonTranslation('REQUESTER_NAME'),
		dataIndex: 'requesterName',
		flex: 1,
		sortable: true
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('SECTION'),
		dataIndex: 'sectionCode',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('REQUEST_CATEGORY'),
		dataIndex: 'REQUEST_CATEGORY',
		flex:1,
		sortable:true
	}, {
		header: getCommonTranslation('REQUEST_TYPE'),
		dataIndex: 'REQUEST_TYPE',
		flex: 1,
		sortable: true
	}, {
		header: getCommonTranslation('REQUEST_DATE'),
		dataIndex: 'requestDate',
		flex: 1,
		sortable: true,
		renderer:function(value) {
			return dateRender(value);
		}
	}, {
		header: getCommonTranslation('REQUEST_ASSIGNED_TO'),
		dataIndex: 'requestAssignedTo',
		flex: 1,
		sortable: true
	}, {
		header: getCommonTranslation('SLA_DAYS'),
		dataIndex: 'sla',
		flex: 1,
		sortable: true
	}, {
		header: getCommonTranslation('SERVICE_REQUEST_STATUS'),
		dataIndex: 'serviceRequestStatus',
		flex: 1,
		sortable: true
	}, {
		header: getCommonTranslation('CANCELLATION_REASON'),
		dataIndex: 'cancellationReason',
		flex: 1,
		sortable: true,
		hidden:true
	},{
        header: getCommonTranslation("APPLICATION_FORM"),
        dataIndex: "applicationForm",
        flex: 1,
        sortable: true,
        renderer: function(c) {
            if (c) {
                return '<a href="#">' + c + "</a>"
            } else {
                return c
            }
        }
    }, {
        header: getCommonTranslation("APPROVAL_LETTER"),
        dataIndex: "approvalLetter",
        flex: 1,
        sortable: true,
        renderer: function(c) {
            if (c) {
                return '<a href="#">' + c + "</a>"
            } else {
                return c
            }
        }
    }]
});