/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.servicerequest.infirmary.InfirmaryDetailDocumentGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.infirmarydetaildocumentgrid',
    border: true,
    autoScroll: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    columns: [{
        header: getCommonTranslation('DOCMENT_NAME'),
        dataIndex: 'documentName',
        flex: 1,
        sortable:false,
        renderer: function(value, rec) {
            var id = rec.record.data.id;
            if (id != "" && id != undefined) {
                return '<a href="#">' + value + '</a>';
            } else {
                return value;
            }
        }
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.servicerequest.infirmary.InfirmaryDetailDocumentStore');
    }
});