/**
 * @author ravi.patidar
 */
Ext.define('Academia.view.servicerequest.infirmary.InfirmaryManageEntryForm', {   
	extend : 'Ext.form.Panel',
	alias : 'widget.infirmarymanageentryform',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	style: {
		marginLeft: '0px !important',
	},
	plugins : "formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
	            xtype: 'customcombobox',
				fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION'),
//				translationKey : 'ACADEMY_LOCATION',
	            name: 'ACADEMY_LOCATION_ID',
	            itemId:'academy_loc_infirmarycombo',
	            //editable: false,
	            store: 'user.UserAcademyLocationStore',
	            displayField: 'value',
	            valueField: 'id',
	            width:226,
	            typeAhead : true,
	            forceSelection:true,
	            hideTrigger:false,
	            queryParam:'qry',
	            //triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	            //queryMode: 'local',
	    	    triggerAction: 'all',
	    	    //anyMatch : true,
	            minChars:3,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{value}'  +
		                    '</div>';
		                }
		            }
	        },{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('FROM_DATE'),
				name : 'from_date_inmry',
				itemId : 'from_date_inmry',
				//--submitFormat: CONSTANTS.DISPLAY_TIME_FORMAT,
				endDateField : 'to_date_inmry',
				allowBlank:false,
				listeners: {
					render: function(field) {
						var toDay = new Date();  
						field = dateFormatRender(field);	
						field.setValue(new Date(new Date().setDate(toDay.getDate() - 30)));
					}
				},
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype : 'daterange'
			},{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('TO_DATE'),
				name : 'to_date_inmry',
				itemId : 'to_date_inmry',
				allowBlank:false,
				//--submitFormat: CONSTANTS.DISPLAY_TIME_FORMAT,
				startDateField : 'from_date_inmry',
				listeners: {
					render: function(field) {
					field = dateFormatRender(field);	
					field.setValue(new Date());
					}
				},
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype : 'daterange'
			}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name:'USER_TYPE_ID',
			itemId:'user_type_infirmarycombo',
			store:Ext.create('Academia.store.userGroup.AllUserTypeStore'),
			fieldLabel: getCommonTranslation('USER_TYPE'),
			width:226,
			valueField: 'id',
			displayField: 'userGroupName',
            editable:false
			//emptyText: getCommonTranslation('ENTER_THREE_CHAR')
		},{
			xtype: 'customcombobox',
			name: 'DEPARTMENT_ID',
			itemId: 'department_name_infirmarycombo',
			fieldLabel: getCommonTranslation('DEPT_NAME'),
			store: Ext.create('Academia.store.department.DepartmentAcademyLocationWiseStore'),
			displayField:'value',
            valueField:'id',
			hidden: true,
            editable: false
			//allowBlank:false
		},{		
			xtype: 'customcombobox',	               
			name: 'STUDENT_USER_ID',
			itemId:'user_studentname_infirmarycombo',
			fieldLabel: getCommonTranslation('USER_CODE_OR_NAME'),
			store:'program.StudentsByAcademyLocationIdStore',
			displayField: 'valueCode',
			valueField: 'id',
			disabled:true,
			queryParam:'term',
			typeAhead:true,
			forceSelection:true,
			triggerAction: 'all',
			minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'  +
	                    '</div>';
	                }
	            }
		},{		
			xtype: 'customcombobox',	               
			name: 'EMPLOYEE_USER_ID',
			itemId:'user_employeename_infirmarycombo',
			fieldLabel: getCommonTranslation('USER_CODE_OR_NAME'),
			store:'user.UsersByDepartmentANdAlStore',
			displayField: 'valueCode',
			valueField: 'id',
			disabled:true,
			//typeAhead:true,
			 queryParam:'qry',
			forceSelection:true,
			hidden:true,
			minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'  +
	                    '</div>';
	                }
	            }
		},{
        	xtype: 'customcombobox',
            name: 'infirmaryReasonId',
            itemId:'infirmaryReasonId',
            fieldLabel: getCommonTranslation('CB_INFIRMARY_CLINIC_REASON'),
            store:'common.InfirmaryReasonStore',
            displayField:'value',
            valueField:'id',
            forceSelection:true,
            editable: false,
            //allowBlank: false
        }]
	},{ 
		xtype:'fieldset',
		title:getFeeAndPaymentCommonTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		defaults: {
			labelAlign: 'top',
		},
		style: {
			marginTop: '40px!important',
		},
		items:[{
			xtype:'fieldcontainer',
			layout: 'hbox',
			style: {
				marginLeft:'-0px !important'
			},
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				 xtype: 'customcombobox',
				 name: 'DOCTOR_USER_ID',
				 itemId:'docor_name_infirmarycombo',
				 store: Ext.create('Academia.store.user.UsersByRoleStore'),
				 fieldLabel: getServiceRequestTranslation('DOCTOR_NAME'),
				 valueField: 'id',
				 displayField: 'valueCode',
				 queryParam:'qry',
				 minChars:3,
				 editable:true,
				 typeAhead:true,
				 //triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				 enableKeyEvents  : 'true',
				 hideTrigger:false,
				 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				 triggerAction: 'all',
				 forceSelection:true,
				 allowBlank:true,
				 listConfig: {
					 listeners: {
						 beforeshow: function(picker) {
							 picker.minWidth = picker.up('combobox').getSize().width;
							 picker.width = picker.up('combobox').getSize().width;
						 }
					 },
					 loadingText: getCommonTranslation('SEARCHING'),
					 emptyText: getCommonTranslation('NO_RECORDS_FOUND')
				 }
			 	}]
		},{
			xtype:'fieldcontainer',
			layout: 'hbox',
			style: {
				marginLeft:'-0px !important'
			},
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
	            xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
//				translationKey : 'PROGRAM',
	            name: 'PROGRAM_ID',
	            itemId:'program_infirmarycombo',
	            //editable: false,
	           // store: 'feeandpayment.ProgramSmartSearchStore',
	            store: Ext.create('Academia.store.program.ProgramByGroupIdStore'),
	            displayField: 'valueCode',
	            valueField: 'id',
	            width:226,
	            disabled:true,
	            //typeAhead : true,
	            forceSelection:true,
	            hideTrigger:false,
	            //queryMode: 'local',
	    	    triggerAction: 'all',
	    	    //anyMatch : true,
	    	    queryParam:'qry',
	    	    minChars:3,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{value}'  +
		                    '</div>';
		                }
		            }
	        },{
				 xtype: 'customcombobox',
				 name: 'BATCH_ID',
				 itemId:'batch_infirmarycombo',
				 store:'program.programbatchdetail.BatchByProgramIdSSStore',
				 fieldLabel: getCommonTranslation('BATCH'),
				 valueField: 'id',
				 displayField: 'value',
				 queryParam:'qry',
				 disabled:true,
				 minChars:3,
				 editable:true,
				 //typeAhead:true,
				 //triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				 enableKeyEvents  : 'true',
				 hideTrigger:false,
				 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				 triggerAction: 'all',
				 forceSelection:true,
				 allowBlank:true
			 	}]
		},{
			xtype:'fieldcontainer',
			layout: 'hbox',
			style: {
				marginLeft:'-0px !important'
			},
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
	            xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('PERIOD'),
	            name: 'PERIOD_ID',
	            itemId:'period_infirmarycombo',
	            store: 'program.programbatchdetail.PeriodByBatchIdSSStore',
	            displayField: 'value',
	            valueField: 'id',
	            width:226,
	            //typeAhead : true,
	            forceSelection:true,
	            hideTrigger:false,
	            disabled:true,
	            queryParam:'qry',
	            triggerAction: 'all',
	            minChars:3,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            listConfig: {
	            	listeners: {
	            		beforeshow: function(picker) {
	            			picker.minWidth = picker.up('combobox').getSize().width;
	            		}
	            	},
	            	loadingText: getCommonTranslation('SEARCHING'),
	            	emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	            	getInnerTpl: function() {
	            		return '<div class="search-item">' +
	            		'{value}'  +
	            		'</div>';
	            	}
	            }
	        },{
				 xtype: 'customcombobox',
				 store: 'program.programbatchdetail.SectionByPeriodIDSmartSearch',
				 fieldLabel: getCommonTranslation('SECTION'),
				 valueField: 'sectionId',
	             displayField: 'sectionCode',
				 name: 'SECTION_ID',
				 itemId:'section_infirmarycombo',
				 disabled:true,
				 queryParam:'qry',
				 minChars:3,
				 editable:true,
				 //typeAhead:true,
				 //triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				 enableKeyEvents  : 'true',
				 hideTrigger:false,
				 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				 triggerAction: 'all',
				 forceSelection:true,
				 allowBlank:true,
	             listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{value}'  +
		                    '</div>';
		                }
		            }
			 	}]
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		style : {
			marginTop : '20px',
			marginLeft : '-2px'
		},
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'manage_infirmary_search',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});