/**
* @author pritam.patil
* program request Details Panel 
 */
Ext.define('Academia.view.servicerequest.programcoursesectiontransferrequest.ProgramRequestDetailsPanel', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.programrequestdetailspanel',
    frame: false,
    border: false,
    plugins: "formlabelrequired",
    cls: 'serviceRequestMainPanelCls',
    items: [{
        xtype: 'hidden',
        name: 'id'
    },
	{
        xtype: 'hidden',
        name: 'version'
    }, {
        xtype: 'nestedJsonCombo',
        name: 'assignee',
        itemId: 'assigneeId',
        hidden: true,
        width: 226
    }, {
        xtype: 'nestedJsonCombo',
        name: 'serviceRequestSetting',
        itemId: 'settingId',
        hidden: true,
        width: 226
    },{
        xtype: 'hidden',
        name: 'fromBatchId',
        itemId: 'fromBatchId',
    },{
        xtype: 'hidden',
        name: 'admissionId',
        itemId: 'admissionId',
    }, {
        xtype: 'requesterdetailspanel',
        itemId: 'requesterDetails',
        style: {
            marginBottom: '0px'
        }
    }, {
        xtype: 'basicdetails',
        itemId: 'programBasicDetails',
        style: {
            marginBottom: '-29px'
        }
    },{
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        style: {
             marginLeft: '20px'
        },
        items: [{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
			name: 'academicTermId',
			store: Ext.create('Academia.store.program.programDetails.programBatches.programSeatType.LeaveOfAbsenceAcademicTermStore'),
			valueField: 'id',
			itemId: 'academicTermId',
			displayField: 'value',
			editable: false,
			queryMode: 'local',
			hidden : true
			
        }]
    },
    {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        style: {
             marginLeft: '20px'
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('FROM_PROGRAM'),
            name: 'fromProgramId',
            store: 'servicerequest.programcoursesectiontransfer.FromPrograms',
            valueField: 'id',
            itemId: 'fromProgramId',
            displayField: 'value',
            allowBlank: false,
            editable: false,
            queryMode: 'local'
        }, {
        	xtype : 'customcombobox',
			name : 'programGroup',
			itemId : 'programGroupId',
			fieldLabel : getCommonTranslation('PROGRAM_GROUP_NAME'),
			store:'program.ProgramGroupStore',
			valueField : 'id',
			displayField : 'value',
			forceSelection : true,
			allowBlank: false,
            editable: false
        }, {
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('TO_PROGRAM'),
            name: 'toProgramId',
            store: 'servicerequest.programcoursesectiontransfer.ToPrograms',
            valueField: 'id',
            itemId: 'toProgramId',
            displayField: 'value',
            allowBlank: false,
            editable: false,
            queryMode: 'local',
            listConfig: {
            	listeners: {
            		beforeshow: function(picker) {
            			picker.minWidth = picker.up('combobox').getSize().width;
            			picker.width = picker.up('combobox').getSize().width;
            		}
            	}

            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        style: {
             marginLeft: '20px',
             marginBottom: '15px'
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('BATCH'),
            name: 'toBatchId',
            store: 'servicerequest.programcoursesectiontransfer.ToBatches',
            valueField: 'id',
            itemId: 'toBatchId',
            displayField: 'value',
            allowBlank: false,
            editable: false,
            queryMode: 'local'
        }, {
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('SEAT_TYPE'),
            name: 'toSeatTypeId',
            store: 'servicerequest.programcoursesectiontransfer.SeatTypes',
            valueField: 'id',
            itemId: 'toSeatTypeId',
            displayField: 'value',
            allowBlank: false,
            editable: false,
            queryMode: 'local'
        },
        {
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('PERIOD'),
            name: 'toPeriodId',
            store: 'servicerequest.programcoursesectiontransfer.programTransferToPeriodStore',
            valueField: 'id',
            itemId: 'toPeriodId',
            displayField: 'value',
            allowBlank: false,
            editable: false,
            queryMode: 'local'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'vbox'
        },
        width: 680,
        style: {
             marginLeft: '20px'
        },
        items: [{
        	xtype: 'displayfield',
        	width: 680,
        	labelWidth: 680,
        	cls:'hideDisplayText',
        	labelSeparator:' ',
        	fieldLabel: getCommonTranslation('PT_AUTHORIZED_DECLARATION'),
        	itemId: 'authorizeDeclarationDetails',
        	name: 'authorizeDeclarationDetails'
        },{
        	xtype: 'checkboxfield',
        	width: '100%',
        	cls:'acceptCheckBox',
        	labelAlign: 'right',
        	boxLabel: getCommonTranslation('PT_AUTHORIZED_CHECKBOX'),
        	name: 'authorizeDeclaration',
        	itemId:'authorizeDeclarationId',
        	inputValue : true,
        	afterBoxLabelTpl:' ',
        	uncheckedValue: false 
        },{
        	xtype: 'fieldset',
        	itemId: 'healthInsuranceId',
        	width: '100%',
        	cls: 'fieldSetDFRCls',
        	title: getCommonTranslation("PT_HEALTH_INSURANCE_FC"),
        	style: {
        		marginLeft: '5px',
        		marginTop: '10px !important',
        		padding: '0px !important'
        	},
        	items: [{
        		xtype: 'checkboxfield',
        		width: '100%',
        		labelAlign: 'right',
        		boxLabel: getCommonTranslation('PT_HEALTH_INSURANCE'),
        		name: 'healthInsuranceCheck',
        		itemId:'healthInsuranceCheckId',
        		inputValue : true,
            	afterBoxLabelTpl:' ',
        		uncheckedValue: false 
        	}]
        },{
        	xtype: 'fieldset',
        	itemId: 'scholarshipId',
        	width: '100%',
        	cls: 'fieldSetDFRCls',
        	title: getCommonTranslation("PT_SCHOLARSHIP_FC"),
        	style: {
        		marginLeft: '5px',
        		marginTop: '10px !important',
        		padding: '0px !important'
        	},
        	items: [{
        		xtype: 'checkboxfield',
        		width: '100%',
        		labelAlign: 'right',
        		boxLabel: getCommonTranslation('PT_SCHOLARSHIP'),
        		name: 'scholarshipCheck',
        		itemId:'scholarshipCheckId',
        		inputValue : true,
            	afterBoxLabelTpl:' ',
        		uncheckedValue: false 
        	}]
        },{
        	xtype: 'fieldset',
        	itemId: 'medicalIssuesId',
        	width: '100%',
        	cls: 'fieldSetDFRCls',
        	title: getCommonTranslation("PT_MEDICAL_ISSUES_FC"),
        	style: {
        		marginLeft: '5px',
        		marginTop: '10px !important',
        		padding: '0px !important'
        	},
        	items: [{
        		xtype: 'checkboxfield',
        		width: '100%',
        		labelAlign: 'right',
        		boxLabel: getCommonTranslation('PT_MEDICAL_ISSUES'),
        		name: 'medicalIssuesCheck',
        		itemId:'medicalIssuesCheckId',
        		inputValue : true,
            	afterBoxLabelTpl:' ',
        		uncheckedValue: false 
        	}]
        },{
        	xtype: 'displayfield',
        	width: 680,
        	labelWidth: 680,
        	cls:'hideDisplayText',
        	labelSeparator:' ',
        	fieldLabel: getCommonTranslation('PT_UP_TO_DATE_DETAILS'),
        	itemId: 'upToDateDetailsDetails',
        	name: 'upToDateDetailsDetails'
        },{
        	xtype: 'checkboxfield',
        	width: '100%',
        	cls:'acceptCheckBox',
        	labelAlign: 'right',
        	boxLabel: getCommonTranslation('PT_UP_TO_DATE_CHECKBOX'),
        	name: 'upToDateDetails',
        	itemId:'upToDateDetailsId',
        	inputValue : true,
        	afterBoxLabelTpl:' ',
        	uncheckedValue: false 
        },{
        	xtype: 'checkboxfield',
        	width: '100%',
        	cls:'hideCheckBox',
        	labelAlign: 'right',
        	boxLabel: getCommonTranslation('STUDENT_DECLARATION'),
        	name: 'studentdeclaration',
        	itemId:'studentDeclarationId',
        	inputValue : true,
        	afterBoxLabelTpl:' ',
        	uncheckedValue: false 
        },{
        	xtype: 'displayfield',
        	width: 680,
        	labelWidth:680,
        	labelSeparator:' ',
        	cls:'hideDisplayText',
        	itemId: 'studentDeclarationDetails',
        	fieldLabel: getCommonTranslation('STUDENT_DECLARATION_CONTENT'),
        	name: 'studentDeclarationDetails'
        }, {
        	xtype: 'checkboxfield',
        	width: '100%',
        	labelAlign: 'right',
        	boxLabel: getCommonTranslation('FOR_STUDENTS_APPLYING'),
        	name: 'studentApply',
        	cls:'hideCheckBox',
        	itemId:'studentApplyId',
        	inputValue : true,
        	afterBoxLabelTpl:':',
        	uncheckedValue: false 
        },{
        	xtype: 'displayfield',
        	width: 680,
        	cls:'hideDisplayText',
        	labelWidth:680,
        	labelSeparator:' ',
        	itemId: 'forStudentsApplyingDetails',
        	fieldLabel: getCommonTranslation('FOR_STUDENTS_APPLYING_CONTENT'),
        	name: 'forStudentsApplyingDetails'
        },{
        	xtye:'checkboxgroup',
        	itemId:'isConfirmation',
        	allowBlank: false,
        	margin:' 0 0 0 -10',
        	items:[{
        		xtype: 'checkboxfield',
        		width: '100%',
        		labelAlign: 'right',
        		cls:'acceptCheckBox',
        		boxLabel: '<span class="required" style="color:red"> *</span>'+getCommonTranslation('ACCEPT_STUDENT_DECLARATION'),
        		name: 'confirmation',
        		itemId:'confirmationId',
        		inputValue : true,
        		afterBoxLabelTpl:'.',
        		uncheckedValue: false 
        	},{
        		xtype: 'checkboxfield',
        		width: '100%',
        		labelAlign: 'right',
        		cls:'acceptCheckBox',
        		boxLabel: getCommonTranslation('Is_STUDENT_JOUNERY'),
        		name: 'isStudentJounery',
        		itemId:'isStudentJouneryId',
        		inputValue : true,
        		afterBoxLabelTpl:'.',
        		hidden: true,
        		uncheckedValue: false 
        	}]
        }]
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        style: {
            marginLeft: '17px',
            marginTop: '24px'
        },
        items: [{
            xtype: 'button',
            text: getServiceRequestTranslation('UPLOAD_DOC'),
            itemId: 'programSubmitBtn',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getServiceRequestTranslation('WITHDRAW_REQUEST'),
            ui: 'CustomBtnSubmit',
            itemId: 'withdrawButtonId',
            scale: CONSTANTS.BUTTONSIZE,
            hidden: true
        }]
    }]
});
