/**
 * @author Niklesh Tiwane
 * 
 */
Ext.define('Academia.view.servicerequest.quickComment.QuickCommentGrid',{
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias:'widget.quickCommentGrid',
	store : 'servicerequest.QuickCommentGridStore',
	title: getFeeAndPaymentCommonTranslation('QUICK_COMMENT'),
	border: true,
	//autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'servicerequest.QuickCommentGridStore',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments); 
	},
	columns: [{
		header : getFeeAndPaymentCommonTranslation('COMMENTS'),
		dataIndex : 'comments',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('DOCUMENTS'),
		dataIndex : 'documentName',
		flex:1,
		itemId: 'onlineDocGridPreviewBtn',
		renderer: function(value, meta, record) {
			if(record.data.documentName){
				return '<a  href="#" class="x-border-box x-btn x-btn-CustomBtnCancel-small x-btn-CustomBtnCancel-small-noicon x-btn-noicon x-noicon x-unselectable" style="text-align: center; text-decoration: none; font-size: 12px;font-weight: bold;font-family: sans-serif,Myriad Pro;color: #666 !important;padding: 8px 10px;" >'+getCommonTranslation('PREVIEW')+'</a>';
			}
			else{
				return " ";
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('COMMENTED_DATE'),
		dataIndex : 'commentDate',
		flex:1,
		renderer: function(dateTime) {
		        return (dateRender(dateTime)+" "+timeRender(dateTime));
		    },
		},
	{
		header : getFeeAndPaymentCommonTranslation('COMMENTED_BY'),
		dataIndex : 'commentedBy',
		flex:1
	}
  ]
});