/**
 * @author Deepak.Nigam
 * this is Quick search Form Of Complaint 
 */
Ext.define('Academia.view.servicerequest.studentPortal.StudentComplaintSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.studentcomplaintsearchform',
    frame : false,
    cls:'customSearchPanel', 
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getServiceRequestTranslation('GRIEVANCE_ID'),
            name: 'COMPLAINT_ID'
        },{
        	xtype:'customcombobox',
    		name: 'COMPLAINT_TYPE',
    		fieldLabel: getServiceRequestTranslation('GRIEVANCE_TYPE'),
    		store:'servicerequest.complaintrequest.ComplaintTypes',
    		displayField:'value',
    		valueField:'id',
    		itemId:'complaintType'
        },{
        	xtype:'customcombobox',
    		name:'STATUS',
    		fieldLabel: getServiceRequestTranslation('STATUS'),
    		store:'servicerequest.complaintrequest.ComplaintStatus',
    		displayField:'value',
    		valueField:'id',
    		itemId:'status'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'datefield',
            name: 'COMPLAINT_FROM_DATE',
            fieldLabel: getServiceRequestTranslation('GRIEVANCE_FROM_DATE'),
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            itemId: 'complaint_from_date',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
        },{
            xtype: 'datefield',
            name: 'COMPLAINT_TO_DATE',
            fieldLabel: getServiceRequestTranslation('GRIEVANCE_TO_DATE'),
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            itemId: 'complaint_to_date',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
        },{
            xtype: 'textfield',
            fieldLabel: getServiceRequestTranslation('BEYOND_SERVICE_LEVEL'),
            itemId: 'status',
            name: 'BEYOND_SERVICE_LEVEL'
        }]
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        items: [{
            xtype: 'button',
            text: getServiceRequestTranslation('SEARCH'),
            itemId: 'complaintFindButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        },{
            xtype: 'button',
            text: getServiceRequestTranslation('CLEAR_SEARCH'),
            itemId: 'complaintClearSearch',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});