/**
 * @author pritam.patil
 * this form is used for student track request
 */
Ext.define('Academia.view.setup.dashboard.TransactionViewSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.transactionviewsearchform',
    frame: false,
    cls:'customSearchPanel',
    items: [{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('NATURE_OF_CHANGE'),
            store: 'setup.dashboard.NatureOfChanges',
            editable: false,
            queryMode: 'local',
            name: 'operationModeId',
            itemId: 'natureOfChangeId',
            valueField: 'id',
            displayField: 'value'
       },{
            xtype: 'datefield',
            name: 'startDate',
            fieldLabel: getServiceRequestTranslation('FROM_DATE'),
            itemId: 'from_date',
            msgTarget: 'qtip',
            vtype: 'daterange',
            endDateField: 'till_date',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.DATE_FORMAT
        }, {
            xtype: 'datefield',
            name: 'endDate',
            fieldLabel: getServiceRequestTranslation('TILL_DATE'),
            itemId: 'till_date',
            msgTarget: 'qtip',
            vtype: 'daterange',
            startDateField: 'from_date',
            listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat: CONSTANTS.DATE_FORMAT
        }]
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('NATURE_OF_TRANSACTION'),
            store: 'setup.dashboard.NatureOfTransactions',
            name: 'transactionCode',
            itemId: 'natureOfTransactionId',
            valueField: 'value',
            width: 462,  
            queryParam:'transactionCode',
            enableKeyEvents  : 'true',
            forceSelection:true,
            enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
            displayField: 'value'
       }, {
            xtype: 'livesearchcombo',
			name: 'user',
			fieldLabel: getPersonModuleTranslation('USER'),
			emptyText :getCommonTranslation('TYPE_3_CHAR'),
			itemId : 'user',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
			}
       }]
     },{
        xtype: 'fieldcontainer',
        width: '100%',
        style :{
        	marginLeft : '-2px',
        	marginTop : '10px' 
        },
        items: [{
            xtype: 'button',
            text: getServiceRequestTranslation('SEARCH'),
            itemId: 'findButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getServiceRequestTranslation('CLEAR_SEARCH'),
            itemId: 'clearSearch',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
            /*listeners : {
            	click : function(button){
            		this.up('form').getForm().reset();
            	}
            }*/
        }]
    }]
});