/**
 * @author ravindra
 * 
 */
Ext.define('Academia.view.setup.loginPageContent.LoginPageContentStructure',{
	extend : 'Ext.panel.Panel',
	alias : 'widget.loginpagecontentstructure',
	autoScroll:true,
	bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL} ,
	items : [{
		xtype:'panel',
		layout: 'vbox',
		items:[{
			xtype:'fieldcontainer',
			layout:'hbox',
			items:[{
				xtype: 'textfield',
				itemId: 'captchaSiteKey',
				allowBlank: false,
				fieldLabel: getCommonTranslation('CAPTCHA_SITE_KEY'),
				labelSeparator: ': <span class="required" style="color:red"> *</span>',
				width: 600,
				labelWidth: 140,
				margin: 10
			},{
	            xtype: 'customcombobox',
	            name: 'urlName',
	            itemId: 'urlItemId',
	            fieldLabel: getCommonTranslation('URLS'),
	            store:'setup.loginPageSetup.LoginPageUrlStore',
	            valueField: 'id',
	            displayField: 'nameValue',
				triggerAction: 'all',
				width: 450,
				editable: false,
				labelWidth: 80,
				margin: 10,
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							//var combo = picker.up('combobox');
							//picker.setWidth(combo.getWidth());
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND')
				}
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			items:[{
				xtype: 'textfield',
				itemId: 'captchaSecretKey',
				allowBlank: false,
				fieldLabel: getCommonTranslation('CAPTCHA_SECRET_KEY'),
				labelSeparator: ': <span class="required" style="color:red"> *</span>',
				width: 600,
				labelWidth: 140,
				margin: '0 0 0 10'
			},{
				xtype:'panel',
				items:[{
				xtype: 'displayfield',
				name: 'urlHyperLinkName',
				itemId: 'urlHyperLinkItemId',
				width: 450,
				margin: '-12 0 0 94',
				renderer:function(value,field,record){
					if(!isNullOrEmpty(value)){
						value = Ext.String.trim(value);
						if (!/^https?:\/\//i.test(value)) {
							value = 'https://' + value;
						}

						if (!/\/$/.test(value)) {
							value = value + '/';
						}
						if (value.length > 70) {
							var valtext = value.substring(0, 70) + "...";
							field.getEl().dom.setAttribute('data-qtip',value);
							return '<a href="' + value + '" target="_blank">'+valtext+'</a>';
						}else {
							field.getEl().dom.setAttribute('data-qtip',value);
							return '<a href="' + value + '" target="_blank">'+value+'</a>';
						}
					}else{
						return value;
					}
				}
			}]
			}]
		},{
			xtype : 'loginpageconfigurationform'
		}
		/*,{
			xtype:'panel',
			items:[{
				xtype : 'searchresultgrid',  
				itemId: 'templatemappinggridId'
			}]
		}*/]
	}]
});