/**
 * @author Dharmendra.Prajapati
 * 
 */
Ext.require([
             'Ext.ux.form.MultiSelect'
             ]);
Ext.define('Academia.view.setup.templatemapping.TemplateMappingSearch',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.templatemappingsearch',  
	plugins : "formlabelrequired",
	frame: false,
	cls:'customSearchPanel',
	standardSubmit: false,
	items: [{
		/*xtype: 'form',
        width: '100%',
        items: [{*/
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items :[{
			xtype : 'multiselectcombofield',
			name : 'academyLocation',
			itemId:'academyLocationId',
			autoloadStore: false,
			width: 460,
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:'common.AcademyLocationNameSeparated',
			valueField : 'id',
			displayField : 'value',
			allowBlank : false,
			queryParam:'qry',
			minChars:3,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							if(items.length==0)
								Ext.select('.x-boundlist-item').elements[0].hidden = true;
							else
								Ext.select('.x-boundlist-item').elements[0].hidden = false;
				        });
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items :[{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('TEMPLATE_TYPE'),
			itemId: 'templateType',
			name: 'templateType', 
			store:'setup.templatemapping.TemplateType',
			valueField:'id',
			displayField:'value',
			allowBlank:false					
		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
			itemId: 'templateName',
			name: 'templateName',
			store:'setup.templatemapping.TemplateName',
			valueField:'value',
			displayField:'value',
			queryParam:'reportTemplateName',
			minChars:3,
			allowBlank:true,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+ 
					'</div>';
				}
			},
			disabled:true
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',

		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			formBind:true,
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getExaminationTranslation('RESET'),
			itemId: 'resetBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}
		]
	}]
});