/**
 * @author Deepika Parmr
 */
Ext.define('Academia.view.sponsorship.QuotationDetailsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.quotationdetailsgrid',
	store: 'sponsorship.QuatationDetailsGridStore',
	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	margin:0,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'sponsorship.QuatationDetailsGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;       
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     

	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype: 'button',
		itemId: 'manageStudents',
		tooltip: getCommonTranslation('MANAGE_STUDENTS'),
		text:getCommonTranslation('MANAGE_STUDENTS')
	},'->',{
		xtype: 'button',
		itemId: 'btnPrint',
		icon: 'resources/images/print1.png',
		tooltip: getFeeAndPaymentCommonTranslation('Print')
	}],
	columns: [{
		header:  getCommonTranslation('QUOTATION_ID'),
		dataIndex: 'quotationCode',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('QUOTATION_NAME'),
		dataIndex: 'quotationName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('QUOTATION_DATE'),
		dataIndex: 'quotationDate',
		flex:1,
		renderer: function(date) {
			if(date!=null){
				return dateRender(date);
			}
		}
		
		
	},{
		header:  getCommonTranslation('CREATED_BY'),
		dataIndex: 'userName',
		flex:1		
	},{
		header:  getCommonTranslation('QUOTATION_AMOUNT'),
		flex:1,
		dataIndex: 'noOfStudentSponsored'
	},{
		header:  getCommonTranslation('APPROVAL_STATUS'),
		flex:1,
		dataIndex: 'approvalStatus',
		renderer: function(value) {
			if(value == 'PENDING'){
				return 'Pending';
			}
			if(value == 'SUBMITTED'){
				return 'Submitted';
			}
			if(value == 'APPROVED'){
				return 'Approved';
			}
			if(value == 'REJECTED'){
				return 'Rejected';
			}
		}
	},{
		header:  getCommonTranslation('NO_OF_STUDENTS'),
		flex:1,
		dataIndex: 'noOfStudentSponsored',
	}]
});

