/**
 *  This form is used for student and StudentThesisUploadForm action
 *  @author Vidhi Shah
 */
Ext.define('Academia.view.student.postGraduateManagement.IndependentNonExaminingChairPersonForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.independentnonexaminingchairpersonform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'independentNonExaminingChairPersonHiddenId',
        name: 'id'
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [ {
            xtype: 'datefield',
            fieldLabel: getCommonTranslation('AUDIT_DATE'),
            itemId: 'auditDate',
            name: 'auditDate',
            startDateField : 'auditDate',
            listeners: {
            	render: function(obj) {
					obj = dateFormatRender(obj);						
					obj.setValue(new Date());
				}
              },
            allowBlank: false,
            vtype : 'daterange',
            readOnly:true
        }, {
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('AUDIT_ID'),
            itemId: 'auditId',
            name: 'auditId',
            allowBlank: false,
            readOnly:true
        }]
    },{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width : 460,
			labelAlign : 'top'
		},
		items : [{
			xtype:'independentnonexaminingchairpersondocgrid',
			itemId:'independentNonExaminingChairPersonDocGridItemId',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{ 
		xtype:'fieldcontainer',
    	width:'auto',
		layout : 'hbox',
		items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        },
        {
			 xtype: 'button',
			 name: 'courseSyllabus',
			 text:getCommonTranslation('UPLOAD_DOC'),
			 itemId: 'uploadINECPItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
    }]
});
