/**
 * 
 * @author Vyabha Thakur
 */
Ext.define('Academia.view.student.studentprofile.FunctionaryProgressReportGrid',{
	alias : 'widget.functionaryprogressreportgrid',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	store:'student.postGraduateManagement.FunctionaryProgressReportStore',
	title: getCommonTranslation('FUNCTIONARY_PROGRESS_REPORT'),
	border: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'student.postGraduateManagement.FunctionaryProgressReportStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		hasDisableForProfileViewMode: true
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode: true
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],
	columns : [ {
		header: getCommonTranslation('PROGRESS_REPORT_PERIOD_START_DATE'),
		dataIndex: 'progressReportPeriodStartDate',
		ItemId: 'progressReportPeriodStartDate',
		sortable: true,
		hidden:false,
		flex: 1.4,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header: getCommonTranslation('PROGRESS_REPORT_PERIOD_END_DATE'),
		dataIndex: 'progressReportPeriodEndDate',
		ItemId: 'progressReportPeriodEndDate',
		sortable: true,
		hidden:false,
		flex: 1.4,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header: getCommonTranslation('RESPONSIBLE_FUNCTIONARY_EMPLOYEE_ID'),
		dataIndex: 'responsibleFunctionaryEmployeeID',
		ItemId: 'responsibleFunctionaryEmployeeID',
		sortable: true,
		hidden:false,
		flex:1.6,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.responsibleFunctionaryEmployeeID.code+"/"+record.data.responsibleFunctionaryEmployeeID.value;
			}                        
		}
	},{
		header: getCommonTranslation('NAME'),
		dataIndex: 'name',
		itemId: 'name',
		sortable: true,
		hidden:false,
		flex: 0.5
	},{
		header: getCommonTranslation('LAST_NAME'),
		dataIndex: 'lastName',
		itemId: 'lastName',
		sortable: true,
		hidden:true,
		flex: 1
	},{
		header: getCommonTranslation('FUNCTIONARY_TYPE'),
		dataIndex: 'functionaryType',
		sortable: true,
		hidden:false,
		flex: 1,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.functionaryType.value;
			}                        
		}
	},{
		header: getCommonTranslation('PROGRESS_REPORT_RATING'),
		dataIndex: 'reportRating',
		sortable: true,
		hidden:false,
		flex: 1,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.reportRating.value;
			}                        
		}
	},{
		header : getCommonTranslation('UPLOAD_DOCUMENT'),
		dataIndex: 'functionaryProgressReportDocuments',
		flex:1,
		sortable:true,
		hidden:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				if(record.data.functionaryProgressReportDocuments.length>1) {					
					return '<a href=#>'+record.data.functionaryProgressReportDocuments.length+'<a>';
				} else if(record.data.functionaryProgressReportDocuments.length==1) {
					return '<a href=#>'+record.data.functionaryProgressReportDocuments[0].name+'<a>';
				} 
			}                        
		}
	},{
		header: getPersonModuleTranslation('AUDIT_DATE'),
		dataIndex: 'auditDate',
		ItemId: 'auditDateItemId',
		sortable: true,
		hidden:true,
		flex: 1,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header: getPersonModuleTranslation('AUDIT_ID'),
		dataIndex: 'auditId',
		ItemId: 'auditIdItemId',
		flex: 1,
		sortable: true,
		hidden:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.auditId.code;
			}                        
		}
	}]
});