/**
 * @Author Harshit Patidar
 */
Ext.define('Academia.view.student.studentprofile.ProgramCompletionDetails', {
	//extend: 'Ext.form.Panel',
	extend: 'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.programcompletiondetails',
	border : false,
	frame : false,
	plugins: "formlabelrequired",
	items: [{
        xtype: 'hidden',
        itemId: 'program_Completion_Details_HiddenId',
        name: 'id'
    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 226
    	},
    	layout: {
    		type: 'hbox'
    	},
    	items: [{
    		xtype: 'textfield',
    		name: 'studentId',
            itemId: 'studentItemId',
            fieldLabel: getCommonTranslation('STUDENT_ID'),
            readOnly:true,
            allowBlank: false
           	},{
        	xtype: 'textfield',
            fieldLabel: getCommonTranslation('STUDENT_NAME'),            
            itemId: 'studentNameItemId',
            name: 'studentName',
            readOnly : true,
            allowBlank: false
        }, {
            xtype: 'nestedJsonCombo',
            name: 'admissionId',
            itemId: 'admissionItemId',
            fieldLabel: getCommonTranslation('ADMISSION_ID'),
            hidden:true,
            allowBlank: true,
            valueField: 'id',
            displayField: 'value',
            queryMode: 'local',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.student.studentprofile.ProgramCompletionDetailsAdmissionStore');
                    combo.bindStore(store);
                }
            }
        },{
            xtype: 'nestedJsonCombo',
            name: 'admissionIdProgramBatch',
            itemId: 'admissionIdProgramBatch',
            fieldLabel: getCommonTranslation('ADMISSION_ID_PROGRAM_BATCH'),
            editable: false,
            allowBlank: false,
            valueField: 'id',
            displayField: 'displayValue',
            queryMode: 'local',
            width:462,
            matchFieldWidth: true,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.student.studentprofile.ProgramBatchAdmissionIDStore');
                    combo.bindStore(store);
                }
            }
        }]
    }, {
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 226
    	},
    	layout: {
    		type: 'hbox'
    	},
			items: [{
				xtype: 'nestedJsonCombo',
				name: 'programId',
				itemId: 'programItemId',
				fieldLabel: getCommonTranslation('PROGRAM'),
				hidden:true,
				allowBlank: true,
				valueField: 'programId',
				displayField: 'programName',
				store: Ext.create('Academia.store.student.studentprofile.ProgramCompletionDetailsProgramCsm'),
				forceSelection: true
			}, {
				xtype: 'nestedJsonCombo',
				name: 'batchId',
				itemId: 'batchCombo',
				hidden:true,
				fieldLabel: getCommonTranslation('BATCH'),
				allowBlank: true,
				displayField: 'batchName',
				valueField: 'batchId',
				store: Ext.create('Academia.store.student.studentprofile.ProgramCompletionDetailsProgramCsm'),
				forceSelection: true
			},{
				xtype: 'nestedJsonCombo',
				name: 'period',
				itemId: 'periodId',
				displayField: 'value',
				valueField: 'id',
				disabled: true,
				allowBlank: true,
				fieldLabel: getCommonTranslation('PERIOD'),
				store: Ext.create('Academia.store.student.studentprofile.ProgramCompletionDetailPeriodStore'),
				forceSelection: true
			},{
				xtype: 'datefield',
				fieldLabel: getCommonTranslation('DATE_OF_GRADUATION'),
				itemId: 'dateOfGraduation',
				name: 'dateOfGraduation',
				vtype: 'daterange',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},{
				xtype: 'nestedJsonCombo',
				name: 'classificationId',
				itemId: 'classificationItemId',
				displayField: 'value',
				valueField: 'id',
				fieldLabel: getCommonTranslation('CLASSIFICATION'),
				forceSelection: true,
				store: Ext.create('Academia.store.student.studentprofile.ClassificationCsmStore', {
				        autoLoad: false
				    }),
				   listeners: {
				        afterrender: function (combo) {
				            combo.onTriggerClick = function () {
				                var form = combo.up('form');
				                var existingStore = combo.getStore();

				                    var this$ = combo.up('programcompletiondetails'); // or however you access controller
				                    var admissionId = form.down('#admissionItemId').getValue();
				                    var programId = form.down('#programItemId').getValue();
				                    var batchId = form.down('#batchCombo').getValue();
				                    var admissionIdProgramBatch = form.down('#admissionIdProgramBatch').getValue();
				                    var studentId = form.down('#studentItemId').getValue();
				                    $$this = Academia.app.getController('Academia.controller.personinfo.student.StudentCourseExecutionController');
				                    var academyLocationId = $$this.getCurrentAcademyLocation();

				                    if (!Ext.isEmpty(admissionIdProgramBatch)) {
				                        Ext.Ajax.request({
				                            type: 'rest',
				                            method: 'GET',
				                            url: SERVERURL.PATH_PROGRAM_BATCH_ADMISSION_ID,
				                            params: {
				                                studentCode: studentId,
				                                academyLocationId: academyLocationId
				                            },
				                            success: function (response) {
				                                var json = Ext.decode(response.responseText);

				                                Ext.Array.each(json, function (item) {
				                                    if (item.programId === programId && item.batchId === batchId) {
				                                        var classifications = item.batchStudentClassifications;
				                                        if (classifications && classifications.length > 0) {
				                                            var data = Ext.Array.map(classifications, function (cls) {
				                                                return {
				                                                    id: cls.studentClassification.id,
				                                                    value: cls.studentClassification.value
				                                                };
				                                            });

				                                            existingStore.loadData(data);
				                                            Ext.defer(function () {
				                                                combo.expand();
				                                            }, 200);
				                                        }else {
				                                            existingStore.load();
				                                            combo.expand();
				                                        }
				                                    }
				                                });
				                            }
				                        });
				                    }else {
			                            existingStore.load();
			                            combo.expand();
			                        }
				            };
				        }
				    }
				},{
					xtype: 'nestedJsonCombo',
					name: 'specializationId',
					itemId: 'specializationItemId',
					displayField: 'value',
					valueField: 'id',
					fieldLabel: getCommonTranslation('SPECIALIZATION'),
					forceSelection: true,
					store: Ext.create('Academia.store.student.studentprofile.SpecilizationCsmStore', {
				        autoLoad: false
				    }),
				    listeners: {
				        afterrender: function (combo) {
				            combo.onTriggerClick = function () {
				                var form = combo.up('form');
				                var existingStore = combo.getStore();

				                    var this$ = combo.up('programcompletiondetails'); // or however you access controller
				                    var admissionId = form.down('#admissionItemId').getValue();
				                    var programId = form.down('#programItemId').getValue();
				                    var batchId = form.down('#batchCombo').getValue();
				                    var admissionIdProgramBatch = form.down('#admissionIdProgramBatch').getValue();
				                    var studentId = form.down('#studentItemId').getValue();
				                    $$this = Academia.app.getController('Academia.controller.personinfo.student.StudentCourseExecutionController');
				                    var academyLocationId = $$this.getCurrentAcademyLocation();

				                    if (!Ext.isEmpty(admissionIdProgramBatch)) {
				                        Ext.Ajax.request({
				                            type: 'rest',
				                            method: 'GET',
				                            url: SERVERURL.PATH_PROGRAM_BATCH_ADMISSION_ID,
				                            params: {
				                                studentCode: studentId,
				                                academyLocationId: academyLocationId
				                            },
				                            success: function (response) {
				                                var json = Ext.decode(response.responseText);

				                                Ext.Array.each(json, function (item) {
				                                    if (item.programId === programId && item.batchId === batchId) {
				                                        var specializations = item.batchSpecializations;
				                                        if (specializations && specializations.length > 0) {
				                                            var data = Ext.Array.map(specializations, function (cls) {
				                                                return {
				                                                    id: cls.studentSpecialization.id,
				                                                    value: cls.studentSpecialization.value
				                                                };
				                                            });

				                                            existingStore.loadData(data);
				                                            Ext.defer(function () {
				                                                combo.expand();
				                                            }, 200);
				                                        }else {
				                                            existingStore.load();
				                                            combo.expand();
				                                        }
				                                    }
				                                });
				                            }
				                        });
				                    }else {
			                            existingStore.load();
			                            combo.expand();
			                        }
				            };
				        }
				    }
				}
			]
		},
   {
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
      items: [{
        xtype: 'nestedJsonCombo',
        name: 'awardTypeId',
        itemId: 'awardTypeItemId',
        displayField: 'value',
        valueField: 'id',
        fieldLabel: getCommonTranslation('AWARD_TYPE'),
        forceSelection: true,
        store: Ext.create('Academia.store.common.ProgramCompletionAwardTypeStore', {
	        autoLoad: false
	    }),
	    listeners: {
	        afterrender: function (combo) {
	            combo.onTriggerClick = function () {
	                var form = combo.up('form');
	                var existingStore = combo.getStore();

	                    var this$ = combo.up('programcompletiondetails'); // or however you access controller
	                    var admissionId = form.down('#admissionItemId').getValue();
	                    var programId = form.down('#programItemId').getValue();
	                    var batchId = form.down('#batchCombo').getValue();
	                    var admissionIdProgramBatch = form.down('#admissionIdProgramBatch').getValue();
	                    var studentId = form.down('#studentItemId').getValue();
	                    $$this = Academia.app.getController('Academia.controller.personinfo.student.StudentCourseExecutionController');
	                    var academyLocationId = $$this.getCurrentAcademyLocation();

	                    if (!Ext.isEmpty(admissionIdProgramBatch)) {
	                        Ext.Ajax.request({
	                            type: 'rest',
	                            method: 'GET',
	                            url: SERVERURL.PATH_PROGRAM_BATCH_ADMISSION_ID,
	                            params: {
	                                studentCode: studentId,
	                                academyLocationId: academyLocationId
	                            },
	                            success: function (response) {
	                                var json = Ext.decode(response.responseText);

	                                Ext.Array.each(json, function (item) {
	                                    if (item.programId === programId && item.batchId === batchId) {
	                                        var awardType = item.batchAwardTypes;
	                                        if (awardType && awardType.length > 0) {
	                                            var data = Ext.Array.map(awardType, function (cls) {
	                                                return {
	                                                    id: cls.programCompletionAwardType.id,
	                                                    value: cls.programCompletionAwardType.value
	                                                };
	                                            });

	                                            existingStore.loadData(data);
	                                            Ext.defer(function () {
	                                                combo.expand();
	                                            }, 200);
	                                        }else {
	                                            existingStore.load();
	                                            combo.expand();
	                                        }
	                                    }
	                                });
	                            }
	                        });
	                    }else {
                            existingStore.load();
                            combo.expand();
                        }
	            };
	        }
	    }
    },{
    	xtype: 'textfield',
        fieldLabel: getCommonTranslation('AWARD_CERTIFICATE_ID'),            
        itemId: 'awardCertificationItemId',
        name: 'awardCertificate',
        maxLength:255
    },{
        xtype: 'nestedJsonCombo',
        name: 'awardDeliveryMethodId',
        itemId: 'awardDeliveryMethodItemId',
        displayField: 'value',
        valueField: 'id',
        store : Ext.create('Academia.store.student.studentprofile.AwardDeliveryMethodStore'),
        fieldLabel: getCommonTranslation('AWARD_DELIVERY_METHOD'),
        forceSelection: true
},{
    	xtype: 'datefield',
        fieldLabel: getCommonTranslation('AWARD_REQUESTED_DATE'),
        itemId: 'awardRequestedDate',
        name: 'awardRequestedDate',
        vtype : 'daterange',
        allowBlank: true,
        listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
				}
	    }]
		},
   {
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
			},
      items: [{
    	xtype: 'datefield',
        fieldLabel: getCommonTranslation('AWARD_SENT_GIVEN_DATE'),
        itemId: 'awardGivenDate',
        name: 'awardGivenDate',
        allowBlank: true,
        vtype : 'daterange',
        listeners: {
			render: function(field) {
				return dateFormatRender(field);
			}
		},
    },{
	    	xtype: 'checkboxfield',
			itemId : 'isAlumni',
			boxLabel: getCommonTranslation('IS_ALUMNI'),
			name: 'isAlumni',
			labelAlign: 'right',
			style:{
				marginTop:'25px'
			},
			region: 'south',
			inputValue: true,
			uncheckedValue: false,
	    }
    ]
},{
	xtype: 'fieldcontainer',
	width: 'auto',
	defaults: {
		labelAlign: 'top',
		width: 226
	},
	layout: {
		type: 'hbox'
	},
	items: [{
    	xtype: 'textfield',
        fieldLabel: getCommonTranslation('AWARD_NOMINATED_PERSON'),            
        itemId: 'awardNominatedPersonItemId',
        name: 'awardNominatedPerson',
        maxLength:255,
        hidden:true,
           }]
},{
	xtype: 'fieldcontainer',
	width: 'auto',
	defaults: {
		labelAlign: 'top',
		width: 226
	},
	layout: {
		type: 'hbox'
	},
	items: [{
    	xtype: 'textfield',
        fieldLabel: getCommonTranslation('AWARD_TRACKING_NUMBER'),            
        itemId: 'awardTrackingNumberItemId',
        name: 'awardTrackingNumber',
        maxLength:255,
        hidden:true
       }]
		}, {
			xtype: 'fieldcontainer',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SUBMIT'),
				itemId: 'submitButtonId',
				buttonAlign: 'right',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelButtonId',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}],
/*	items: [{
		xtype: 'checkboxfield',
		itemId: 'isAlumni',
		boxLabel: getCommonTranslation('IS_ALUMNI'),
		name: 'isAlumni',
		labelAlign: 'right',
		style: {
			marginTop: '25px'
		},
		region: 'south',
		inputValue: true,
		uncheckedValue: false,
	}] */
});