/**
 * @author Abhishek Chouhan
 */
var studentAcadmicHistoryGridStore =Ext.create('Academia.store.student.studentprofile.StudentAcademicsHistoryGridStore');
Ext.define('Academia.view.student.studentprofile.StudentAcademicsHistoryGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentacademicshistorygrid',
	title: getPersonModuleTranslation('ACADEMIC_HISTORY'),
	border: true,
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWSV2D-124878
	},
	isGridConfigurable:true,
	enableColumnHide: false,
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.student.studentprofile.StudentAcademicsHistoryGridStore');
	},
	tbar: [{	
		xtype: 'button',
		itemId: 'btnPrintTranscriptItemId',
		tooltip:getCommonTranslation('PRINT_TRANSCRIPT'),
		text:getCommonTranslation('PRINT_TRANSCRIPT')
	},{	
		//V2D-306946  
		xtype: 'button',
		itemId: 'btnPrintTranscriptInExcelItemId',
		tooltip:getCommonTranslation('PRINT_TRANSCRIPT_IN_EXCEL'),
		text:getCommonTranslation('PRINT_TRANSCRIPT_IN_EXCEL')
	}],
	columns: [{
		header: getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.3,
		hidden:true,
		sortable: true
	},{
		header: getCommonTranslation('BATCH_NAME'),
		dataIndex: 'batchName',
		flex:.3,
		hidden:true,
		sortable: true
	},{
		header: getCommonTranslation('ACADEMIC_TERM'),
		dataIndex: 'academicTerm',
		flex:.4,
		sortable: true
	},{
		header: getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('CREDITS_ALLOTED'),
		dataIndex: 'creditAlloted',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('CREDITS_EARNED'),
		dataIndex: 'creditEarned',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('TOTAL_OBTAINED_TOTAL_MARKS'),
		dataIndex: 'obtainedMarks',
		flex:.4,
		sortable: true,
		renderer:function(value,meta,record){
			var marksObtainedFrom = record.get('marksObtainedFrom');
			return value+"/"+marksObtainedFrom;  
		}
	},{
		header: getCommonTranslation('PERCENTAGE'),
		dataIndex: 'percentage',
		flex:.4,
		sortable: true
	},{
		header: getCommonTranslation('SGPA'),
		dataIndex: 'sgpa',
		flex:.2,
		sortable: true,
	},{
		header: getCommonTranslation('CGPA'),
		dataIndex: 'cgpa',
		flex:.2,
		sortable: true
	}, {
		header: getCommonTranslation('RESULT_STATUS'),
		dataIndex: 'status',
		flex:.4,
		sortable: true,
		renderer:function(record){
			if(!isNullOrEmpty(record)){
				if(!isNullOrEmpty(record)){
					if(record=='Pass'){
						return record;
					}else {
						return record = record.substring(",", record.length - 1);
					}
				}
			}
		}  
	},{
		header: getCommonTranslation('RESULT_DEC_DATE'),
		dataIndex: 'studentResultDeclarationDate',
		flex:.4,
		sortable: true
	},{
		header: getCommonTranslation('PUBLISH_DATE'),
		dataIndex: 'studentPublishDate',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('VIEW'),
		dataIndex: 'view',
		flex:.4,
		sortable: true,
		renderer:function(record){
			if(!isNullOrEmpty(record)){
				return "<a href='#'>"+getExaminationTranslation('VIEW_DETAILS')+"</a>";
			}else{
				return "-";
			}
		}  
	}]
});