/**
 * @author Rohit Thadani
 */
Ext.define('Academia.view.student.succeedingEnrollmentReport.StudentSucceedingTotalReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentsucceedingtotalreportgrid',
	store: 'student.studentenrollmentreport.StudentSucceedingTotalReportStore',
	title: getCommonTranslation('SUCCEEDING_TOTAL_ENROLLMENTS'),
	border: true,
	autoScroll: false,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS,
		emptyText :getCommonTranslation('EMPTY_MESSAGE'),
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [/*{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			//store : 'student.report.StdDemographicReportGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}*/]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	tbar: [],
	columns: [{
		header:  getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1,
	},{
		header:  getCommonTranslation('FIRST_NAME'),
		dataIndex: 'firstName',
		flex:.1
	},{
		header:  getCommonTranslation('LAST_NAME'),
		dataIndex: 'lastName',
		flex:.1
	},{
		header:  getCommonTranslation('ADMISSION_DATE'),
		dataIndex: 'admissionDate',
		renderer : function(value, recordObj, record ){
			if( !isNullOrEmpty(record.data.admissionDate) ){
				return dateRender(value);
			} else  {
				return dateRender(record.data.startingDate);
			}
		},
		flex:.1
	}]
});
