/**
 * This view is used for the student Pending Bills records.
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.studentPortal.OnlinePaymentBillLevelGridForPortal', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.onlinepaymentbilllevelgridforportal',
//	title: getPersonModuleTranslation('ONLINE_PAYMENT_BILL_LEVEL'),
	store : 'feeandpayment.adjustment.OnlinePaymentBillLevelGridStore',
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: false,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var whetherActive = record.get("whetherActive");
			if (whetherActive) {
				var baseCSSPrefix = Ext.baseCSSPrefix;
				metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
				return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
			} else {
				return '';
			} 
		}	
	},
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		listeners: {
            beforeitemkeydown: function(view, record, item, index, e) {
                var key = e.getKey();
                if (key === Ext.EventObject.UP || key === Ext.EventObject.DOWN || e.shiftKey || key === Ext.EventObject.SPACE) {
                    e.stopEvent();
                    return false;
                }
            }
        }
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:false 
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnView',
		text:getPersonModuleTranslation('MAKE_PAYMENT'),
		tooltip: getPersonModuleTranslation('MAKE_PAYMENT')
	},{
		xtype: 'button',
		itemId: 'btnPaytmPayment',
		text:getPersonModuleTranslation('MAKE_PAYMENT_VIA_PAYTM'),
		tooltip: getPersonModuleTranslation('MAKE_PAYMENT_VIA_PAYTM')
	},{
		xtype: 'button',
		itemId: 'btnPaytmTechprocess',
		text:    getCommonTranslation('MAKE_PAYMENT_VIA_TECH_PROCESS'),
		tooltip: getCommonTranslation('MAKE_PAYMENT_VIA_TECH_PROCESS')
	},{
		xtype:'fieldcontainer',
		items:[{
			xtype: 'customcombobox',
			width: 440,
			labelAlign: 'top',
			name: 'bank',
			itemId:'bankItemId',
			store: 'feeandpayment.receipts.DrawnOnBank',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			minChars:3,
			fieldLabel:getCommonTranslation('BANK'),
			allowBlank: false,
			style:{
				marginTop:'-10px'
			}
		}]
	}, '->',{
		xtype: 'button',
		itemId: 'btnPrint',
		disabled:true,
		hidden:true,
		icon: 'resources/images/print1.png',
		tooltip: getFeeAndPaymentCommonTranslation('Print')
	}],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('BILL_NO'),
		dataIndex : 'billNo',
		flex : 1,
		sortable:false,
		summaryRenderer:function(value, summaryData, dataIndex, rowIndex, colIndex, store, view){
			if(store.data.items[0].data.whetherDisplayTotal != false) {
				return getFeeAndPaymentCommonTranslation('TOTAL');
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('BILL_DATE'),
		dataIndex : 'billHeaderBillingDate',
		flex :1,
		sortable:false,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('DUE_DATE'),
		dataIndex:'billHeaderDueDate',
		flex : 1,
		sortable:false,
		renderer:function(val){		
			return dateRender(val);
		}
	},{
		header : getFeeAndPaymentCommonTranslation('BILL_AMOUNT'),
		dataIndex : 'billableAmount',
		flex : 1,
		sortable:false,
		summaryType: 'sum',
		summaryRenderer:function(value, summaryData, dataIndex, rowIndex, colIndex, store, view){
			if(store.data.items[0].data.whetherDisplayTotal != false) {
				return currencyRenderer(value,store.data.items[0].data.currencyId);
			}
		},
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(record.get("currencyId"))){
				return currencyRenderer(value,record.get("currencyId"));
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('BALANCE_AMOUNT'),
		dataIndex : 'tempRemainingAmount',
		flex : 1,
		sortable:false,
		summaryType: 'sum',
		summaryRenderer:function(value, summaryData, dataIndex, rowIndex, colIndex, store, view){
			if(store.data.items[0].data.whetherDisplayTotal != false) {
				return currencyRenderer(value,store.data.items[0].data.currencyId);
			}
		},
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(record.get("currencyId"))){
				return currencyRenderer(value,record.get("currencyId"));
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('AMOUNT_TO_PAY'),
		dataIndex : 'balanceAmount',
		flex : 1,
		sortable:false,
		editing:true,
		summaryType: 'sum',
		editor : {
			xtype:'numberfield',
			name: 'totalBalanceAmount',
			itemId:'amountToBeAdjusted',
			mouseWheelEnabled:false,
			allowDecimals:true,
			enableKeyEvents:true,
			hideTrigger:true,
			minValue:0
		},  
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value) &&!isNullOrEmpty(record.get("currencyId"))){
				return currencyRenderer(value,record.get("currencyId"));
			}else {
				meta.tdCls = 'gridInputCustomStyle'; 
				return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
			}                     
		},
		summaryRenderer:function(value, summaryData, dataIndex, rowIndex, colIndex, store, view){
			if(store.data.items[0].data.whetherDisplayTotal != false) {
				return currencyRenderer(value,store.data.items[0].data.currencyId);
			}
		}
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
		listeners : {
			beforeedit:function( editor, context, e ){
				var record = context.record;
				var getGridStore = context.grid.getStore();
				var getData = getGridStore.data.items[context.rowIdx];
				var checkedRow = context.row.firstElementChild.classList.contains('x-grid-cell-row-checker');
				
				// Ensure selection only happens through checkbox
		        if (context.grid.getSelectionModel().checkOnly && !checkedRow) {
		            return false; // Prevent editing if row is not selected via checkbox V2D-484868
		        }
				
				if(context.field== "balanceAmount") {
					if(record.data.whetherMandatoryToPay) {
						context.grid.columns[5].getEditor().setReadOnly(true);
					}else{
						context.grid.columns[5].getEditor().setReadOnly(false);
					}
				}
				var storeItems = context.grid.getStore().data.items;
				var paymentMndatoryRecArr = [];
				Ext.each(storeItems,function(rec){
					if((rec.data.whetherMandatoryToPay && rec.data.whetherActive) || rec.data.whetherChecked) {
						paymentMndatoryRecArr.push(rec);
					}
				});
				paymentMndatoryRecArr.push(record);
				context.grid.getSelectionModel().select(paymentMndatoryRecArr);

				if(record.data.whetherMandatoryToPay == true) {
					//grid.getSelectionModel().select(paymentMndatoryRecArr);
					showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('MANDATORY_BILL_NOT_EDITABLE'));
				}
				if(checkedRow == false){
					return false;
				}else{	
					if(getData.data.allowPartialPayment == false ){
						return false;
					}else{
						return true;
					}	
				}
			}
		}
	}]
});