/**
 * This view is used for the student, faculty Pending Bills records.
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.studentPortal.OnlinePaymentGridForPortal', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.onlinepaymentgridforportal',
	store : 'feeandpayment.adjustment.BillReceivableOnline',
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: false,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var whetherActive = record.get("whetherActive");
			if (whetherActive) {
				var baseCSSPrefix = Ext.baseCSSPrefix;
				metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
				return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
			} else {
				return '';
			} 
		}	
	},
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:false 
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnView',
		text:getPersonModuleTranslation('MAKE_PAYMENT'),
		tooltip: getPersonModuleTranslation('MAKE_PAYMENT')
	},{
		xtype: 'button',
		itemId: 'btnPaytmPayment',
		text:getPersonModuleTranslation('MAKE_PAYMENT_VIA_PAYTM'),
		tooltip: getPersonModuleTranslation('MAKE_PAYMENT_VIA_PAYTM')
	},{
		xtype: 'button',
		itemId: 'btnPaytmTechprocess',
		text:getCommonTranslation('MAKE_PAYMENT_VIA_TECH_PROCESS'),
		tooltip: getCommonTranslation('MAKE_PAYMENT_VIA_TECH_PROCESS')
	},{
		xtype: 'button',
		itemId: 'btnPaytmViaSFC',
		text:getCommonTranslation('MAKE_PAYMENT_VIA_SFC'),
		tooltip: getCommonTranslation('MAKE_PAYMENT_VIA_SFC')
	},{
		xtype:'fieldcontainer',
		items:[{
			xtype: 'hidden',
			itemId:'sfcAmountId',
			name: 'sfcAmount'
		},{
			xtype: 'customcombobox',
			width: 440,
			labelAlign: 'top',
			name: 'bank',
			itemId:'bankItemId',
			store: 'feeandpayment.receipts.DrawnOnBank',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			minChars:3,
			fieldLabel:getCommonTranslation('BANK'),
			allowBlank: false,
			style:{
				marginTop:'-10px'
			}
		}] 
	}],
	/*dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.adjustment.BillReceivable',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],*/
	columns: [{
		header : getFeeAndPaymentCommonTranslation('BILL_NO'),
		dataIndex : 'billNo',
		flex : 1,
		summaryRenderer:function(value, summaryData, dataIndex, rowIndex, colIndex, store, view){
			if(store.data.items[0].data.whetherDisplayTotal != false) {
				return getFeeAndPaymentCommonTranslation('TOTAL');
			}
		}
	/*summaryRenderer: function(value, summaryData, dataIndex) {
            return getFeeAndPaymentCommonTranslation('TOTAL');
        }*/
	},{
		header : getFeeAndPaymentCommonTranslation('BILL_DATE'),
		dataIndex : 'billHeaderBillingDate',
		flex :1,
		renderer: function(date) {
			return dateRender(date);
		}
	},{

		header : getCommonTranslation('DUE_DATE'),
		dataIndex:'billHeaderDueDate',
		flex : 1,
		renderer:function(val){		
			return dateRender(val);
		}
	}, {
		header : getCommonTranslation('FEE_PLAN'),
		dataIndex : 'feePlanName',
		flex : 1
	}, {
		header : getFeeAndPaymentCommonTranslation('FEE_HEAD'),
		dataIndex : 'feeHeadName',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('BILL_AMOUNT'),
		dataIndex : 'totalAmount',
		flex : 1,
		summaryType: 'sum',
		//align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryRenderer:function(value, summaryData, dataIndex, rowIndex, colIndex, store, view){
			if(store.data.items[0].data.whetherDisplayTotal != false) {
				return currencyRenderer(value,store.data.items[0].data.currencyId);
			}
		},
		/*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  currencyRenderer(value);
		},*/
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(record.get("currencyId"))){
				return currencyRenderer(value,record.get("currencyId"));
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('BALANCE_AMOUNT'),
		dataIndex : 'tempRemainingAmount',
		flex : 1,
		summaryType: 'sum',
		summaryRenderer:function(value, summaryData, dataIndex, rowIndex, colIndex, store, view){
			if(store.data.items[0].data.whetherDisplayTotal != false) {
				return currencyRenderer(value,store.data.items[0].data.currencyId);
			}
		},
		/*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  currencyRenderer(value);
		},*/
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(record.get("currencyId"))){
				return currencyRenderer(value,record.get("currencyId"));
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('AMOUNT_TO_PAY'),
		dataIndex : 'totalBalanceAmount',
		flex : 1,
		editing:true,
		summaryType: 'sum',
		editor : {
			xtype:'numberfield',
			name: 'totalBalanceAmount',
			itemId:'amountToBeAdjusted',
			mouseWheelEnabled:false,
			allowDecimals:false,
			enableKeyEvents:true,
			hideTrigger:true,
			minValue:0
		},  
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
				//return value;
			} else {
				meta.tdCls = 'gridInputCustomStyle'; 
				return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
			}                        
		},
		summaryRenderer:function(value, summaryData, dataIndex, rowIndex, colIndex, store, view){
			if(store.data.items[0].data.whetherDisplayTotal != false) {
				return currencyRenderer(value,store.data.items[0].data.currencyId);
			}
		}
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
		listeners : {
			beforeedit:function( editor, context, e ){
				var record = context.record;
				var getGridStore = context.grid.getStore();
				var getData = getGridStore.data.items[context.rowIdx];
				var checkedRow = context.row.firstElementChild.classList.contains('x-grid-cell-row-checker');
				
				// Ensure selection only happens through checkbox
		        if (context.grid.getSelectionModel().checkOnly && !checkedRow) {
		            return false; // Prevent editing if row is not selected via checkbox V2D-484868
		        }
		        
				if(context.field== "totalBalanceAmount") {
					if(record.data.whetherMandatoryToPay) {
						context.grid.columns[7].getEditor().setReadOnly(true);
					}else{
						context.grid.columns[7].getEditor().setReadOnly(false);
					}
				}
				var storeItems = context.grid.getStore().data.items;
				var paymentMndatoryRecArr = [];
				Ext.each(storeItems,function(rec){
					if(rec.data.whetherMandatoryToPay && rec.data.whetherActive) {
						paymentMndatoryRecArr.push(rec);
					}
				});
				paymentMndatoryRecArr.push(record);
				context.grid.getSelectionModel().select(paymentMndatoryRecArr);
				if(record.data.whetherMandatoryToPay == true) {
					//grid.getSelectionModel().select(paymentMndatoryRecArr);
					showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('MANDATORY_BILL_NOT_EDITABLE'));
				}
				if(checkedRow == false){
					return false;
				}else{	
					if(getData.data.allowPartialPayment == false ){
						return false;
					}else{
						return true;
					}	
				}
			}
		}
	}]
});