/**
 * @author Shashi Kumara
 */
Ext.define('Academia.view.sunsuccess.businessrules.BusinessRuleApplyToPeriodGrid', {
	extend: 'Ext.panel.Panel',
	alias: 'widget.businessruleapplytoperiodgrid',

	
//	title: getExaminationTranslation('PERIOD'),
	width:'100%',
	height:'100%',
	autoScroll:false,
	bodyStyle:{
		border: 0
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
    items:[{
		xtype:'label',
		itemId:'degreeClassificationNameLabel',
		margin: 10
	},{
		xtype:'grid',
		title:getExaminationTranslation('PERIOD'),
		store: 'sunsuccess.BusinessRulePeriodGridStore',
		id:'businessruleperiodid',
		border: true,
		autoScroll:false,
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS
		},
		selType:'checkboxmodel',
		selModel: {
			checkOnly : false,
			multiSelect :true,
    	    mode: 'SIMPLE'
		},
		dockedItems: [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype : 'custompagingtoolbar',
				plugins:['pagesize'],
				store: 'sunsuccess.BusinessRulePeriodGridStore',
				emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
				displayInfo : true
			}]
		}],
	  tbar: [{
			xtype: 'button',
			itemId: 'submitid',
			tooltip: getCommonTranslation('SUBMIT'),
	        scale: CONSTANTS.BUTTONSIZE,
	        disabled:true,
			text:'<div style="color: black">'+getExaminationTranslation('SUBMIT')+'</div>',
		},{
			xtype: 'button',
			itemId: 'btnReset',
			tooltip: getExaminationTranslation('RESET'),
			text:'<div style="color: black">'+getExaminationTranslation('RESET')+'</div>',
	}],
	columns: [{
		header: getExaminationTranslation('ACADEMY_LOCATION'),
		dataIndex: 'academyLocationName',
		flex:.9,
		sortable:true
	},{
		header: getExaminationTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.9,
		sortable:true
	},{
		header: getExaminationTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.9,
		sortable:true
	},{
		header: getExaminationTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.9,
		sortable:true
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
	}]
   }]
});
var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {	
	clicksToEdit: 1,
	listeners : {
		beforeedit:function( editor, context, e ){ 
		}
	}

});