/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.sunsuccess.businessrules.BusinessRuleApplyToStudentGroupAddGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.businessruleapplytostudentgroupaddgrid',
	initComponent: function() {
		var grid = this;
		//grid.addExportToolBarItems(grid, true);
		this.callParent(arguments);
	},
	store: 'sunsuccess.BusinessRuleApplyToStudentGroupAddGridStore',
	title: getCourseTxCommonTranslation('SEARCH_RESULT'),
	border: true,
	refreshStoreData: true,
	headerFix:{
    	headerFix: true,
    	portalIdsWithStructure: {
    		'businessruleapplytostudentgroupaddsearchtab,applytostudentgroupsearchtab': 1
    	}
    },
	selType:'checkboxmodel',
	selModel: {
		checkOnly : false,
		multiSelect :true,
	    mode: 'SIMPLE'
	},
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store: 'sunsuccess.BusinessRuleApplyToStudentGroupAddGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	columns: [{
		header: getCommonTranslation('SCHOLARSHIP_ID'),
		dataIndex: 'id'
	}, {
		header: getCommonTranslation('SCHOLARSHIP_NAME'),
		dataIndex: 'scholarshipName',
		flex: 1
	}, {
		header: getCommonTranslation('SCHOLARSHIP_TYPE'),
		dataIndex: 'scholarshipType'
	}, {
		header: getCommonTranslation('ORG_NAME'),
		dataIndex: 'organizationName',
		flex: 1
	}, {
		header: getCommonTranslation('SCHOLARSHIP_AMOUNT_TYPE'),
		dataIndex: 'scholarshipAmountType',
		flex: 1
	}, {
		header: getCommonTranslation('SCHOLARSHIP_STATUS'),
		dataIndex: 'scholarshipStatus',
		flex: 1,
		renderer: function(value, meta, record) {
        	if(!isNullOrEmpty(value) && value) {
        		return "<span style = 'color:#009e0f;'>Active</span>";
			}
        	else {
				return "<span style = 'color:#cc0000;'>InActive</span>";
			}                     
        }
	},{
		header: getCommonTranslation('NO_OF_AWARDEES'),
		dataIndex: 'scholarshipAwardees',
		renderer: function(value, meta, record) {
        	if(!isNullOrEmpty(value) && value != 0) {
        		return '<a href="#">'+value+'</a>';
			}
        	else if(!isNullOrEmpty(value) && value == 0) {
        		return value;
			}
        	else {
				return "-";
			}                     
        }
	}, {
		header: getCommonTranslation('ELIGIBILITY_CRITERIA'),
		dataIndex: 'droolAgenda',
		hidden:true
	}]
});