Ext.define('Academia.view.survey.createSurvey.CreateSurveyGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.createsurveygrid',
	title: getCommonTranslation('LIST_OF_SURVEY_TEMPLATE'),
	border: true,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'createsurveystructure':1
		}
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon',
		disabled: true
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header: getCommonTranslation('SURVEY_ID'),
		dataIndex: 'sid',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('SURVEY_NAME'),
		dataIndex: 'surveyls_title',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('START_DATE'),
		dataIndex: 'startdate',
		flex:.3,
		sortable: true
	}, {
		header: getCommonTranslation('END_DATE'),
		dataIndex: 'expires',
		flex:.3,
		sortable: true
	}, {
		header: getCommonTranslation('ANONYMOUS'),
		dataIndex: 'isAnonymized',
		flex:.3,
		sortable: true,
		renderer : function(value){
			if(value == true){
				return 'Yes';
			}else if(value == false){
				return 'No';
			}else{
				return '';
			}
		}
	},{
		header: getCommonTranslation('STATUS'),
		dataIndex: 'active',
		flex:.3,
		sortable: true,
		renderer : function(value){
			if(value == "Y"){
				return getCommonTranslation('ACTIVE');
			}else{
				return getCommonTranslation('INACTIVE');
			}
		}
	},{
		header: getCommonTranslation('NO_OF_QUESTIONS'),
		dataIndex: 'noOfQuestions',
		flex:.3,
		sortable: true
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.survey.CreateSurveyGridStore');
	}
});