Ext.define('Academia.view.survey.sendSurvey.SendSurveyPBSFilter', {
	extend: 'Ext.form.Panel',
    alias: 'widget.sendsurveypbsfilter',
    plugins : "formlabelrequired",
    autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
    items: [{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'surveyNamePBS',
			itemId: 'surveyNamePBSItemId',
			fieldLabel:getCommonTranslation('SURVEY_NAME'),
			store: Ext.create('Academia.store.survey.SpecificSurveyListStore'),	    
            valueField:'surveyId',
            displayField:'surveyName',
			width:226,
			disabled:false,
			typeAhead : true,
			forceSelection : true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			matchFieldWidth:true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
			},
			listeners:{
				afterrender: function(combo) {
		            // Ensure that the store is loaded and ready
		            var store = combo.getStore();
		            
		            // Check if the store has not been loaded yet
		            if (store) {
		                store.on('beforeload', function(store) {
		                    store.getProxy().extraParams = {
		                    	isPbs: true // Pass additional params before loading
		                    };
		                });
		            }
		        }
			}
		},{
			xtype : 'customcombobox',
			name : 'academyLocationPBS',
			itemId:'academyLocationPBS',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:Ext.create('Academia.store.coursetransaction.studentenrollment.AcademyLocationsByAdmissionStore'),
			valueField : 'id',
			displayField : 'value',
			width: 460,
			typeAhead : false,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			editable:false,
			allowBlank: false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'programIdPBS',
			itemId: 'programIdPBS',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			store:Ext.create('Academia.store.feeandpayment.ALProgramSearchCombo'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:false,
			forceSelection:true ,
		    typeAhead:false,
		    disabled: true,
			allowBlank: false,
			editable: false,
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{value}' +
	                    '</div>';
	                }
	            }
		},{
			xtype: 'customcombobox',
			name: 'batchIdPBS',
			fieldLabel: getCourseTxCommonTranslation('BATCH'),
			itemId:'batchIdPBS',
			store:Ext.create('Academia.store.examconcession.ExamConcessionBatchStore'),
			displayField: 'value',
			valueField: 'id',
			disabled : true,
			typeAhead:false,
			forceSelection:true,
			editable : false,
			allowBlank: false,
		},{
			xtype: 'customcombobox',
			name: 'periodIdPBS',
			itemId:'periodIdPBS',
			fieldLabel: getCourseTxCommonTranslation('PERIOD'),
			store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCourseParameterizationPeriodStore'),
			displayField: 'value',
			valueField: 'id',
			disabled : true,
			allowBlank: false,
			typeAhead:true,
			forceSelection:true,
			editable : false 
		}]
	},{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items:[{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('SECTION'),
			width: 226,
			labelAlign: 'top',
			name : 'sectionIdPBS',
			itemId : 'sectionIdPBS',
			store:Ext.create('Academia.store.attendance.SectionAndFacultyByPeriodID'),
			displayField : 'sectionCode',
			valueField : 'sectionId',
			typeAhead : true,
		    disabled:true,
			forceSelection : true,
			editable: false
		},{
			xtype: 'customcombobox',
			name: 'whetherAnonymousPBSLevel',
			itemId: 'whetherAnonymousPBSLevelItemId',
			fieldLabel: getCBTranslation('survey_whetherAnonymous'),
			hidden: true,
			store: Ext.create('Ext.data.Store', {
		        fields: ['code', 'value'],
		        data: [
		            { code: 'Y', value: getCommonTranslation("YES") },  // For Anonymous
		            { code: 'N', value: getCommonTranslation("NO") }    // For Non-Anonymous
		        ]
		    }),	    
            valueField:'code',
            displayField:'value',
			width:226,
			disabled:false,
			typeAhead : false,
			forceSelection : true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			editable:false,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
			}
		}]
	}, {
		xtype:'fieldcontainer',
		width: '100%',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchPBSBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			formBind:true,
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetPBSBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});