Ext.define('Academia.view.survey.surveyReport.PBSSurveyReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.pbssurveyreportgrid',
	title: getCommonTranslation('REPORT_ANALYTICS'),
	border: true,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'pbssurveyreport':1
		}
	},
	tbar: ['->',{
		xtype: 'button',
		text:getCommonTranslation('EXPORT_REPORT'),
		itemId:'exportReportPBS',
		tooltip :getCommonTranslation('EXPORT_REPORT'),
		disabled:true
	}],
	columns: [{
		header: getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex: 'academyLocationName',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.3,
		sortable: true
	}, {
		header: getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.3,
		sortable: true
	}, {
		header: getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('NO_OF_QUESTIONS'),
		dataIndex: 'noOfQuestions',
		flex:.3,
		sortable: true,
		renderer:function(value,rec){
			if(!isNullOrEmpty(value)){
				return '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header: getCBTranslation('survey_whetherAnonymous'),
		dataIndex: 'isAnonymized',
		flex:.3,
		sortable: true,
		renderer : function(value){
			if(!isNullOrEmpty(value) && (value=="true" || value==true)){
				return  getCommonTranslation('YES');
			}else{
				return getCommonTranslation('NO');
			}
		}
	},{
		header: getCommonTranslation('PARTICIPATION'),
		dataIndex: 'participationPercentage',
		flex:.3,
		sortable: true,
		renderer : function(value){
			return value+" %";
		}
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$, false);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.survey.PBSSurveyReportGridStore');
	}
});