/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.transport.vehicle.EmissionHistoryDetailWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.emissionhistorydetailwin',
	title: getTransportTranslation('EMISSION_DETAILS'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'idgeneratorformwin',
		itemId:'emissionhistorydetailwin',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width:226
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'emissionVendor',
				itemId:'emissionVendor',
				fieldLabel: getTransportTranslation('EMISSION_VENDER'),  // Pollution Control Center Name
				maxLength:100,
				enforceMaxLength : true
			},{
				xtype: 'textfield',
				fieldLabel: getTransportTranslation('EMISSION_DOCUMENT_WITH'),  // Pollution Control Authority
				name: 'emissionPolicyWith',
				itemId:'emissionPolicyWith',
				maxLength:100,
				enforceMaxLength : true,
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'datefield',
				name:'emissionToBeCheckOn',
				itemId:'emissionToBeCheckOn',
				allowBlank : false,
				fieldLabel:getTransportTranslation('EMISSION_TO_BE_CHECKED_ON'),
				listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat: CONSTANTS.DATE_FORMAT
			},{
				xtype: 'datefield',
				name: 'emissionCheckDate',
				itemId:'emissionCheckDate',
				maxValue: new Date(),
				fieldLabel: getTransportTranslation('EMISSION_CHECKED_ON'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.DATE_FORMAT
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'emissionCurrency',
				itemId:'emissionCurrency',
				fieldLabel: getTransportTranslation('EMISSION_CURRENCY'),
				store: 'organization.BaseCurrencyStore',
				valueField: 'id',
				displayField: 'name',
				allowBlank: true,
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'numberfield',
				name: 'emissionCost',
				itemId:'emissionCost',
				fieldLabel: getTransportTranslation('EMISSION_CHECK_COST'), // ​Certification Cost
				maxLength: 8,
				enforceMaxLength: true,
		        hideTrigger: true,
		        keyNavEnabled: false,
		        mouseWheelEnabled: false,
		        allowExponential: false,
		        minValue:0,
		        decimalPrecision : 2
			}]
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});