/**
 * @author Rajkumar.Patidar
 */
Ext.define('Academia.view.transport.vehicle.VehicleDetailForm', {
	extend:'Academia.view.common.DynamicFieldForm',
	alias: 'widget.vehicledetailform',
	autoScroll: false,
	frame: false,
	border:false,
	plugins : "formlabelrequired",
	layout:'vbox',
	//cls:'customSearchPanel',
	bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL} ,
	items: [{
		xtype:'hidden',
		name:'id'
	},{
		xtype:'hidden',
		name:'resourceId'
	},{
		xtype:'hidden',
		name:'listButtonId',
		itemId:'listButtonId'
	},{
		xtype: 'panel',
		layout:'vbox',
		width: '100%',
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width: '100%',
			defaults: {
				width: 226,
				xtype: 'textfield',
				labelAlign: 'top'
			},
			items: [{
				fieldLabel: getTransportTranslation('VEHICLE_CODE'),
				name: 'vehicleCode',
				readOnly : true,
				itemId:'vehicleCode',
				maxLength: 45
			},{
				fieldLabel: getTransportTranslation('VEHICLE_NO'),
				name: 'vehicleNumber',
				itemId:'vehicleNumber',
				allowBlank : false,
				maxLength: 60
			},{
				fieldLabel: getTransportTranslation('MODEL'),
				name: 'model',
				itemId:'model',
				maxLength: 45
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width: '100%',
			readOnly : true,
			defaults: {
				width: 226,
				xtype: 'textfield',
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				fieldLabel: getTransportTranslation('VEHICLE_TYPE'),
				name: 'subType',
				itemId:'subType',
				readOnly : true,
				store: 'transport.vehicle.VehicleSubType',
				displayField: 'value',
				valueField: 'id',
				forceSelection:true
			},{
				xtype: 'numberfield',
				allowExponential:false,
				hideTrigger: true,
				keyNavEnabled: false,
				minValue : 0,
				minLength: 1,
				maxLength: 3,
				fieldLabel: getTransportTranslation('CAPACITY'),
				name: 'capacity',
				itemId:'capacity',
				allowBlank : false
			},{
				xtype: 'customcombobox',
				fieldLabel: getTransportTranslation('HAS_A_REGULAR_ROUTE'),
				name: 'hasARegularRoute',
				itemId:'hasARegularRoute',
				store: 'transport.vehicle.VehicleYesNoEnum',
				displayField: 'value',
				valueField: 'id',
				forceSelection:true,
				editable: false
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width: '100%',
			defaults: {
				width: 226,
				xtype: 'textfield',
				labelAlign: 'top'
			},
			items: [{
				xtype: 'datefield',
				name: 'lastServiced',
				itemId: 'lastServiced',
				fieldLabel: getTransportTranslation('LAST_SERVICED'),
				vtype: 'daterange',
				maxValue: new Date(),
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
					}
				}
			},{
				fieldLabel: getTransportTranslation('SERVICED_BY'),
				name: 'serviceBy',
				itemId:'serviceBy',
				maxLength: 255
			},{
				xtype: 'button',
				itemId: 'serviceByAddress',
				style:{marginTop:'30px'},
				text: getCommonTranslation('ADDRESS'),
				tooltip: getCommonTranslation('ADD'),
				ui: 'CustomBtnThird',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype:'hidden',
				name:'serviceFromAddressId',
				itemId:'serviceFromAddressId'
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width: '100%',
			defaults: {
				width: 226,
				xtype: 'textfield',
				labelAlign: 'top'
			},
			items: [{
				fieldLabel: getTransportTranslation('PURCHASED_FROM'),
				name: 'purchaseFrom',
				itemId:'purchaseFrom',
				maxLength: 255
			},{
				xtype: 'button',
				itemId: 'purchasedFromAddress',
				style:{marginTop:'30px'},
				text: getCommonTranslation('ADDRESS'),
				tooltip: getCommonTranslation('ADD'),
				ui: 'CustomBtnThird',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype:'hidden',
				name:'purchaseFromAddressId',
				itemId:'purchaseFromAddressId'
			}]
		},{
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 460,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'textarea',
                name: 'transVehicleDescriptionId',
                itemId: 'transVehicleDescriptionId',
                width: 460,
                maxLength: 2000,
                fieldLabel: getTransportTranslation('TRANS_VEHICLE_DESCRIPTION')
            }]
        },
        {
			xtype:'fieldset',
			title: getTransportTranslation('TRANS_LICENCE_AND_REGISTRATION_DETAILS'),
			collapsible: true,
			collapsed:true,
			width: '100%',
			layout:'vbox',
			itemId:'vehicleLicenceAndRegistrationDetailId',
			frame:false,
			items:[{
				xtype: 'fieldcontainer',
				style:{marginTop:'10px'},
				layout: 'hbox',
				width: '100%',
				defaults: {
					width: 226,
					xtype: 'textfield',
					labelAlign: 'top'
				},
				items: [{
					xtype:'hidden',
					name:'licenceRegistrationId',
					itemId:'licenceRegistrationId'
				},{
					xtype: 'textfield',
					fieldLabel: getTransportTranslation('TRANS_LICENCE_DISK_NO'),
					name: 'transLicenceDiskNo',
					itemId:'transLicenceDiskNo',
					maxLength:100
				},{
					xtype: 'textfield',
					fieldLabel: getTransportTranslation('TRANS_LICENCE_NO'),
					name: 'transLicenceNo',
					itemId:'transLicenceNo',
					maxLength:100
				},{
					xtype: 'textfield',
					fieldLabel: getTransportTranslation('TRANS_VEHICLE_LICENCE_NO'),
					name: 'transVehicleLicenceNo',
					itemId:'transVehicleLicenceNo',
					maxLength:100
				}]
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				width: '100%',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items: [{
					xtype: 'textfield',
					fieldLabel: getTransportTranslation('TRANS_VIN'),
					name: 'transVin',
					itemId:'transVin',
					maxLength:100
				},{
					xtype: 'textfield',
					fieldLabel: getTransportTranslation('TRANS_ENGINE_NO'),
					name: 'transEngineNo',
					itemId:'transEngineNo',
					maxLength:100
				},{
					xtype: 'numberfield',
					fieldLabel: getTransportTranslation('TRANS_FEES'),
					name: 'transFees',
					itemId:'transFees',
					maxLength: 10,
					minValue : 0,
		            enforceMaxLength: true,
		            hideTrigger: true,
		            keyNavEnabled: false,
		            mouseWheelEnabled: false,
		            allowExponential: false,
		            decimalPrecision : 2
				}]
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				width: '100%',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items: [{
					xtype: 'numberfield',
					fieldLabel: getTransportTranslation('TRANS_GVM_IN_KG'),
					name: 'transGVM',
					itemId:'transGVM',
		            maxLength: 10,
		            minValue : 0,
		            enforceMaxLength: true,
		            hideTrigger: true,
		            keyNavEnabled: false,
		            mouseWheelEnabled: false,
		            allowExponential: false,
		            decimalPrecision : 3
				},{
					xtype: 'numberfield',
					fieldLabel: getTransportTranslation('TRANS_TARE_IN_KG'),
					name: 'transTARE',
					itemId:'transTARE',
		            maxLength: 10,
		            minValue : 0,
		            enforceMaxLength: true,
		            hideTrigger: true,
		            keyNavEnabled: false,
		            mouseWheelEnabled: false,
		            allowExponential: false,
		            decimalPrecision : 3
				},{
					xtype: 'datefield',
					name:'transDateOfExpiry',
					itemId:'transDateOfExpiry',
					fieldLabel:getTransportTranslation('TRANS_DATE_OF_EXPIRY'),
					//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					vtype : 'daterange'
				}]
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				width: '100%',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items: [{
					xtype: 'datefield',
					name: 'transDateOfTest',
					itemId:'transDateOfTest',
					fieldLabel: getTransportTranslation('TRANS_DATE_OF_TEST'),
					vtype: 'daterange',
					maxValue: new Date(),
					//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					vtype : 'daterange'
				},{
					xtype: 'numberfield',
					fieldLabel: getTransportTranslation('TRANS_EXPIRY_ALERT_BEFORE_N_DAYS'),
					name: 'transExpiryAlertBeforeNdays',
					itemId:'transExpiryAlertBeforeNdays',
					minValue : 0,
					maxValue: 100,
					maxLength: 3
				}]
			}],
			listeners:{
				render: function(myfieldset){
					myfieldset.setMargin('-10px');
				}
			}
		},{
			xtype:'fieldset',
			title: getTransportTranslation('INSURANCE_DETAILS'),
			collapsible: true,
			collapsed:true,
			itemId:'insuranceDetailId',
			width: '100%',
			layout:'vbox',
			frame:false,
			items:[{
				xtype: 'fieldcontainer',
				style:{marginTop:'10px'},
				layout: 'hbox',
				width: '100%',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items: [{
					xtype:'hidden',
					name:'insuranceId',
					itemId:'insuranceId'
				},{
					xtype: 'textfield',
					fieldLabel: getTransportTranslation('INSURED_BY'),
					name: 'insuredBy',
					itemId:'insuredBy',
					maxLength:100
				},{
					xtype: 'button',
					itemId: 'insuranceAddress',
					style:{marginTop:'30px'},
					text: getCommonTranslation('ADDRESS'),
					tooltip: getCommonTranslation('ADD'),
					ui: 'CustomBtnThird',
					scale: CONSTANTS.BUTTONSIZE
				},{
					xtype:'hidden',
					name:'insuranceAddressId',
					itemId:'insuranceAddressId'
				}]
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				width: '100%',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items: [{
					xtype: 'textfield',
					fieldLabel: getTransportTranslation('POLICY_HOLDER_NAME'),
					name: 'policyHolderName',
					itemId:'policyHolderName',
					maxLength:100
				},{
					xtype: 'textfield',
					fieldLabel: getTransportTranslation('POLICY_NUMBER'),
					name: 'policyNumber',
					itemId:'policyNumber',
					maxLength:100
				},{
					xtype: 'datefield',
					name: 'inceptionDate',
					itemId:'inceptionDate',
					fieldLabel: getTransportTranslation('INCEPTION_DATE'),
					vtype: 'daterange',
					maxValue: new Date(),
					//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
				}]
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				width: '100%',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items: [{
					xtype: 'datefield',
					name:'insuranceValidFrom',
					itemId:'insuranceValidFrom',
					endDateField : 'insuranceValidTill',
					maxValue: new Date(),
					fieldLabel:getTransportTranslation('INSURANCE_VALID_FROM'),
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						},
						blur: function(field) {
							var insuranceValidFrom = field;
							var insuranceValidTill = field.up().down('#insuranceValidTill').getValue();
							var currentDate = new Date();
							currentDate.setHours(0);
							currentDate.setMinutes(0);
							currentDate.setSeconds(0);
							if (!isNullOrEmpty(insuranceValidTill)) {
								if (insuranceValidTill >= currentDate) {
									insuranceValidFrom.setMaxValue(currentDate);
								} else {
									insuranceValidFrom.setMaxValue(insuranceValidTill);
								}
							} else {
								insuranceValidFrom.setMaxValue(currentDate);
							}
						}
					},
					//--submitFormat: CONSTANTS.DATE_FORMAT,
					vtype : 'daterange'
				},{
					xtype: 'datefield',
					name:'insuranceValidTill',
					itemId:'insuranceValidTill',
					fieldLabel:getTransportTranslation('INSURANCE_VALID_TILL'),
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						},
						blur: function(field) {
							var insuranceValidFrom = field.up().down('#insuranceValidFrom');
							var insuranceValidTill = field.getValue();
							var currentDate = new Date();
							currentDate.setHours(0);
							currentDate.setMinutes(0);
							currentDate.setSeconds(0);
							if (!isNullOrEmpty(insuranceValidTill)) {
								if (insuranceValidTill >= currentDate) {
									insuranceValidFrom.setMaxValue(currentDate);
								} else {
									insuranceValidFrom.setMaxValue(insuranceValidTill);
								}
							} else {
								insuranceValidFrom.setMaxValue(currentDate);
							}
						}
					},
					//--submitFormat: CONSTANTS.DATE_FORMAT,
					startDateField :'insuranceValidFrom',
					vtype : 'daterange'
				},{
					xtype: 'customcombobox',
					name:'premiumPaymentCycle',
					itemId:'premiumPaymentCycle',
					fieldLabel:getTransportTranslation('PREMIUM_PAYMENT_CYCLE'),
					store: 'transport.vehicle.MonthlyAnnualStore',
					valueField: 'name',
					displayField: 'value',
					allowBlank:true,
					typeAhead:true,
					reference: 'fiddleCombo',
					forceSelection:true,
					enableKeyEvents:true,
					editable: false,
					trigger1Cls: 'x-form-clear-trigger', 
					trigger2Cls: 'x-form-arrow-trigger',
					onTrigger1Click: function() { this.clearValue(); },
				}]
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				width: '100%',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items: [{
					xtype: 'customcombobox',
					name:'insuranceCurrency',
					itemId:'insuranceCurrency',
					fieldLabel:getTransportTranslation('INSURANCE_CURRENCY'),
					store: 'organization.BaseCurrencyStore',
					valueField: 'id',
					displayField: 'name',
					allowBlank:true,
					typeAhead:true,
		            editable: false,
					forceSelection:true
				},{
					xtype: 'numberfield',
					fieldLabel: getTransportTranslation('INSURANCE_COST'),
					name: 'insuranceCost',
					itemId:'insuranceCost',
					maxLength:8,
					enforceMaxLength: true,
			        hideTrigger: true,
			        minValue : 0,
			        keyNavEnabled: false,
			        mouseWheelEnabled: false,
			        allowExponential: false,
			        decimalPrecision : 2
				},{
					xtype: 'datefield',
					name:'insurancePaidOn',
					itemId:'insurancePaidOn',
					fieldLabel:getTransportTranslation('INSURANCE_PAID_ON'),
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					//--submitFormat: CONSTANTS.DATE_FORMAT
				}]
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				width: '100%',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items: [/*{
					xtype: 'textfield',
					fieldLabel: getTransportTranslation('INSURANCE_ALERT_MODEL'),
					name: 'insuranceAlertModel',
					itemId:'insuranceAlertModel',
					maxLength:255
				},*/{
					xtype: 'numberfield',
					fieldLabel: getTransportTranslation('INSURANCE_ALERT_BEFORE_N_DAYS'),
					name: 'insuranceAlertBeforeNdays',
					itemId:'insuranceAlertBeforeNdays',
					minValue : 0,
					maxValue:100,
					maxLength:3
				},{
					xtype: 'textfield',
					fieldLabel: getTransportTranslation('INSURANCE_POLICY_WITH'),
					name: 'insurancePolicyWith',
					itemId:'insurancePolicyWith',
					maxLength:100
				}]
			},{
			xtype:'fieldcontainer',
			labelSeparator : ':',
			fieldLabel: getTransportTranslation('BROKER_CONTACT_NO'),
			itemId:'brokerMobileCoutryCodeContainer',
			layout:'hbox',
			labelAlign:'top',
			items:[{
				xtype: 'customcombobox',
				valueField: 'isdCode',
				displayField: 'isdCode',
				store: Ext.create('Academia.store.common.CountryStore'),
				itemId:'brokerMobileCountryCode',
				triggerAction: 'all',
				name: 'brokerMobileCountryCode',
				width: 80,
				//typeAhead:true,
				forceSelection:true,
				emptyText: 'Code', 
				minChars: 1
			},{
				xtype: 'numberfield',
				//fieldLabel:getCommonTranslation('ADDRESS_MOBILE_NO'),
				name:'brokerMobileNumber',
				itemId:'brokerMobileNumber',
				minLength: 6,
				maxLength: 11,
				spinUpEnabled : false,
				spinDownEnabled : false,
				hideTrigger : true,
				enforceMaxLength : true,
				width:135
			}]}],
			listeners:{
				render: function(myfieldset){
					myfieldset.setMargin('-10px');
				}
			}
		},{
			xtype:'fieldset',
			title: getTransportTranslation('EMISSION_DETAILS'),  // ​Emission Check Details
			collapsible: true,
			width: '100%',
			itemId:'emissionDetailId',
			layout:'vbox',
			collapsed:true,
			frame:false,
			items:[{
				xtype: 'fieldcontainer',
				style:{marginTop:'10px'},
				layout: 'hbox',
				width: '100%',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items: [{
					xtype:'hidden',
					name:'emissionId',
					itemId:'emissionId'
				},{
					xtype:'hidden',
					name:'emissionAddressId',
					itemId:'emissionAddressId'
				},{
					xtype: 'textfield',
					fieldLabel: getTransportTranslation('EMISSION_VENDER'),   // Pollution Control Center Name
					name: 'emissionVender',
					itemId:'emissionVender',
					maxLength: 100
				},{
					xtype: 'button',
					itemId: 'emissionAddress',
					style:{marginTop:'30px'},
					text: getCommonTranslation('ADDRESS'),
					tooltip: getCommonTranslation('ADD'),
					ui: 'CustomBtnThird',
					scale: CONSTANTS.BUTTONSIZE
				}]
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				width: '100%',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items: [{
					xtype: 'textfield',
					fieldLabel: getTransportTranslation('EMISSION_DOCUMENT_WITH'), // Pollution Control Authority
					name: 'emissionDocumentWith',
					itemId:'emissionDocumentWith',
					maxLength: 100
				},{
					xtype: 'datefield',
					name:'emissionToBeCheckedOn',
					itemId:'emissionToBeCheckedOn',
					fieldLabel:getTransportTranslation('EMISSION_TO_BE_CHECKED_ON'), //Valid Date
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					//--submitFormat: CONSTANTS.DATE_FORMAT
				},{
					xtype: 'datefield',
					name:'emissionChkedOn',
					itemId:'emissionChkedOn',
					maxValue: new Date(),
					fieldLabel:getTransportTranslation('EMISSION_CHECKED_ON'),   //​Test Date
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					//--submitFormat: CONSTANTS.DATE_FORMAT
				}]
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				width: '100%',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items: [{
					xtype: 'customcombobox',
					name:'emissionCurrency',
					itemId:'emissionCurrency',
					fieldLabel:getTransportTranslation('EMISSION_CURRENCY'),
					store: 'organization.BaseCurrencyStore',
					displayField: 'name',
					valueField: 'id',
					typeAhead:true,
					forceSelection:true
				},{
					xtype: 'numberfield',
					fieldLabel: getTransportTranslation('EMISSION_CHECK_COST'),  // ​Certification Cost
					name: 'emissionCheckCost',
					itemId:'emissionCheckCost',
					maxLength: 8,
					enforceMaxLength: true,
			        hideTrigger: true,
			        keyNavEnabled: false,
			        mouseWheelEnabled: false,
			        minValue : 0,
			        allowExponential: false,
			        decimalPrecision : 2
				},{
					xtype: 'numberfield',
					fieldLabel: getTransportTranslation('EMISSION_ALERT_BEFORE_N_DAYS'),  //Expiry Alert Before (In Days)
					name: 'emissionAlertBeforeNdays',
					itemId:'emissionAlertBeforeNdays',
					minValue : 0,
					maxValue : 100,
					maxLength: 3
				}/*,{
					xtype: 'textfield',
					fieldLabel: getTransportTranslation('EMISSION_ALERT_MODE'),
					name: 'emissionAlertModel',
					itemId:'emissionAlertModel',
					maxLength: 255
				}*/]
			}/*,{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				width: '100%',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items: [{
					xtype: 'numberfield',
					fieldLabel: getTransportTranslation('EMISSION_ALERT_BEFORE_N_DAYS'),  //Expiry Alert Before (In Days)
					name: 'emissionAlertBeforeNdays',
					itemId:'emissionAlertBeforeNdays',
					minValue : 0,
					maxLength: 255
				}]
			}*/],
			listeners:{
				render: function(myfieldset){
					myfieldset.setMargin('-10px');
				}
			}
		},{
			xtype:'fieldset',
			title: getTransportTranslation('ROAD_TAX_DETAILS'),
			collapsible: true,
			collapsed:true,
			itemId:'roadTaxDetailId',
			width: '100%',
			layout:'vbox',
			frame:false,
			items:[{
				xtype: 'fieldcontainer',
				style:{marginTop:'10px'},
				layout: 'hbox',
				defaults: {
					width: 226,
					xtype: 'textfield',
					labelAlign: 'top'
				},
				items: [{
					xtype:'hidden',
					name:'roadTaxId',
					itemId:'roadTaxId'
				},{
					xtype: 'textfield',
					fieldLabel: getTransportTranslation('ROAD_TAX_AUTHORITY'),
					name: 'roadTaxVender',
					itemId:'roadTaxVender',
					maxLength: 100
				},{
					xtype: 'button',
					itemId: 'roadTaxAddress',
					style:{marginTop:'30px'},
					text: getCommonTranslation('ADDRESS'),
					tooltip: getCommonTranslation('ADD'),
					ui: 'CustomBtnThird',
					scale: CONSTANTS.BUTTONSIZE
				},{
					xtype:'hidden',
					name :'roadTaxAddressId',
					itemId : 'roadTaxAddressId'
				}]
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				width: '100%',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items: [{
					xtype: 'textfield',
					fieldLabel: getTransportTranslation('ROAD_TAX_DOCUMENT_WITH'), //Road Tax Agent
					name: 'roadTaxDocumentWith',
					itemId:'roadTaxDocumentWith',
					maxLength: 100
				},{
					xtype: 'datefield',
					name:'roadTaxValidFrom',
					itemId:'roadTaxValidFrom',
					endDateField : 'roadTaxValidTill',
					maxValue: new Date(),
					fieldLabel:getTransportTranslation('ROAD_TAX_VALID_FROM'), //​Valid From
					//--submitFormat: CONSTANTS.DATE_FORMAT,
					vtype : 'daterange',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						},
						blur: function(field) {
							var roadTaxValidFrom = field;
							var roadTaxValidTill = field.up().down('#roadTaxValidTill').getValue();
							var currentDate = new Date();
							currentDate.setHours(0);
							currentDate.setMinutes(0);
							currentDate.setSeconds(0);
							if (!isNullOrEmpty(roadTaxValidTill)) {
								if (roadTaxValidTill >= currentDate) {
									roadTaxValidFrom.setMaxValue(currentDate);
								} else {
									roadTaxValidFrom.setMaxValue(roadTaxValidTill);
								}
							} else {
								roadTaxValidFrom.setMaxValue(currentDate);
							}
						}
					}
				},{
					xtype: 'datefield',
					name:'roadTaxValidTill',
					itemId:'roadTaxValidTill',
					fieldLabel:getTransportTranslation('ROAD_TAX_VALID_TILL'),   //Valid Till
					//--submitFormat: CONSTANTS.DATE_FORMAT,
					starttDateField : 'roadTaxValidFrom',
					vtype : 'daterange',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						},
						blur: function(field) {
							var roadTaxValidFrom = field.up().down('#roadTaxValidFrom');
							var roadTaxValidTill = field.getValue();
							var currentDate = new Date();
							currentDate.setHours(0);
							currentDate.setMinutes(0);
							currentDate.setSeconds(0);
							if (!isNullOrEmpty(roadTaxValidTill)) {
								if (roadTaxValidTill >= currentDate) {
									roadTaxValidFrom.setMaxValue(currentDate);
								} else {
									roadTaxValidFrom.setMaxValue(roadTaxValidTill);
								}
							} else {
								roadTaxValidFrom.setMaxValue(currentDate);
							}
						}
					}
				}]
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				width: '100%',
				defaults: {
					width: 226,

					labelAlign: 'top'
				},
				items: [{
					xtype: 'customcombobox',
					name:'roadTaxCurrency',
					itemId:'roadTaxCurrency',
					fieldLabel:getTransportTranslation('ROAD_TAX_CURRENCY'),
					store: 'organization.BaseCurrencyStore',
					displayField: 'name',
					valueField: 'id',
					typeAhead:true,
					forceSelection:true,
					editable:false
				},{
					xtype: 'numberfield',
					fieldLabel: getTransportTranslation('ROAD_TAX_COST'),
					name: 'roadTaxCost',
					itemId:'roadTaxCost',
					maxLength: 8,
					enforceMaxLength: true,
			        hideTrigger: true,
			        keyNavEnabled: false,
			        mouseWheelEnabled: false,
			        minValue : 0,
			        allowExponential: false,
			        decimalPrecision : 2
				},{
					xtype: 'datefield',
					name:'roadTaxPaidOn',
					itemId:'roadTaxPaidOn',
					fieldLabel:getTransportTranslation('ROAD_TAX_PAID_ON'),
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					//--submitFormat: CONSTANTS.DATE_FORMAT
				}]
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				width: '100%',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items: [/*{
					xtype: 'textfield',
					fieldLabel: getTransportTranslation('ROAD_TAX_ALERT_MODE'),
					name: 'roadTaxAlertModel',
					itemId:'roadTaxAlertModel',
					maxLength: 100
				},*/{
					xtype: 'numberfield',
					fieldLabel: getTransportTranslation('ROAD_TAX_ALERT_BEFORE_N_DAYS'), //Expiry Alert Before (In Days)
					name: 'roadTaxAlertBeforeNdays',
					itemId:'roadTaxAlertBeforeNdays',
					minValue : 0,
					maxValue : 100,
					maxLength: 3
				}]
			}],
			listeners:{
				render: function(myfieldset){
					myfieldset.setMargin('-10px');
				}
			}
		},{
			xtype: 'fieldcontainer',
			style : {marginTop:'0px'},
			width: 'auto',
			items: [{
				xtype: 'button',
				text: getTransportTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getTransportTranslation('RESET'),
				hidden:true,
				itemId: 'btnCancel',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});