var popup = document.getElementById("chatPopup");
var btn = document.getElementById("openChatBtn");
var chatBody = document.getElementById("chatBody");
var sendSound = document.getElementById("sendSound");
var minimizedBar = document.getElementById("minimizedBar");
var chatIcon = document.querySelector('.chatbot-icon');
var responseInProgress = false;
var loggedInUser = window.chatbotUserContext && window.chatbotUserContext.loggedInUser;
var retryInProgress = false;
var rawMarkdown = '';
var lastYouMessage = '';
var youMessages = '';
var reloginFailureCount = 0;
var userScrolled = false;
var isInternalScroll = false;
var scrollPauseTimer = null;
var isDragging = false;
var dragStarted = false;
var offsetX, offsetY, lastDraggedTop, lastDraggedLeft;

function getViewportWidth() {
    return window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
}

function getViewportHeight() {
    return window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight;
}


var targetEl = null; // element currently being dragged

function enableDrag(el) {
  el.addEventListener('mousedown', function (e) {
    isDragging = true;
    dragStarted = false;
    targetEl = el;

    // Calculate offset based on element clicked
    offsetX = e.clientX - el.getBoundingClientRect().left;
    offsetY = e.clientY - el.getBoundingClientRect().top;

    el.style.transition = "none"; // disable animation during drag
    el.style.position = "fixed";  // ensure it’s draggable in viewport
  });
}

document.addEventListener('mousemove', function (e) {
  if (!isDragging || !targetEl) return;
  
  if(popup.className.indexOf("expanded") !== -1) return;
  // Detect if real dragging started (ignore tiny movements)
  if (!dragStarted && (Math.abs(e.movementX) > 3 || Math.abs(e.movementY) > 3)) {
    dragStarted = true;
  }

  if (dragStarted) {
	  targetEl.style.left = (e.clientX - offsetX) + "px";
	  targetEl.style.top = (e.clientY - offsetY) + "px";
	  targetEl.style.bottom = "auto";
	  targetEl.style.right = "auto";
  }
  
  if (dragStarted) {
      var newLeft = e.clientX - offsetX;
      var newTop = e.clientY - offsetY;
      
      // Keep element within viewport bounds
      var viewportWidth = getViewportWidth();
      var viewportHeight = getViewportHeight();
      var elementWidth = targetEl.offsetWidth || 0;
      var elementHeight = targetEl.offsetHeight || 0;
      
      var constrainedLeft = Math.max(0, Math.min(newLeft, viewportWidth - elementWidth));
      var constrainedTop = Math.max(0, Math.min(newTop, viewportHeight - elementHeight));
      
      targetEl.style.left = constrainedLeft + "px";
      targetEl.style.top = constrainedTop + "px";
      targetEl.style.bottom = "auto";
      targetEl.style.right = "auto";

      // Save last dragged position
      lastDraggedLeft = constrainedLeft + "px";
      lastDraggedTop = constrainedTop + "px";
  }
});

//Also update the mouseup handler to reset dragStarted properly
document.addEventListener('mouseup', function (e) {
    if (targetEl) {
        targetEl.style.transition = "all 0.2s ease"; // smooth drop effect
        
        // Add a small delay to reset dragStarted to prevent immediate click
        if (dragStarted) {
            setTimeout(function() {
                dragStarted = false;
            }, 50);
        }
    }
    isDragging = false;
    targetEl = null;
});

// Make both draggable
enableDrag(chatIcon);
enableDrag(popup);

chatBody.addEventListener('wheel', function () {
	userScrolled = true;
});

function messageScroll(lastYouMessage, isProgrammaticScroll) {
	if (userScrolled) return;

	if (isProgrammaticScroll) {
		isInternalScroll = true;
		chatBody.scrollTop = lastYouMessage - 50;
		isInternalScroll = false;
	}
}	
//Add this function to calculate smart popup position
function calculateSmartPopupPosition(iconLeft, iconTop, popupWidth, popupHeight) {
    var viewportWidth = getViewportWidth();
    var viewportHeight = getViewportHeight();
    var margin = 10; // Minimum margin from edges
    
    var left = iconLeft;
    var top = iconTop;
    
    // Adjust horizontal position if popup would go off-screen
    if (left + popupWidth > viewportWidth) {
        left = viewportWidth - popupWidth - margin;
    }
    if (left < margin) {
        left = margin;
    }
    
    // Adjust vertical position if popup would go off-screen  
    if (top + popupHeight > viewportHeight) {
        top = viewportHeight - popupHeight - margin;
    }
    if (top < margin) {
        top = margin;
    }
    
    return {
        left: left,
        top: top
    };
}

// Modified button click handler
btn.addEventListener("click", function(e) {
    var feedback = document.getElementById("parent-feedback");
    var sendButton = document.getElementById("send-button");
    
    if (dragStarted) return;
    
    minimizedBar.style.display = "none";
    resetChatState();
    if (feedback) {
        feedback.remove();
    }

    sendButton.removeAttribute('disabled');
    sendButton.style.opacity = '1';

    var url = window.location.href;

    /**
                 * Extracts the subdomain-like part of the URL (between // and /),
                 * removes dots and hyphens, and converts the result to uppercase.
                 * * Example: https://handson.academiaerp.com/#  -> HANDSONACADEMIAERPCOM
                 * Example: https://stage-one.mywebsite.net/path -> STAGEONEMYWEBSITENET
                 *
                 * @param {string} url The input URL string.
                 * @returns {string} The processed and uppercased string.
                 */
                function getSubdomain(url) {
                    var protocol, remainingUrl, startIndex, endIndex, fullDomain;

                    // 1. Remove the protocol (up to //)
                    startIndex = url.indexOf('//');
                    if (startIndex !== -1) {
                        remainingUrl = url.substring(startIndex + 2); // Start after '//'
                    } else {
                        remainingUrl = url; // No protocol found, use the whole string
                    }

                    // 2. Find the end of the domain (first '/')
                    endIndex = remainingUrl.indexOf('/');
                    if (endIndex !== -1) {
                        fullDomain = remainingUrl.substring(0, endIndex); // Get only the domain part
                    } else {
                        fullDomain = remainingUrl; // No path found, use the rest of the string
                    }

                    // Handle case where the URL might end with '#'
                    endIndex = fullDomain.indexOf('#');
                    if (endIndex !== -1) {
                        fullDomain = fullDomain.substring(0, endIndex);
                    }

                    // 3. Replace all dots (.) and hyphens (-)
                    // Use the RegExp constructor for compatibility, although a simple global replace should work too.
                    var processedString = fullDomain.replace(/\./g, '');
                    processedString = processedString.replace(/-/g, '');

                    // 4. Convert to uppercase
                    return processedString.toUpperCase();
                }

    Ext.Ajax.request({
        url: 'rest/academiaChatBotLoginResource/loginToAcademiaAIChatbot',
        method: 'GET',
        params: {
            clientCode: getSubdomain(url)
        },
        success: function(response) {
        	try {
        		var data = Ext.decode(response.responseText);

        		// Get popup dimensions (use defaults if not available)
        		/* var popupWidth = popup.offsetWidth || 400;
                var popupHeight = popup.offsetHeight || 500;

                var finalLeft = 20; // Default position
                var finalTop = 20;  // Default position

               if (!isNullOrEmpty(lastDraggedLeft) && !isNullOrEmpty(lastDraggedTop)) {
                    var draggedLeft = lastDraggedLeft;
                    var draggedTop = lastDraggedTop;

                    // Calculate smart position to keep popup in view
                    var smartPosition = calculateSmartPopupPosition(draggedLeft, draggedTop, popupWidth, popupHeight);
                    finalLeft = smartPosition.left;
                    finalTop = smartPosition.top;

                    // Update the saved position to the adjusted position
                    lastDraggedLeft = finalLeft + "px";
                    lastDraggedTop = finalTop + "px";*/
        		popup.style.top = "auto";
        		popup.style.left = "auto";
        		popup.style.bottom = "20px";  // distance from bottom
        		popup.style.right = "20px";   // distance from right
        		popup.style.position = "fixed";
        		popup.style.transform = "none";
        		popup.classList.add("open");
//      		}

        		chatBody.data = data;
        		popup.style.display = "flex";
        		popup.classList.remove("expanded");
        		btn.style.display = 'none';
        	} catch (e) {
        		console.warn('Failed to parse response as JSON');
        	}
        },
        failure: function(response) {
            console.error('Chat login failed:', response.statusText || 'Error');
        }
    });
    scrollToBottom();
});

function resetChatState() {
	retryInProgress = false;
	responseInProgress = false;
	rawMarkdown = '';
	lastYouMessage = '';
	youMessages = '';

	// Clear error message if present
	var errorMsg = document.getElementById("chat-relogin-error");
	if (errorMsg) {
		errorMsg.remove();
	}

	// Reset chatBody data (login/auth info) so a fresh login is forced
	chatBody.data = null;
}

function reloginToChatbot(callback) {
    var attemptCount = 0;
    var MAX_RETRIES_PER_CALL = 3;
    var url = window.location.href;

    function getSubdomain(url) {
        var protocol, remainingUrl, startIndex, endIndex, fullDomain;

        // 1. Remove the protocol (up to //)
        startIndex = url.indexOf('//');
        if (startIndex !== -1) {
            remainingUrl = url.substring(startIndex + 2); // Start after '//'
        } else {
            remainingUrl = url; // No protocol found, use the whole string
        }

        // 2. Find the end of the domain (first '/')
        endIndex = remainingUrl.indexOf('/');
        if (endIndex !== -1) {
            fullDomain = remainingUrl.substring(0, endIndex); // Get only the domain part
        } else {
            fullDomain = remainingUrl; // No path found, use the rest of the string
        }

        // Handle case where the URL might end with '#'
        endIndex = fullDomain.indexOf('#');
        if (endIndex !== -1) {
            fullDomain = fullDomain.substring(0, endIndex);
        }

        // 3. Replace all dots (.) and hyphens (-)
        // Use the RegExp constructor for compatibility, although a simple global replace should work too.
        var processedString = fullDomain.replace(/\./g, '');
        processedString = processedString.replace(/-/g, '');

        // 4. Convert to uppercase
        return processedString.toUpperCase();
    }

    function tryRelogin() {
        if (reloginFailureCount >= 3 || attemptCount >= MAX_RETRIES_PER_CALL) {
            showReloginErrorMessage();
            callback(false); // ⛔️ failed
            return;
        }

        attemptCount++;

        Ext.Ajax.request({
            url: 'rest/academiaChatBotLoginResource/loginToAcademiaAIChatbot',
            method: 'GET',
            params: {
                clientCode: getSubdomain(url)
            },
            success: function(response) {
                try {
                    var data = Ext.decode(response.responseText);
                    if (!data || !data.body || !data.body.token) throw new Error("Missing token");

                    chatBody.data = data;
                    reloginFailureCount = 0;
                    console.log("✅ Re-login successful");
                    callback(true); // ✅ success

                } catch (e) {
                    console.warn("⚠️ Re-login parse error", e.message);
                    reloginFailureCount++;
                    tryRelogin();
                }
            },
            failure: function() {
                reloginFailureCount++;
                tryRelogin();
            }
        });
    }

    tryRelogin();
}

function showReloginErrorMessage() {
	var existingMessage = document.getElementById("chat-relogin-error");
	if (existingMessage) return; // Don't show multiple

	var errorDiv = document.createElement("div");
	errorDiv.id = "chat-relogin-error";
	errorDiv.className = "chat-error-message";
	
	errorDiv.style.cssText =
		"color: red;" +
		"background: #fff0f0;" +
		"padding: 10px;" +
		"margin: 10px;" +
		"border: 1px solid #f5c2c2;" +
		"border-radius: 5px;" +
		"text-align: center;" +
		"font-weight: bold;";

	errorDiv.innerText = "⚠️ Session expired. Please close and reopen the chat popup to continue.";

	var chatPopup = document.querySelector(".chat-popup") || document.getElementById("chatBody");
	if (chatPopup) {
		chatPopup.appendChild(errorDiv);
	}
}


function toggleExpand(e) {
      var chatIcon = document.getElementById("openChatBtn");
      e.stopPropagation();

      // smooth transition for all properties
      popup.style.transition = "all 0.4s cubic-bezier(0.25, 1, 0.5, 1)";

      var isExpanded = popup.classList.toggle("expanded");

      if (isExpanded) {
        // ✅ expand to center
        popup.style.top = "50%";
        popup.style.left = "50%";
        popup.style.bottom = "auto";
        popup.style.right = "auto";
        popup.style.transform = "translate(-50%, -50%) scale(1.05)";
        popup.style.boxShadow = "0 10px 30px rgba(0,0,0,0.3)";
        popup.style.borderRadius = "20px";
      } else {
        // ✅ minimize → always bottom-right
        popup.style.transform = "none";
        popup.style.top = "auto";
        popup.style.left = "auto";
        popup.style.bottom = "20px";  // distance from bottom
        popup.style.right = "20px";   // distance from right
        popup.style.boxShadow = "0 4px 16px rgba(0,0,0,0.2)";
        popup.style.borderRadius = "16px";
      }

      chatIcon.style.display = "none";
      scrollToBottom();

      // optional: reset scale after animation ends for clean look
      setTimeout(function () {
        if (isExpanded) popup.style.transform = "translate(-50%, -50%) scale(1)";
      }, 400);
    }
/*function minimizeChat(e) {
	e.stopPropagation();
	popup.style.display = "none";

	// Hide minimized bar if visible
	if (minimizedBar) {
		minimizedBar.style.display = "none";
	}

	// Show the floating button again
	var chatIcon = document.getElementById("openChatBtn");
	if (chatIcon) {
		chatIcon.style.display = "flex";
	}
}*/
function minimizeChat(e) {
	  e.stopPropagation();
	  popup.style.display = "none";

	  if (minimizedBar) {
	    minimizedBar.style.display = "none";
	  }

	  // Show the floating button again
	  var chatIcon = document.getElementById("openChatBtn");
	  if (chatIcon) {
	    chatIcon.style.display = "flex";
	  }

	  // ✅ when restoring later, popup will use last dragged position
	  popup.style.transform = "none";
	  popup.style.top = lastDraggedTop;
	  popup.style.left = lastDraggedLeft;
	}

function restoreChat() {
	popup.style.display = "flex";
	minimizedBar.style.display = "none";
	scrollToBottom();
}

function scrollToBottom() {
	setTimeout(function() {
		chatBody.scrollTop = chatBody.scrollHeight;
	}, 100);
}

function rateFeedback(el, type) {
	var feedbackDiv = el.parentNode;

	// Remove 'selected' from all spans
	var spans = feedbackDiv.getElementsByTagName('span');
	for (var i = 0; i < spans.length; i++) {
		spans[i].className = spans[i].className.replace(/\bselected\b/, '');
		var svg = spans[i].getElementsByTagName('svg')[0];
		if (svg) {
			svg.className.baseVal = svg.className.baseVal.replace(/\bfilled\b/,
					'');
		}
	}

	// Add 'selected' and 'filled' to clicked element
	el.className += ' selected';
	var selectedSvg = el.getElementsByTagName('svg')[0];
	if (selectedSvg) {
		selectedSvg.className.baseVal += ' filled';
	}

	var isLike = type === 'like';

	// Find the previous message div
	var questionDiv = feedbackDiv.parentElement.previousSibling;
	while (questionDiv && (!questionDiv.className || questionDiv.className.indexOf('you') === -1)) {
		questionDiv = questionDiv.previousSibling;
	}
	var question = questionDiv ? questionDiv.innerText	|| questionDiv.textContent : '';

	// Get user info
	var data = chatBody.data.body;
	var userCode = data.userCode;
	var clientCode = data.clientCode;
	var token = data.token;
	var rawUrl =  data.helpDeskURL || '';
	var cleanedUrl = rawUrl.replace(/^"+|"+$/g, '');
	var feedbackUrl = cleanedUrl.replace(/help-desk$/, 'approve');
	
	// Send PUT request
	var xhr = new XMLHttpRequest();
	xhr.open('PUT', feedbackUrl, true);
	xhr.setRequestHeader('Content-Type', 'application/json');
	xhr.setRequestHeader('Authorization', 'Bearer ' + token);

	/* --- filled SVG markup we will inject when the server confirms --- */
	var LIKE_FILLED_SVG = '<svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" viewBox="0 0 26 26" fill="none">'
			+ '<path d="M19.9888 12.1875L19.2388 18.1875C19.1931 18.5501 19.0166 18.8835 18.7425 19.1252C18.4684 19.3668 18.1154 19.5001 17.75 19.5L7 19.5C6.73478 19.5 6.48043 19.3946 6.29289 19.2071C6.10536 19.0196 6 18.7652 6 18.5L6 13C6 12.7348 6.10536 12.4804 6.29289 12.2929C6.48043 12.1054 6.73478 12 7 12L9.69125 12L12.0525 7.27625C12.0941 7.19318 12.158 7.12333 12.237 7.07454C12.316 7.02574 12.4071 6.99993 12.5 7C13.163 7 13.7989 7.26339 14.2678 7.73223C14.7366 8.20107 15 8.83696 15 9.5L15 10.5L18.5 10.5C18.7129 10.4999 18.9233 10.5452 19.1173 10.6327C19.3113 10.7202 19.4845 10.848 19.6253 11.0077C19.7662 11.1673 19.8714 11.355 19.9341 11.5585C19.9967 11.7619 20.0154 11.9763 19.9888 12.1875ZM9.5 13L7 13L7 18.5L9.5 18.5L9.5 13Z" fill="#2F2F2F"/>'
			+ '</svg>';

	var DISLIKE_FILLED_SVG = '<svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" viewBox="0 0 26 26" fill="none">'
			+ '<path d="M6.01125 14.3125L6.76125 8.3125C6.80693 7.94993 6.9834 7.6165 7.25752 7.37483C7.53164 7.13316 7.88456 6.99987 8.25 7H19C19.2652 7 19.5196 7.10536 19.7071 7.29289C19.8946 7.48043 20 7.73478 20 8V13.5C20 13.7652 19.8946 14.0196 19.7071 14.2071C19.5196 14.3946 19.2652 14.5 19 14.5H16.3088L13.9475 19.2238C13.9059 19.3068 13.842 19.3767 13.763 19.4255C13.684 19.4743 13.5929 19.5001 13.5 19.5C12.837 19.5 12.2011 19.2366 11.7322 18.7678C11.2634 18.2989 11 17.663 11 17V16H7.5C7.28714 16.0001 7.07671 15.9548 6.88268 15.8673C6.68865 15.7798 6.51547 15.652 6.37466 15.4923C6.23384 15.3327 6.1286 15.145 6.06594 14.9415C6.00329 14.7381 5.98464 14.5237 6.01125 14.3125ZM16.5 13.5H19V8H16.5V13.5Z" fill="#2F2F2F"/>'
			+ '</svg>';
	
	xhr.onreadystatechange = function() {
		if (xhr.readyState === 4) {
			if (xhr.status === 200) {
				console.log("Feedback sent successfully:", xhr.responseText);
				el.innerHTML = isLike ? LIKE_FILLED_SVG : DISLIKE_FILLED_SVG;

				// Disable both like and dislike after rating
				var feedbackSpans = feedbackDiv.getElementsByTagName('span');
				for (var i = 0; i < feedbackSpans.length; i++) {
					feedbackSpans[i].onclick = null;
					feedbackSpans[i].style.cursor = 'default';
				}
			} else {
				console.error("Feedback failed:", xhr.status, xhr.responseText);
			}
		}
	};

	var payload = JSON.stringify({
		userCode : userCode,
		clientCode : clientCode,
		inputPrompt : question,
		whetherApproved : isLike
	});

	xhr.send(payload);
}

document.getElementById("userInput").addEventListener("keydown", function(e) {
	if (e.keyCode === 13 && !e.shiftKey) {
		e.preventDefault();

		var input = document.getElementById("userInput");
		var text = input.value.trim();

		if (!responseInProgress && text) {
			sendMessage();
		}
	}
});

function clearChat(e){
	var chatBody = document.getElementById("chatBody");
	if (chatBody && !responseInProgress) {
		chatBody.innerHTML = '<div class="blank-box">'
				+ '<img style="width: 150px;margin: auto;border-radius: 100px;padding: 10px;background-color: #fff;" src="resources/chatbot/chatbot.gif">'
				+ '<p class="typing-effect">How may I help you? 😊</p>'
				+ '</div>';
	}

}

function closeChat(e) {
	e.stopPropagation();

	showConfirmMessage(
			"Confirm",
			"Are you sure you want to close the chat?",
			function(btn) {
				if (btn === 'yes') {
					popup.style.display = "none";
					minimizedBar.style.display = "none";
					popup.className = "chat-popup"

					var chatBody = document.getElementById("chatBody");
					if (chatBody) {
						chatBody.innerHTML = '<div class="blank-box">'
								+ '<img style="width: 150px;margin: auto;border-radius: 100px;padding: 10px;background-color: #fff;" src="resources/chatbot/chatbot.gif">'
								+ '<p class="typing-effect">How may I help you? 😊</p>'
								+ '</div>';
					}

					var input = document.getElementById("userInput");
					if (input) {
						input.value = '';
					}

					document.querySelector(".chatbot-icon").style.display = "flex";
					lastDraggedLeft = null;
					lastDraggedTop = null;
				}
			});
}

/**
 * Stream GPT reply.
 * 
 * @param {String}
 *            question
 * @param {Function}
 *            onChunk called with every partial chunk
 * @param {Function}
 *            onDone called once when stream ends
 * @param {Function}
 *            onError called if stream fails
 */

function streamBotReply(question, onChunk, onDone, onError) {
    var data = chatBody.data.body;
    
    if (!data) {
        var errorMsg = '<p style="font-weight: bold;">Service Unavailable</p>';
        if (onError) onError(errorMsg);
        return;
    }
//    
//    var userCode = data.userCode;
//    var bearer = data.token;
    var chaturl = getBaseChatURL(data.helpDeskURL);
    var url = window.location.href;

    function getSubdomain(url) {
        var protocol, remainingUrl, startIndex, endIndex, fullDomain;

        // 1. Remove the protocol (up to //)
        startIndex = url.indexOf('//');
        if (startIndex !== -1) {
            remainingUrl = url.substring(startIndex + 2); // Start after '//'
        } else {
            remainingUrl = url; // No protocol found, use the whole string
        }

        // 2. Find the end of the domain (first '/')
        endIndex = remainingUrl.indexOf('/');
        if (endIndex !== -1) {
            fullDomain = remainingUrl.substring(0, endIndex); // Get only the domain part
        } else {
            fullDomain = remainingUrl; // No path found, use the rest of the string
        }

        // Handle case where the URL might end with '#'
        endIndex = fullDomain.indexOf('#');
        if (endIndex !== -1) {
            fullDomain = fullDomain.substring(0, endIndex);
        }

        // 3. Replace all dots (.) and hyphens (-)
        // Use the RegExp constructor for compatibility, although a simple global replace should work too.
        var processedString = fullDomain.replace(/\./g, '');
        processedString = processedString.replace(/-/g, '');

        // 4. Convert to uppercase
        return processedString.toUpperCase();
    }
    
    function getBaseChatURL(url) {
        if (!url) return '';

        try {
            return url.replace(/^"+|"+$/g, ''); // remove trailing slashes
        } catch (e) {
            console.warn('Invalid URL passed to getBaseChatURL:', url);
            return '';
        }
    }


    var retryAttempted = false;

    function makeRequest() {
        // 🔄 Always get fresh token and userCode
        	data = chatBody.data.body;
        var userCode = data.userCode;
        var bearer = data.token;

        var xhr = new XMLHttpRequest();
        var lastIndex = 0;

        var endpoint = chaturl
        + '?question=' + encodeURIComponent(question);
        
        xhr.open('GET', endpoint, true);
        xhr.setRequestHeader('Accept', 'text/event-stream');
        xhr.setRequestHeader('Authorization', 'Bearer ' + bearer);

        xhr.onprogress = function () {
            var text = xhr.responseText.substring(lastIndex);
            lastIndex = xhr.responseText.length;

            var lines = text.split(/\r?\n/);
            for (var i = 0; i < lines.length; i++) {
                var line = lines[i].trim();
                if (line.indexOf('data:') === 0) {
                    try {
                        var jsonStr = line.replace(/^data:\s*/, '');
                        if (jsonStr) {
                            var dataObj = JSON.parse(jsonStr);
                            if (dataObj && typeof dataObj.content !== "undefined") {
                                onChunk(dataObj.content);
                            }
                        }
                    } catch (e) {
                        console.error('Invalid SSE JSON chunk:', e);
                    }
                }
            }
        };

        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4) {
                if (xhr.status === 200) {
                    retryAttempted = false;
                    onDone();
                } else if (xhr.status === 401 && !retryAttempted) {
                    retryAttempted = true;

                    reloginToChatbot(function (success) {
                        if (success) {
                            makeRequest(); // ✅ Retry the stream with updated token
                        } else {
                            onError("Relogin failed.");
                        }
                    });
                } else {
                    retryAttempted = false;
                    onError(xhr.statusText || '<p style="font-weight: bold; color: #1F236B;;">Oops! Something unexpected happened. Please try again.</p>');
                }
            }
        };

        xhr.onerror = function () {
            if (!retryAttempted) {
                retryAttempted = true;
                reloginToChatbot(function () {
                    var newData = chatBody.data.body;
                    userCode = newData.userCode;
                    bearer = newData.token;

                    endpoint = chaturl
                        + '?question=' + encodeURIComponent(question);

                    makeRequest(); // 🔁 Retry after relogin
                });
            } else {
            	onError('<p style="font-weight: bold; color: #FFC107;">Oops! Something unexpected happened. Please try again.</p>');
            }
        };

        /* ---- send (may throw synchronously) ---- */
        try {
            xhr.send(null);

        } catch (ex) {

            // First time we see the exception → re‑login
            if (!retryAttempted) {
                retryAttempted = true;

                reloginToChatbot(function () {

                    // ⏳ Wait one tick so we are out of the current call stack
                    setTimeout(function () {

                        // refresh token / userCode after relogin
                        var newData = chatBody.data.body;
                        userCode = newData.userCode;
                        bearer   = newData.token;

                        // re‑build endpoint with fresh data
                        endpoint = chaturl
                            + '?question=' + encodeURIComponent(question);

                        // 🔁 brand‑new XHR in a clean context
                        makeRequest();

                    }, 0);
                });

            } else {
                // Already retried once – give up
            	onError(ex.message || '<p style="font-weight: bold; color: #FFC107;">Oops! Something unexpected happened. Please try again.</p>');;
            }
        }

    }

    // 🔰 Start the request
    makeRequest();
}



function sendMessage() {
	if (responseInProgress) return;
	responseInProgress = true;
	userScrolled = false;

	var input = document.getElementById("userInput");
	var sendButton = document.getElementById("send-button");
	var text = input.value.trim();

	if (!text) {
		responseInProgress = false;
		return;
	}

	var blankBox = document.querySelector('.blank-box');
	if (blankBox && blankBox.parentNode) {
		blankBox.parentNode.removeChild(blankBox);
	}


	sendButton.setAttribute('disabled', '');
	sendButton.style.opacity = '0.5';

	var youMsg = document.createElement('div');
	youMsg.className = 'message you';
	youMsg.innerHTML = text;
	chatBody.appendChild(youMsg);
	chatBody.scrollTop = chatBody.scrollHeight;
	/*clearTimeout(scrollPauseTimer);
	scrollPauseTimer = Ext.defer(function () {
		userScrolled = false;
	}, 2000);*/

	youMessages = document.getElementsByClassName('you');
	lastYouMessage = youMessages[youMessages.length - 1].offsetTop;

	var botMsg = document.createElement('div');
	botMsg.className = 'message bot';
	chatBody.appendChild(botMsg);

	var typing = document.createElement("div");
	typing.className = "typing-indicator";
	typing.textContent = "Searching...";
	botMsg.appendChild(typing);

	input.value = '';

	var firstChunkReceived = false;

	streamBotReply(text, function onChunk(chunk) {
		if (!firstChunkReceived) {
			firstChunkReceived = true;
			if (typing.parentNode) {
				typing.parentNode.removeChild(typing);
			}
		}
		rawMarkdown += chunk;
		botMsg.innerHTML = convertMarkdownToHTML(rawMarkdown);
		
		messageScroll(lastYouMessage, true);
//		if(!isScrolled){
//			chatBody.scrollTop = lastYouMessage - 50;
//		}
	}, function onDone() {
		var message = document.getElementsByClassName('message');
		if (message.length) {
			addFeedbackRow();
			finalize();
		} }, function onErr(err) {
			if (typing.parentNode) {
				typing.parentNode.removeChild(typing);
			}
			botMsg.innerHTML += '<br/><i>' + err + '</i>';
			scrollToBottom();
			finalize();
		});

	function finalize() {
		sendButton.removeAttribute('disabled');
		sendButton.style.opacity = '1';
		responseInProgress = false;
		rawMarkdown = '';
		userScrolled = false;
	}
}



function addFeedbackRow() {
	var feedBack = document.createElement("div");
	feedBack.className = 'parent-feedback';

	feedBack.innerHTML = '<div class="feedback">'
			+ 'Did you like this response? '
			+ '<span onclick="rateFeedback(this, \'like\')">'
			+ '<svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" viewBox="0 0 26 26" fill="none">'
			+ '<path d="M19.9888 12.1875L19.2388 18.1875C19.1931 18.5501 19.0166 18.8835 18.7425 19.1252C18.4684 19.3668 18.1154 19.5001 17.75 19.5L7 19.5C6.73478 19.5 6.48043 19.3946 6.29289 19.2071C6.10536 19.0196 6 18.7652 6 18.5L6 13C6 12.7348 6.10536 12.4804 6.29289 12.2929C6.48043 12.1054 6.73478 12 7 12L9.69125 12L12.0525 7.27625C12.0941 7.19318 12.158 7.12333 12.237 7.07454C12.316 7.02574 12.4071 6.99993 12.5 7C13.163 7 13.7989 7.26339 14.2678 7.73223C14.7366 8.20107 15 8.83696 15 9.5L15 10.5L18.5 10.5C18.7129 10.4999 18.9233 10.5452 19.1173 10.6327C19.3113 10.7202 19.4845 10.848 19.6253 11.0077C19.7662 11.1673 19.8714 11.355 19.9341 11.5585C19.9967 11.7619 20.0154 11.9763 19.9888 12.1875ZM9.5 13L7 13L7 18.5L9.5 18.5L9.5 13ZM18.875 11.6694C18.8284 11.6158 18.7708 11.5729 18.706 11.5436C18.6413 11.5144 18.571 11.4995 18.5 11.5L14.5 11.5C14.3674 11.5 14.2402 11.4473 14.1464 11.3536C14.0527 11.2598 14 11.1326 14 11L14 9.5C14.0001 9.1532 13.88 8.81708 13.6602 8.54884C13.4404 8.2806 13.1344 8.09681 12.7944 8.02875L10.5 12.6181L10.5 18.5L17.75 18.5C17.8718 18.5 17.9895 18.4556 18.0808 18.3751C18.1722 18.2945 18.231 18.1834 18.2463 18.0625L18.9963 12.0625C19.0056 11.9921 18.9996 11.9205 18.9787 11.8527C18.9578 11.7848 18.9224 11.7223 18.875 11.6694Z" fill="#2F2F2F"/>'
			+ '</svg>'
			+ '</span>'
			+ '<span onclick="rateFeedback(this, \'dislike\')">'
			+ '<svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" viewBox="0 0 26 26" fill="none">'
			+ '<path d="M6.01125 14.3125L6.76125 8.3125C6.80693 7.94993 6.9834 7.6165 7.25752 7.37483C7.53164 7.13316 7.88456 6.99987 8.25 7H19C19.2652 7 19.5196 7.10536 19.7071 7.29289C19.8946 7.48043 20 7.73478 20 8V13.5C20 13.7652 19.8946 14.0196 19.7071 14.2071C19.5196 14.3946 19.2652 14.5 19 14.5H16.3088L13.9475 19.2238C13.9059 19.3068 13.842 19.3767 13.763 19.4255C13.684 19.4743 13.5929 19.5001 13.5 19.5C12.837 19.5 12.2011 19.2366 11.7322 18.7678C11.2634 18.2989 11 17.663 11 17V16H7.5C7.28714 16.0001 7.07671 15.9548 6.88268 15.8673C6.68865 15.7798 6.51547 15.652 6.37466 15.4923C6.23384 15.3327 6.1286 15.145 6.06594 14.9415C6.00329 14.7381 5.98464 14.5237 6.01125 14.3125ZM16.5 13.5H19V8H16.5V13.5ZM7.125 14.8306C7.1716 14.8842 7.22924 14.9271 7.29396 14.9564C7.35869 14.9856 7.42898 15.0005 7.5 15H11.5C11.6326 15 11.7598 15.0527 11.8536 15.1464C11.9473 15.2402 12 15.3674 12 15.5V17C11.9999 17.3468 12.12 17.6829 12.3398 17.9512C12.5596 18.2194 12.8656 18.4032 13.2056 18.4712L15.5 13.8819V8H8.25C8.12819 7.99996 8.01055 8.04439 7.91917 8.12494C7.8278 8.2055 7.76898 8.31664 7.75375 8.4375L7.00375 14.4375C6.99438 14.5079 7.00037 14.5795 7.0213 14.6473C7.04223 14.7152 7.07761 14.7777 7.125 14.8306Z" fill="#2F2F2F"/>'
			+ '</svg>' + '</span>' + '</div>';

	chatBody.appendChild(feedBack);
}


function convertMarkdownToHTML(text) {
    // Escape HTML
    text = text.replace(/</g, "&lt;").replace(/>/g, "&gt;");

    // Convert markdown bold (**) to <strong>
    text = text.replace(/\*\*(.*?)\*\*/g, "<strong>$1</strong>");

    // Add new line before numbered strong headings
    text = text.replace(/(\d+\.\s*<strong>.*?<\/strong>)/g, "\n$1");

    // Break into lines for further processing
    var lines = text.split(/\n+/);
    var html = '';
    var insideOl = false;
    var insideUl = false;

    for (var i = 0; i < lines.length; i++) {
        var line = Ext.String.trim(lines[i]);

        if (/^\d+\.\s*<strong>/.test(line)) {
            if (insideUl) {
                html += '</ul>';
                insideUl = false;
            }
            if (!insideOl) {
                html += '<ol>';
                insideOl = true;
            }
            html += '<li>' + line.replace(/^\d+\.\s*/, '');
        } else if (line.indexOf('- ') === 0) {
            if (!insideUl) {
                html += '<ul>';
                insideUl = true;
            }
            html += '<li>' + line.replace(/^- /, '') + '</li>';
        } else {
            if (insideUl) {
                html += '</ul>';
                insideUl = false;
            }
            if (insideOl) {
                html += '</li>';
                insideOl = false;
                html += '</ol>';
            }
            html += '<p>' + line + '</p>';
        }
    }

    if (insideUl) html += '</ul>';
    if (insideOl) html += '</li></ol>';

    return html;
}
