/*
    This file is generated and updated by Sencha Cmd. You can edit this file as
    needed for your application, but these edits will have to be merged by
    Sencha Cmd when upgrading.
 */
Ext.Loader.setConfig({
	enabled: true,
	disableCaching: false,
	paths: {
		'Ext.calendar': 'app/utilities/calendar'
	}
});
Ext.application({
	name: 'Academia', // application name that becomes the namespace
	extend: 'Academia.Application',
	init: function(){
		Academia.enumStore = {};
		Academia.dataStore = {};
	},
	autoCreateViewport: false, //// automatically refer Viewport.js
	controllers: ['Academia.controller.menu.CoreERPNavigationController',
		'Academia.controller.base.BaseController',
		'Academia.controller.authentication.AuthenticationController',
		'Academia.controller.dashboard.DashboardController',
		'Academia.controller.criteriabuilder.CriteriaBuilderController',
		'Academia.controller.criteriabuilder.SavedAdvanceSearchCriteriaController',
		'Academia.controller.datasetting.IdGeneratorController',
		'Academia.controller.webcam.ImageCaptureController',
		'Academia.controller.personinfo.common.PersonCommonController',
		'Academia.controller.portal.StudentPortalController',
		'Academia.controller.portal.FacultyPortalController',
		'Academia.controller.portal.ApplicantPortalController',
		'Academia.controller.portal.ParentPortalController',
		'Academia.controller.coursetransaction.studentcourseenrollment.StudentCourseMasterController',
		'Academia.controller.coursetransaction.studentcourseenrollment.StudentEnrollmentDetailTabController',
		'Academia.controller.coursetransaction.studentcourseenrollment.courseGroup.StudentCourseGroupController',
		'Academia.controller.attendance.LeaveReportController',
		'Academia.controller.coursetransaction.studentcourseenrollment.StudentPortalCourseRegistrationController',
		'Academia.controller.portal.MasterScheduleController',
		'Academia.controller.personinfo.student.StudentCourseExecutionController',
		'Academia.controller.personinfo.common.PersonCourseExecutionController',
		'Academia.controller.feeandpayment.FeeAndPaymentController',
		'Academia.controller.personinfo.faculty.FacultyCourseExecutionController',
		'Academia.controller.portal.StudentAttendanceReportController',
		'Academia.controller.admission.admissionCycle.AdmissionCycleController',
		'Academia.controller.admission.selectionStage.SelectionStageController',
		'Academia.controller.admission.applications.applicationBase.ApplicationBaseController',
		'Academia.controller.admission.admissionCommon.AdmissionFormCommonController',
		'Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.ButtonPanelConfiguration',
		'Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.LinkPanelConfiguration',
		//'Academia.controller.admission.applications.ButtonPanelAndLinkPanelConfiguration.AppProgMainGridToolBarButtonConfiguration',
		'Academia.controller.coursetransaction.facultyTopicAssignment.FacultyTopicAssignmentController',
		'Academia.controller.coursetransaction.facultyTopicAssignment.FacultyTopicAssignmentListController',
		'Academia.controller.coursetransaction.sectioncoursecoverageplan.MasterTimeTableController',
		'Academia.controller.examinationcenters.manageEvaluation.ManageEvalResultSearchController',
		'Academia.controller.coursetransaction.homework.HomeworkSubmissionController',
		'Academia.controller.coursetransaction.homework.HomeworkAssignmentController',
		'Academia.controller.coursetransaction.homework.HomeworkEvaluationController',
		'Academia.controller.program.SpecializationEnollmentController',
		'Academia.controller.coursetransaction.studentperiodenrollment.StudentPeriodRegistrationController',
		'Academia.controller.program.sessionReport.SessionReportController',
		'Academia.controller.personinfo.student.StudentPersonalController',
		'Academia.controller.personinfo.common.PersonInfoController',
		'Academia.controller.organization.AddressController',
		'Academia.controller.personinfo.student.StudentListController',
		'Academia.controller.examinationcenters.ExaminationCentersController',
		'Academia.controller.examinationcenters.evaluationgrouplisting.EvalGroupListingMasterController',
		'Academia.controller.examinationcenters.evaluationgrouplisting.applicationdetail.ApplicationDetailController',
		'Academia.controller.examinationcenters.evaluationgrouplisting.documentsubmit.EvalGroupListingDocumentSubmitController',
		'Academia.controller.examinationcenters.evaluationgrouplisting.centerallocation.EGListingCenterAlllocationController',
		'Academia.controller.examinationcenters.roomallocation.RoomAllocationController',
		'Academia.controller.examinationcenters.evaluationresult.EvaluationResultController',
		'Academia.controller.personinfo.student.StudentExaminationDocumentsController',
		'Academia.controller.examinationcenters.studentportal.revaluation.RevaluationSPController',
		'Academia.controller.examinationcenters.studentportal.SPStudentAssessmentReportController',
		'Academia.controller.examinationcenters.studentresultreport.StudentResultReportController',
		'Academia.controller.personinfo.common.PersonPaymentRefundController',
		'Academia.controller.personinfo.student.StudentPaymentRefundController',
		'Academia.controller.personinfo.faculty.FacultyPaymentRefundController',
		'Academia.controller.scholarship.ScholarshipMasterController',
		'Academia.controller.feeandpayment.feerequest.StudentPortalFeeRequestController',
		'Academia.controller.feeandpayment.FeeAndPaymentReportController',
		'Academia.controller.placement.placementcampus.PlacementCampusController',
		'Academia.controller.placement.placementjobapplication.PlacementJobApplicationController',
		'Academia.controller.servicerequest.ServiceRequestController',
		'Academia.controller.servicerequest.ServiceRequestBaseController',
		'Academia.controller.reports.complaints.ComplaintsDashboardReportController',
		'Academia.controller.programCourseDashboard.organizationUnit.organizationUnitController',
		'Academia.controller.personinfo.student.StudentComplaintController',
		'Academia.controller.attendance.FacultyAttendanceController',
		'Academia.controller.attendance.AttendanceMasterController',
		'Academia.controller.admission.applications.applicantService.ApplicantServiceController',
		'Academia.controller.personinfo.common.PersonServiceController',
		'Academia.controller.personinfo.student.StudentServiceController',
		'Academia.controller.personinfo.faculty.FacultyServiceController',
		'Academia.controller.personinfo.common.PersonPastHistoryController',
		'Academia.controller.personinfo.student.StudentPastHistoryController',
		'Academia.controller.personinfo.faculty.FacultyPastHistoryController',
		'Academia.controller.committee.committee.StudentCommitteeController',
		'Academia.controller.personinfo.faculty.FacultyPersonalController',
		'Academia.controller.personinfo.faculty.FacultyListController',
		'Academia.controller.personinfo.student.StudentKYSController',
		'Academia.controller.personinfo.student.StudentDocumentController',
		'Academia.controller.admission.applications.applicantpasthistory.ApplicantPastHistoryController',
		'Academia.controller.servicerequest.infirmarymanage.InfirmaryManageController',
		'Academia.controller.personinfo.student.StudentDisciplinaryController',
		'Academia.controller.personinfo.common.PersonDisciplinaryController',
		'Academia.controller.personinfo.faculty.FacultyDisciplinaryController',
		'Academia.controller.sgappointment.sgappointment.SGStudentAppointmentController',
		'Academia.controller.facilitiesresources.managegallery.ManageGalleryController',
		'Academia.controller.personinfo.dashlet.PersonInfoDashboardController',
		'Academia.controller.feeandpayment.payment.PaymentController',
		'Academia.controller.feeandpayment.AccountStatementReportController',
		'Academia.controller.fdmanagement.FDManagementController',
		'Academia.controller.servicerequest.PersonalDataChangeRequestController',
		'Academia.controller.examinationdegreeremark.ExaminationDegreeRemarkController',
		'Academia.controller.DMSController.DMSCommonController',
		'Academia.controller.kohaLibraryTransalation.SGStudentLibraryIssuedBookTransactionController',
		'Academia.controller.scholarship.ScholarshipListingController',
	    'Academia.controller.hostel.manageallocation.ManageAllocationController',
		'Academia.controller.examinationcenters.thesisManagement.studentThesisManagementController',
        'Academia.controller.election.election.ElectionController',
        'Academia.controller.personinfo.student.StudentManageHoldController',
        'Academia.controller.powerBI.AnalyticsCommonController',
        'Academia.controller.personinfo.student.StudentJourneyController',
        'Academia.controller.examinationtimetable.ExamTimetableController'
	],
	views: [
		'common.StatusCombo','common.StatusCombos',
		'Academia.view.baselayout.contentarea.ContentPanel',
		'Academia.view.CustomAlerts',
		// from base controller
		'reports.admission.admsnDataNullReport',
		'common.LiveSearchCombo',
		'Academia.view.common.AcadLocProgBatchSeattypeComponent',
		'common.NestedTextField',
		'common.IdGeneratorCustomForm',
		'common.DynamicFieldForm',
		'common.DynamicFieldFormWin',
		'common.IdGeneratorCustomFormWin',
		'common.IdGeneratorFormWin',
		'common.AddressDetailPanel',
		'common.CustomFieldForm',
		'messaging.sendmessage.SendMessageWindow',
		// form CoreERPNavigationController
		'Academia.view.organization.OrganizationStructure',
        'Academia.utilities.ux.CustomTopPagingToolBar'
	],
	stores: [
		'common.StatusComboStore',
		'common.LiveSearchCombos',
		'Academia.store.common.AcademyStore',
		'Academia.store.common.SeatTypesByBatchId',
		'Academia.store.common.LocationStore',
		'Academia.store.common.ProgramsByAcademyIdLocationId',
		'Academia.store.common.BatchesByProgramId',
		'Academia.store.common.SeatTypesByBatchId',
		'Academia.store.common.Checklist',
		'Academia.store.common.DocumentTypeStore',
		'common.ActiveUserStore',
		'Academia.store.messaging.MessageTemplate'
	],
    models:[
    	'customfields.CustomFieldDataModel',
    	'singleton.Organization',
    	'menu.MegaMenuDataModel',
    	'Academia.model.common.OrgSettingDateTimeModel'
    ],
	requires:[
		'Academia.constants.CurrencyFormatConstants',
		'Academia.utilities.CommonUtil',
		'Academia.utilities.vTypeValidations.Validation',
		'Academia.utilities.ErrorHandler',
		'Academia.utilities.plugins.AsteriskPlugin',
		'Academia.utilities.CustomAlerts',
		'Academia.utilities.JsonAjaxRequest',
		'Academia.utilities.ImageActionColumn',
		'Academia.utilities.accessControl.AccessControlManager',
		'Academia.utilities.accessControl.FeaturePrivilegeManager',
		// from base controller
		'Academia.utilities.plugins.TreeFilter',
		'Academia.utilities.ckEditor.CkEditor',
		'Academia.utilities.gridExporter',
		'Academia.utilities.DisplayFormatMap',
		'Academia.utilities.CurrencyFormatMap',
		'Academia.utilities.plugins.SessionMonitor',
		'Academia.utilities.currency.CurrencyManager',
		'Academia.utilities.date.DateHelper',
		'Academia.utilities.ux.PageSize', 
		'Academia.utilities.ux.CustomPagingToolBar',
		'Academia.utilities.ux.AutoGroupedColumn',
		'Academia.utilities.ux.GroupingComboBox',
		'Academia.utilities.ux.CustomCheckboxField',
		'Academia.utilities.reader.CacheRest',
		'Academia.utilities.reader.CustomArrayReader',
        'Academia.config.Runtime'
	],
	launch :function(){
		Ext.app.autoCallAPIs = true;
		//--- code for separating tabs ---//
		setTabId();

		var getParams = document.URL.split("?");
		var params = Ext.urlDecode(getParams[getParams.length - 1]);
		localStorage.setItem('userHash','');
		if(params["userHash"])
		{
			localStorage.setItem('userHash',params["userHash"]);
			window.history.pushState("", "", getParams[0]);
		}
		/**
		 * @ravi.patidar login check and reload app
		 */
		
		if (typeof localStorage.getItem('tokenApiResponse') != "string"){
			var tokenApiResponse = localStorage.getItem('tokenApiResponse');
			var academylocationid = localStorage.getItem('academylocationid');
			var wheatherSchool = localStorage.getItem('wheatherSchool');
		}else{
			var tokenApiResponse = JSON.parse(localStorage.getItem('tokenApiResponse'));
    	    var academylocationid = JSON.parse(localStorage.getItem('academylocationid'));
    	    var wheatherSchool = JSON.parse(localStorage.getItem('wheatherSchool'));
		}
		
		if(isNullOrEmpty(localStorage.getItem('maxLength'))){
			localStorage.setItem('maxLength',160);
		}
		if(!isNullOrEmpty(localStorage.getItem('defaultPage'))){
			var defaultPage = localStorage.getItem('defaultPage');
			setTimeout(function(){
				try{
					var defaultPageSplitted = defaultPage.split('-');
					this$.openTab(getMegaMenuTranslation(defaultPageSplitted[0]), defaultPageSplitted[1] );
					localStorage.setItem('defaultPage','');
				}
				catch(e){
					localStorage.setItem('defaultPage','');
				}
			},5000);
		}
		if(!isNullOrEmpty(tokenApiResponse) && !isNullOrEmpty(tokenApiResponse.Authorization) && !isNullOrEmpty(academylocationid)){
			Ext.Ajax.defaultHeaders = {
					Authorization: "Bearer " + tokenApiResponse.access_token,
					expires_in: tokenApiResponse.expires_in,
					access_token: tokenApiResponse.access_token,
					refresh_token: tokenApiResponse.refresh_token
			};
			var userInfo = Academia.model.authentication.UserInfoModel;

			userInfo.set("accessToken", tokenApiResponse.access_token);
			userInfo.set("refreshToken", tokenApiResponse.refresh_token);
			userInfo.set("expiryTimeForAccessToken", tokenApiResponse.expires_in);

			Academia.app.getController('Academia.controller.authentication.AuthenticationController').loginAccessLoadMainPanel();
			/*setTimeout(function(){
				Academia.app.getController('Academia.controller.authentication.AuthenticationController').loadDataAfterLogin(); 
			},2000);*/
			loadApisFunction();
		}
		var style = document.createElement('style');
		style.type = 'text/css';
		var fullWidth = window.innerWidth;
		//style.innerHTML = '.x-grid .x-header-text { margin-left: 494px !important; } .x-grid .x-header-text-container { left: 0 !important; }';4
		style.innerHTML = '.x-grid .x-header-text-container { width: '+fullWidth+'px !important;left: -245px !important; } .x-grid .x-header-text { margin-left: 110px !important; }';
		document.getElementsByTagName('head')[0].appendChild(style);
		var style2 = document.createElement('style');
        style2.type = 'text/css';
        style2.innerHTML='.centerAlignTitle.x-grid .x-header-text-container { width: inherit !important;;left: unset!important;; }';
        document.getElementsByTagName('head')[0].appendChild(style2);
        var style3 = document.createElement('style');
        style3.type = 'text/css';
        style3.innerHTML='.parallelGridCenterAlignTitle.x-grid .x-header-text { margin-left: 145px !important; }';
        document.getElementsByTagName('head')[0].appendChild(style3);
        
		window.addEventListener('keydown', function(e) {
    		if(e.keyCode == 32 && e.target == document.body) {
    	    	e.preventDefault();
    	  	}
    	});
		
		if(sessionStorage.getItem(window.name+'_registrationPortalToken') || sessionStorage.getItem('registrationPortalToken') || sessionStorage.registrationPortalToken){
			sessionStorage.removeItem(window.name+'_registrationPortalToken');
			sessionStorage.removeItem('registrationPortalToken');
		}
	},
	runAction:function(controllerName, actionName){
		var controller = this.getController(controllerName);
	},
	ctrls: []                              
});

/* checkcolumn override for click event to be work on checkbox only */
Ext.override(Ext.grid.column.CheckColumn, {
	processEvent: function(type1, view, cell, recordIndex, cellIndex, e, record, row) {
        var me = this,
            key = (type1 === 'keydown' && e.getKey()),
            mousedown = (type1 == 'mousedown');

        if (mousedown && !Ext.fly(e.getTarget()).hasCls('x-grid-checkcolumn')) {
            return !me.stopSelection;
        }

        me.callParent([type1, view, cell, recordIndex, cellIndex, e, record, row]);
    }
});

/* 
 * @author : abhishek.bais
 * @since  : 04-07-2017
 * @description : This Section Add For Customize Sorting Order Of Grid Column
 */
Ext.override(Ext.grid.column.Column, {
	listeners:{
		hide: function(column){
			resetGridHeaderFix(this.up('grid'));
		},
		show: function(column){
			resetGridHeaderFix(this.up('grid'));
		}
	},
	doSort : function(state) {
		var ds = this.up('grid').store;
		var field = this.getSortParam();
		var grid = this.up('grid');
		if(ds.sorters.length){
			var oldIndex;
			var dataIndex = ds.sorters.keys[0];
			var gridColumns = this.up('grid').columns;
			for (oldIndex = 0; oldIndex < gridColumns.length; ++oldIndex) {
				if (gridColumns[oldIndex].dataIndex == dataIndex) { break; }
			}
			grid.store.applyState({root: "data", property: "", direction: ""});
			grid.columns[oldIndex].setSortState(null);
			grid.store.sorters.clear();
			grid.view.refresh();
		}
		if(Ext.isDefined(grid.getStore()) && Ext.isDefined(grid.getStore().getProxy()) && Ext.isDefined(grid.getStore().getProxy().api) && Object.keys(grid.getStore().getProxy().api).length>0 && grid.getStore().remoteSort==true){
			grid.getStore().load({
				callback: function(){
					ds.sort({
						property : field,
						direction : state,
						sorterFn : function(v1, v2) {
							var reA = /[^a-zA-Z]/g;
							var reN = /[^0-9]/g;
							if (!isNullOrEmpty(v1.get(field))
									&& !isNullOrEmpty(v2.get(field))) {
								if (typeof (v1.get(field)) == "string" && typeof (v2.get(field)) == "string") {
									v1 = v1.get(field);
									v2 = v2.get(field);
									var aA = v1.replace(reA, "");
									var bA = v2.replace(reA, "");
									if(aA.toLowerCase() === bA.toLowerCase()) {
										var aN = parseInt(v1.replace(reN, ""), 10);
										var bN = parseInt(v2.replace(reN, ""), 10);
										return aN === bN ? 0 : aN > bN ? 1 : -1;
									} else {
										return aA.toLowerCase() > bA.toLowerCase() ? 1 : -1;
									}
								} else {
									v1 = v1.get(field);
									v2 = v2.get(field);
									return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
								}
							} else {
								if (isNullOrEmpty(v1.get(field))) {
									v1.set(field, '');
								}
								if (isNullOrEmpty(v2.get(field))) {
									v2.set(field, '');
								}
								v1 = v1.get(field);
								v2 = v2.get(field);
								return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						}
					});
				}
			});
		}
		else{
			ds.sort({
				property : field,
				direction : state
			});
		}
	}
});
Ext.override(Ext.data.proxy.Ajax, { timeout: CONSTANTS.AJAX_TIMEOUT });
/*
 * Overridden the grid panel, applied for grid row editing like excel
 * @ravi.patidar
 */
Ext.override(Ext.grid.plugin.CellEditing,{
	onSpecialKey: function(ed, field, e) {
		Ext.app.gridRendered = true;
		var grid = this.grid,sm;
		if (e.getKey() === e.TAB) {
			e.stopEvent();
			sm = grid.getSelectionModel();
			if (sm.onEditorTab)sm.onEditorTab(this, e);
		}else if(e.getKey() === e.ENTER){
			e.stopEvent();
			sm = grid.getSelectionModel();
			if (sm.onEditorEnter)sm.onEditorEnter(this, e);
		}
	}
});
Ext.override(Ext.selection.RowModel, {
	lastId:null,
	onEditorTab: function(ep, e) {
		me = this,
		view = me.view,
		record = ep.getActiveRecord(),
		header = ep.getActiveColumn(),
		position = view.getPosition(record, header),
		direction = e.shiftKey ? 'left' : 'right',
				newPosition = view.walkCells(position, direction, e, false),
				newId=newPosition.row,
				grid=view.up('gridpanel');
		var myInterval = setInterval(function(){
			if(Ext.app.gridRendered){
				if(newPosition.column >= 10){
					deltaX = -Infinity;
					header=grid.headerCt.getHeaderAtIndex(0);
					position = view.getPosition(record, header);
					position.row = position.row+1;
					if(header){
						while(!header.getEditor()){
							position= view.walkCells(position,direction, e, false);
							header=grid.headerCt.getHeaderAtIndex(position.column);
						}
					}
					newPosition = position;
				} else if (me.lastId!=newId && me.lastId!=null){
					deltaX = me.lastId<newId? -Infinity : Infinity;
					header=grid.headerCt.getHeaderAtIndex(newPosition.column);
					if(header){
						while(!header.getEditor()){
							newPosition= view.walkCells(newPosition,direction, e, false);
							header=grid.headerCt.getHeaderAtIndex(newPosition.column);
						}
					}
				} else {
					deltaX = ep.context.column.width * (direction== 'right' ? 1 : -1);
				}
				grid.scrollByDeltaX(deltaX);
				me.lastId=newPosition.row;
				if (newPosition)ep.startEditByPosition(newPosition);
				else ep.completeEdit();
				Ext.app.gridRendered = false;
				clearInterval(myInterval);
			}
		}, 100);
	},
	onEditorEnter:function(ep,e){
		var me = this,
		view = me.view,
		record = ep.getActiveRecord(),
		header = ep.getActiveColumn(),
		position = view.getPosition(record, header),
		direction = e.shiftKey ? 'up' : 'down',
				newPosition = view.walkCells(position, direction, e, false),
				newId=newPosition.row,
				grid=view.up('gridpanel');

		deltaY=20 * (direction== 'down' ? 1 : -1);
		grid.scrollByDeltaY(deltaY);
		me.lastId=newPosition.row;
		Ext.defer(function(){
			if(Ext.app.gridRendered){
				if (newPosition)ep.startEditByPosition(newPosition);
				else ep.completeEdit();
			}
		}, 100);
	}
});
/**
 * Overridden the text field to set max Length 
 */
Ext.override(Ext.form.field.Text, {
	maxLength : 255,
	enforceMaxLength :true,
	msgTarget: 'side',
	listeners:{
		blur : function(){
			if(this.xtype =='textfield' || this.xtype =='textarea' || this.xtype =='textareafield'){
				var str = this.getValue();
				if(!isNullOrEmpty(str)){
					str = str.replace(/\s{2,}/g, ' ');
					this.setValue(str.trim());				
				}
			}
		},
		beforeedit: function() {
			if(this.xtype =='textfield' && this.readOnly == true){
				 return false;
			}
       },
       render: function(field) {
       	if(this.xtype =='textfield' && this.readOnly == true){
           field.getEl().on('keydown', function(e) {
               e.stopEvent();
           });
       	}
       }
	}
});
/**
 * Overridden the text Area to set max Length 
 */
Ext.override(Ext.form.field.TextArea, {
	enforceMaxLength :true,
	listeners:{
		render : function(me,eOpts){
			if(me.name=="smsDiscription"){
				var maxLength = localStorage.getItem('maxLength');
				me.maxLength = maxLength;
				me.el.dom.children[0].children[0].children[0].children[1].maxLength = maxLength;
			}
		}
	}
});
/**
 * Overridden the display field to set max Length text
 */
Ext.override(Ext.form.field.Display, {
	listeners:{
		render : function(me,eOpts){
			if(me.name=="smsDiscriptionNotice"){
				var maxLength = localStorage.getItem('maxLength');
				me.setValue('<span class="required" style="color:red">'+getMessagingModuleTranslation('MAX_LENGTH_MESSAGE')+maxLength+'/'+maxLength+'</span>');
			}
		}
	}
});
/**
 * Overridden the combo field and added a matchFieldWidth.
 * Whether the picker dropdown's width should be explicitly set to match the width of the field
 * @author Rajkumar.Patidar
 */
Ext.override(Ext.form.field.ComboBox, {
	matchFieldWidth : false,
	listConfig: {
		listeners: {
			beforeshow: function(picker) {
				picker.minWidth = picker.up('combobox').getSize().width;
			}
		}
	}
});
/**
 * Overridden each component for help field behaviour.
 * @author Akshay.Kalbhor
 */
Ext.override(Ext.Component, {
	afterRender: function(cmp)
	{
		if(Ext.isDefined(this) && Ext.isDefined(this.xtype)){
			var self = this;
			var parent = this.up();
			var selfXtype = this.xtype;
			var parentXtype = (Ext.isDefined(parent) && parent.xtype) ? parent.xtype+"_" : "";
			var selfName = Ext.isDefined(this.name) ? this.name+"_" : "";
			var selfItemId = Ext.isDefined(this.itemId) ? this.itemId+"_" : "";
			
			var xpath = parentXtype+selfName+selfItemId+selfXtype;
			
			if(selfXtype && selfXtype == "verticalnavigationmenubutton"){
				xpath = xpath + "_" + this.displayCode;
			}
				
			if(self && self.el && self.el.dom && self.el.dom.setAttribute){
				self.el.dom.setAttribute('data-xpath', xpath);
			}
		}
		
		//-- Start - Code to hide combo picker on parent panel scroll - V2D-409676
		if(Ext.isDefined(this) && Ext.isDefined(this.xtype) && Ext.isDefined(this.superclass) && Ext.isDefined(this.superclass.xtypesChain) && Ext.isArray(this.superclass.xtypesChain) && Ext.Array.contains(this.superclass.xtypesChain, "container")){
			if(this.autoScroll){
				try{
					this.body.on('scroll', function(){
						if(Ext.query('.x-boundlist:visible').length){
							var boundListCombo = Ext.getCmp(Ext.query('.x-boundlist:visible')[0].id).up('combo');
							if(boundListCombo && Ext.isDefined(boundListCombo) && boundListCombo.collapse){
								boundListCombo.collapse();
							}
						}
					});
				}
				catch(e){
					//
				}
			}
		}
		//-- End - Code to hide combo picker on parent panel scroll - V2D-409676
		
		var elements = Ext.ComponentQuery.query('[translationKey]');
		Ext.each(elements, function(element){
			if(element.translationKey){
				if(element.xtype == 'textfield' || element.xtype == 'combo')
					element.setFieldLabel(getCommonTranslation(element.translationKey));
				else if(element.xtype == 'button')
					element.setText(getCommonTranslation(element.translationKey));
			}
		});
		/**
		 * Apply new CSS and Icon class on all grid button (add, edit, view, delete and print) in Academia 
		 * 
		 */
		if((this && this.superclass && this.superclass.xtypesChain && Ext.Array.contains(this.superclass.xtypesChain,'grid')) || (this &&  this.xtype == 'grid')){
			if(this.getHeader() == false){
				this.header=null;
				if(this.xtype == 'griddashlet'){
					this.setTitle(' ');
				}else{
					this.setTitle(this.title);
				}
				
			}
			if(!this.getHeader()){
				this.setTitle(' ');
			}
			if((this.down('custompagingtoolbar') || this.xtype == 'searchresultgrid')){
				this.getHeader().insert(0, {xtype: 'customTopPagingToolBar'});
				var pagingDisplayField = this.down('#pagingDisplayField');
				if(pagingDisplayField){
					pagingDisplayField.setVisible(false);
				}
			}else{
				if(this.itemId !=='outStandingAmountDashlet' && this.xtype !=='studentfeepayerdetaildocumentgrid' && this.xtype !=='studentpassportdocumentgrid' && this.xtype !=='studentpassporturlgrid'
					&& this.xtype !=='proofofactivitydocumentgrid'&& this.xtype !=='independentnonexaminingchairpersondocgrid'
					&& this.xtype !=='studentthesisuploaddocumentgrid'&& this.xtype !=='studentethicsclearanceletterdocumentgrid'
					&& this.xtype !=='studentmoudocumentgrid'&& this.xtype !=='functionaryprogressreportdocumentgrid'
					&& this.xtype !=='studentownprogressreportdocumentgrid'&& this.xtype !=='studentjointdegreedocumentgrid'&& this.xtype !=='postdocinfodocumentgrid'
					&& this.xtype !=='studenthealthinformationdocumentgrid'&& this.xtype !=='studenthealthinformationurlgrid'
				    && this.xtype !=='studenteducationhistorydocumentgrid'&& this.xtype !=='studenteducationhistoryurlgrid'
					&& this.xtype !=='studentlanguagedocumentgrid'&& this.xtype !=='studentlanguageurlgrid'
					&& this.xtype !=='trainingtypedocument'&& this.xtype !=='patenttypedocument'&& this.xtype !=='studentvisaurlgrid'&& this.xtype !=='studentvisadocumentgrid'
					&& this.xtype !=='applicantvisadocumentgrid'&& this.xtype !=='applicantvisaurlgrid'&& this.xtype !=='studentlanguagedocumentgrid'&& this.xtype !=='studentlanguageurlgrid'
					&& this.xtype !=='applicantlanguagedocdetailgrid'&& this.xtype !=='applicantlangurlgrid'&& this.xtype !=='permitdocumentgrid'&& this.xtype !=='permiturldocumentgrid'
					&& this.xtype !=='applicantpermitdocumentgrid'&& this.xtype !=='applicantpermiturldocumentgrid'&& this.xtype !=='feepayerdetaildocumentgrid'
					&& this.xtype !=='applicanteducationhistoryurlgrid'&& this.xtype !=='applicanteducationhistorydocumentgrid' && this.xtype !=='homeworkassignmentdocumentgrid'
					&& this.xtype !=='studenthomeworkassignmentdocumentgrid'
					&& this.xtype  !=='studentinsurancedocumentgrid' && this.xtype  !=='studentinsuranceurlgrid'){
				this.getHeader().insert(0, {xtype:'displayfield',
					minWidth:40,
					height:30,
					//hidden:true,
					itemId:'totalRecordDisplayField',
					name:'totalRecordDisplayField',
					cls:'total-Count-cls',
					margin:'-3x 0px 0px 10px',
					value:getCommonTranslation('TOTAL_RECORDS')+": 0"
					});
			  }
			}
			if(this.down('toolbar')){
				var toolbarBtnsArray = Ext.query('#'+this.down('toolbar').id+' .x-btn');
				Ext.each(toolbarBtnsArray, function(currentbtn){
					var currentBtnCmp = Ext.getCmp(currentbtn.id);
					var btnCheck = currentBtnCmp.glyph;
					if(!currentBtnCmp.glyph){
						 btnCheck = currentBtnCmp.iconCls;
					}
					if(currentBtnCmp.icon && currentBtnCmp.icon.indexOf('print1') != -1){
						btnCheck = 'printBtn';
					}
						switch (btnCheck) {
					  case '70@Pictos':
						  var spanBtn = Ext.query('#'+currentBtnCmp.id+' span[role=img]');
					    if(spanBtn && spanBtn[0]){
					    	spanBtn[0].removeAttribute('class');
					    	Ext.get(spanBtn[0]).update('');
					    	spanBtn[0].setAttribute('class','x-btn-icon-el icon-addbutton');
					    	currentBtnCmp.setIconCls('icon-addbutton')
					    	currentBtnCmp.addCls('addbutton')

					    }
					    break;
					  case 'view-icon':
						  var spanBtn = Ext.query('#'+currentBtnCmp.id+' span[role=img]');
						  if(spanBtn && spanBtn[0]){
						    	spanBtn[0].removeAttribute('class');
						    	Ext.get(spanBtn[0]).update('');
						    	spanBtn[0].setAttribute('class','x-btn-icon-el icon-View');
						    	currentBtnCmp.setIconCls('icon-View');
						    	currentBtnCmp.addCls('iconView');

						    }
						  break;
					  case '116@Pictos':
						  var spanBtn = Ext.query('#'+currentBtnCmp.id+' span[role=img]');
						  if(spanBtn && spanBtn[0]){
						    	spanBtn[0].removeAttribute('class');
						    	Ext.get(spanBtn[0]).update('');
						    	spanBtn[0].setAttribute('class','x-btn-icon-el icon-Delete');
						    	currentBtnCmp.setIconCls('icon-Delete');
						    	currentBtnCmp.addCls('iconDelete');

						    }
					    break;
					  case '47@Pictos':
					    var spanBtn = Ext.query('#'+currentBtnCmp.id+' span[role=img]');
					    if(spanBtn && spanBtn[0]){
					    	spanBtn[0].removeAttribute('class');
					    	Ext.get(spanBtn[0]).update('');
					    	spanBtn[0].setAttribute('class','x-btn-icon-el icon-editbutton');
					    	currentBtnCmp.setIconCls('icon-editbutton');
					    	currentBtnCmp.addCls('editbutton');

					    }
				    break;
					  case 'printBtn':
						    var spanBtn = Ext.query('#'+currentBtnCmp.id+' span[role=img]');
						    if(spanBtn && spanBtn[0]){
						    	spanBtn[0].removeAttribute('class');
						    	Ext.get(spanBtn[0]).update('');
						    	spanBtn[0].setAttribute('class','x-btn-icon-el print-btn');
						    	currentBtnCmp.setIconCls('print-btn');

						    }
					    break;
					  case '76@Pictos':
						    var spanBtn = Ext.query('#'+currentBtnCmp.id+' span[role=img]');
						    if(spanBtn && spanBtn[0]){
						    	spanBtn[0].removeAttribute('class');
						    	Ext.get(spanBtn[0]).update('');
						    	spanBtn[0].setAttribute('class','x-btn-icon-el refresh-icon');
						    	currentBtnCmp.setIconCls('refresh-icon');
						    	currentBtnCmp.addCls('refresh-btn');

						    }
					    break;
					}
				});
				var toolItems = this.down('toolbar').items.items;
				var isTbfill = false;
				toolItems.forEach(function(item){
					if(item.xtype == 'tbfill'){
						isTbfill = true;
					}
					if(isTbfill){
						item.addCls('algin-right-cls')
					}
				});
				var splitBtn=this.query('splitbutton');
				splitBtn.forEach(function(rec){
					rec.menu && rec.menu.addCls('moreActionNewMneuBtnCls');
				    if(rec.menu && rec.menu.items && rec.menu.items.items){
				    	rec.menu.items.items.forEach(function(menuItem){
				    		menuItem.addCls('moreActionNewMneuBtnCls');
				    	});
				    }
				});
			}
		}
		/**
		 * Overridden Calendar for checking and adding 'Export' button.
		 * @author Raghavendra.Soni
		 */
		try{
			if(Ext.isDefined(this.showExportToPNG) && this.showExportToPNG==true){
				//--getting calendar
				var cal = this;
				//--getting buttonContainer to place export button
				var buttonContainer = '';
				if(cal.getDockedItems('toolbar').length){
					buttonContainer = cal.getDockedItems('toolbar')[0];
				}
				else if(cal.up().getDockedItems('toolbar').length){
					buttonContainer = cal.up().getDockedItems('toolbar')[0];
				}
				else if(Ext.isDefined(cal.up().down('fieldcontainer'))){
					buttonContainer = cal.up().down('fieldcontainer');
				}
				if(!isNullOrEmpty(buttonContainer)){
					//--generating random id for new export button
					var exportButtonId = randomString(7);
					//--adding export button to buttonContainer
					buttonContainer.add({
						xtype: 'button',
						text: getCommonTranslation('EXPORT_TO_PNG'),
						id: exportButtonId,
						buttonAlign : 'right',
						ui : 'CustomBtnSubmit',
						itemId:'exportToPngBtn',
						scale : CONSTANTS.BUTTONSIZE,
						cls: 'x-btn x-unselectable x-btn-CustomBtnSubmit-small x-noicon x-btn-noicon x-btn-CustomBtnSubmit-small-noicon',
						handler: function(button){
							//--- generating exported file name dynamically
							try{
								var tabTitle = button.up('tabpanel').getActiveTab().title;
							}
							catch(e){
								var tabTitle = getCommonTranslation('EXPORT_TO_PNG');
							}
							var fileName = tabTitle.replace(/ /g,'_').toLowerCase() + ".png";

							//--- reconfigure texts before exporting
							var evtBody = Ext.query('.ext-evt-bd');
							Ext.each(evtBody, function(currentEvt){
								currentEvt.innerText = currentEvt.innerText.replace(/-/g, ' - ');
							});
							var element = '';        					
							if(Ext.isDefined(button.up('calendarpanel'))){
								var isPrintBtnPresent = false;
								try{
									if(Ext.isDefined(button.up('calendarpanel').down('#btnPrint'))){
										button.up('calendarpanel').down('#btnPrint').el.dom.style.opacity = 0;
										isPrintBtnPresent = true;
									}
								}
								catch(e){
									isPrintBtnPresent = false;
								}
								button.el.dom.style.opacity = 0;
								var element = button.up('calendarpanel').el.dom;
								setTimeout(function(){
									button.el.dom.style.opacity = 1;
									if(isPrintBtnPresent){
										button.up('calendarpanel').down('#btnPrint').el.dom.style.opacity = 1;
									}
								},1);
							}
							else if(button.up('panel').down('calendarpanel')){
								var element = button.up('panel').down('calendarpanel').el.dom;
							}
							if(!isNullOrEmpty(element)){
								var getCanvas;
								html2canvas(element).then(function(canvas){
									document.body.appendChild(canvas);
									getCanvas = canvas;
									var imgageData = getCanvas.toDataURL("image/png");
									var newData = imgageData.replace(/^data:image\/png/, "data:application/octet-stream");
									saveExportedPNGFile(fileName, newData);
									setTimeout(function(){
										document.body.removeChild(canvas);
									},300);
								});
							}
						}
					});
				}
			}
		}
		catch (e){
		}
		
		try{
			if(Ext.isDefined(this.headerFix) && Ext.isDefined(this.headerFix.headerFix) && Ext.isDefined(this.headerFix.portalIdsWithStructure) && this.headerFix.headerFix==true && Ext.Object.getSize(this.headerFix.portalIdsWithStructure)>0){
				var currentGrid = this;
				var currentPortalId = localStorage.getItem('portalId');
				Ext.each(currentGrid.headerFix.portalIdsWithStructure, function(name){
					var structureName = Object.keys(name)[0];
					var structurePortalId = Object.values(name)[0];
					if(currentPortalId==structurePortalId){
						setTimeout(function(){
							freezeCurrentGrid(currentGrid,structureName);
						},300);
					}
				});
			}
			
			if(Ext.isDefined(this.isGridConfigurable) && this.isGridConfigurable==true){
				var currentGrid = this;
				var currentPortalId = localStorage.getItem('portalId');
				currentGrid.addCls('hiddenMenuCls');

				var isCBGrid = false;
				var isSync=true;
				var gridClass = currentGrid.$className;
				
				if(gridClass.indexOf("SearchResultGrid")!=-1){
					gridClass = currentGrid.cbViewCode;
					isCBGrid = true;
					isSync=false;
				}
				
				var parentUserId = null;
				if(!isNullOrEmpty(localStorage.getItem('parentUserId')) && !isNullOrEmpty(currentPortalId) && currentPortalId==7) {
					parentUserId = localStorage.getItem('parentUserId');
				}
				
				Ext.Ajax.request({
    				type : 'rest',
    				url : SERVERURL.PATH_GET_GRID_COLUMN_CONFIGURATION,
    				params : {
    					portalId : currentPortalId,
    					parentUserId : parentUserId,
    					gridName : gridClass
    				},
    				method : 'GET',
    				async:isSync,
    				success : function(response) {
    				if(response.responseText!=''){
    					var respData = Ext.decode(response.responseText);
    					var responseData = Ext.decode(respData.jsonObject);
    					
    					var respUserData = respData;
    					
    					var hiddenColumns = [];
    					var removedColumns = [];
    					var visibleColumns = [];
    					Ext.each(responseData, function(currentResponseColumn){
    						if(currentResponseColumn.columnVisibility=="HIDE"){
    							hiddenColumns.push(currentResponseColumn.dataIndex);
    						}
    						else if(currentResponseColumn.columnVisibility=="REMOVE"){
    							removedColumns.push(currentResponseColumn.dataIndex);
    						}
    						else if(currentResponseColumn.columnVisibility=="SHOW"){
    							visibleColumns.push(currentResponseColumn.dataIndex);
    						}
    					});
    					if(!isCBGrid){
    						var gridColumn=currentGrid.columns;
    						if(isNullOrEmpty(gridColumn)){
    							gridColumn=currentGrid.down('grid').columns;
    						}
        					Ext.each(gridColumn, function(currentGridColumn){
        						try{
        							if(Ext.Array.contains(hiddenColumns,currentGridColumn.dataIndex)){
        								currentGridColumn.hide();
        							}
        							/*else if(Ext.Array.contains(removedColumns,currentGridColumn.dataIndex)){
        								currentGridColumn.destroy();
        							}*/
        							else if(Ext.Array.contains(visibleColumns,currentGridColumn.dataIndex)){
        								currentGridColumn.show();
        								currentGridColumn.menuDisabled = true;
        							}
        							else{
        								currentGridColumn.hide();
        							}
        						}
        						catch(e){}
        					});
    					}

    					/*currentGrid.getStore().on('beforeload',function(){
    						var baseController = Academia.app.getController('Academia.controller.base.BaseController');
    						currentGrid.getStore().getProxy().extraParams.userId = baseController.getCurrentlyLoggedInUser().id;
    						currentGrid.getStore().getProxy().extraParams.portalId = baseController.getCurrentLoggedPortalId();
    					});*/
    					
    					Ext.Ajax.request({
            				type : 'rest',
            				url : SERVERURL.PATH_GET_GRID_COLUMN_CONFIGURATION_DEFAULT,
            				params : {
            					portalId : currentPortalId,
            					gridName : gridClass
            				},
            				async:isSync,
            				method : 'GET',
            				success : function(response) {
            					var respData = Ext.decode(response.responseText);
            					var responseData1 = Ext.decode(respData[0].jsonObject);
                    			
                    			var resultGridStoreData = [];
                    			var isHiddenColumnGrid = false;
                    			Ext.each(responseData1, function(currentGridColumn){
                    				resultGridStoreData.push({
                    					id: currentGridColumn.id,
                    					columnName: currentGridColumn.columnName,
                    					dataIndex: currentGridColumn.dataIndex,
                    					columnVisibility: currentGridColumn.columnVisibility,
                    					mandatory: currentGridColumn.mandatory,
                    					sequence: currentGridColumn.sequence
                    				});
                    			});
                    			if(respData[0].isVisibleColumn){
            						isHiddenColumnGrid = false;
            					}else{
            						isHiddenColumnGrid = true;
            					}
                    			if(currentGrid.xtype == "griddashlet"){
                    				var panel = currentGrid.up();
                    				currentGrid.up().addDataGridConfigureButtonDashlet(panel,gridClass,resultGridStoreData,responseData,respUserData);
                    			}
                    			else{
                    				if(isNullOrEmpty(currentGrid.getHeader())){
                    					var grid= currentGrid.down('grid');
                    					if(!isNullOrEmpty(grid)){
                    						grid.getHeader().add({
                    							xtype: 'button',
                    							text: getCommonTranslation('COLUMNS'), 
                    							ui: 'CustomBtnSubmit',
                    							cls:'common-btn-cls',
                    							scale: CONSTANTS.BUTTONSIZE,
                    							gridClass: gridClass,
                    							hidden:isHiddenColumnGrid,
                    							defaultColumns: resultGridStoreData,
                    							userDefinedColumns: responseData,
                    							recordId: respUserData.id,
                    							dataGridId: respUserData.dataGridId,
                    							handler: function(btn){
                    								createColumnWindow(gridClass, btn.recordId, btn.dataGridId, btn.defaultColumns, btn.userDefinedColumns);
                    							}
                    						});
                    					}
                    				}else{
                    					currentGrid.getHeader().add({
                    				        xtype: 'button',
                    			            text: getCommonTranslation('COLUMNS'), 
                    			            ui: 'CustomBtnSubmit',
                    			            cls:'common-btn-cls',
                    		    			scale: CONSTANTS.BUTTONSIZE,
                    			            gridClass: gridClass,
                    			            hidden:isHiddenColumnGrid,
                    			            defaultColumns: resultGridStoreData,
                    			            userDefinedColumns: responseData,
                    			            recordId: respUserData.id,
                    			            dataGridId: respUserData.dataGridId,
                    			            handler: function(btn){
                    			            	createColumnWindow(gridClass, btn.recordId, btn.dataGridId, btn.defaultColumns, btn.userDefinedColumns);
                    			            }
                    				    });
                    				}
                    			}
            				}
            			});
    				}
    				}
				});
			}
			
			/**********Start Code added for clear Report Header data for again new tab open*****/
			if(Ext.isDefined(this.config) && Ext.isDefined(this.config.searchFilterForm)){
				delete this.config.searchFilterForm;
			}
			if(Ext.isDefined(this.config) && Ext.isDefined(this.config.htmlFilter)){
				delete this.config.htmlFilter;
			}
			if(Ext.isDefined(this.config) && Ext.isDefined(this.config.htmlFilterExcel)){
				delete this.config.htmlFilterExcel;
			}
			/**********End Code added for clear Report Header data for again new tab open*****/
			if(this.$className == "Ext.tree.Panel" || this.xtype == "treepanel") {
				var me = this;
				Ext.defer(function() {
					var domEl = me.el.dom.querySelector('.x-header-text-container');
					var style = document.createElement('style');
					style.type = 'text/css';
					style.innerHTML = '.x-tree-panel.x-grid .x-header-text-container { width: '+domEl.style.width+' !important;left: '+domEl.style.left+' !important; }';
					document.getElementsByTagName('head')[0].appendChild(style);
					
					me.on('collapse', function() {
						Ext.defer(function() {
							var domEl = me.reExpander.el.dom.querySelector('.x-header-text-container');
							var style = document.createElement('style');
							style.type = 'text/css';
							style.innerHTML = '.x-tree-panel.x-grid .x-header-text-container { width: '+domEl.style.width+' !important;left: '+domEl.style.left+' !important; }';
							document.getElementsByTagName('head')[0].appendChild(style);
						}, 1);
					});
					me.on('beforeexpand', function() {
						var domEl = me.el.dom.querySelector('.x-header-text-container');
						var style = document.createElement('style');
						style.type = 'text/css';
						style.innerHTML = '.x-tree-panel.x-grid .x-header-text-container { width: '+domEl.style.width+' !important;left: 0px !important; }';
						document.getElementsByTagName('head')[0].appendChild(style);
				});
				}, 1);
				
			}
			/** start - validate filefield and form if filefield's browse button clicked and then cancle button **/
			if(this.xtype == "filefield" && this.allowBlank == false) {
				var fileField = this;
				fileField.on('boxready', function() {
					Ext.defer(function() {
						var inputEl = fileField.getEl().down('input[type=file]').dom;
						document.getElementById(inputEl.id).addEventListener('change', function(event) {
						// Check if files were selected
							if (event.target.files.length === 0) {
								fileField.up('form').isValid();
								fileField.clearInvalid();
							}
						});
					}, 500);
					fileField.button.on('click', function() {
						fileFieldInterval = setInterval(fileFieldTimer, 100);
						function fileFieldTimer() {
							if(!fileField.up('form').isValid()) {
								fileField.up('form').getForm().checkValidity();
								fileField.clearInvalid();
								myStopFunction();
							}
						}

						function myStopFunction() {
							clearInterval(fileFieldInterval);
						}
					});
				});
			}
			/** end - validate filefield and form if filefield's browse button clicked and then cancle button **/
		}
		catch(e){
			
		}
		this.callParent(arguments);
	}
});

//Override Ext.Ajax.request to automatically set options.fns
Ext.override(Ext.Ajax, {
    request: function(options) {
        options = options || {};

        // Set fns to the name of the caller function if available
        try {
            if (arguments.callee.caller && !isNullOrEmpty(arguments.callee.caller)) {
                options.fns = (arguments.callee.caller.name=="")?"EMPTY":arguments.callee.caller.name;
            } else {
                options.fns = '';
            }
        } catch (e) {
            options.fns = '';
        }

        // Call the original Ext.Ajax.request with modified options
        return this.callParent([options]);
    }
});

Ext.override(Ext.form.field.Date, {
	submitFormat:CONSTANTS.NEW_SUBMIT_DATE_FORMAT,
    initComponent: function () {
        this.callParent(arguments);
        
        if (this.vtype === 'daterange') {
            this.on('change', function (field, newValue) {
                var form = field.up('form');
                if (!newValue) {
                    if (field.startDateField) {
                        var start = form.down('datefield#' + field.startDateField);
                        if (start) {
                            start.setMaxValue(null);
                            start.validate();
                        }
                    }
                    if (field.endDateField) {
                        var end = form.down('datefield#' + field.endDateField);
                        if (end) {
                            end.setMinValue(null);
                            end.validate();
                        }
                    }
                }
            });
        }
    }
});
Ext.Msg.on('show', function (msg) {
    msg.maxWidth=900;
    msg.setWidth(400);
    msg.center();
});
//--Tooltip issue on IE
Ext.override(Ext.tip.QuickTip, {
    helperElId: 'ext-quicktips-tip-helper',
    initComponent: function ()
    {
        var me = this;

        me.target = me.target || Ext.getDoc();
        me.targets = me.targets || {};
        me.callParent();

        // new stuff
        me.on('move', function ()
        {
            var offset = me.hasCls('x-tip-form-invalid') ? 35 : 27,
                helperEl = Ext.fly(me.helperElId) || Ext.fly(
                    Ext.DomHelper.createDom({
                        tag: 'div',
                        id: me.helperElId,
                        style: {
                            position: 'absolute',
                            left: '-1000px',
                            top: '-1000px',
                            'font-size': '12px',
                            'font-family': 'tahoma, arial, verdana, sans-serif'
                        }
                    }, Ext.getBody())
                );
            try{
            	if(!isNullOrEmpty(me.html) && (me.html.length <= '2000' && me.html.length>='1000')){
                	helperEl.update(me.html);
                	me.setWidth(600);
                }
                else if (me.html && (me.html !== helperEl.getHTML() || me.getWidth() !== (helperEl.dom.clientWidth + offset)))
                {
                    helperEl.update(me.html);
                    me.setWidth(Ext.Number.constrain(helperEl.dom.clientWidth + offset, me.minWidth, me.maxWidth));
                }
            }
            catch(e){
            	if (me.html && (me.html !== helperEl.getHTML() || me.getWidth() !== (helperEl.dom.clientWidth + offset)))
                {
                    helperEl.update(me.html);
                    me.setWidth(Ext.Number.constrain(helperEl.dom.clientWidth + offset, me.minWidth, me.maxWidth));
                }
            }
        }, this);
    }
});
Ext.override(Ext.window.Window,{
	initComponent: function ()
	{
		var me = this;
		me.target = me.target || Ext.getDoc();
		me.targets = me.targets || {};

		me.callParent();
		me.on('show', function ()
				{
			if(me.id !='NotificationAlertWindow') {
				var el = me.getEl();
				el.setOpacity(0);
				el.fadeIn({
					duration: 800
				});
			}
			
		}, this);

		me.on('beforeclose',function(win){
			if(win.id !='NotificationAlertWindow') {
				
			if (!win.shouldClose) {
					win.getEl().fadeOut({
						duration: 500,
						callback: function () {
							win.shouldClose = true;
							win.close();
						}
					});
				}
			return win.shouldClose ? true : false;
			}
			
		});


	}
});
//to manage sorting menu through translation //
Ext.override(Ext.form.field.File, {
	listeners:{
		change : function(field, value, eOpts){
			try{
				var filename = value.replace(/^.*[\\\/]/, '');
				if(!isValidFile(filename)){
					field.reset();
					return false;
				}
			}
			catch(e){
				//error
			}
		}
	}
});

Ext.override(Ext.grid.header.Container, {
	getMenuItems :function(){
		   var me = this,
           menuItems = [],
           hideableColumns = me.enableColumnHide ? me.getColumnMenu(me) : null;

       if (me.sortable) {
           menuItems = [{
               itemId: 'ascItem',
               text: getCommonTranslation("SORT_ASCENDING"),
               cls: me.menuSortAscCls,
               handler: me.onSortAscClick,
               scope: me
           },{
               itemId: 'descItem',
               text: getCommonTranslation("SORT_DESCENDING"),
               cls: me.menuSortDescCls,
               handler: me.onSortDescClick,
               scope: me
           }];
       }
       if (hideableColumns && hideableColumns.length) {
           if (me.sortable) {
               menuItems.push('-');
           }
           menuItems.push({
               itemId: 'columnItem',
               text: getCommonTranslation('COLUMNS'),
               cls: me.menuColsIcon,
               menu: hideableColumns,
               hideOnClick: false
           });
       }
       return menuItems;
	}
		
});

/**
 * Overridden the grid to set total records
 */
Ext.override(Ext.grid.View, {
	refresh : function(grid){
		var me = this,
		hasFocus = me.el && me.el.isAncestor(Ext.Element.getActiveElement());

		me.callParent(arguments);
		me.headerCt.setSortState();

		// Create horizontal stretcher element if no records in view and there is overflow of the header container.
		// Element will be transient and destroyed by the next refresh.
		if (me.el && !me.all.getCount() && me.headerCt && me.headerCt.tooNarrow) {
			me.el.createChild({style:'position:absolute;height:1px;width:1px;left:' + (me.headerCt.getFullWidth() - 1) + 'px'});
		}

		if (hasFocus) {
			me.selModel.onLastFocusChanged(null, me.selModel.lastFocused);
		}

		var grid = this.up('grid');
		var gridDom = grid.el ? grid.el.dom : null;

		if(gridDom){

			try{
				grid.on('hide', function(){
					try{
						Ext.query('.'+this.id)[0].style.display = 'none';
					}
					catch(e){
						//
					}
				});
				grid.on('destroy', function(){
					try{
						Ext.query('.'+this.id)[0].style.display = 'none';
					}
					catch(e){
						//
					}
				});
				grid.on('show', function(){
					try{
						Ext.query('.'+this.id)[0].style.display = '';
					}
					catch(e){
						//
					}
				});
				grid.on('afterlayout', function(curGrid){
					var curGridLeft = curGrid.el.dom.offsetLeft;
					var curGridWidth = curGrid.el.dom.offsetWidth;
					var curGridTop = curGrid.el.dom.offsetTop;
					var curGridHeight = curGrid.el.dom.offsetHeight;

					if(Ext.query('.'+curGrid.id).length){
						Ext.query('.'+curGrid.id)[0].style.width = '150px';
						Ext.query('.'+curGrid.id)[0].style.left = (curGridLeft + curGridWidth - 150) + 'px';
						Ext.query('.'+curGrid.id)[0].style['float'] = 'initial';
						Ext.query('.'+curGrid.id)[0].style['top'] = (curGridTop + curGridHeight + 5) + 'px';
						Ext.query('.'+curGrid.id)[0].style.position = 'absolute';
					}
					
					//-- START HERE --- Grid Header Fix issue on tab change (Generic)
						resetGridHeaderFix(curGrid);
					//-- START HERE --- Grid Header Fix issue on tab change (Generic)
				});
			}
			catch(e){
				//
			}

			if(grid.xtype!=="courseparametergrid"){
				if(gridDom.parentNode && (gridDom.parentNode.lastElementChild.className== "gridTotalDivCls")){
					gridDom.parentNode.removeChild(gridDom.parentNode.lastElementChild)
				}

				try{
					if(gridDom.parentNode && $('.gridTotalDivCls.'+grid.id).length == 1){
						gridDom.parentNode.removeChild($('.gridTotalDivCls.'+grid.id)[0]);
					}
				}
				catch(e){
					try{
						$('.gridTotalDivCls.'+grid.id)[0].parentNode.removeChild($('.gridTotalDivCls.'+grid.id)[0]);
					}
					catch(ee){
						//--
					}
				}
			}

			try{
				if(grid.itemId=="applicationStageBasicSearchGrid" || grid.itemId=="exportAllGrid" || grid.xtype == "hosteldocument"  || grid.itemId=="d365dashletgrid" || grid.xtype.indexOf("documentgrid") >= 0 || grid.itemId=="studentParentGuardianGrid" ||
						 grid.itemId=="studentpassporturlgrid" || grid.itemId=="studentvisaurlgrid" || grid.itemId=="studentinsuranceurlgrid"  || grid.itemId=="studenteducationhistoryurlgrid" || grid.itemId=="studentlanguageurlgrid" ||
						 grid.itemId=="studenthealthinformationurlgrid"){
					//--do not show total records here
				}
				else if(grid.isHidden() == false && ($('.gridTotalDivCls.'+grid.id).length == 0)) {

					if(grid.xtype!=="courseparametergrid"){
						var totalDiv = document.createElement("div");
						totalDiv.className = "gridTotalDivCls "+grid.id;
						totalDiv.innerHTML = "<span class='totalSpanCls'>"+getCommonTranslation('TOTAL_RECORDS')+": 0</span>";
					}

					if(grid.xtype!=="courseparametergrid"){
						if(gridDom.nextSibling) {
							gridDom.parentNode.insertBefore(totalDiv, gridDom.nextSibling);
						} else {
							gridDom.parentNode.appendChild(totalDiv);
						}
						if(gridDom.style.marginBottom == "0px" || gridDom.style.marginBottom =="" ){
							gridDom.style.marginBottom = "10px";
						}
					}
					if (grid.store.totalCount) {
						if( grid.store.getCount() == 0){
							var recordCount =grid.store.getCount();
						}else{
							var recordCount =grid.store.totalCount;
						}

					}else {
						var recordCount = grid.store.getCount();
					}
					if(grid.xtype == 'mapprogramoutcomegrid' || grid.xtype == 'paymenttermconfiguredocumentlistgrid' || grid.xtype == 'availableevents' || grid.xtype == 'programbatchsectiongrid'){
						var recordCount =grid.store.getCount();
					}
					if(grid.xtype!=="courseparametergrid"){
						if(recordCount == 0){
							gridDom.nextElementSibling.children[0].innerText = '';
							
						}else{
						gridDom.nextElementSibling.children[0].innerText = getCommonTranslation('TOTAL_RECORDS')+": "+ recordCount;
					  }
					}
					else{
						if(recordCount == 0){
						 gridDom.nextElementSibling.children[0].children[0].children[0].children[0].children[0].innerText = '';
							
						}else{
						gridDom.nextElementSibling.children[0].children[0].children[0].children[0].children[0].innerText = getCommonTranslation('TOTAL_RECORDS')+": "+ recordCount;
					  }
					}
					if(grid.down('#totalRecordDisplayField')){
						grid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ recordCount)
					}
					if(recordCount > 0){
						grid.addCls('removeBackgroundImageCls');
						grid.removeCls('gridHeightCls');
						
					}else{
						grid.removeCls('removeBackgroundImageCls');
						grid.addCls('gridHeightCls');
					}
					grid.doLayout();
				}
			}
			catch(e){
				//--
			}
		}
	}
});

/*Ext.override(Ext.grid.header.DragZone, { //Commenting as it is creating issue while drag/drop columns
	getDragData: function(e) {
		if (e.getTarget(this.colInnerSelector)) {
            var header = e.getTarget(this.colHeaderSelector),
                headerCmp,
                ddel;

            if (header) {
                headerCmp = Ext.getCmp(header.id);
                if (!this.headerCt.dragging && headerCmp.draggable && !(headerCmp.isOnLeftEdge(e) || headerCmp.isOnRightEdge(e))) {
                    ddel = document.createElement('div');
                    ddel.innerHTML = Ext.getCmp(header.id).text;
                    $('html,body').css('cursor','move');
                    headerCmp.up('grid').addCls("movingColumnGridCls");
                    return {
                        ddel: ddel,
                        header: headerCmp
                    };
                }
            }
        }
        return false;
    }
});

Ext.override(Ext.grid.header.DropZone, {
	onNodeDrop: function(node, dragZone, e, data) {
		var me = this;
        var headerCmp = Ext.getCmp(me.id);
	    $('html,body').css('cursor','auto');
        headerCmp.up('grid').removeCls("movingColumnGridCls");
        if (this.valid) {
            var dragHeader   = data.header,
                dropLocation = data.dropLocation,
                targetHeader = dropLocation.header,
                fromCt       = dragHeader.ownerCt,
                localFromIdx = fromCt.items.indexOf(dragHeader), // Container.items is a MixedCollection
                toCt         = targetHeader.ownerCt,
                localToIdx   = toCt.items.indexOf(targetHeader),
                headerCt     = this.headerCt,
                columnManager= headerCt.columnManager,
                fromIdx      = columnManager.getHeaderIndex(dragHeader),
                toIdx        = columnManager.getHeaderIndex(targetHeader),
                colsToMove   = dragHeader.isGroupHeader ? dragHeader.query(':not([isGroupHeader])').length : 1,
                sameCt       = fromCt === toCt,
                scrollerOwner, savedWidth;

            // Drop position is to the right of the targetHeader, increment the toIdx correctly
            if (dropLocation.pos === 'after') {
                localToIdx++;
                toIdx += targetHeader.isGroupHeader ? targetHeader.query(':not([isGroupHeader])').length : 1;
            }

            // If we are dragging in between two HeaderContainers that have had the lockable
            // mixin injected we will lock/unlock headers in between sections, and then continue
            // with another execution of onNodeDrop to ensure the header is dropped into the correct group
            if (data.isLock) {
                scrollerOwner = fromCt.up('[scrollerOwner]');
                scrollerOwner.lock(dragHeader, localToIdx);
                data.isLock = false;

                // Now that the header has been transferred into the correct HeaderContainer, recurse, and continue the drop operation with the same dragData
                this.onNodeDrop(node, dragZone, e, data);
            } else if (data.isUnlock) {
                scrollerOwner = fromCt.up('[scrollerOwner]');
                scrollerOwner.unlock(dragHeader, localToIdx);
                data.isUnlock = false;

                // Now that the header has been transferred into the correct HeaderContainer, recurse, and continue the drop operation with the same dragData
                this.onNodeDrop(node, dragZone, e, data);
            }
            
            // This is a drop within the same HeaderContainer.
            else {
                this.invalidateDrop();
                // Cache the width here, we need to get it before we removed it from the DOM
                savedWidth = dragHeader.getWidth();
                
                // Dragging within the same container.
                if (sameCt) {
                    // A no-op. This can happen when cross lockable drag operations recurse (see above).
                    // If a drop was a lock/unlock, and the lock/unlock call placed the column in the
                    // desired position (lock places at end, unlock places at beginning) then we're done.
                    if (localToIdx === localFromIdx) {
                        // We still need to inform the rest of the components so that events can be fired.
                        headerCt.onHeaderMoved(dragHeader, colsToMove, fromIdx, toIdx);
                        return;
                    }
                    // If dragging rightwards, then after removal, the insertion index will be less.
                    if (localToIdx > localFromIdx) {
                        localToIdx -= 1;
                    }
                }

                // Suspend layouts while we sort all this out.
                Ext.suspendLayouts();

                if (sameCt) {
                    toCt.move(localFromIdx, localToIdx);
                } else {
                    fromCt.remove(dragHeader, false);
                    toCt.insert(localToIdx, dragHeader);
                }

                // Group headers acquire the aggregate width of their child headers
                // Therefore a child header may not flex; it must contribute a fixed width.
                // But we restore the flex value when moving back into the main header container
                if (toCt.isGroupHeader) {
                    // Adjust the width of the "to" group header only if we dragged in from somewhere else.
                    if (!sameCt) {
                        dragHeader.savedFlex = dragHeader.flex;
                        delete dragHeader.flex;
                        dragHeader.width = savedWidth;
                    }
                } else {
                    if (dragHeader.savedFlex) {
                        dragHeader.flex = dragHeader.savedFlex;
                        delete dragHeader.width;
                    }
                }

                // Refresh columns cache in case we remove an emptied group column
                headerCt.purgeCache();
                Ext.resumeLayouts(true);
                headerCt.onHeaderMoved(dragHeader, colsToMove, fromIdx, toIdx);

                // Ext.grid.header.Container will handle the removal of empty groups, don't handle it here
            }
        }
    }
});

Ext.override(Ext.dd.DragSource, {
	b4EndDrag: function(){
		var me = this;
		
		try{
			if(me.id.indexOf('body') == -1){
				var headerCmp = Ext.getCmp(me.id);
				$('html,body').css('cursor','auto');
				headerCmp.up('grid').removeCls("movingColumnGridCls");
			}
		}
		catch(e){
			//--
		}
	}
});*/

Ext.override(Ext.panel.Table, {
	getView: function() {
        var me = this,
            sm;

        if (!me.view) {
            sm = me.getSelectionModel();
            sm.headerWidth = 40;
            
            // TableView injects the view reference into this grid so that we have a reference as early as possible
            Ext.widget(Ext.apply({

                // Features need a reference to the grid, so configure a reference into the View
                grid: me,
                deferInitialRefresh: me.deferRowRender !== false,
                trackOver: me.trackMouseOver !== false,
                scroll: me.scroll,
                xtype: me.viewType,
                store: me.store,
                headerCt: me.headerCt,
                columnLines: me.columnLines,
                rowLines: me.rowLines,
                selModel: sm,
                features: me.features,
                panel: me,
                emptyText: me.emptyText || ''
            }, me.viewConfig));

            // Normalize the application of the markup wrapping the emptyText config.
            // `emptyText` can now be defined on the grid as well as on its viewConfig, and this led to the emptyText not
            // having the wrapping markup when it was defined in the viewConfig. It should be backwards compatible.
            // Note that in the unlikely event that emptyText is defined on both the grid config and the viewConfig that the viewConfig wins.
            if (me.view.emptyText) {
                me.view.emptyText = '<div class="' + me.emptyCls + '">' + me.view.emptyText + '</div>';
            }

            // TableView's custom component layout, Ext.view.TableLayout requires a reference to the headerCt because it depends on the headerCt doing its work.
            me.view.getComponentLayout().headerCt = me.headerCt;

            me.mon(me.view, {
                uievent: me.processEvent,
                scope: me
            });
            sm.view = me.view;
            me.headerCt.view = me.view;
        }
        return me.view;
    }
});

/* 
 * @since  : 19-01-2023
 * @description : validates combobox selected value
 */
Ext.override(Ext.form.field.ComboBox, {
	validateValue : function(value) {
		if(this.xtype == 'multiselectcombofield') {
			if(this.hasFocus && this.allowBlank == false) {
				var errs = this.getErrors(value);

				if((value || value != "")){
					var val = this.getValue();
					for(var i = 0;i < val.length; i++) {
						var rec;
						if(typeof val[i] == 'object') {
							rec = this.findRecord(this.valueField, val[i].data[this.valueField]);
						}
						else {
							rec = this.findRecord(this.valueField, val[i]);
						}

						if(!rec)
							errs.push("Invalid Selection"); 
					}
				}

				var error = errs[0];

				if (error == undefined) {
					this.clearInvalid();
					return true;
				} else {
					this.markInvalid(error);
					return false;
				}
			}
			else if(this.allowBlank == true) {
				return true;
			}
			else if(this.allowBlank == false && Ext.isEmpty(value)) {
				return false;
			}
			else if(this.allowBlank == false && !Ext.isEmpty(value)) {
				var rawVal = this.processRawValue(this.getRawValue());
				var errs = this.getErrors(rawVal),
		          	errCount = Ext.isEmpty(errs);
		        if (!this.preventMark) {
		            if (errCount) {
		                this.clearInvalid();
		            }
		            else {
		                this.markInvalid(errs);
		            }
		        }
		        return errCount;
				//return true;
			}
		}
		else if(this.hasFocus && this.allowBlank == false) {
			var errs = this.getErrors(value);

			if((value || value != "")){
				var val = this.getRawValue();
				if(this.xtype == 'livesearchcombo' && this.lastSelection[0]) {
                    val = this.lastSelection[0].get('value');
                }
				var rec = this.findRecord(this.displayField, val);
				if(!rec && !isNaN(parseInt(val))) {
					rec = this.findRecord(this.displayField, parseInt(val));
				}
					if(this.xtype == "timefield"){
						if(this.minValue){
							var time = this.minValue.getTime();
							if(this.getValue()){
								var currentTime = this.getValue().getTime();
								if(currentTime<time){
									this.markInvalid('The time in this field  must be equal to or after '+timeRender(this.minValue.getTime()));
									return false;
								}else{
									this.clearInvalid();
									return true;
								}
							}else{
								if(this.getRawValue()){
									this.markInvalid('Not a valid time');
									return false;
								}
							}
						}else{
							this.clearInvalid();
						}
						return true;
					}
				if(!rec)
					errs.push("Invalid Selection"); 
			}

			var error = errs[0];

			if (error == undefined) {
				this.clearInvalid();
				return true;
			} else {
				this.markInvalid(error);
				return false;
			}
		}
		else if(this.allowBlank == true) {
			if(this.xtype == "timefield"){
				if(this.minValue){
					var time = this.minValue.getTime();
					if(this.getValue()){
						var currentTime = this.getValue().getTime();
						if(currentTime<time){
							this.markInvalid('The time in this field  must be equal to or after '+timeRender(this.minValue.getTime()));
							return false;
						}else{
							this.clearInvalid();
							return true;
						}
					}else{
						if(this.getRawValue()){
							this.markInvalid('Not a valid time');
							return false;
						}
					}
				}else{
					this.clearInvalid();
				}
				return true;
			}else{
				return true;
			}
		}
		else if(this.allowBlank == false && Ext.isEmpty(value)) {
			return false;
		}
		else if(this.allowBlank == false && !Ext.isEmpty(value)) {
			return true;
		}
	}
});
Ext.override(Ext.grid.Panel, {
	titleAlign:'center',
	emptyText:' ',
	reserveScrollbar:true
});
Ext.override(Ext.tree.Panel, {
	titleAlign:'center'
});