/*
 * @author prathamesh.sheth
 * 
 * This controller is used for Application Details and References tab.
 *    
 */
Ext.define('Academia.controller.admission.applications.applicationDetailsAndReferences.ApplicationDetailsAndReferencesController', {
    extend: 'Academia.controller.personinfo.common.PersonCommonController',
    alias: "widget.applicationdetailsandreferencescontroller",
    mixins: {
    	ApplicationBaseController:'Academia.controller.admission.applications.applicationBase.ApplicationBaseController',
    	ApplicantPersonalController:'Academia.controller.admission.applications.applicantinfo.ApplicantPersonalController',
    	AdmissionFormCommonController: 'Academia.controller.admission.admissionCommon.AdmissionFormCommonController'       			
    },
    models: ['admission.applications.applicationDetailsAndReferences.ReferenceModel'],

    stores: ['Academia.store.common.YesNoClientSideComboStore', 
             'Academia.store.admission.applicationFormSale.ProgramTabGridStore', 
             'Academia.store.admission.applicationFormSale.AddProgramGridStore', 
             'admission.applicationFormSale.ActiveProgramGroupComboStore',
             'admission.applicationFormSale.ProgramGroupByAcademyLocationStore',
             'Academia.store.admission.applicationFormSale.ProgramGroupComboStore', 
             'Academia.store.enquiry.studentDetail.ReservationCategoryStore', 
             'admission.applications.applicationDetailsAndReferences.ReferenceGridStore',
             'admission.applicationFormSale.ChangeProgramStore',
             'program.ProgramGroupStore','common.AcademyLocationNameSeparated',
             'admission.applicationFormSale.ChangeProgramCurrentStore',
             'Academia.store.common.ModeOfDeliveryStore',
             'Academia.store.common.RegistrationTypeStore',
             'campaignnew.RegistrationTypeStore',
             'admission.applications.applicationDetailsAndReferences.WaitingListStore',
             'admission.applications.applicationDetailsAndReferences.OfferLetterDueStore',
             'admission.applications.applicationDetailsAndReferences.EscalatedOfferReviewedStore',
             'admission.applicationFormSale.AdmissionConditionByOfferTypeStore'
             ],

	views: [
	        'admission.applications.applicationDetailsAndReferences.ReferenceGrid', 
	        'admission.applications.applicationDetailsAndReferences.ReferenceFormWindow', 
	        'admission.applications.applicationDetailsAndReferences.ApplicationDetails', 
	        'admission.applications.applicationDetailsAndReferences.AddApplicationProgramWindow', 
	        'Academia.view.admission.applicationFormSale.AddProgramTabGrid',
	        'admission.applications.applicantProfileBase.SelectionSnapshotGrid',
	        'admission.applications.applicantProfileBase.ApplicantProfile',
	        'admission.applicationFormSale.ChangeProgramGrid',
	        'admission.applicationFormSale.ChangeProgramWindow',
	        'admission.applicationFormSale.ChangeProgramWindowGrid',
	        'admission.applicationFormSale.ChangeProgramWindowCurrentGrid',
	        'admission.applications.applicationBase.ApplicationConditionsForAdmission',
	        'admission.applications.applicationDetailsAndReferences.ApplicationReferenceForm',
	        'admission.applications.applicationBase.ApplicationReviewDetails',
	        'admission.applications.applicationBase.ReviewDetailsPanel',
	        'admission.applicationFormSale.ApplicationProgramDetailWindow',
	        'admission.applicationFormSale.ApplicationProgramDetailGrid',
	        'admission.applicationFormSale.SendOfferLetterForm',
	        'admission.applications.applicationDetailsAndReferences.UpdateOfferStatusForm',
	        'Academia.view.criteriabuilder.grid.SearchResultGrid'
	        ],

    refs: [
    /**************Application Details Tab ********************/ 
    {
        ref: 'applicantAddProgramWindow',
        selector: 'addapplicationprogramwindow[itemId=addApplicantApplicationProgramWindow]'
    }, {
        ref: 'applicationDetailsForm',
        selector: 'applicationdetails[itemId=applicantApplicationDetails]'
    },


    /**************References Tab ********************/ {
        ref: 'applicantReferenceWindow',
        selector: 'referenceformwindow[itemId=applicantReferenceWindow]'
    },
    /****** Selection snapshot grid********/
    {
    	ref: 'selectionSnapShotGrid',
    	selector: 'applicantprofile selectionsnapshotgrid[itemId=selectionSnapShotGrid]'
    },{
    	ref:'changeProgramGrid',
    	selector:'changeprogramgrid[itemId=changeprogramGrid]'
    },{
    	ref:'changeProgramWindow',
    	selector:'changeprogramwindow[itemId=changeprogramWindow]'
    },{
    	ref:'changeprogramwindowcurrentgrid',
    	selector:'changeprogramwindowcurrentgrid'
    },{
    	ref:'referencegrid',
    	selector:'referencegrid'
    },{
        ref: 'applicationProgramDetailsWindow',
        selector: 'applicationprogramdetailwindow[itemId=applicationProgramDetailWindow]'
    },{
        ref: 'applicationProgramDetailGrid',
        selector: 'applicationprogramdetailgrid[itemId=applicationProgramDetailGrid]'
    },{
    	ref: 'sendOfferLetterForm',
        selector: 'sendofferletterform[itemId=sendOfferLetterForm]'
    },{
    	ref:'updateofferstatusform',
    	selector:'updateofferstatusform'
    },{
    	ref: 'applicationProgramDetailsWindow',
        selector: 'applicationprogramdetailwindow[itemId=applicationProgramDetailWindowItemId]'
    }, {
        ref: 'searchResultGrid',
        selector: 'searchresultgrid[itemId=applicationsListGrid]'
    }],
    config: {
    	APPLICANT_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_DETAILS_PRIVILEGES'),
    	APPLICANT_REFERENCES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_REFERENCES_PRIVILEGES'),
    	APPLICANT_CHANGE_APPLICATION_PROGRAM_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_CHANGE_APPLICATION_PROGRAM_PRIVILEGES'),
    	APPLICANT_CONDITIONS_FOR_ADMISSION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_CONDITIONS_FOR_ADMISSION_PRIVILEGES'),
    	APPLICANT_APPLICATION_REFERENCES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICANT_APPLICATION_REFERENCES_PRIVILEGES'),
    	APPLICANT_CHANGE_PROGRAM_INNER_GRID_PERMISSIONS_INNER_GRID: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_CHANGE_APPLICATION_PROGRAM_INNER_GRID_PRIVILEGES'),
    	APPLICATION_DETAILS_ADD_PROGRAM_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('APPLICATION_DETAILS_ADD_PROGRAM_PRIVILEGES')
    },
    init: function(application) {
        this.control({
        
            /**************Application Details Tab ********************/

            'applicationdetails[itemId=applicantApplicationDetails] grid[itemId=selectedApplicantApplicationProgramGrid]': {
                render: function(grid) {
                	this.doAccessControlValidation(grid, this.getAPPLICANT_DETAILS_PERMISSIONS());
                    this.disableMoreActionPivileges(grid,this.getAPPLICANT_DETAILS_PERMISSIONS());
                	var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                    	try{
                    		applicantProfile.getApplicationId();
                    	} catch(e){
                    		applicantProfile = me.getContentPanel().items.items[0];
                    	}
                    	if(!isNullOrEmpty(applicantProfile.getApplicationId())){
                    		if(applicantProfile.getApplicationInfo()['isViewMode'] || 
                    				((applicantProfile.getApplicationInfo()['applicationStatus']!=='APPLIED') &&
                    						(applicantProfile.getApplicationInfo()['applicationStatus']!=='SOLD') &&
                    						(applicantProfile.getApplicationInfo()['applicationStatus']!=='SUBMITTED') &&
                    						(applicantProfile.getApplicationInfo()['applicationStatus']!=='DIRECT_ADMISSION') &&
                    						(applicantProfile.getApplicationInfo()['applicationStatus']!=='MID_TERM_ADMISSION')) 
                    		){
                    			me.mixins.ApplicationBaseController.setContainerInViewMode(grid);
                    		}
                    		grid.getStore().load({
                    			params: {
                    				applicationID: applicantProfile.getApplicationId()
                    			}
                    		});

                    		grid.getStore().on('beforeload', function(store, operation) {
                    			var applicationId = applicantProfile.getApplicationId();
                    			store.proxy.extraParams = {
                    					applicationID:applicationId 
                    			};
                    		});
                    	}
                    } 
                },
                afterrender : function(grid){
    				var me = this;
    				me.addDataGridConfigButton(grid,me.getAPPLICANT_DETAILS_PERMISSIONS());
    			},
    			selectionchange: function(column, selected,eOpts){
    				var me = this;
    				var applicationProfile = me.getContentPanelActiveTab();
    				var grid = applicationProfile.down('#selectedApplicantApplicationProgramGrid');
    				var sendOfferLetterButton = grid.down('#sendOfferLetter');
    				var resendOfferLetterButton = grid.down('#resendOfferLetter');
    				var upateOfferStatusButton = grid.down('#updateOfferStatus');
    				if(selected.length>0) {
    					if(!isNullOrEmpty(selected[0].data.currentStatus) && (selected[0].data.currentStatus=="OFFER_LETTER_DUE" || selected[0].data.currentStatus=="ESCALATED_OFFER_REVIEWED")){
    						sendOfferLetterButton.setDisabled(false);
    					}
    					else {
    						sendOfferLetterButton.setDisabled(true);
    					}
    					if(!isNullOrEmpty(selected[0].data.currentStatus) && (selected[0].data.currentStatus=="OFFER_LETTER_ISSUED" || selected[0].data.currentStatus=="OFFER_EXPIRED")){
    						resendOfferLetterButton.setDisabled(false);
    					}
    					else {
    						resendOfferLetterButton.setDisabled(true);
    					}
    					if(!isNullOrEmpty(selected[0].data.currentStatus) && (selected[0].data.currentStatus=="OFFER_LETTER_DUE" || selected[0].data.currentStatus=="WAITING_LIST" ||
    						selected[0].data.currentStatus=="ESCALATED_OFFER_REVIEWED")){
    						upateOfferStatusButton.setDisabled(false);
    					}
    					else {
    						upateOfferStatusButton.setDisabled(true);
    					}
    				}
    				else{
    					sendOfferLetterButton.setDisabled(true);
    					upateOfferStatusButton.setDisabled(true);
    					resendOfferLetterButton.setDisabled(true);
    				}
                }
            },
            
            'applicationdetails[itemId=applicantApplicationDetails]': {
                render: function(form) {
                	var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                    	try{
                    		applicantProfile.getApplicationId();
                    	} catch(e){
                    		applicantProfile = me.getContentPanel().items.items[0];
                    	}
                    	if(!isNullOrEmpty(applicantProfile.getApplicationId())){
                    		if(applicantProfile.getApplicationInfo()['isViewMode']||
                    			((applicantProfile.getApplicationInfo()['applicationStatus']!=='APPLIED') &&
                                (applicantProfile.getApplicationInfo()['applicationStatus']!=='SOLD') &&
                                (applicantProfile.getApplicationInfo()['applicationStatus']!=='SUBMITTED')  &&
                    	(applicantProfile.getApplicationInfo()['applicationStatus']!=='DIRECT_ADMISSION') &&
                    	(applicantProfile.getApplicationInfo()['applicationStatus']!=='MID_TERM_ADMISSION')) 	
                    		){
                        		me.mixins.ApplicationBaseController.setContainerInViewMode(form,"applicationdetails[itemId=applicantApplicationDetails]>fieldcontainer>button",applicantProfile);
                        	}                    		
                    	}
                    }                	
                }
            },
            'applicationdetails[itemId=applicantApplicationDetails] grid[itemId=selectedApplicantApplicationProgramGrid] button[itemId=btnAdd]': {
                click: function() {
                	var this$=this;
                    var window = this.getApplicantAddProgramWindow();
                    if (!window) {
                        window = Ext.widget('addapplicationprogramwindow', {
                            itemId: 'addApplicantApplicationProgramWindow'
                        });
                    }
                    window.show();
                    this$.applyWindowMask();
                    if(this.getCurrentLoggedPortalId() == 6) {
                    	var academyLocationCombo = window.down('#cmbAcademyLocations');
                    	var loggedInAcademyLocationId = this.getCurrentAcademyLocation();
                    	academyLocationCombo.setValue(loggedInAcademyLocationId);
                    }
                }
            },
            'applicationdetails[itemId=applicantApplicationDetails] grid[itemId=selectedApplicantApplicationProgramGrid] button[itemId=btnDelete]': {
                click: function() {
                    var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                        var grid = applicantProfile.down('#selectedApplicantApplicationProgramGrid');
                        var url = SERVERURL.APPLICATION_FORM_SALE_PROGRAM_DELETE; //URL-:rest/applicationProgram/delete
                        var snapShotGrid = applicantProfile.down('#selectionSnapShotGrid');
                        if(isNullOrEmpty(snapShotGrid)){
                        	var profile = me.getContentPanel().items.items[0];
                        	snapShotGrid=profile.down('#selectionSnapShotGrid');
                        }
                        if (grid) {
                            me.mixins.AdmissionFormCommonController.checkGridRecordSelection(me, grid, 'id', getAdmissionTranslation('DELETE_PROGRAM'), url, getAdmissionTranslation('DELETE_PROGRAM_MSG'),snapShotGrid);
                        }
                    }
                }
            },
            'applicationdetails[itemId=applicantApplicationDetails] grid[itemId=selectedApplicantApplicationProgramGrid] button[itemId=savePriority]': {
                click: function() {
                    var applicantProfile = this.getContentPanelActiveTab();
                    if (applicantProfile) {
                        var grid = applicantProfile.down('#selectedApplicantApplicationProgramGrid');
                        this.mixins.AdmissionFormCommonController.savePriority(this, grid);
                    }
                }
            },
            'applicationdetails[itemId=applicantApplicationDetails] grid[itemId=selectedApplicantApplicationProgramGrid] button[itemId=sendOfferLetter]': {
                click: function() {
                    var window = this.getApplicationProgramDetailsWindow();
                    if (!window) {
                        window = Ext.widget('applicationprogramdetailwindow', {
                            itemId: 'applicationProgramDetailWindow'
                        });
                    }
                    window.show();
                }
            },
            'applicationdetails[itemId=applicantApplicationDetails] grid[itemId=selectedApplicantApplicationProgramGrid] button[itemId=resendOfferLetter]': {
                click: function() {
                    var window = this.getApplicationProgramDetailsWindow();
                    if (!window) {
                        window = Ext.widget('applicationprogramdetailwindow', {
                            itemId: 'applicationProgramDetailWindowItemId'
                        });
                    }
                    window.show();
                }
            },
            'applicationdetails[itemId=applicantApplicationDetails] grid[itemId=selectedApplicantApplicationProgramGrid] button[itemId=updateOfferStatus]': {
                click: function() {
                    var window = this.getUpdateofferstatusform();
                    if (!window) {
                    	window = Ext.widget('updateofferstatusform');
                    }
                    window.show();
                }
            },
            'updateofferstatusform customcombobox#offerStatus': {
	        	afterrender: function(obj) {
	        		var me = this;
	        		var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                    	var selectedApplicationProgramGrid = applicantProfile.down('#selectedApplicantApplicationProgramGrid');
                        record = selectedApplicationProgramGrid.getSelectionModel().getSelection()[0];
                        var status = record.get('currentStatus');
                        var preserveStatus = record.get('preserveStatus');
                        var store;
                        if(status == "WAITING_LIST" && (isNullOrEmpty(preserveStatus) || preserveStatus == "OFFER_LETTER_DUE")) {
                        	store = Ext.create('Academia.store.admission.applications.applicationDetailsAndReferences.OfferLetterDueStore');
                        	obj.bindStore(store);
            		        store.load();
            		        store.commitChanges();
                        } else if(status == "WAITING_LIST" && !isNullOrEmpty(preserveStatus) && preserveStatus == "ESCALATED_OFFER_REVIEWED") {
                        	store = Ext.create('Academia.store.admission.applications.applicationDetailsAndReferences.EscalatedOfferReviewedStore');
                        	obj.bindStore(store);
            		        store.load();
            		        store.commitChanges();
                        } else if(status == "OFFER_LETTER_DUE" || status == "ESCALATED_OFFER_REVIEWED") {
                        	store = Ext.create('Academia.store.admission.applications.applicationDetailsAndReferences.WaitingListStore');
                        	obj.bindStore(store);
            		        store.load();
            		        store.commitChanges();
                        }
                    }
	        	}
	        },
            'updateofferstatusform button#offerSubmitbuttonId': {
	        	click: function(obj) {
	        		this.updateOfferStatusSave(obj);
	        	}
	        },
	        'updateofferstatusform button#offerCancelbuttonId': {
	        	click: function(obj) {
	        		 obj.up('window').close();
	        	}
	        },
            'applicationdetails[itemId=applicantApplicationDetails] button[itemId=saveApplicationDetails]': {
                click: function() {
                    var me = this;
                    var applicantProfile = this.getContentPanelActiveTab();
                    if (applicantProfile) {
                        var selectedApplicationProgramGrid = applicantProfile.down('#selectedApplicantApplicationProgramGrid');
                        var applicantApplicationDetailsForm = applicantProfile.down('#applicantApplicationDetails');
                        me.updateApplicationForm(applicantApplicationDetailsForm, selectedApplicationProgramGrid);
                    }
                }
            },
            'applicationdetails[itemId=applicantApplicationDetails] button[itemId=cancelApplicationDetails]': {
                click: function() {
                    var applicantProfile = this.getContentPanelActiveTab();
                    if (applicantProfile) {
                        applicantProfile.down('#applicantApplicationDetails').getForm().reset();
                    }
                }
            },
        /*    'addapplicationprogramwindow[itemId=addApplicantApplicationProgramWindow] grid[itemId=applicantProfileAddApplicationProgramGrid]': {
                render: function(addProgramWindowGrid) {
                    var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                        var selectedApplicationProgramGrid = applicantProfile.down('#selectedApplicantApplicationProgramGrid');
                        var programGroup = addProgramWindowGrid.down('#cmbPgmGroup');
                        if (selectedApplicationProgramGrid && programGroup) {
                            me.mixins.AdmissionFormCommonController.loadProgramGroupWithGridData(me, programGroup, addProgramWindowGrid, selectedApplicationProgramGrid);
                        }
                    }
                }
            },*/
            'addapplicationprogramwindow[itemId=addApplicantApplicationProgramWindow] grid[itemId=applicantProfileAddApplicationProgramGrid]': {
            	 afterrender: function(grid) {
            		 var me = this;
            		 me.addDataGridConfigButton(grid,me.getAPPLICATION_DETAILS_ADD_PROGRAM_PERMISSIONS());
            	 }
            },
            'addapplicationprogramwindow[itemId=addApplicantApplicationProgramWindow] button[itemId=resetBtn]':{
            	click:function(){
            		var programWindow = this.getApplicantAddProgramWindow();
                    var addProgramWindowGrid = programWindow.down('#applicantProfileAddApplicationProgramGrid');
            		
            		var a = addProgramWindowGrid.down("#cmbAcademyLocations");
            		if( a != undefined ){
            			a.reset();
            			var storeAcademyLocation = a.getStore();
            			if(storeAcademyLocation != undefined){
            				//b.select(storeProgramGroup.getAt(0));
            				storeAcademyLocation.removeAll();
            				storeAcademyLocation.load();
            			}
            		}
            		if(this.getCurrentLoggedPortalId() == 6) {
	            		var loggedInAcademyLocationId = this.getCurrentAcademyLocation();
	                	a.setValue(loggedInAcademyLocationId);
            		}
            		var b = addProgramWindowGrid.down("#cmbPgmGroup");
            		var c = addProgramWindowGrid.down("#cmbPrograms");
            		if( b != undefined ){
            			b.reset();
            			var storeProgramGroup = b.getStore();
            			if(storeProgramGroup != undefined){
            				//b.select(storeProgramGroup.getAt(0));
            				storeProgramGroup.removeAll();
            				if(this.getCurrentLoggedPortalId() == 6) {
                                var academyLocationId = a.getValue();
                                storeProgramGroup.getProxy().extraParams={
                    				academyLocationId:academyLocationId,
                				};
                            }
            				else {
            				storeProgramGroup.getProxy().extraParams = {};
            				}
            				var params = storeProgramGroup.getProxy().extraParams;
            				console.log(params);
            				storeProgramGroup.load({
                                scope:this,
                                callback: function(records,option,success){
                                	storeProgramGroup.commitChanges();
                                	c.reset();
                                    b.bindStore(storeProgramGroup);
                                    if(storeProgramGroup.getAt(0)){
                                    	b.select(storeProgramGroup.getAt(0));
                                    	this.addProgramWindowQuickSearch();
                                    }
                                }
            				});
            			}
            		}
            		
            		if( c != undefined ){
            			c.reset();
            			/*var storeProgram = c.getStore();
            			if(storeProgram != undefined){
            				//b.select(storeProgramGroup.getAt(0));
            				storeProgram.removeAll();
            			}*/
            		}
            		var d = addProgramWindowGrid.down("#modeDeliveryId");
            		var e = addProgramWindowGrid.down("#registrationTypeId");
					if (d != undefined) {
						d.reset();
					}
					if (e != undefined) {
						e.reset();
					}
            		
                    var programGroupIds = [];
      	            var selectedProgramId = 0;	
      	            var selectedAcademyLocationId = 0;
      	            var selectedProgramGroup = 0;
      	            //https://serosoft.atlassian.net/browse/V2D-115644
                    var isformSaleSelection=false, isformSubmissionSelection=false,whetherAdmissionOpen =true;
              		//this.loadAddProgramGrid(addProgramWindowGrid, selectedProgramGroup,isformSaleSelection,isformSubmissionSelection,whetherAdmissionOpen, programGroupIds, selectedAcademyLocationId, selectedProgramId);
            	}
            },
            'addapplicationprogramwindow[itemId=addApplicantApplicationProgramWindow] button[itemId=quickSearchId]':{
            	click:function(){
            		this.addProgramWindowQuickSearch();
            	}
            },
            'addapplicationprogramwindow[itemId=addApplicantApplicationProgramWindow] combo[itemId=cmbAcademyLocations]': {
            	afterrender:function(combo){
            		var store = combo.getStore();
            	 	  store.getProxy().api.read = this.getUrlOfStore(store) +'?activeFormSale=true&activeFormSubmission=false';
                      store.load({
                          scope:this,
                             callback: function(records,option,success){
                                 store.commitChanges();
                                 combo.bindStore(store);
                                  if(store.getAt(0)){
                                	  //combo.select(store.getAt(0));
                                  }
                          }
                       });
                    var programWindow = this.getApplicantAddProgramWindow();
                    var addProgramWindowGrid = programWindow.down('#applicantProfileAddApplicationProgramGrid');
                    var programGroupIds = [];
      	            var selectedProgramId = 0;	
      	            var selectedAcademyLocationId = 0;
      	            var selectedProgramGroup = 0;
                    var isformSaleSelection=true, isformSubmissionSelection=false,whetherAdmissionOpen =true;
              		//this.loadAddProgramGrid(addProgramWindowGrid, selectedProgramGroup,isformSaleSelection,isformSubmissionSelection,whetherAdmissionOpen, programGroupIds, selectedAcademyLocationId, selectedProgramId);
              	},
                //change: function(combo, selectedAcademyLocation) {
              	select: function( combo, selectedAcademyLocation, eOpts ) {
                	var programWindow = this.getApplicantAddProgramWindow();
                    var addProgramWindowGrid = programWindow.down('#applicantProfileAddApplicationProgramGrid');
                    var a = combo;
            		var b = addProgramWindowGrid.down("#cmbPgmGroup");
            		var c = addProgramWindowGrid.down("#cmbPrograms");
            		var d = addProgramWindowGrid.down("#modeDeliveryId");
            		var e = addProgramWindowGrid.down("#registrationTypeId");
            		var storeProgram = c.getStore();
            		var storeProgramGroup = b.getStore();
            		storeProgram.getProxy().extraParams={
            			academyLocationId:selectedAcademyLocation[0].data.id,
            			isformSaleSelection:false,
						isformSubmissionSelection:false,
        				whetherAdmissionOpen:true
    				};
            		
            		if(selectedAcademyLocation[0].data.id != null){
            			storeProgramGroup.getProxy().extraParams={
            				academyLocationId:selectedAcademyLocation[0].data.id,
        				};
            			storeProgramGroup.load({
                            scope:this,
                            callback: function(records,option,success){
                            	storeProgramGroup.commitChanges();
                                b.bindStore(storeProgramGroup);
                                if(storeProgramGroup.getAt(0)){
                                	if(records != null && records != undefined && records != "" && records.length > 0){
                                    	if(storeProgramGroup.getAt(0)){
                                        	b.select(storeProgramGroup.getAt(0));
                                        }
                                    }
                                }
                            }
            			});
            		}
            		
            		if(b != undefined && b.getValue() != null ){
            			storeProgram.getProxy().extraParams.programGroupId = b.getValue();
    	            }
            		if (d != undefined && d.getValue() != null) {
						storeProgram.getProxy().extraParams.modeDeliveryId = d.getValue();
					}
            		var regTypeEnum = null;
					if (e != undefined && e.getValue() != null) {
						if(e.getValue()=="FULL_TIME"){
							regTypeEnum = false;
						}else if(e.getValue()=="PART_TIME"){
							regTypeEnum = true;
						}
					}
					if (regTypeEnum!=null) {	
						storeProgram.getProxy().extraParams.registrationTypeEnum = regTypeEnum;
					}
					storeProgram.load();
            		
                }
            },
            'addapplicationprogramwindow[itemId=addApplicantApplicationProgramWindow] combo[itemId=cmbPrograms]': {
            	afterrender:function(combo){
            		var store = combo.getStore();
            		store.getProxy().extraParams={
            			isformSaleSelection:false,
						isformSubmissionSelection:false,
        				whetherAdmissionOpen:true
    				};
            	 	  store.getProxy().api.read = this.getUrlOfStore(store) +'?activeFormSale=true&activeFormSubmission=false';
                      store.load({
                          scope:this,
                             callback: function(records,option,success){
                                 store.commitChanges();
                                 combo.bindStore(store);
                                  if(store.getAt(0)){
                                	  //combo.select(store.getAt(0));
                                  }
                          }
                       });
              	}
            },
            'addapplicationprogramwindow[itemId=addApplicantApplicationProgramWindow] combo[itemId=cmbPgmGroup]': {
            	afterrender:function(combo){
            		var store = combo.getStore();
            	 	  store.getProxy().api.read = this.getUrlOfStore(store) +'?activeFormSale=true&activeFormSubmission=false';
                     store.load({
                          scope:this,
                             callback: function(records,option,success){
                                 store.commitChanges();
                                 combo.bindStore(store);
                                  if(store.getAt(0)){
                                	  combo.select(store.getAt(0));
                                	  this.addProgramWindowQuickSearch();
                                  }
                          }
                       });
                      if(this.getCurrentLoggedPortalId() == 6) {
                    	  var loggedInAcademyLocationId = this.getCurrentAcademyLocation();
                    	  store.getProxy().extraParams={
              				academyLocationId:loggedInAcademyLocationId,
          				};
              			store.load({
                              scope:this,
                              callback: function(records,option,success){
                            	  store.commitChanges();
                            	  combo.bindStore(store);
                                  if(store.getAt(0)){
                                  	if(records != null && records != undefined && records != "" && records.length > 0){
                                      	if(store.getAt(0)){
                                      		combo.select(store.getAt(0));
                                      		this.addProgramWindowQuickSearch();
                                          }
                                      }
                                  }
                              }
              			});
                      }
                      
                      this.setAllowBlank(combo,false);
                      //this.addProgramWindowQuickSearch();
              	},
                change: function(combo, selectedProgramGroup) {
                //select: function( combo, selectedProgramGroup, eOpts ) {
                	var programWindow = this.getApplicantAddProgramWindow();
                    var addProgramWindowGrid = programWindow.down('#applicantProfileAddApplicationProgramGrid');
                    var a = addProgramWindowGrid.down("#cmbAcademyLocations");
            		var c = addProgramWindowGrid.down("#cmbPrograms");
            		var d = addProgramWindowGrid.down("#modeDeliveryId");
            		var e = addProgramWindowGrid.down("#registrationTypeId");
            		var storeProgram = c.getStore();
            		if(this.getCurrentLoggedPortalId() == '6'){
            			storeProgram.getProxy().extraParams={
            				programGroupId:selectedProgramGroup,
            				isformSaleSelection:true,
            				whetherAdmissionOpen :false,
            				isformSubmissionSelection:false
            			};
            		}
            		else
            		{
            			storeProgram.getProxy().extraParams={
            				programGroupId:selectedProgramGroup,
            				isformSaleSelection:false,
            				isformSubmissionSelection:false,
            				whetherAdmissionOpen:true
            				//programGroupId:selectedProgramGroup[0].data.id,
            			};
            		}
            		if(a != undefined && a.getValue() != null ){
            			storeProgram.getProxy().extraParams.academyLocationId = a.getValue();
    	            }
            		if (d != undefined && d.getValue() != null) {
						storeProgram.getProxy().extraParams.modeDeliveryId = d.getValue();
					}
            		var regTypeEnum = null;
					if (e != undefined && e.getValue() != null) {
						if(e.getValue()=='FULL_TIME'){
							regTypeEnum = false;
						}else if(e.getValue()=='PART_TIME'){
							regTypeEnum = true;
						}
					}
					if (regTypeEnum!=null) {	
						storeProgram.getProxy().extraParams.registrationTypeEnum = regTypeEnum;
					}
            		storeProgram.load();
                }
            },
            'addapplicationprogramwindow[itemId=addApplicantApplicationProgramWindow] combo[itemId=modeDeliveryId]' : {
				afterrender : function(combo) {
				  var store = combo.getStore();
          	 	  store.getProxy().api.read = this.getUrlOfStore(store);
                    store.load({
                        scope:this,
                           callback: function(records,option,success){
                               store.commitChanges();
                               combo.bindStore(store);
                                if(store.getAt(0)){
                              	 // this.addProgramWindowQuickSearch();
                                }
                        }
                     });
					this.setAllowBlank(combo, true);
				},
				change : function(combo, selectedModeOfDelivery) {
					var programWindow = this.getApplicantAddProgramWindow();
					var addProgramWindowGrid = programWindow.down('#applicantProfileAddApplicationProgramGrid');
					var a = addProgramWindowGrid.down("#cmbAcademyLocations");
					var b = addProgramWindowGrid.down("#cmbPgmGroup");
					var c = addProgramWindowGrid.down("#cmbPrograms");
					var d = addProgramWindowGrid.down("#modeDeliveryId");
					var e = addProgramWindowGrid.down("#registrationTypeId");

					var storeProgram = c.getStore();
					storeProgram.getProxy().extraParams = {
						modeDeliveryId : selectedModeOfDelivery,
						isformSaleSelection:false,
						isformSubmissionSelection:false,
        				whetherAdmissionOpen:true
					};

					if (a != undefined && a.getValue() != null) {
						storeProgram.getProxy().extraParams.academyLocationId = a.getValue();
					}

					if (b != undefined && b.getValue() != null) {
						storeProgram.getProxy().extraParams.programGroupId = b.getValue();
					}

					var regTypeEnum = null;
					if (e != undefined && e.getValue() != null) {
						if(e.getValue()=='FULL_TIME'){
							regTypeEnum = false;
						}else if(e.getValue()=='PART_TIME'){
							regTypeEnum = true;
						}
					}
					if (regTypeEnum!=null) {	
						storeProgram.getProxy().extraParams.registrationTypeEnum = regTypeEnum;
					}
					storeProgram.load();
				}
			},
			'addapplicationprogramwindow[itemId=addApplicantApplicationProgramWindow] combo[itemId=registrationTypeId]' : {
				afterrender : function(combo) {
					var store = combo.getStore();
	          	 	  store.getProxy().api.read = this.getUrlOfStore(store);
	                    store.load({
	                        scope:this,
	                           callback: function(records,option,success){
	                               store.commitChanges();
	                               combo.bindStore(store);
	                                if(store.getAt(0)){
	                              	//  this.addProgramWindowQuickSearch();
	                                }
	                        }
	                     });

					this.setAllowBlank(combo, true);
				},
				change : function(combo, selectedRegistrationType) {
					var programWindow = this.getApplicantAddProgramWindow();
					var addProgramWindowGrid = programWindow.down('#applicantProfileAddApplicationProgramGrid');
					var a = addProgramWindowGrid.down("#cmbAcademyLocations");
					var b = addProgramWindowGrid.down("#cmbPgmGroup");
					var c = addProgramWindowGrid.down("#cmbPrograms");
					var e = addProgramWindowGrid.down("#modeDeliveryId");
					var regTypeEnum=null;
					
					if(selectedRegistrationType!=null){
						if(selectedRegistrationType=='FULL_TIME'){
							regTypeEnum=false;
						}else if(selectedRegistrationType=='PART_TIME'){
							regTypeEnum=true;
						}
					}
					
					
					var storeProgram = c.getStore();
					if(regTypeEnum!=null){
						storeProgram.getProxy().extraParams = {
							registrationTypeEnum : regTypeEnum,
							isformSaleSelection:false,
							isformSubmissionSelection:false,
	        				whetherAdmissionOpen:true
						};
					}

					if (a != undefined && a.getValue() != null) {
						storeProgram.getProxy().extraParams.academyLocationId = a.getValue();
					}

					if (b != undefined && b.getValue() != null) {
						storeProgram.getProxy().extraParams.programGroupId = b.getValue();
					}

					if (e != undefined && e.getValue() != null) {
						storeProgram.getProxy().extraParams.modeDeliveryId = e.getValue();
					}
					storeProgram.load();
				}
			},
            'addapplicationprogramwindow[itemId=addApplicantApplicationProgramWindow] button[itemId=addProgramBtn]': {
                click: function() {
                    var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                        var selectedApplicationProgramGrid = applicantProfile.down('#selectedApplicantApplicationProgramGrid');
                        var programWindow = me.getApplicantAddProgramWindow();
                        var addProgramWindowGrid = programWindow.down('#applicantProfileAddApplicationProgramGrid');                        
                    	                    
                        var applicantionId ;
                        try {
                        	applicantionId=applicantProfile.getApplicationId();
                        } catch(e){
                        	applicantionId = me.getContentPanel().items.items[0].applicationId;
           			 	}
                        
                        var b = addProgramWindowGrid.down("#cmbPgmGroup");
                        if(b != undefined){
                        	if( !(b.getValue() == null || b.getValue() == undefined || b.getValue()=="") ){
                        		if(this.validateMaxProgramsAllowed(selectedApplicationProgramGrid,programWindow,addProgramWindowGrid)){
                                	me.mixins.AdmissionFormCommonController.addProgramToApplication(me, selectedApplicationProgramGrid, programWindow, addProgramWindowGrid, applicantionId,applicantProfile);
                                }
                        	}else{
                        		showWarningMessage(getAdmissionTranslation('SUBMIT_FORM'), getAdmissionTranslation('SELECT_PROGRAM_GROUP_MSG'));
                        	}
                        }
                    }
                }
            },
            'addapplicationprogramwindow[itemId=addApplicantApplicationProgramWindow] button[itemId=cancelProgramBtn]': {
                click: function() {
                    var window = this.getApplicantAddProgramWindow();
                    if (window) {
                        window.close();
                    }
                }
            },

            /**************References Tab ********************/
            'referencegrid[itemId=referenceGrid]': {
                render: function(grid) {
                	if(this.getCurrentLoggedPortalId() == 1){
                		this.doAccessControlValidation(grid, this.getAPPLICANT_REFERENCES_PERMISSIONS());
                		this.showResendLinkPivileges(grid,this.getAPPLICANT_REFERENCES_PERMISSIONS());
                	}
                	if(this.getCurrentLoggedPortalId() == 6){
                		this.showResendLinkPivileges(grid,this.getAPPLICANT_APPLICATION_REFERENCES_PERMISSIONS());
                	}
                	var resendLinkButton=grid.down('#btnResendLink');
                	resendLinkButton.setDisabled(true);
                	var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                    	try{
                    		applicantProfile.getApplicationId();
                    	} catch(e){
                    		applicantProfile = me.getContentPanel().items.items[0];
                    	}
                    	if(!isNullOrEmpty(applicantProfile.getApplicationId())){
                    		if(applicantProfile.getApplicationInfo()['isViewMode']||
                    			((applicantProfile.getApplicationInfo()['applicationStatus']!=='APPLIED') &&
                                (applicantProfile.getApplicationInfo()['applicationStatus']!=='SOLD') &&
                                (applicantProfile.getApplicationInfo()['applicationStatus']!=='SUBMITTED')  &&
                                (applicantProfile.getApplicationInfo()['applicationStatus']!=='DIRECT_ADMISSION') &&
                                (applicantProfile.getApplicationInfo()['applicationStatus']!=='MID_TERM_ADMISSION')) 
                    		){
                        		me.mixins.ApplicationBaseController.setContainerInViewMode(grid);
                        	}
                    		grid.getStore().load({
                                params: {
                                    applicationId: applicantProfile.getApplicationId()
                                }
                            });
                    		
                    		grid.getStore().on('beforeload', function(store, operation) {
                                var applicationId = applicantProfile.getApplicationId();
                                store.proxy.extraParams = {
                                	applicationId:applicationId 
                                };
                            });
                    	}
                    }                    
                },
                selectionchange: function(column, selected,eOpts ){
                	this.disableResendLinkButton(column,selected);                	
                } 
            },
            'referencegrid[itemId=referenceGrid] button[itemId=btnAdd]': {
                click: function() {
                    this.addReferences(true);
                }
            },
            'referencegrid[itemId=referenceGrid] button[itemId=btnEdit]': {
                click: function() {
                    var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                        var referenceGrid = applicantProfile.down('#referenceGrid');
                        me.editReferences(referenceGrid, false);
                    }
                }
            },
            'referencegrid[itemId=referenceGrid] button[itemId=btnView]': {
                click: function() {
                    var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                        var referenceGrid = applicantProfile.down('#referenceGrid');
                        me.editReferences(referenceGrid, true);
                    }
                }
            },
            'referencegrid[itemId=referenceGrid] button[itemId=btnDelete]': {
                click: function() {
                    var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                        var referenceGrid = applicantProfile.down('#referenceGrid');
                        me.deleteReferences(referenceGrid);
                    }
                }
            },
            'referencegrid[itemId=referenceGrid] button[itemId=btnResendLink]': {
                click: function() {
                	var me = this;
                	var applicantProfile = me.getContentPanelActiveTab();
                	if (applicantProfile) {
                		var referenceGrid = applicantProfile.down('#referenceGrid');
                    record = referenceGrid.getSelectionModel().getSelection()[0];
                    applicationReferenceId = record.data.id;
                    Ext.Ajax.request({
                        method: "GET",
                        type: 'rest',
                        url: SERVERURL.PATH_RESEND_LINK_APPLICATION_REFERENCE,
                        params:{
                        	applicationReferenceId:applicationReferenceId
                        },
                    });
            		showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('SEND_SUCCESS_MESSAGE'));
                		referenceGrid.getSelectionModel().deselectAll();
                	}
            	}
            },
            'referenceformwindow[itemId=applicantReferenceWindow] button[itemId=btnSaveReferencesForm]': {
                click: function() {
                    var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                        var referenceGrid = applicantProfile.down('#referenceGrid');
                        var window = me.getApplicantReferenceWindow();
                        me.saveReferences(referenceGrid, window);
                    }
                }
            },
            'referenceformwindow[itemId=applicantReferenceWindow] button[itemId=btnCancelReferencesMasterForm]': {
                click: function() {
                    this.getApplicantReferenceWindow().close();
                }
            },
            /***************************** change Application program grid******************************/
            'changeprogramgrid[itemId=changeprogramGrid]': {
            	render: function(grid) {
            		this.getRenderChangeProgram(grid);
            	},
            	afterrender:function(grid){
            		this.addDataGridConfigButton(grid,this.getAPPLICANT_CHANGE_APPLICATION_PROGRAM_PERMISSIONS());
            	},
            },
            'changeprogramgrid[itemId=changeprogramGrid] button[itemId=btnEdit]' :{
            	click : this.getEditChangeProgram
            },
            'changeprogramwindow[itemId=changeprogramWindow] combo[itemId=cmbPgmGroup]': {
            	afterrender:function(combo){
            		var store = combo.getStore();
            		store.getProxy().api.read = this.getUrlOfStore(store) +'?activeFormSale=true&activeFormSubmission=false';
            		store.load({
            			scope:this,
            			callback: function(records,option,success){
            				store.commitChanges();
            				combo.bindStore(store);

            				if(store.getAt(0))
            					combo.select(store.getAt(0));
            			}
            		});
            	},
            	 change: function(combo, selectedProgramGroup) {
                     var me = this;
                     var addProgramWindowGrid = me.getChangeProgramWindow().down('#changeprogramwindowgrid');
                     if (addProgramWindowGrid && selectedProgramGroup) {
                         me.mixins.AdmissionFormCommonController.loadAddProgramGrid(addProgramWindowGrid, selectedProgramGroup,false,true,true,0,0);
                     }
                 }
            },
            'changeprogramwindow[itemId=changeprogramWindow] button[itemId=btnCancle]': {
            	click: this.getCloseChangeProgramWin
            },
            'changeprogramwindow[itemId=changeprogramWindow] button[itemId=btnChangeProgram]': {
            	click: this.getAddChangeProgram
            },
            'changeprogramwindow[itemId=changeprogramWindow] form[itemId=applicantChangeProgramFilter] customcombobox[itemId=academyLocation]': {
            	select: function( academyLocCombo, selectedAcademyLocation ) {
            		
            		var form = academyLocCombo.up('form');
            		var programGroupCombo = form.down('#programGroup');
            		var storeProgramGroup = programGroupCombo.getStore();
            		
            		var programCombo = form.down('#program');
            		var storeProgram = programCombo.getStore();
            		storeProgram.removeAll();
            		programCombo.reset();
            		programCombo.setDisabled(true);
            		
            		var batchCombo = form.down('#batch');
            		var storeBatch = batchCombo.getStore();
            		storeBatch.removeAll();
            		batchCombo.reset();
            		batchCombo.setDisabled(true);
            		
            		var seatTypeCombo = form.down('#seatType');
            		var storeSeatType = seatTypeCombo.getStore();
            		storeSeatType.removeAll();
            		seatTypeCombo.reset();
            		seatTypeCombo.setDisabled(true);
            		form.down('#modeDeliveryId').setDisabled(false);
            		form.down('#registrationTypeId').setDisabled(false);
            		
            		storeProgramGroup.proxy.extraParams = {
                    	academyLocationIds:academyLocCombo.getValue(),
                    	//activeFormSale:true,
                    	//activeFormSubmission:false
                    };
            		storeProgramGroup.removeAll();
            		programGroupCombo.reset();
            		storeProgramGroup.load({
                        scope:this,
                        callback: function(records,option,success){
                        	if(records != null && records != undefined && records != "" && records.length > 0){
                        		//if(storeProgramGroup.getAt(0)){
                        		if( records.length == 1 ){
                        			programGroupCombo.select(storeProgramGroup.getAt(0));
                        			var model = [records[0]];
                        			programGroupCombo.fireEvent('select', programGroupCombo, model);
                        			programCombo.setDisabled(false);
                        		}
                        		programGroupCombo.setDisabled(false);
                        	} else {
                        		storeProgramGroup.removeAll();
                        		programGroupCombo.reset();
                        		programGroupCombo.setDisabled(false);
                        	}
                        	
                        }
        			});
            	}
            },
            'changeprogramwindow[itemId=changeprogramWindow] form[itemId=applicantChangeProgramFilter] customcombobox[itemId=programGroup]': {
            	select: function( programGroupCombo, selectedProgramGroup ) {
            		this.selectConfiguredProgramGroup(programGroupCombo, selectedProgramGroup);
            	}
            },
            'changeprogramwindow[itemId=changeprogramWindow] form[itemId=applicantChangeProgramFilter]': {
            	afterrender:function(grid){
            		var formGrid = this.getChangeprogramwindowcurrentgrid();
            		this.addDataGridConfigButton(formGrid,this.getAPPLICANT_CHANGE_PROGRAM_INNER_GRID_PERMISSIONS_INNER_GRID());
            	}
            },
            'changeprogramwindow[itemId=changeprogramWindow] form[itemId=applicantChangeProgramFilter] customcombobox[itemId=modeDeliveryId]': {
            	select: function( modeOfDeliveryCombo, selectid ) {
            		this.selectModeOfDelivery(modeOfDeliveryCombo, selectid);
            	}
            },
            'changeprogramwindow[itemId=changeprogramWindow] form[itemId=applicantChangeProgramFilter] customcombobox[itemId=registrationTypeId]': {
            	select: function( registrationTypeCombo, selectid ) {
            		this.selectRegistrationType(registrationTypeCombo, selectid);
            	}
            },
            'changeprogramwindow[itemId=changeprogramWindow] form[itemId=applicantChangeProgramFilter] customcombobox[itemId=program]': {
            	select: function( programCombo, selectedProgram ) {
            		this.selectConfiguredProgram( programCombo, selectedProgram );
            	}
            },
            'changeprogramwindow[itemId=changeprogramWindow] form[itemId=applicantChangeProgramFilter] customcombobox[itemId=batch]': {
            	select: function( batchCombo, selectedBatch) {
            		this.selectConfiguredBatch( batchCombo, selectedBatch);
            	}
            },
            'changeprogramwindow[itemId=changeprogramWindow] form[itemId=applicantChangeProgramFilter] customcombobox[itemId=seatType]': {
            	select: function( seatTypeCombo, selectedSeatType ) {
            		
            	}
            },
            'applicationprogramdetailwindow[itemId=applicationProgramDetailWindow] applicationprogramdetailgrid[itemId=applicationProgramDetailGrid]': {
            	render: function(grid) {
                	var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                    	
                    	var selectedApplicationProgramGrid = applicantProfile.down('#selectedApplicantApplicationProgramGrid');
                        var applicantApplicationDetailsForm = applicantProfile.down('#applicantApplicationDetails');
                        
                        record = selectedApplicationProgramGrid.getSelectionModel().getSelection()[0];
                        
                    	if(!isNullOrEmpty(record.get('id')) && !isNullOrEmpty(applicantProfile.getApplicationId())){
                    		grid.getStore().proxy.extraParams = {
                                applicationID: applicantProfile.getApplicationId(),
                                applicationProgramID: record.get('id')
                            }
                    		
                    		grid.getStore().on('beforeload', function(store, operation) {
                    			applicationId = applicantProfile.getApplicationId();
                                var applicationProgramId = record.get('id');
                                store.proxy.extraParams = {
                                		applicationID:applicationId,
                                		applicationProgramID:applicationProgramId 
                                };
                            });
                    		grid.getStore().load({
                                scope:this,
                                callback: function(records,option,success){
                                	if(records != null && records != undefined && records != "" && records.length > 0){
                                		var form = this.getSendOfferLetterForm();
                                		if(form != undefined){
	                                		form.down('#applicationProgramId').setValue(records[0].data.id);
	                                		form.down('#programBatchSeatConfigId').setValue(records[0].data.programBatchSeatConfigurationId);
	                                		var escalationRequired = form.down('#escalationRequired');
	                                		me.loadDFRForEscalationRequired(escalationRequired);
	                                		var offerLetterField = form.down('#offerLetter');
	                                		offerLetterField.getStore().proxy.extraParams = {
	                            				ownerId: records[0].data.programBatchSeatConfigurationId,
	                       				 	};
	                                		offerLetterField.getStore().load({
	                                            scope:this,
	                                            callback: function(records,option,success){
	                                            	if(records != null && records != undefined && records != "" && records.length > 0){
	                                            		offerLetterField.setValue(records[0].data.id);
	                                           	}
	                                            }
	                                		});
	                                		if(records[0].data.maxDaysToAcceptOfferLetter != undefined && !isNullOrEmpty(records[0].data.maxDaysToAcceptOfferLetter)){
	                                			form.down('#offerValidUntil').setValue(Ext.Date.add(new Date(), Ext.Date.DAY, records[0].data.maxDaysToAcceptOfferLetter));
	                                		}
	                                		else {
	                                			form.down('#offerValidUntil').setValue(new Date());
	                                		}
	                                		var loadApplicationProgramId = records[0].data.id;
	                                		var fetchDataUrl = SERVERURL.PATH_FIND_APPLICATION_PROGRAMS_ADMISSION_DETAILS_BY_ID;
	                                		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	                                		Ext.Ajax.request({
	                                			type: 'rest',
	                                			url: fetchDataUrl+'?applicationProgramID='+loadApplicationProgramId,
	                                			method: 'GET',
	                                			success: function(response, action) {
	                                				Ext.getBody().unmask();
	                                				if(response.responseText!=undefined && !isNullOrEmpty(response.responseText)) {
		                                				var jdata = Ext.decode(response.responseText);
		                                				if(jdata.id!=undefined && !isNullOrEmpty(jdata.id)) {
		                                					me.setSendOfferLetterFormValues(form,jdata);
		                                				}
	                                				}
	                                			}
	                                		});
                                		}
                                		
                                	}
                                }
                    		});
                    	}
                    }      
            	}
            },
        	'applicationprogramdetailwindow[itemId=applicationProgramDetailWindow] sendofferletterform multiselectcombofield[itemId=documentApplicable]':{
        		afterrender: function(obj) {
        			var form = obj.up('form');
        			obj.getStore().getProxy().extraParams = {
        				isApplicableForStudent: true,
   				 	};
        			obj.getStore().load();
        		}
        	},
        	'applicationprogramdetailwindow[itemId=applicationProgramDetailWindow] sendofferletterform radiogroup[itemId=offerType]':{
        		afterrender: function(radio) {
        			var form = radio.up('form');
        			var radioValue = radio.getValue();
        			var dateOfSatisfactionCondition = form.down('#dateOfSatisfactionCondition');
        			var conditionApplicable = form.down('#conditionApplicable').getValue();
        			if(conditionApplicable.isConditionApplicable=="true") {
        				dateOfSatisfactionCondition.setVisible(true);
        			}
        			else{
        				dateOfSatisfactionCondition.setVisible(false);
        				dateOfSatisfactionCondition.allowBlank = true;
        			}
        			form.getForm().checkValidity();
        		},
        		change: function(radio, newValue, oldVaue) {
        			var form = radio.up('form');
        			var admissionConditionPanel = form.down('#applicableAdmissionPanelId');
            		for(var i=admissionConditionPanel.items.length-1; i>0;i--){
            			admissionConditionPanel.remove(admissionConditionPanel.items.items[i]);
            		}
            		form.doLayout();
        			var applicableAdmissionCondition = form.down('#applicableAdmissionCondition');
        			applicableAdmissionCondition.reset();
        			var additionlConditions = form.down('#additionlConditions');
        			additionlConditions.reset();
        			var dateOfSatisfactionCondition = form.down('#dateOfSatisfactionCondition');
        			dateOfSatisfactionCondition.reset();
        			var conditionApplicable = form.down('#conditionApplicable').getValue();
        			applicableAdmissionCondition.getStore().getProxy().extraParams = {
        				offerType: newValue,
   				 	};
        			applicableAdmissionCondition.getStore().load();
        			if(conditionApplicable.isConditionApplicable=="true") {
        				dateOfSatisfactionCondition.setVisible(true);
        			}
        			else{
        				dateOfSatisfactionCondition.setVisible(false);
        				dateOfSatisfactionCondition.allowBlank = true;
        			}
        			form.getForm().checkValidity();
        		}
        	}, 
        	'applicationprogramdetailwindow[itemId=applicationProgramDetailWindow] sendofferletterform customcombobox[itemId=applicableAdmissionCondition]':{
        		afterrender: function(obj) {
        			var form = obj.up('form');
        			var offerTypeValue = form.down('#offerType').getValue();
        			obj.getStore().getProxy().extraParams = {
        				offerType: offerTypeValue,
   				 	};
        			obj.getStore().load();
        		},
        		select: function(obj,record,value) {
        			var form = obj.up('form');
        			var additionalCondition = obj.nextSibling();
        			var satisfactionDate = obj.nextSibling().nextSibling();
        			additionalCondition.reset();
        			satisfactionDate.reset();
        			var selectedConditionId = record[0].get('id');
					var count = 0;
					var subjectMarkPanel = obj.up("#applicableAdmissionPanelId");
					var rowIndx = obj.rowIndx;
					if(!isNullOrEmpty(subjectMarkPanel)){
						subjectMarkPanel.items.each(function(item, index, items) {
							var conditionId = item.down("[name=applicableAdmissionCondition]").getValue();
							if(selectedConditionId == conditionId){
								count++;
							}
						});
					}
					if(count==1) {
						if(!isNullOrEmpty(record[0].data) && !isNullOrEmpty(record[0].data.code)) {
	        				additionalCondition.setValue(record[0].data.code);
	        			}
					} else {
						obj.reset();
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('APPLICABLE_CONDITION_ALREADY_SELECTED_MSG'));
						return false;
					}
        		}
        	},
        	'applicationprogramdetailwindow[itemId=applicationProgramDetailWindow] sendofferletterform radiogroup[itemId=escalationRequired]':{
        		afterrender: function(radio) {
        			var form = radio.up('form');
        			var radioValue = radio.getValue();
        			var escalateButton = form.down('#escalateButtonId');
        			var sendButton = form.down('#sendButtonId');
        			var assignedTo = form.down('#assignedTo');
        			var escalationComments = form.down('#escalationComments');
        			var sendButton = form.down('#sendButtonId');
        			var offerValidUntil = form.down('#offerValidUntil');
        			if(radioValue.isEscalationRequired=="true"){
        				escalateButton.setVisible(true);
        				sendButton.setVisible(false);
        				assignedTo.setVisible(true);
        				assignedTo.allowBlank = false;
        				escalationComments.setVisible(true);
        				form.getForm().checkValidity();
        			}
        			if(radioValue.isEscalationRequired=="false"){
        				escalateButton.setVisible(false);
        				sendButton.setVisible(true);
        				assignedTo.setVisible(false);
        				assignedTo.allowBlank = true;
        				escalationComments.setVisible(false);
        				escalationComments.allowBlank = true;
        				form.getForm().checkValidity();
        			}
        		},
        		change: function(radio, newValue, oldVaue) {
        			var form = radio.up('form');
        			var escalateButton = form.down('#escalateButtonId');
        			var sendButton = form.down('#sendButtonId');
        			var assignedTo = form.down('#assignedTo');
        			var escalationComments = form.down('#escalationComments');
        			var offerValidUntil = form.down('#offerValidUntil');
        			if(newValue.isEscalationRequired=="true"){
        				escalateButton.setVisible(true);
        				sendButton.setVisible(false);
        				assignedTo.setVisible(true);
        				assignedTo.allowBlank = false;
        				escalationComments.setVisible(true);
        				form.getForm().checkValidity();
        			}
        			if(newValue.isEscalationRequired=="false"){
        				escalateButton.setVisible(false);
        				sendButton.setVisible(true);
        				assignedTo.setVisible(false);
        				assignedTo.allowBlank = true;
        				escalationComments.setVisible(false);
        				escalationComments.allowBlank = true;
        				form.getForm().checkValidity();
        			}
        		}
        	},
        	'applicationprogramdetailwindow[itemId=applicationProgramDetailWindow] sendofferletterform button[itemId=sendButtonId]':{
        		click: function(obj) {
        			var $this = this;
        			var form = obj.up('form');
        			var window = $this.getApplicationProgramDetailsWindow();
        			var applicantProfile = $this.getContentPanelActiveTab();
        			var snapShotGrid = applicantProfile.down('#selectionSnapShotGrid');
        	        var grid = applicantProfile.down('#selectedApplicantApplicationProgramGrid');
        	   		var sendOfferLetterButton = grid.down("#sendOfferLetter");
        	   		var updateOfferStatusButton = grid.down("#updateOfferStatus");
        			var jsonFormFieldData = new Object();
        			jsonFormFieldData = $this.createSendOfferLetterFormJsonData(form,'Send');
        			$this.applyWindowMask(); 
        	    	Ext.Ajax.request({
        	    		type : 'rest',
        	    		url : SERVERURL.PATH_UPDATE_APPLICATION_PROGRAM_OFFER_DETAIL,
        	    		jsonData : jsonFormFieldData,
        	    		method : 'POST',
        	    		success : function(response, action) {
        	    			$this.hideWindowMask();
        	    			showSuccessMessage(getAdmissionTranslation('SUCCESS'), getAdmissionTranslation('TRANSACTION_SUCCESS'));
        	    			window.close();
        	    			grid.getStore().reload();
        	    			if(!isNullOrEmpty(snapShotGrid)){
        	    				snapShotGrid.getStore().load({
				                    params: {
				                    	applicationID: applicantProfile.getApplicationId(),
				                    	portalId:$this.getCurrentLoggedPortalId()
				                    }
               	    	 		});
        	    			}
        	    		},
        	    		failure: function(form, action) {
						   Ext.getBody().unmask();
					   }
        	    	});
        	    	grid.getSelectionModel().deselectAll();
        	    	sendOfferLetterButton.setDisabled(true);
        	    	updateOfferStatusButton.setDisabled(true);
        		}
        	},
        	'applicationprogramdetailwindow[itemId=applicationProgramDetailWindow] sendofferletterform button[itemId=escalateButtonId]':{
        		click: function(obj) {
        			var $this = this;
        			var form = obj.up('form');
        			var window = $this.getApplicationProgramDetailsWindow();
        			var applicantProfile = $this.getContentPanelActiveTab();
        			var snapShotGrid = applicantProfile.down('#selectionSnapShotGrid');
        	        var grid = applicantProfile.down('#selectedApplicantApplicationProgramGrid');
        	   		var sendOfferLetterButton = grid.down("#sendOfferLetter");
        			var jsonFormFieldData = new Object();
        			jsonFormFieldData = $this.createSendOfferLetterFormJsonData(form,'Escalate');
        			$this.applyWindowMask(); 
        	    	Ext.Ajax.request({
        	    		type : 'rest',
        	    		url : SERVERURL.PATH_UPDATE_APPLICATION_PROGRAM_OFFER_DETAIL,
        	    		jsonData : jsonFormFieldData,
        	    		method : 'POST',
        	    		success : function(response, action) {
        	    			$this.hideWindowMask();
        	    			showSuccessMessage(getAdmissionTranslation('SUCCESS'), getAdmissionTranslation('TRANSACTION_SUCCESS'));
        	    			window.close();
        	    			grid.getStore().reload();
        	    			if(!isNullOrEmpty(snapShotGrid)){
        	    				snapShotGrid.getStore().load({
				                    params: {
				                    	applicationID: applicantProfile.getApplicationId(),
				                    	portalId:$this.getCurrentLoggedPortalId()
				                    }
               	    	 		});
        	    			}
        	    		}
        	    	});
        	    	grid.getSelectionModel().deselectAll();
        	    	sendOfferLetterButton.setDisabled(true);
        		}
        	},
        	'applicationprogramdetailwindow[itemId=applicationProgramDetailWindow] sendofferletterform button[itemId=cancelButtonId]':{
        		click: function(obj) {
        			var $this = this;
        			var window = $this.getApplicationProgramDetailsWindow();
        	    	window.close();
        		}
        	},
        	'applicationprogramdetailwindow[itemId=applicationProgramDetailWindow] sendofferletterform radiogroup[itemId=conditionApplicable]':{
        		afterrender: function(radio) {
        			var form = radio.up('form');
        			var radioValue = radio.getValue();
        			var applicableAdmissionCondition = form.down('#applicableAdmissionCondition');
        			var additionlConditions = form.down('#additionlConditions');
        			var documentApplicable = form.down('#documentApplicable');
        			var escalationRequired = form.down('#escalationRequired');
        			var dateOfSatisfactionCondition = form.down('#dateOfSatisfactionCondition');
        			var offerType = form.down('#offerType').getValue();
        			var addConditionBtn = form.down('#addConditionBtn');
        			if(radioValue.isConditionApplicable=="true"){
        				applicableAdmissionCondition.setVisible(true);
        				applicableAdmissionCondition.allowBlank = false;
        				additionlConditions.setVisible(true);
        				documentApplicable.setVisible(true);
        				escalationRequired.setVisible(true);
        				dateOfSatisfactionCondition.setVisible(true);
        				addConditionBtn.setVisible(true);
        				form.getForm().checkValidity();
        			}
        			if(radioValue.isConditionApplicable=="false"){
        				applicableAdmissionCondition.setVisible(false);
        				applicableAdmissionCondition.allowBlank = true;
        				additionlConditions.setVisible(false);
        				documentApplicable.setVisible(false);
        				escalationRequired.setValue({isEscalationRequired: "false"});
        				escalationRequired.setVisible(false);
        				dateOfSatisfactionCondition.setVisible(false);
        				dateOfSatisfactionCondition.allowBlank = true;
        				addConditionBtn.setVisible(false);
        				form.getForm().checkValidity();
        			}
        		},
        		change: function(radio, newValue, oldVaue) {
        			var form = radio.up('form');
        			var admissionConditionPanel = form.down('#applicableAdmissionPanelId');
            		for(var i=admissionConditionPanel.items.length-1; i>0;i--){
            			admissionConditionPanel.remove(admissionConditionPanel.items.items[i]);
            		}
            		form.doLayout();
        			var applicableAdmissionCondition = form.down('#applicableAdmissionCondition');
        			var additionlConditions = form.down('#additionlConditions');
        			var documentApplicable = form.down('#documentApplicable');
        			var escalationRequired = form.down('#escalationRequired');
        			var dateOfSatisfactionCondition = form.down('#dateOfSatisfactionCondition');
        			var offerType = form.down('#offerType').getValue();
        			var addConditionBtn = form.down('#addConditionBtn');
        			if(newValue.isConditionApplicable=="true"){
        				applicableAdmissionCondition.setVisible(true);
        				applicableAdmissionCondition.allowBlank = false;
        				additionlConditions.setVisible(true);
        				documentApplicable.setVisible(true);
        				escalationRequired.setVisible(true);
        				dateOfSatisfactionCondition.setVisible(true);
        				addConditionBtn.setVisible(true);
        				form.getForm().checkValidity();
        				this.loadDFRForEscalationRequired(escalationRequired);
        			}
        			if(newValue.isConditionApplicable=="false"){
        				applicableAdmissionCondition.setVisible(false);
        				applicableAdmissionCondition.allowBlank = true;
        				additionlConditions.setVisible(false);
        				additionlConditions.allowBlank = true;
        				documentApplicable.setVisible(false);
        				documentApplicable.allowBlank = true;
        				escalationRequired.setValue({isEscalationRequired: "false"});
        				escalationRequired.setVisible(false);
        				dateOfSatisfactionCondition.setVisible(false);
        				dateOfSatisfactionCondition.allowBlank = true;
        				addConditionBtn.setVisible(false);
        				form.getForm().checkValidity();
        			}
        		}
        	},
        	'applicationprogramdetailwindow[itemId=applicationProgramDetailWindow] sendofferletterform button[itemId=addConditionBtn]':{
        		click: function(obj) {
        			this.addMultipleCondition(obj.up('form'));
        		}
        	},
        	'applicationprogramdetailwindow[itemId=applicationProgramDetailWindowItemId] applicationprogramdetailgrid[itemId=applicationProgramDetailGrid]': {
            	render: function(grid) {
                	var me = this;
                    var applicantProfile = me.getContentPanelActiveTab();
                    if (applicantProfile) {
                    	
                    	var selectedApplicationProgramGrid = applicantProfile.down('#selectedApplicantApplicationProgramGrid');
                        var applicantApplicationDetailsForm = applicantProfile.down('#applicantApplicationDetails');
                        
                        record = selectedApplicationProgramGrid.getSelectionModel().getSelection()[0];
                        
                    	if(!isNullOrEmpty(record.get('id')) && !isNullOrEmpty(applicantProfile.getApplicationId())){
                    		grid.getStore().proxy.extraParams = {
                                applicationID: applicantProfile.getApplicationId(),
                                applicationProgramID: record.get('id')
                            }
                    		
                    		grid.getStore().on('beforeload', function(store, operation) {
                    			applicationId = applicantProfile.getApplicationId();
                                var applicationProgramId = record.get('id');
                                store.proxy.extraParams = {
                                		applicationID:applicationId,
                                		applicationProgramID:applicationProgramId 
                                };
                            });
                    		grid.getStore().load({
                                scope:this,
                                callback: function(records,option,success){
                                	if(records != null && records != undefined && records != "" && records.length > 0){
                                		var form = this.getSendOfferLetterForm();
                                		if(form != undefined){
	                                		form.down('#applicationProgramId').setValue(records[0].data.id);
	                                		form.down('#programBatchSeatConfigId').setValue(records[0].data.programBatchSeatConfigurationId);
	                                		var offerLetterField = form.down('#offerLetter')
	                                		offerLetterField.getStore().proxy.extraParams = {
	                            				ownerId: records[0].data.programBatchSeatConfigurationId,
	                       				 	};
	                       				 	if(records[0].data.maxDaysToAcceptOfferLetter != undefined && !isNullOrEmpty(records[0].data.maxDaysToAcceptOfferLetter)){
	                                			form.down('#offerValidUntil').setValue(Ext.Date.add(new Date(), Ext.Date.DAY, records[0].data.maxDaysToAcceptOfferLetter));
	                                		}
	                                		else {
	                                			form.down('#offerValidUntil').setValue(new Date());
	                                		}
	                                		var loadApplicationProgramId = records[0].data.id;
	                                		var fetchDataUrl = SERVERURL.PATH_FIND_APPLICATION_PROGRAMS_ADMISSION_DETAILS_BY_ID;
	                                		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
	                                		Ext.Ajax.request({
	                                			type: 'rest',
	                                			url: fetchDataUrl+'?applicationProgramID='+loadApplicationProgramId,
	                                			method: 'GET',
	                                			success: function(response, action) {
	                                				Ext.getBody().unmask();
	                                				if(response.responseText!=undefined && !isNullOrEmpty(response.responseText)) {
		                                				var jdata = Ext.decode(response.responseText);
		                                				if(jdata.id!=undefined && !isNullOrEmpty(jdata.id)) {
		                                					me.setResendOfferLetterFormValues(form,jdata);
		                                					form.down('#escalationRequired').setReadOnly(true);
		                                					form.down('#escalationComments').setReadOnly(true);
		                                					form.down('#assignedTo').setReadOnly(true);
		                                				}
	                                				}else{
	                                					offerLetterField.getStore().load();
	                                					form.down('#escalationRequired').setValue({isEscalationRequired: "false"});
	                                					form.down('#escalationRequired').setReadOnly(true);
	                                					form.down('#escalationComments').setReadOnly(true);
	                                					form.down('#assignedTo').setReadOnly(true);
	                                				}
	                                			}
	                                		});
                                		}
                                		
                                	}
                                }
                    		});
                    	}
                    }      
            	}
            },
            'applicationprogramdetailwindow[itemId=applicationProgramDetailWindowItemId] sendofferletterform multiselectcombofield[itemId=documentApplicable]':{
        		afterrender: function(obj) {
        			var form = obj.up('form');
        			obj.getStore().getProxy().extraParams = {
        				isApplicableForStudent: true,
   				 	};
        			obj.getStore().load();
        		}
        	},
        	'applicationprogramdetailwindow[itemId=applicationProgramDetailWindowItemId] sendofferletterform radiogroup[itemId=offerType]':{
        		afterrender: function(radio) {
        			var form = radio.up('form');
        			var radioValue = radio.getValue();
        			var dateOfSatisfactionCondition = form.down('#dateOfSatisfactionCondition');
        			var conditionApplicable = form.down('#conditionApplicable').getValue();
        			if(conditionApplicable.isConditionApplicable=="true") {
        				dateOfSatisfactionCondition.setVisible(true);
        			}
        			else{
        				dateOfSatisfactionCondition.setVisible(false);
        				dateOfSatisfactionCondition.allowBlank = true;
        			}
        			form.getForm().checkValidity();
        		},
        		change: function(radio, newValue, oldVaue) {
        			var form = radio.up('form');
        			var admissionConditionPanel = form.down('#applicableAdmissionPanelId');
            		for(var i=admissionConditionPanel.items.length-1; i>0;i--){
            			admissionConditionPanel.remove(admissionConditionPanel.items.items[i]);
            		}
            		form.doLayout();
        			var applicableAdmissionCondition = form.down('#applicableAdmissionCondition');
        			applicableAdmissionCondition.reset();
        			var additionlConditions = form.down('#additionlConditions');
        			additionlConditions.reset();
        			var dateOfSatisfactionCondition = form.down('#dateOfSatisfactionCondition');
        			dateOfSatisfactionCondition.reset();
        			var conditionApplicable = form.down('#conditionApplicable').getValue();
        			applicableAdmissionCondition.getStore().getProxy().extraParams = {
        				offerType: newValue,
   				 	};
        			applicableAdmissionCondition.getStore().load();
        			if(conditionApplicable.isConditionApplicable=="true") {
        				dateOfSatisfactionCondition.setVisible(true);
        			}
        			else{
        				dateOfSatisfactionCondition.setVisible(false);
        				dateOfSatisfactionCondition.allowBlank = true;
        			}
        			form.getForm().checkValidity();
        		}
        	}, 
        	'applicationprogramdetailwindow[itemId=applicationProgramDetailWindowItemId] sendofferletterform customcombobox[itemId=applicableAdmissionCondition]':{
        		afterrender: function(obj) {
        			var form = obj.up('form');
        			var offerTypeValue = form.down('#offerType').getValue();
        			obj.getStore().getProxy().extraParams = {
        				offerType: offerTypeValue,
   				 	};
        			obj.getStore().load();
        		},
        		select: function(obj,record,value) {
        			var form = obj.up('form');
        			var additionalCondition = obj.nextSibling();
        			var satisfactionDate = obj.nextSibling().nextSibling();
        			additionalCondition.reset();
        			satisfactionDate.reset();
        			var selectedConditionId = record[0].get('id');
					var count = 0;
					var subjectMarkPanel = obj.up("#applicableAdmissionPanelId");
					var rowIndx = obj.rowIndx;
					if(!isNullOrEmpty(subjectMarkPanel)){
						subjectMarkPanel.items.each(function(item, index, items) {
							var conditionId = item.down("[name=applicableAdmissionCondition]").getValue();
							if(selectedConditionId == conditionId){
								count++;
							}
						});
					}
					if(count==0 || count==1) {
						if(!isNullOrEmpty(record[0].data) && !isNullOrEmpty(record[0].data.code)) {
	        				additionalCondition.setValue(record[0].data.code);
	        			}
					} else {
						obj.reset();
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('APPLICABLE_CONDITION_ALREADY_SELECTED_MSG'));
						return false;
					}
        		}
        	},
        	'applicationprogramdetailwindow[itemId=applicationProgramDetailWindowItemId] sendofferletterform radiogroup[itemId=escalationRequired]':{
        		afterrender: function(radio) {
        			var form = radio.up('form');
        			var radioValue = radio.getValue();
        			var escalateButton = form.down('#escalateButtonId');
        			var sendButton = form.down('#sendButtonId');
        			var assignedTo = form.down('#assignedTo');
        			var escalationComments = form.down('#escalationComments');
        			var sendButton = form.down('#sendButtonId');
        			var offerValidUntil = form.down('#offerValidUntil');
        			if(radioValue.isEscalationRequired=="true"){
        				escalateButton.setVisible(true);
        				sendButton.setVisible(false);
        				assignedTo.setVisible(true);
        				assignedTo.allowBlank = false;
        				escalationComments.setVisible(true);
        				form.getForm().checkValidity();
        			}
        			if(radioValue.isEscalationRequired=="false"){
        				escalateButton.setVisible(false);
        				sendButton.setVisible(true);
        				assignedTo.setVisible(false);
        				assignedTo.allowBlank = true;
        				escalationComments.setVisible(false);
        				escalationComments.allowBlank = true;
        				form.getForm().checkValidity();
        			}
        		},
        		change: function(radio, newValue, oldVaue) {
        			var form = radio.up('form');
        			var escalateButton = form.down('#escalateButtonId');
        			var sendButton = form.down('#sendButtonId');
        			var assignedTo = form.down('#assignedTo');
        			var escalationComments = form.down('#escalationComments');
        			var offerValidUntil = form.down('#offerValidUntil');
        			if(newValue.isEscalationRequired=="true"){
        				escalateButton.setVisible(true);
        				sendButton.setVisible(false);
        				assignedTo.setVisible(true);
        				assignedTo.allowBlank = false;
        				escalationComments.setVisible(true);
        				form.getForm().checkValidity();
        			}
        			if(newValue.isEscalationRequired=="false"){
        				escalateButton.setVisible(false);
        				sendButton.setVisible(true);
        				assignedTo.setVisible(false);
        				assignedTo.allowBlank = true;
        				escalationComments.setVisible(false);
        				escalationComments.allowBlank = true;
        				form.getForm().checkValidity();
        			}
        		}
        	},
        	'applicationprogramdetailwindow[itemId=applicationProgramDetailWindowItemId] sendofferletterform button[itemId=sendButtonId]':{
        		click: function(obj) {
        			var $this = this;
        			var form = obj.up('form');
        			var window =form.up('window');
        			var applicantProfile = $this.getContentPanelActiveTab();
        			var snapShotGrid = applicantProfile.down('#selectionSnapShotGrid');
        	        var grid = applicantProfile.down('#selectedApplicantApplicationProgramGrid');
        	   		var sendOfferLetterButton = grid.down("#sendOfferLetter");
        	   		var resendOfferLetterButton = grid.down("#resendOfferLetter");
        	   		var updateOfferStatusButton = grid.down("#updateOfferStatus");
        			var jsonFormFieldData = new Object();
        			jsonFormFieldData = $this.createSendOfferLetterFormJsonData(form,'Send');
        			$this.applyWindowMask(); 
        	    	Ext.Ajax.request({
        	    		type : 'rest',
        	    		url : SERVERURL.PATH_RESEND_APPLICATION_PROGRAM_OFFER_DETAIL,
        	    		jsonData : jsonFormFieldData,
        	    		method : 'POST',
        	    		success : function(response, action) {
        	    			$this.hideWindowMask();
        	    			showSuccessMessage(getAdmissionTranslation('SUCCESS'), getAdmissionTranslation('RESEND_OFFER_LETTER_MSG'));
        	    			window.close();
        	    			grid.getStore().reload();
        	    			if(!isNullOrEmpty(snapShotGrid)){
        	    				snapShotGrid.getStore().load({
				                    params: {
				                    	applicationID: applicantProfile.getApplicationId(),
				                    	portalId:$this.getCurrentLoggedPortalId()
				                    }
               	    	 		});
        	    			}
        	    		},
        	    		failure: function(form, action) {
						   Ext.getBody().unmask();
					   }
        	    	});
        	    	grid.getSelectionModel().deselectAll();
        	    	sendOfferLetterButton.setDisabled(true);
        	    	resendOfferLetterButton.setDisabled(true);
        	    	updateOfferStatusButton.setDisabled(true);
        	    	
        			
        		}
        	},
        	'applicationprogramdetailwindow[itemId=applicationProgramDetailWindowItemId] sendofferletterform button[itemId=cancelButtonId]':{
        		click: function(obj) {
        	    	obj.up('form').up('window').close();
        		}
        	},
        	'applicationprogramdetailwindow[itemId=applicationProgramDetailWindowItemId] sendofferletterform radiogroup[itemId=conditionApplicable]':{
        		afterrender: function(radio) {
        			var form = radio.up('form');
        			var radioValue = radio.getValue();
        			var applicableAdmissionCondition = form.down('#applicableAdmissionCondition');
        			var additionlConditions = form.down('#additionlConditions');
        			var documentApplicable = form.down('#documentApplicable');
        			var escalationRequired = form.down('#escalationRequired');
        			var dateOfSatisfactionCondition = form.down('#dateOfSatisfactionCondition');
        			var offerType = form.down('#offerType').getValue();
        			var addConditionBtn = form.down('#addConditionBtn');
        			if(radioValue.isConditionApplicable=="true"){
        				applicableAdmissionCondition.setVisible(true);
        				applicableAdmissionCondition.allowBlank = false;
        				additionlConditions.setVisible(true);
        				documentApplicable.setVisible(true);
        				escalationRequired.setVisible(true);
        				dateOfSatisfactionCondition.setVisible(true);
        				addConditionBtn.setVisible(true);
        				form.getForm().checkValidity();
        			}
        			if(radioValue.isConditionApplicable=="false"){
        				applicableAdmissionCondition.setVisible(false);
        				applicableAdmissionCondition.allowBlank = true;
        				additionlConditions.setVisible(false);
        				documentApplicable.setVisible(false);
        				escalationRequired.setValue({isEscalationRequired: "false"});
        				escalationRequired.setVisible(false);
        				dateOfSatisfactionCondition.setVisible(false);
        				dateOfSatisfactionCondition.allowBlank = true;
        				addConditionBtn.setVisible(false);
        				form.getForm().checkValidity();
        			}
        		},
        		change: function(radio, newValue, oldVaue) {
        			var form = radio.up('form');
        			var admissionConditionPanel = form.down('#applicableAdmissionPanelId');
        			for(var i=admissionConditionPanel.items.length-1; i>0;i--){
            			admissionConditionPanel.remove(admissionConditionPanel.items.items[i]);
            		}
            		form.doLayout();
        			var applicableAdmissionCondition = form.down('#applicableAdmissionCondition');
        			var additionlConditions = form.down('#additionlConditions');
        			var documentApplicable = form.down('#documentApplicable');
        			var escalationRequired = form.down('#escalationRequired');
        			var dateOfSatisfactionCondition = form.down('#dateOfSatisfactionCondition');
        			var offerType = form.down('#offerType').getValue();
        			var addConditionBtn = form.down('#addConditionBtn');
        			if(newValue.isConditionApplicable=="true"){
        				applicableAdmissionCondition.setVisible(true);
        				applicableAdmissionCondition.allowBlank = false;
        				additionlConditions.setVisible(true);
        				documentApplicable.setVisible(true);
        				escalationRequired.setVisible(true);
        				dateOfSatisfactionCondition.setVisible(true);
        				addConditionBtn.setVisible(true);
        				form.getForm().checkValidity();
        				this.loadDFRForEscalationRequired(escalationRequired);
        			}
        			if(newValue.isConditionApplicable=="false"){
        				applicableAdmissionCondition.setVisible(false);
        				applicableAdmissionCondition.allowBlank = true;
        				additionlConditions.setVisible(false);
        				additionlConditions.allowBlank = true;
        				documentApplicable.setVisible(false);
        				documentApplicable.allowBlank = true;
        				escalationRequired.setValue({isEscalationRequired: "false"});
        				escalationRequired.setVisible(false);
        				dateOfSatisfactionCondition.setVisible(false);
        				dateOfSatisfactionCondition.allowBlank = true;
        				addConditionBtn.setVisible(false);
        				form.getForm().checkValidity();
        			}
        		}
        	},
        	'applicationprogramdetailwindow[itemId=applicationProgramDetailWindowItemId] sendofferletterform button[itemId=addConditionBtn]':{
        		click: function(obj) {
        			this.addMultipleCondition(obj.up('form'));
        		}
        	},
        	'referenceformwindow[itemId=applicantReferenceWindow] customcombobox[itemId=mobileCountryCode]': {
            	select: function(rowModel,record){
                		var form = this.getApplicantReferenceWindow();
                		var countryCodeField = form.down("#mobileCountryCode");
                     	var mobileField = form.down("#contactNo");
                     	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
            		
            	}                  
            },
            'referenceformwindow[itemId=applicantReferenceWindow] customcombobox[itemId=contactNo]': {
            	change: function(record) {
                	var form = this.getApplicantReferenceWindow();
                	var mobileField = form.down("#contactNo");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }                  
            }
        });
    },
    selectConfiguredProgramGroup : function(programGroupCombo, selectedProgramGroup){
		
		var form = programGroupCombo.up('form');
		
		var academyLocationCombo = form.down('#academyLocation');
		
		var modeOfDeliveryId = form.down('#modeDeliveryId').getValue();
		
		var registrationType = null; 
		
		if(form.down('#registrationTypeId').getValue()=='PART_TIME'){
			registrationType = true;
		}
		if(form.down('#registrationTypeId').getValue()=='FULL_TIME'){
			registrationType = false;
		}
		
		var programCombo = form.down('#program');
		var storeProgram = programCombo.getStore();
		storeProgram.proxy.extraParams = {
				programGroupId:programGroupCombo.getValue(),
				academyLocationId:academyLocationCombo.getValue(),
				modeDeliveryId:modeOfDeliveryId,
				registrationTypeEnum:registrationType
		};
		storeProgram.removeAll();
		if(registrationType==null){
		delete storeProgram.getProxy().extraParams.registrationTypeEnum;
		}
		programCombo.reset();
		storeProgram.load({
            scope:this,
            callback: function(records,option,success){
            	if(records != null && records != undefined && records != "" && records.length > 0){
            		if( records.length == 1 ){
            			programCombo.select(storeProgram.getAt(0));
            			var model = [records[0]];
                		programCombo.fireEvent('select', programCombo, model);
            		}
            		programCombo.setDisabled(false);
            	} else {
            		storeProgram.removeAll();
            		programCombo.reset();
            		programCombo.setDisabled(false);
            	}
            	
            }
		});
		
		var batchCombo = form.down('#batch');
		var storeBatch = batchCombo.getStore();
		storeBatch.removeAll();
		batchCombo.reset();
		batchCombo.setDisabled(true);
		
		var seatTypeCombo = form.down('#seatType');
		var storeSeatType = seatTypeCombo.getStore();
		storeSeatType.removeAll();
		seatTypeCombo.reset();
		seatTypeCombo.setDisabled(true);
		
	},
    selectConfiguredProgram : function(programCombo, selectedProgram){
		
		var form = programCombo.up('form');
		var batchCombo = form.down('#batch');
		var modeOfDeliveryId = form.down('#modeDeliveryId').getValue();
		var registrationType = null; 
		var storeBatch = batchCombo.getStore();
		
		var seatTypeCombo = form.down('#seatType');
		var storeSeatType = seatTypeCombo.getStore();
		storeSeatType.removeAll();
		seatTypeCombo.reset();
		seatTypeCombo.setDisabled(true);
		if(form.down('#registrationTypeId').getValue()=='PART_TIME'){
			registrationType = true;
		}
		if(form.down('#registrationTypeId').getValue()=='FULL_TIME'){
			registrationType = false;
		}
		if(registrationType!=null){
			storeBatch.proxy.extraParams = {
		        	programId:programCombo.getValue(),
		        	modeOfDeliveryId:modeOfDeliveryId,
					registrationTypeEnum:registrationType
			};
		}else{
			storeBatch.proxy.extraParams = {
		        	programId:programCombo.getValue(),
		        	modeOfDeliveryId:modeOfDeliveryId
			};
		}
		storeBatch.removeAll();
		batchCombo.reset();
		storeBatch.load({
            scope:this,
            callback: function(records,option,success){
            	if(records != null && records != undefined && records != "" && records.length > 0){
            		//if(storeProgramGroup.getAt(0)){
            		if( records.length == 1 ){
            			batchCombo.select(storeBatch.getAt(0));
            			var model = [records[0]];
            			batchCombo.fireEvent('select', batchCombo, model);
            			//this.selectConfiguredBatch( batchCombo, model);
            		}
            		batchCombo.setDisabled(false);
            	} else {
            		storeBatch.removeAll();
            		batchCombo.reset();
            		batchCombo.setDisabled(false);
            	}
            }
		});
		
	},
    selectConfiguredBatch : function(batchCombo, selectedBatch){
		
		var form = batchCombo.up('form');
		var seatTypeCombo = form.down('#seatType');
		var storeSeatType= seatTypeCombo.getStore();
		var oldProgramgrid = this.getChangeProgramGrid();
    	var oldProgramRecord = oldProgramgrid.getSelectionModel().getSelection()[0];
    	if(!isNullOrEmpty(oldProgramRecord)){
    		var programBatchSeatConfigurationId = oldProgramRecord.get('programBatchSeatConfigurationId');
    	}else{
    		var programBatchSeatConfigurationId = oldProgramgrid.getStore().data.items[0].data.programBatchSeatConfigurationId
    	}
		storeSeatType.proxy.extraParams = {
        	batchId:batchCombo.getValue(),
        	programBatchSeatConfigurationId:programBatchSeatConfigurationId
        	
        };
		storeSeatType.removeAll();
		seatTypeCombo.reset();
		storeSeatType.load({
            scope:this,
            callback: function(records,option,success){
            	if(records != null && records != undefined && records != "" && records.length > 0){
            		//if(storeProgramGroup.getAt(0)){
            		if( records.length == 1 ){
            			seatTypeCombo.select(storeSeatType.getAt(0));
            			var model = [records[0]];
            			seatTypeCombo.fireEvent('select', seatTypeCombo, model);
            		}
            		seatTypeCombo.setDisabled(false);
            	} else {
            		storeSeatType.removeAll();
            		seatTypeCombo.reset();
            		seatTypeCombo.setDisabled(false);
            	}
            }
		});
		
	},
	selectModeOfDelivery : function(modeOfDeliveryCombo, selectid){
		
		var form = modeOfDeliveryCombo.up('form');
		
		var academyLocationCombo = form.down('#academyLocation');
		
		var programGroupCombo = form.down('#programGroup');
		
		var modeOfDeliveryId = form.down('#modeDeliveryId').getValue();
		
		var registrationType = null; 
		
		if(form.down('#registrationTypeId').getValue()=='PART_TIME'){
			registrationType = true;
		}
		if(form.down('#registrationTypeId').getValue()=='FULL_TIME'){
			registrationType = false;
		}
		
		var programCombo = form.down('#program');
		var storeProgram = programCombo.getStore();
		
		var batchCombo = form.down('#batch').setDisabled(true);
		var storeBatch = batchCombo.getStore();
		storeBatch.removeAll();
		batchCombo.reset();
		var seatTypeCombo = form.down('#seatType').setDisabled(true);
		var storeSeatType = seatTypeCombo.getStore();
		storeSeatType.removeAll();
		seatTypeCombo.reset();
		storeProgram.proxy.extraParams = {
				programGroupId:programGroupCombo.getValue(),
				academyLocationId:academyLocationCombo.getValue(),
				modeDeliveryId:modeOfDeliveryId,
				registrationTypeEnum:registrationType
		};
		storeProgram.reload();
	},
	selectRegistrationType : function(registrationTypeCombo, selectid){
		
		var form = registrationTypeCombo.up('form');
		
		var academyLocationCombo = form.down('#academyLocation');
		
		var programGroupCombo = form.down('#programGroup');
		
		var modeOfDeliveryId = form.down('#modeDeliveryId').getValue();
		
		var registrationType = null; 
		
		if(form.down('#registrationTypeId').getValue()=='PART_TIME'){
			registrationType = true;
		}
		if(form.down('#registrationTypeId').getValue()=='FULL_TIME'){
			registrationType = false;
		}
		
		var programCombo = form.down('#program');
		var storeProgram = programCombo.getStore();
		
		var batchCombo = form.down('#batch').setDisabled(true);
		var storeBatch = batchCombo.getStore();
		storeBatch.removeAll();
		batchCombo.reset();
//		storeBatch.reload();
		var seatTypeCombo = form.down('#seatType').setDisabled(true);
		var storeSeatType = seatTypeCombo.getStore();
		storeSeatType.removeAll();
		seatTypeCombo.reset();
//		storeSeatType.reload();
		storeProgram.proxy.extraParams = {
				programGroupId:programGroupCombo.getValue(),
				academyLocationId:academyLocationCombo.getValue(),
				modeDeliveryId:modeOfDeliveryId,
				registrationTypeEnum:registrationType
		};
		storeProgram.reload();
	},
    getAddChangeProgram : function(btn){
    	var $this = this;
    	
    	var oldProgramgrid = this.getChangeProgramGrid();
    	var oldProgramRecord = oldProgramgrid.getSelectionModel().getSelection()[0];
    	if(!isNullOrEmpty(oldProgramRecord)){
    		var oldProgramRecord = oldProgramRecord;
    	}else{
    		var oldProgramRecord = oldProgramgrid.getStore().data.items[0]
    	}
    	var applicantProfile = $this.getContentPanelActiveTab();
    	
    	var form = btn.up('form');
    	var newAcademyLocationId = form.down('#academyLocation').getValue();
    	var newProgramId = form.down('#program').getValue();
    	var newBatchId = form.down('#batch').getValue();
    	
    	var newSeatTypeVlue = form.down('#seatType').getValue();
    	var newSeatTypeId = form.down('#seatType').findRecordByValue(newSeatTypeVlue).data.sequence;
    	var newProgBatchSeatConfigId = form.down('#seatType').findRecordByValue(newSeatTypeVlue).data.id;
        var schoolAttendanceStartDate = form.down('#schoolAttendanceStartDate').getValue();

    	var changeJson={
    			applicationId : applicantProfile.getApplicationId(),
    			applicationProgramId :  oldProgramRecord.get('id'),
    			applicationStatus : applicantProfile.applicationInfo.applicationStatus,
    			programId : newProgramId,
    			batchId : newBatchId,
    			seatTypeId : newSeatTypeId,
    			progBatchSeatConfigId : newProgBatchSeatConfigId,
    			academyLocationId : newAcademyLocationId,
    			oldProgramId : oldProgramRecord.get('program').id,
    			oldBatchId : oldProgramRecord.get('batch').id,
    			oldSeatTypeId : oldProgramRecord.get('seatType').id,
    			oldProgBatchSeatConfigId : oldProgramRecord.get('programBatchSeatConfigurationId'),
    			oldAcademyLocationId : oldProgramRecord.get('academyLocationId'),
    			schoolAttendanceStartDate : schoolAttendanceStartDate
    	};

    	$this.applyWindowMask(); 
    	Ext.Ajax.request({
    		type : 'rest',
    		url : SERVERURL.APPLICATION_PROGRAM_TO_CHANGE,
    		jsonData : changeJson,
    		method : 'POST',
    		success : function(response, action) {
    			$this.hideWindowMask();
    			showSuccessMessage(getAdmissionTranslation('CHANGE_APPLICATION_PROGRAM'), getAdmissionTranslation('TRANSACTION_SUCCESS'));
    			$this.getCloseChangeProgramWin();
    			oldProgramgrid.getStore().reload();
    			$this.mixins.ApplicationBaseController.gettingDataInSummaryGrid(applicantProfile);   
    			//oldProgramgrid.getSelectionModel().deselectAll();
    		},
			failure: function(form, action) {
				$this.getCloseChangeProgramWin();
			}
    	});
    	oldProgramgrid.getSelectionModel().deselectAll();
    },
    getCloseChangeProgramWin : function(){
    	this.getChangeProgramWindow().close();
    },
    getEditChangeProgram: function() {
    	var $this = this;
    	var grid = null;
    	 var applicantProfile = $this.getContentPanelActiveTab();
    	 var snapShotGrid = applicantProfile.down('#selectionSnapShotGrid');
    	 
    	 if(!isNullOrEmpty(snapShotGrid)){
    		 var store = snapShotGrid.getStore();
    	 }
    	
    	grid = applicantProfile.down('#changeprogramGrid');
    	 if(isNullOrEmpty(grid)){
    		 grid = this.getChangeProgramGrid();
    	 }
    	if (grid.getSelectionModel().getCount() > 0) {
    		if (applicantProfile) {
    			if(!isNullOrEmpty(applicantProfile.getApplicationId())){
    				if(store.find('admissionStatus', 'ADMISSION_IN_PROGRESS') == 0){
    					showWarningMessage(getAdmissionTranslation('CHANGE_APPLICATION_PROGRAM'), getAdmissionTranslation('APPLICATION_PROGRAM_STATUS_AFTER_ADMISSION_IN_PROGRESS'));
    					return false;
    				}else if (applicantProfile.getApplicationInfo()['applicationStatus']=='REJECTED'){
    					showWarningMessage(getAdmissionTranslation('CHANGE_APPLICATION_PROGRAM'), getAdmissionTranslation('APPLICATION_PROGRAM_STATUS_AFTER_REJECTION'));
    					return false;
    				}else if (applicantProfile.getApplicationInfo()['applicationStatus']=='WITHDRAWN'){
    					showWarningMessage(getAdmissionTranslation('CHANGE_APPLICATION_PROGRAM'), getAdmissionTranslation('APPLICATION_PROGRAM_STATUS_AFTER_WITHDRAWN'));
    					return false;
    				}else if (applicantProfile.getApplicationInfo()['applicationStatus']=='ADMISSION_GRANTED'){
    					showWarningMessage(getAdmissionTranslation('CHANGE_APPLICATION_PROGRAM'), getAdmissionTranslation('APPLICATION_PROGRAM_STATUS'));
    					return false;
    				}else {
    					var window = this.getChangeProgramWindow();
    					if (!window) {
    						window = Ext.widget('changeprogramwindow', {
    							itemId: 'changeprogramWindow'
    						});
    					}
    					window.show();
    					var changeprogramwindowcurrentgrid = this.getChangeprogramwindowcurrentgrid();
    					changeprogramwindowcurrentgrid.getStore().removeAll();
    					var storeCurrentProgram = changeprogramwindowcurrentgrid.getStore();
    					
    					var selectedRecord = grid.getSelectionModel().selected.items[0].data;
    					
    					var oldProgramId = selectedRecord.program.id;
    					var oldBatchId = selectedRecord.batch.id;
    					var oldSeatTypeId = selectedRecord.seatType.id;
    					var oldProgBatchSeatConfigId = selectedRecord.programBatchSeatConfigurationId;
    					var academyLocationName = selectedRecord.academy.value+" "+selectedRecord.location.value;
    					var programGroupName = selectedRecord.programGroupName;
    					var programName = selectedRecord.program.value;
    					var batchName = selectedRecord.batch.value;
    					var seatTypeName = selectedRecord.seatType.value;
    					var modeOfDelivery = selectedRecord.modeOfDelivery.value;
                        var schoolAttendanceStartDate;
    					var registrationType=null;
    					if(!selectedRecord.batchPartTime){
    						registrationType = 'Full Time';
    					}
    					if(selectedRecord.batchPartTime){
    						registrationType = 'Part Time';
    					}
    					
    					var url = SERVERURL.PATH_FIND_APPLICANT_PROGRAM_BATCH;
						Ext.Ajax.request({
							type: 'rest',
							url: url,
							method: 'GET',
							params: {
								applicationID: applicantProfile.getApplicationId()
							},
							headers: {
								'Content-Type': 'application/json'
							},
							success: function(response, action) {
								var responseObj = Ext.decode(response.responseText);
								var matchedRecord = null;

								if (Ext.isArray(responseObj)) {
									for (var i = 0; i < responseObj.length; i++) {
										var record = responseObj[i];
										// Match the record using programBatchSeatConfigurationId or any other ID
										if (record.programBatchSeatConfigurationId === oldProgBatchSeatConfigId) {
											matchedRecord = record;
											break;
										}
									}
								}

								if (matchedRecord) {
									schoolAttendanceStartDate = matchedRecord.schoolAttendanceStartDate;
								}
								storeCurrentProgram.add({
									id: selectedRecord.id,
									academyLocationName: academyLocationName,
									programGroupName: programGroupName,
									programName: programName,
									batchName: batchName,
									seatTypeName: seatTypeName,
									oldProgramId: oldProgramId,
									oldBatchId: oldBatchId,
									oldSeatTypeId: oldSeatTypeId,
									oldProgBatchSeatConfigId: oldProgBatchSeatConfigId,
									modeOfDelivery: modeOfDelivery,
									batchPartTime: registrationType,
									schoolAttendanceStartDate: schoolAttendanceStartDate
								});

								changeprogramwindowcurrentgrid.bindStore(storeCurrentProgram);
								var schoolAttendanceStartDateField = window.down('#schoolAttendanceStartDate');
								schoolAttendanceStartDateField.setValue(dateRender(schoolAttendanceStartDate));
							}
						});  
    					
    				}
    			}
    		}

    	}else{
    		showWarningMessage(getAdmissionTranslation('CHANGE_APPLICATION_PROGRAM'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
    	}
    },
    getRenderChangeProgram : function(grid){
    	this.doAccessControlValidation(grid, this.getAPPLICANT_CHANGE_APPLICATION_PROGRAM_PERMISSIONS());
    	buttonsToolBar = grid.query('toolbar')[0];
    	var button = buttonsToolBar.query('#btnEdit')[0];
    	button.setVisible(true);
    	buttonsToolBar.query('#btnView')[0].setVisible(false);
    	var me = this;
        var applicantProfile = me.getContentPanelActiveTab();
        if (applicantProfile) {
        	if(!isNullOrEmpty(applicantProfile.getApplicationId())){
        		if(applicantProfile.getApplicationInfo()['isViewMode']||
        			((applicantProfile.getApplicationInfo()['applicationStatus']!=='APPLIED') &&
                    (applicantProfile.getApplicationInfo()['applicationStatus']!=='SOLD') &&
                    (applicantProfile.getApplicationInfo()['applicationStatus']!=='SUBMITTED')  &&
                    (applicantProfile.getApplicationInfo()['applicationStatus']!=='DIRECT_ADMISSION') &&
                    (applicantProfile.getApplicationInfo()['applicationStatus']!=='MID_TERM_ADMISSION')) 
        		){
            		me.mixins.ApplicationBaseController.setContainerInViewMode(grid);
            	}
        		grid.getStore().load({
                    params: {
                        applicationID: applicantProfile.getApplicationId()
                    }
                });
        		
        		grid.getStore().on('beforeload', function(store, operation) {
                    var applicationId = applicantProfile.getApplicationId();
                    store.proxy.extraParams = {
                    		applicationID:applicationId 
                    };
                });
        	}
        }             
    },

    /**************Application Details Tab ********************/
    /**
     * This function is used for to save application form details
     *     
     */
    updateApplicationForm: function(applicationForm, grid) {
    	var me=this;
    	var applicantProfile = me.getContentPanelActiveTab();
        if (applicationForm  && applicantProfile) {                         
            var applicantionId = applicantProfile.getApplicationId();
            var version= applicantProfile.getApplicationDataObject()['version'];
            if(!isNullOrEmpty(applicantionId) && !isNullOrEmpty(version)){
            	var applicationFormData = new Object();
                var formData = applicationForm.getValues();
                if (!isEmpty(formData)) {
                    applicationFormData.id = applicantionId;
                    applicationFormData.version = version;
                    applicationFormData.familyIncome = (!isNullOrEmpty(formData.familyIncome)) ? formData.familyIncome : 0;
                    applicationFormData.reservationCategory = (!isEmpty(formData.reservationCategory)) ? formData.reservationCategory : null;
                }
            }
            
            if (!isEmpty(applicationFormData)) {
                var jsonFormatFormData = Ext.encode(applicationFormData);
                Ext.Ajax.request({
                    type: 'rest',
                    url: SERVERURL.APPLICATION_FORM_SALE_APPLICANT_UPDATE, //URL-rest/application/update
                    jsonData: jsonFormatFormData,
                    method: 'PUT',
                    success: function(response, form) {
                        showSuccessMessage(getAdmissionTranslation('ADD_APPLICATION'), getAdmissionTranslation('ADD_APPLICATION_MSG')); //Application saved successfully.
                        me.mixins.ApplicantPersonalController.onRenderApplicantPersonalInformationForm(me);
                        applicationForm.getForm().reset();
                        if (grid) {
                            grid.getStore().reload();
                            grid.getSelectionModel().deselectAll();
                        }
                    }
                });
            }
        }
    },

    /**************Reference Tab ********************/
    /*
     * This function is used for to show References Details Dialog box   
     */
    addReferences: function(isAdd) {
        var window = this.getApplicantReferenceWindow();
        if (!window) {
            window = Ext.widget('referenceformwindow', {
                itemId: 'applicantReferenceWindow'
            });
        }
        window.show();
        if(isAdd && !isNullOrEmpty(window) && !isNullOrEmpty(window.down('form'))) {
        	var form = window.down('form');
	        var countryCodeFieldItemIDArray = ["#mobileCountryCode"];
		    this.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
	    	var countryCodeField = form.down("#mobileCountryCode");
	    	var mobileField = form.down("#contactNo");
	    	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
        }
    },

    /*
     * This function is used for to show References Details Dialog box with values of selected record after clicking on edit button   
     */
    editReferences: function(grid, isView) {
        var me = this;
        if (grid.getSelectionModel().getCount() > 0) {
            me.addReferences(false); //show References Details Dialog box  
            var record = grid.getSelectionModel().getSelection()[0];
            var window = me.getApplicantReferenceWindow();
            if (window) {
                var referenceForm = window.down('#referenceForm');
                if (!isEmpty(record) && !isEmpty(referenceForm)) {
                    var rec = new Academia.model.admission.applications.applicationDetailsAndReferences.ReferenceModel(record.data);
                    referenceForm.loadRecord(rec);
                    if(record.data.salutation.id!=null && record.data.salutation.id!=undefined) {
	                    var salutationId = record.data.salutation.id;
	                    
	                    var salutation = referenceForm.down('#salutation');
	                    var store = salutation.getStore();
	                    store.load({
	                    	callback: function(records, operation, success) {
	                    		if (success) {
	                    			for(var i in records) {
	                    				if(records[i].data.id == salutationId) {
	                    					salutation.setValue(records[i].data.id);
	                    				}
	                    			}
	                    		}
	                    	}
	                    });
                    }
				    if (isView) {
                        window.down('#btnSaveReferencesForm').setVisible(false);
                        toggleReadOnlyFormItems(referenceForm.getForm(), true);
                        referenceForm.getForm().isValid();
                    }
                }
            }
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },

    /*  
     *   This function is used for to save References Details after clicking on save button
     *       
     */
    saveReferences: function(grid, window) {
    	var me=this;
    	//var applicantProfile = me.getContentPanelActiveTab();
        
        var applicantProfile = me.getContentPanelActiveTab();
        if (applicantProfile) {
        	try{
        		applicantProfile.getApplicationId();
        	} catch(e){
        		applicantProfile = me.getContentPanel().items.items[0];
        	}
        }
    	
    	var referenceForm = window.down('#referenceForm');
        var submitUrl = '',
            methodName = '',
            isUpdate = false;
        if (referenceForm  && applicantProfile) {  
        	var applicationId = applicantProfile.getApplicationId();
            var referenceFormData = referenceForm.getValues();
            referenceFormData.applicationId = applicationId;
            referenceFormData.salutation=me.getIdValueJson(referenceFormData.salutation);
                        if(referenceFormData.waived=="") {
            	delete(referenceFormData.waived);
            }
            var referenceHiddenField = referenceForm.down('#referenceHiddenField');
            if (isNullOrEmpty(referenceHiddenField.getSubmitValue())) {
                submitUrl = SERVERURL.APPLICATIONS_REFERENCES_CREATE, //rest/applicationReference/create
                methodName = 'POST';
                isUpdate = false;
            } else {
                submitUrl = SERVERURL.APPLICATIONS_REFERENCES_UPDATE, //rest/applicationReference/update
                methodName = 'PUT';
                isUpdate = true;
            }
            var jsonFormatFormData = Ext.encode(referenceFormData);
            if (!isNullOrEmpty(submitUrl) && !isNullOrEmpty(methodName) && !isNullOrEmpty(jsonFormatFormData)) {
            	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
            	referenceForm.down('#btnSaveReferencesForm').setDisabled(true);
            	Ext.Ajax.request({
                    type: 'rest',
                    url: submitUrl,
                    method: methodName,
                    jsonData: jsonFormatFormData,
                    success: function(form, action) {
                        window.close();
                        grid.getStore().reload();
                        grid.getSelectionModel().deselectAll();
                        if (isUpdate) {
                            showSuccessMessage(getAdmissionTranslation('REFERENCES'), getAdmissionTranslation('UPDATE_REFERENCE_MSG')); //References updated successfully												
                        } else {
                            showSuccessMessage(getAdmissionTranslation('REFERENCES'), getAdmissionTranslation('ADD_REFERENCE_MSG')); //References added successfully												
                        }
                        Ext.getBody().unmask();
                    }
                });

            }
        }
    },

    /*
     * This function is used for to delete References after click on delete button.
     * 
     */
    deleteReferences: function(grid) {
        var grdStore = grid.getStore();
        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getAdmissionTranslation('DELETE_REFERENCE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var referenceId = "",
                                url = '';
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                referenceId = records[count].get("id");
                                url = SERVERURL.APPLICATIONS_REFERENCES_DELETE; //URL-rest/applicationReference/delete                                    
                                if (!isNullOrEmpty(referenceId) && !isNullOrEmpty(url)) {
                                    url = url.concat("/" + referenceId);
                                    Ext.Ajax.request({
                                        type: 'rest',
                                        method: 'DELETE',
                                        url: url,
                                        success: function(form, action) {
                                            showSuccessMessage(getAdmissionTranslation('DELETE_REFERENCE'), getAdmissionTranslation('DELETE_REFERENCE_MSG')); //References deleted successfully.
                                            grdStore.reload();
                                        }
                                    });
                                }
                            }
                        }
                    }
                }
            });
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },
    addProgramWindowQuickSearch : function(){
    		var programWindow = this.getApplicantAddProgramWindow();
            var addProgramWindowGrid = programWindow.down('#applicantProfileAddApplicationProgramGrid');
    		var a = addProgramWindowGrid.down("#cmbAcademyLocations");
    		var b = addProgramWindowGrid.down("#cmbPgmGroup");
    		var c = addProgramWindowGrid.down("#cmbPrograms");
    		var d = addProgramWindowGrid.down("#modeDeliveryId");
    		var e = addProgramWindowGrid.down("#registrationTypeId");
    		
    		if(b != undefined){
            	if( b.getValue() == null || b.getValue() == undefined || b.getValue() == ""){
            		showWarningMessage(getAdmissionTranslation('SUBMIT_FORM'), getAdmissionTranslation('SELECT_PROGRAM_GROUP_ERR_MSG'));
            	}else{
            		var programGroupIds = [];
                    var selectedProgramId = 0;
                    var selectedAcademyLocationId = 0;
                    var selectedProgramGroup = programGroupIds;
                    var modeDeliveryId = 0;
    				var regTypeEnum = null;                
                    if(a != undefined && a.getValue() != null ){
                    	selectedAcademyLocationId = a.getValue();
                    }
                    
                    if(c != undefined && c.getValue() != null ){
                    	
                    		if (c.getValue() === parseInt(c.getValue(), 10)){
                    		selectedProgramId = c.getValue();
                    	}
                    	
                    }
                    if (d != undefined && d.getValue() != null) {
    					modeDeliveryId = d.getValue();
    				}
    				if (e != undefined && e.getValue() != null) {
    					if(e.getValue()=='FULL_TIME'){
    						regTypeEnum = false;
    					}else if(e.getValue()=='PART_TIME'){
    						regTypeEnum = true;
    					}
    				}
                    
                    if(b != undefined){
                    	
                    	if( b.getValue() == null ){    	            	
                        	var items = b.store.data.items;
                        	if(items.length > 0){
                        		var arrayLength = items.length;
                        		for (var i = 0; i < arrayLength; i++) {
                        			programGroupIds.push(items[i].raw.id);            			
                        		}
                        	}
                        	selectedProgramGroup = 0;
                    	}else{    	            		
                    		selectedProgramGroup = b.getValue();
                    	}
                    }
                    
            		var isformSaleSelection=false, isformSubmissionSelection=false,whetherAdmissionOpen =true;
            		this.loadAddProgramGrid(addProgramWindowGrid, selectedProgramGroup,isformSaleSelection,isformSubmissionSelection,whetherAdmissionOpen, programGroupIds,
            				selectedAcademyLocationId, selectedProgramId,modeDeliveryId,regTypeEnum);
            	}
            }
    },
    getMaxProgramsAllowedForSelectedProgramGroup : function(storeProgramGroupDropdown, programGroupId){
    	if(storeProgramGroupDropdown != null && storeProgramGroupDropdown != undefined){
    		var maxProgramsAllowed = -1;
    		var items = storeProgramGroupDropdown.data.items;
    		if(items != undefined && items.length == 0){
    			return maxProgramsAllowed;
    		}
    		if(items != undefined && items.length > 0){
    			items.forEach(function(entry) {
    			    if(programGroupId == entry.raw.id){
    			    	maxProgramsAllowed = entry.raw.maxProgramsAllowed;
    			    }
    			});
    		}
    		return maxProgramsAllowed;
    	}
    },
    getAppliedProgramsByProgramGroupId : function(storeAppliedPrograms, selectedProgramGroupId){
    	if(storeAppliedPrograms != null && storeAppliedPrograms != undefined){
    		var appliedProgramsCountByProgramGroupId = 0;
    		var items = storeAppliedPrograms.data.items;
    		if(items != undefined && items.length == 0){
    			return appliedProgramsCountByProgramGroupId;
    		}
    		if(items != undefined && items.length > 0){
    			items.forEach(function(entry) {
    			    if(selectedProgramGroupId == entry.data.programGroupId){
    			    	appliedProgramsCountByProgramGroupId++;
    			    }
    			});
    		}
    		return appliedProgramsCountByProgramGroupId;
    	}
    },
    validateMaxProgramsAllowed : function(programTabGrid,programWindow,addProgramWindowGrid){
    	
    	var selectedApplicationProgramGrid = programTabGrid;
        var programWindow = programWindow;
        var addProgramWindowGrid = addProgramWindowGrid;
    	
    	var b = addProgramWindowGrid.down("#cmbPgmGroup");
        var selectedProgramGroupId = b.getValue();
        var storeProgramGroup = b.getStore();
        var storeProgramGroupItems = storeProgramGroup.data.items;
        
        var maxProgramsAllowed = this.getMaxProgramsAllowedForSelectedProgramGroup(storeProgramGroup, selectedProgramGroupId);
        
        if(maxProgramsAllowed != null && parseInt(maxProgramsAllowed) != -1 && parseInt(maxProgramsAllowed) != 0 ){
            var programsAppliedByProgramGroup = this.getAppliedProgramsByProgramGroupId(selectedApplicationProgramGrid.getStore(),selectedProgramGroupId);
            var selectedPrograms = addProgramWindowGrid.getSelectionModel().selected;
            if(selectedPrograms != undefined){
            	var selectedProgramsCount = selectedPrograms.items.length;
            	if( parseInt(selectedProgramsCount) + parseInt(programsAppliedByProgramGroup) > parseInt(maxProgramsAllowed) ){
            		if(parseInt(maxProgramsAllowed) == 1){
            			showWarningMessage(getAdmissionTranslation('SUBMIT_FORM'), getAdmissionTranslation('MAX_PROGRAMS_ERR_MSG_START') + maxProgramsAllowed + getAdmissionTranslation('MAX_PROGRAMS_SINGLE_ERR_MSG_END'));
            		}else{
            			showWarningMessage(getAdmissionTranslation('SUBMIT_FORM'), getAdmissionTranslation('MAX_PROGRAMS_ERR_MSG_START') + maxProgramsAllowed + getAdmissionTranslation('MAX_PROGRAMS_MULTIPLE_ERR_MSG_END'));
            		}
            		return false;
            	}else{
            		return true;
            	}
            }
        }else{
        	return true;
        }
    },
    /**
     * @author Pravin.Surve
     * This function is to enable update priority button
     */
    disableMoreActionPivileges: function(gridReference,permissionsMap) {
       	var associatedAcadLocationIds = new Array();
   		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
   		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
   		var applicantProfile = this.getContentPanelActiveTab();
        var grid = applicantProfile.down('#selectedApplicantApplicationProgramGrid');
   		var updateButton = grid.down("#savePriority");//itemId of update button
   		var sendOfferLetterButton = grid.down("#sendOfferLetter");
   		var resendOfferLetterButton = grid.down("#resendOfferLetter");
   		var updateOfferStatusButton = grid.down("#updateOfferStatus");
       	
   		updateButton.setVisible(false);
   		sendOfferLetterButton.setVisible(false);
   		sendOfferLetterButton.setDisabled(true);
   		resendOfferLetterButton.setVisible(false);
   		resendOfferLetterButton.setDisabled(true);
   		updateOfferStatusButton.setVisible(false);
   		updateOfferStatusButton.setDisabled(true);
       	 
       	Ext.each(permissionList, function(privilege) {
       		if (privilege === 'UPDATEPRIORITY') {
           		if(!isNullOrEmpty(updateButton)){
           			updateButton.setVisible(true);//enable more action button
           		}        		
           	}
       		if (privilege === 'SENDOFFERLETTER') {
       			if(!isNullOrEmpty(sendOfferLetterButton)){
       	   			sendOfferLetterButton.setVisible(true);//enable more action button
       	   		}       		
           	}
       		if (privilege === 'RESEND_OFFER_LETTER') {
       			if(!isNullOrEmpty(resendOfferLetterButton)){
       	   			resendOfferLetterButton.setVisible(true);//enable more action button
       	   		}       		
           	}
       		if (privilege === 'UPDATEOFFERSTATUS') {
       			if(!isNullOrEmpty(updateOfferStatusButton)){
       				updateOfferStatusButton.setVisible(true);
       	   		}       		
           	}
       	});
       },
	   showResendLinkPivileges: function(gridReference,permissionsMap) {
	      	var associatedAcadLocationIds = new Array();
	      	associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	   		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	   		if(gridReference.down("#btnResendLink")!=null){
	   			var resendLink = gridReference.down("#btnResendLink");
		   		resendLink.setVisible(false);
	   		}
	       	Ext.each(permissionList, function(privilege) {
	       		if (privilege === 'RESENDLINK') {
	           		if(!isNullOrEmpty(resendLink)){
	           			resendLink.setVisible(true);
	           		}        		
	           	}
	       	});
	       },
	       disableResendLinkButton:function(column,selected) {
	    	var me = this;
            var referenceWindow = me.getContentPanelActiveTab();
	       	var grid = referenceWindow.down('#referenceGrid');
	       	var resentLinkButton = grid.down('#btnResendLink');
	       	resentLinkButton.setDisabled(false);
	       	var counter = 0;
	       	selected.forEach(function(obj){
	       		var admissionstatus=obj.getData().applicationStatus;
	       		if(!isNullOrEmpty(admissionstatus)){
	       			if(admissionstatus == 'SUBMITTED'){
	       				counter = counter+1;
	       			}
	       		}
	       	});
	       		if(counter>0){
	       			resentLinkButton.setDisabled(false);
	       		}else{
	       			resentLinkButton.setDisabled(true);
	       		}
	       },
	       createSendOfferLetterFormJsonData: function(form,actionType) {
		       var $this = this;
		       var applicantProfile = $this.getContentPanelActiveTab();
		       var applicationId;
	           if (applicantProfile) {
	        	   if(!isNullOrEmpty(applicantProfile.getApplicationId())){
	        		   applicationId = applicantProfile.getApplicationId();
	        	   }
	           }
	           var jsonFormFieldData = new Object();
	           var formData = form.getValues();

	           jsonFormFieldData.actionType = actionType;
	           if(jsonFormFieldData.actionType=="Send" && !isNullOrEmpty(formData.offerLetter)) {
	        	   jsonFormFieldData.documentOwnerConfigurationId = formData.offerLetter;
	           }
	           jsonFormFieldData.applicationId = applicationId;
	           if (!isEmpty(formData)) {  
	        	   jsonFormFieldData.applicationProgramId = formData.applicationProgramId;
	        	   var applicationProgramAdmissionDetails = new Object();
	               if(formData.isOfferType=="true") {
	            	   applicationProgramAdmissionDetails.offerType = "FIRM";
	               }
	               if(formData.isOfferType=="false") {
	            	   applicationProgramAdmissionDetails.offerType = "PROVISIONAL";
	               }
	               
	               applicationProgramAdmissionDetails.conditionApplicable = formData.isConditionApplicable;
	               if(formData.isConditionApplicable=="true") {
	            	   
	            	   var applicableConditionInfo = new Array();
	            	   if (!isNullOrEmpty(formData["applicableAdmissionCondition"])) {
	                   	if(!isArray(formData["applicableAdmissionCondition"]))
	                       {
	                       formData["applicableAdmissionCondition"] = [formData["applicableAdmissionCondition"]];
	                       }
	                       var isApplicableConditionArray = isArray(formData["applicableAdmissionCondition"]);
	                       var isAdditionalConditionArray = [];
	                       var isDateOfSatisfactionArray = [];
	                       if(formData["additionlConditions"] != undefined) {
	                       	 if(!isArray(formData["additionlConditions"]))
	                            {
	                            formData["additionlConditions"] = [formData["additionlConditions"]];
	                            }
	                       	isAdditionalConditionArray = isArray(formData["additionlConditions"]);
	                       }
	                       if(formData["dateOfSatisfactionCondition"] != undefined) {
	                      	 if(!isArray(formData["dateOfSatisfactionCondition"]))
	                           {
	                           formData["dateOfSatisfactionCondition"] = [formData["dateOfSatisfactionCondition"]];
	                           }
	                      	isDateOfSatisfactionArray = isArray(formData["dateOfSatisfactionCondition"]);
	                      }
	                       if (isApplicableConditionArray || isAdditionalConditionArray || isDateOfSatisfactionArray) {
	                           for (var i = 0; i < formData["applicableAdmissionCondition"].length; i++) {
	                           	if(!isNullOrEmpty(formData["applicableAdmissionCondition"][i])){
	                           		var obj = new Object();

	                 	               var modes2 = {
	                 						"id": applicantProfile.getPersonId()
	                 						}
	                 	               obj.applicantPerson =  modes2;
	                                   obj.admissionCondition = $this.getIdValueJson(formData["applicableAdmissionCondition"][i]);
	                                   if(formData["additionlConditions"] != undefined){
	                                   	obj.additionalCondition = formData["additionlConditions"][i];
	                                   }
	                                   if(formData["dateOfSatisfactionCondition"] != undefined){
	                                   	obj.conditionSatisfactionDate = formData["dateOfSatisfactionCondition"][i];
	                                   }
	                                   applicableConditionInfo.push(obj);
	                           	}
	                         }
	                       } else {
	                           var obj = new Object();
	                           if(!isNullOrEmpty(formData["applicableAdmissionCondition"])){
	                        	   var modes2 = {
	                 						"id": applicantProfile.getPersonId()
	                        	   }
	                 	           obj.applicantPerson =  modes2;
	                               obj.admissionCondition = $this.getIdValueJson(formData["applicableAdmissionCondition"][i]);
	                               obj.additionalCondition = formData["additionlConditions"];
	                               obj.conditionSatisfactionDate = formData["dateOfSatisfactionCondition"];
	                               applicableConditionInfo.push(obj);
	                           }
	                       }
	                      
	                       jsonFormFieldData.admissionConditionIds = applicableConditionInfo;
	                   }
	            	   
	            	   var documentArray = [];
	            	   if(!isNullOrEmpty(formData.documentApplicable)){
	            		   if(typeof formData.documentApplicable == "object"){
	   	               			Ext.each(formData.documentApplicable, function(currentDocumentId){
	   	               				if(!isNullOrEmpty(currentDocumentId)){
		   	               				var singleDocumentArray = new Object();
		   	               				singleDocumentArray.id = currentDocumentId.data.id;
		   	               				singleDocumentArray.code = currentDocumentId.data.code;
		   	               				singleDocumentArray.value = currentDocumentId.data.value;
		   	               				documentArray.push(singleDocumentArray);
	   	               				}
	   	               			});
	   	           			}
	   	           			else{
	   	           				if(!isNullOrEmpty(formData.documentApplicable)){
	   	           					documentArray.push(formData.documentApplicable);
	   	           				}
	   	           			}
	   	           	   }
	            	   jsonFormFieldData.applicableDocuemntIds = documentArray;
	   	           		
	   	           }
	               applicationProgramAdmissionDetails.escalationRequired = formData.isEscalationRequired;
	               if(formData.isEscalationRequired=="true") {
	            	   applicationProgramAdmissionDetails.escalationComments = formData.escalationComments;
	            	   var users = new Object();
	            	   users.id = formData.assignedTo;
	            	   applicationProgramAdmissionDetails.users = users;
	               }
	               else {
	            	   jsonFormFieldData.offerValidDate = formData.offerValidUntil;
	               }
	           		
	               jsonFormFieldData.applicationProgramAdmissionDetails = applicationProgramAdmissionDetails;
	               
	           }
	           if(isNullOrEmpty(jsonFormFieldData.applicationProgramAdmissionDetails.users) || isNullOrEmpty(jsonFormFieldData.applicationProgramAdmissionDetails.users.id)){
	        	   delete jsonFormFieldData.applicationProgramAdmissionDetails.users;
	           }
	            
	           return jsonFormFieldData;
	       },
	       setSendOfferLetterFormValues: function(form,record) {
	    	   	   var $this = this;
	    		   var offerType = form.down('#offerType');
	    		   var conditionApplicable = form.down('#conditionApplicable');
	    		   var applicableAdmissionCondition = form.down('#applicableAdmissionCondition');
	    		   var documentApplicable = form.down('#documentApplicable');
	    		   var escalationRequired = form.down('#escalationRequired');
	    		   var assignedTo = form.down('#assignedTo');
	    		   var escalationComments = form.down('#escalationComments');
	    		   var offerTypeStatus = false;
	    		   
	    		   if(record.offerType == "FIRM"){
	    			   offerType.setValue({isOfferType: "true"});
	    			   offerTypeStatus = true;
	    		   }
	    		   if(record.offerType == "PROVISIONAL"){
	    			   offerType.setValue({isOfferType: "false"});
	    			   offerTypeStatus = false;
	    		   }
	    		   
	    		   if(typeof record.conditionApplicable == "boolean"){
	    			   if(record.conditionApplicable) {
	    				   conditionApplicable.setValue({isConditionApplicable: "true"});
	    				   
	    				   
	    				   applicableAdmissionCondition.getStore().proxy.extraParams = {
	    					   offerType:offerTypeStatus 
	                    };
	    				   
	    				if(!isNullOrEmpty(record.admissionConditionDetail) && record.admissionConditionDetail.length>0){
	    					var data = [];
	    					for (var i = 0; i < record.admissionConditionDetail.length; i++) {
	    						if(!isNullOrEmpty(record.admissionConditionDetail[i].admissionCondition) && !isNullOrEmpty(record.admissionConditionDetail[i].admissionCondition.id)) {
	    							data.push(record.admissionConditionDetail[i]);
	    						}
	    					}
	    					applicableAdmissionCondition.getStore().load();
	    					if(!isNullOrEmpty(data) && data.length>0){
		    					for (var i = 0; i < data.length; i++) {
		    						var applicableAdmissionPanel = form.down('#applicableAdmissionPanelId');
		    						var formContainer = applicableAdmissionPanel.getComponent(i);
		    						formContainer.down('#applicableAdmissionCondition').setValue(data[i].admissionCondition.id);
		    						if(!isNullOrEmpty(data[i].additionalCondition)) {
		    							formContainer.down('#additionlConditions').setValue(data[i].additionalCondition);
		    						}
		    						if(!isNullOrEmpty(data[i].conditionSatisfactionDate)) {
		    							formContainer.down('#dateOfSatisfactionCondition').setValue(dateRender(data[i].conditionSatisfactionDate));
		    						}
		    						if (i < (data.length - 1)) {
		    							$this.addMultipleCondition(form);
		    						}
		    					}
	    					}
	    				}
	    				   
	    				   if(!isNullOrEmpty(record.admissionConditionDetail) && record.admissionConditionDetail.length>0){
	    					   documentApplicable.getStore().proxy.extraParams = {
	    						   isApplicableForStudent:true 
	    					   };
	    					   documentApplicable.getStore().load({
                   				callback: function(records, operation, success) {
                   					if (success) {
                   						var documentArray = [];
                   						if(records.length > 0){
                   							record.admissionConditionDetail.forEach(function(documentObj){
                   								if(!isNullOrEmpty(documentObj.documentType)) {
                   								var result = records.filter(function (obj) {
                   									  return obj.data.id === documentObj.documentType.id;
                   									})[0];
                   								documentArray.push(result);
                   								}
                   							});
                   							documentApplicable.setValue(documentArray);
                   						}
                   					}
                   				}
                   	        });
           				}	
	    				   
	    			   }
	    			   else {
	    				   conditionApplicable.setValue({isConditionApplicable: "false"});
	    			   }
	    		   }
	    		   if(typeof record.escalationRequired == "boolean"){
	    			   if(record.escalationRequired) {
	    				   escalationRequired.setValue({isEscalationRequired: "true"});
	    				   if(!isNullOrEmpty(record.users)) {
	    					   assignedTo.getStore().proxy.extraParams = {
		    					   qry:'' 
	   	                    	};
	    					   assignedTo.getStore().load({
	                   				callback: function(records, operation, success) {
	                   					if (success) {
	                   						for(var i in records) {
	    	                    				if(records[i].data.id == record.users.id) {
	    	                    					assignedTo.setValue(records[i].data.id);
	    	                    					break;
	    	                    				}
	    	                    			}
	                   					}
	                   				}
	                   	        });
	    				   }
	    			   }
	    			   else {
	    				   escalationRequired.setValue({isEscalationRequired: "false"});
	    			   }
	    		   }
	       },
	       updateOfferStatusSave:function(obj){
	    	   var me = this;
               var applicantProfile = me.getContentPanelActiveTab();
               var searchResultGrid = me.getSearchResultGrid();
               var form = obj.up('form');
               if (applicantProfile) {
               	var selectedApplicationProgramGrid = applicantProfile.down('#selectedApplicantApplicationProgramGrid');
               	var snapShotGrid = applicantProfile.down('#selectionSnapShotGrid');
               	var updateOfferStatusButton = selectedApplicationProgramGrid.down("#updateOfferStatus");
               	var sendOfferLetterButton = selectedApplicationProgramGrid.down("#sendOfferLetter");
                   
                   record = selectedApplicationProgramGrid.getSelectionModel().getSelection()[0];
                   
               	if(!isNullOrEmpty(record.get('id'))){
               		var jsonData = new Object();
       	        	jsonData.id = record.get('id');
       	        	jsonData.currentStatus = form.down('#offerStatus').getValue();
                       
               		submitUrl = SERVERURL.PATH_UPDATE_OFFER_STATUS_BY_APPLICATION_PROGRAM_ID;
       	     		Ext.Ajax.request({
       	     			type : 'rest',
       	     			url : submitUrl,
       	     			jsonData : jsonData,
       	     			method : 'POST',
       	     			success : function(form, action) {
       	     				showSuccessMessage(getAdmissionTranslation('UPDATE_OFFER_STATUS'),getAdmissionTranslation('OFFER_STATUS_UPDATED_SUCCESSFULLY'));
       	     				obj.up('window').close();
       	     				selectedApplicationProgramGrid.getStore().reload();
       	     				if(!isNullOrEmpty(snapShotGrid)){
           	    				snapShotGrid.getStore().load({
   				                    params: {
   				                    	applicationID: applicantProfile.getApplicationId(),
   				                    	portalId:me.getCurrentLoggedPortalId()
   				                    }
                  	    	 		});
           	    				searchResultGrid.getStore().reload();
           	    			}
       	     			}
       	     		});
	       	     	selectedApplicationProgramGrid.getSelectionModel().deselectAll();
	       	     	updateOfferStatusButton.setDisabled(true);
	       	     	sendOfferLetterButton.setDisabled(true);
               	}
               }
	        },
	        setResendOfferLetterFormValues: function(form,record) {
	        	   var $this = this;
	    		   var offerType = form.down('#offerType');
	    		   var conditionApplicable = form.down('#conditionApplicable');
	    		   var applicableAdmissionCondition = form.down('#applicableAdmissionCondition');
	    		   var documentApplicable = form.down('#documentApplicable');
	    		   var escalationRequired = form.down('#escalationRequired');
	    		   var assignedTo = form.down('#assignedTo');
	    		   var escalationComments = form.down('#escalationComments');
	    		   var offerTypeStatus = false;
	    		   var programBatchSeatConfigId = form.down('#programBatchSeatConfigId');
 
	    			var offerLetterField = form.down('#offerLetter');
            		offerLetterField.getStore().proxy.extraParams = {
        				ownerId: programBatchSeatConfigId.getValue(),
   				 	};
           	
            		offerLetterField.getStore().load({
                        scope:this,
                        callback: function(records,option,success){
                        	if (success && !isNullOrEmpty(record.documentOwnerConfigurationId)) {
                                for(i in records){
                                    if(records[i].data.id==record.documentOwnerConfigurationId){
                                    	offerLetterField.setValue(records[i].data.id);                                        
                                    }
                                }
                            }
                        }
            		
            		});
            		if(record.expiryDate != undefined && !isNullOrEmpty(record.expiryDate)){
            			form.down('#offerValidUntil').setValue(dateRender(record.expiryDate));
            		}
            		
            		
            		offerLetterField.getStore().load();
	    		   
	    		   if(record.offerType == "FIRM"){
	    			   offerType.setValue({isOfferType: "true"});
	    			   offerTypeStatus = true;
	    		   }
	    		   if(record.offerType == "PROVISIONAL"){
	    			   offerType.setValue({isOfferType: "false"});
	    			   offerTypeStatus = false;
	    		   }
	    		   
	    		   if(typeof record.conditionApplicable == "boolean"){
	    			   if(record.conditionApplicable) {
	    				   conditionApplicable.setValue({isConditionApplicable: "true"});
	    				   
	    				   
	    				   applicableAdmissionCondition.getStore().proxy.extraParams = {
	    					   offerType:offerTypeStatus 
	                    };
	    				   if(!isNullOrEmpty(record.admissionConditionDetail) && record.admissionConditionDetail.length>0){
		    					var data = [];
		    					for (var i = 0; i < record.admissionConditionDetail.length; i++) {
		    						if(!isNullOrEmpty(record.admissionConditionDetail[i].admissionCondition) && !isNullOrEmpty(record.admissionConditionDetail[i].admissionCondition.id)) {
		    							data.push(record.admissionConditionDetail[i]);
		    						}
		    					}
		    					applicableAdmissionCondition.getStore().load();
		    					if(!isNullOrEmpty(data) && data.length>0){
			    					for (var i = 0; i < data.length; i++) {
			    						var applicableAdmissionPanel = form.down('#applicableAdmissionPanelId');
			    						var formContainer = applicableAdmissionPanel.getComponent(i);
			    						formContainer.down('#applicableAdmissionCondition').setValue(data[i].admissionCondition.id);
			    						if(!isNullOrEmpty(data[i].additionalCondition)) {
			    							formContainer.down('#additionlConditions').setValue(data[i].additionalCondition);
			    						}
			    						if(!isNullOrEmpty(data[i].conditionSatisfactionDate)) {
			    							formContainer.down('#dateOfSatisfactionCondition').setValue(dateRender(data[i].conditionSatisfactionDate));
			    						}
			    						if (i < (data.length - 1)) {
			    							$this.addMultipleCondition(form);
			    						}
			    					}
		    					}
		    				}
        				
	    				   
	    				   if(!isNullOrEmpty(record.admissionConditionDetail) && record.admissionConditionDetail.length>0){
	    					   documentApplicable.getStore().proxy.extraParams = {
	    						   isApplicableForStudent:true 
	    					   };
	    					   documentApplicable.getStore().load({
                				callback: function(records, operation, success) {
                					if (success) {
                						var documentArray = [];
                						if(records.length > 0){
                							record.admissionConditionDetail.forEach(function(documentObj){
                								if(!isNullOrEmpty(documentObj.documentType)) {
                								var result = records.filter(function (obj) {
                									  return obj.data.id === documentObj.documentType.id;
                									})[0];
                								documentArray.push(result);
                								}
                							});
                							documentApplicable.setValue(documentArray);
                						}
                					}
                				}
                	        });
        				}	
	    				   
	    			   }
	    			   else {
	    				   conditionApplicable.setValue({isConditionApplicable: "false"});
	    			   }
	    		   }
	    		   if(typeof record.escalationRequired == "boolean"){
	    			   if(record.escalationRequired) {
	    				   escalationRequired.setValue({isEscalationRequired: "true"});
	    				   if(!isNullOrEmpty(record.users)) {
	    					   assignedTo.getStore().proxy.extraParams = {
		    					   qry:'' 
	   	                    	};
	    					   assignedTo.getStore().load({
	                   				callback: function(records, operation, success) {
	                   					if (success) {
	                   						for(var i in records) {
	    	                    				if(records[i].data.id == record.users.id) {
	    	                    					assignedTo.setValue(records[i].data.id);
	    	                    					break;
	    	                    				}
	    	                    			}
	                   					}
	                   				}
	                   	        });
	    				   }
	    			   }
	    			   else {
	    				   escalationRequired.setValue({isEscalationRequired: "false"});
	    			   }
	    		   }
	    
	       },
	       addMultipleCondition:function(form){
	    	   
	    	   var $this = this;
		   	   
		   	   var stopContiner = form.down('#applicableAdmissionPanelId');
		   	   var formFieldContainer = stopContiner.items.items[0];
		   	   var isConditionAllowBlank = formFieldContainer.down('#applicableAdmissionCondition').allowBlank;
		   	   var isConditionHidden = formFieldContainer.down('#applicableAdmissionCondition').hidden;
		   	   var conditionFieldLabel = formFieldContainer.down('#applicableAdmissionCondition').fieldLabel;
		   	   if(!conditionFieldLabel.includes(":")) {
		   		   conditionFieldLabel = conditionFieldLabel+':';
		   	   }
		   	   if(!isConditionAllowBlank && !conditionFieldLabel.includes("*")) {
		   		   conditionFieldLabel = conditionFieldLabel+'<span class="required" style="color:red"> *</span>';
		   	   }
		   	   
		   	   var isAddConditionAllowBlank = formFieldContainer.down('#additionlConditions').allowBlank;
		   	   var isAddConditionHidden = formFieldContainer.down('#additionlConditions').hidden;
		   	   var addconditionFieldLabel = formFieldContainer.down('#additionlConditions').fieldLabel;
		   	   if(!addconditionFieldLabel.includes(":")) {
		   		   addconditionFieldLabel = addconditionFieldLabel+':';
		   	   }
		   	   if(!isAddConditionAllowBlank && !addconditionFieldLabel.includes("*")) {
		   		   addconditionFieldLabel = addconditionFieldLabel+'<span class="required" style="color:red"> *</span>';
		   	   }
		   	   
		   	   var isDateOfSatisfactionAllowBlank = formFieldContainer.down('#dateOfSatisfactionCondition').allowBlank;
		   	   var isDateOfSatisfactionHidden = formFieldContainer.down('#dateOfSatisfactionCondition').hidden;
		   	   var dateOfSatisfactionFieldLabel = formFieldContainer.down('#dateOfSatisfactionCondition').fieldLabel;
		   	   if(!dateOfSatisfactionFieldLabel.includes(":")) {
		   		   dateOfSatisfactionFieldLabel = dateOfSatisfactionFieldLabel+':';
		   	   }
		   	   if(!isDateOfSatisfactionAllowBlank && !dateOfSatisfactionFieldLabel.includes("*")) {
		   		   dateOfSatisfactionFieldLabel = dateOfSatisfactionFieldLabel+'<span class="required" style="color:red"> *</span>';
		   	   }
		   	   
		   	   var indx = stopContiner.items.length;
		   	   var panelItem = new Array();
			   var insertPosition=indx;
			    panelItem.push({
			   		   xtype:'fieldcontainer',
			   		   width: '100%',
			   		   layout : 'hbox',
			   		   defaults : {
			   			   labelAlign : 'top'
			   		   },
			   		   items : [{
			   			   xtype: 'customcombobox',
			   			   name: 'applicableAdmissionCondition',
			   			   itemId: 'applicableAdmissionCondition',
			   			   allowBlank: isConditionAllowBlank,
			   			   hidden: isConditionHidden,
			   			   fieldLabel: conditionFieldLabel,
			   			   store: 'admission.applicationFormSale.AdmissionConditionByOfferTypeStore',
			   			   displayField: 'value',
			   			   valueField: 'id',
			   			   forceSelection:true,
			   			   queryParam:'qry',
			   			   editable:false,
			   			   width: 300,
			   			   labelSeparator : '',
			   			   listeners:{
			   				   beforeshow: function(picker) {
			   					   picker.minWidth = picker.up('combobox').getSize().width;
			   				   }
			   			   }
						},{
							xtype: 'textarea',
			     			name: 'additionlConditions',
			     			itemId: 'additionlConditions',
			     			fieldLabel: addconditionFieldLabel,
			     			editable:false,
			     			readOnly: true,
			     			maxLength:2000,
			     			width: 300,
			     			allowBlank: isAddConditionAllowBlank,
				   			hidden: isAddConditionHidden,
				   			labelSeparator : '',
				   			listeners: {
	                            change:function(obj,value){
	                            	obj.getEl().dom.setAttribute('data-qtip',value);
	                            	obj.getEl().dom.style.textAlign = 'left';
	                            	obj.getEl().dom.style.overflow = 'hidden'; 
	                            	return '<tpl if="xindex%2==0"><div class="oddColorCombo" style="width:404px"></tpl><tpl if="xindex%2==1"><div class="evenColorCombo" style="width:404px"></tpl> {' + value + '} </div>';
	                           }
	                        }
						},{
			        		xtype: 'datefield',
			        		fieldLabel: dateOfSatisfactionFieldLabel,
			        		name: 'dateOfSatisfactionCondition',
			        		itemId: 'dateOfSatisfactionCondition',
			        		vtype: 'daterange',
			        		width: 260,
			        		labelSeparator : '',
			        		listeners: {
			        			render: function(field) {
			        				return dateFormatRender(field);
			        			}
			        		},
			        		minValue: new Date(),
			        		allowBlank: isDateOfSatisfactionAllowBlank,
				   			hidden: isDateOfSatisfactionHidden
				   	   },{
			   			   xtype: 'button',
			   			   glyph: ICONGLYPH.DELETEGLYPH,
			   			   cls: 'CustomBodyBtnReject',
			   			   tooltip: getCommonTranslation('DELETETOOLTIP'),
			   			   width:30,
			   			   style:{
			   				   marginTop:'30px'
			   			   },
			   			   listeners:{
			   				   click:function(obj){
			   					   var container = obj.up('fieldcontainer');
			   					   var panelContiner = form.down('#applicableAdmissionPanelId');
			   					   panelContiner.remove(container);
			   					   form.getForm().checkValidity();
			   					   form.getForm().isValid();
			   					   form.getForm().clearInvalid();
			   				   }
			   			   }
			   		   }]
			   	   });
			   
			    
		     	stopContiner.insert(insertPosition,panelItem);
		     	stopContiner.doLayout();
		      },
		      loadDFRForEscalationRequired: function(escalationRequired){
		      	var $this = this;
		      	var form = $this.getSendOfferLetterForm();
			   	var assignedTo = form.down('#assignedTo');
		      	Ext.Ajax.request({
		      		type: 'rest',
		      		async: false,
		      		url: SERVERURL.COMMON_FORM_FIELD_INFO,
		      		params: {
		      			screenName: 'sendofferletterform',
		      			academyLocationId: this.getCurrentAcademyLocation(),
		      			languageCode:'en'
		      		},
		      		method: 'GET',
		      		success: function(res, action) {
		      			var response = Ext.decode(res.responseText);
		      			if( Object.keys(response).length > 0 ){
		      				var records=response.sendofferletterform;
		      				for(i in records){
		        					  if(records[i].formFieldInputType=='radiogroup' && records[i].formFieldId=='escalationRequired' && records[i].isMandatory==true){
		        						  escalationRequired.allowBlank = false;
		        					  }
		        					  if(records[i].formFieldInputType=='radiogroup' && records[i].formFieldId=='escalationRequired' && records[i].isVisible==true){
		        						  escalationRequired.setVisible(true);
		        						  if(escalationRequired){
		        							  assignedTo.setVisible(true);
		        						  }else{
		        							  assignedTo.setVisible(false);
		        						  }
		        						   break;
		        					  }else{
		        						  escalationRequired.setVisible(false);
		        						  escalationRequired.allowBlank = true;
		        						  assignedTo.setVisible(false);
		        						  assignedTo.allowBlank = true;
		        					  }
		      				}
		      			}else{
		      				escalationRequired.setVisible(true);
		      			}
		      		}
		      		
		      	});   	
		      }
});
