/*
 * @author Rohit Sharma
 */
Ext.define('Academia.controller.admission.applications.pandadoc.PandaDocController', {
	extend: 'Academia.controller.base.BaseController',
	alias: "widget.pandadoccontroller",
	mixins: {

	},

	stores: ['admission.applications.pandadoc.PandaDocTemplateStore', 'admission.applications.pandadoc.PandaDocGridStore','admission.applications.pandadoc.PandaDiscountAppliedStore'],

	views: ['admission.applications.applicationBase.PandaDocPopup','admission.applications.applicationBase.SsoConfigurationStructure','admission.applications.applicationBase.SsoConfigurationForm'],

	refs: [{
		ref: 'pandadocpopup',
		selector: 'pandadocpopup'
	}, {
		ref: 'searchResultGrid',
		selector: 'searchresultgrid[itemId=applicationsListGrid]'
	}, {
		ref: 'pandadocgrid',
		selector: 'pandadocpopup grid[itemId=pandadocGrid]'
	},{
		ref:'ssoConfigurationStructure',
		selector:'ssoConfigurationStructure'
	},{
		ref:'ssoConfigurationForm',
		selector:'ssoConfigurationForm'
	}],
	config: {},
	init: function(application) {
		this.control({
			'pandadocpopup grid[itemId=pandadocGrid]': {
				render: function(grid) {
					var me = this,
					activeTabPanel = me.getActiveTabfromContentPanel(),
					activeGridView = activeTabPanel.down('grid');
					grid.getHeader().add({
						xtype: 'button',
						text: getCommonTranslation('REFRESH'), 
						ui: 'CustomBtnSubmit',
						itemId: 'refresh',
						scale: CONSTANTS.BUTTONSIZE
					});
					var selection = activeGridView.getSelectionModel().getSelection();
					grid.getStore().removeAll();
					if(activeTabPanel.xtype == 'studentlistview'){
						grid.getStore().getProxy().extraParams = {
							studentId: selection[0].data.ID
						};
					}else{
						grid.getStore().getProxy().extraParams = {
							applicationId: selection[0].data.ID
						};
					}
					
					grid.getStore().load();
				},
				cellclick: function(gridview, td, cellIndex, record, tr, rowIndex, e, eOpts) {
					var me = this,
					activeTabPanel = me.getActiveTabfromContentPanel(),
					activeGridView = activeTabPanel.down('grid');
					var dataIndex = gridview.getHeaderCt().getHeaderAtIndex(cellIndex).dataIndex;
					if(dataIndex == 'delete' && e.target.offsetParent.className == 'x-btn-button') {
						Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						Ext.Ajax.request({
							type : 'rest',
							url : SERVERURL.PATH_DELETE_PANDA_DOC_DOCUMENT + '?documentId=' + record.get('documentId') + '&id=' + record.get('id'),
							/*jsonData : {
								documentId: record.get('documentId'),
								id: record.get('id')
							},*/
							method : 'DELETE',
							success : function(frm, action) {
								Ext.getBody().unmask();
								var selection = activeGridView.getSelectionModel().getSelection();
								if(activeTabPanel.xtype == 'studentlistview'){
									gridview.up('grid').getStore().getProxy().extraParams = {
										studentId: selection[0].data.ID
									};
								}else{
									gridview.up('grid').getStore().getProxy().extraParams = {
										applicationId: selection[0].data.ID
									};
								}
								gridview.up('grid').getStore().load();
							}
						});
					}
					if(dataIndex == 'send' && e.target.offsetParent.className == 'x-btn-button') {
						var me = this;
						Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						Ext.Ajax.request({
							type : 'rest',
							url : SERVERURL.PATH_SEND_PANDA_DOCUMENT_TO_USER,
							jsonData : {
								createdDocId: record.get('id'),
								documentId: record.get('documentId'),
								content: record.get('documentName')
							},
							method : 'POST',
							success : function(frm, action) {
								Ext.getBody().unmask();
								var selection = activeGridView.getSelectionModel().getSelection();
								if(activeTabPanel.xtype == 'studentlistview'){
									gridview.up('grid').getStore().getProxy().extraParams = {
										studentId: selection[0].data.ID
									};
								}else{
									gridview.up('grid').getStore().getProxy().extraParams = {
										applicationId: selection[0].data.ID
									};
								}
								gridview.up('grid').getStore().load();
							}
						});
					}
					if(dataIndex == 'documentName' && e.target.tagName == 'A') {
						var me = this;
						var documentId = record.get('documentId');
						/*Ext.Ajax.request({
							type : 'rest',
							url : SERVERURL.PATH_DOWNLOAD_PANDADOC_DOCUMENT,
							jsonData : {
								createdDocId: record.get('id'),
								documentId: record.get('documentId')
							},
							method : 'POST',
							success : function(frm, action) {
								Ext.getBody().unmask();
								var selection = me.getSearchResultGrid().getSelectionModel().getSelection();
								gridview.up('grid').getStore().getProxy().extraParams = {
									applicationId: selection[0].data.ID
								};
								gridview.up('grid').getStore().load();
							}
						});*/
						if(!isNullOrEmpty(documentId)){
							var reportParams =new Object();
							reportParams.DOCUMENT_ID = documentId;
							reportParams.DOCUMENT_NAME = record.get('documentName');
							me.exportJRXMLReport(null,reportParams,null,'.pdf',SERVERURL.PATH_DOWNLOAD_PANDADOC_DOCUMENT);
						}
					}
				}
			},
			'pandadocpopup button[itemId=sendNowBtn]': {
				click: function(btn) {
					var me = this,
					activeTabPanel = me.getActiveTabfromContentPanel(),
					activeGridView = activeTabPanel.down('grid');
					var vals = btn.up('form').getValues();
					var selection = activeGridView.getSelectionModel().getSelection();
					var grid = this.getPandadocgrid();
					if(selection && selection.length) {
						Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						var param = {
								applicationId: selection[0].data.ID,
								templateUuid: vals.templateId,
								studentFullName: selection[0].data.FULL_NAME,
								recipientEmail: selection[0].data.EMAIL,
								recipientFirstName: selection[0].data.FIRST_NAME,
								recipientLastName: selection[0].data.LAST_NAME,
								templateName: btn.up('form').down('#templateId').lastSelection[0].data.name,
								studentName: selection[0].data.APPLICATION_PERSON_PRINTNAME,
								applicationCode: selection[0].data.APPLICATION_ID,
								discount:vals.discount,
								cf1:vals.cf1,
								cf2:vals.cf2,
								discountValidationStartDuration:vals.discountValidationStartDuration,
								discountValidationEndDuration:vals.discountValidationEndDuration,
								tutionPayment:vals.tutionPayment,
								firstName:selection[0].data.FIRST_NAME,
								lastName: selection[0].data.LAST_NAME,
								programmeOfStudy: selection[0].data.PROGRAM_NAME, 
							    programBatch: selection[0].data.BATCH, 
							     batchId:selection[0].data.BATCH_ID
							};
						if(activeTabPanel.xtype == 'studentlistview'){
							delete param.applicationId;
							delete param.applicationCode;
							param.stuId=selection[0].data.ID;
							param.studentId=selection[0].data.STUDENT_ID;
							param.recipientEmail=selection[0].data.EMAIL_ID;
							param.studentName=selection[0].data.STUDENT_NAME;
							param.studentFullName=selection[0].data.STUDENT_NAME;
							param.firstName=selection[0].data.FIRST_NAME;
							param.lastName= selection[0].data.LAST_NAME;
							param.admissionCode= selection[0].data.ADMISSION_NUMBER;
							param.entryYear= selection[0].data.INTAKE_YEAR;
							param.programBatch= selection[0].data.BATCH_NAME;
							   
						}
						Ext.Ajax.request({
							type : 'rest',
							url : SERVERURL.PATH_CREATE_AND_SEND_PANDA_DOCUMENT_TO_USER,
							jsonData : param,
							method : 'POST',
							success : function(frm, action) {
								Ext.getBody().unmask();
								var selection = activeGridView.getSelectionModel().getSelection();
								if(activeTabPanel.xtype == 'studentlistview'){
									grid.getStore().getProxy().extraParams = {
										studentId: selection[0].data.ID
									};
								}else{
									grid.getStore().getProxy().extraParams = {
										applicationId: selection[0].data.ID
									};
								}
								grid.getStore().load();
							}
						});
					}
				}
			},
			'pandadocpopup button[itemId=sendLaterBtn]': {
				click: function(btn) {
					var me = this,
					activeTabPanel = me.getActiveTabfromContentPanel(),
					activeGridView = activeTabPanel.down('grid');
					var vals = btn.up('form').getValues();
					var selection = activeGridView.getSelectionModel().getSelection();
					var grid = this.getPandadocgrid();
					if(selection && selection.length) {
						Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						var param = {
								applicationId: selection[0].data.ID,
								templateUuid: vals.templateId,
								studentFullName: selection[0].data.FULL_NAME,
								recipientEmail: selection[0].data.EMAIL,
								recipientFirstName: selection[0].data.FIRST_NAME,
								recipientLastName: selection[0].data.LAST_NAME,
								templateName: btn.up('form').down('#templateId').lastSelection[0].data.name,
								studentName: selection[0].data.APPLICATION_PERSON_PRINTNAME,
								applicationCode: selection[0].data.APPLICATION_ID,
								discount:vals.discount,
								cf1:vals.cf1,
								cf2:vals.cf2,
								discountValidationStartDuration:vals.discountValidationStartDuration,
								discountValidationEndDuration:vals.discountValidationEndDuration,
								tutionPayment:vals.tutionPayment,
								firstName:selection[0].data.FIRST_NAME,
								lastName: selection[0].data.LAST_NAME,
								programmeOfStudy: selection[0].data.PROGRAM_NAME, 
							    programBatch: selection[0].data.BATCH, 
							     batchId:selection[0].data.BATCH_ID

							};
						if(activeTabPanel.xtype == 'studentlistview'){
							delete param.applicationId;
							delete param.applicationCode;
							param.stuId=selection[0].data.ID;
							param.studentId=selection[0].data.STUDENT_ID;
							param.recipientEmail=selection[0].data.EMAIL_ID;
							param.studentName=selection[0].data.STUDENT_NAME;
							param.studentFullName=selection[0].data.STUDENT_NAME;
							param.firstName=selection[0].data.FIRST_NAME;
							param.lastName= selection[0].data.LAST_NAME;
							param.admissionCode= selection[0].data.ADMISSION_NUMBER;
							param.entryYear= selection[0].data.INTAKE_YEAR;
							param.programBatch= selection[0].data.BATCH_NAME;
						}
						Ext.Ajax.request({
							type : 'rest',
							url : SERVERURL.PATH_CREATE_PANDA_DOCUMENT_USING_TEMPLATE,
							jsonData :param ,
							
							method : 'POST',
							success : function(frm, action) {
								Ext.getBody().unmask();
								var selection = activeGridView.getSelectionModel().getSelection();
								if(activeTabPanel.xtype == 'studentlistview'){
									grid.getStore().getProxy().extraParams = {
										studentId: selection[0].data.ID
									};
								}else{
									grid.getStore().getProxy().extraParams = {
										applicationId: selection[0].data.ID
									};
								}
								grid.getStore().load();
							}
						});
					}
				}
			},
			'pandadocpopup grid[itemId=pandadocGrid] button[itemId=refresh]': {
				click: function(btn) {
					var grid = this.getPandadocgrid();
					//var sm = grid.getSelectionModel();
					//var records = sm.getSelection();
					var uuids = [];
					for(var i = 0; i < grid.getStore().getCount(); i++) {
						var data = {
						documentId: grid.getStore().getAt(i).data.documentId
						};
						uuids.push(data);
					}
					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					Ext.Ajax.request({
						type : 'rest',
						url : SERVERURL.PATH_SYNC_DOCUMENT_STATUS,
						jsonData : uuids,
						method : 'POST',
						success : function(frm, action) {
							Ext.getBody().unmask();
							grid.getStore().reload();
						}
					});
				}
			},
			'ssoConfigurationStructure':{
				afterrender:function(cmp){
					var me = this,sosRec=[],
					form = me.getSsoConfigurationStructure(),
					ssoConfigurationContainer = form.down('#ssoConfigurationContainer');
					Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
					Ext.Ajax.request({
						type : 'rest',
						url : SERVERURL.PATH_GET_SOCIAL_LOGIN_DETAILS,
						method : 'GET',
						success : function(frm, action) {
							Ext.getBody().unmask();
							if(frm.responseText){
								var data = Ext.decode(frm.responseText);
								data.forEach(function(rec){
									sosRec.push({
										boxLabel : rec.socialLogin,
										itemId:rec.socialLogin,
										name:'socialLogin',
										inputValue : rec.socialLogin,
										checked : rec.whetherPrimaryEmailSave
									});
								});
								ssoConfigurationContainer.ssoData=data;
								ssoConfigurationContainer.add({
									xtype : 'radiogroup',
									itemId:'ssoLoginId',
									labelAlign : 'top',
									allowBlank: false,
									labelSeparator:' ',
									fieldLabel:getCommonTranslation('PLEASE_SELECT_SINGLE_SIGN_ON_SSO_PROVIDER'),
									items:sosRec
								})
								
							}
						}
					});
				}
			},
			'ssoConfigurationForm button[itemId=cancelButtonSSO]':{
				click:function(btn){ 
					 this.getActiveTabfromContentPanel().close();
				}
			},
			'ssoConfigurationForm button[itemId=submitButtonSSO]':{
				click:this.saveSSODetails
			}
			
		});
	},
	saveSSODetails:function(btn){
		btn.setDisabled(true);
		var me = this,
		form = me.getSsoConfigurationForm(),
		ssoConfigurationContainer = form.down('#ssoConfigurationContainer'),
		formVal =form.getValues(),
		ssoData = ssoConfigurationContainer.ssoData;
		ssoData.forEach(function(rec){
		 if(formVal.socialLogin == rec.socialLogin){
			 rec.whetherPrimaryEmailSave = true;
		 }else{
			 rec.whetherPrimaryEmailSave = false;
		 }
		});
		var postData= Ext.encode(ssoData);
		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		Ext.Ajax.request({
			type : 'rest',
			url : SERVERURL.PATH_SOCIAL_LOGIN_UPDATE,
			jsonData : postData,
			method : 'POST',
			success : function(frm, action) {
				Ext.getBody().unmask();
				showSuccessMessage(getMegaMenuTranslation('SSO_CONFIGURATION'), getCommonTranslation('SUCCESS'));
				me.getActiveTabfromContentPanel().close();
			}
		});
	}
}); 
