/**
 * This controller is used for replacement module
 * @author Pravin.Surve
 */
Ext.define('Academia.controller.admission.replacement.ReplacementController', {
	extend: 'Academia.controller.base.BaseController',
	
	views: ['Academia.view.admission.replacement.ReplacementTabPanelView','Academia.view.admission.replacement.ReplaceStudentSearchView',
	        'Academia.view.admission.replacement.ReplaceStudentSearchForm','Academia.view.admission.replacement.StudentToBeReplaceGrid',
	        'Academia.view.admission.replacement.SelectReplacementGrid','Academia.view.admission.replacement.ReplaceStudentButtonPanel',
	        'Academia.view.admission.selectionStage.StageStatasticsGrid','Academia.view.admission.replacement.CloseReplacementSearchForm',
	        'Academia.view.admission.replacement.CloseReplacementSearchView','Academia.view.admission.replacement.CloseReplacementGrid',
	        'Academia.view.admission.replacement.ApproveReplacementGrid','Academia.view.admission.replacement.ApproveReplacementView',
	        'Academia.view.admission.replacement.ApproveReplacementButtonPanel','Academia.view.admission.replacement.ApproveReplacementDetailsView',
	        'Academia.view.admission.replacement.ReplacementDetailTemplate','Academia.view.common.AcadLocProgBatchSeattypeComponent',
	        'Academia.view.admission.replacement.ViewReplacementListGrid','Academia.view.admission.replacement.ReplacementListWindow',
	        'Academia.view.admission.replacement.SendForApprovalButtonPanel','Academia.store.admission.replacement.ReplacementWaitingListStore',
	        'Academia.view.admission.replacement.ClosedReplacementSearchView','Academia.view.admission.replacement.StartReplacementGrid'],
	
	stores: ['Academia.store.common.AcademyStore','Academia.store.common.AcademyByUserStore',
	         'Academia.store.common.LocationStore','Academia.store.common.LocationByUserStore',
	         'Academia.store.common.ProgramsByAcademyIdLocationId','Academia.store.common.BatchesByProgramId',
	         'Academia.store.common.SeatTypesByBatchId','Academia.store.admission.selectionProcess.QuotaTypes',
	         'Academia.store.admission.quotas.QuotaLists','Academia.store.admission.selectionStage.SelectionStageFromSeatType',
	         'Academia.store.admission.selectionStage.StageStatistics','Academia.store.admission.replacement.StudentToBeReplaceStore',
	         'Academia.store.admission.replacement.CandidateByReplacedStore',
	         'Academia.store.admission.replacement.ApproveReplacementListStore',
	         'Academia.store.admission.replacement.ViewReplacementListStore','admission.selectionProcess.QuotaTypesByProgramBatchSeatConfigId',
	         'Academia.store.admission.replacement.CloseReplacementStore',
	         'Academia.store.admission.admissionCycle.QuotaTypePickList'],
	
	refs: [{
		ref: 'contentPanel',
		selector: 'contentpanel'
	},{
		ref: 'replaceStudentSearchForm',
		selector: 'replacestudentsearchform[itemId=replaceStudentSearchForm]'
	},{
		ref: 'replacementTabPanelView',
		selector: 'replacementtabpanelview'
	},{
		ref: 'stageStatasticsGrid',
		selector: 'stagestatasticsgrid[itemId=replacementStageStatistic]'
	},{
		ref: 'studentToBeReplacedGrid',
		selector: 'studenttobereplacegrid[itemId=studentToBeReplacedGrid]'
	},{
		ref: 'selectReplacementGrid',
		selector: 'selectreplacementgrid[itemId=selectReplacementGrid]'
	},{
		ref: 'replaceStudentButtonPanel',
		selector: 'replacestudentbuttonpanel[itemId=replaceStudentButtonPanel]'
	},{
		ref: 'closeReplacementGrid',
		selector: 'closereplacementgrid[itemId=closeReplacementGrid]'
	},{
		ref: 'closeReplacementSearchForm',
		selector: 'closereplacementsearchform[itemId=closeReplacementSearchForm]'
	},{
		ref: 'acadLocProgBatSeatTypeForm',
		selector: 'acadlocprogbatchseattypecomponent[itemId=acadLocProgBatSeatTypeId]'
	},{
		ref: 'approveReplacementButtonPanel',
		selector: 'approvereplacementbuttonpanel[itemId=approveReplacementButtonPanel]'
	},{
		ref: 'approveReplacementGrid',
		selector: 'approvereplacementgrid[itemId=approveReplacementGrid]'
	},{
		ref: 'replacementDetailTemplate',
		selector: 'replacementdetailtemplate[itemId=replacementDetailTemplate]'
	},{
		ref: 'viewReplacementListGrid',
		selector: 'viewreplacementlistgrid[itemId=viewReplacementListGridId]'
	},{
		ref: 'sendForApprovalButtonPanel',
		selector: 'sendforapprovalbuttonpanel[itemId=sendForApprovalId]'
	},{
		ref: 'approveStageStatasticsGrid',
		selector: 'stagestatasticsgrid[itemId=approveStageStatasticsGrid]'
	},{
		ref: 'approveReplacementDetailsView',
		selector: 'approvereplacementdetailsview[itemId=approveReplacementDetailsView]'
	},{
		ref: 'startReplacementGrid',
		selector: 'closedreplacementsearchview startreplacementgrid[itemId=restartReplacementGrid]'
	}],
	
	config: {
    	programSelectionProcessStageId: null,
    	//START_REPLACEMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('START_REPLACEMENT_PRIVILEGES'),
    	//ADMISSION_REPLACEMENT_STUDENT_TOBE_REPLACED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADMISSION_REPLACEMENT_STUDENT_TOBE_REPLACED_PRIVILEGES'),
    	//ADMISSION_REPLACEMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADMISSION_REPLACEMENT_PRIVILEGES'),
    	
    	//ADMISSION_APPROVAL_REPLACEMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADMISSION_APPROVAL_REPLACEMENT_PRIVILEGES'),
    	//ADMISSION_CLOSE_REPLACEMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADMISSION_CLOSE_REPLACEMENT_PRIVILEGES'),
    	//ADMISSION_START_REPLACEMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ADMISSION_START_REPLACEMENT_PRIVILEGES'),

	},
    
	init: function(application){
		this.control({
			'startreplacementgrid':{
				afterrender:function(obj){
					this.disableMoreActionStartReplacementPivileges(obj,this.getADMISSION_START_REPLACEMENT_PERMISSIONS());
				}
			},
			'closereplacementgrid':{
				render:function(obj){
					this.disableMoreActionCloseReplacementPivileges(obj,this.getADMISSION_CLOSE_REPLACEMENT_PERMISSIONS());
				}
			},
			'approvereplacementbuttonpanel':{
				render:function(obj){
					this.disableMoreActionApprovalReplacementPivileges(obj,this.getADMISSION_APPROVAL_REPLACEMENT_PERMISSIONS());
				}
			},
			'replacestudentbuttonpanel':{
				render:function(grid){
					this.disableMoreActionReplacementBottomPivileges(grid,this.getADMISSION_REPLACEMENT_PERMISSIONS());
				}
			},
			'studenttobereplacegrid':{
				render:function(grid){
					console.log('getADMISSION_REPLACEMENT_STUDENT_TOBE_REPLACED_PERMISSIONS()..',this.getADMISSION_REPLACEMENT_STUDENT_TOBE_REPLACED_PERMISSIONS());
					this.doAccessControlValidation(grid, this.getADMISSION_REPLACEMENT_STUDENT_TOBE_REPLACED_PERMISSIONS());
   				    this.disableMoreActionReplacementPivileges(grid,this.getADMISSION_REPLACEMENT_STUDENT_TOBE_REPLACED_PERMISSIONS());
   				    var buttonsToolBar = grid.query('toolbar')[0];
   				    var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
   			   		var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
   				    pdftoolbar.setDisabled(true);
   				    exceltoolbar.setDisabled(true);
				}
			},
			/**
			 * To load and clear search form combo
			 */
			'fieldcontainer[itemId=replaceAcadLocProgBatchContainer] combo[itemId=academyId]':{
				render: function(combo){
					this.loadAcademyCombo(combo);
				},
				select: function(combo, records, eOpts) {
                    var locationComboField = combo.up('form').down('#locationId');
                    var comboValue = combo.getValue();
	                this.loadDependentCombo( locationComboField, comboValue, 'academyId');
                }
			},
			
			'fieldcontainer[itemId=replaceAcadLocProgBatchContainer] combo[itemId=locationId]':{
				select: function(combo, records, eOpts) {
	                var programComboField = combo.up('form').down('#programId');
	                var academyCombo = combo.up('form').down('#academyId');
                    var academyValue = academyCombo.getValue(); 
                    var comboValue = combo.getValue();
                    this.loadDependentCombo( programComboField, comboValue, 'locationId','academyId',academyValue);
	            }
			},
			
			'fieldcontainer[itemId=replaceAcadLocProgBatchContainer] combo[itemId=programId]':{
				select: function(combo, records, eOpts) {
	                var batchComboField = combo.up('form').down('#batchId');
	                var comboValue = combo.getValue();
	                this.loadDependentCombo( batchComboField, comboValue, 'id');
	            }
			},
			
			'fieldcontainer[itemId=replaceSeattypeQuotaContainer] combo[itemId=batchId]': {
				select: function(combo, records, eOpts) {
	                var seatTypeComboField = combo.up('form').down('#seatTypeId');
	                var comboValue = combo.getValue();
	                this.loadDependentCombo( seatTypeComboField, comboValue, 'batchId');
	            }
			},
			
			'fieldcontainer[itemId=replaceSeattypeQuotaContainer] combo[itemId=seatTypeId]': {
				select: function(combo, records, eOpts) {
					var studentToBeReplacedGrid = this.getStudentToBeReplacedGrid();
					var selectReplacementGrid = this.getSelectReplacementGrid();
					var quotaTypeComboField = combo.up('form').down('#quotaTypeId');
					var button = studentToBeReplacedGrid.down('#replaceStudentSelectionStatistic');
					button.setDisabled(true);
					var studentToStageCombo = studentToBeReplacedGrid.down('#studentReplaceSelectionStageCombo');
					var selectReplacementCombo = selectReplacementGrid.down('#selectReplacementStageCombo');
	                var comboValue = records[0].get('id');
	                this.loadDependentCombo( quotaTypeComboField, comboValue, 'programBatchSeatConfigId');
	                this.loadDependentCombo( studentToStageCombo, comboValue, 'programBatchSeatConfigId');
	                this.loadDependentCombo( selectReplacementCombo, comboValue, 'programBatchSeatConfigId');
	            }
			},
			
			'fieldcontainer[itemId=replaceQuotaContainer] combo[itemId=quotaTypeId]':{
				select : function(combo,records, eOpts){
        			var quotaComboField = combo.up('form').down('#quotaId');
        			var comboValue = combo.getValue();
        			this.loadDependentCombo(quotaComboField, comboValue, 'quotaTypeId');
        		}
			},
			
			/**
			 * This is to open the selection statistic grid
			 */
			'studenttobereplacegrid[itemId=studentToBeReplacedGrid] button[itemId=replaceStudentSelectionStatistic]':{
				click: function(button){
					var selectionStageCombo = button.up('grid').down('#studentReplaceSelectionStageCombo');
					var value = selectionStageCombo.getValue();
					if(value){
						this.showSelectionStatisticGrid(getAdmissionTranslation('SELECTION_STATISTIC'));
						this.setProgramSelectionProcessStageId(selectionStageCombo.getValue());
	        			this.loadStage(selectionStageCombo);
	        			var grid = this.getStageStatasticsGrid();
	                    var quotaTypeCombo = grid.down('#quotaTypesCombo');
	                    this.loadComponentStore(quotaTypeCombo, 'programSelectionProcessId', this.getProgramSelectionProcessId());
						this.loadGrids();
					}else{
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
					
				}
			},
			/***This is to load grid data*****/
			'replacestudentsearchform[itemId=replaceStudentSearchForm] button[itemId=searchBtn]':{
				click: function(){
					this.loadReplaceStudentGrid();
					var selectReplacementGrid = this.getSelectReplacementGrid();
			    	var waitListComboField = selectReplacementGrid.down('#waitListId');
			    	waitListComboField.clearValue();
				}
			},
			
			/**
			 * disable buttons on stage statistic grid
			 */
			'stagestatasticsgrid[itemId=replacementStageStatistic]': {
				render: function(grid){
					var transferSeatBtn = grid.down('#transferSeatBtn');
			        //transferSeatBtn.setVisible(false);
			        var overrideQuotaLimits = grid.down('#overrideQuotaLimits');
			        //overrideQuotaLimits.setVisible(false);
				}
			},
			
			/**
			 * This is to disable combo and buttons
			 */
			'stagestatasticsgrid[itemId=approveStageStatasticsGrid]': {
				render: function(grid){
					var combo = grid.down('#quotaTypesCombo');
					combo.setVisible(false);
					var transferSeatBtn = grid.down('#transferSeatBtn');
			        //transferSeatBtn.setVisible(false);
			        var overrideQuotaLimits = grid.down('#overrideQuotaLimits');
			        //overrideQuotaLimits.setVisible(false);
				}
			},
			
			/**
			 * this is to load student to be replace grid on combo selection
			 */ 
			'studenttobereplacegrid[itemId=studentToBeReplacedGrid] combo[itemId=studentReplaceSelectionStageCombo]':{
				select: function(combo){
					this.loadReplaceStudentGrid(combo,'STUDENT_REPLACE');
					var grid = combo.up('grid');
					var selectionBtn = grid.down('#replaceStudentSelectionStatistic');
					selectionBtn.setDisabled(false);
				}
			},
			
			/**
			 * this is to load select replacement grid on combo selection
			 */
			'selectreplacementgrid[itemId=selectReplacementGrid] combo[itemId=selectReplacementStageCombo]':{
				select: function(combo){
					this.loadReplaceStudentGrid(combo,'SELECT_REPLACE');
					var waitListComboField = combo.up('grid').down('#waitListId');
					waitListComboField.clearValue();
				}
			},
			
			/**
			 * this is to load select replacement grid on combo selection
			 */
			'selectreplacementgrid[itemId=selectReplacementGrid] combo[itemId=waitListId]':{
				select: function(combo){
					this.loadReplaceStudentGrid(combo,'WAIT_LIST');
				}
			},
			
			/**
			 * this is to enable add to approval list and view approval list button
			 */
			'studenttobereplacegrid[itemId=studentToBeReplacedGrid]':{
				cellclick: function(view, td, cellIndex, record) {
                    this.cellClickApplicantProfileView(view, td, cellIndex, record);
                },
				select: function(grid){
					this.enableAddViewApprovalButton();
				}
			},
			
			/**
			 * this is to enable add to approval list and view approval list button
			 */
			'selectreplacementgrid[itemId=selectReplacementGrid]':{
				cellclick: function(view, td, cellIndex, record) {
                    this.cellClickApplicantProfileView(view, td, cellIndex, record);
                },
				select: function(grid){
					this.enableAddViewApprovalButton();
				}
			},
			
			/**
			 * this is to add the student to approval form replacement
			 */
			'replacestudentbuttonpanel[itemId=replaceStudentButtonPanel] button[itemId=addToApprovalList]':{
				click: function(){
					this.AddStudentToApprovalList();
				}
			},
			
			/**
			 * this is to view approval details screen
			 */
			'replacestudentbuttonpanel[itemId=replaceStudentButtonPanel] button[itemId=viewApprovalList]': {
				click: function(){
					this.viewApprovalListGrid();
				}
			},
			
			/**
			 * This function it tosend applicant to approval list
			 */
			'viewreplacementlistgrid[itemId=viewReplacementListGridId]': {
				render: function(grid){
					grid.getStore().load();
				},
				select: function(checkBox, record, index){
					var sendApprovalBtn = this.getSendForApprovalButtonPanel().down('#sendForApproval');
						sendApprovalBtn.setDisabled(false);
				}
			},
			
			/**
			 * Send for approval
			 */
			'sendforapprovalbuttonpanel[itemId=sendForApprovalId] button[itemId=sendForApproval]': {
				click: function(){
					this.sendForApprovalList();
				}
			},
			
			/**
			 * This is to open applicant profile
			 */
			'approvereplacementgrid[itemId=approveReplacementGrid]': {
				cellclick: function(view, td, cellIndex, record) {
                    this.cellClickApplicantProfileView(view, td, cellIndex, record);
                },
                select: function(){
                	this.showReplacementDetails();
                	this.enableApproveRejectButton();
                	var view = this.getApproveReplacementDetailsView();
                	view.setVisible(true);
                },
                render: function(grid){
                	var store = grid.getStore();
                	store.load();
                	var view = this.getApproveReplacementDetailsView();
                	view.setVisible(false);
                }
			},
			
			/**
			 * This is to approve the replacement
			 */
			'approvereplacementbuttonpanel[itemId=approveReplacementButtonPanel] button[itemId=approveReplacementId]': {
				click: function(){
					this.approveRejectReplacement('APPROVE');
					var view = this.getApproveReplacementDetailsView();
                	view.setVisible(false);
				}
			},
			
			/**
			 * This is to reject the replacement
			 */
			'approvereplacementbuttonpanel[itemId=approveReplacementButtonPanel] button[itemId=rejectReplacementId]': {
				click: function(){
					this.approveRejectReplacement('REJECT');
					var view = this.getApproveReplacementDetailsView();
                	view.setVisible(false);
				}
			},
			
			/**
			 * This is to send notification the replacement
			 */
			'approvereplacementbuttonpanel[itemId=approveReplacementButtonPanel] button[itemId=sendNotificationId]': {
				click: function(){
					
				}
			},
			
			/**
			 * This is to enable close replacement button 
			 */
			'closereplacementgrid[itemId=closeReplacementGrid]': {
				select: function(){
					var grid = this.getCloseReplacementGrid();
					var closeReplacementBtn = grid.down('#closeReplacementBtn');
					closeReplacementBtn.setDisabled(false);
					//this.enableCloseReplacementBtn(grid);
				}
			},
			
			/**
			 * This is to close the replacement of selected applicants
			 */
			'closereplacementgrid[itemId=closeReplacementGrid] button[itemId=closeReplacementBtn]': {
				click: function(){
					this.closeReplacement();
				}
			},
			/**
			 *This is to load selection process combo 
			 */
			'acadlocprogbatchseattypecomponent[itemId=acadLocProgBatSeatTypeId] combo[itemId=seatTypeCombo]': {
				select: function(combo,records, eOpts){
					var form = this.getCloseReplacementSearchForm();
					var selectionProcessComboField = form.down('#selectionProcess');
		            var comboValue = records[0].get('id');
		            this.loadDependentCombo( selectionProcessComboField, comboValue, 'progBatchSeatConfId');
				}
			},
			
			/**
			 * To load close replacement grid
			 */
			'closereplacementsearchform[itemId=closeReplacementSearchForm] button[itemId=closeReplacementSearchBtn]':{
				click: function(){
					this.loadCloseReplacementGrid();
				}
			},
			
			/**
			 * To load closed replacement grid
			 */
			'closereplacementsearchform[itemId=closedReplacementSearchform] button[itemId=closeReplacementSearchBtn]':{
				click: function(button){
					this.loadClosedReplacementGrid(button);
				}
			},
			
			/**
			 * This is to enable close replacement button 
			 */
			'closedreplacementsearchview startreplacementgrid[itemId=restartReplacementGrid]': {
				select: function(grid){
					var grid = this.getStartReplacementGrid();
					var startReplacementBtn = grid.down('#startReplacementBtn');
					startReplacementBtn.setDisabled(false);
				},
				render : function(grid){
					this.disableMoreActionPivileges(grid, this.getSTART_REPLACEMENT_PERMISSIONS());
				}
			},
			/**
			 * This is to close the replacement of selected applicants
			 */
			'closedreplacementsearchview startreplacementgrid[itemId=restartReplacementGrid] button[itemId=startReplacementBtn]': {
				click: function(button){
					this.startReplacement(button);
				}
			}
			
			
		});
	},
	/**
	 * This function is to enable add to approval list and view approval list button 
	 */
	enableAddViewApprovalButton: function(){
		var selectReplacementGrid = this.getSelectReplacementGrid();
		var studentToBeReplacedGrid = this.getStudentToBeReplacedGrid();
		var selectReplacementCount = selectReplacementGrid.getSelectionModel().getCount();
		var studentToBeReplacedCount = studentToBeReplacedGrid.getSelectionModel().getCount();
		var replaceStudentButtonPanel = this.getReplaceStudentButtonPanel();
		var addToApprovalButton = replaceStudentButtonPanel.down('#addToApprovalList');
		if(studentToBeReplacedCount > 0 && selectReplacementCount > 0){
			addToApprovalButton.setDisabled(false);
		}else{
			addToApprovalButton.setDisabled(true);
		}
	},
	
	/**
	 * this is to enable close replacement btn
	 */
	enableCloseReplacementBtn: function(){
		var grid = this.getCloseReplacementGrid();
		var closeReplacementBtn = grid.down('#closeReplacementBtn');
		var count = grid.getSelectionModel().getCount();
		if(count > 0){
			closeReplacementBtn.setDisabled(false);
		}else{
			closeReplacementBtn.setDisabled(true);
		}
	},
	
	/**
	 *This is to load academy combo 
	 */
	loadAcademyCombo:function(combo){
    	combo.getStore().load({
		});
    },
	
	/**
     * This function is to load the dependent combo
     */
    loadDependentCombo: function(dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
    	var this$ = this;
    	this$.resetOtherDropdowns(dependentCombo);
        dependentCombo.clearValue();
        dependentCombo.setDisabled(false);
        dependentCombo.store.removeAll();
        var store = dependentCombo.getStore();
        var id = comboValue;
        if(!isNullOrEmpty(id)){
        	var url = store.getProxy().proxyConfig.api.read;
            if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
                url = url.concat('?' + parameter + '=' + id);
            } else {
                url = url.concat('?' + parameter + '=' + id);
                url = url.concat('&' + extraParameter + '=' + extraParamValue);
            }
            store.getProxy().api.read = url;
            store.reload();
        }
    },
    
    /**
     * This function is to reset other combo
     */
    resetOtherDropdowns: function(combo) {
        var container = combo.up('form');
        switch (combo.itemId) {
        case 'academyId':
            this.clearCombo(combo);
            locationCombo = container.down('combo[itemId=locationId]');
            this.clearCombo(locationCombo);
            programCombo = container.down('combo[itemId=programId]');
            this.clearCombo(programCombo);
            batchCombo = container.down('combo[itemId=batchId]');
            this.clearCombo(batchCombo);
            seatTypeCombo = container.down('combo[itemId=seatTypeId]');
            this.clearCombo(seatTypeCombo);
            quotaType = container.down('combo[itemId=quotaTypeId]');
            this.clearCombo(quotaType);
            quotaCombo = container.down('combo[itemId=quotaId]');
        	this.clearCombo(quotaCombo);
        	locationCombo.setDisabled(true);
        	programCombo.setDisabled(true);
        	batchCombo.setDisabled(true);
        	seatTypeCombo.setDisabled(true);
        	 quotaType.setDisabled(true);
	    	 quotaCombo.setDisabled(true);
            break;
        case 'locationId':
            this.clearCombo(combo);
            programCombo = container.down('combo[itemId=programId]');
            this.clearCombo(programCombo);
            batchCombo = container.down('combo[itemId=batchId]');
            this.clearCombo(batchCombo);
            seatTypeCombo = container.down('combo[itemId=seatTypeId]');
            this.clearCombo(seatTypeCombo);
            quotaType = container.down('combo[itemId=quotaTypeId]');
            this.clearCombo(quotaType);
            quotaCombo = container.down('combo[itemId=quotaId]');
        	this.clearCombo(quotaCombo);
        	
        	programCombo.setDisabled(true);
        	batchCombo.setDisabled(true);
        	seatTypeCombo.setDisabled(true);
        	 quotaType.setDisabled(true);
	    	 quotaCombo.setDisabled(true);
            break;
        case 'programId':
            this.clearCombo(combo);
            batchCombo = container.down('combo[itemId=batchId]');
            this.clearCombo(batchCombo);
            seatTypeCombo = container.down('combo[itemId=seatTypeId]');
            this.clearCombo(seatTypeCombo);
            quotaType = container.down('combo[itemId=quotaTypeId]');
            this.clearCombo(quotaType);
            quotaCombo = container.down('combo[itemId=quotaId]');
        	this.clearCombo(quotaCombo);
        	
        	batchCombo.setDisabled(true);
        	seatTypeCombo.setDisabled(true);
	    	 quotaType.setDisabled(true);
	    	 quotaCombo.setDisabled(true);
            break;
        case 'batchId':
        	this.clearCombo(combo);
        	seatTypeCombo = container.down('combo[itemId=seatTypeId]');
        	this.clearCombo(seatTypeCombo);
        	quotaType = container.down('combo[itemId=quotaTypeId]');
            this.clearCombo(quotaType);
            quotaCombo = container.down('combo[itemId=quotaId]');
        	this.clearCombo(quotaCombo);
        	seatTypeCombo.setDisabled(true);
        	 quotaType.setDisabled(true);
	    	 quotaCombo.setDisabled(true);
        	break;
        case 'seatTypeId':
        	this.clearCombo(combo);
        	quotaType = container.down('combo[itemId=quotaTypeId]');
            this.clearCombo(quotaType);
            quotaCombo = container.down('combo[itemId=quotaId]');
        	this.clearCombo(quotaCombo);
        	 quotaType.setDisabled(true);
	    	 quotaCombo.setDisabled(true);
        case 'quotaTypeId':
        	this.clearCombo(combo);
        	quotaCombo = container.down('combo[itemId=quotaId]');
        	this.clearCombo(quotaCombo);
        	 quotaCombo.setDisabled(true);
        	break;
        case 'quotaId':
        	this.clearCombo(combo);
        }
    },
    
    /**
     * This function is to clear the combo value
     */
    clearCombo: function(combo) {
        combo.clearValue();
        combo.store.removeAll();
    },
    
    /**
     * This method is used to add document 
     */
    showSelectionStatisticGrid: function(title) {
    	
    	var this$ = this;
    	var replacementTabPanel = this$.getReplacementTabPanelView();
    	var newTab = replacementTabPanel.items.findBy(function(tab) {
            return tab.title === title;
        });
        if (!newTab) {
        	newTab = replacementTabPanel.add({
                xtype: 'stagestatasticsgrid',
                itemId: 'replacementStageStatistic',
                padding: 10,
                title: title,
                closable: true
            });
        }
        var grid = this.getStageStatasticsGrid();
        var transferSeatBtn = grid.down('#transferSeatBtn');
       // transferSeatBtn.setVisible(false);
        var overrideQuotaLimits = grid.down('#overrideQuotaLimits');
       // overrideQuotaLimits.setVisible(false);
        replacementTabPanel.setActiveTab(newTab);
    },
    
    /**
     * This function is to load grid
     */
    loadReplaceStudentGrid: function(combo,requestType) {
        var this$= this;
        var comboValue = null;
        if(!isNullOrEmpty(combo)){
        	comboValue = combo.getValue();
        }
    	var studentToBeReplacedGrid = this$.getStudentToBeReplacedGrid();
    	var buttonsToolBar = studentToBeReplacedGrid.query('toolbar')[0];
	    var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
	    var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
    	var selectReplacementGrid = this$.getSelectReplacementGrid();
    	var buttonsToolBarGrid = selectReplacementGrid.query('toolbar')[0];
	    var pdftoolbarreplacementgrid = buttonsToolBarGrid.query('#btnExportToPDF')[0];
	    var exceltoolbarreplacementgrid = buttonsToolBarGrid.query('#btnExportToExcel')[0];
    	studentToBeReplacedGrid.getSelectionModel().deselectAll();
    	selectReplacementGrid.getSelectionModel().deselectAll();
    	this$.enableAddViewApprovalButton();
    	var searchCriteriaForm = this$.getReplaceStudentSearchForm();
    	var formValues = this$.createReplaceStudentJsonFormat(searchCriteriaForm,null);
    	
		var seatTypeCombo = searchCriteriaForm.down('#seatTypeId');
        var programBatchSeatConfigId =seatTypeCombo.valueModels[0].get("id");
        formValues.programBatchSeatConfigId=programBatchSeatConfigId;
        
    	if(requestType == 'STUDENT_REPLACE' || requestType == 'SELECT_REPLACE'){
    		   var stagesId = [];
    		   stagesId.push(comboValue);
    		formValues.stagesId = stagesId;
    	}
    	if(requestType == 'WAIT_LIST'){
    		var stageValue = selectReplacementGrid.down('#selectReplacementStageCombo').getValue();
    		var stagesId = [];
    		stagesId.push(stageValue);
    		formValues.stagesId = stagesId;
    		formValues.stageStatus = comboValue;
    	}
    	var studentGridStore = studentToBeReplacedGrid.getStore();
    	var replacementGridStore= selectReplacementGrid.getStore();
    	studentGridStore.getProxy().extraParams = formValues;
    	replacementGridStore.getProxy().extraParams= formValues;
    	if(requestType == 'STUDENT_REPLACE'){
    		studentGridStore.load({ 
        		callback: function(records, operation, success) {
    				if(records.length>0){
    			    	pdftoolbar.setDisabled(false);
    			    	exceltoolbar.setDisabled(false);
    				}
    			  }});
    	}
    	if(requestType == 'SELECT_REPLACE' || requestType == 'WAIT_LIST'){
    		replacementGridStore.load({ 
        		callback: function(records, operation, success) {
    				if(records.length>0){
    			    	pdftoolbar.setDisabled(false);
    			    	exceltoolbar.setDisabled(false);
    				}
    			  }});
    	}
    	if(isNullOrEmpty(requestType)) {
    		studentGridStore.load({ 
        		callback: function(records, operation, success) {
    				if(records.length>0){
    			    	pdftoolbar.setDisabled(false);
    			    	exceltoolbar.setDisabled(false);
    				}
    			  }});
        	replacementGridStore.load({ 
        		callback: function(records, operation, success) {
    				if(records.length>0){
    			    	pdftoolbar.setDisabled(false);
    			    	exceltoolbar.setDisabled(false);
    				}
    			  }});
    	}
    	 /***************Start Code added for show filter data on PDF/Excel Export Report **************/
    	     	
    	     	grid.config.searchFilterForm = this$.getReplaceStudentSearchForm();
    	     	
    	        /***************End Code added for show filter data on PDF/Excel Export Report **************/
    },
    
    /**
     * Create search criteria json
     * @params searchCriteriaForm
     */
    createReplaceStudentJsonFormat: function(searchCriteriaForm,grid){
    	var formValues = null;
    	if(searchCriteriaForm){
			formValues = searchCriteriaForm.getValues();
    	}
    	if(isNullOrEmpty(grid)){
    		delete formValues.stageObject;
    	}
    	if(!isNullOrEmpty(grid)){
            for (var key in formValues) {
				if(key != 'selectionProcess'){
					formValues[key] = formValues[key].id;
				}
              }
    	}
    	return formValues;
    },
    
    /**
     * This is to add student to approval list
     */
    AddStudentToApprovalList : function(){
    	var studentToBeReplacedGrid = this.getStudentToBeReplacedGrid();
    	var selectReplacementGrid = this.getSelectReplacementGrid();
    	var approveReplacementGrid= this.getApproveReplacementGrid();
    	var studentReplaceRecord = studentToBeReplacedGrid.getSelectionModel().getSelection()[0];
    	var selectReplaceRecord = selectReplacementGrid.getSelectionModel().getSelection()[0];
    	if(!isNullOrEmpty(studentReplaceRecord) && !isNullOrEmpty(selectReplaceRecord)){
    		showConfirmMessage(getAdmissionTranslation('ADD_TO_APPROVAL_LIST'), getAdmissionTranslation('ADD_TO_APPROVAL_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                	var candidateToReplaced = studentReplaceRecord.get('id');
                	var candidateByReplaced = selectReplaceRecord.get('id');
                	var url = SERVERURL.ADD_TO_APPROVAL_LIST;
                	url = url.concat('?candidateToReplaced='+candidateToReplaced+'&candidateByReplaced='+candidateByReplaced+'');
                    Ext.Ajax.request({
                        type: 'rest',
                        url: url,
                        method: 'PUT',
                        async: false,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        success: function(response) {
                        	studentToBeReplacedGrid.getSelectionModel().deselectAll();
                        	selectReplacementGrid.getSelectionModel().deselectAll();
                        	studentToBeReplacedGrid.getStore().load();
                        	selectReplacementGrid.getStore().load();
                        	approveReplacementGrid.getStore().load();
                        }
                    });
                }
                });
    		
    	}else{
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    	
    },
    
    /**
     * This is to view approval list
     */
    viewApprovalListGrid: function(){
    	var window = Ext.create('Academia.view.admission.replacement.ReplacementListWindow');
    	window.show();
    },
    
    /**
     * Send for approval list
     */
    sendForApprovalList: function(){
    	var grid = this.getViewReplacementListGrid();
    	var approveReplacementGrid= this.getApproveReplacementGrid();
    	var selection = grid.getSelectionModel().getSelection();
    	var sendApprovalIDs = new Array();
    	if(selection.length != 0){
    		for(var i=0; i < selection.length; i++){
        		sendApprovalIDs.push(selection[i].get('id'));
        	}
        	var url = SERVERURL.SEND_FOR_APPROVAL;
        	url = url.concat('?sendForApprovalReplacementIds='+sendApprovalIDs+'');
        	Ext.Ajax.request({
                type: 'rest',
                url: url,
                method: 'POST',
                success: function(res, action) {
                    grid.getStore().load();   
                    approveReplacementGrid.getStore().load();
                    showSuccessMessage(getAdmissionTranslation('SEND_FOR_APPROVAL'), getAdmissionTranslation('RECORD_ADDED_TO_APPROVAL_LIST'));
                }
            });
    	}else{
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    	
    },
    
    /**
     * This function is to open the applicant profile
     */
    cellClickApplicantProfileView: function(view, td, cellIndex, record, tr, rowIndex, e, eOpts) {
        var columnName = view.getGridColumns()[cellIndex].dataIndex;
        var grid = view.up('grid');
        var applicationBaseController = this.getController('Academia.controller.admission.applications.applicationBase.ApplicationBaseController');
        if(columnName == "replacedToBeAppId"){
        	var applicationId=record.get('replacedToBePrimaryId');
        	applicationBaseController.openApplicantProfile(applicationId,true,grid,'REPLACE_TO_APPLICATION_ID');
        }
        if(columnName == 'replacedByAppId'){
        	var applicationId=record.get('replacedByPrimaryId');
        	applicationBaseController.openApplicantProfile(applicationId,true,grid,'REPLACE_BY_APPLICATION_ID');
        }
        return false; 
    },
    
    /**
     * This is to show replacement details
     */
    showReplacementDetails: function(){
    	var $this = this;
    	var applicantProfileView = this.getReplacementDetailTemplate();
    	var grid = this.getApproveReplacementGrid();
    	var record = grid.getSelectionModel().getSelection()[0];
    	var url = SERVERURL.REPLACEMENT_DETAILS_OF_APPLICANT;
    	if(!isNullOrEmpty(record)){
    		var id= record.get('id');
        	url = url.concat('?id='+id+'');
        	Ext.Ajax.request({
                type: 'rest',
                url: url,
                method: 'GET',
                success: function(res, action) {
                    var data = Ext.decode(res.responseText);
                    var tpl = applicantProfileView.tpl;
                    tpl.overwrite(applicantProfileView.el.dom, data);
                    $this.loadGrids(data);
                }
            });
    	}
    },
    
    /**
     * This is to enable disable approve reject button
     */
    enableApproveRejectButton: function(){
    	var grid = this.getApproveReplacementGrid();
    	var gridCount = grid.getSelectionModel().getCount();
		var approveReplacementButtonPanel = this.getApproveReplacementButtonPanel();
		var approveReplacementId = approveReplacementButtonPanel.down('#approveReplacementId');
		var rejectReplacementId = approveReplacementButtonPanel.down('#rejectReplacementId');
		if(gridCount > 0){
			approveReplacementId.setDisabled(false);
			rejectReplacementId.setDisabled(false);
		}else{
			approveReplacementId.setDisabled(true);
			rejectReplacementId.setDisabled(true);
		}
    },
    
    /**
     * This is to approve and reject replacement
     */
    approveRejectReplacement: function(requestType){
    	var grid = this.getApproveReplacementGrid();
    	var record = grid.getSelectionModel().getSelection()[0];
    	var fieldName = null;
    	var message = null;
    	var url = null;
    	if(requestType == 'APPROVE'){
    		url = SERVERURL.APPROVE_REPLACEMENT;
    		fieldName = getAdmissionTranslation('APPROVE_REPLACEMENT');
    		message =  getAdmissionTranslation('APPROVE_REPLACEMENT_MESSAGE');
    	}
    	if(requestType == 'REJECT'){
    		url = SERVERURL.REJECT_REPLACEMENT;
    		fieldName = getAdmissionTranslation('REJECT_REPLACEMENT');
    		message =  getAdmissionTranslation('REJECT_REPLACEMENT_MESSAGE');
    	}
    	if(!isNullOrEmpty(record)){
    		showConfirmMessage(fieldName, message, function(btn, text) {
                if (btn == 'yes') {
            		var id= record.get('id');
                	url = url.concat('?id='+id+'');
                	Ext.Ajax.request({
                        type: 'rest',
                        url: url,
                        method: 'PUT',
                        async: false,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        success: function(response) {
                        	grid.getStore().load();
                        	if(requestType == 'APPROVE'){
                        		showSuccessMessage(getAdmissionTranslation('APPROVE_REPLACEMENT'), getAdmissionTranslation('REPLACEMENT_APPROVED_SUCCESSFULLY'));
                        	}
                        	if(requestType == 'REJECT'){
                        		showSuccessMessage(getAdmissionTranslation('REJECT_REPLACEMENT'), getAdmissionTranslation('REPLACEMENT_REJECTED_SUCCESSFULLY'));
                        	}
                        }
                    });
            	}
                });
    		}else{
    			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        	}
    },
    
    /**
     * This function is to load close replacement grid
     */
    loadCloseReplacementGrid: function(){
    	var grid = this.getCloseReplacementGrid();
		grid.getSelectionModel().deselectAll();
		this.enableCloseReplacementBtn();
		var searchCriteriaForm = this.getCloseReplacementSearchForm();
    	var formValues = this.createReplaceStudentJsonFormat(searchCriteriaForm,grid);
    	var closeReplacementGridStore= grid.getStore();
    	closeReplacementGridStore.getProxy().extraParams = formValues;
    	closeReplacementGridStore.load();
    },
    
    loadClosedReplacementGrid: function(button){
		var panel = button.up('closedreplacementsearchview');
		var grid=panel.down('#restartReplacementGrid');
		
		grid.getSelectionModel().deselectAll();
		
		var searchCriteriaForm =button.up('#closedReplacementSearchform');
		
    	var formValues = this.createReplaceStudentJsonFormat(searchCriteriaForm,grid);
    	
    	var closedReplacementGridStore= grid.getStore();
    	closedReplacementGridStore.getProxy().extraParams = formValues;
    	closedReplacementGridStore.load();
    },
    
    startReplacement : function(button){
    	var grid = button.up('startreplacementgrid');
    	var selection = grid.getSelectionModel().getSelection();
    	
    	if(selection.length != 0){
    		showConfirmMessage(getAdmissionTranslation('START_REPLACEMENT'), getAdmissionTranslation('START_REPLACEMENT_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                	var programSelectionProcessId  = selection[0].get('selectionProcess').id;
                	var url = SERVERURL.START_REPLACEMENT;
                	Ext.Ajax.request({
                        type: 'rest',
                        url: url,
                        method: 'POST',
                        async: false,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        
                        params:{
                        	'programSelectionProcessId':programSelectionProcessId
                        },
                        success: function(response) {
                        	grid.getStore().load();
                        }
                        
                        
                    });
                }
                });
        	
    	}else{
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    	
    },
    
    /**
     * This is to close the replacement of the applicants selected
     */
    closeReplacement: function(){
    	var grid = this.getCloseReplacementGrid();
    	var selection = grid.getSelectionModel().getSelection();
    	
    	
    	if(selection.length != 0){
    		showConfirmMessage(getAdmissionTranslation('CLOSE_REPLACEMENT'), getAdmissionTranslation('CLOSE_REPLACEMENT_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                	var programSelectionProcessId  = selection[0].get('id');
                	var url = SERVERURL.CLOSE_REPLACEMENT_CREATE;
                	Ext.Ajax.request({
                        type: 'rest',
                        url: url,
                        method: 'POST',
                        async: false,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        
                        params:{
                        	'programSelectionProcessId':programSelectionProcessId
                        },
                        success: function(response) {
                        	grid.getStore().load();
                        }
                        
                        
                    });
                }
                });
        	
    	}else{
    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    	
    },
    
    /**
     * Set Program Selection Process Stage ID
     */ 
     setProgramSelectionProcessStageId: function(id) {
     	this.programSelectionProcessStageId = id;
     },
     
     getProgramSelectionProcessStageObject: function() {
         var replaceStudentSearchForm = this.getReplaceStudentSearchForm().getForm();
         var stageObjectData = replaceStudentSearchForm.findField('stageObject').getSubmitValue();
         return Ext.decode(stageObjectData); 
     },
     /**
      * This function is to find programSelectionProcessId
      */
     getProgramSelectionProcessId: function() {
         return this.getProgramSelectionProcessStageObject().programSelectionProcessId;
     },
     /**
      * This function is to load data to get programSelectionProcessId
      */
     loadStage: function(selectionStageCombo) {
         var this$ = this;
         var url = SERVERURL.PSP_STAGE_SETTING_ADD_EDIT_DELETE_FIND;
         var selectionStageId = selectionStageCombo.getValue();
         url = url.concat('/'+selectionStageId);
         Ext.Ajax.request({
             type: 'rest',
             url: url,
             method: 'GET',
             async: false,
             headers: {
                 'Content-Type': 'application/json'
             },
             success: function(response) {
             	data = Ext.decode(response.responseText);
             	var form = this$.getReplaceStudentSearchForm().getForm();
                 form.setValues({
                     'stageObject': response.responseText
                 });
                 form.setValues(data);
             }
         });
     },
     
     /**
      * This function is to load quota report grid
      */
     loadGrids: function(data) {
     	var criteria = new Object();
     	var programSelectionProcessStageIds = new Array();
     	criteria.whetherLatest = true;
     	var grid =null;
     	if(isNullOrEmpty(data)){
     		programSelectionProcessStageIds.push(this.getProgramSelectionProcessStageId());
         	grid = this.getStageStatasticsGrid();
     	}
     	if(data){
     		programSelectionProcessStageIds.push(data.selectionStage.id);
     		grid = this.getApproveStageStatasticsGrid();
     	}
     	criteria.programSelectionProcessStageId = programSelectionProcessStageIds;
 		var store= grid.getStore();
 		store.load({
 			params:criteria	
 		});
     },
     
     //******************Disable reset password button**********************************
     disableMoreActionPivileges: function(gridReference,permissionsMap) {
         	var associatedAcadLocationIds = new Array();
         	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
     		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
     		buttonsToolBar = gridReference.query('toolbar')[0];
         	var startReplacementBtn = gridReference.down('#startReplacementBtn');
         	startReplacementBtn.setVisible(false);
         	Ext.each(permissionList, function(privilege) {
         		if (privilege === 'STARTREPLACEMENT') {
             		var button = buttonsToolBar.query('#startReplacementBtn')[0];
             		if(!isNullOrEmpty(button)){
             			startReplacementBtn.setVisible(true);
             		}        		
             	}
         	});
         },
       //******************Disable Replacement button**********************************
         disableMoreActionReplacementPivileges: function(gridReference,permissionsMap) {
             	var associatedAcadLocationIds = new Array();
             	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
         		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
             	var replaceStudentSelectionStatistic = gridReference.down('#replaceStudentSelectionStatistic');
             	replaceStudentSelectionStatistic.setVisible(false);
             	Ext.each(permissionList, function(privilege) {
             		if (privilege === 'SELECTIONSTATISTIC') {
                 		if(!isNullOrEmpty(replaceStudentSelectionStatistic)){
                 			replaceStudentSelectionStatistic.setVisible(true);
                 		}        		
                 	}
             	});
             },
           //******************Disable Replacement bottom button**********************************
             disableMoreActionReplacementBottomPivileges: function(gridReference,permissionsMap) {
                 	var associatedAcadLocationIds = new Array();
                 	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
             		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
                 	
             		var addToApprovalList = gridReference.down('#addToApprovalList');
                 	addToApprovalList.setVisible(false);
                 	
                 	var viewApprovalList = gridReference.down('#viewApprovalList');
                 	viewApprovalList.setVisible(false);
                 	
                 	
                 	Ext.each(permissionList, function(privilege) {
                 		if (privilege === 'ADDTOAPPROVALLIST') {
                     		if(!isNullOrEmpty(addToApprovalList)){
                     			addToApprovalList.setVisible(true);
                     		}        		
                     	}
                 		if (privilege === 'VIEWAPPROVALLIST') {
                     		if(!isNullOrEmpty(viewApprovalList)){
                     			viewApprovalList.setVisible(true);
                     		}        		
                     	}
                 	});
                 }, 
          //******************disableMoreActionApprovalReplacementPivileges**********************************
                 disableMoreActionApprovalReplacementPivileges: function(gridReference,permissionsMap) {
                     	var associatedAcadLocationIds = new Array();
                     	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
                 		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
                     	
                 		var approveReplacementId = gridReference.down('#approveReplacementId');
                 		approveReplacementId.setVisible(false);
                     	
                     	var rejectReplacementId = gridReference.down('#rejectReplacementId');
                     	rejectReplacementId.setVisible(false);
                     	
                     
                     	
                     	Ext.each(permissionList, function(privilege) {
                     		if (privilege === 'APPROVALREPLACEMENT') {
                         		if(!isNullOrEmpty(approveReplacementId)){
                         			approveReplacementId.setVisible(true);
                         		}        		
                         	}
                     		if (privilege === 'REJECTREPLACEMENT') {
                         		if(!isNullOrEmpty(rejectReplacementId)){
                         			rejectReplacementId.setVisible(true);
                         		}        		
                         	}
                     		
                     	});
                     },
             //******************Disable Clsoe Replacement button**********************************
                     disableMoreActionCloseReplacementPivileges: function(gridReference,permissionsMap) {
                         	var associatedAcadLocationIds = new Array();
                         	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
                     		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
                         	
                     		var closeReplacementBtn = gridReference.down('#closeReplacementBtn');
                         	closeReplacementBtn.setVisible(false);
                         	
                         	
                         	Ext.each(permissionList, function(privilege) {
                         		if (privilege === 'CLOSEREPLACEMENT') {
                             		if(!isNullOrEmpty(closeReplacementBtn)){
                             			closeReplacementBtn.setVisible(true);
                             		}        		
                             	}
                         		
                         	});
                         },    
              //******************Disable Start Replacement button**********************************
                         disableMoreActionStartReplacementPivileges: function(gridReference,permissionsMap) {
                             	var associatedAcadLocationIds = new Array();
                             	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
                         		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
                             	
                         		var startReplacementBtn = gridReference.down('#startReplacementBtn');
                             	startReplacementBtn.setVisible(false);
                             	
                             	
                             	Ext.each(permissionList, function(privilege) {
                             		if (privilege === 'STARTREPLACEMENT') {
                                 		if(!isNullOrEmpty(startReplacementBtn)){
                                 			startReplacementBtn.setVisible(true);
                                 		}        		
                                 	}
                             		
                             	});
                             }           
});
