/**
 * This controller is used for Completion set up functionality
 */
Ext.define('Academia.controller.completion.CompletionSettingController', {
    extend: 'Academia.controller.completion.CompletionFormController',
    stores: ['completion.setup.CheckListItemStore', 'completion.setup.TransactionTypeStore', 'Academia.store.common.ProgramByAcademyLocationStore',
             'othermasters.certificatemaster.CertificateMasterStore', 'Academia.store.common.ProgramByAcademyLocationStore',
             'Academia.store.completion.setup.CompletionChecklists', 'Academia.store.completion.setup.CertificatesMappedWithTransactionType',
             'Academia.store.completion.setup.CKItemsMappedWithTransactionType', 'Academia.store.completion.setup.ChecklistAndCertificates',
             'completion.setup.TransactionTypes','completion.setup.CompletionCertificates'
             ,'completion.setup.TransactionTypesExceptTempTermination'],

    requires:['Ext.ux.data.PagingMemoryProxy' ],
    views: ['completion.CompletionCommonWindow', 'completion.setup.CompletionSettingPanel', 'completion.setup.MapCertificateWithTransactionForm', 
            'completion.setup.ManageCompletionCheckListPanel', 'completion.setup.MapItemWithTransactionForm',
            'completion.setup.MapCheckListCertificatePanel','completion.setup.ManageCheckListItemPanel', 'completion.setup.ManageCheckListItemGrid', 
            'completion.setup.ManageTransactionTypePanel', 'completion.setup.ManageTransactionTypeGrid', 'completion.setup.ManageTransactionTypeForm',
            'completion.setup.MapCertificateWithTransactionTypeForm', 'completion.setup.ManageCheckListItemForm',
            'completion.setup.MapChecklistWithTransactionTypeForm', 'completion.setup.ManageCompletionSearchPanel', 'completion.setup.CompletionChecklistGrid',
            'completion.setup.checklistCertificatePopUp','completion.setup.ShowChekListPopUp'
            ],
            
    refs: [{
        ref: 'completionCommonWindow',
        selector: 'completioncommonwindow[itemId=completionCommonWindow]'
    }, {
        ref: 'manageCheckListItemGrid',
        selector: 'managechecklistitemgrid[itemId=manageCheckListItemGrid]'
    }, {
        ref: 'manageCheckListItemForm',
        selector: 'managechecklistitemform[itemId=manageCheckListItemForm]'
    }, {
        ref: 'manageTransactionTypeGrid',
        selector: 'managetransactiontypegrid[itemId=manageTransactionTypeGrid]'
    }, {
        ref: 'manageTransactionTypeForm',
        selector: 'managetransactiontypeform[itemId=manageTransactionTypeForm]'
    }, {
        ref: 'mapItemWithTransactionForm',
        selector: 'mapitemwithtransactionform[itemId=mapItemWithTransactionForm]'
    }, {
    	ref : 'mapChecklistToTransactionPanel',
    	selector: 'mapchecklistcertificatepanel'
    }, {
    	ref : 'mapChecklistWithTransactionTypeForm',
    	selector: 'mapchecklistwithtransactiontypeform[itemId=mapChecklistWithTransactionTypeForm]'
    }, {
    	ref : 'mapCertificateWithTransactionTypeForm',
    	selector: 'mapcertificatewithtransactiontypeform[itemId=mapCertificateWithTransactionTypeForm]'
    }, {
    	ref: 'completionChecklistGrid',
    	selector: 'completionchecklistgrid'
    }],
    config: {
    	COMPLETION_SETTING_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COMPLETION_SETTING_PRIVILEGES')
    },
    init: function() {

        this.control({
        	
        	/**
        	 * On render map transaction type form load item selector store 
        	 */
        	'completionsettingpanel' : {
        		tabchange : function(tabPanel, newCard, oldCard, eOpts ){
        			var tab = tabPanel.activeTab.itemId ;
        			switch(tab){
        			case 'manageTransactionTypePanel' :{
        				
        				var manageTransactionTypeForm = tabPanel.down('#manageTransactionTypePanel');
        				var grid = manageTransactionTypeForm.down('#manageTransactionTypeGrid');
        				grid.getStore().load();
        				break;
        			}
        			case 'manageChecklistItemPanel' :{
        				
        				var manageCheckList = tabPanel.down('#manageChecklistItemPanel');
        				var grid = manageCheckList.down('#manageCheckListItemGrid');
        				grid.getStore().load();
                        this.doAccessControlValidation(grid, this.getCOMPLETION_SETTING_PERMISSIONS());
        				break;
        			}
        			case 'mapChecklistToTransactionPanel' :{
        				
        				var manageCheckListToTransaction = tabPanel.down('#mapChecklistWithTransactionTypeForm');
        				var itemSelector = manageCheckListToTransaction.down('#mapChecklistItemSelector');
        			    manageCheckListToTransaction.down('#checklistTransactionTypeCombo').reset();
        			    itemSelector.getStore().removeAll();
        				itemSelector.reset();
            			itemSelector.setDisabled(true);
            			break;
        			}
        			case 'mapCertificateToTransactionPanel' :{
        				
        				var manageCertToTransaction = tabPanel.down('#mapCertificateWithTransactionTypeForm');
        				var itemSelector = manageCertToTransaction.down('#mapCertificateItemSelector');
        				manageCertToTransaction.down('#certificateTransactionTypeCombo').reset();
        				itemSelector.getStore().removeAll();
        				itemSelector.reset();
            			itemSelector.setDisabled(true);
            			break;
        			}
        			case 'manageCompletionChecklistPanel':{
        				
        				var manageCompletionChekList = tabPanel.down('#manageCompletionChecklistPanel');
        				var grid = manageCompletionChekList.down('#completionchecklistgridId');
        				grid.getStore().load();
        				break;
        			}
        			}
        			
        		}
        	},
        	'managetransactiontypepanel':{
        		afterrender:function(structure){
        			var grid = structure.down('managetransactiontypegrid');
        			this.getGridHeaderFreezeForCompletion(grid,structure,false)
        		}
        	},
        	'managechecklistitempanel':{
        		afterrender:function(structure){
        			var grid = structure.down('managechecklistitemgrid');
        			this.getGridHeaderFreeze(grid,structure,false)
        		}
        	},
        	
        	'mapchecklistwithtransactiontypeform[itemId=mapChecklistWithTransactionTypeForm] nestedJsonCombo[itemId=checklistTransactionTypeCombo]' : {
        		select : function(combo, record){
        			this.getMappedChecklistTransactionType(combo, record);
        			
        		}
        	},
        	
        	'mapcertificatewithtransactiontypeform[itemId=mapCertificateWithTransactionTypeForm] nestedJsonCombo[itemId=certificateTransactionTypeCombo]' : {
        		select : function(combo, record){
        			this.getMappedCertificateTransactionType(combo, record);
        		}
        	},
        	'mapchecklistwithtransactiontypeform[itemId=mapChecklistWithTransactionTypeForm] button[itemId=submitButtonId]' : {
        		click : function(btn){
        			this.saveMappedChecklistItemWithTransactionType(btn);
        			
        		}
        	},
        	
        	'mapchecklistwithtransactiontypeform[itemId=mapChecklistWithTransactionTypeForm] combo[itemId=checklistTransactionTypeCombo]' : {
        		render : function(combo){
        			var store = combo.getStore();
        			store.load({
        				callback : function(records){
        					Ext.each(records,function(rec){
        							store.removeAt(records[2].internalId);
                					store.commitChanges();
        					});
        				}
        			});
        			
        			
        		}
        	},
        	
        	'mapcertificatewithtransactiontypeform[itemId=mapCertificateWithTransactionTypeForm] button[itemId=submitButtonId]' : {
        		click : function(btn){
        			this.saveMappedCertificateItemWithTransactionType(btn);
        		}
        	},

            /**
             *  Manage CheckList Item
             */

           
            'managechecklistitemgrid[itemId=manageCheckListItemGrid] button[itemId=btnAdd]': {
                click: function(){
                	this.showCompletionCommonWindow('MANAGE_CHECKLIST_ITEM');
                }
            },
            'managechecklistitemgrid[itemId=manageCheckListItemGrid] button[itemId=btnEdit]': {
            	click: function(){
            		var isView = false; 
                	this.editCheckListItemFormWindow('MANAGE_CHECKLIST_ITEM', isView);
                }
            },
            'managechecklistitemgrid[itemId=manageCheckListItemGrid] button[itemId=btnView]': {
            	click: function(){
            		var isView = true; 
                	this.editCheckListItemFormWindow('MANAGE_CHECKLIST_ITEM', isView);
                }
            },
            'managechecklistitemgrid[itemId=manageCheckListItemGrid] button[itemId=btnDelete]': {
                click: this.deleteCheckListItemRecord
            },
            'completioncommonwindow managechecklistitemform[itemId=manageCheckListItemForm] button[itemId=submitButtonId]': {
                click: this.saveCheckListItem
            },
            'completioncommonwindow managechecklistitemform[itemId=manageCheckListItemForm] button[itemId=cancelButtonId]': {
                click: this.closeCompletionFormWindow
            },

            /**
             *  Manage Transaction Type
             */
            
            'managetransactiontypegrid[itemId=manageTransactionTypeGrid]': {
            	render: function(grid){
            		grid.getStore().load();
                }
            },
            'managetransactiontypegrid[itemId=manageTransactionTypeGrid] button[itemId=btnAdd]': {
            	click: function(){
                	this.showCompletionCommonWindow('MANAGE_TRANSACTION_TYPE');
                }
            },
            'managetransactiontypegrid[itemId=manageTransactionTypeGrid] button[itemId=btnEdit]': {
            	click: function(){
            		var isView = false; 
                	this.editTransactionTypeFormWindow('MANAGE_TRANSACTION_TYPE', isView);
                }
            },
            'managetransactiontypegrid[itemId=manageTransactionTypeGrid] button[itemId=btnView]': {
            	click: function(){
            		var isView = true; 
                	this.editTransactionTypeFormWindow('MANAGE_TRANSACTION_TYPE', isView);
                }
            },
            'managetransactiontypegrid[itemId=manageTransactionTypeGrid] button[itemId=btnDelete]': {
                click: this.deleteTransactionTypeRecord
            },
            'completioncommonwindow managetransactiontypeform[itemId=manageTransactionTypeForm] button[itemId=submitButtonId]': {
                click: this.saveTransactionType
            },
            'completioncommonwindow managetransactiontypeform[itemId=manageTransactionTypeForm] button[itemId=cancelButtonId]': {
                click: this.closeCompletionFormWindow
            },
            
            /**
             * listener to listen the render of the search panel and load the dropdowns.
             * loads the program Dropdown first.
             * @author Akshay.Kalbhor
             */
            'managecompletionsearchpanel': {
            	render: function( panel, eOpts ) {
            		this.loadProgramDropdown(panel);	
            	}
            },
            
            /**
             * listener to listen the select of the program combo from the search panel and load the batch dropdown.
             * loads the batch Dropdown.
             * @author Akshay.Kalbhor
             */
            'managecompletionsearchpanel combo#programCombo': {
            	select: function(combo, records, eOpts ) {
            		this.loadBatchCombo(combo, records);	
            	}
            },
            
            /**
             * listener to listen the button clicks of the search panel.
             * @author Akshay.Kalbhor
             */
            'managecompletionsearchpanel button': {
            	click: function(button) {
            		if(button.itemId === 'completionChecklistSearch') {
            			var searchPanel = button.up('managecompletionsearchpanel');
                		var grid = button.up('managecompletionsearchpanel').nextSibling();
                		this.loadCompletionChecklistGrid(grid, searchPanel);	
            		} else if(button.itemId === 'completionChecklistReset') {
            			var searchPanel = button.up('managecompletionsearchpanel');
            			searchPanel.getForm().reset();
            			searchPanel.down('#batchCombo').setDisabled(true);
            		}
            		
            	}
            },
            
            /**
             * Listener of the grid to fire a search on render.
             * @author Akshay.Kalbhor
             */
            'managecompletionchecklistpanel completionchecklistgrid': {
            	render: function(grid) {
            		var searchPanel = grid.up('panel#manageCompletionChecklistPanel').down('managecompletionsearchpanel');
            		this.loadCompletionChecklistGrid(grid, searchPanel);
            	}
            },
            
            /**
             * Listeners of buttons of the completionchecklistgrid. 
             * @author Akshay.Kalbhor
             */
            'completionchecklistgrid #add_checklist': {
            	click: function(button) {
            		var grid = button.up('grid');
        			if(grid.getSelectionModel().getCount()>0){
            			var window = this.showCompletionCommonWindow('MAP_ITEM_WITH_TRANSACTION');
            			this.loadCompletionChecklistRecord(grid, window, 'mapChecklistItems');
        	    	} else {
        	    		showWarningMessage(getCompletionModuleTranslation('COMPLETION_CHECKLISTS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        	    	}
            	}
            },
            'completionchecklistgrid #add_certificates': {
            	click: function(button) {
            		var grid = button.up('grid');
        			if(grid.getSelectionModel().getCount()>0){
        				var window = this.showCompletionCommonWindow('MAP_ITEM_WITH_TRANSACTION');
            			this.loadCompletionChecklistRecord(grid, window, 'mapCertificateItems');
        	    	} else {
        	    		showWarningMessage(getCompletionModuleTranslation('COMPLETION_CERTIFICATE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        	    	}
            	}
            },
            'completionchecklistgrid #edit_checklist': {
            	click: function(button) {
            		var grid = button.up('grid');
                    var records = grid.getSelectionModel().getSelection()[0];
                    if(isNullOrEmpty(records)){
                    	showWarningMessage(getCompletionModuleTranslation('COMPLETION_CHECKLISTS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
           		 		return false;
           		 	} else {
           		 	var transactionTypeId = records.get('transactionTypeId');
                    var completionChecklistId = records.get('completionChecklistId');
                    if(!isNullOrEmpty(transactionTypeId) && !isNullOrEmpty(completionChecklistId)){
                    	var window = this.showCompletionCommonWindow('MAP_ITEM_WITH_TRANSACTION');
                		this.editCompletionRecord(grid, window, 'mapChecklistItems');
                    } else {
        	    			showWarningMessage(getCompletionModuleTranslation('COMPLETION_CHECKLISTS'), getCompletionModuleTranslation('PLEASE_ADD_TRANSACTION_TYPE'));
                    	}
           		 	}
            	}
            },
            'completionchecklistgrid #edit_certificates': {
            	click: function(button) {
            		var grid = button.up('grid');
            		 var records = grid.getSelectionModel().getSelection()[0];
            		 if(isNullOrEmpty(records)){
                     	showWarningMessage(getCompletionModuleTranslation('COMPLETION_CHECKLISTS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
            		 } else {
            		 var transactionTypeId = records.get('transactionTypeId');
                     var completionChecklistId = records.get('completionChecklistId');
                     if(!isNullOrEmpty(transactionTypeId) && !isNullOrEmpty(completionChecklistId)){
                    	 var window = this.showCompletionCommonWindow('MAP_ITEM_WITH_TRANSACTION');
                    	 this.editCompletionRecord(grid, window, 'mapCertificateItems');
                     } else {
             	    		showWarningMessage(getCompletionModuleTranslation('COMPLETION_CHECKLISTS'), getCompletionModuleTranslation('PLEASE_ADD_TRANSACTION_TYPE'));
                      	}
            		 }
            	}
            },  
            'completionchecklistgrid #deleteTransactionType': {
            	click: this.deleteCompletionRecord
            },
            
            /**
             * listeners of the template columns of the grid.
             * @author Akshay.Kalbhor
             */
            'completionchecklistgrid templatecolumn#checklistItemCount': {
            	click: function(grid) {
            		this.showChecklistItems(grid);
            	}
            },
            
            /**
             * listeners of the template columns of the grid.
             * @author Akshay.Kalbhor
             */
            'completionchecklistgrid templatecolumn#certificateCount': {
            	click: function(grid) {
            		this.showCertificateItems(grid);
            	}
            },
            
            /**
             * listeners of the buttons of the mapitemwithtransactionform popup
             * @author Akshay.Kalbhor
             */
            'mapitemwithtransactionform button': {
            	click: function(button) {
            		if(button.itemId === 'itemSubmitButtonId') {
            			this.updateChecklistItem(button);
            		}else if(button.itemId === 'cancelButtonId') {
            			button.up('window').close();
            		}
            	}
            },
            
          /*  *//**
             * listeners of the buttons of the mapcertificatewithtransactionform popup
             * @author Akshay.Kalbhor
             *//*
            'mapcertificatewithtransactionform button': {
            	click: function(button) {
            		if(button.itemId === 'certificateSubmitButtonId') {
            			this.updateChecklistItem(button);
            		}else if(button.itemId === 'cancelButtonId') {
            			button.up('window').close();
            		}
            	}
            },
            */
            'completionchecklistgrid' : {
            	render : function(grid){
            		this.disableMoreActionPivileges(grid, this.getCOMPLETION_SETTING_PERMISSIONS());
            	}
            },
            
        	'mapitemwithtransactionform  combo[itemId=checklistTransactionTypeCombo]' : {
        		change : this.loadCheckListItemSelectorStore
        	}
        });
    },
    /**
     * On selection/change get mapped checklist item with transaction type
     * and set to item selector
     */
    getMappedChecklistTransactionType : function(combo, record){
    	var this$ = this;
    	var id = combo.getValue();
    	var form = this.getMapChecklistWithTransactionTypeForm();
    	var itemSelector = form.down('#mapChecklistItemSelector');
    	itemSelector.setDisabled(false);
    	itemSelector.getStore().removeAll();
    	itemSelector.reset();
    	//if(records.length>0){
			this$.sendGetAjaxRequest(SERVERURL.GET_MAPPED_CHECKLIST_WITH_TRANSACTION_TYPE + id, 'GET', null, function(option, success, response) {
	    		if(success){
	    			if(!isNullOrEmpty(response.responseText)){
	    			var data = Ext.decode(response.responseText);
	    			var array = new Array();
	    			for(var i = 0; i < data.length; i++){
	    				array.push(data[i].id);
	    			}	
	    			
	    			itemSelector.getStore().load({
	    	    		callback: function(records, operation, success){
	    	    			if(array.length>0){
	    	    				itemSelector.setValue(array);
	    	    			}   
	    	    		}
	    	    	});    	
	    			 	    		    			
    	    		}
    	    	}				    	    		
    	    });    	    				
		//}
    		
    },
    /**
     * On selection/change get mapped certificate item with transaction type
     * and set to item selector
     */
    getMappedCertificateTransactionType : function(combo, record){
    	var this$ = this;
    	var id = combo.getValue();
    	var form = this.getMapCertificateWithTransactionTypeForm();
    	var itemSelector = form.down('#mapCertificateItemSelector');
    	itemSelector.setDisabled(false);
    	itemSelector.getStore().removeAll();
    	itemSelector.reset();    	
    			itemSelector.getStore().load({
    				params:{
						certificateCategory:'PROGRAM'
					},
    	    		callback: function(records, operation, success){
    	    			if(records.length>0){
    	    				this$.sendGetAjaxRequest(SERVERURL.GET_MAPPED_CERTIFICATE_WITH_TRANSACTION_TYPE + id, 'GET', null, function(option, success, response) {
    	    		    		if(success){
    	    		    			if(!isNullOrEmpty(response.responseText)){
    	    		    			var data = Ext.decode(response.responseText);
    	    		    			var array = new Array();
    	    		    			for(var i = 0; i < data.length; i++){
    	    		    				array.push(data[i].id);
    	    		    			}	
    	    		    			if(array.length>0){
    	    		    				itemSelector.setValue(array);
    	    		    			}    	    		    			
				    	    		}
				    	    	}				    	    		
				    	    });    	    				
    	    			}
    	    		}
    	    	});    		
    },
    /**
     *  Save mapped checklist item with transaction type
     */
    saveMappedChecklistItemWithTransactionType : function(btn){
    	var this$ = this;
    	btn.setDisabled(true);
    	var form = this.getMapChecklistWithTransactionTypeForm();
    	var formaData = form.getForm().getValues();
    	var jsonFormatData = new Object();
    	jsonFormatData.transactionTypeId = formaData.transactionType.id;
    	jsonFormatData.checklistItems = formaData.checklistItems;
    	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    	 
    	this$.sendSaveAjaxRequest(SERVERURL.ADD_MAPPED_CHECKLIST_WITH_TRANSACTION_TYPE, 'POST', jsonFormatData, function(option, success, response) {
        	if(success){
        		Ext.getBody().unmask();
        		btn.setDisabled(false);
        		showSuccessMessage(getCompletionModuleTranslation('MAP_CHECKLIST_WITH_TRANSACTION_TYPE'), getCompletionModuleTranslation('MAP_CHECKLIST_ITEM_SUCCESS'));
    		}
    	});
    },
    /**
     *  Save mapped certificate item with transaction type
     */
    saveMappedCertificateItemWithTransactionType : function(btn){
    	var this$ = this;
    	btn.setDisabled(true);
    	var form = this.getMapCertificateWithTransactionTypeForm();
    	var formaData = form.getForm().getValues();
    	var jsonFormatData = new Object();
    	jsonFormatData.transactionTypeId = formaData.transactionType.id;
    	jsonFormatData.certificates= formaData.certificates;
    	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    
    	this$.sendSaveAjaxRequest(SERVERURL.ADD_MAPPED_CERTIFICATE_WITH_TRANSACTION_TYPE, 'POST', jsonFormatData, function(option, success, response) {
        	if(success){
        		btn.setDisabled(false);
        		 Ext.getBody().unmask();
        		showSuccessMessage(getCompletionModuleTranslation('MAP_CERTIFICATE_WITH_TRANSACTION_TYPE'), getCompletionModuleTranslation('MAP_CERTIFICATE_ITEM_SUCCESS'));
    		}
    	});
    },
    /**
     *  Show completion form window
     */
    showCompletionCommonWindow : function(formType){
    	var this$ = this;
    	var title = null, xtypeForm = null, xTypeItemId = null;
    	var formWindow = this$.getCompletionCommonWindow();
    	if(!formWindow){
    		switch(formType){
        	
	    		case 'MANAGE_CHECKLIST_ITEM' : {//Manage CheckList Item
	    			title = getCompletionModuleTranslation('MANAGE_CHECKLIST_ITEM');
					xtypeForm = 'managechecklistitemform';
		    		xTypeItemId = 'manageCheckListItemForm';
		    		break;
		    	}
	    		case 'MANAGE_TRANSACTION_TYPE' : {//Manage Transaction Type
		    		title = getCompletionModuleTranslation('MANAGE_TRANSACTION_TYPE');
		    		xtypeForm = 'managetransactiontypeform';
		    		xTypeItemId = 'manageTransactionTypeForm';
		    		break;
		    	}
	    		case 'MAP_ITEM_WITH_TRANSACTION' : {//Map Item With Transaction
		    		title = getCompletionModuleTranslation('MAP_ITEM_WITH_TRANSACTION');
		    		xtypeForm = 'mapitemwithtransactionform';
		    		xTypeItemId = 'mapItemWithTransactionForm';
		    		break;
		    	}
	    		case 'MAP_CERTIFICATE_WITH_TRANSACTION': {
	    			title = getCompletionModuleTranslation('MAP_CERTIFICATE_WITH_TRANSACTION');
		    		xtypeForm = 'mapcertificatewithtransactionform';
		    		xTypeItemId = 'mapCertificateWithTransactionForm';
		    		
		    		break;
	    		}
		    	default :{
		    		break;
		    	}
    		}
    		
    		formWindow = Ext.widget('completioncommonwindow',{
        		title: title,
        		itemId : 'completionCommonWindow',
        		items: [{
        			 xtype: xtypeForm,
        		     itemId: xTypeItemId
        		}]
        	});
    	}
    	formWindow.show();
    	return formWindow;
    },

    /**
     *  close completion form window
     */
    closeCompletionFormWindow: function() {
        var this$ = this;
        this$.getCompletionCommonWindow().close();
    },
    /**
     *  Get Json for form submission
     */
    getJsonSubmitData: function(form) {

        var jsonFormFieldData = new Object();
        var formData = form.getValues();
        jsonFormFieldData = Ext.encode(formData);
        return jsonFormFieldData;
    },
    
    /**
     *  View/Edit checkList item form window
     */
    editCheckListItemFormWindow: function(formType, isView) {

        var this$ = this;
        var grid = this$.getManageCheckListItemGrid();

        if (grid.getSelectionModel().getCount() > 0) {
            this$.showCompletionCommonWindow(formType);
            var form = this$.getManageCheckListItemForm();
            if (isView) {
                form.down('#submitButtonId').setVisible(false);
                form = form.getForm();
                toggleReadOnlyFormItems(form, true);
            }
            var records = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(records)) {
            	console.log(records)
                form.loadRecord(records);
            }
        } else {
            showWarningMessage(getCompletionModuleTranslation('COMPLETION_SETTINGS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    /**
     *  delete checkList item record
     */
    deleteCheckListItemRecord: function() {

        var this$ = this;
        var grid = this$.getManageCheckListItemGrid();

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getCompletionModuleTranslation('COMPLETION_SETTINGS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                id = records[count].get("id");
                            }
                            Ext.Ajax.request({
                                type: 'rest',
                                url: SERVERURL.COMPLETION_CHECKLIST_ITEM_DELETE + id,
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                success: function(form, action) {
                                    grid.getStore().reload();
                                    showSuccessMessage(getCompletionModuleTranslation('COMPLETION_SETTINGS'), getCompletionModuleTranslation('CHECKLIST_ITEM_DELETE_SUCCESS'));
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getCompletionModuleTranslation('COMPLETION_SETTINGS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }

    },
    /**
     *  save checkList item
     */
    saveCheckListItem: function() {

        var this$ = this;
        var form = this$.getManageCheckListItemForm();
        var grid = this$.getManageCheckListItemGrid();

        var submitUrl, methodType, isUpdate = false;
        var id = form.down('#checklist_hidden_field');
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = SERVERURL.COMPLETION_CHECKLIST_ITEM_CREATE,
            methodType = 'POST';
            isUpdate = false;
        } else {
            submitUrl = SERVERURL.COMPLETION_CHECKLIST_ITEM_UPDATE,
            methodType = 'PUT';
            isUpdate = true;
        }
        var jsonFormatFormData = this$.getJsonSubmitData(form);
        this$.applyWindowMask(); 
       
        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,
            jsonData: jsonFormatFormData,
            method: methodType,
            success: function(form, action) {
            	 this$.hideWindowMask();
                this$.closeCompletionFormWindow();
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();
                if (isUpdate) {
                    showSuccessMessage(getCompletionModuleTranslation('COMPLETION_SETTINGS'), getCompletionModuleTranslation('CHECKLIST_ITEM_UPDATE_SUCCESS'));
                } else {
                    showSuccessMessage(getCompletionModuleTranslation('COMPLETION_SETTINGS'), getCompletionModuleTranslation('CHECKLIST_ITEM_ADD_SUCCESS'));
                }
            },
            failure: function(form, action) {
                this$.closeCompletionFormWindow();
                grid.getStore().reload();
            }
        });

    },

    /**
     *  edit transaction type form window
     */
    editTransactionTypeFormWindow: function(formType, isView) {

        var this$ = this;
        var grid = this$.getManageTransactionTypeGrid();

        if (grid.getSelectionModel().getCount() > 0) {
        	this$.showCompletionCommonWindow(formType);
            var form = this$.getManageTransactionTypeForm();
            if (isView) {
                form.down('#submitButtonId').setVisible(false);
                form = form.getForm();
                toggleReadOnlyFormItems(form, true);
            }
            var records = grid.getSelectionModel().getSelection()[0];
            if (!isEmpty(records)) {
                form.loadRecord(records);
            }
        } else {
            showWarningMessage(getCompletionModuleTranslation('COMPLETION_SETTINGS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },
    
    /**
     *  delete transaction type record
     */
    deleteTransactionTypeRecord: function() {

        var this$ = this;
        var grid = this$.getManageTransactionTypeGrid();

        if (grid.getSelectionModel().getCount() > 0) {
            showConfirmMessage(getCompletionModuleTranslation('COMPLETION_SETTINGS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                if (btn == 'yes') {
                    if (grid.getSelectionModel().getCount() > 0) {
                        var records = grid.getSelectionModel().getSelection();
                        for (var count = 0; count < records.length; count++) {
                            var id = "";
                            if (!isNullOrEmpty(records[count].get("id"))) {
                                id = records[count].get("id");
                            }
                            Ext.Ajax.request({
                                type: 'rest',
                                url: SERVERURL.COMPLETION_TRANSACTION_TYPE_DELETE + id,
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                success: function(form, action) {
                                    grid.getStore().reload();
                                    showSuccessMessage(getCommonTranslation('SUCCESS'), getCompletionModuleTranslation('TRANSACTION_TYPE_DELETE_SUCCESS'));
                                }
                            });
                        }
                    }
                }
            });
        } else {
            showWarningMessage(getCompletionModuleTranslation('COMPLETION_SETTINGS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }

    },
    /**
     *  save transaction type
     */
    saveTransactionType: function(model, records) {

        var this$ = this;
        var form = this$.getManageTransactionTypeForm();
        var grid = this$.getManageTransactionTypeGrid();

        var submitUrl, methodType, isUpdate = false;
        var id = form.down('#transaction_hidden_field');
        if (isNullOrEmpty(id.getSubmitValue())) {
            submitUrl = SERVERURL.COMPLETION_TRANSACTION_TYPE_CREATE,
            isUpdate = false;
            methodType = 'POST';
        } else {
            submitUrl = SERVERURL.COMPLETION_TRANSACTION_TYPE_UPDATE,
            isUpdate = true;
            methodType = 'PUT';
        }
        var jsonFormatFormData = this$.getJsonSubmitData(form);
        Ext.Ajax.request({
            type: 'rest',
            url: submitUrl,
            jsonData: jsonFormatFormData,
            method: methodType,
            success: function(form, action) {
                this$.closeCompletionFormWindow();
                grid.getStore().reload();
                grid.getSelectionModel().deselectAll();
                if (isUpdate) {
                    showSuccessMessage(getCompletionModuleTranslation('COMPLETION_SETTINGS'), getCompletionModuleTranslation('TRANSACTION_TYPE_UPDATE_SUCCESS'));
                } else {
                    showSuccessMessage(getCompletionModuleTranslation('COMPLETION_SETTINGS'), getCompletionModuleTranslation('TRANSACTION_TYPE_ADD_SUCCESS'));
                }
            },
            failure: function(form, action) {
                this$.closeCompletionFormWindow();
                grid.getStore().reload();
            }
        });

    },
    
    /**
     * Code to load the program combo which is in the search panel.
     * @author Akshay.Kalbhor
     */
    loadProgramDropdown: function(panel) {
    	var programCombo = panel.down('combo#programCombo');
    	var programComboStore = programCombo.getStore();
    	
    	var academyLocationId = this.getCurrentAcademyLocation();
    	var url = programComboStore.getProxy().proxyConfig.api.read;
            url = url.concat('?academyLocationId=' + academyLocationId);
        programComboStore.getProxy().api.read = url;
        programComboStore.reload();
    },
    
    /**
     * method to load the batch combo of the search panel;
     * @author Akshay.Kalbhor
     */
    loadBatchCombo: function(combo, records) {
    	var batchCombo = combo.nextSibling('combo#batchCombo');
    	batchCombo.clearValue();
    	batchCombo.setDisabled(false);
    	batchCombo.store.removeAll();
    	var batchComboStore = batchCombo.getStore();
    	var programId = records[0].get('id');
    	
    	var batchUrl = batchComboStore.getProxy().proxyConfig.api.read;
     	batchUrl = batchUrl.concat('?id=' +programId);
     	batchComboStore.getProxy().api.read = batchUrl;
     	batchComboStore.reload();
    },
    
    /**
     * Code to load the checklist grid on click of the search button. 
     * @author Akshay.Kalbhor
     */
    loadCompletionChecklistGrid: function(checklistGrid, searchPanel) {
    	
		var academyLocationId = this.getCurrentAcademyLocation();
		var programId = searchPanel.down('combo#programCombo').getValue();
		var batchId = searchPanel.down('combo#batchCombo').getValue();
		var store = checklistGrid.getStore();
		store.getProxy().extraParams= {
			academyLocationId : academyLocationId,
		    programId : programId,
		    batchId : batchId
		 };
		 store.load();
    },
    
    /**
     * code to load the grid record into the popup and load the corresponding values in the checklistItems
     * itemselector or certificate itemselector.
     * method is called on the click of the buttons "Map Checklist Items" and "Map Certificates"
     * present on the CompletionChecklistGrid. 
     * @author Akshay.Kalbhor
     */
    loadCompletionChecklistRecord: function(grid, window, source) {
    	var form = window.down('form');
    	var selectedRecord = grid.getSelectionModel().getSelection()[0];
    	var recordData = selectedRecord;
     	this.setItemSelectorAsPerSource(source, form);
     	var cmb = form.down('#checklistTransactionTypeCombo');
     	var completionChecklistId = selectedRecord.get('completionChecklistId');
     	if(source === 'mapChecklistItems'){
     		this.loadTransactionTypesCombo(cmb, completionChecklistId, true);
     	}else{
     		this.loadTransactionTypesCombo(cmb, completionChecklistId, false);
     	}
        delete recordData.data.transactionType;
		form.loadRecord(recordData);
    },
    
    /**
     * This method is used to set itemSelector of certificate & checkList
     * @param source
     * @param form
     * @author pritam.patil
     */
    setItemSelectorAsPerSource : function(source,form){
    	
    	if(source === 'mapChecklistItems'){
    		form.down('#certificates').setDisabled(true);
    		form.down('#certificates').setVisible(false);
    		form.down('#checklistItems').setDisabled(false);
    		form.down('#checklistItems').setVisible(true);
    		form.down('#checklistItems').reset();
    	}else{
    		form.down('#certificates').setDisabled(false);
    		form.down('#certificates').setVisible(true);
    		form.down('#certificates').reset();
    		form.down('#checklistItems').setDisabled(true);
    		form.down('#checklistItems').setVisible(false);
    		}
    },
    
    /**
     * This method is used to load cheklist & certificate Item Selector 
     * @param completionChecklistId
     * @param transactionTypeId
     * @param component
     * @author pritam.patil
     */
    loadChecklistAndCertificateItemSelectors: function(completionChecklistId, transactionTypeId, component) {
    	var dataUrl = null;
    	if(component.getItemId() === 'checklistItems') {
    		dataUrl = SERVERURL.GET_CHECKLIST_ITEMS_BY_TRANSACTION_TYPE;	
    	} else {
    		dataUrl = SERVERURL.GET_CERTIFICATES_BY_TRANSACTION_TYPE;
    	}
    	
    	dataUrl = dataUrl.concat('?completionChecklistId='+completionChecklistId);
    	dataUrl = dataUrl.concat('&transactionTypeId='+transactionTypeId);
    	
    	  Ext.Ajax.request({
              type: 'rest',
              method: 'GET',
              url: dataUrl, 
              success: function(response, action) {
            	  if(!isNullOrEmpty(response.responseText)){
            		var data = Ext.decode(response.responseText);
          			var valueArray = new Array();
          			Ext.each(data, function(value) {
          				valueArray.push(value.id);
          			});
          			component.setValue(valueArray);
            	  }            	  
              }
    	});
    	component.doLayout();	
    },
    
    /**
     * This is used to load check List & certificate item Selector 
     * @param cmb
     */
    loadCheckListItemSelectorStore: function(cmb) {
    	
    	var id = cmb.getValue();
    	var certificateItemSelector = cmb.up('form').down('#certificates');
       	if(certificateItemSelector.hidden === false){
	       	var url = certificateItemSelector.getStore().getProxy().proxyConfig.api.read;
			url = url.concat(id);
			certificateItemSelector.getStore().getProxy().api.read = url;
			certificateItemSelector.getStore().removeAll();
			certificateItemSelector.reset();
			certificateItemSelector.getStore().load();
			
    	}else{
    		var itemSelector = cmb.up('form').down('#checklistItems');
	    	var url = itemSelector.getStore().getProxy().proxyConfig.api.read;
			url = url.concat(id);
			itemSelector.getStore().getProxy().api.read = url;
			itemSelector.getStore().removeAll();
			itemSelector.reset();
			itemSelector.getStore().reload();
    	}
    },
    
    /**
     * This function will load the Checklist Items into the popup which will be shown on the click of the
     * Check list Items link present in the CompletionChecklistGrid.
     * @author Akshay.Kalbhor
     */
    showChecklistItems: function(grid) {
    	var this$ = this;
    	var selectedRecord = grid.getSelectionModel().getSelection()[0];
    	var completionChecklistId = selectedRecord.get('completionChecklistId');
    	var transactionTypeId = selectedRecord.get('transactionTypeId');
    	if(parseInt(selectedRecord.get('checklistItemCount')) != 0 && !isNullOrEmpty(selectedRecord.get('checklistItemCount'))) {
    		var popup = this$.showWindow('checklistcertificatepopup');
        	popup.setTitle(getCompletionModuleTranslation('CHECK_LIST')),
        	templateContainer = popup.down('dataview#checklistCertificateTemplate');
        	var store = templateContainer.getStore();
        	
        	var url = SERVERURL.GET_CHECKLIST_ITEMS_BY_TRANSACTION_TYPE;
        	url = url.concat('?completionChecklistId='+completionChecklistId);
        	url = url.concat('&transactionTypeId='+transactionTypeId);
        	store.getProxy().api.read = url;
        	store.load(); 
    	}
    },

    /**
     * This function will load the certificate items into the popup which will be shown on the click of the
     * certificate link present in the CompletionChecklistGrid.
     * @author Akshay.Kalbhor
     */
    showCertificateItems: function(grid) {
    	var this$ = this;
    	var selectedRecord = grid.getSelectionModel().getSelection()[0];
    	var completionChecklistId = selectedRecord.get('completionChecklistId');
    	var transactionTypeId = selectedRecord.get('transactionTypeId');
    	if(parseInt(selectedRecord.get('certificateCount')) != 0 && !isNullOrEmpty(selectedRecord.get('certificateCount'))) {
	    	var popup = this$.showWindow('checklistcertificatepopup');
	    	popup.setTitle(getCompletionModuleTranslation('CERTIFICATE')),
	    	templateContainer = popup.down('dataview#checklistCertificateTemplate');
	    	var store = templateContainer.getStore();
	    	
	    	var url = store.getProxy().proxyConfig.api.read;
	    	url = url.concat('?completionChecklistId='+completionChecklistId);
	    	url = url.concat('&transactionTypeId='+transactionTypeId);
	    	store.getProxy().api.read = url;
	    	store.load();    
    	}
    },
    
    /**
     * Code to update the mapped items of the checklist and certificates.
     * called on the click of the submit buttons of the popup which is opened from the "Map Checklist Items" and "Map Certificates"
     * buttons present on the CompletionChecklistGrid. 
     * @author Akshay.Kalbhor
     */
    updateChecklistItem: function(button) {
    	var form = button.up('form');
    	var jsonFormatData = form.getValues();
    	var completionChecklistGrid = this.getCompletionChecklistGrid();
    	var selectedRecord = completionChecklistGrid.getSelectionModel().getSelection()[0];
    	jsonFormatData.academyLocation = selectedRecord.get('academyLocation');
    	jsonFormatData.batch = selectedRecord.get('batch');
    	jsonFormatData.program = selectedRecord.get('program');
    	jsonFormatData.seatType = selectedRecord.get('seatType');
    	jsonFormatData.id = selectedRecord.get('completionChecklistId');
    	jsonFormatData.progBatchSeatConfId = selectedRecord.get('progBatchSeatConfId');
    	
    	var transactionTypeId =  jsonFormatData.transactionType.id;
    	
    	var selectedItems = form.down('itemselector#checklistItems').getValue();
    	var transactionTypeCkItems = this.getSelectedItemsArray(selectedItems,transactionTypeId,null);
    	var certificateSelector = form.down('itemselector#certificates');
    	
    	selectedItems = form.down('itemselector#certificates').getValue();
    	var transactionTypeCertificateItems = this.getSelectedItemsArray(selectedItems,transactionTypeId ,certificateSelector);
    	
    	delete jsonFormatData.transactionType;
    	
    	if(!isNullOrEmpty(transactionTypeCkItems)) {
    		jsonFormatData.transactionTypeChecklistItems = transactionTypeCkItems;
    	}
    	
    	if(isNullOrEmpty(jsonFormatData.transactionTypeCertificates)){
    		jsonFormatData.transactionTypeCertificates =null;
    	}else{
    		jsonFormatData.transactionTypeCertificates = transactionTypeCertificateItems;
    	}
    	
    	var url = null;
    	  if(jsonFormatData.isEdit === 'true'){
              url = SERVERURL.COMPLETION_CHECKLIST_UPDATE_CHECKLIST;
              method = 'PUT';
    	  }else{
              url = SERVERURL.COMPLETION_CHECKLIST_CREATE_CHECKLIST;
              method = 'POST';
    	  }
    	delete jsonFormatData.isEdit ;
    	submitData = Ext.encode(jsonFormatData);
    	console.log(submitData);
    	 this.applyWindowMask(); 
    	this.sendSaveAjaxRequest(url, method, submitData, function(option, success, response) {
        	if(success){
        		if(!isNullOrEmpty(transactionTypeCkItems)) {
        			showSuccessMessage(getCompletionModuleTranslation('MAP_CHECKLIST_WITH_TRANSACTION_TYPE'),getCompletionModuleTranslation('TRANSACTION_TYPE_UPDATE_SUCCESS'));
            	} else {
            		showSuccessMessage(getCompletionModuleTranslation('MAP_CERTIFICATE_WITH_TRANSACTION_TYPE'),getCompletionModuleTranslation('TRANSACTION_TYPE_UPDATE_SUCCESS'));
            	};
        		completionChecklistGrid.getStore().reload();
        		button.up('window').close();
    		}
        	this.hideWindowMask();
    	});
    },
    
    getSelectedItemsArray: function(selectedItems,transactionTypeId,certificate) {
    	var transactionTypeCkItems = new Array();
    	Ext.each(selectedItems, function(item) {
    		var a = new Object();
    		
    		if(certificate){
    			a.certificate =item;
    		}else{
    			a.checklistItem = item;
    			
    		}
    		a.transactionType = transactionTypeId;
    		transactionTypeCkItems.push(a);
    	});
    	
    	return transactionTypeCkItems;
    },
    /**
     * @author Pravin.Surve
     * This function is to enable more action button
     */
    disableMoreActionPivileges: function(gridReference,permissionsMap) {
       	var associatedAcadLocationIds = new Array();
   		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
   		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
   		var grid = this.getCompletionChecklistGrid();
   		var mapChecklistButton = grid.down("#mapChecklistItems");//itemId of split button
   		var mapCertificateButton = grid.down('#mapCertificateItems');
        	
   		mapChecklistButton.setVisible(false);
   		mapCertificateButton.setVisible(false);
       	 
       	Ext.each(permissionList, function(privilege) {
       		if (privilege === 'MAPCHECKLIST') {
           		if(!isNullOrEmpty(mapChecklistButton)){
           			mapChecklistButton.setVisible(true);//enable more action button
           		}        		
           	}else if(privilege === 'MAPCERTIFICATE'){
           		if(!isNullOrEmpty(mapCertificateButton)){
           			mapCertificateButton.setVisible(true);
           		}
           	}
       	});
       },
       
       /**
        * This method is used to load transaction types combo 
        */
       loadTransactionTypesCombo : function(cmb,id,isChecklist){
    	   
    	   var store = cmb.getStore();
    	   store.getProxy().api.read = SERVERURL.COMPLETION_TRANSACTION_TYPE;
    	   store.getProxy().extraParams={
    		   id: id,
    	       isChecklist : isChecklist
    	   };
    	   store.load();
       },
       
       /**
        * This is used to edit completion checklist & certificate 
        * @param grid 
        * @param window 
        * @param source
        */
       editCompletionRecord : function (grid,window,source){
           var form = window.down('form');
           var flag = form.down('#isEditId') ;
           flag.setValue('true');
           
           var records = grid.getSelectionModel().getSelection()[0];
    	
           var transactionTypeId = records.get('transactionTypeId');
           var completionChecklistId = records.get('completionChecklistId');
           var checklistItemsItemSelector = form.down('#checklistItems');
           var certificateItemsItemSelector = form.down('#certificates');
           var transactionTypeCmb = form.down('#checklistTransactionTypeCombo');
           var store = transactionTypeCmb.getStore();
           store.getProxy().api.read  = SERVERURL.COMPLETION_TRANSACTION_TYPE_GRID_DATA ;
           this.setItemSelectorAsPerSource(source, form);
        	   if (!isEmpty(records)) {
            	   
            	   store.load({
            		   callback : function (records,opt,success){
            			   if(success){  
            				   transactionTypeCmb.setValue(transactionTypeId);
            			   }
            		   }
            	   });
                   form.loadRecord(records);
                   transactionTypeCmb.setReadOnly(true);
                   if(source === 'mapChecklistItems'){
                	   this.loadChecklistAndCertificateItemSelectors(completionChecklistId, transactionTypeId, checklistItemsItemSelector);
                   }else{
                	   this.loadChecklistAndCertificateItemSelectors(completionChecklistId, transactionTypeId, certificateItemsItemSelector);
                   }
               }
       },
       
       /**
        * this method is usd to delete completion cheklist / certificate record
        */
       deleteCompletionRecord: function(button) {

           var grid = button.up('grid');
           if (grid.getSelectionModel().getCount() > 0) {
        	   var records = grid.getSelectionModel().getSelection();
               var transactionType	= records[0].data.transactionType ;
               if(transactionType){
               showConfirmMessage(getCompletionModuleTranslation('COMPLETION_SETTINGS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                   if (btn == 'yes') {
                       if (grid.getSelectionModel().getCount() > 0) {
                           var id = records[0].data.completionChecklistId;
                           var transactionTypeId = records[0].data.transactionType.id;
                           var param = {
                        		   id : id,
                        		   transactionTypeId : transactionTypeId
                           };
                               Ext.Ajax.request({
                                   type: 'rest',
                                   url: SERVERURL.COMPLETION_CHECKLIST_DELETE_CHECKLIST ,
                                   method: 'GET',
                                   params: param,
                                   success: function(form, action) {
                                       grid.getStore().reload();
                                       showSuccessMessage(getCommonTranslation('SUCCESS'), getCompletionModuleTranslation('DELETE_SUCCESS'));
                                   }
                               });
                           }
                       }
               });
               }else{
            	   showInfoMessage(getCompletionModuleTranslation('COMPLETION_SETTINGS'), getCompletionModuleTranslation('CAN_NOT_DELETE'));
               }
           } else {
               showWarningMessage(getCompletionModuleTranslation('COMPLETION_SETTINGS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
           }
       }
});
