/**
 * @author Ankur Jaiswal
 */
Ext.define('Academia.controller.configureloader.ConfigureLoaderController', {
    extend: 'Academia.controller.base.BaseController',
    stores: ['common.TerminologyStore',
       // 'importutility.ModuleName',
        'configureloader.AcademyLocationByTerminologyStore',
        'configureloader.ConfigureLoaderGridStore',
        'configureloader.CLMandatoryOptionalStore',
        'common.YesNoDynamicFormCombo',
        'importutility.LoaderConfiguredModuleNameStore'
    ],
    views: ['configureloader.ConfigureLoaderStructure',
        'configureloader.ConfigureLoaderFilter',
        'configureloader.ConfigureLoaderGrid',
        'configureloader.ConfigureLoaderGridWindow'
    ],
    models: [],
    refs: [{
        ref: 'configureloaderfilter',
        selector: 'configureloaderfilter'
    }, {
        ref: 'configureloadergridwindow',
        selector: 'configureloadergridwindow'
    }, {
        ref: 'configureloadergrid',
        selector: 'configureloadergrid'
    }],
    config: {},
    init: function() {
        this.control({
        	'configureloadergrid': {
        		beforerender: function(component) {
        			this.getStore('configureloader.ConfigureLoaderGridStore').removeAll();
        		}
        	},
            'configureloaderfilter button[itemId=resetConfigureLoaderFilterItemId]': {
                click: function() {
                    var filter = this.getConfigureloaderfilter();
                    filter.getForm().reset();
                }
            },
            'configureloaderfilter label[itemId=viewLinkedItemId]': {
                render: function(component) {
                    var $this = this;
                    component.getEl().on('click', function(e) {
                        if (e.target.tagName == 'A') {
                            $this.openLinkedAcademyLocationWindow();
                        }
                    });
                }
            },
            'configureloaderfilter button[itemId=searchConfigureLoaderFilterItemId]': {
                click: function() {
                    this.loadLoaderHeaderGrid();
                }
            },
            'configureloadergrid button[itemId=saveBtnItemId]': {
   			 click: function() {
   				 this.saveConfigureLoaderData();
   			 }
   		 }
        });
    },
    openLinkedAcademyLocationWindow: function() {
        var $this = this;
        var filter = $this.getConfigureloaderfilter();
        var terminologyItemId = filter.down('#terminologyItemId');

        if (!isNullOrEmpty(terminologyItemId.getValue())) {
            var formWindow = $this.getConfigureloadergridwindow();
            if (!formWindow) {
                Ext.widget('configureloadergridwindow');
                formWindow = $this.getConfigureloadergridwindow();
            }
            var configureLoaderGrid = formWindow.down('#configureLoaderGridItemId');
            var store = configureLoaderGrid.getStore();

            store.getProxy().extraParams = {
                terminology: terminologyItemId.getValue()
            };
            store.load();
            formWindow.show();
        } else {
            showWarningMessage(getCommonTranslation('CL_CONFIGURE_LOADER'), getCommonTranslation('CL_PLEASE_SELECT_TERMINOLOGY'));
        }

    },
    loadLoaderHeaderGrid: function() {
        var $this = this;
        var filter = $this.getConfigureloaderfilter();
        var terminologyItemId = filter.down('#terminologyItemId');
        var loaderTypeItemId = filter.down('#loaderTypeItemId');
        var loaderTypeStore = loaderTypeItemId.getStore();
        var loaderId = loaderTypeItemId.getValue();
        var importUtilityMasterCode = loaderTypeStore.findRecord('id', loaderId,null,false,false, true).data.code;
        var configureLoaderGrid = $this.getConfigureloadergrid();
        var store = configureLoaderGrid.getStore();
        store.getProxy().extraParams = {
            terminology: terminologyItemId.getValue(),
            loaderCode: importUtilityMasterCode
        };
        store.load();
    },
    saveConfigureLoaderData: function() {
        var $this = this;
        var grid = $this.getConfigureloadergrid();
        var record = grid.getSelectionModel().getSelection();
        var filter = $this.getConfigureloaderfilter();
        var terminologyItemId = filter.down('#terminologyItemId');
        var loaderId = filter.down('#loaderTypeItemId').getValue();
        var isSchool = true;;
        if (terminologyItemId.getValue() == 'COLLEGE') {
            isSchool = false;
        }
        var configureArray = [];
        var flag = true;
        for (var i = 0; i < record.length; i++) {
           /* if (record[i].data.isMandatory == 'Mandatory') {
                if (record[i].data.isVisible == 'No') {
                    if (isNullOrEmpty(record[i].data.defaultValue)) {
                     //   flag = false;
                        break;
                    }
                }
            }*/
            var importUtilityMasterId = new Object();
            importUtilityMasterId.id = loaderId;
            var mainData = new Object();
            mainData.id = record[i].data.id;
            mainData.headerLabel = record[i].data.headerLabel;
            mainData.defaultValue = record[i].data.defaultValue;
            mainData.isSchool = isSchool;
            mainData.importUtilityMasterId = importUtilityMasterId;
            mainData.isNonEditable = record[i].data.isNonEditable;
            if (record[i].data.isMandatory == 'Mandatory') {
                mainData.isMandatory = true;
            } else {
                mainData.isMandatory = false;
            }
            if (record[i].data.isVisible == 'Yes') {
                mainData.isVisible = true;
            } else {
                mainData.isVisible = false;
            }
            mainData.defaultHeaderLabel = record[i].data.defaultHeaderLabel;
            mainData.headerCode = record[i].data.headerCode;
            mainData.headerLabel = record[i].data.headerLabel;
            configureArray.push(mainData);
        }
        if (flag == true) {
            Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            Ext.Ajax.request({
                type: 'rest',
                url: SERVERURL.UPDATE_LOADER_HEADER_DETAILS,
                jsonData: configureArray,
                method: 'POST',
                success: function(form, action) {
                	if(form.responseText == 'SUCCESS') {
                		showSuccessMessage(getCommonTranslation('CL_CONFIGURE_LOADER'), getCommonTranslation('CONFIG_SAVED_SUCCESSFULLY'));
                	} else {
                		 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('CL_DUPLICATE_HEADER_LABEL'));
                	}
                	Ext.getBody().unmask();
            		grid.getSelectionModel().deselectAll(true);
            		grid.getStore().reload();
                }
            });
        } else {
            showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('CL_PLEASE_ENTER_DEFAULT_VALUE'));
            grid.getSelectionModel().deselectAll(true);
            grid.getStore().reload();
        }
    }
});