Ext.define('Academia.controller.course.courseEquivalence.CourseEquivalenceController', {
	extend: 'Academia.controller.base.BaseController',
	models : ['common.IdValueCodeDataModel','course.courseequivalence.CourseEquivalenceModel'],
	stores : ['course.courseequivalence.CourseEquivalenceStore','course.courseequivalence.CourseExceptCurrentEquivalenceStore'
	          ,'course.courseequivalence.CourseComponentEquivalenceStore','course.courseequivalence.CourseEquivalenceAliasStore','course.courseequivalence.CourseExceptCurrentEquivalenceIdStore'],
	          views : ['course.courseEquivalence.CourseEquivalenceForm','course.courseEquivalence.CourseEquivalenceGrid','course.CourseTabStructure'],
	config:{
		/*
  	   	 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
  	   	 */
      	/**
           * @cfg {Array} COURSEEQUIVALENCE_PERMISSIONS array (required)
           * The array of permissions to use for Access control wise enabling and disabling buttons.
           * @accessor
           */
		COURSEEQUIVALENCE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSEEQUIVALENCE_PRIVILEGES')	
		    
	},          

	          refs : [{
	        	  ref : 'courseequivalencegrid',
	        	  selector : 'courseequivalencegrid'
	          },{
	        	  ref :'courseequivalenceform',
	        	  selector :'courseequivalenceform'	
	          },{
	        	  ref :'courseequivalenceForm',
	        	  selector :'courseequivalenceform form'
	          },{
	        	  ref : 'coursetabstructure',
	        	  selector : 'coursetabstructure'		  		  
	          },{
	              ref: 'coursetabstructure',
	              selector: 'coursetabstructure'
	          }],

	          init : function() {
	        	  this.control({
	        		  'courseequivalencegrid' : {
	        			  render : function(grid){
	        				  this.courseEquivalenceGridRender(grid);
	        			  },
	      				afterrender:function(grid){
	    					var viewMode = this.getCoursetabstructure().getForm().findField('courseViewMode').getValue();
	    					if(viewMode == "View"){
	    						grid.down('#btnEdit').setVisible(false);
	    						grid.down('#btnDelete').setVisible(false);
	    						grid.down('#btnAdd').setVisible(false);
	    					}
	    				}
	        		  },
	        		  'courseequivalenceform button[itemId=courseEquivalentSaveBtnId]' : {
	        			  click : this.SaveEquivalenceFormWindow
	        		  },
	        		  'courseequivalenceform button[itemId=courseEquivalentCancelBtnId]' : {
	        			  click : this.closeFormWindow
	        		  },
	        		  'courseequivalencegrid button[itemId=btnAdd]' : {
	        			  click : this.showFormWindow
	        		  },
	        		  'courseequivalencegrid button[itemId=btnEdit]' : {
	        			  click:  this.editFormWindow
	        		  },
	        		  'courseequivalencegrid button[itemId=btnDelete]' : {
	        			  click : this.deleteFormWindow
	        		  },
	        		  'courseequivalencegrid button[itemId=btnView]' : {
	        			  click : this.viewFormWindow
	        		  },
	        		  'courseequivalenceform customcombobox#equivalentCourseCode': {
	        			  select: function(obj, record) {
	        				  var ECCId = record[0].get("id");
	        				  var ECCValue = record[0].get("value");
	        				  obj.nextSibling().setValue(ECCValue);

	        				  if(ECCId > 0){
	        					  var form =this.getCourseequivalenceForm().getForm();
	        					  var store = this.getStore('course.courseequivalence.CourseExceptCurrentEquivalenceIdStore');
	        					  store.getProxy().extraParams = {
	        						  id: ECCId
	        					  };
	        					  store.load();                    
	        				  }
	        			  }
	        		  },
	        	
	        	  });
	          },	
	          loadCombo : function (){

	        	  var $this = this;
	        	  
	        	  var tabStcrFrm = $this.getCoursetabstructure().getForm();
	        	  var cId = tabStcrFrm.findField("ids").getValue();

	        	  var CCStore = $this.getStore('course.courseequivalence.CourseComponentEquivalenceStore');
	        	  var CECStore = $this.getStore('course.courseequivalence.CourseExceptCurrentEquivalenceStore');
	        	  CCStore.getProxy().extraParams = {
	        		  id: cId
	        	  };
	        	  CCStore.load();

	        	  CECStore.getProxy().extraParams = {
	        		  id: cId
	        	  };
	        	  CECStore.load();

	          },
	          showFormWindow : function() {
	        	  var $this = this;
	        	  var formWindow = $this.getCourseequivalenceform();
	        	  if (!formWindow) {
	        		  Ext.widget('courseequivalenceform');
	        		  formWindow = $this.getCourseequivalenceform();
	        	  }
	        	  formWindow.show();
	        	  $this.loadCombo();
	          },

	          closeFormWindow : function() {
	        	  this.getCourseequivalenceform().close();
	          },

	          editFormWindow: function() {
                  var $this = this;
	        	  var grid = $this.getCourseequivalencegrid();
	        	  if (grid.getSelectionModel().getCount() > 0) {
	        		  $this.showFormWindow();
	        		  var form = $this.getCourseequivalenceForm();
	        		  
	        		  var store=this.getStore('course.courseequivalence.CourseEquivalenceStore');
	        		  var selectedRecord = grid.getSelectionModel().getSelection()[0];
	        		  var row = store.indexOf(selectedRecord);
	        		  var courseEquivalenceId = selectedRecord.data.equivalenceCourseId.id;
	        		   var courseEquivalenceName = selectedRecord.data.courseEquivalentName;
	        		  var records=store.getAt(row);
	        		  if (records != undefined && records != "" && records != null) {
	        			  form.loadRecord(records);
	        			  var WARadio = form.down('#whetherActive');
	        			  var whetherActve = records.data.whetherActive;
	        			 
	        			  if(!whetherActve){
	        				  WARadio.items.items[1].setValue(true);
	        			  }
	        		  }
	        		  form.down('#equivalentCourseCode').setValue(courseEquivalenceId);
	        		  form.down('#equivalentCourseNameId').setValue(courseEquivalenceName);
	        		  var CeStore = $this.getStore('course.courseequivalence.CourseEquivalenceStore');
	        	  } else {
	        		  showWarningMessage(getCommonTranslation('COURSE_EQUIVANENCE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	        	  }
	          },
	          viewFormWindow : function(){

	        	  this.editFormWindow();
	        	  var form =this.getCourseequivalenceForm();
	        	  if (form) {
	        		  form.down('#courseEquivalentSaveBtnId').setVisible(false);
	        		  form = form.getForm();
	        		  toggleReadOnlyFormItems(form, true);
	        	  }
	          },
	          deleteFormWindow: function() {

	        	  var grid = this.getCourseequivalencegrid();
	        	  var grdStore = grid.getStore();

	        	  if(grid.getSelectionModel().getCount()>0){
	        		  showConfirmMessage(getCommonTranslation('COURSE_EQUIVANENCE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	        			  if (btn == 'yes') {
	        				  var records=grid.getSelectionModel().getSelection();						        
	        				  var id=records[0].get("id");
	        				  Ext.Ajax.request({
	        					  method: "DELETE",
	        					  type: 'rest',
	        					  url: SERVERURL.COURSE_EQUIVALENCE_DELETE+'?id='+id,
	        					  headers: {
	        						  'Content-Type': 'application/json'
	        					  },
	        					  success:function(form, action){
	        						  grdStore.reload();
	        						  showSuccessMessage(getCommonTranslation('COURSE_EQUIVANENCE'),getCommonTranslation('SUCCESS'));
	        					  }
	        				  });
	        			  }
	        		  });
	        	  }else{
	        		  showWarningMessage(getCommonTranslation('COURSE_EQUIVANENCE'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
	        	  }

	          },
	          SaveEquivalenceFormWindow : function(){
                  var $this = this;
	        	  var grid = $this.getCourseequivalencegrid();
	        	  var grdStore = grid.getStore();
	        	  var tabStcrFrm = $this.getCoursetabstructure().getForm();
	        	  var courseId = tabStcrFrm.findField("ids").getValue();

				  var courseEquivalenceForm =  this.getCourseequivalenceForm();
				  var courseEquivalenceField = courseEquivalenceForm.down('#equivalentCourseCode');
				  var courseEquivalenceId = courseEquivalenceField.getValue();
				  var courseEquivalenceCode = courseEquivalenceField.rawValue;
	        	  var frmWin =this.getCourseequivalenceForm().getForm();
	        	  var courseComponentField = frmWin.findField("courseComponent");
	        	  var equivalentCourseComponentField = frmWin.findField("equivalentCourseComponent");
	        	  var value = frmWin.getValues();
	        	  
	        	  //var equivalenceModel = new Academia.model.course.courseequivalence.CourseEquivalenceModel();
	        	  var equivalenceModel = new Object();
	        	  equivalenceModel.whetherActive=value.whetherActive;
	        	  equivalenceModel.courseEquivalenceAlias=value.courseEquivalenceAlias;
                 
                   equivalenceModel.courseEquivalentCode=courseEquivalenceCode;
                   equivalenceModel.courseEquivalentName=value.equivalentCourseName;
                   var courses = new Object();
                   var equivalenceCourseId = new Object();
                   courses.id=courseId;
                   equivalenceCourseId.id=courseEquivalenceId;
                   equivalenceModel.courses=courses;
	        	   equivalenceModel.equivalenceCourseId=equivalenceCourseId;

	        	
	        	  if (value.id == null ||value.id == "") {
	        		  submitUrl = SERVERURL.COURSE_EQUIVALENCE_CREATE;
	        	  } else {
	        		  equivalenceModel.id=value.id;
	        		  submitUrl = SERVERURL.COURSE_EQUIVALENCE_UPDATE;
	        		  }

	        	  var submitData = equivalenceModel;
	        	  var btnSaveUpdateBtn= this.getCourseequivalenceForm().down('#courseEquivalentSaveBtnId');
	        	  btnSaveUpdateBtn.disable();
	        	  Ext.Ajax.request({
	        		  url: submitUrl,
	        		  jsonData: submitData,
	        		  method: 'POST',
	        		  success: function(response) {
	        			  if(response.responseText == "RECORD_ALREADY_EXIST"){
	        				  showWarningMessage(getCommonTranslation('ALERT'),"Record Already Exist");
	        			  }else{
	        				  grdStore.reload();
	        				  showSuccessMessage(getCommonTranslation('COURSE_EQUIVANENCE'),getCommonTranslation('SUCCESS'));
	        			  }
	        			  $this.closeFormWindow();
	        			  btnSaveUpdateBtn.enable();
	        		  }
	        	  });
	        	   this.courseEquivalenceGridRender(grid);
	        	   grid.getSelectionModel().deselectAll();
	          },

	          /*
	           * @method
	           * method to load the store manually after the rendering of the grid.
	           */
	          courseEquivalenceGridRender : function(grid){
	        	  
	        	  var $this = this;
	        	  
	        	  var tabStcrFrm = $this.getCoursetabstructure().getForm();
	        	  var courseId = tabStcrFrm.findField("ids").getValue();
	        	  $this.doAccessControlValidation(grid, $this.getCOURSEEQUIVALENCE_PERMISSIONS());
	        	  var store = this.getCourseequivalencegrid().getStore();
	        	  store.getProxy().extraParams = {
	        		  id:courseId
	        	  };
	        	  store.load();

	          },
	          getIdValueJson: function(id, value) {
	        	  if (id) return {
	        		  id: id,
	        		  value: value
	        	  };
	          }


});
