/**
 * @author Utsav Chandvaniya
 * 
 */
Ext.define('Academia.controller.coursetransaction.coursereading.CourseReadingController', {
	extend: 'Academia.controller.base.BaseController',	
	models : [
	          'program.programDetails.programBatches.PrimaryAcademicModel',
	          'coursetransaction.coursereading.CourseReadingDetails',
	          'coursetransaction.coursereading.AssignCourses','coursetransaction.coursereading.CourseReadingList',
	          'facilitiesresources.resourcebooking.CourseModel','coursetransaction.coursereading.CoursesReadingDocument'
	          ],
   stores : ['common.ProgramStore','enquiry.AcademicBatchStore','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
             'facilitiesresources.resourcebooking.CourseListStore','attendance.StudentCourses','coursetransaction.facultytopicassignment.CourseComboStore',
             'course.coursetopic.CourseComponentStore','course.readingmaterial.ReadingNameStore',
            'program.programDetails.programBatches.PrimaryAcademicStore',
            'coursetransaction.coursereading.TopicReading','course.readingmaterial.ReadingTypeStore',
            'coursetransaction.coursereading.DistributionMode',
            'coursetransaction.coursereading.TopicType','coursetransaction.coursereading.MaterialType',
            'common.YesNoStatus','coursetransaction.coursereading.AssignCourseMultiSelect',
            'coursetransaction.coursereading.AssignCourseGrid','coursetransaction.coursereading.CourseByPeriod',
            'coursetransaction.coursereading.NoOfTopicsCourseReading','coursetransaction.coursereading.CourseReadingListGrid',
            'coursetransaction.coursereading.CourseReadingUpload',
            'coursetransaction.coursereading.ComponentByParentCourseId',
            'servicerequest.programcoursesectiontransfer.ProgramForSectionTransfer','common.AssignedProgramStore','attendance.AssignedCoursesFacultyStore',
            'course.AssignedPeriodCoursesFacultyStore','common.AcademyLocationNameSeparated','common.AssignedProgramStoreOfMultiAcademy','common.AllUserBySmartSearch',
            'course.LinkedCourseWithReadingNameStore','course.AccessibleCourseDepartmentStore'
            ],
	views : [
	         'coursetransaction.coursereading.CourseReadingSearch',
	         'coursetransaction.coursereading.CourseReadingSearchListing',
	         'coursetransaction.coursereading.CourseReadingStructure',
	         'coursetransaction.coursereading.CourseReadingDetails',
	         'coursetransaction.coursereading.AssignCoursesList','coursetransaction.coursereading.AssingCourseForm',
	         'coursetransaction.coursereading.NoOfTopicsCourseReadingGrid','coursetransaction.coursereading.CourseReadingList',
	         'coursetransaction.coursereading.CourseReadingDocumentGrid',
	         'coursetransaction.coursereading.ResourceRequestDetailsPncForm'
	         ],
	 config: {
	              /*
	               	 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
	                		   	 */
	                	   	/**
	                	        * @cfg {Array} COURSEREADING_PERMISSIONS array (required)
	                	        * The array of permissions to use for Access control wise enabling and disabling buttons.
	                	        * @accessor
	                	        */
	        COURSEREADING_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('COURSEREADING_PRIVILEGES'),
	        MAP_COURSE_VARIANT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('MAP_COURSE_VARIANT_PRIVILEGES')
	   },	         
     refs : [
			{
				 ref : 'coursereadinglist',
				 selector : 'coursereadinglist'
			},{
				 ref : 'assingcourseform',
				 selector : 'assingcourseform'
			},{
				 ref : 'assigncourseslist',
				 selector : 'assigncourseslist'
			},{
				 ref : 'coursereadingsearch',
				 selector : 'coursereadingsearch'
			 },{
				 ref : 'coursereadingdetails',
				 selector : 'coursereadingdetails'
			 },{
				 ref : 'contentPanel',
				 selector : 'contentPanel'
			 },{
		    	 ref : 'coursereadingstructure',
		    	 selector : 'coursereadingstructure'
		     },{
		    	 ref : 'coursereadingsearchlisting',
		    	 selector : 'coursereadingsearchlisting'
		     },{
		    	 ref : 'coursereadingsearch',
		    	 selector : 'coursereadingsearch'
		     },{
		    	 ref : 'simpledocumentform',
		    	 selector : 'simpledocumentform'
		     },{
		    	 ref : 'coursereadingdocumentgrid',
		    	 selector : 'coursereadingdocumentgrid'
		     },{
		    	 ref : 'nooftopicscoursereadinggrid',
		    	 selector : 'nooftopicscoursereadinggrid'
		     },{
		    	 ref : 'resourcerequestdetailspncform',
		    	 selector : 'resourcerequestdetailspncform'
		     }],
		     init : function() {
		    	 this.control({
		    		 'coursereadingsearch button[itemId=courseReadingSearchBtn]' : {
		 				click : this.loadCourseReadingGrid
		 			 },
		 			 'coursereadingstructure':{
		 				 beforerender:function(){
		 					 this.getCoursereadinglist().getStore().removeAll();
		 				 },
		 				 render:function(grid){
		 					 var permissionsMap = new Ext.util.HashMap();
		 					 permissionsMap=this.getCOURSEREADING_PERMISSIONS();
		 					 this.doAccessControlValidation(grid,this.getCOURSEREADING_PERMISSIONS());
		 					 this.disableMoreActionPivileges(grid,permissionsMap);
		 					 
		 				 },
		 				 afterrender:function(structure){
		 					 var grid = structure.down('coursereadinglist');
          				     this.getGridHeaderFreeze(grid,structure);
		 				 }
		 			 },
		 			 'coursereadingsearch button[itemId=courseReadingResetBtn]' : {
		 				 click :function(){ 
		 					 var form = this.getCoursereadingsearch();
		 					 if(this.getCurrentLoggedPortalId()==3){
		 						 form.getForm().reset();
		 					 }else{
		 						 form.getForm().reset();
		 						 form.down("#courseId").setVisible(true);
		 						 form.down("#courseId").reset();
		 						 form.down("#course_period_Id").setVisible(false);
		 						 form.down("#course_period_Id").reset();
		 						 form.down("#componentItemId").setVisible(false);
		 						 form.down("#componentItemId").reset();
		 						form.down("#readingNameId").setDisabled(true);
		 					 }
		 					 var topicCombo = form.down('combo#materialTopic_Id');
		 					 topicCombo.clearValue();
		 					 topicCombo.setDisabled(true);
		 				 }
		 			 },
		 			 'coursereadingsearch combo[itemId=topicId]' : {
		 				 select:function(obj,rec){ 
		 					 var data=rec[0].data.id;
	        				 var form=obj.up('form').getForm();
	        				 var readingNameField=form.findField('readingName');
	        				 readingNameField.enable();
	        				 readingNameField.getStore().getProxy().extraParams={
	        					 inventoryTypeId: data
	        				 },
	        				 readingNameField.getStore().load();
		 				 }
		 			 },
		             'assigncourseslist button[itemId=assignCourse_Add_Id]': {
			             	click : function() {
			             		var grid = this.getAssigncourseslist();
			             		var academicTermVal = grid.down('#academicTerm').getValue();
			             		if(!isNullOrEmpty(academicTermVal)){
			             			if (grid.getStore() != null){
			             				serialNo = grid.getStore().getCount();
			             				this.showAssingCourseWithAcademicTerm(serialNo + 1,academicTermVal);
			             			}
			             			else{
			             				this.showAssingCourseWithAcademicTerm(1,academicTermVal);
			             			}
			             		}else{
			             			this.showAssingCourse(1);	
			             		}
			 	   				//this.removeDocStore();
			 	   			}
			             },
			             'assigncourseslist button[itemId=assignCourse_Delete_Id]': {
				             	click : function() {
				 	   				this.deleteAssingCourse();
				 	   			}
				             },
				             'assigncourseslist button[itemId=btnSaveMapCourseVarItemId]': {
				            	 click : function() {
				            		 this.updateAssignCourse();
				            	 }
				             },
		             'assingcourseform button[itemId=assingCourseCancel]': {
			             	click : function() {
			             		this.getAssingcourseform().close();
			 	   			}
			             }, 
		             'assingcourseform button[itemId=assingCourseSubmit]': {
			             	click : function() {
			 	   			this.addAssignCourses();
			             	}
			             }, 
			             
		             'coursereadingdetails button[itemId=courseReading_Add]': {
			             	click : function() {
			 	   				this.addCourseReading();
			 	   			}
			             },
		             'coursereadingdetails button[itemId=courseReading_Cancel]': {
			             	click : function() {
			 	   				this.cancelCourseReading();
			 	   			}
			             },
			             'assingcourseform multiselectcombofield[itemId=multiselectAcademyLocationId]': {
				             	/*change : function(me, newValue, oldValue, eOpts) {
				 	   				console.log(me);
				 	   			}*/
			            	 blur:function(ob,rec) {
			            		 var grid = this.getCoursereadinglist();
			            		 var academyLocationId = ob.up('form').down('#multiselectAcademyLocationId').getValue();
			            		 var alIds=[];
			     				var academyLocationIds; 
			     				if(academyLocationId !=undefined && academyLocationId.length > 0 && academyLocationId[0] != ""){
			     					for(var i in academyLocationId){
			     						if(Ext.isObject(academyLocationId[0])){
			     							alIds.push(academyLocationId[i].get("id"));
			     						}else{
			     							alIds.push(academyLocationId[i]);
			     						}
			     					}
			     					academyLocationIds = alIds.join();
			     				} else {
			     					alIds.push(this.getCurrentAcademyLocation());
			     					academyLocationIds = alIds.join();
			     				}
		        				if (!isNullOrEmpty(grid) && grid.getSelectionModel().getCount() > 0) {
		        					
		        			   	 var records = grid.getSelectionModel().getSelection();
		        		    	 if (records != undefined && records != ""&& records != null) {
		        		    		 var courseId = records[0].data.courseId;
		        		    		 var coursePlanningAndReadingId = records[0].data.coursePlanningAndReadingId;
		 							
		        		    		 var winform=this.getAssingcourseform();
				            		 var variantBox=winform.down('#multiCourseVariantId');
				            		 var variantBoxStore=variantBox.getStore();
				            		 variantBoxStore.getProxy().extraParams = {
		    						 courseId: courseId,
		    						 courseReadingId : coursePlanningAndReadingId,
		    						 academyLocationIds : academyLocationIds
		    					 };
				            		 variantBoxStore.load();
		        		    	 	}
		        				 }
		        				else{
		        					var grid = this.getAssigncourseslist();
		           				 	var readingId = grid.config.readingId;
		           				 	var courseId = grid.config.courseId;
		           				 	var winform=this.getAssingcourseform();
		           				 	var variantBox=winform.down('#multiCourseVariantId');
		           				 	var variantBoxStore=variantBox.getStore();
		           				 	variantBoxStore.getProxy().extraParams = {
		           				 		courseIds: courseId,
		           				 		courseReadingId : readingId,
		           				 		academyLocationIds : academyLocationIds
		           				 	};
		           				 	variantBoxStore.load();
		        				}
			            		
			            	   }
				             },
			            /* 'coursereadinglist':{
			            	 render: function() {
			        				this.getCoursereadinglist().getStore().remove();
			        				//this.removeDocStore();
			        			}
				             },*/
		             'coursereadinglist button[itemId=btnAdd]': {
		            	 click: function() {
		        				this.showCourseReadingDetails();
		        				this.topicDetails("ADD");
		        				//this.getCoursereadinglist().getStore().remove();
		        				//this.removeDocStore();
		        			}
			             },
		             'coursereadinglist button[itemId=btnEdit]': {
		            	 click: function() {
		        				this.editCourseReading();
		        				this.topicDetails("EDIT");
		        			}
			             },
		             'coursereadinglist button[itemId=btnDelete]': {
		            	 click: function() {
		        				this.deleteCourseReading();
		        			}
			             },
		             'coursereadinglist button[itemId=btnView]': {
		            	 click: function() {
		            		    this.topicDetails("VIEW");
		        				this.viewCourseReading();
		        			}
			             },
		             'coursereadinglist menuitem[itemId=textLinked]': {
		            	 click: function() {
		        				this.textLinked();
		        			}
			             },    
		             'coursereadingdetails radiogroup[itemId=topicRadio_Id]':{
		            	 change: function() {
		        				this.topicRadio();
		        			}	 
		             },
		             'coursereadingdetails combo[itemId=courseReadingType_Id]':{
		            	 select: function(ob,rec) {
		        				this.courseReadingAuthor(ob,rec);
		        				
		        				 var data=rec[0].data.id;
		        				 var form=ob.up('form').getForm();
		        				 var readingNameField=form.findField('invtItemMaster');
		        				 readingNameField.enable();
		        				 readingNameField.getStore().getProxy().extraParams={
		        					 inventoryTypeId: data
		        				 },
		        				 readingNameField.getStore().load();
		        			 
		        			}	 
		             },
		             'coursereadingdetails button#courseReadingUploadId': {
	        			  click:function(){
	        				  this.getDocumentController().showDocumentFormWindow('courseReadingformItemId', 'DOCUMENT');
	        			  }
	        		  },
	        		  'coursereadingdetails': {
	        			  render:function(){
	        				  this.courseReadingRender();
	        				  this.getCoursereadingdocumentgrid().getStore().removeAll();
	        			  }
	        		  },
	        		  'documentformwindow[itemId=courseReadingformItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId':{
	        			  click:function(){
	        				  var $this=this;
	        				  var isTransient = true;
	        				  var module = 'courseReading';
	        				  var entityId ;
	        				  var entityType = 'courseReading';

	        				  $this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient){
	        					  var documentModel=new Academia.model.coursetransaction.coursereading.CoursesReadingDocument();
	        					  documentModel.set("documentName",response.name);
	        					  documentModel.set("path",response.path);
	        					  documentModel.set("type",response.type);
	        					  documentModel.set("documentName",response.name);
	        					  documentModel.set("createdBy",$this.getIdValueJson(response.createdBy.id,response.createdBy.value));
	        					  var store=$this.getStore('coursetransaction.coursereading.CourseReadingUpload');
	        					  store.add(documentModel);
	        					  $this.getDocumentController().closeDocumentFormWindow();
	        				  }, isTransient);
	        			  }
	        		  },
	        		  'simpledocumentform button#documentCancelButtonId':{
	        			  click:function(){
	        				  this.getDocumentController().closeDocumentFormWindow();
	        			  }
	        		  },
	        		  'coursereadingdocumentgrid button#btnDwnlod':{
	        			  click:function(){
	        				  this.downloadStudentDocumentFile();
	        			  }
	        		  },
	        		  'coursereadingdocumentgrid' : {
	        			  cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
	        				  var $this = this;
	        				  var documentGrid = $this.getCoursereadingdocumentgrid();
	        				  var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

	        				  if (columnName == "documentName") {
	        					  if (e.target.tagName == 'A') {
	        						  var documentId = record.get("documentId");
	        						  if (!isNullOrEmpty(documentId)) {
	        							  $this.getDocumentController().downloadDocumentFile(documentId);
	        						  }
	        					  }
	        				  }
	        			  }
	        		  },
	        		  'coursereadingdocumentgrid button#btnDelete':{
	        			  click:function(){
	        				  var $this=this;
	        				  var grid=$this.getCoursereadingdocumentgrid();
	        				  if (grid.getSelectionModel().getCount() > 0) {
	        					  showConfirmMessage(getCommonTranslation('COURSE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
	        			                if (btn == 'yes') {
	        			                    var records = grid.getSelectionModel().getSelection();
	        			                    if(isNullOrEmpty(records[0].data.documentId)){
	        							    	var filePath = records[0].data.path;
	        							    	  Ext.Ajax.request({
			        			                        method: "DELETE",
			        			                        type: 'rest',
			        			                        url: SERVERURL.PATH_DELETE_READING_MATERIAL_FILE + '?filePaths=' + filePath,
			        			                        headers: {
			        			                            'Content-Type': 'application/json'
			        			                        },
			        			                        success: function(form, action) {
			        			                        	if(form.responseText == 'true'){
			        			                        		grid.getStore().reload();
				        			                            showSuccessMessage(getCommonTranslation('COURSE'), getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
			        			                        	} else {
			        			                        		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
			        			                        	}
			        			                            
			        			                        }
			        			                    });
	        							    }else{
	        							    	var id = records[0].get("id");
		        			                    Ext.Ajax.request({
		        			                        method: "DELETE",
		        			                        type: 'rest',
		        			                      //  url: SERVERURL.COURSE_DOCUMENT_DELETE_DOCUMENT_URL + '?id=' + id,
		        			                        url: SERVERURL.COURSE_DOCUMENT_DETAIL_DELETE_DOCUMENT_URL + '?id=' + id,
		        			                        headers: {
		        			                            'Content-Type': 'application/json'
		        			                        },
		        			                        success: function(form, action) {
		        			                            grid.getStore().reload();
		        			                            showSuccessMessage(getCommonTranslation('COURSE'), getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
		        			                        }
		        			                    });
	        							    }
	        			                    
	        			                }
	        			            });
	        			        } else {
	        			            showWarningMessage(getCourseTxCommonTranslation('COURSE_READ'), getCommonTranslation("PLEASE_SELECT_RECORD")); //Please select a record
	        			        }
	        			  }
	        		  },
		             'assigncourseslist' : {
        			   render : function(grid){},
        			 cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
        				 var $this = this;
        				 var grid = $this.getAssigncourseslist();
        				 var columnName = grid.columnManager.columns[cellIndex].dataIndex;

        				 if(columnName == "courseDepartment"){
        					 return false;
        				 }
        				 else if (e.target.tagName == 'DIV') {
        					 if (columnName == "addButton") {
        						 if (e.target.className == "addButtonClsForGridActionCls") {
        							 if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
        								 var serialNo;
        								 if (grid.getStore() != null)
        									 serialNo = grid.getStore().getCount();
        								 this.showAssingCourse(serialNo + 1, record);
        							 }
        						 }
        					 } else if (columnName == "deleteButton") {
        						 if (e.target.className == "deleteButtonClsForGridActionCls") {
        							 if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
        								 
        								 if(isNullOrEmpty(record.data.id)){
        									 grid.getStore().removeAt(rowIndex);
            								 var models = grid.getStore().getRange();
            								 for (var i = 0; i < models.length; i++) {
            									 models[i].data.serialNo = i + 1;
            								 }
            								 grid.getStore().loadRawData(models, true);
            								 if(models.length == 0){
            									 grid.down('#assignCourse_Add_Id').show();
            									 grid.down('#academicTerm').setVisible(false);
            									 grid.down('#fldContCVSaveItemId').setVisible(false);
            									 grid.down('#resetBtn').setVisible(false);
            								 }
        								 }
        								 else{
        									 var idVal = record.data.id;
        									 showConfirmMessage(getCommonTranslation("RESOURCE_REQUEST_DETAILS"),getCommonTranslation("DELETE_CONFIRM_MESSAGE"),
        											 function(btn, text) {
        										 if (btn == 'yes'){
        											 Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        											 Ext.Ajax.request({
        												 method : "DELETE",
        												 type : 'rest',
        												 url : SERVERURL.ASSIGN_COURSE_DELETE + '?id='+ idVal,
        												 headers : {
        													 'Content-Type' : 'application/json'
        												 },
        												 params : {
        													 id : idVal
        												 },
        												 success : function(form,action) {
        													 Ext.getBody().unmask();
        													 grid.getStore().removeAt(rowIndex);
        													 var models = grid.getStore().getRange();
        													 for (var i = 0; i < models.length; i++) {
        														 models[i].data.serialNo = i + 1;
        													 }
        													 grid.getStore().loadRawData(models, true);
        													 if(models.length == 0){
        														 grid.down('#assignCourse_Add_Id').show();
        														 grid.down('#academicTerm').setVisible(false);
        														 grid.down('#fldContCVSaveItemId').setVisible(false);
        														 grid.down('#resetBtn').setVisible(false);
        													 }
        												 }
        											 });
        										 }
        									 });
        								 }
        							 }
        						 }
        					 }
        				 }
        			 },
        			 selectionchange: function(column, selected,eOpts ){
        				 var grid = this.getAssigncourseslist();
        				 if(selected.length== 1){ 
        					 grid.down('#btnSaveMapCourseVarItemId').setDisabled(false);
        					 //grid.down('#assignCourse_Delete_Id').setDisabled(false);
        				 }
        				 else{
        					 grid.down('#btnSaveMapCourseVarItemId').setDisabled(true);
        					 //grid.down('#assignCourse_Delete_Id').setDisabled(true);
        				 }							
        			 }
        		 },
        		 'assigncourseslist customcombobox[itemId=academicTerm]': {
        			 select : function(obj, record) {
    	   				 var assigncourseslist = this.getAssigncourseslist();
    	   				assigncourseslist.getStore().clearFilter();
    	   				 if(!isNullOrEmpty(record)){
    	   					assigncourseslist.getStore().filter({property: 'academicTermId',
    	   						 value: record[0].get('id'),
    	   						 exactMatch: true,
    	   						 caseSensitive: true});
    	   					
    	   					if(assigncourseslist.getStore().data.length == 0){
    	   						assigncourseslist.down('#assignCourse_Add_Id').show();
    	   					}
    	   					else{
    	   						assigncourseslist.down('#assignCourse_Add_Id').hide();
    	   					}
    	   				 }
    	   			 },
    	   			 render: function(combo){
    	   				 var me = this;
    	   				var grid = this.getAssigncourseslist();
    	   				var readingNameId = grid.config.readingId;
    	   				 var academyLocationId = this.getCurrentAcademyLocation();
    	   				 if(!isNullOrEmpty(combo)){
    	   					 var store = combo.getStore();
    	   					 store.getProxy().extraParams = {
    	   						 academyLocationIds: academyLocationId,
    	   						 readingNameId:readingNameId
    	   					 };
    	   					 store.load();
    	   				 }
    	   			 }
        		 },
        		 'assigncourseslist button#resetBtn':{
        			 click:function(btn){
        				 var activeGrid = this.getAssigncourseslist();
        				 activeGrid.getSelectionModel().deselectAll();
        				 activeGrid.getStore().clearFilter();
        				 if(activeGrid.down('#academicTerm')){
        					 activeGrid.down('#academicTerm').reset();
        				 }
        				 activeGrid.down('#assignCourse_Add_Id').hide();
        			 }
        		 },
	             'assingcourseform' : {
        			 show : function(){
        				 var grid = this.getAssigncourseslist();
        				 var readingId = grid.config.readingId;
        				 var courseId = grid.config.courseId;
        				 if(!isNullOrEmpty(readingId)){
        					 var academyLocationId = this.getCurrentAcademyLocation();
            				 var store = this.getStore('coursetransaction.coursereading.AssignCourseMultiSelect');
        					 store.getProxy().extraParams = {
        						 courseIds: courseId,
        						 courseReadingId : readingId,
        						 academyLocationIds : academyLocationId
        					 };
        					 store.load();
        				 }
        				 /*var grid = this.getCoursereadinglist();
        				 var academyLocationId = this.getCurrentAcademyLocation();
        				 if (grid.getSelectionModel().getCount() > 0) {
        			   	 var records = grid.getSelectionModel().getSelection();
        		    	 if (records != undefined && records != ""&& records != null) {
        		    		 var courseId = records[0].data.courseId;
        		    		 var coursePlanningAndReadingId = records[0].data.coursePlanningAndReadingId;
 							
        				 var store = this.getStore('coursetransaction.coursereading.AssignCourseMultiSelect');
    					 store.getProxy().extraParams = {
    						 courseId: courseId,
    						 courseReadingId : coursePlanningAndReadingId,
    						 academyLocationIds : academyLocationId
    					 };
    					 store.load();
        		    	 	}
        				 }*/
        			 }
        		 },
	             'coursereadingdetails combo#courseReadingCourse_Id' : {
        			 select : function(obj, record) {
        				 var this$ = this;
        				 var courseId = record[0].get("courseId");
        				 var sectionAtComponentLevel = record[0].get("sectionAtComponentLevel");
        				 var  componentField = this.getCoursereadingdetails().down("#componentId");
        				 
        				 if(sectionAtComponentLevel){
        					 componentField.setVisible(true);
        					 componentField.allowBlank=false;
        					 componentField.getStore().getProxy().extraParams = {
        						 id : courseId
        					 };
        					 componentField.getStore().load({
        						 callback:function(record,callback){
        	        				 var  componentField = this$.getCoursereadingdetails().down("#componentId");
        							 if(!isNullOrEmpty(componentField.editModeCourseId)){
        								 componentField.setValue(componentField.editModeCourseId);
        								 componentField.editModeCourseId = "";
        							 }
        						 }
        					 });
        				 }else{
        					 componentField.setVisible(false);
        					 componentField.clearValue();
        					 componentField.allowBlank=true;
        				 }
        					 var store = this.getStore('coursetransaction.coursereading.MaterialType');
        					 store.getProxy().extraParams = {
        						 courseId: courseId
        					 };
        					 store.load();
        			 }
        		 }, 
        		 'coursereadingdetails combo#componentId' : {
        			 select : function(obj, record) {
        				 var form = this.getCoursereadingdetails().getForm();
        				 var courseId = form.findField('course').getValue();
        				 var componentId = record[0].get("id");
        				  var topicStore = this.getStore('coursetransaction.coursereading.MaterialType');
        				  topicStore.getProxy().extraParams = {
        					  courseId : courseId,
        					  componentId:componentId
        				  };
        				  topicStore.load();
        			 }
        		 }, 
        		 'coursereadingsearch' : {
        			 render : function(form) {
        				 var $this = this;
    	        		  
    	        		  var attendanceProgram = form.down("#attendanceProgram");
    	        		  var multiselectAcademyLocationId = form.down("#multiselectAcademyLocationId");
    	        		  var programId = form.down("#programId");
    	        		  var batchId = form.down("#batchId");
    	        		  var batchCombo = form.down("#batchCombo");
    	        		  var courseId = form.down("#courseId");
    	        		  var studentCourseId = form.down("#studentCourseId");
    	        		  var portalId = this.getCurrentLoggedPortalId();
    	            	  var facultyId = null;
    	            	  var alIds=[];
    	            	  alIds.push(this.getCurrentAcademyLocation());
    	            	  var als=alIds.join();
    	        		  if(this.getCurrentLoggedPortalId()==3){
    	        			  
    	        			  programId.setVisible(false);
    	        			  batchId.setVisible(false);
    	        			  courseId.setVisible(false);
    	        			  multiselectAcademyLocationId.setVisible(false);
    	        			  multiselectAcademyLocationId.allowBlank =true;
    	        			  
    	        			  attendanceProgram.setVisible(true);
    	        			  batchCombo.setVisible(true);
    	        			  studentCourseId.setVisible(true);
    	        			  
    	        			  var attendanceProgramStore = attendanceProgram.getStore();
    	        			  attendanceProgramStore.getProxy().extraParams = {
        	        			  studentId:$this.getCurrentlyLoggedInUser().id				
        	        		  };
    	        			  attendanceProgramStore.load();
    	        			  
    	        			  var studentPortalInfo = this.getCurrentlyLoggedInUserInfoForPortal();
              				  var studentprogramId = studentPortalInfo.programBatchDetails.programId;
              				  var studentbatchId = studentPortalInfo.programBatchDetails.batchId;
              				  
              				 attendanceProgram.setValue(studentprogramId);
							 attendanceProgram.setReadOnly(true);
							 
							 var batchStore = batchCombo.getStore();
							 batchStore.getProxy().extraParams = {
        						 id : studentprogramId
        					 };
							 batchStore.load();
								
							 batchCombo.setValue(studentbatchId);
							 batchCombo.setReadOnly(true);
    	        			  
    	        		  }else{
    	        			 var academyLocationId = this.getCurrentAcademyLocation();
    	        			 var academyLocationIds =this.getUserAccessibleAL();
    	        			 var multiselectAcademyLocationStore=multiselectAcademyLocationId.getStore();
    	        			 multiselectAcademyLocationStore.load({
    	        				 callback: function(records, operation, success) {
            						   if (success) {
            							   if(records.length > 0){
            								   multiselectAcademyLocationId.setValue(academyLocationId);
            							   }		 
            						   }
    	        				 }
    	        			 });
        	        		 if(portalId == 2) {
        	        			 facultyId = this.getCurrentlyLoggedInUser().id;
        	        		 }
        	        		   var store = this.getStore('attendance.AssignedCoursesFacultyStore');
        	        			  store.getProxy().extraParams = {	
				    					facultyId : facultyId,
				    					academyLocationId:academyLocationId
				    				};
				    				store.load();
        	                     
        	        		    var programStore =  this.getStore('common.AssignedProgramStoreOfMultiAcademy');
        	        			programStore.getProxy().extraParams = {	
				    					facultyId : facultyId,
				    					academyLocationIds:als
				    				};
				    			programStore.load();
				    			
				    			var batchStore =  this.getStore('enquiry.AcademicBatchStore');
				    			batchStore.getProxy().extraParams = {	
				    					academyLocationIds:academyLocationId
				    				};
				    			batchStore.load();
				    			var periodStore =  this.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
				    			periodStore.getProxy().extraParams = {	
				    					academyLocationIds:academyLocationId,
				    					//sectionType:"ProgramBatchSection"
				    				};
				    			periodStore.load();
				    			
    	        		  }
        			 }
        		 },
        		 'coursereadingsearch multiselectcombofield[itemId=multiselectAcademyLocationId]': {
	            	 blur:function(ob,rec) {
	            		 var coursereadingsearch = this.getCoursereadingsearch();
	            		 var programId = coursereadingsearch.down("#programId");
	            		 var batchId = coursereadingsearch.down("#batchId");
	            		 var batchCombo = coursereadingsearch.down("#batchCombo");
	            		 var periodId = coursereadingsearch.down("#periodId");
	            		 var courseId = coursereadingsearch.down("#courseId");
   	        		 	 var studentCourseId = coursereadingsearch.down("#studentCourseId");
   	        		 	  coursereadingsearch.down("#courseId").setVisible(true);
   	        		      coursereadingsearch.down("#course_period_Id").setVisible(false);
	            		 var portalId = this.getCurrentLoggedPortalId();
	            		 var facultyId = null;
	            		 var academyLocationId = ob.up('form').down('#multiselectAcademyLocationId').getValue();
	            		 var alIds=[];
	     				var academyLocationIds; 
	     				if(academyLocationId !=undefined && academyLocationId.length > 0 && academyLocationId[0] != ""){
	     					for(var i in academyLocationId){
	     						if(Ext.isObject(academyLocationId[0])){
	     							alIds.push(academyLocationId[i].get("id"));
	     						}else{
	     							alIds.push(academyLocationId[i]);
	     						}
	     					}
	     				} else {
	     					alIds.push(this.getCurrentAcademyLocation());
	     				}
	     				academyLocationIds = alIds.join();
	     				if(portalId == 2) {
   	        			 facultyId = this.getCurrentlyLoggedInUser().id;
   	        		 }
	     				programId.reset();
	     				batchId.reset();
	     				batchCombo.reset();
	     				periodId.reset();
	     				courseId.reset();
	     				studentCourseId.reset();
	     			   var store = this.getStore('attendance.AssignedCoursesFacultyStore');
   	        			  store.getProxy().extraParams = {	
			    					facultyId : facultyId,
			    					academyLocationIds:academyLocationIds
			    				};
			    				store.load();
   	                     
   	        		    var programStore =  this.getStore('common.AssignedProgramStoreOfMultiAcademy');
   	        			programStore.getProxy().extraParams = {	
			    					facultyId : facultyId,
			    					academyLocationIds:academyLocationIds
			    				};
			    			programStore.load();
			    			
			    			var batchStore =  this.getStore('enquiry.AcademicBatchStore');
			    			batchStore.getProxy().extraParams = {	
			    					academyLocationIds:academyLocationIds
			    				};
			    			batchStore.load();
			    			var periodStore =  this.getStore('program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
			    			periodStore.getProxy().extraParams = {	
			    					academyLocationIds:academyLocationIds
			    				};
			    			periodStore.load();
	            		
	            	   }
		             },
        		 'coursereadingsearch combo#programId' : {
        			 select : function(obj, record) {
        				 $this = this;
        				 var programId = record[0].get("id");
        				 if (programId > 0) {
        					 var form = this.getCoursereadingsearch();
            				 form.down("#courseId").setVisible(true);
            				 form.down("#courseId").reset();
            				 form.down("#course_period_Id").setVisible(false);
            				 form.down("#course_period_Id").reset();
            				 batchComboBox=form.down("#batchId");
            				 
        					 var store = this.getStore('enquiry.AcademicBatchStore');
        					 store.getProxy().extraParams = {
        						 id : programId
        					 };
        					 var periodField=form.down('#periodId');
        					 periodField.enable();
  						   //	 periodField.reset();
        					 store.load({
          					   callback: function(records, operation, success) {
          						   if (success) {
          							   var periodField=form.down('#periodId');
          							   if(records.length == 1){
          								   batchComboBox.setValue(records[0].data.id);
          								   periodField.clearValue();
                						   var storePeriod = periodField.getStore();
                						   storePeriod.getProxy().extraParams = {
                							   id:records[0].data.id,
                						   };
                						   
                						   storePeriod.load({
                							   callback: function(records, operation, success) {
                								   if (success) {
                									   if(records.length == 1){
                										 periodField.setValue(records[0].data.id);
                										 
                										 
                										// var form = this.getCoursereadingsearch();
                				    					 var facultyId = null;
                				        				 //var componentField = this.getCoursereadingsearch().down("#componentItemId");
                				        				 var componentField = form.down("#componentItemId");
                				        				 componentField.setVisible(false);
                				        				 
                				        				/* form.down("#courseId").setVisible(false);
                				    					 form.down("#course_period_Id").setVisible(false);*/
                				        				 
                				        				 /**
                				        				  * for student
                				        				  */
                				        				 if($this.getCurrentLoggedPortalId()==3){
                				        					 var periodId = records[0].data.id	//record[0].get('id');
                				        					 var studentCourseId = form.down("#studentCourseId");
                				        					 var studentCourseStore = studentCourseId.getStore();
                				        					 studentCourseStore.getProxy().extraParams = {
                				        						 periodId : periodId
                				        					 };
                				        					 studentCourseStore.load();
                				        				 }else{
                				        					 var batchId = form.down("#batchId").getValue();
                				        					 var batch;
                				        					 var academyLocationId=form.down("#multiselectAcademyLocationId").getValue();
                  				        					 var alIds=[];
                  				        					 var academyLocationIds; 
                  				   	     				if(academyLocationId !=undefined && academyLocationId.length > 0 && academyLocationId[0] != ""){
                  				   	     					for(var i in academyLocationId){
                  				   	     						if(Ext.isObject(academyLocationId[0])){
                  				   	     							alIds.push(academyLocationId[i].get("id"));
                  				   	     						}else{
                  				   	     							alIds.push(academyLocationId[i]);
                  				   	     						}
                  				   	     					}
                  				   	     					academyLocationIds = alIds.join();
                  				   	     				} else {
                  				   	     					alIds.push($this.getCurrentAcademyLocation());
                  				   	     					academyLocationIds = alIds.join();
                  				   	     				}
                				        					 if(batchId > 0 && batchId !=null ){
                				        						 batch = batchId; 
                				        					 }else{
                				        						 batch =0;
                				        					 }
                				        					 form.down("#courseId").setVisible(false);
                				        					 form.down("#course_period_Id").setVisible(true);

                				        					 var periodId = records[0].data.id	 //record[0].get("id");
                				        					 var courseStore = $this.getStore('course.AssignedPeriodCoursesFacultyStore');
                				        					 if($this.getCurrentLoggedPortalId()==2){
                				        					 facultyId = $this.getCurrentlyLoggedInUser().id;
                				        					 }
                				        						 courseStore.getProxy().extraParams = {
                				            						 batchId:batch,
                				            						 periodId : periodId,
                				            						 facultyId: facultyId,
                				            						 academyLocationIds:academyLocationIds,
                				            						 //sectionType:"ProgramBatchSection"
                				            					 };
                				        					 courseStore.load();
                				        				 }
                										 
                									   }		 
                								   }

                							   }	   
                						   });
          							   }		 
          						   }
          						   var periodField=form.down('combo#periodId');
          						   periodField.enable();
          						   periodField.reset();
          						   var storePeriod = periodField.getStore();
          						   storePeriod.getProxy().extraParams = {
          							   id:records[0].data.id,
          						   };
          						   
          						   storePeriod.load({
          							   callback: function(records, operation, success) {
          								   if (success) {
          									   if(records.length == 1){
          										 periodField.setValue(records[0].data.id);
          										 
          										 
          										// var form = this.getCoursereadingsearch();
          				    					 var facultyId = null;
          				        				 //var componentField = this.getCoursereadingsearch().down("#componentItemId");
          				        				 var componentField = form.down("#componentItemId");
          				        				 componentField.setVisible(false);
          				        				 
          				        				/* form.down("#courseId").setVisible(false);
          				    					 form.down("#course_period_Id").setVisible(false);*/
          				        				 
          				        				 /**
          				        				  * for student
          				        				  */
          				        			if($this.getCurrentLoggedPortalId()==3){
          				        					 var periodId = records[0].data.id	//record[0].get('id');
          				        					 var studentCourseId = form.down("#studentCourseId");
          				        					 var studentCourseStore = studentCourseId.getStore();
          				        					 studentCourseStore.getProxy().extraParams = {
          				        						 periodId : periodId
          				        					 };
          				        					 studentCourseStore.load();
          				        				 }else{
          				        					 var batchId = form.down("#batchId").getValue();
          				        					 var academyLocationId=form.down("#multiselectAcademyLocationId").getValue();
          				        					 var alIds=[];
          				        					 var academyLocationIds; 
          				   	     				if(academyLocationId !=undefined && academyLocationId.length > 0 && academyLocationId[0] != ""){
          				   	     					for(var i in academyLocationId){
          				   	     						if(Ext.isObject(academyLocationId[0])){
          				   	     							alIds.push(academyLocationId[i].get("id"));
          				   	     						}else{
          				   	     							alIds.push(academyLocationId[i]);
          				   	     						}
          				   	     					}
          				   	     					academyLocationIds = alIds.join();
          				   	     				} else {
          				   	     					alIds.push($this.getCurrentAcademyLocation());
          				   	     					academyLocationIds = alIds.join();
          				   	     				}
          				        					 
          				        					 
          				        					 var batch;
          				        					 if(batchId > 0 && batchId !=null ){
          				        						 batch = batchId; 
          				        					 }else{
          				        						 batch =0;
          				        					 }
          				        					 form.down("#courseId").setVisible(false);
          				        					 form.down("#course_period_Id").setVisible(true);

          				        					 var periodId = records[0].data.id	 //record[0].get("id");
          				        					 var courseStore = $this.getStore('course.AssignedPeriodCoursesFacultyStore');
          				        					 if($this.getCurrentLoggedPortalId()==2){
          				        					 facultyId = $this.getCurrentlyLoggedInUser().id;
          				        					 }
          				        						 courseStore.getProxy().extraParams = {
          				            						 batchId:batch,
          				            						 periodId : periodId,
          				            						 facultyId: facultyId,
          				            						 academyLocationIds:academyLocationIds,
          				            						 //sectionType:"ProgramBatchSection"
          				            					 };
          				        					 courseStore.load();
          				        				 }
          										 
          									   }		 
          								   }

          							   }	   
          						   });
          					   }	   
          				   });

        				 }
        			 }
        		 },
        		 'coursereadingsearch combo#batchCombo' : {
        			 select : function(obj,record){
        				 var form = obj.up('form');
        				 var batchId = record[0].get("batchId");
        				 form.down("#courseId").setVisible(false);
        				 form.down("#course_period_Id").setVisible(false);
        				 
        					var periodComboBox = form.down('combo#periodId');
        					 periodComboBox.clearValue();
        					 
        					 var periodStore = periodComboBox.getStore();
        					 periodStore.getProxy().extraParams = {
        	                        id: batchId
        	                    };
        					 periodStore.load();
        			 }
        		 },
        		 'coursereadingsearch combo#batchId' : {
        			 select : function(obj, record) {
        				 var batchId = record[0].get("id");
        				 var form = this.getCoursereadingsearch();
        				 form.down("#courseId").setVisible(true);
        				 form.down("#course_period_Id").setVisible(false);
        				 var periodComboBox = this.getCoursereadingsearch().down('combo#periodId');
        				 var periodField =form.down("#periodId");
        				 periodComboBox.clearValue();

        				 var periodStore = periodComboBox.getStore();
        				 periodStore.getProxy().extraParams = {
        					 id: batchId
        				 };
        				 periodStore.load({
        					 callback: function(records, operation, success) {
        						 if (success) {
        							 if(records.length == 1){
        								 periodField.setValue(records[0].data.id);
        								 
										 
										// var form = this.getCoursereadingsearch();
				    					 var facultyId = null;
				        				 //var componentField = this.getCoursereadingsearch().down("#componentItemId");
				        				 var componentField = form.down("#componentItemId");
				        				 componentField.setVisible(false);
				        				 
				        				/* form.down("#courseId").setVisible(false);
				    					 form.down("#course_period_Id").setVisible(false);*/
				        				 
				        				 /**
				        				  * for student
				        				  */
				        				 if($this.getCurrentLoggedPortalId()==3){
				        					 var periodId = records[0].data.id	//record[0].get('id');
				        					 var studentCourseId = form.down("#studentCourseId");
				        					 var studentCourseStore = studentCourseId.getStore();
				        					 studentCourseStore.getProxy().extraParams = {
				        						 periodId : periodId
				        					 };
				        					 studentCourseStore.load();
				        				 }else{
				        					 var batchId = form.down("#batchId").getValue();
				        					 var batch;
				        					 var academyLocationId=form.down("#multiselectAcademyLocationId").getValue();
  				        					 var alIds=[];
  				        					 var academyLocationIds; 
  				   	     				if(academyLocationId !=undefined && academyLocationId.length > 0 && academyLocationId[0] != ""){
  				   	     					for(var i in academyLocationId){
  				   	     						if(Ext.isObject(academyLocationId[0])){
  				   	     							alIds.push(academyLocationId[i].get("id"));
  				   	     						}else{
  				   	     							alIds.push(academyLocationId[i]);
  				   	     						}
  				   	     					}
  				   	     					academyLocationIds = alIds.join();
  				   	     				} else {
  				   	     					alIds.push($this.getCurrentAcademyLocation());
  				   	     					academyLocationIds = alIds.join();
  				   	     				}
				        					 if(batchId > 0 && batchId !=null ){
				        						 batch = batchId; 
				        					 }else{
				        						 batch =0;
				        					 }
				        					 form.down("#courseId").setVisible(false);
				        					 form.down("#course_period_Id").setVisible(true);

				        					 var periodId = records[0].data.id	 //record[0].get("id");
				        					 var courseStore = $this.getStore('course.AssignedPeriodCoursesFacultyStore');
				        					 if($this.getCurrentLoggedPortalId()==2){
				        					 facultyId = $this.getCurrentlyLoggedInUser().id;
				        					 }
				        						 courseStore.getProxy().extraParams = {
				            						 batchId:batch,
				            						 periodId : periodId,
				            						 facultyId: facultyId,
				            						 academyLocationIds:academyLocationIds,
				            						 //sectionType:"ProgramBatchSection"
				            					 };
				        					 courseStore.load();
				        				 }
										 
									   
        							 }		 
        						 }

        					 }	   
        				 });
        			 }
        		 },
        		
        		 'coursereadingsearch combo#courseId' : {
        			 select : function(obj, record) {
        				 var courseId = record[0].get("courseId");
        				 var topicCombo = this.getCoursereadingsearch().down('combo#materialTopic_Id');
        				 topicCombo.clearValue();
        				 topicCombo.setDisabled(false);
        				 var componentField = this.getCoursereadingsearch().down("#componentItemId");
        				 var topicField = this.getCoursereadingsearch().down("#materialTopic_Id");
        				 if(record[0].data.sectionAtComponentLevel){
        					 componentField.setVisible(true);
        					 topicField.setDisabled(true);
            				 if(courseId > 0){//section on the bases of component
            					 componentField.getStore().getProxy().extraParams = {
            						 id : courseId
            					 };
            					 componentField.getStore().load();
            				 }
        				 }else{
        					 componentField.setVisible(false);
        					 componentField.reset();
        				 }
        				 
        				 var topicStore = topicCombo.getStore();
        				 topicStore.getProxy().extraParams = {
        					 courseId: courseId
    	                    };
        				 topicStore.load();
        			 }
        		 }, 
        		 'coursereadingsearch combo#course_period_Id' : {
        			 select : function(obj, record) {
        				 var courseId = record[0].get("courseId");
        				 var componentField = this.getCoursereadingsearch().down("#componentItemId");
        				 
        				 var topicField = this.getCoursereadingsearch().down("#materialTopic_Id");
        				 if(record[0].data.sectionAtComponentLevel){
        					 componentField.setVisible(true);
        					 topicField.setDisabled(true);
            				 if(courseId > 0){//section on the bases of component
            					 componentField.getStore().getProxy().extraParams = {
            						 id : courseId
            					 };
            					 componentField.getStore().load();
            				 }
        				 }else{
        					 componentField.setVisible(false);
        					 componentField.reset();
        				 }
        				 
        				 var topicCombo = this.getCoursereadingsearch().down('combo#materialTopic_Id');
        				 topicCombo.clearValue();
        				 topicCombo.setDisabled(false);
        				 
        				 var topicStore = topicCombo.getStore();
        				 topicStore.getProxy().extraParams = {
        					 courseId: courseId
    	                    };
        				 topicStore.load();
        			 }
        		 },
        		 'coursereadingsearch combo#componentItemId' : {
        			 select : function(obj, record) {
        				 var componentId = record[0].get("id");
        				 var topicCombo = this.getCoursereadingsearch().down('combo#materialTopic_Id');
        				 topicCombo.clearValue();
        				 topicCombo.setDisabled(false);
        				 
        				 var courseId;
        				 var course = this.getCoursereadingsearch().getForm().findField('COURSE').getValue();
        				 var course1= this.getCoursereadingsearch().getForm().findField('COURSE_PERIOD_ID').getValue();
        				 if(course !=null && course > 0){
        					 courseId = course;
        				 }else{
        					 courseId = course1;
        				 }
        				 
        				 var topicStore = topicCombo.getStore();
        				 topicStore.getProxy().extraParams = {
        					 courseId: courseId,
        					 componentId:componentId
    	                    };
        				 topicStore.load();
        			 }
        		 },
        		 'coursereadingsearch combo#periodId' : {
        			 select : function(obj, record) {
        				 var form = this.getCoursereadingsearch();
    					 var facultyId = null;
        				 var componentField = this.getCoursereadingsearch().down("#componentItemId");
        				 componentField.setVisible(false);
        				 
        				 form.down("#courseId").setVisible(false);
    					 form.down("#course_period_Id").setVisible(false);
        				 
        				 /**
        				  * for student
        				  */
        				 if(this.getCurrentLoggedPortalId()==3){
        					 var periodId = record[0].get('id');
        					 var studentCourseId = form.down("#studentCourseId");
        					 var studentCourseStore = studentCourseId.getStore();
        					 studentCourseStore.getProxy().extraParams = {
        						 periodId : periodId
        					 };
        					 studentCourseStore.load();
        				 }else{
        					 var batchId = form.down("#batchId").getValue();
        					 var academyLocationId=form.down("#multiselectAcademyLocationId").getValue();
	        					 var alIds=[];
	        					 var academyLocationIds; 
	   	     				if(academyLocationId !=undefined && academyLocationId.length > 0 && academyLocationId[0] != ""){
	   	     					for(var i in academyLocationId){
	   	     						if(Ext.isObject(academyLocationId[0])){
	   	     							alIds.push(academyLocationId[i].get("id"));
	   	     						}else{
	   	     							alIds.push(academyLocationId[i]);
	   	     						}
	   	     					}
	   	     					academyLocationIds = alIds.join();
	   	     				} else {
	   	     					alIds.push(this.getCurrentAcademyLocation());
	   	     					academyLocationIds = alIds.join();
	   	     				}
        					 
        					 var batch;
        					 if(batchId > 0 && batchId !=null ){
        						 batch = batchId; 
        					 }else{
        						 batch =0;
        					 }
        					 form.down("#courseId").setVisible(false);
        					 form.down("#course_period_Id").setVisible(true);

        					 var periodId = record[0].get("id");
        					 var courseStore = this.getStore('course.AssignedPeriodCoursesFacultyStore');
        					 if(this.getCurrentLoggedPortalId()==2){
        					 facultyId = this.getCurrentlyLoggedInUser().id;
        					 }
        						 courseStore.getProxy().extraParams = {
            						 batchId:batch,
            						 periodId : periodId,
            						 facultyId: facultyId,
            						 academyLocationIds:academyLocationIds,
            						 //sectionType:"ProgramBatchSection"
            					 };
        					 courseStore.load();
        				 }
        			 }
        		 },
        		 'coursereadinglist':{
        			 render:function(grid){
        				 this.doAccessControlValidation(grid,this.getCOURSEREADING_PERMISSIONS());
        				 this.disableMoreActionPivileges(grid,this.getCOURSEREADING_PERMISSIONS());
        				 if(this.getCurrentLoggedPortalId()==3) {
        					 grid.down('#btnView').setVisible(false);
        				 }
        			 },
        			 cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
        				 var $this=this;
        				 var searchResultGrid = $this.getCoursereadinglist();
        				 var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;
        				 if(columnName=='noOfCount' &&  record.data.noOfCount > 0){ // checked
        					 if (e.target.tagName == 'A') {
        						 var formWindow = $this.getNooftopicscoursereadinggrid();
            					 if (!formWindow) {
            						 Ext.widget('nooftopicscoursereadinggrid');
            						 formWindow = $this.getNooftopicscoursereadinggrid();
            					 }
            					 formWindow.show();
            					 formWindow.setTitle(getCourseTxCommonTranslation('TOPIC_NAME'));
            					 var topicGrid = formWindow.down('#topicItemId');
            					 topicGrid.setVisible(true);
            					 var docsGrid = formWindow.down('#docsItemId');
            					 docsGrid.setVisible(false);
            					 var youtubeVideo = formWindow.down('#youtubeItemId');
            					 youtubeVideo.setVisible(false);
            					 var store= topicGrid.getStore();
            					 store.getProxy().extraParams = {
            						 courseReadingId: record.data.coursePlanningAndReadingId
            					 };
            					 store.load();
        					 }
        				 }
        				 if(columnName=='noOfDocs'){
        					 var formWindow = $this.getNooftopicscoursereadinggrid();
        					 if (!formWindow) {
        						 Ext.widget('nooftopicscoursereadinggrid');
        						 formWindow = $this.getNooftopicscoursereadinggrid();
        					 }
        					 formWindow.show();
        					 formWindow.setTitle(getCourseTxCommonTranslation('DOCS_NO'));
        					 var topicGrid = formWindow.down('#topicItemId');
        					 topicGrid.setVisible(false);
        					 var docsGrid = formWindow.down('#docsItemId');
        					 docsGrid.setVisible(true);
        					 var youtubeVideo = formWindow.down('#youtubeItemId');
        					 youtubeVideo.setVisible(false);
        					 docsGrid.down('#btnDelete').setVisible(false);
        					 var store= docsGrid.getStore();
        					 store.getProxy().extraParams = {
        						 courseReadingId: record.data.coursePlanningAndReadingId
        					 };
        					 store.load();
        				 }
        				 if(columnName=='readingName'){
        					 if (e.target.tagName == 'A') {
        						 if(record.data.readingTypeName =='Youtube') {
        							 var formWindow = $this.getNooftopicscoursereadinggrid();
                					 if (!formWindow) {
                						 Ext.widget('nooftopicscoursereadinggrid');
                						 formWindow = $this.getNooftopicscoursereadinggrid();
                					 }
                					 formWindow.setTitle(getCourseTxCommonTranslation('READING_TITLE'));
                					 var topicGrid = formWindow.down('#topicItemId');
                					 var docsGrid = formWindow.down('#docsItemId');
                					 var youtubeVideo = formWindow.down('#youtubeItemId');
                					 docsGrid.setVisible(false);
                					 topicGrid.setVisible(false);
                					 youtubeVideo.setVisible(true); 
                					 youtubeVideo.update("");
                					 youtubeVideo.update("<iframe width=\"560\" height=\"315\" src=\""+record.data.readingName+"\" frameborder=\"0\"></iframe>");
                					 formWindow.show();
        						 }
        					 }
        				 }
        			 }
        		 }
		     });
			 },
			 getDocumentController : function(){
		          	var this$ = this;
		          	return this$.getController('Academia.controller.document.DocumentController');
		          },
			 loadCourseReadingGrid:function(){
				 var $this=this;
				 var courseReadingSearchForm = this.getCoursereadingsearch().getForm();
			     var courseIds;
			     var readingTypeIds =0;
				 var  distributionModeIds=0;
				 var  topicIds = 0;
				 
				 var readingNameId = courseReadingSearchForm.findField('readingName').getValue();
				 var courseId = courseReadingSearchForm.findField('COURSE').getValue();
				 var coursePeriodId = courseReadingSearchForm.findField('COURSE_PERIOD_ID').getValue();
				 var studentCourseId = courseReadingSearchForm.findField('studentCourse').getValue();
				 
				 var programId = courseReadingSearchForm.findField('PROGRAM').getValue();
				 var batchId = courseReadingSearchForm.findField('BATCH').getValue();
				 var periodId = courseReadingSearchForm.findField('PERIOD').getValue();
				 var portalId = this.getCurrentLoggedPortalId();
         		 var facultyId = null
         		 if(portalId==2){
         			facultyId = this.getCurrentlyLoggedInUser().id;
         		 }
				 if(courseId > 0 ){
					 courseIds = courseId;
				 }else if(coursePeriodId > 0){
					 courseIds = coursePeriodId;
				 }else if(studentCourseId > 0){	 
					 courseIds = studentCourseId;
				 }else{
					 courseIds="";
				 }
				 var topicType = courseReadingSearchForm.findField('TOPIC_TYPE').getRawValue();
				 
				 readingTypeId = courseReadingSearchForm.findField('TOPIC_READING_ID').getValue();
				 
				 if(readingTypeId !=null){
					 readingTypeIds = readingTypeId;
				 }else{
					 readingTypeIds = 0;
				 }
				 
				 distributionModeId = courseReadingSearchForm.findField('DISTRIBUTION_MODE').getValue();
				 
				 if(distributionModeId !=null){
					 distributionModeIds = distributionModeId;
				 }else{
					 distributionModeIds = 0;
				 }
				 
				 topicId = courseReadingSearchForm.findField('MATERIAL_TYPE').getValue();
				 if(topicId !=null && topicId > 0){
					 topicIds = topicId;
				 }else{
					 topicIds = 0;
				 }
				 
				 var  whetherCompulsory = courseReadingSearchForm.findField('COMPULSORY_OPTIONAL').getValue();
				 
				 if(whetherCompulsory == 1){
					 whetherCompulsory = true;	 
				 }else if(whetherCompulsory ==0){
					 whetherCompulsory = false;
				 }

				 var componentId= courseReadingSearchForm.findField('componentId').getValue();
				 var academyLocationId=courseReadingSearchForm.findField('multiselectAcademyLocation').getValue();
				 var alIds=[];
				 var academyLocationIds; 
				if(academyLocationId !=undefined && academyLocationId.length > 0 && academyLocationId[0] != ""){
					for(var i in academyLocationId){
						if(Ext.isObject(academyLocationId[0])){
							alIds.push(academyLocationId[i].get("id"));
						}else{
							alIds.push(academyLocationId[i]);
						}
					}
					academyLocationIds = alIds.join();
				} else {
					alIds.push(this.getCurrentAcademyLocation());
					academyLocationIds = alIds.join();
				}
				 var store = this.getStore('coursetransaction.coursereading.CourseReadingListGrid');
				 store.getProxy().extraParams = {
					 courseIds: courseIds,
					 programId: programId > 0 ? programId : 0,
					 batchId: batchId > 0 ? batchId : 0,
					 periodId: periodId > 0 ? periodId : 0,
					 academyLocationIds:academyLocationIds,
					 topicType:topicType,
					 readingTypeId:readingTypeIds,
					 distributionModeId:distributionModeIds,
					 topicId: topicIds,
					 whetherCompulsory:whetherCompulsory,
					 invtItemMasterId:readingNameId > 0 ? readingNameId : 0,
					 componentId:componentId,
					 facultyId:facultyId
				 };
				 $this.resetPageSetting(store);
				 store.loadPage(1);
			 },
		     textLinked : function(){
		    	var $this = this;
				var grid = $this.getCoursereadinglist();
				if (grid.getSelectionModel().getCount() > 0) {		    	 
		    	 var me = this;
            	 var contentpanel = me.getContentPanel();
            	 var assigncoursesId = Ext.widget('assigncourseslist');
            	 var tabName = getCourseTxCommonTranslation('ASSIGN_COURSE_VARIANT');
            	 
            	 var getcontroller=$this.getController('menu.CoreERPNavigationController');
            	 var getTab=getcontroller.getTab(tabName);
            	 if(getTab!=null){
            		 contentpanel.remove(getTab, true);
            	 }
            	 openTab(contentpanel, tabName, assigncoursesId,CONSTANTS.MENU_COLOR_THREE);
            	 
            	 
            	 
            	 
			}else{
				 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
			}
		     },
		     showCourseReadingDetails : function() {
            	 var me = this;
            	 var contentpanel = me.getContentPanel();
            	 var courseReadingId = Ext.widget('coursereadingdetails');
            	 var tabName = getCourseTxCommonTranslation('COURSE_READING');
            	 
            	 var getcontroller=me.getController('menu.CoreERPNavigationController');
            	 var getTab=getcontroller.getTab(tabName);
            	 if(getTab!=null){
            		 contentpanel.remove(getTab, true);
            	 }
            	 openTab(contentpanel, tabName, courseReadingId,CONSTANTS.MENU_COLOR_THREE);
             },
 
             cancelCourseReading:function(){
				 this.getCoursereadingdetails().getForm().reset();
				 var forms = this.getCoursereadingdetails();
				 var form = this.getCoursereadingdetails().getForm();
//				 form.findField('author').hide();
//				 form.findField('author').reset();
				 form.findField('whetherDownloadable').hide();
				 form.findField('whetherDownloadable').reset();
				 form.findField('linkPath').hide();
				 form.findField('linkPath').reset();
				 forms.down('#topicRadio_Id').items.items[0].setValue(true);
	  			 forms.down('#topicRadio_Id').items.items[1].setValue(false);
				 
				 
             },
             viewCourseReading : function() {
				 this.editCourseReading();
            	 var forms = this.getCoursereadingdetails();
            	 var readingDoc =this.getCoursereadingdocumentgrid();            	 
            	 var form = forms.getForm();
					if (form) {
						form.findField('course').setReadOnly(true);
						form.findField('COMPONENT_ID').setReadOnly(true);
						form.findField('invtTypeMaster').setReadOnly(true);
//						form.findField('author').setReadOnly(true);
						form.findField('linkPath').setReadOnly(true);
						form.findField('invtItemMaster').setReadOnly(true);
						form.findField('distributionMode').setReadOnly(true);
						form.findField('whetherCompulsory').setReadOnly(true);
						form.findField('whetherDownloadable').setReadOnly(true);
						form.findField('courseReadingLinks').setReadOnly(true);
						form.findField('courseReadingTopics').setReadOnly(true);
						forms.down('#topicRadio_Id').setReadOnly(true);
						forms.down('#courseReading_Add').hide();
						forms.down('#courseReading_Cancel').hide();
						forms.down('#courseReadingUploadId').hide();
					}
					readingDoc.down('#btnDelete').setVisible(false);
				},
             
          topicDetails:function(radioType){
	        	  var $this =this;
	        	  var grid = $this.getCoursereadinglist();
	        	Ext.Ajax.request({
					type : 'rest',
					url :SERVERURL.TOPIC_TYPE,
					method : 'GET',
					success : function(form, action) {
				    	var topicType = Ext.JSON.decode(form.responseText);
				    	var topicTypeRadio = Ext.ComponentQuery.query('radiogroup#topicRadio_Id')[0];
				    	for(var i=0, n=topicType.length; i<n; i++ ){
				    		topicTypeRadio.add({
				    			boxLabel: topicType[i].code,
				    			name:'topicType',
				    			inputValue: topicType[i].code
		                    });
				    	}
				     var forms = $this.getCoursereadingdetails();
					 if (radioType == "VIEW"){
				    		topicTypeRadio.setReadOnly(true); 
				    	}
					if (radioType != "ADD"){
				    	 if (grid.getSelectionModel().getCount() > 0) {
			  				var records = grid.getSelectionModel().getSelection();
			  				if (records != undefined && records != ""
			  						&& records != null) {
			  					var values = records[0].data.topicType;
			  					if(values == getCourseTxCommonTranslation('GENERAL')){
			  	            		 Ext.ComponentQuery.query('multiselectcombofield#multiTopics_Id')[0].hide();
			  	            		forms.down('#topicRadio_Id').items.items[0].setValue(true);
						  			 forms.down('#topicRadio_Id').items.items[1].setValue(false);
			  	            	 }else if(values == getCourseTxCommonTranslation('SPECIFIC')){
			  	            		 Ext.ComponentQuery.query('multiselectcombofield#multiTopics_Id')[0].show();
			  	            		forms.down('#topicRadio_Id').items.items[0].setValue(false);
						  			 forms.down('#topicRadio_Id').items.items[1].setValue(true);
			  	            	 }	
			  				}
			  				}
				    	} else{
				    		forms.down('#topicRadio_Id').items.items[0].setValue(true);
				  			forms.down('#topicRadio_Id').items.items[1].setValue(false);
				    	} 
			  			   //if(radioType)
			  			   
			  			   /*V2D-12464*/
			  			  /* if(isViewMode != undefined && isViewMode != null){
			  				   if(isViewMode == 'viewMode'){
			  					   topicTypeRadio.setReadOnly(true); 
			  				   }
			  			   }*/
					}
				});
           },
             topicRadio : function(){
            	 var value = this.getCoursereadingdetails().getForm().getValues();
            	 var topicType = value.topicType;
            	 
            	 if(topicType == getCourseTxCommonTranslation('GENERAL')){
            		 Ext.ComponentQuery.query('multiselectcombofield#multiTopics_Id')[0].hide();
            	 }else if(topicType == getCourseTxCommonTranslation('SPECIFIC')){
            		 Ext.ComponentQuery.query('multiselectcombofield#multiTopics_Id')[0].show();
            	 }								
             },
             courseReadingAuthor:function(ob,rec){
            	 var form = this.getCoursereadingdetails().getForm();

//            	 var authorField = form.findField('author');
            	 var linkField = form.findField('linkPath');

//            	 authorField.allowBlank =true;
            	 linkField.allowBlank =true;

            	 var Book = rec[0].data.value;
            	 var Link = rec[0].data.value;

            	 if((getCourseTxCommonTranslation('BOOK') == Book) || (Book == 'book')){
//            		 form.findField('author').show();
            		 form.findField('linkPath').hide();
            		 form.findField('linkPath').reset();
            		 form.findField('whetherDownloadable').hide();
            		 form.findField('whetherDownloadable').reset();
            	 }else if(getCourseTxCommonTranslation('LINK') == Link){
            		 form.findField('linkPath').show();
//            		 form.findField('author').hide();
//            		 form.findField('author').reset();
            		 form.findField('whetherDownloadable').show();
            	 }else{
//            		 form.findField('author').hide();
//            		 form.findField('author').reset();
            		 form.findField('linkPath').hide();
            		 form.findField('linkPath').reset();
            		 form.findField('whetherDownloadable').hide();
            		 form.findField('whetherDownloadable').reset();
            	 }

             },
             addCourseReading:function(){
            	 var $this = this;
                 var form = $this.getCoursereadingdetails().getForm();
               	 var values = form.getValues();
	        	 var id = form.findField('id').getValue();
	        	 var version= form.findField('version').getValue();

	        	 var courseReading  =  new  Academia.model.coursetransaction.coursereading.CourseReadingDetails();
	        	
	         	 var courseReadingLinks = form.findField('courseReadingLinks').getValue();
	         	 
	        	 var courseReadingTopicsId = form.findField('courseReadingTopics').getValue();
	        	 var distributionModeId = form.findField('distributionMode').getValue();
	        	 var courseReadTypeId = form.findField('invtTypeMaster').getValue();
	        	 var courseId = form.findField('course').getValue();
	        	 var componentId = form.findField('COMPONENT_ID').getValue();
	        	 
	        	 var course;
	        	 if(componentId > 0 && componentId != null){
	        	  course = this.getIdValueJson(componentId);
	        	 }else{
	        	  course = this.getIdValueJson(courseId);
	        	 }
	        	 var parentCourse;
	        	 parentCourse=this.getIdValueJson(0);
	        	 var invtTypeMaster = this.getIdValueJson(courseReadTypeId);
	        	 var distributionMode = this.getIdValueJson(distributionModeId);
	        	 var customFieldDatas=values.customFieldDatas;
	        	 
	        	 var courseReadingTopicsIds  = form.findField('courseReadingTopicsIds').getValue();
	        	 	var array = courseReadingTopicsIds.split(',');
	        	 	
	        	 	 var maps = [];
	        		 var maps1 = [];
	        		 
	        		 if(id != null  && id > 0){
	        			 
	        			 if(courseReadingTopicsId.length > array.length){
	        				 for ( var i in courseReadingTopicsId) {
	   	        			  maps.push({
	   	        				  "id" : maps1[i],
	   	        				  "courseTopic"  : this.getIdValueJson(courseReadingTopicsId[i].data.id)  
	   	        				  });
	   	        		  };
	        			 }else{
	        				 for ( var i in courseReadingTopicsId) {
	        					 if(typeof courseReadingTopicsId[i]=="object"){
	        						 var courseTopicVal = courseReadingTopicsId[i].data.id;
	        					 }
	        					 else {
	        						 var courseTopicVal = courseReadingTopicsId[i];
	        					 }
		   	        			  maps.push({
		   	        				  "id" : maps1[i],
		   	        				  "courseTopic"  : this.getIdValueJson(courseTopicVal)  
		   	        				  });
		   	        		  }; 
	        			 }
	        			 
	        		 }else if(courseReadingTopicsId !=undefined && courseReadingTopicsId.length > 0){
		        		 for ( var i in courseReadingTopicsId) {
		        			  maps.push({
		        				  "id" : maps1[i],
		        				  "courseTopic"  : this.getIdValueJson(courseReadingTopicsId[i].data.id)  
		        				  });
		        		  };
		        	 	 } 
	        	 
	        	 var obj = form.findField('courseReadingDocObj').getValue();
	        		 
	        // for updload document
	        	  var mediaType=[];	        	  
	        		  mediaType.push({
	        		  /*"mediaLinks":	 courseReadingLinks,
	        		  "whetherDownloadable":values.whetherDownloadable*/
        			  "id":obj,
    		         "courseReadingId":id,
    		         "mediaLinks":courseReadingLinks,
    		         "whetherDownloadable":values.whetherDownloadable	  
	        		  });
	        		var invItems;
	        		var invItemsArrayData =[];
	        		  if(!isNullOrEmpty(values.invtItemMaster)) {
							for ( var i in values.invtItemMaster) {
								if (Ext.isObject(values.invtItemMaster[0])) {
									invItems = values.invtItemMaster[i].get("id");
									invItemsArrayData.push(invItems);
								} else {
									invItems = values.invtItemMaster[i];
									invItemsArrayData.push(invItems);
								}
							}
						}
	        		  
	        	var invItemsMasterArr = [];
	        	if(invItemsArrayData.length > 0){
	        	for(var i in invItemsArrayData){
	        		invItemsMasterArr.push({
	        			"id":invItemsArrayData[i]
	        		})
	        	}
	        }
	        		  
//	        	courseReading.set("id", id);
	        	courseReading.set("academicYear",values.academicYear);
//	        	courseReading.set("author",values.author);
	        	courseReading.set("linkPath",values.linkPath);
	        	courseReading.set("invtItemMaster",invItemsMasterArr);
	        	courseReading.set("whetherCompulsory",values.whetherCompulsory);
	        	courseReading.set("topicType",values.topicType);
	        	
	       	    courseReading.set("courseReadingLinks",mediaType);
	        	 courseReading.set("courseReadingTopics",maps);
	        	courseReading.set("course",course);
	        	courseReading.set("invtTypeMaster",invtTypeMaster);
	        	courseReading.set("distributionMode",distributionMode);
	        	courseReading.set("customData",values.customData);
	        	courseReading.set("version",version);
	        	courseReading.set("parentCourse",parentCourse);
	        	
	        	
	        	var docStore=$this.getStore('coursetransaction.coursereading.CourseReadingUpload');
	        	  var docArray=[]; 
	        	  if(docStore.data.items!=null && docStore.data.items.length>0){
	        	  Ext.each(docStore.data.items, function (val) {
	        		  var newData={
	        				  "name":val.data.documentName,
	        				  "path":val.data.path,
	        				  "type":val.data.type,
	        				  "createdBy":$this.getIdValueJson(val.data.createdBy.id,val.data.createdBy.value)
	        		  };
	        		  if(val.data.documentId==""){
	        			  docArray.push(newData);  
	        		  }
//	        		  docArray.push(newData);
       		   });
	        	  }
	        	  if(docArray.length > 0 ){
	        		  courseReading.set("documents",docArray);  
	        	  }else{
		        	  courseReading.set("documents",null);	        		  
	        	  }

	        	
	        	var submitUrl;
	        	if (form.findField('id').getSubmitValue() == null
	        			|| form.findField('id').getSubmitValue() == "") {
	        		submitUrl = SERVERURL.COURSE_READING_CREATE;
	        	} else {
	        		courseReading.set("id", values.id);
	        		submitUrl = SERVERURL.COURSE_READING_UPDATE;
	        	}
	        	var formData = Ext.encode(courseReading.data);
	        	 //$this.applyWindowMask(); 
	        	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	        	
	        	Ext.Ajax.request({
	        		type : 'rest',
	        		url : submitUrl,
	        		jsonData : formData,
	        		method : 'POST',
	        		success : function(form, action) {
	        			//$this.hideWindowMask();
	        			 Ext.getBody().unmask();
//	        		Ext.JSON.decode(form.responseText);
	        		showSuccessMessage(getCourseTxCommonTranslation('COURSE_READ'),getCourseTxCommonTranslation('COURSE_READING_SAVE'));
	        		$this.cancelCourseReading();
	        		$this.getCoursereadingdocumentgrid().getStore().removeAll();
	        		$this.loadCourseReadingGrid();
	        		}
	        	});
             }, 
             getIdValueJson : function(id, value, code) {
            	 if (id)
            		 return {
            		 id : id,
            		 value : value,
            		 code : code
            	 };
             },
     editCourseReading : function() {
			var $this = this;
			var grid = $this.getCoursereadinglist();
			if (grid.getSelectionModel().getCount() > 0) {
				this.showCourseReadingDetails();
				var records = grid.getSelectionModel().getSelection();
				if (records != undefined && records != ""
						&& records != null) {
					var id = records[0].data.coursePlanningAndReadingId;
			Ext.Ajax.request({
						type : 'rest',
						url : SERVERURL.COURSE_FIND_BY_ID,
						params : {
							id : id
						},
				        method : 'GET',
				        async: false,
				        success : function(response) {
				        var $form = $this.getCoursereadingdetails().getForm();
				        var data = Ext.decode(response.responseText);
 					 
						var button =Ext.ComponentQuery.query('button#courseReading_Add')[0];
						button.setText('Save');
						
						var editButton =Ext.ComponentQuery.query('button#courseReading_Cancel')[0];
						editButton.setVisible(false);
						
						var courseReading  =  new  Academia.model.coursetransaction.coursereading.CourseReadingDetails(data);
	 					$form.loadRecord(courseReading);
 					
	 					
	 					$form.findField('COMPONENT_ID').allowBlank=true;
	 					//for hide and show author and link
 					
//	 					var authorField = $form.findField('author');
	 					var linkField = $form.findField('linkPath');
 		           	    
// 		           	    authorField.allowBlank = true;
 		                linkField.allowBlank = true;
 					
 		                
 					   var courseType = data.invtTypeMaster;
						if(courseType!= null ){
	    					 if(data.invtTypeMaster.value == 'Book'){
//	    						 $form.findField('author').setValue(data.author).setVisible(true);
	    						 $form.findField('linkPath').setVisible(false);
	    					 }else if(data.invtTypeMaster.value == 'Link' && data.courseReadingLinks !=null ){
//	    						 $form.findField('author').setVisible(false);
	    						 $form.findField('whetherDownloadable').setValue(data.courseReadingLinks[0].whetherDownloadable).setVisible(true);
	    						 $form.findField('linkPath').setValue(data.linkPath).setVisible(true);
	    					 }else{
//	    						 $form.findField('author').setVisible(false);
	    						 $form.findField('linkPath').setVisible(false);
	    					 }
						}

    					// for course reading Links set id update time
						if(data.courseReadingLinks != null && data.courseReadingLinks.length > 0){
    					$form.findField('courseReadingDocObj').setValue(data.courseReadingLinks[0].id);	
    					$form.findField('courseReadingLinks').setRawValue(data.courseReadingLinks[0].mediaLinks);

				        }
    					
    					// set doc in upload button for show at edit time
    					// for course reading topics
	 					var courseReadT = courseReading.data.courseReadingTopics;
    					var ids =[];
    					for(var i in courseReadT){
    						  ids.push(courseReadT[i].id);
    					 };
    					 $form.findField("courseReadingObj").setValue(ids);
    					 
    					 var topicsIds=[];
    					 if(courseReadT !=null && courseReadT.length > 0){
    						 for(var i=0;i<courseReadT.length;i++){
    							 topicsIds.push(courseReadT[i].courseTopic.id);
    						 }
    					 }
    					 $form.findField("courseReadingTopicsIds").setValue(topicsIds);
    					 
    					 
    					var courseReading= $form.findField('courseReadingTopics');
    					var courseTopicsIds = [];
       	        		 for ( var i in data.courseReadingTopics) {
 	     	        				  courseTopicsIds.push(data.courseReadingTopics[i].courseTopic.id);
       	        		 };
    					courseReading.store.load({
    						params:{
    							courseId: data.course.id
    						},
    						callback : function(records,operation,success) {
                          if (success) {
                        	  courseReading.setValue(courseTopicsIds);
                               }
                           }
    					});
    					
	 					var courseCombo = $form.findField('course');
	 					var courseReadTypeCombo = $form.findField('invtTypeMaster');
	 					var distributionModeCombo = $form.findField('distributionMode');
	 					var courseReadNameCombo = $form.findField('invtItemMaster');
	 					var componentCombo = $form.findField('COMPONENT_ID');
	 					
	 					var distributionMode =  data.distributionMode;
//                        if(distributionMode == null){
//                        	return false;
//                    }else{
	 					
	 					if(distributionMode != null){
	 						distributionModeCombo.store.load({callback : function(records,operation,success) {
	 							var distributionModeId =  data.distributionMode.id;                    
	 							if (success) {
	 								distributionModeCombo.setValue(distributionModeId);
	 							}
	 						}
	 						});
	 					}
//                    }
	 					
	 					courseReadTypeCombo.setReadOnly(true);
	 					var invtTypeMaster =  data.invtTypeMaster;
                        if(invtTypeMaster == null){
                        	return false;
                    }else{
                    	courseReadTypeCombo.store.load({
                    	callback : function(records,operation,success) {
                            var courseReadTypeId =  data.invtTypeMaster.id;                    
                          if (success) {
                        	  courseReadTypeCombo.setValue(courseReadTypeId);
                               }
                           }
                       });
                    }
                        
                        
//                        var invtItemMaster =  data.invtItemMaster;
                        courseReadNameCombo.setDisabled(false);
                        courseReadNameCombo.setReadOnly(true);
                        courseReadNameCombo.store.getProxy().extraParams = {
                        	inventoryTypeId : data.invtTypeMaster.id
	                	   };
                        courseReadNameCombo.store.load({
                    	callback : function(records,operation,success) {
                            var courseReadNameId =  data.invtItemMaster[0].id;                    
                          if (success) {
                        	  courseReadNameCombo.setValue([courseReadNameId]);
                               }
                           }
                       });
                        
                        
                        
                        
	 					var course =  data.course;
                        if(course == null){
                        	return false;
                        }else{
                        	courseCombo.store.load({
                        		callback : function(records,operation,success) {
                        			var courseId =  data.course.id;
                        			var index = this.find('courseId', courseId);
                        			if(index == -1){
                        				componentCombo.editModeCourseId = courseId;
                        				courseId = data.parentCourse.id;
                        				var recIndex = this.find('courseId', courseId);
                        				var tempArr = [];
                        				var rec = this.getAt(recIndex);
                        				tempArr.push(rec);
                        				courseCombo.fireEvent('select', courseCombo , tempArr);
                        			}
                        			if (success) {
                        				courseCombo.setValue(courseId);
                        			}
                        		}
                        	});
                        }
	 				
                        /**
         				 * Load document grid on the bases of course id
         				 */
          				//var documentStore=$this.getStore('coursetransaction.coursereading.CourseReadingUpload');
                        var grid=$this.getCoursereadingdocumentgrid();
    			    	var documentStore = grid.getStore();
                        documentStore.getProxy().extraParams = {
                        	courseReadingId: id
                        };
                        documentStore.load();                        
                     
					}
				});
				}
			} else {
				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				grid.getStore().reload();
			}
				},
			deleteCourseReading:function(){
				var $this = this;
				var grid = $this.getCoursereadinglist();
				if (grid.getSelectionModel().getCount() > 0) {
					showConfirmMessage(getCourseTxCommonTranslation('COURSE_READ'), getCommonTranslation("DELETE_CONFIRM_MESSAGE"),
					function(btn, text) { 
						if (btn == 'yes') {
							var records = grid.getSelectionModel().getSelection()[0];
							var id = records.data.coursePlanningAndReadingId;
							Ext.Ajax.request({
								method : "DELETE",
								type : 'rest',
								url : SERVERURL.COURSE_READING_DELETE + '?id=' + id,
								headers : {
									'Content-Type' : 'application/json'
								},
								params : {
									id : id
								},
								success : function(form,action) {
								  showSuccessMessage(getCourseTxCommonTranslation('COURSE_READ'),getCourseTxCommonTranslation('COURSE_READING_DELTE'));
									grid.getStore().reload();
								}
							});
						}
					});
				} else {
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				}
				
			},			
				showAssingCourse:function(serialNo, currentRecord){
	            	var me = this;
	            	var grid = this.getAssigncourseslist();
	            	var ObjModel = [];
	            	if(serialNo == 1){
	            		var assignCoursesModel = new Academia.model.coursetransaction.coursereading.AssignCourses();
	            		assignCoursesModel.set("serialNo", serialNo);
	            		assignCoursesModel.set("academicTermId", '');
	            		assignCoursesModel.set("courseId", '');
	            		assignCoursesModel.set("courseDepartment", '');
	            		assignCoursesModel.set("dateRequired", '');
	            		assignCoursesModel.set("userRequestedId", '');
	            		assignCoursesModel.set("issuedNumber", '');
	            		assignCoursesModel.set("isAddDeleteRow", true);
	            		ObjModel.push(assignCoursesModel);
	            		grid.getStore().loadRawData(ObjModel, true);
	            		grid.getStore().sort([
	            			{
	            				property : 'serialNo',
	            				direction: 'ASC'
	            			}
	            			]);
	            		grid.down('#assignCourse_Add_Id').hide();
	            		grid.down('#academicTerm').setVisible(true);
	            		grid.down('#fldContCVSaveItemId').setVisible(true);
	            		grid.down('#resetBtn').setVisible(true);
	            	}
	            	else if(serialNo>1){
	            		var academicTermId = currentRecord.get('academicTermId');
	            		var assignCoursesModel = new Academia.model.coursetransaction.coursereading.AssignCourses();
	            		assignCoursesModel.set("serialNo", serialNo);
	            		assignCoursesModel.set("courseId", '');
	            		assignCoursesModel.set("courseDepartment", '');
	            		assignCoursesModel.set("dateRequired", '');
	            		assignCoursesModel.set("userRequestedId", '');
	            		assignCoursesModel.set("issuedNumber", '');
	            		assignCoursesModel.set("isAddDeleteRow", true);
	            		ObjModel.push(assignCoursesModel);
	            		grid.getStore().loadRawData(ObjModel, true);
	            		if(!isNullOrEmpty(academicTermId)){
	            			assignCoursesModel.set("academicTermId", academicTermId);
	            		}
	            		else{
	            			assignCoursesModel.set("academicTermId", '');
	            		}
	            		ObjModel.push(assignCoursesModel);
	            		grid.getStore().loadRawData(ObjModel, true);
	            		grid.getStore().sort([
	            			{
	            				property : 'serialNo',
	            				direction: 'ASC'
	            			}
	            			]);
	            	}
	            	grid.getStore().sorters.clear();
					
				       /* var formWindow = this.getAssingcourseform();
				        if (!formWindow) {
				            Ext.widget('assingcourseform');
				            formWindow = this.getAssingcourseform();
				        }
				        formWindow.show();
				        var academylocationId=this.getCurrentAcademyLocation();
				        var multiselectALbox=formWindow.down('#multiselectAcademyLocationId');
				        multiselectALbox.getStore().load({
   						 callback:function(record,callback){
   							multiselectALbox.setValue(academylocationId);
   						 }
   					 });*/
				      				
				},
				showAssingCourseWithAcademicTerm: function(serialNo, academicTermVal){

	            	var me = this;
	            	var grid = this.getAssigncourseslist();
	            	var ObjModel = [];
	            	if(serialNo == 1){
	            		var assignCoursesModel = new Academia.model.coursetransaction.coursereading.AssignCourses();
	            		assignCoursesModel.set("serialNo", serialNo);
	            		assignCoursesModel.set("academicTermId", academicTermVal);
	            		assignCoursesModel.set("courseId", '');
	            		assignCoursesModel.set("courseDepartment", '');
	            		assignCoursesModel.set("dateRequired", '');
	            		assignCoursesModel.set("userRequestedId", '');
	            		assignCoursesModel.set("issuedNumber", '');
	            		assignCoursesModel.set("isAddDeleteRow", true);
	            		ObjModel.push(assignCoursesModel);
	            		grid.getStore().loadRawData(ObjModel, true);
	            		grid.getStore().sort([
	            			{
	            				property : 'serialNo',
	            				direction: 'ASC'
	            			}
	            			]);
	            		grid.down('#assignCourse_Add_Id').hide();
	            	}
	            	else if(serialNo>1){
	            		var assignCoursesModel = new Academia.model.coursetransaction.coursereading.AssignCourses();
	            		assignCoursesModel.set("serialNo", serialNo);
	            		assignCoursesModel.set("courseId", '');
	            		assignCoursesModel.set("courseDepartment", '');
	            		assignCoursesModel.set("dateRequired", '');
	            		assignCoursesModel.set("userRequestedId", '');
	            		assignCoursesModel.set("issuedNumber", '');
	            		assignCoursesModel.set("isAddDeleteRow", true);
	            		ObjModel.push(assignCoursesModel);
	            		grid.getStore().loadRawData(ObjModel, true);
	            		if(!isNullOrEmpty(academicTermId)){
	            			assignCoursesModel.set("academicTermId", academicTermId);
	            		}
	            		ObjModel.push(assignCoursesModel);
	            		grid.getStore().loadRawData(ObjModel, true);
	            		grid.getStore().sort([
	            			{
	            				property : 'serialNo',
	            				direction: 'ASC'
	            			}
	            			]);
	            	}
	            	grid.getStore().sorters.clear();
				},
				addAssignCourses:function(){
				  var $this = this;	
				  var grid = $this.getCoursereadinglist();
				  if(!isNullOrEmpty(grid)){
					  var records = grid.getSelectionModel().getSelection();

					  if (records != undefined && records != ""&& records != null) {
						  var courseReadingId = records[0].data.coursePlanningAndReadingId;

						  var form = Ext.getCmp('assingCourseForm_Id').getForm();
						  var values = form.getValues();

						  var multiCourseVariant = form.findField('multiCourseVariant').getValue();

						  var courseMaps = [];
						  for ( var i in multiCourseVariant) {
							  courseMaps.push({
								  "courseVariantId" : multiCourseVariant[i].data.id,
								  "courseReadingId"  : courseReadingId
							  });
						  };

						  var submitUrl;
						  if (form.findField('id').getSubmitValue() == null
								  || form.findField('id').getSubmitValue() == "") {
							  submitUrl = SERVERURL.ASSIGN_COURSE_CREATE;
						  } else {
							  periodBreaks.set("id", values.id);
//							  submitUrl = SERVERURL.PERIOD_BREAK_UPDATE;
						  }
						  var formData = Ext.encode(courseMaps);
						  $this.applyWindowMask(); 
						  Ext.Ajax.request({
							  type : 'rest',
							  url : submitUrl,
							  jsonData : formData,
							  method : 'POST',
							  success : function(form, action) {
								  $this.hideWindowMask();
								  var grid = $this.getCoursereadinglist();
								  var records = grid.getSelectionModel().getSelection();
								  var courseReadingId = records[0].data.coursePlanningAndReadingId;
								  showSuccessMessage(getCourseTxCommonTranslation('ASSIGN_COURSE_VARIANT'), getCommonTranslation("SUCCESS"));
								  $this.getStore('coursetransaction.coursereading.AssignCourseGrid').load();
								  /*store.getProxy().extraParams = {
		    						 courseReadingId: courseReadingId
		    					 };*/
								  $this.getAssingcourseform().close();
							  }
						  });
					  }
				  } else{
					  var grid = this.getAssigncourseslist();
					  var courseReadingId = grid.config.readingId;
					  var courseId = grid.config.courseId;

					  var form = Ext.getCmp('assingCourseForm_Id').getForm();
					  var values = form.getValues();

					  var multiCourseVariant = form.findField('multiCourseVariant').getValue();

					  var courseMaps = [];
					  for ( var i in multiCourseVariant) {
						  courseMaps.push({
							  "courseVariantId" : multiCourseVariant[i].data.id,
							  "readingId"  : courseReadingId,
							  "courseId": multiCourseVariant[i].data.value
						  });
					  };

					  var submitUrl;
					  if (form.findField('id').getSubmitValue() == null
							  || form.findField('id').getSubmitValue() == "") {
						  submitUrl = SERVERURL.ASSIGN_COURSE_CREATE;
					  } else {
						  periodBreaks.set("id", values.id);
//						  submitUrl = SERVERURL.PERIOD_BREAK_UPDATE;
					  }
					  var formData = Ext.encode(courseMaps);
					  $this.applyWindowMask(); 
					  Ext.Ajax.request({
						  type : 'rest',
						  url : submitUrl,
						  jsonData : formData,
						  method : 'POST',
						  success : function(form, action) {
							  $this.hideWindowMask();
							  showSuccessMessage(getExaminationTranslation("MAP_CV"), getCommonTranslation("SUCCESS"));
							  $this.getStore('coursetransaction.coursereading.AssignCourseGrid').load();
							  $this.getAssingcourseform().close();
						  }
					  });
				  }
				},
				updateAssignCourse:function(){
					var $this = this;
					var grid = this.getAssigncourseslist();
					var records = grid.getStore().getRange();
					var readingId = grid.config.readingId;
					var records = grid.getStore().getRange();
					var arryRecordToSave=[];
					var isFlag = true;
					for(var i in records) {
						
						var editorField = grid.down('[dataIndex=courseId]').getEditor();
						var store = editorField.getStore();
						var record = store.findRecord('id',records[i].data.courseId);
						
						if(!isNullOrEmpty(records[i].data.academicTermId) && !isNullOrEmpty(records[i].data.courseReadingId) && !isNullOrEmpty(records[i].data.courseVariantId) && !isArray(records[i].data.courseId)){
							var fromDate = null ;
							if(!isNullOrEmpty(records[i].data.dateRequired))
							{	
								fromDate = Ext.Date.format(new Date(records[i].data.dateRequired), CONSTANTS.NEW_SUBMIT_DATE_FORMAT);//records[i].data.fromDate;
								if(fromDate==="NaN-NaN-0NaN" || fromDate === "0NaN-NaN-NaN" || fromDate === "NaN-0NaN-NaN"){
									var date = moment(records[i].data.dateRequired, "DD/MM/YYYY").format("MM-DD-Y")
									fromDate= Ext.Date.format(new Date(date), CONSTANTS.NEW_SUBMIT_DATE_FORMAT);
								}
							}
							if(records[i].dirty){
								arryRecordToSave.push({
									"courseReadingId":records[i].data.courseReadingId,
									"academicTerm":this.getIdValueJson(records[i].data.academicTermId),
									"dateRequired":fromDate,
									"id":records[i].data.id,
									"userRequestedBy":this.getIdValueJson(records[i].data.userRequestedId),
									"issuedNumber": records[i].data.issuedNumber,
									"courseVariantId": records[i].data.courseVariantId
								});	
							}
						}
	        			else{
	        				arryRecordToSave=[];
	        				isFlag = false;
	        				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ENTER_MANDATORY_FIELDS'));
	        			}
					}
					
					if(!isNullOrEmpty(arryRecordToSave) && arryRecordToSave.length>0 && isFlag == true){
						var submitUrl = SERVERURL.ASSIGN_COURSE_VARIANT_UPDATE;
						var formData = Ext.encode(arryRecordToSave);
						Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						Ext.Ajax.request({
							type : 'rest',
							url : submitUrl,
							jsonData : formData,
							method : 'POST',
							success : function(form, action) {
								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.PATH_FIND_COURSE_READING_ACADEMIC_TERM,
									method: 'GET',
									params: {
										readingId:readingId
									},
									success: function(response, action) {
										Ext.getBody().unmask();
										var responseData = Ext.decode(response.responseText);
										if(!isNullOrEmpty(responseData) && responseData.length>0){
											grid.getStore().removeAll();
											grid.getStore().clearFilter();
											var ObjModel = [];
											var cntLC = 1;
											responseData.forEach(function(obj){
												var dateVal = obj.dateRequired;
												if(!isNullOrEmpty(obj.dateRequired)){
													dateVal = dateRender(obj.dateRequired);
												}
												var assignCoursesModel = new Academia.model.coursetransaction.coursereading.AssignCourses();
												assignCoursesModel.set("serialNo", cntLC);
												assignCoursesModel.set("academicTermId", obj.academicTermId);
												assignCoursesModel.set("courseId", obj.courseId);
												assignCoursesModel.set("courseDepartment", obj.courseDepartment);
												assignCoursesModel.set("dateRequired", dateVal);
												assignCoursesModel.set("userRequestedId", obj.userRequestedId);
												assignCoursesModel.set("issuedNumber", obj.issuedNumber);
												assignCoursesModel.set("readingId", obj.readingId);
												assignCoursesModel.set("id", obj.id);
												assignCoursesModel.set("courseReadingId", obj.courseReadingId);
												assignCoursesModel.set("courseVariantId", obj.courseVariantId);
												assignCoursesModel.set("courseVariantCode", obj.courseVariantCode);
												assignCoursesModel.set("isAddDeleteRow", true);
												assignCoursesModel.commit();
												ObjModel.push(assignCoursesModel);
												cntLC = cntLC+1;
											});
											grid.down('#academicTerm').reset();
											grid.getStore().loadRawData(ObjModel, true);
											
											showSuccessMessage(getCommonTranslation("RESOURCE_REQUEST_DETAILS"), getCommonTranslation("SUCCESS"));
										}
									}
								});
								grid.getSelectionModel().deselectAll();
							}
						});
					}
				},
				deleteAssingCourse:function(){
					 var grid = this.getAssigncourseslist();
				 	 if (grid.getSelectionModel().getCount() > 0) {
				 		showConfirmMessage(getExaminationTranslation("MAP_CV"),getCommonTranslation("DELETE_CONFIRM_MESSAGE"),
				 		 function(btn, text) {
				 			 if (btn == 'yes'){
				 				 var records = grid.getSelectionModel().getSelection()[0];
				 				 var id = records.data.id;
				 				 Ext.Ajax.request({
				 					 method : "DELETE",
				 					 type : 'rest',
				 					 url : SERVERURL.ASSIGN_COURSE_DELETE + '?id='+ id,
				 					 headers : {
				 						 'Content-Type' : 'application/json'
				 					 },
				 					 params : {
				 						 id : id
				 					 },
				 					 success : function(form,action) {
				 						showSuccessMessage(getExaminationTranslation("MAP_CV"),getCommonTranslation("SUCCESS"));
				 						grid.getStore().reload();
				 					 }
				 				 });
				 			 }
				 		 });
				 	 } else {
				 		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
				 	 }
				},
				downloadStudentDocumentFile : function(){
		          	var this$ = this;
		          	var documentGrid = this$.getCoursereadingdocumentgrid();
		          	var record = documentGrid.getSelectionModel().getSelection()[0];
		          	var documentId = record.get("documentId");
		          	if(!isNullOrEmpty(documentId)){
		              	this$.getDocumentController().downloadDocumentFile(documentId);
		              }
		          },
                  disableMoreActionPivileges: function(gridReference,permissionsMap) {
			    	
			    	var associatedAcadLocationIds = new Array();
			    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			    	
					var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
			    	buttonsToolBar = gridReference.query('toolbar')[0];
			    	var splitbuttons = buttonsToolBar.query('splitbutton')[0];
			    	splitbuttons.setVisible(false);
					
			    	Ext.each(splitbuttons.menu.items.items, function(menuItems) {
						menuItems.setVisible(false);
			    	});
			    	
			    	Ext.each(permissionList, function(privilege) {
			    		if (privilege === 'MOREACTIONS') {
			        		var button = buttonsToolBar.query('#spBtnMoreActions')[0];
			        		if(!isNullOrEmpty(button)){
			        			button.setVisible(true);
			        		}        		
			        	}
			    		if (privilege === 'ASSIGN') {
			        		var button = buttonsToolBar.query('#textLinked')[0];
			        		if(!isNullOrEmpty(button)){
			        			button.setVisible(true);
			        		}        		
			        	}
			    	});
			    },
			    courseReadingRender:function(){
			    	var academyLocationId = this.getCurrentAcademyLocation();
			    	var academyLocationIds = this.getUserAccessibleAL();
			    	var portalId = this.getCurrentLoggedPortalId();
			    	if(isNullOrEmpty(academyLocationIds)){
			    		academyLocationIds=academyLocationId;
			    	}
	            	  var facultyId = null;
	            	  if(portalId==2){
	            		  facultyId = facultyId = this.getCurrentlyLoggedInUser().id;
	            	  }
	        		  var store = this.getStore('attendance.AssignedCoursesFacultyStore');
	        		  store.getProxy().extraParams = {
	        			  //academyLocationId:academyLocationId,
	        			  academyLocationIds:academyLocationIds,
	        			  facultyId:facultyId
	        		  };
	        		  store.load();
			    },
			    removeDocStore:function(){
			    	var $this = this;
			    	var grid=$this.getCoursereadingdocumentgrid();
			    	var store = grid.getStore();
//			    	var length = store.data.length;
			    	store.removeAll();
			    },
			    getUserAccessibleAL:function(){
			    	   var academyLocationId = [];
			    	   var academyLocationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademyLocations();
			    	   for(var i=0; i<academyLocationList.length; i++){
			    		   academyLocationId.push(academyLocationList[i].id);
			    	   }
			    	   return academyLocationId.join();
			       },
			       hideShowButtonsByPivileges: function(permissionsMap, gridReference) {
			    	   var associatedAcadLocationIds = new Array();
			    	   associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
			    	   var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
			    	   buttonsToolBar = gridReference.query('toolbar')[0];
			    	   var buttons = buttonsToolBar.query('button');
			    	   Ext.each(buttons, function(button) {
			    		   if(button.itemId == "btnSaveMapCourseVarItemId"){
			    			   button.setVisible(true);
			    		   }else{
			    			   button.setVisible(false);
			    		   }
			    	   });

			    	   Ext.each(permissionList, function(privilege) {
			    		   if (privilege === 'CREATE') {
			    			   var button = buttonsToolBar.query('#assignCourse_Add_Id')[0];
			    			   if(!isNullOrEmpty(button)){
			    				   button.setVisible(true);
			    			   }        		
			    		   }/*else if (privilege === 'DELETE') {
			    			   var button = buttonsToolBar.query('#assignCourse_Delete_Id')[0];
			    			   if(!isNullOrEmpty(button)){
			    				   button.setVisible(true);
			    			   }  
			    		   }*/ else if (privilege === 'EXPORT') {
			    			   var buttonsArray = new Array();
			    			   buttonsArray.push(buttonsToolBar.query('#btnExportToPDF')[0]);
			    			   buttonsArray.push(buttonsToolBar.query('#btnExportToExcel')[0]);
			    			   Ext.each(buttonsArray, function(button) {
			    				   if(!isNullOrEmpty(button)){
			    					   button.setVisible(true);
			    				   }  
			    			   });
			    		   }
			    	   });
			       }
 });
