/*
 *  @author Dharmendra.prajapati
 * 
 */
Ext.define('Academia.controller.coursetransaction.homework.HomeworkSubmissionController',{
	extend: 'Academia.controller.base.BaseController',
	models : [
	          'coursetransaction.homework.submissiondetails.SubmissionDetailsGrid',
	          'coursetransaction.homework.submissiondetails.GroupValue',
	          'coursetransaction.homework.submissiondetails.SubmissionDetails' ],

	          stores : [
	                    'coursetransaction.homework.submissiondetails.SubmissionDetailsGrid',
	                    'coursetransaction.homework.submissiondetails.GroupName',
	                    'coursetransaction.homework.submissiondetails.StudentName',
	                    'coursetransaction.homework.submissiondetails.StudentHomeworkAssignmentDocument'
	                    ],

	                    views : [
	                             'Academia.view.coursetransaction.homework.submissiondetails.SubmissionDetailsGrid',
	                             'Academia.view.coursetransaction.homework.submissiondetails.SubmissionDetails',
	                             'Academia.view.coursetransaction.homework.submissiondetails.StudentHomeworkAssignmentDocumentList',
	                             'Academia.view.coursetransaction.homework.submissiondetails.StudentHomeworkAssignmentDocumentGrid',
	                             'Academia.view.coursetransaction.homework.submissiondetails.SubmissionDetailsGridNew',
	                             ],
	                             config:{

	                            	 /*
	                            	  * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
	                            	  */
	                            	 /**
	                            	  * @cfg {Array} HOMEWORK_ASSIGNMENT_SUBMISSION_DETAIL_PERMISSIONS array (required)
	                            	  * The array of permissions to use for Access control wise enabling and disabling buttons.
	                            	  * @accessor
	                            	  */
	                            	 HOMEWORK_ASSIGNMENT_SUBMISSION_DETAIL_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HOMEWORK_ASSIGNMENT_SUBMISSION_DETAIL_PRIVILEGES'),
	                            	 
	                            	 HOMEWORK_ASSIGNMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('HOMEWORK_ASSIGNMENT_PRIVILEGES') ,
	                            	 STUDENT_HOMEWORK_ASSIGNMENT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_HOMEWORK_ASSIGNMENT_PRIVILEGES') ,
	                            	 FACULTY_HOMEWORK_ASSIGNMENT_DETAIL_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_HOMEWORK_ASSIGNMENT_DETAIL_PRIVILEGES'),
	                            	 PARENT_PORTAL_HOME_WORK_ASSIGNMENTS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_HOME_WORK_ASSIGNMENTS_PRIVILEGES')
	                             
	                             },          
	                             refs : [{
	                            	 ref : 'submissiondetailsgrid',
	                            	 selector : 'submissiondetailsgrid'
	                             },{
	                            	 ref : 'submissiondetailsgridnew',
	                            	 selector : 'submissiondetailsgridnew'
	                             }, {
	                            	 ref : 'submissiondetails',
	                            	 selector : 'submissiondetails'
	                             }, {
	                            	 ref : 'submissionDetails',
	                            	 selector : 'submissiondetails form'
	                             }, {
	                            	 ref : 'assignmentdetails',
	                            	 selector : 'assignmentdetails'
	                             }, {
	                            	 ref : 'studenthomeworkassignmentdocumentlist',
	                            	 selector : 'studenthomeworkassignmentdocumentlist'
	                             },{
	                            	 ref : 'studenthomeworkassignmentdocumentgrid',
	                            	 selector : 'studenthomeworkassignmentdocumentgrid'
	                             }],

	                             init : function() {
	                            	 this.control({

	                            		 'submissiondetails button[itemId=btnCancel]' : {
	                            			 click : function() {
	                            				 this.cancelSubmissionDetails();
	                            			 }
	                            		 },
	                            		 'submissiondetails button[itemId=btnSubmit]' : {
	                            			 click : function() {
	                            				 this.addSubmissionDetails();
	                            			 }
	                            		 },
	                            		 'submissiondetailsgrid button[itemId=btnEdit]' : {
	                            			 click : function() {
	                            				 this.editSubmissionDetails();
	                            			 }
	                            		 },
	                            		 'submissiondetailsgridnew button[itemId=btnEdit]' : {
	                            			 click : function() {
	                            				 this.editSubmissionDetails();
	                            			 }
	                            		 },
	                            		 'submissiondetailsgrid' : {
	                            			 render : function(grid) {
	                            				 this.submissionGridRender(grid);
	                            				 var form = this.getAssignmentdetails().getForm();
	                            				 var gridStatus = form.findField('gridStatus').getValue();
	                            				 if (!isNullOrEmpty(gridStatus)) {
	                            					 if(gridStatus == 'View'){
	                            						 var grid = this.getSubmissiondetailsgrid();
	                            						 if(grid.isVisible()==false){
	                            							 var grid = this.getSubmissiondetailsgridnew();
	                            						 }
	                            						 buttonsToolBar = grid.query('toolbar')[0];

	                            						 var editButton = buttonsToolBar.query('#btnEdit')[0];
	                            						 editButton.setVisible(false);
	                            						 var editButton = buttonsToolBar.query('#submissionUploadDocument')[0];
	                            						 editButton.setVisible(false);
	                            						 grid.selModel.selectAll(true);
	                            						 grid.selModel.setLocked(true);	

	                            					 }
	                            				 }
	                            			 },
	                            			 selectionchange: function(column, selected,eOpts ){
	                            				 var grid=this.getSubmissiondetailsgrid();
	                            				 var form = this.getAssignmentdetails().getForm();
	                            				 var onlineSubmission = form.findField('hwonlineSubmission').getValue();
	                            				 var buttonsToolBar = grid.query('toolbar')[0];
	                            				 var uploadDocumentBtn= buttonsToolBar.query('#submissionUploadDocument')[0];
	                            				 var submitAssignmentBtn= buttonsToolBar.query('#btnEdit')[0];
											     if(!onlineSubmission.onlineRadio_ID) {
	 												uploadDocumentBtn.setDisabled(true);
												 }
												 else if(selected.length == 1){
	                            					 uploadDocumentBtn.setDisabled(false);
	                            					 submitAssignmentBtn.setDisabled(false);
	                            				 }else if(selected.length > 1){
	                            					 submitAssignmentBtn.setDisabled(false);
	                            					 uploadDocumentBtn.setDisabled(true);
	                            				 }else{
	                            					 uploadDocumentBtn.setDisabled(true);
	                            					 submitAssignmentBtn.setDisabled(true);
	                            				 }
	                            			 },
	                            			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
	                            				 var $this = this;
	                            				 var documentGrid = $this.getSubmissiondetailsgrid();
	                            				 if(documentGrid.isVisible()==false){
	                            					 var documentGrid = this.getSubmissiondetailsgridnew();
	                            				 }
	                            				 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

	                            				 if (columnName == "documents" && record.data.documents.length == 1) {

	                            					 if (e.target.tagName == 'A') {

	                            						 var document = record.get("documents");
	                            						 var documentId = document[0].encryptedDocId;

	                            						 if (!isNullOrEmpty(documentId)) {
	                            							 $this.getDocumentController().downloadDocumentFile(documentId);
	                            						 }
	                            					 }
	                            				 }else if(columnName=='documents' && record.data.documents.length > 1){
	                            					 this.linkNoOfStudentHomeworkAssignmentDocuments(grid, rowIndex, record);
	                            				 }
	                            			 }
	                            		 },
	                            		 'submissiondetailsgridnew' : {
	                            			 render : function(grid) {
	                            				 this.submissionGridRender(grid);
	                            				 var form = this.getAssignmentdetails().getForm();
	                            				 var gridStatus = form.findField('gridStatus').getValue();
	                            				 if (!isNullOrEmpty(gridStatus)) {
	                            					 if(gridStatus == 'View'){
	                            						 var grid = this.getSubmissiondetailsgrid();
	                            						 if(grid.isVisible()==false){
	                            							 var grid = this.getSubmissiondetailsgridnew();
	                            						 }
	                            						 buttonsToolBar = grid.query('toolbar')[0];

	                            						 var editButton = buttonsToolBar.query('#btnEdit')[0];
	                            						 editButton.setVisible(false);
	                            						 var editButton = buttonsToolBar.query('#submissionUploadDocument')[0];
	                            						 editButton.setVisible(false);
	                            						 grid.selModel.selectAll(true);
	                            						 grid.selModel.setLocked(true);	

	                            					 }
	                            				 }
	                            			 },
	                            			 selectionchange: function(column, selected,eOpts ){
	                            				 var grid=this.getSubmissiondetailsgridnew();
	                            				 var buttonsToolBar = grid.query('toolbar')[0];
	                            				 var uploadDocumentBtn= buttonsToolBar.query('#submissionUploadDocument')[0];
	                            				 var submitAssignmentBtn= buttonsToolBar.query('#btnEdit')[0];
	                            				 if(selected.length == 1){
	                            					 uploadDocumentBtn.setDisabled(false);
	                            					 submitAssignmentBtn.setDisabled(false);
	                            				 }else if(selected.length > 1){
	                            					 submitAssignmentBtn.setDisabled(false);
	                            					 uploadDocumentBtn.setDisabled(true);
	                            				 }else{
	                            					 uploadDocumentBtn.setDisabled(true);
	                            					 submitAssignmentBtn.setDisabled(true);
	                            				 }
	                            			 },
	                            			 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
	                            				 var $this = this;
	                            				 var documentGrid = $this.getSubmissiondetailsgridnew();
	                            				 if(documentGrid.isVisible()==false){
	                            					 var documentGrid = this.getSubmissiondetailsgridnew();
	                            				 }
	                            				 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

	                            				 if (columnName == "documents" && record.data.documents.length == 1) {

	                            					 if (e.target.tagName == 'A') {

	                            						 var document = record.get("documents");
	                            						 var documentId = document[0].encryptedDocId;

	                            						 if (!isNullOrEmpty(documentId)) {
	                            							 $this.getDocumentController().downloadDocumentFile(documentId);
	                            						 }
	                            					 }
	                            				 }else if(columnName=='documents' && record.data.documents.length > 1){
	                            					 this.linkNoOfStudentHomeworkAssignmentDocuments(grid, rowIndex, record);
	                            				 }
	                            			 }
	                            		 },
	                            		 'submissiondetails' : {
	                            			 render : function() {
	                            				 var $this = this;
	                            				 var form = this.getAssignmentdetails().getForm();
	                            				 var assignmentId = form.findField('responseId').getValue();
	                            				 var store = this.getStore('coursetransaction.homework.submissiondetails.GroupName');
	                            				 store.getProxy().extraParams = {
	                            					 id : assignmentId
	                            				 };
	                            				 store.load();

	                            			 }
	                            		 },
	                            		 'submissiondetails customcombobox#groupName_Id' : {
	                            			 select : function(obj, record) {
	                            				 var groupName = record[0].data.value;
	                            				 var form = this.getAssignmentdetails().getForm();
	                            				 var assignmentId = form.findField('responseId').getValue();
	                            				 var store = this.getStore('coursetransaction.homework.submissiondetails.StudentName');

	                            				 store.getProxy().extraParams = {
	                            					 homeWorkAssignmentId : assignmentId,
	                            					 groupName : groupName
	                            				 };
	                            				 store.load();
	                            			 }
	                            		 },

	                            		 'submissiondetailsgrid [itemId=submissionUploadDocument]': {
	                            			 click: function() {
	                            				 this.submissionDocumentUpload();
	                            			 }
	                            		 }, 
	                            		 'submissiondetailsgridnew [itemId=submissionUploadDocument]': {
	                            			 click: function() {
	                            				 this.submissionDocumentUpload();
	                            			 }
	                            		 }, 
	                            		 'documentformwindow[itemId=submissionDocItemId] simpledocumentform[itemId=simpleDocumentForm] button[itemId=documentFormSubmitButtonId]':{
	                            			 click: function(){
	                            				 this.getUploadDocument();
	                            			 }
	                            		 },
	                            		 'studenthomeworkassignmentdocumentgrid button[itemId=downloadDocumentItemId]':{
	         	             				click:function(obj){
	         	             					this.downloadAllHomeworkAssignmentDocumentFormsZip();
	         	             				}
	         	             			},
	         	             			'studenthomeworkassignmentdocumentgrid':{
	         	             				render: function(grid){
	         	             					var portalId = this.getCurrentLoggedPortalId();
	         	             					setTimeout(function(){
	         	             						grid.doLayout();
	         	             					},300);
	         	             					if(portalId==7){
	         	             						 this.disableDownloadAllPivileges(grid,this.getPARENT_PORTAL_HOME_WORK_ASSIGNMENTS_PERMISSIONS());
	         	             					 }
	         	             					 else if(portalId==2){
	         	             						 this.disableDownloadAllPivileges(grid,this.getFACULTY_HOMEWORK_ASSIGNMENT_DETAIL_PERMISSIONS());
	         	             					 }else if(portalId==3){
	         	             						 this.disableDownloadAllPivileges(grid,this.getSTUDENT_HOMEWORK_ASSIGNMENT_PRIVILEGES()); 
	         	             					 }else{
	         	             						 this.disableDownloadAllPivileges(grid,this.getHOMEWORK_ASSIGNMENT_PERMISSIONS()); 
	         	             					 }
	         	             	 			},
	         	             				cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
	         	             					var $this = this;
	         	             					var documentGrid = $this.getStudenthomeworkassignmentdocumentgrid();
	         	             					var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
	         	             					if (columnName == "name") {
	         	             						if (e.target.tagName == 'A') {
	         	             							var documentId = record.raw.encryptedDocId;
	         	             							if (!isNullOrEmpty(documentId)) {
	         	             								$this.getDocumentController().downloadDocumentFile(documentId);
	         	             							}
	         	             						}
	         	             					}
	         	             				}
	         	             			},
	         	             			'submissiondetails customcombobox[itemId=assignmentStatus_Id]' : {
	                            			 change : function(obj, record) { 
	                            				 var form = this.getSubmissiondetails();
	                            				 var assignmentStatus = obj.value;
	                            				 var selectedAssignmentStatus = form.down('#selectedAssignmentStatus').getValue();
	                            				 if(selectedAssignmentStatus == 'Pending') {
	                            					 if(assignmentStatus == 'ReSubmitted') {
		                            					 form.down('#reSubmissionDate').setVisible(true);
		                            					 form.down('#reSubmissionDueDate').setVisible(true);
		                            					 this.setAllowBlank(form.down('#reSubmissionDueDate'), false);
		                            					 form.down('#reSubmissionDueDate').setValue(new Date());
		                            				 } else if(assignmentStatus == 'Submitted') {
		                            					 form.down('#reSubmissionDate').setVisible(false);
		                            					 form.down('#reSubmissionDueDate').setVisible(false);
		                            					 this.setAllowBlank(form.down('#reSubmissionDueDate'), false);
		                            					 form.down('#reSubmissionDueDate').setValue(new Date());
		                            					 form.down('#isResubmissionRequired_id').reset();
		                            					 form.down('#isResubmissionRequired_id').setVisible(true);
		                            				 } else {
		                            					 form.down('#reSubmissionDate').reset();
		                            					 form.down('#reSubmissionDate').setVisible(false);
		                            					 form.down('#reSubmissionDueDate').reset();
		                            					 form.down('#reSubmissionDueDate').setVisible(false);
		                            					 this.setAllowBlank(form.down('#reSubmissionDueDate'), true);
		                            					 form.down('#isResubmissionRequired_id').reset();
		                            					 form.down('#isResubmissionRequired_id').setVisible(false);
		                            				 }
	                            				 }else if(selectedAssignmentStatus == 'Resubmitted') {
	                            					 if(assignmentStatus == 'Submitted') {
		                            					 form.down('#reSubmissionDate').setVisible(false);
		                            					 form.down('#reSubmissionDueDate').setVisible(false);
		                            					 this.setAllowBlank(form.down('#reSubmissionDueDate'), false);
		                            					 form.down('#submissionDate').setVisible(false);
		                            					 this.setAllowBlank(form.down('#submissionDate'), true);
		                            					 form.down('#reSubmissionDueDate').setValue(new Date());
		                            					 form.down('#isResubmissionRequired_id').reset();
		                            					 form.down('#isResubmissionRequired_id').setVisible(true);
		                            				 }else if(assignmentStatus == 'Completed') {
		                            					 form.down('#reSubmissionDate').setVisible(false);
		                            					 form.down('#reSubmissionDueDate').setVisible(false);
		                            					 this.setAllowBlank(form.down('#reSubmissionDueDate'), false);
		                            					 form.down('#submissionDate').setVisible(false);
		                            					 this.setAllowBlank(form.down('#submissionDate'), true);
		                            					 form.down('#reSubmissionDueDate').setValue(new Date());
		                            					 form.down('#isResubmissionRequired_id').reset();
		                            					 form.down('#isResubmissionRequired_id').setVisible(false);
		                            				 } else {
		                            					 form.down('#reSubmissionDate').reset();
		                            					 form.down('#reSubmissionDate').setVisible(false);
		                            					 form.down('#reSubmissionDueDate').reset();
		                            					 form.down('#reSubmissionDueDate').setVisible(false);
		                            					 this.setAllowBlank(form.down('#reSubmissionDueDate'), true);
		                            					 form.down('#submissionDate').setVisible(false);
		                            					 this.setAllowBlank(form.down('#submissionDate'), true);
		                            					 form.down('#isResubmissionRequired_id').reset();
		                            					 form.down('#isResubmissionRequired_id').setVisible(false);
		                            				 }
	                            				 } else if(selectedAssignmentStatus == 'Submitted') {
	                            					 if(assignmentStatus == 'Submitted') {
		                            					 form.down('#reSubmissionDate').setVisible(false);
		                            					 form.down('#reSubmissionDueDate').setVisible(false);
		                            					 this.setAllowBlank(form.down('#reSubmissionDueDate'), false);
		                            					 form.down('#submissionDate').setVisible(false);
		                            					 this.setAllowBlank(form.down('#submissionDate'), true);
		                            					 form.down('#reSubmissionDueDate').setValue(new Date());
		                            					 form.down('#isResubmissionRequired_id').reset();
		                            					 form.down('#isResubmissionRequired_id').setVisible(true);
		                            				 } else {
		                            					 form.down('#reSubmissionDate').reset();
		                            					 form.down('#reSubmissionDate').setVisible(false);
		                            					 form.down('#reSubmissionDueDate').reset();
		                            					 form.down('#reSubmissionDueDate').setVisible(false);
		                            					 this.setAllowBlank(form.down('#reSubmissionDueDate'), true);
		                            					 form.down('#submissionDate').setVisible(false);
		                            					 this.setAllowBlank(form.down('#submissionDate'), true);
		                            					 form.down('#isResubmissionRequired_id').reset();
		                            					 form.down('#isResubmissionRequired_id').setVisible(false);
		                            				 }
	                            				 }
	                            			 }
	                            		 },
	             						'submissiondetails radiogroup[itemId=isResubmissionRequired_id]': {
	             							change:function(obj,data){
	             								var form = obj.up('submissiondetails');
	             								var value = obj.getValue();
	             								var isResubmissionRequired = value.isResubmissionRequire_ID;
	             								if(isResubmissionRequired){
	             									form.down('#reSubmissionDate').setVisible(true);
	             									form.down('#reSubmissionDueDate').setVisible(true);
	             									this.setAllowBlank(form.down('#reSubmissionDueDate'), false);
	             									form.down('#reSubmissionDueDate').setValue(new Date());

	             								}else{
	             									form.down('#reSubmissionDate').setVisible(false);
	             									form.down('#reSubmissionDueDate').setVisible(false);
	             									this.setAllowBlank(form.down('#reSubmissionDueDate'), true);
	             									form.down('#reSubmissionDueDate').setValue(new Date());
	             								}

	             							}
	             						},
	                            	 });
	                             },
	                             submissionGridRender:function(grid){
	                            	 var forms = this.getAssignmentdetails();
	                            	 var form = forms.getForm();
	                            	 var assignmentId = form.findField('responseId').getValue();
	                            	 var onlineSubmission = form.findField('hwonlineSubmission').getValue();
	                            	 var assignmentType = form.getValues().assignmentType;
	                            	 var user=this.getCurrentlyLoggedInUser();
	                            	 var userId=user.id;
	                            	 var userPortalId=this.getCurrentLoggedPortalId();
	                            	 if(userPortalId!=3){
	                            		 userId =null;
	                            	 }
	                            	 if(userPortalId == 7) {
	                            		 var userInfo = this.getCurrentlyLoggedInUserInfoForPortal();
	                            		 if(!isNullOrEmpty(userInfo) && userInfo != undefined && userInfo != null ){
	                            			 userId=userInfo.student.id;
	                            		 }
	                            	 }
	                            	 var uploadedBy=null;
	                            	 if(userPortalId==3 || userPortalId==7){
	                            		 uploadedBy="student";
	                            	 }else{
	                            		 uploadedBy="faculty";
	                            	 }
	                            	 var grid=this.getSubmissiondetailsgrid();
	                            	 if(grid.isVisible()==false){
            							 var grid = this.getSubmissiondetailsgridnew();
            						 }
	                            	 if(assignmentType == 'group') {
	                            		 grid.columns[0].show();
	                            	 } else {
	                            		 grid.columns[0].hide();
	                            	 }
	                            	 this.doAccessControlValidation(grid, this.getHOMEWORK_ASSIGNMENT_SUBMISSION_DETAIL_PERMISSIONS());
	                            	 this.disableMoreActionSequencePivileges(grid, this.getHOMEWORK_ASSIGNMENT_SUBMISSION_DETAIL_PERMISSIONS());
	                            	 if(!onlineSubmission.onlineRadio_ID) {
	                            		 grid.down('#submissionUploadDocument').setDisabled(true);
	                            	 }
	                            	 var store = this.getStore('coursetransaction.homework.submissiondetails.SubmissionDetailsGrid');
	                            	 store.getProxy().extraParams = {
	                            		 id : assignmentId,
	                            		 docType:'SUBMITED_DOC',
	                            		 userId: userId,
	                            		 portalId:userPortalId
	                            	 };
	                            	 store.load();
	                             },
	                             showSubmissionDetails : function() {
	                            	 var $this = this;
	                            	 var forms = $this.getAssignmentdetails();
	                            	 var formWindow = $this.getSubmissiondetails();
	                            	 if (!formWindow) {
	                            		 Ext.widget('submissiondetails');
	                            		 formWindow = $this.getSubmissiondetails();
	                            	 }
	                            	 formWindow.show();
	                             },

	                             editSubmissionDetails : function(){
	                            	 var $this = this;
	                            	 var grid = $this.getSubmissiondetailsgrid();
	                            	 if(grid.isVisible()==false){
            							 var grid = this.getSubmissiondetailsgridnew();
            						 }
	                            	 var portalId = $this.getCurrentLoggedPortalId();
	                            	 if (grid.getSelectionModel().getCount() > 0) {

	                            		 var selectedRecord = grid.getSelectionModel().getSelection();
	                            		 var groupNameStatus = false;
	                            		 var whetherGroupLeader = false;
	                            		 var submissionsDateFlag=false;
	                            		 var studentIds=[];
	                            		 if(grid.getStore().getRange()[0].data.assignmentType=="group"){
	                            			 for(i=0;i<grid.getStore().getRange().length;i++){
	                            				 studentIds.push(grid.getStore().getRange()[i].data.studentCodeId);
	                            				 if(grid.getStore().getRange()[i].data.groupName != null){
		                            				 groupNameStatus = true;
		                            			 }
		                            			 if(grid.getStore().getRange()[i].data.whetherGroupLeader != null){
		                            				 whetherGroupLeader = true;
		                            			 }
	                            			 }
	                            		 }else{
	                            		 for(i=0;i<selectedRecord.length;i++){
	                            			 studentIds.push(selectedRecord[i].data.studentCodeId);
	                            			 if(selectedRecord[i].data.groupName != null){
	                            				 groupNameStatus = true;
	                            			 }
	                            			 if(selectedRecord[i].data.whetherGroupLeader != null){
	                            				 whetherGroupLeader = true;
	                            			 }
	                            		 }
	                            		 }
	                            		 var studentIdsStr = studentIds.join(',');
	                            		 if(whetherGroupLeader == true || (!groupNameStatus || groupNameStatus == false) || (portalId != 3)){		// PORTAL ID check for restrict for student can not submit assignment only group lead and faculty can submit assignment
	                            			if(portalId==2){
	                            			 Ext.Ajax.request({
			                            		 type : 'rest',
			                            		 url : SERVERURL.PATH_GET_SURVEY_COMPLETED,
			                            		 params : {
			                            			 studentIds : studentIdsStr,
			             						},
			             						method : 'GET',
			                            			 success: function(response) {
			                            				 if (!isNullOrEmpty(response.responseText)){
			                            					 	if (response.responseText=="true") {
			                            					 		$this.checkConditionSubmission(selectedRecord,grid);
			                            					 	} else {
			                            					 		showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('LIME_SURVEY_IS_PENDING_ALERT_FACULTY'));
			                            					 	}
			                            				 }else{
			                            					 	$this.checkConditionSubmission(selectedRecord,grid);
			                            					 }
			                            				 }
			                            	 });
	                            			}else{
	                            				$this.checkConditionSubmission(selectedRecord,grid);
	                            			}
	                            			 

	                            		 }else{
	                            			 showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('GROUP_LEAD_ALERT'));
	                            		 }

	                            	 }else{
	                            		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                            	 }
	                             },
	                             addSubmissionDetails : function() {
	                            	 var $this = this;
	                            	 var submissionForm = $this.getSubmissionDetails().getForm();
	                            	 var values = submissionForm.getValues();
	                            	 var studentComboBox = this.getSubmissiondetails().down('customcombobox#studentName_Id');
	                            	 var studentStore = studentComboBox.getStore();
	                            	 var students = studentStore.data.items; 

	                            	 if(values.isResubmissionRequire_ID==true && values.reSubmissionDate==""){
	                            		 values.assignmentStatus="Pending";
	                            	 }
	                            	
	                            	 if(values.isResubmissionRequire_ID==true && values.reSubmissionDate!=null && values.reSubmissionDate!=""){
	                            		 values.assignmentStatus="Resubmitted";
	                            	 }
	                            	 
	                            	 if(values.isResubmissionRequire_ID==false){
	                            		 reSubmissionDueDate=null;
	                            	 }else{
	                            		 reSubmissionDueDate=values.reSubmissionDueDate+" 11:59 PM";
	                            	 }
	                            	 var assignmentForm = this.getAssignmentdetails().getForm();
	                            	 var assignmentId = assignmentForm.findField('responseId').getValue();

	                            	 var grid = this.getSubmissiondetailsgrid();
	                            	 if(grid.isVisible()==false){
            							 var grid = this.getSubmissiondetailsgridnew();
            						 }
	                            	 var detailsSubmission =[];
	                            	 var selectRecords = grid.getSelectionModel().getSelection();
	                            	 var isGroup = false;
	                            	 if(!(assignmentForm.findField('assignmentType_Id').getValue().assignmentType == 'group')){
	                            		 for(var i=0;i<selectRecords.length;i++){
	                            			 if(!isNullOrEmpty(selectRecords[i].data.groupName)){
	                            				 isGroup = true;
	                            			 }
	                            			 detailsSubmission.push({	
	                            				 "id" :selectRecords[i].data.id,
	                            				 "studentId":selectRecords[i].data.studentId,
	                            				 "submissionDate":values.submissionDate+" 00:00 AM",
	                            				 "resubmissionDueDate":reSubmissionDueDate,
	                            				 "resubmissionDate":values.reSubmissionDate+" 00:00 AM",
	                            				 "submissionStatus": values.assignmentStatus,
	                            				 "courseHomeWorkAssignmentId":assignmentId,
	                            				 "whetherGroupLeader":false
	                            			 });
	                            		 }
	                            	 }else{
	                            		 /**
	                            		  * In case of group 
	                            		  */
	                            		 var groupNames = [];
	                            		 for(var j=0; j < selectRecords.length ;j++){
	                            			if(groupNames.length == 0 || groupNames.indexOf(selectRecords[j].data.groupName) == -1) {
	                            				grid.getStore().filter("groupName", selectRecords[j].data.groupName);
	                            				groupNames.push(selectRecords[j].data.groupName);
		             	    					for(var i=0; i < grid.getStore().getRange().length ;i++){
		             	    						detailsSubmission.push({	
			                            				 "id":grid.getStore().getRange()[i].data.id,
			                            				 "studentId":grid.getStore().getRange()[i].data.studentId,
			                            				 "groupName": grid.getStore().getRange()[i].data.groupName,
			                            				 "submissionDate":values.submissionDate+" 00:00 AM",
			                            				 "resubmissionDueDate":reSubmissionDueDate,
			                            				 "resubmissionDate":values.reSubmissionDate+" 00:00 AM",
			                            				 "submissionStatus":values.assignmentStatus,
			                            				 "courseHomeWorkAssignmentId":assignmentId,
			                            				 "whetherGroupLeader":grid.getStore().getRange()[i].data.whetherGroupLeader
			                            			 });
		             	    					}
		             	    					grid.getStore().clearFilter();
	                            			}
	             	    				}
	                            	 }
	                            	 var submitUrl;
	                            	 submitUrl = SERVERURL.HW_SUMBMISSION_UPDATE;
	                            	 $this.applyWindowMask(); 
	                            	 Ext.Ajax.request({
	                            		 type : 'rest',
	                            		 url : submitUrl,
	                            		 jsonData : detailsSubmission,
	                            		 method : 'POST',
	                            		 success : function(form, action) {
	                            			 $this.hideWindowMask();
	                            			 showSuccessMessage(getCourseTxCommonTranslation('HW_SUBMISSION_DETAILS'),getCommonTranslation('SUCCESS'));
	                            			 $this.getSubmissiondetails().close();
	                            			 $this.submissionGridRender(grid);
	                            			 if(assignmentForm.findField('assignmentType_Id').getValue().assignmentType == 'group') {
	                     						var groupGridStore = $this.getStore('coursetransaction.homework.assignmentdetails.AssignmentGroupBlank');
	                     						groupGridStore.reload();
	                            			 } else if(assignmentForm.findField('assignmentType_Id').getValue().assignmentType == 'individual'){
	                            				 var store = $this.getStore('coursetransaction.homework.assignmentdetails.AssignmentIndividualBlank');
		                            			 store.reload();
	                            			 } else{
	                            				 var store = $this.getStore('coursetransaction.homework.assignmentdetails.AssignmentDetailGridStore');
		                            			 store.reload();
	                            			 }
	                            			 grid.getSelectionModel().deselectAll(true);
	                            			 var buttonsToolBar = grid.query('toolbar')[0];
	                            			 var uploadDocumentBtn= buttonsToolBar.query('#submissionUploadDocument')[0];
	                            			 var submitAssignmentBtn= buttonsToolBar.query('#btnEdit')[0];
	                            			 uploadDocumentBtn.setDisabled(true);
	                            			 submitAssignmentBtn.setDisabled(true);
	                            		 }
	                            	 });
	                             },
	                             cancelSubmissionDetails:function(){
	                            	 this.getSubmissiondetails().close();
	                             },
	                             /**
	                              * checkConditionSubmission check Assignment Details online submission is checked or not
	                              * if it is checked then user able to edit submission details. 
	                              */
	                             checkConditionSubmission:function(records,grid,submissionsDate){
	                            	 var $this = this;
	                            	 var assignmentForm = this.getAssignmentdetails().getForm();
	                            	 var assignmentId = assignmentForm.findField('responseId').getValue();
	                            	 var portalId = $this.getCurrentLoggedPortalId();
	                            	 $this.showSubmissionDetails();
	                            	 var flag= true ;
	                            	 var form = $this.getSubmissionDetails();
	                            	 var assignmentStatusField = form.down('#assignmentStatus_Id');
	                            	 if (records != undefined && records != "" && records != null) {
	                            		 var startDate = assignmentForm.findField('publishDate').getValue();
	                            		 var endDate = assignmentForm.findField('dateSubmitted').getValue();
	                            		 models = grid.getStore().getRange();
	                            		 var selectedSubmissionStatus = null;
	                            		 var storeArray = [];
	                            		 for(var i in records) {
	                            			 if(isNullOrEmpty(selectedSubmissionStatus) || selectedSubmissionStatus == records[i].data.submissionStatus) {
	                            				 selectedSubmissionStatus = records[i].data.submissionStatus;
	                            			 } else if((selectedSubmissionStatus == 'Pending' && records[i].data.submissionStatus == 'Drafted') ||
	                            					 (selectedSubmissionStatus == 'Drafted' && records[i].data.submissionStatus == 'Pending')){
	                            				 
	                            			 }else if((selectedSubmissionStatus != 'Pending' && selectedSubmissionStatus == 'Submitted' && records[i].data.submissionStatus == 'Resubmitted') ||
	                            					 (selectedSubmissionStatus != 'Pending' && selectedSubmissionStatus == 'Resubmitted' && records[i].data.submissionStatus == 'Submitted')){
	                            				 form.down('#selectedAssignmentStatus').setValue('Resubmitted');
	                            				 form.down('#submissionDate').setVisible(false);
	                            				 form.down('#reSubmissionDate').setVisible(false);
	                            				 form.down('#reSubmissionDueDate').setVisible(false);
	                            				 storeArray.push({
	                            					 'id':'Completed',
	                            					 'value': 'Completed'
	                            				 });
	                            				 var store1 = Ext.create('Ext.data.Store', {
	                            					 fields: ['id','value'],
	                            					 data : storeArray
	                            				 });
	                            				 assignmentStatusField.bindStore(store1);
	                            				 assignmentStatusField.setValue('Completed'); 
	                            				 flag=false;
	                            			 }else {
	                            				 selectedSubmissionStatus = false;
	                            				 $this.getSubmissiondetails().close();
	                            				 showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('DIFFERENT_ASSIGNMENT_STATUS_SELECTED'));
	                            				 return;
	                            			 }
	                            		 }
	                            		 $this.showSubmissionDetails();
	                            		 var form = $this.getSubmissionDetails();
	                            		 var assignmentStatusField = form.down('#assignmentStatus_Id');
	                            		 if(selectedSubmissionStatus =='Pending' || selectedSubmissionStatus =='Drafted') {
	                            			 form.down('#selectedAssignmentStatus').setValue('Pending');
	                            			 storeArray.push({
	                            				 'id':'Submitted',
	                            				 'value': 'Submitted'
	                            			 });
	                            			 /*storeArray.push({
	                            				 'id':'ReSubmitted',
	                            				 'value': 'Resubmitted'
	                            			 });*/
	                            			 storeArray.push({
	                            				 'id':'Completed',
	                            				 'value': 'Completed'
	                            			 });
	                            			 var store1 = Ext.create('Ext.data.Store', {
	                            				 fields: ['id','value'],
	                            				 data : storeArray
	                            			 });
	                            			 assignmentStatusField.bindStore(store1);
	                            			 assignmentStatusField.setValue('Submitted');
	                            			 form.down('#submissionDate').setValue(new Date());
	                            			 if(!isNullOrEmpty(records[i].data.resubmissionDueDate)){
	                            				 form.down('[name=isResubmissionRequire_ID]').setValue({isResubmissionRequire_ID:true});
	                            			 }

	                            		 } else if (selectedSubmissionStatus =='Submitted' && flag==true) {
	                            			 form.down('#selectedAssignmentStatus').setValue('Submitted');
	                            			 form.down('#submissionDate').setVisible(false);
	                            			 form.down('#reSubmissionDate').setVisible(false);
	                            			 form.down('#reSubmissionDueDate').setVisible(false);
	                            			 storeArray.push({
	                            				 'id':'Submitted',
	                            				 'value': 'Submitted'
	                            			 });
	                            			 storeArray.push({
	                            				 'id':'Completed',
	                            				 'value': 'Completed'
	                            			 });
	                            			 var store1 = Ext.create('Ext.data.Store', {
	                            				 fields: ['id','value'],
	                            				 data : storeArray
	                            			 });
	                            			 assignmentStatusField.bindStore(store1);
	                            			 assignmentStatusField.setValue('Submitted');
	                            			 if(!isNullOrEmpty(records[i].data.resubmissionDueDate)){
	                            				 form.down('[name=isResubmissionRequire_ID]').setValue({isResubmissionRequire_ID:true});
	                            				 form.down('[name=reSubmissionDueDate]').setValue(new Date(records[i].data.resubmissionDueDate));
	                            			 }
	                            		 }else if (selectedSubmissionStatus =='Resubmitted') {
	                            			 form.down('#selectedAssignmentStatus').setValue('Resubmitted');
	                            			 form.down('#submissionDate').setVisible(false);
	                            			 form.down('#reSubmissionDate').setVisible(false);
	                            			 form.down('#reSubmissionDueDate').setVisible(false);
	                            			 /*storeArray.push({
	                            				 'id':'Submitted',
	                            				 'value': 'Submitted'
	                            			 });*/
	                            			 storeArray.push({
	                            				 'id':'Completed',
	                            				 'value': 'Completed'
	                            			 });
	                            			 var store1 = Ext.create('Ext.data.Store', {
	                            				 fields: ['id','value'],
	                            				 data : storeArray
	                            			 });
	                            			 assignmentStatusField.bindStore(store1);
	                            			 assignmentStatusField.setValue('Completed');
	                            		 }
	                            		 form.down("#submissionDate").setMinValue(startDate);
	                            		 form.down("#reSubmissionDate").setMinValue(startDate);
	                            		 form.down("#reSubmissionDueDate").setMinValue(startDate);
	                            	 }

	                             },

	                             submissionDocumentUpload:function(){
	                            	 var $this=this;
	                            	 var grid = this.getSubmissiondetailsgrid();
	                            	 if(grid.isVisible()==false){
            							 var grid = this.getSubmissiondetailsgridnew();
            						 }
	                            	 if(grid.getSelectionModel().getCount() ==  1){
	                            		 var checkDocument=false;
	                            		 var selectedRecord = grid.getSelectionModel().getSelection()[0];
	                            		 var groupHwAssignmentId=selectedRecord.data.id;
	                            		 var studentId;
	                            		 var homeworkAssignmentController=$this.getController('Academia.controller.coursetransaction.homework.HomeworkAssignmentController');
	                            		 var studentIds=[];
	                            		 if(grid.getStore().getRange()[0].data.assignmentType=="group"){
	                            			 for(i=0;i<grid.getStore().getRange().length;i++){
	                            				 studentIds.push(grid.getStore().getRange()[i].data.studentCodeId);
	                            				 if(grid.getStore().getRange()[i].data.groupName != null){
		                            				 groupNameStatus = true;
		                            			 }
		                            			 if(grid.getStore().getRange()[i].data.whetherGroupLeader != null){
		                            				 whetherGroupLeader = true;
		                            			 }
	                            			 }
	                            		 }else{
	                            			 studentIds.push(selectedRecord.data.studentCodeId);
	                            		 }
	                            		 var studentIdsStr = studentIds.join(',');
	                            		 if(selectedRecord.data.hwonlineSubmission){
	                            		  if(selectedRecord.data.submissionStatus!= "Submitted"){
	                            			  if(selectedRecord.data.submissionStatus=="Resubmitted"){
	                            				  //homeworkAssignmentController.linkHomeworkAssignmentDocuments(groupHwAssignmentId,"ReSubmitted");  
	                            				  showWarningMessage(getCommonTranslation('ALERT'),getPersonModuleTranslation('THIS_ASSIGNMENT_HAS_BEEN_ALREADY_SUBMITTED'));
	                            				  checkDocument=true;
	                            			  }else{
	                            				  if(portalId==2){
	     	                            			 Ext.Ajax.request({
	     			                            		 type : 'rest',
	     			                            		 url : SERVERURL.PATH_GET_SURVEY_COMPLETED,
	     			                            		 params : {
	     			                            			 studentIds : studentIdsStr,
	     			             						},
	     			                            		 method : 'GET',
	     			                            			 success: function(response) {
	     			                            				 if (!isNullOrEmpty(response.responseText)){
	     			                            					 	if (response.responseText=="true") {
	     			                            					 		homeworkAssignmentController.linkHomeworkAssignmentDocuments(groupHwAssignmentId,null);
	     			                            					 	} else {
	     			                            					 		showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('LIME_SURVEY_IS_PENDING_ALERT_FACULTY'));
	     			                            					 	}
	     			                            				 }else{
	     			         											homeworkAssignmentController.linkHomeworkAssignmentDocuments(groupHwAssignmentId,null);
	     			         										}
	     			         								} 
	     			                            	 });
	                            				  }else{
	                            					  homeworkAssignmentController.linkHomeworkAssignmentDocuments(groupHwAssignmentId,null);
	                            				  }
	                            			  }
	                            			  
		                            		 }else{
		                            			 showWarningMessage(getCommonTranslation('ALERT'),getPersonModuleTranslation('THIS_ASSIGNMENT_HAS_BEEN_ALREADY_SUBMITTED'));
		                            			 checkDocument=true;
		                            		 }
	                            		  }        		
	                            	}else if(grid.getSelectionModel().getCount() ==  0){
	                            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                            	}else{
	                            		 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ONLY_ONE_RECORD')); //Please select a record  
	                            	 }
	                             },
	                             getDocumentController : function() {
	                            	 var this$ = this;
	                            	 return this$.getController('Academia.controller.document.DocumentController');
	                             },
	                             /**
	                              *  for upload document
	                              */
	                             getUploadDocument : function(){
	                            	 var $this=this;
	                            	 var grid = this.getSubmissiondetailsgrid();
	                            	 if(grid.isVisible()==false){
            							 var grid = this.getSubmissiondetailsgridnew();
            						 }
	                            	 var isTransient = true;
	                            	 var module = 'homeworkSubmission';
	                            	 var entityId ;
	                            	 var entityType = 'homeworkSubmission';

	                            	 $this.getDocumentController().saveDocumentForm(entityId, module, entityType, 'DOCUMENT', function(success, response, isCallBackTransient){

	                            		 if (grid.getSelectionModel().getCount() > 0) {
	                            			 var record = grid.getSelectionModel().getSelection()[0];
	                            			 var id = record.get("id");
	                            			 var serverCurrentDate=null;
	                            			 var serverTimeZone=null;
	                            			Ext.Ajax.request({
	                                			 type : 'rest',
	                                			 url :SERVERURL.PATH_FIND_SERVER_DATE_TIME,
	                                			 method : 'GET',
	                                			 async: false,
	                                			 success : function(form, action) {
	                                				var data = Ext.JSON.decode(form.responseText);
	                            			 var todayDate = data.serverDateTimeYYYYMMDD;	                            			 
	                            			 var data = {
	                            					 "id": id,
	                            					 "docType": "SUBMITED_DOC",
	                            					 "submissionStatus": "Completed",
	                            					 "submissionDate": todayDate,
	                            					 "documents": [
	                            					               {
	                            					            	   //"createdBy": $this.getIdValueJson(response.createdBy.id),
	                            					            	   "name": response.name,
	                            					            	   "path": response.path,
	                            					            	   "type": response.type
	                            					               }
	                            					               ]
	                            			 };


	                            			 Ext.Ajax.request({
	                            				 type : 'rest',
	                            				 url : SERVERURL.HW_SUMBMISSION_DOC_UPLOAD,
	                            				 jsonData : data,
	                            				 method : 'POST',
	                            				 success : function(response, action) {
	                            					 showSuccessMessage(getCourseTxCommonTranslation('HW_SUBMISSION_DETAILS'), getFeeAndPaymentCommonTranslation('DOCUMENT_UPLOADED_SUCCESSFULLY'));
	                            					 //$this.getTopicgrid().getStore.reload();
	                            					 grid.getStore().load();
	                            					 grid.getSelectionModel().deselectAll(true);
	                            				 }
	                            			 });	

	                                			 }});
	                            		 }
	                            		 $this.getDocumentController().closeDocumentFormWindow();
	                            	 }, isTransient);
	                             },
	                             // ********* Hide  more Action and upload button *************
	                             disableMoreActionSequencePivileges: function(gridReference,permissionsMap) {
	                            	 var associatedAcadLocationIds = new Array();
	                            	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	                            	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	                            	 /*buttonsToolBar = gridReference.query('toolbar')[0];
	                            	 var splitbuttons = buttonsToolBar.query('splitbutton')[0];
	                            	 splitbuttons.setVisible(false);
	                            	 Ext.each(splitbuttons.menu.items.items, function(menuItems) {
	                            		 menuItems.setVisible(false);
	                            	 });*/
	                            	 var uploadDocument = gridReference.down('#submissionUploadDocument');
	                     	    	 uploadDocument.setVisible(false);
	                            	 Ext.each(permissionList, function(privilege) {
	                            		/* if (privilege === 'MOREACTIONS') {
	                            			 var button = buttonsToolBar.query('#spBtnMoreActions')[0];
	                            			 if(!isNullOrEmpty(button)){
	                            				 button.setVisible(true);
	                            			 }        		
	                            		 }*/
	                            		 if (privilege === 'UPLOAD_DOCUMENT') {
	                            			 if(!isNullOrEmpty(uploadDocument)){
	                            				 uploadDocument.setVisible(true);
	                            			 }        		
	                            		 }

	                            	 });
	                             },
	                             linkNoOfStudentHomeworkAssignmentDocuments: function(view, rowIndex, record) {
	                            	 var docWindow = this.getStudenthomeworkassignmentdocumentlist();
	                            	 var ID = record.data.id;
	                            	 var documentsArray = record.data.documents;
	                            	 if (!docWindow) {
	                            		 Ext.widget('studenthomeworkassignmentdocumentlist');
	                            		 docWindow = this.getStudenthomeworkassignmentdocumentlist();
	                            	 }
	                            	 var docWindowStore = docWindow.down('grid').getStore();
	                            	 docWindowStore.removeAll();
	                            	 docWindowStore.loadData(documentsArray);
	                            	 docWindow.show();
	                            	 /*var grid = this.getStudenthomeworkassignmentdocumentgrid();
	                            	 var store = grid.getStore();
	                            	 store.getProxy().extraParams = {
	                            		 ID: ID
	                            	 };
	                            	 store.load();*/
	                             },
	                             downloadAllHomeworkAssignmentDocumentFormsZip:function(){
	                            	 var $this=this;
	                            	 var grid=$this.getStudenthomeworkassignmentdocumentgrid();
	                            	 if (grid.getSelectionModel().getCount() > 0) {
	                            		 var selectedRecord = grid.getSelectionModel().getSelection();
	                            		 var saveModel=[];  
	                            		 var dispatchZipName = "Homework Assigment Document";
	                            		 for(var i in selectedRecord){
	                            			 if(!isNullOrEmpty(selectedRecord[i].get('path'))) {
	                            				 saveModel.push(selectedRecord[i].get('path'));
	                            			 }
	                            		 }
	                            		 var directoryType = CONSTANTS.DIRECTORY_TYPE_BASEDIR;
	                            		 $this.getDocumentController().downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
	                            	 }else{
	                            		 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
	                            	 }

	                             },
	                             disableDownloadAllPivileges:function(grid,permissionsMap) {
	                     	    	var associatedAcadLocationIds = new Array();
	                     	    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	                     			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	                     	    	var downloadAll = grid.down('#downloadDocumentItemId');
	                     	    	downloadAll.setVisible(false);
	                     	    	Ext.each(permissionList, function(privilege) {
	                     	    		if (privilege === 'DOWNLOAD_ALL') {
	                     	        		if(!isNullOrEmpty(downloadAll)){
	                     	        			downloadAll.setVisible(true);
	                     	        		}        		
	                     	        	}
	                     	    	});
	                     	    },
});
