/*
 *  @author Dharmendra.prajapati
 * 
 */
Ext.define('Academia.controller.coursetransaction.promotion.PromotionController', {
	extend : 'Academia.controller.base.BaseController',
	models : [],

	stores : ['common.ProgramByAcademyLocationStore','enquiry.AcademicBatchStore',
	          'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod','attendance.SectionAndFacultyByPeriodID',
	          'coursetransaction.promotion.PromotionType','coursetransaction.promotion.PromotionStatus','coursetransaction.promotion.PromotionList',
	          'coursetransaction.promotion.PromotionRetainStatus','scholarships.LogedInUserAcademyLocationStore','attendance.attendancereport.AcadmyByAdmission',
              'personinfo.common.personalinfo.AttendanceReportProgramGroupStore','common.AcademicTermStoreForIntakeYearId',
              'student.studentJourney.ProgressionStatusStoreForGrid','messaging.StudentsFilterByAcademyLocationIdStore','coursetransaction.promotion.ImportBulkPassoutStatusUpdateStore'
              ],

	views : ['coursetransaction.promotion.PromotionSearch','coursetransaction.promotion.PromotionStructure',
	         'coursetransaction.promotion.PromotionList','coursetransaction.promotion.PromoteRetainStudent','coursetransaction.promotion.ImportPassoutStatusUpdate',
	         'coursetransaction.promotion.ImportPassoutStatusUpdateForm','coursetransaction.promotion.ImportListPassoutStatusUpdate','UploadOptionRadioGroup'
	         ],	           

	         config:{
            	   /*
                  	 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
                   		   	 */
                   	   	/**
                   	        * @cfg {Array} CREATE_TIME_TABLE_PRIVILEGES array (required)
                   	        * The array of permissions to use for Access control wise enabling and disabling buttons.
                   	        * @accessor
                   	        */
	        	 PROMOTION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PROMOTION'),
               },
               
	         refs : [{
	        	 ref : 'promotionstructure',
	        	 selector : 'promotionstructure'
	         },{
	        	 ref : 'promotionsearch',
	        	 selector : 'promotionsearch'
	         },{
	        	 ref : 'promotionlist',
	        	 selector : 'promotionlist'
	         },{
	        	 ref : 'promoteretainstudent',
	        	 selector : 'promoteretainstudent'
	         },{
	        	 ref : 'promoteRetainstudent',
	        	 selector : 'promoteretainstudent form'
	         },{
	        	 ref : 'importpassoutstatusupdateform',
	        	 selector : 'importpassoutstatusupdateform'
	         },{
	        	 ref : 'importlistpassoutstatusupdate',
	        	 selector : 'importlistpassoutstatusupdate'
	         },{
	         	ref: 'uploadoptionradiogroup',
	        	selector: 'uploadoptionradiogroup'
	        }],

	init : function() {
		this.control({
			'promotionsearch':{
				render:function(){
					var $this = this;
					//var academyLocationId = $this.getCurrentAcademyLocation();
					var ALField = $this.getPromotionsearch().down("#academyLocationId");
					$this.setDefaultAcademyLocation(ALField);
					var form = $this.getPromotionsearch();
					var alinfomodel = Academia.model.authentication.ALInfoModel;
					var wheatherSchool = alinfomodel.get('wheatherSchool');
					var structure = $this.getPromotionstructure();
					var aLId = $this.getCurrentAcademyLocation();
					var programGroupCombo = $this.getPromotionsearch().down('#ProgramGroupItemId');
					var programGroupComboStore = programGroupCombo.getStore();
             	    var grid =  structure.down('grid'); 
             	    var gridStore = grid.getStore();
             	   var studentId = form.down('#studentId');
             	    gridStore.removeAll();
					grid.down('#custompagingtoolbar').setVisible(false);
					   if(!wheatherSchool){
						   grid.columns[8].setVisible(true);
						   grid.columns[12].setVisible(true);
							  }
					   if(wheatherSchool){
							form.down('#periodId').hide();
							  }
					    programGroupComboStore.getProxy().extraParams = {
							academyLocationId : aLId
						};
					    studentId.getStore().getProxy().extraParams = {
							academyLocationIds : aLId
						};
					     programGroupComboStore.load();
					     var promotionStatusComobo = $this.getPromotionsearch().down("#promotionStatusId");
						var promotionStatusComoboStore = promotionStatusComobo.getStore();
						promotionStatusComoboStore.getProxy().extraParams = {
						};
						promotionStatusComoboStore.load();
						var programCombo = $this.getPromotionsearch().down('#programId');
						var programstore = programCombo.getStore();
						programstore.getProxy().extraParams = {
							academyLocationId : aLId
						};
						programstore.removeAll();
				}
			},
			'promotionsearch customcombobox#academyLocationId' : {
				select : function(obj, record) {
				 var $this = this;
				 var alId = record[0].get("id");
				 var programCombo = $this.getPromotionsearch().down('#programId');
				 var programGroupCombo = $this.getPromotionsearch().down('#ProgramGroupItemId');
				 var programCoordinate = $this.getPromotionsearch().down('#programCoordinatorId');
				 

				 var programstore = programCombo.getStore();
					programstore.getProxy().extraParams = {
						academyLocationId : alId
					};
					programstore.load();

			    var programGroupComboStore = programGroupCombo.getStore();
			    programGroupComboStore.getProxy().extraParams = {
					academyLocationId : alId
				};
			    programGroupComboStore.load();
			    Ext.defer(function(){
			    	 $this.setParamsStudentCombo();
				},500)
				programCoordinate.reset()
				var programCoordinateStore = programCoordinate.getStore()
				programCoordinateStore.getProxy().extraParams = {
					academyLocationId : obj.getValue(),
				};
			    programCoordinateStore.load();
			   
				}
			},
			'promotionsearch customcombobox#intakeYear' : {
				select : function(obj, record) {
					var $this = this;
					var id = record[0].get("id");
					var programCombo = $this.getPromotionsearch().down('#programId');
					var programGroupCombo = $this.getPromotionsearch().down('#ProgramGroupItemId');
					var academicTerm = $this.getPromotionsearch().down('#academicTerm');
					var academyLocationId = $this.getPromotionsearch().down('#academyLocationId');
					var batchComboBox = this.getPromotionsearch().down('customcombobox#batchId');
					var periodComboBox = this.getPromotionsearch().down('customcombobox#periodId');
					var sectionComboBox = this.getPromotionsearch().down('customcombobox#sectionId');
					
					programCombo.clearValue();
					batchComboBox.clearValue();
					periodComboBox.clearValue();
					sectionComboBox.clearValue();
					programGroupCombo.clearValue();
					academicTerm.clearValue();
					
					batchComboBox.setDisabled(true);
					periodComboBox.setDisabled(true);
					sectionComboBox.setDisabled(true);
					
					var programstore = programCombo.getStore();
					programstore.getProxy().extraParams = {
						academyLocationId : academyLocationId.getValue(),
						intakeYearId : id
					};
					programstore.load();
					varacademicTermStore = academicTerm.getStore();
					varacademicTermStore.getProxy().extraParams = {
						academyLocationIds : academyLocationId.getValue(),
						intakeYearId : id
					};
					varacademicTermStore.load({
						callback: function(record, operation, success) {
							   if (success) {
								   if(record.length==1){
									   academicTerm.setValue(record[0].get('id'));
								   }
							   }
						}
					});
				}
			},
			'promotionsearch customcombobox#academicTerm' : {
				select : function(obj, record) {
					var $this = this;
					var id = record[0].get("id");
					var periodComboBox = this.getPromotionsearch().down('customcombobox#periodId');
					var batchComboBox = this.getPromotionsearch().down('customcombobox#batchId');
					var sectionComboBox = this.getPromotionsearch().down('customcombobox#sectionId');
					var programComboBox = this.getPromotionsearch().down('customcombobox#programId');
					var programGroupComboBox = this.getPromotionsearch().down('customcombobox#ProgramGroupItemId');
					var batchId = this.getPromotionsearch().down('customcombobox#batchId').getValue();
					var intakeYearId = this.getPromotionsearch().down('customcombobox#intakeYear').getValue();
					var academyLocationId = this.getPromotionsearch().down('customcombobox#academyLocationId').getValue();
					
					programGroupComboBox.clearValue();
					programComboBox.clearValue();
					batchComboBox.clearValue();
					periodComboBox.clearValue();
					sectionComboBox.clearValue();
					
					batchComboBox.setDisabled(true);
					periodComboBox.setDisabled(true);
					sectionComboBox.setDisabled(true);
					
					var programStore = programComboBox.getStore();
					programStore.getProxy().extraParams = {
						academicTermId : id,
						intakeYearId:intakeYearId,
						academyLocationId:academyLocationId
					};
					programStore.load();
				}
			},
			'promotionsearch combo#ProgramGroupItemId' : {
				select : function(obj, record) {
					var this$ = this;
					var form=this$.getPromotionsearch();
					var programGroupId = record[0].get("id");
					var programComboBox = this.getPromotionsearch().down('customcombobox#programId');
					var academyLocationId = this$.getCurrentAcademyLocation();
					var batchComboBox = this.getPromotionsearch().down('customcombobox#batchId');
					var periodComboBox = this.getPromotionsearch().down('customcombobox#periodId');
					var sectionComboBox = this.getPromotionsearch().down('customcombobox#sectionId');
					var intakeYearId = this.getPromotionsearch().down('customcombobox#intakeYear').getValue();
					var academicTermId = this.getPromotionsearch().down('customcombobox#academicTerm').getValue();
					
					var programStore = programComboBox.getStore();
					
					programComboBox.clearValue();
					batchComboBox.clearValue();
					periodComboBox.clearValue();
					sectionComboBox.clearValue();
					
					batchComboBox.setDisabled(true);
					periodComboBox.setDisabled(true);
					sectionComboBox.setDisabled(true);
					
					programStore.getProxy().extraParams = {
						intakeYearId:intakeYearId,
						academicTermId:academicTermId,
						programGroupId: programGroupId,
						academyLocationId :academyLocationId
					};
					programStore.load();
				}
			},
			'promotionsearch customcombobox#programId' : {
				select : function(obj, record) {
					var this$=this;
					 var programId = record[0].get("id");
    				 var batchComboBox = this.getPromotionsearch().down('customcombobox#batchId');
    				 var academicTermId = this.getPromotionsearch().down('customcombobox#academicTerm').getValue();
    				 var intakeYearId = this.getPromotionsearch().down('customcombobox#intakeYear').getValue();
     				 var sectionCombo = this.getPromotionsearch().down('customcombobox#sectionId');
     				 var programAL = this.getPromotionsearch().down('#academyLocationId').getValue();
     				 var programCoordinate = this.getPromotionsearch().down('#programCoordinatorId');
     				 
    				 sectionCombo.clearValue();
					 batchComboBox.clearValue();
    				 batchComboBox.setDisabled(false);
    				 var form=this.getPromotionsearch();
    				 var batchStore = batchComboBox.getStore();
    				 batchStore.getProxy().extraParams = {
    					 id: programId,
    					 intakeYearId:intakeYearId,
    					 academicTermId:academicTermId
    				 };
    				 batchStore.load({
						   callback: function(record, operation, success) {
							   if (success) {
								   if(record.length==0){
									   form.down("#sectionId").setDisabled(true);
									   form.down("#sectionId").clearValue();
								   }
								   if(record.length==1){
									   form.down("#batchId").setValue(record[0].get('id'));
									   form.down("#periodId").setDisabled(false); 
									   
								   }
							   }
						   }
					   
          		   
    				 });
    				 Ext.defer(function(){
    					 this$.setParamsStudentCombo();
    				},500)
    				 
    				programCoordinate.reset()
    				var programCoordinateStore = programCoordinate.getStore()
    				programCoordinateStore.getProxy().extraParams = {
    					programId: obj.getValue(),
    					academyLocationId : programAL,
    				};
    			    programCoordinateStore.load();

				}
			},
			'promotionsearch customcombobox#batchId' : {
				change : function(obj, record) {
					var this$=this;
					var batch_Id = this.getPromotionsearch().down('customcombobox#batchId').value;
					var form=this.getPromotionsearch();
					var periodComboBox = this.getPromotionsearch().down('customcombobox#periodId');
					var academicTermId = this.getPromotionsearch().down('customcombobox#academicTerm').getValue();
					var intakeYearId = this.getPromotionsearch().down('customcombobox#intakeYear').getValue();
					periodComboBox.clearValue();
					periodComboBox.setDisabled(false);
					if(batch_Id>0){
						var periodStore = periodComboBox.getStore();
						periodStore.getProxy().extraParams = {
							id: batch_Id,
							isFromPromotion:true,
							academicTermId:academicTermId,
							intakeYearId:intakeYearId
						};
						periodStore.load({
							   callback: function(records, operation, success) {
								   if (success) {
									   if(records.length==0){
										   if(wheatherSchool) {
											   showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('PERIOD_NOT_CREATED'));
	
										   } 
									   }
									   else if(records.length==1){
										   form.down("#periodId").setValue(records[0].get('id'))
										   form.down("#sectionId").setDisabled(false);
										   var store = this$.getStore('attendance.SectionAndFacultyByPeriodID');
										   store.getProxy().extraParams = {
											   periodId: records[0].get('id')
										   };
										   store.load({
											   callback: function(records, operation, success) {
												   if (success) {
													   if(records.length==1){
														   form.down("#sectionId").setValue(records[0].data.sectionId);
										    		 
												   }
												   }
											   }
										   });
	
									   }else{
										   form.down('#periodId').setVisible(true); 
									   }
								   }
							   }
						   
						   
						});
						Ext.defer(function(){
							this$.setParamsStudentCombo();
						},500)
					}
					
				}
			},
			 'promotionsearch customcombobox#periodId' : {
    			 select : function(obj, record) {
    				 var me= this;
    				 var periodId = record[0].get("id");
    				 var sectionCombo = this.getPromotionsearch().down('customcombobox#sectionId');
    				 sectionCombo.clearValue();
    				 sectionCombo.setDisabled(false);
    				 var sectionStore =sectionCombo.getStore(); 
    				 sectionStore.getProxy().extraParams = {	
    					 periodId: periodId
    				 };
    				 sectionStore.load({
						   callback: function(records, operation, success) {
							   if (success) {
								   if(records.length==1){
									   sectionCombo.setValue(records[0].data.sectionId);
					    		 
							   }
							   }
						   }
					   });
    				 Ext.defer(function(){
    					 me.setParamsStudentCombo();
    				},500)
    				
    				  
    				
    			 }
    		 },
    		 'promotionsearch customcombobox#sectionId' : {
    			 select : function(obj, record) {
    				 var me = this;
    				 Ext.defer(function(){
    					 me.setParamsStudentCombo();
    				},500)
    				 
    			 }
    		 },
    		 'promotionsearch button[itemId=searchBtn]' : {
    			 click : this.loadPromotionGrid
    		 },
    		 'promotionsearch button[itemId=resetBtn]' : {
    			 click : function(){
    				 this.getResetPromotion();
    			 }
    		 },
    		 'promotionlist button[itemId=promoteRetainId]': {
    			 click: function() {
    				 var $this = this;
    				 var grid = $this.getPromotionlist();
    				 var allHolds=false;
    				 var flag=false;
    				 if (grid.getSelectionModel().getCount() > 0) {
    					 this.showPromoteRetain();
    				 }else{
    					 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    				 }
    			 }
    		 },
    		 'promotionlist button[itemId=approveId]': {
    			 click: function() {
    				 var $this = this;
    				 var grid = $this.getPromotionlist();
    				 if (grid.getSelectionModel().getCount() > 0) {
    					 showConfirmMessage(getProgramandcourseTranslation('APPROVE'),getProgramandcourseTranslation('CONFIRM_FOR_APPROVE'),
    							 function(btn, text) {
    						 if (btn == 'yes') {
    							 $this.approveStudents(grid); 
    						 }
    					 });
    				 }else{
    					 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    				 }
    			 }
    		 },
    		 'promotionlist button[itemId=saveBtnId]': {
    			 click: function() {
    				 var $this = this;
    				 var grid = $this.getPromotionlist();
    				 if (grid.getSelectionModel().getCount() > 0) {
    					 showConfirmMessage(getProgramandcourseTranslation('ALERT'),getProgramandcourseTranslation('CONFIRM_FOR_SAVE'),
    							 function(btn, text) {
    						 if (btn == 'yes') {
    							 $this.saveStudents(grid); 
    						 }
    					 });
    				 }else{
    					 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
    				 }
    			 }
    		 },
    		 'promoteretainstudent button[itemId=CancelBtn]' : {
    			 click : function(){
    				 this.getPromoteretainstudent().close();
    			 }
    		 },
    		 'promoteretainstudent button[itemId=SubmitBtn]' : {
    			 click : function(btn){
    				 var me = this;
    				 setTimeout(function(){
    					 if(!btn.isDisabled()){
            				 me.savePromotionRetainStudentDetails(btn);
    					 }
    				 },100);
    			 }
    		 },
    		 'promotionstructure':{
    			 beforerender:function(){
    				 this.getPromotionlist().getStore().removeAll();
    			 }
    		 },
    		 'promotionstructure': {
             	afterrender : function(structure){
             		var grid = structure.down('promotionlist');
             		this.getGridHeaderFreeze(grid,structure,false);
             	},
             	 render:function(structure){
    				 this.disableBulkPassoutStatusTab(structure, this.getPROMOTION_PERMISSIONS());
    			 }
             },
         	'importpassoutstatusupdateform':{
				render: function(obj){
					var $this = this;
					var temForm = $this.getImportpassoutstatusupdateform();
					var tempFormValue=temForm.getForm().findField('importUtilityMasterId');
					var grid = $this.getImportlistpassoutstatusupdate();
					var form = $this.getUploadoptionradiogroup();
					var isUploadAll = form.items.items[0].getValue().isUploadAll;
					$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_PASSOUT_STATUS_UPDATE');
					tempFormValue.getStore().load({
						callback:function(record){
							for(var i in record){
								if(record[i].data.value == 'Import Passout Status Update'){
									tempFormValue.setValue(record[i].data.id);
									tempFormValue.setReadOnly(true);
								}
							}
						}
					});
				}
			},
             'importpassoutstatusupdateform button[itemId=SubmitBtn]':{
    				click: function(obj){
    					var temForm = obj.up('importpassoutstatusupdateform');
    			    	var tempFormValue=temForm.getForm().findField('importUtilityMasterId').getRawValue();
    			    	var $this=this;
    			    	var grdStore;
    			    	submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
        	            $this.getHashOfFile(temForm);
    		            setTimeout(function() {
    				    	temForm.getForm().submit({
    				    		method : 'POST',
    				    		url : submitUrl,
    				    		success : function(form, action){
    					        	showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
    					        	temForm.getForm().isValid();
    				    		},
    				    		failure: function(form, action) {
       		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
    				    	    }
    				    	});
    		        	},1000);
    		            Ext.defer(function() {
    		            	var grid = $this.getImportlistpassoutstatusupdate();
    		            	var form = $this.getUploadoptionradiogroup();
    		            	var isUploadAll = form.items.items[0].getValue().isUploadAll;
    		            	$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_PASSOUT_STATUS_UPDATE');
    		            }, 2000, this);
    					
    				}
    			},
    			'importpassoutstatusupdateform button[itemId=resetBtn]':{
    				click: function(obj){
    					var $this=this;
    					var temForm = $this.getImportpassoutstatusupdateform();
    					temForm.down('#uploadFileField').reset();
    					var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
    					uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
    						isUploadAll: false
    					});
    					temForm.getForm().isValid();

    					var tempFormValue=temForm.getForm().findField('importUtilityMasterId');
    					var grid = $this.getImportlistpassoutstatusupdate();
    					var form = $this.getUploadoptionradiogroup();
    					var isUploadAll = form.items.items[0].getValue().isUploadAll;
    					var templateNameValue= "Import Passout Status Update";
                         	$this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_PASSOUT_STATUS_UPDATE');
    					tempFormValue.getStore().load({
    						callback:function(record){
    							for(var i in record){
    								if(record[i].data.value == templateNameValue){
    									tempFormValue.setValue(record[i].data.id);
    									tempFormValue.setReadOnly(true);
    								}
    							}
    						}
    					});
    				}
    			},
    			'importpassoutstatusupdateform uploadoptionradiogroup[itemId=passoutStatusUpdateUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
					 change: function( radioGroup, newValue, oldValue, eOpts){
						 var grid =this.getImportlistpassoutstatusupdate();
						 var form =this.getUploadoptionradiogroup();
						 var isUploadAll = newValue.isUploadAll;
						 this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_PASSOUT_STATUS_UPDATE');
					 }   
				 },
				 'importlistpassoutstatusupdate':{
	    				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
	    					if (e.target.tagName == 'A') {
	    						var fileType=null;
	    						if(cellIndex==1){
	    							fileType='successFile';
	    						}else if(cellIndex==6){
	    							fileType='errorFile';
	    						}else if(cellIndex==7){
	    							fileType='logFile';
	    						}
	    						var documentId = record.get("id");
	    						if (!isNullOrEmpty(documentId)) {
	    							this.getImportListDownloadFile(documentId,fileType);
	    						}
	    					}
	    				}
	    			},
	    			
    			'importlistpassoutstatusupdate button[itemId=btnForce]':{
     				 click : function(obj) {
     					 var grid = this.getImportlistpassoutstatusupdate();
     		            	if (grid.getSelectionModel().getCount() > 0) {
     		            		if(grid.getSelectionModel().getCount() > 1){
     			        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
     			        		}else{
     			        			var this$ = this;
     	 	                	var id = grid.getSelectionModel().selectionStart.data.id;
     	 	                	var urlAppend="?jobName="+id;
     	 	                	var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
     	 	    	        	Ext.Ajax.request({
     	 	    	        		url: submitURL,
     	 	    	        		method: 'GET',
     	 	    	        		success: function(response) {
     	 	    	        			if(response.responseText==="JOB_STATUS_NOT_PENDING"){
     	 	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
     	 	    	        			}else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
     	 	    	        				showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
     	 	    	        			}else if(response.responseText==="SUCCESS"){
     	     	    	        			showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
     	 	    	        			}
     	 	    	        		}
     	 	    	        	});
     			        		}
     		            	} else {
     		            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
     		            	}  
     		            }
     			 },
     			 
    		 'promotionlist':{
    			 render: function(grid) {
    				 this.doAccessControlValidation(grid, this.getPROMOTION_PERMISSIONS());
    				 var permissionsMap = new Ext.util.HashMap();
    				 permissionsMap = this.getPROMOTION_PERMISSIONS();
    				 this.disableMoreActionPivileges(grid,permissionsMap);
    			 },
    			 afterrender:function(grid){
     				var me = this;
     				setTimeout(function(){
     					me.addDataGridConfigButton(grid,me.getPROMOTION_PERMISSIONS());
     				},1500);
     				var gridStore=	Ext.getStore('student.studentJourney.ProgressionStatusStoreForGrid');
     				gridStore.load({
     					callback: function(records, operation, success) {
     						if (records.length==0){
     							//grid.down('#saveBtnId').setDisabled(true);
     							grid.down('#saveBtnId').hide();
     						}
     						else{
     							grid.down('#saveBtnId').show();
     						}
     					}
     				});

     			},
    			 itemclick:function(grid, record, item, index, e, eOpts ){
    				 if(record.data.isEligibleForPromotion == false){
    					 grid.getSelectionModel().deselect(index);
    					 showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('IS_ELIGIBLE_FOR_PROMOTION'));
    				 }
    			 },
    			 cellclick: this.onPromotionListCellClick
    			 
    		 },
    		 'promotionsearch customcombobox#programCoordinatorId' : { 
    			 render : function(combo){            		
             		var academyLocationId = this.getCurrentAcademyLocation();                   
                    	var store = combo.getStore();
                    	store.proxy.extraParams = {
   							 academyLocationId : academyLocationId
   					};	
                 },
    		 },
    		 'promotionlist button[itemId=sendMessageId]': {
    			 click: function() {
    				 var $this = this;
    				 var grid = $this.getPromotionlist();
    				 showConfirmMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('SEND_COMMUNICATION_CONFIRM_MESSAGE'),function(btn,text){
    					 if (btn == 'yes') {
    						 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    						 Ext.Ajax.request({
    							 type: 'rest',
    							 url: SERVERURL.PATH_MANAGE_PROMOTION_SAVE,
    							 method: 'POST',
    							 success: function(response) {
    								 Ext.getBody().unmask();
    								 grid.getStore().reload();
    								 showSuccessMessage(getProgramandcourseTranslation('PROMOTE_SAVE'),getProgramandcourseTranslation('PROMOTION_STATUS_COMMUNICATION_SUCCESS'));
    							 },
    							 failure: function(form, action) {
    								 Ext.getBody().unmask();
    							 }
    						 });
    					 }
    				 });
    			 }
    		 },
		});
	},
	
	loadPromotionGrid:function(){
		var $this = this;
		var promotionForm = $this.getPromotionsearch();
		promotionForm.down('#searchBtn').setDisabled(true);
		var grid = $this.getPromotionlist();
		var form = promotionForm.getForm();
		var values = form.getValues();
		var academyLocationId  = values.academyLocationId;
		var periodId = values.periodId;
		var sectionId = values.sectionId;
		var programGroupId = values.programGroup;
		var programId = values.programId;
		var batchId = values.batchId;
		var promotionType = values.promotionType;
		var programCoordinator = values.programCoordinator;
		var promotionStatus = values.promotionStatus;
		var byPassPeriodDate = values.byPassPeriod;
		
		
		var store = grid.getStore();

		store.getProxy().extraParams = {
			academyLocationId:academyLocationId,
			programId:programId,
			batchId:batchId,
			periodId:periodId,
			sectionId: sectionId,
			promotionType:promotionType,
			programCoordinatorId:programCoordinator,
			promotionStatus:promotionStatus,
			intakeYearId : values.intakeYear,
			academicTermId : values.academicTerm,
			programGroupId:programGroupId,
			studentId:values.studentId,
			isFromPromotion:true,
			byPassPeriod:byPassPeriodDate

		};
		this.resetPageSetting(store);
		store.load({
			callback: function(records, operation, success) {
				promotionForm.down('#searchBtn').setDisabled(false);
			}
		});
		grid.config.searchFilterForm = promotionForm;
	},
	
	showPromoteRetain:function(){
		var $this = this;
		var formWindow = $this.getPromoteretainstudent();
		if (!formWindow) {
			Ext.widget('promoteretainstudent');
			formWindow = $this.getPromoteretainstudent();
		}
		formWindow.show();	
	},     
	savePromotionRetainStudentDetails:function(btn){
		btn.setDisabled(true);
		var $this = this;
		var form = $this.getPromoteRetainstudent().getForm();
		var grid = $this.getPromotionlist();
		var values = form.getValues();
		var id = null;
		var progressionStatus = null;
		
		var statusCombo=$this.getPromoteRetainstudent().down('[name=status]');
		var selectedStatusRec = {};
		if(statusCombo.getValue()){
			var idx = statusCombo.store.findExact(statusCombo.valueField,statusCombo.getValue());
			if(idx != -1){
				selectedStatusRec = statusCombo.store.getAt(idx).data;
			    id = selectedStatusRec.id;
			    progressionStatus = selectedStatusRec.displayOtherLanguage;
			}
		}
		
		var promoteRetainstudent = $this.getPromoteRetainstudent();
		var noOfStudent=0;
		if (grid.getSelectionModel().getCount() > 0) {
			var records = grid.getSelectionModel().getSelection();
			var passoutHold = false;
			var periodNameMap = new Ext.util.HashMap();;
			var promtionRecord = [];
			for(var i=0; i< records.length; i++){
				if(records[i].data.promotionStatus == getProgramandcourseTranslation('PROMOTION_APPROVAL_PENDING') && values.status == "PROMOTE"){
					showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('PROMOTION_REQEST_ALREADY_RASIED'));
					btn.setDisabled(false);
					return;
				}else if(records[i].data.promotionStatus == getProgramandcourseTranslation('RETENTION_APPROVAL_PENDING') && values.status == "RETAIN"){
					showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('RETENTION_REQEST_ALREADY_RASIED'));
					btn.setDisabled(false);
					return;
				}else if(values.status == "PASS_OUT" && ((!isNullOrEmpty(records[i].data.isLastPeriodOfProgram) && !records[i].data.isLastPeriodOfProgram) || 
						 (!isNullOrEmpty(records[i].data.whetherSucceedingProgram) && records[i].data.whetherSucceedingProgram))){
					 passoutHold=true;
					 if(!periodNameMap.containsKey(records[i].data.periodId)) {
						 periodNameMap.add(records[i].data.fromPeriodId, records[i].data.fromProgramName+" - "+records[i].data.fromBatchName+" - "+records[i].data.fromPeriodName);
					 }
				}else if((records[i].data.promotionStatus.toUpperCase() == getProgramandcourseTranslation('PROMOTION_APPROVAL_PENDING').toUpperCase() || records[i].data.promotionStatus == 'Promotion approval pending' ) && values.status == "Demote"){
					showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('PROMOTION_REQEST_ALREADY_RASIED'));
					btn.setDisabled(false);
					return;
				}else if((records[i].data.promotionStatus.toUpperCase() == getProgramandcourseTranslation('RETENTION_APPROVAL_PENDING').toUpperCase() ||  records[i].data.promotionStatus == 'Retention approval pending' ) && values.status == "Demote"){
					showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('RETENTION_REQEST_ALREADY_RASIED'));
					btn.setDisabled(false);
					return;
				}else if((records[i].data.promotionStatus.toUpperCase() == getProgramandcourseTranslation('PASS_OUT_APPROVAL_PENDING').toUpperCase() ||  records[i].data.promotionStatus == 'Pass Out Approval Pending' ) && values.status == "Demote"){
					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PASS_OUT_REQUEST_ALREADY_RASIED'));
					btn.setDisabled(false);
					return;
				}else {
					promtionRecord.push({
						"promotionStatus" : values.status,
						"progressionStatusId" : id,
						"progressionStatus" : progressionStatus,
						"remarks" : values.remarks,
						"fromRecordId" : records[i].data.fromRecordId,
						"examinationStatus" : records[i].data.examinationStatus
					});
				}
			}
			if(passoutHold && promtionRecord.length == 0) {
				var periodName = "";
				var i = 0;
				periodNameMap.each(function(key, value, length){
					if(i == 0){
						periodName = value;
						i++;
					} else{
						periodName = periodName +" , " + value;
					}
				});
				btn.setDisabled(false);
				showWarningMessage(getProgramandcourseTranslation('PROMOTE_RETAIN'), getProgramandcourseTranslation('PASSOUT_CONFIRMATION')+periodName);
				return;
			} else if(passoutHold && promtionRecord.length > 0){
				var periodName = "";
				var i = 0;
				periodNameMap.each(function(key, value, length){
					if(i == 0){
						periodName = value;
						i++;
					} else{
						periodName = periodName +" , " + value;
					}
				});
				showConfirmMessage(getProgramandcourseTranslation('PROMOTE_RETAIN'),getProgramandcourseTranslation('PASSOUT_CONFIRMATION')+periodName+getProgramandcourseTranslation('STILL_CONTINUE'),
						 function(btn, text) {
					 if (btn == 'yes') {
						 $this.saveStudentDetailsForPromotion(btn,promtionRecord,$this);
					 }
				 });
			}else{
				$this.saveStudentDetailsForPromotion(btn,promtionRecord,$this);
			}
		}
},
saveStudentDetailsForPromotion:function(btn,promtionRecord,$this){
	submitUrl = SERVERURL.SAVE_PROMOTION_RETAIN_STUDENT;
	 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	Ext.Ajax.request({
		type : 'rest',
		url : submitUrl,
		jsonData : promtionRecord,
		method : 'POST',
		success : function(form, action) {
			Ext.getBody().unmask();
			if(form.responseText == "PROMOTE_RETAIN_QUEUE_SUCCESS"){
			 showSuccessMessage(getProgramandcourseTranslation('PROMOTE_RETAIN'),getCommonTranslation('PROMOTE_RETAIN_QUEUE_SUCCESS'));
			}else{
			showSuccessMessage(getProgramandcourseTranslation('PROMOTE_RETAIN'),getCommonTranslation('SUCCESS'));
			}
			$this.getPromoteretainstudent().close();
			$this.getPromotionlist().getStore().reload();
		},
		failure: function(response, opts) {
	        Ext.getBody().unmask();
	        btn.setDisabled(false); // Re-enable the button on failure as well.
	    }
	}); 
},
saveStudents:function(grid){
	var $this = this;
	var searchTab = grid.up('tabpanel').getActiveTab();
	if (grid.getSelectionModel().getCount() > 0) {
		var records = grid.getSelectionModel().getSelection();
		
		var progressionStatusStore = Ext.getStore('student.studentJourney.ProgressionStatusStoreForGrid');
		
		var saveArray = [];
		for(var i=0; i<records.length;i++){
			
			var foundIdx = progressionStatusStore.findExact('value',records[i].data.promotionStatus);
			var progressionStatus = '';
			var progressionStatusId = '';
			if(foundIdx != -1){
				progressionStatus = progressionStatusStore.getAt(foundIdx).data.displayOtherLanguage;
			    progressionStatusId = progressionStatusStore.getAt(foundIdx).data.id;
			}
			
			saveArray.push({
				 "id": records[i].data.id,
				 "studentName": records[i].data.studentName,
				 "isEligibleForPromotion": records[i].data.isEligibleForPromotion,
				 "isLastPeriodOfProgram": records[i].data.isLastPeriodOfProgram,
				 "approverName": records[i].data.approverName,
				 "approverId": records[i].data.approverId,
				 "approvalDate": records[i].data.approvalDate,
				 "promotionStatus": records[i].data.promotionStatus,
				 "remarks": records[i].data.remarks,
				 "fromRecordId": records[i].data.fromRecordId,
				 "fromAdmissionCode": records[i].data.fromAdmissionCode,
				 "fromAdmissionId": records[i].data.fromAdmissionId,
				 "fromPeriodId": records[i].data.fromPeriodId,
				 "fromSectionId": records[i].data.fromSectionId,
				 "fromBatchId": records[i].data.fromBatchId,
				 "fromProgramId": records[i].data.fromProgramId,
				 "fromProgramName": records[i].data.fromProgramName,
				 "fromBatchName": records[i].data.fromBatchName,
				 "fromPeriodName": records[i].data.fromPeriodName,
				 "toRecordId": records[i].data.toRecordId,
				 "toAdmissionCode": records[i].data.toAdmissionCode,
				 "toAdmissionId": records[i].data.toAdmissionId,
				 "toSectionId": records[i].data.toSectionId,
				 "toPeriodId": records[i].data.toPeriodId,
				 "toBatchId": records[i].data.toBatchId,
				 "toProgramId": records[i].data.toProgramId,
				 "toProgramName": records[i].data.toProgramName,
				 "toBatchName": records[i].data.toBatchName,
				 "toPeriodName": records[i].data.toPeriodName,
				 "whetherSucceedingProgram":records[i].data.whetherSucceedingProgram,
				 "examinationStatus" : records[i].data.examinationStatus,
				 "progressionStatus": progressionStatus,
				 "progressionStatusId":progressionStatusId
			}); 
			 
		}
	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	submitUrl = SERVERURL.SAVE_PROMOTION_STUDENT;
	Ext.Ajax.request({
		type : 'rest',
		url : submitUrl,
		jsonData : saveArray,
		method : 'POST',
		success : function(form, action) {
			showSuccessMessage(getProgramandcourseTranslation('PROMOTE_SAVE'),getCommonTranslation('SUCCESS'));
			//$this.getPromoteretainstudent().close();
			$this.getPromotionlist().getStore().reload();
			Ext.getBody().unmask();
			
		}
	});
  }	 
},
approveStudents:function(grid){
	var $this = this;
	var searchTab = grid.up('tabpanel').getActiveTab();
	if (grid.getSelectionModel().getCount() > 0) {
		var records = grid.getSelectionModel().getSelection();
		
		var approveArray = [];
		for(var i=0; i<records.length;i++){
			approveArray.push({
				 "id": records[i].data.id,
				 "studentName": records[i].data.studentName,
				 "isEligibleForPromotion": records[i].data.isEligibleForPromotion,
				 "isLastPeriodOfProgram": records[i].data.isLastPeriodOfProgram,
				 "approverName": records[i].data.approverName,
				 "approverId": records[i].data.approverId,
				 "approvalDate": records[i].data.approvalDate,
				 "promotionStatus": records[i].data.promotionStatus,
				 "remarks": records[i].data.remarks,
				 "fromRecordId": records[i].data.fromRecordId,
				 "fromAdmissionCode": records[i].data.fromAdmissionCode,
				 "fromAdmissionId": records[i].data.fromAdmissionId,
				 "fromPeriodId": records[i].data.fromPeriodId,
				 "fromSectionId": records[i].data.fromSectionId,
				 "fromBatchId": records[i].data.fromBatchId,
				 "fromProgramId": records[i].data.fromProgramId,
				 "fromProgramName": records[i].data.fromProgramName,
				 "fromBatchName": records[i].data.fromBatchName,
				 "fromPeriodName": records[i].data.fromPeriodName,
				 "toRecordId": records[i].data.toRecordId,
				 "toAdmissionCode": records[i].data.toAdmissionCode,
				 "toAdmissionId": records[i].data.toAdmissionId,
				 "toSectionId": records[i].data.toSectionId,
				 "toPeriodId": records[i].data.toPeriodId,
				 "toBatchId": records[i].data.toBatchId,
				 "toProgramId": records[i].data.toProgramId,
				 "toProgramName": records[i].data.toProgramName,
				 "toBatchName": records[i].data.toBatchName,
				 "toPeriodName": records[i].data.toPeriodName,
				 "whetherSucceedingProgram":records[i].data.whetherSucceedingProgram,
				 "progressionStatus":records[i].raw.progressionStatus,
				 "byPassPeriod":grid.store.getProxy().extraParams.byPassPeriod,
				 "stdId":records[i].raw.stdId
			}); 
			 
		}
		searchTab.body.mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		submitUrl = SERVERURL.APPROVE_REJECT_STUDENT_REQUEST;
		Ext.Ajax.request({
			type : 'rest',
			url : submitUrl,
			jsonData : approveArray,
			method : 'POST',
			timeout: CONSTANTS.AJAX_TIMEOUT,
			success : function(form, action) {
				//Ext.JSON.decode(form.responseText);
				if(form.responseText == 'PROMOTE_RETAIN_QUEUE_SUCCESS'){
					grid.getStore().load({
						callback: function(){
							searchTab.body.unmask();
						}
					});
					showWarningMessage(getProgramandcourseTranslation('APPROVE'),getCommonTranslation('PROMOTE_RETAIN_QUEUE_SUCCESS'));
				}else if(form.responseText == 'PERIOD_NOT_ELIGIBLE_FOR_PROMOTION'){
					searchTab.body.unmask();
					showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('PERIOD_NOT_ELIGIBLE_FOR_PROMOTION'));
				}else if(form.responseText == 'SEAT_CONFIGURATION_INCOMPLETE'){
					searchTab.body.unmask();
					showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('SEAT_CONFIGURATION_INCOMPLETE'));
				}else if(form.responseText == 'COMPLETION_SETTING_NOT_DONE'){
					searchTab.body.unmask();
					showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('COMPLETION_SETTING_NOT_DONE'))
				}else if(form.responseText == 'STUNDENT_CREDIT_NOT_MATCH_FOR_BATCH'){
					searchTab.body.unmask();
					showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('STUNDENT_CREDIT_NOT_MATCH_FOR_BATCH'))
				}
				else if(form.responseText == 'MINIMUM_CPA_CONDITION_IS_NOT_FULLFILLED'){
					searchTab.body.unmask();
					showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('MINIMUM_CPA_CONDITION_IS_NOT_FULLFILLED'))
				}else if(form.responseText == 'SOME_STUNDENTS_ARE_NOT_ELIGIBLE'){
					showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('SOME_STUNDENTS_ARE_NOT_ELIGIBLE'));
					grid.getStore().load({
						callback: function(){
							searchTab.body.unmask();
						}
					});
				}
				//Start Demotion Alerts
				else if(form.responseText == 'NO_DATA_FOR_OPERATION'){
					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('NO_DATA_FOR_OPERATION'));
					grid.getStore().load({
						callback: function(){
							searchTab.body.unmask();
						}
					});
				}
				
				else if(form.responseText == 'STUDENT_ENROLLED_IN_COURSES_CANT_BE_DEMOTED'){
					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('STUDENT_ENROLLED_IN_COURSES_CANT_BE_DEMOTED'));
					grid.getStore().load({
						callback: function(){
							searchTab.body.unmask();
						}
					});
				}
				else if(form.responseText == 'NOT_ELIGIBLE_FOR_PROMOTION'){
					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('NOT_ELIGIBLE_FOR_PROMOTION'));
					grid.getStore().load({
						callback: function(){
							searchTab.body.unmask();
						}
					});
				}
				//End
				
				else if(form.responseText == 'SUCCESS'){
					showSuccessMessage(getProgramandcourseTranslation('APPROVE'),getCommonTranslation('SUCCESS'));
					grid.getStore().load({
						callback: function(){
							searchTab.body.unmask();
						}
					});
				}else if(form.responseText.match("EXCHANGE_REQUEST_FOR_FUTURE_SEM")){
					//var msgString = getCommonTranslation('EXCHANGE_REQUEST_FOR_FUTURE_SEM');
					//msgString = msgString+ '\n';
					var msgString = 'Admission Id' +'\n';
					msgString = msgString+ form.responseText.replaceAll(',','\n');
					msgString=msgString.replace("EXCHANGE_REQUEST_FOR_FUTURE_SEM","");
					msgString=getCommonTranslation('EXCHANGE_REQUEST_FOR_FUTURE_SEM')+ '\n'+ msgString;
					var link1 = document.createElement('a');
					link1.download = 'PeriodPromotionErrors.log';
					var blob2 = new Blob([msgString], {type: 'text/plain'});
					link1.href = window.URL.createObjectURL(blob2);
					link1.click();
				
				showSuccessMessage(getProgramandcourseTranslation('APPROVE'),getCommonTranslation('SUCCESS'));
				grid.getStore().load({
					callback: function(){
						searchTab.body.unmask();
					}
				});
				}
				else{
					if(!isNullOrEmpty(form.responseText)){
						var msgString = getCommonTranslation('ERROR_MSG_FOR_PROMOTION');
						msgString = msgString+ '\n';
						msgString = msgString+ 'Admission Id' +'\n';
						msgString = msgString+ form.responseText.replaceAll(',','\n');
						
						var link1 = document.createElement('a');
						link1.download = 'PeriodPromotionErrors.log';
						var blob2 = new Blob([msgString], {type: 'text/plain'});
						link1.href = window.URL.createObjectURL(blob2);
						link1.click();
					}
					showSuccessMessage(getProgramandcourseTranslation('APPROVE'),getCommonTranslation('SUCCESS'));
					grid.getStore().load({
						callback: function(){
							searchTab.body.unmask();
						}
					});
				}
			},
			failure: function(form, action){
				searchTab.body.unmask();
				var msg = Ext.JSON.decode(form.responseText);
				try{
					var failureMsg= msg[0].key;
				}
				catch(e){
					var failureMsg= '';
				}
				if(failureMsg == 'PERIOD_NOT_ELIGIBLE_FOR_PROMOTION')
					showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('PERIOD_NOT_ELIGIBLE_FOR_PROMOTION'));
				else if(failureMsg == "PASSING_OUT_API_FAILING")
					showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('COMPLETION_SETTING_NOT_DONE'));
			}
		});
		
	}
},
disableMoreActionPivileges: function(gridReference,permissionsMap) {

	var associatedAcadLocationIds = new Array();
	associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);

	buttonsToolBar = gridReference.query('toolbar')[0];

	var promoteRetainButton = buttonsToolBar.query('#promoteRetainId')[0];
	promoteRetainButton.setVisible(false);

	var approveButton = buttonsToolBar.query('#approveId')[0];
	approveButton.setVisible(false);
	
	var saveButton = buttonsToolBar.query('#saveBtnId')[0];
	saveButton.setVisible(false);
	
	var sendMessage = buttonsToolBar.query('#sendMessageId')[0];
	sendMessage.setVisible(false);

	Ext.each(permissionList, function(privilege) {

		if (privilege === 'PROMOTIONRETAINED') {
			var button = buttonsToolBar.query('#promoteRetainId')[0];
			if(!isNullOrEmpty(button)){
				button.setVisible(true);
			}        		
		}
		if (privilege === 'APPROVE') {
			var button = buttonsToolBar.query('#approveId')[0];
			if(!isNullOrEmpty(button)){
				button.setVisible(true);
			}        		
		}
		if (privilege === 'SAVE') {
			var button = buttonsToolBar.query('#saveBtnId')[0];
			if(!isNullOrEmpty(button)){
				button.setVisible(true);
			}        		
		}
		if (privilege === 'SEND_MESSAGE') {
			if(!isNullOrEmpty(sendMessage)){
				sendMessage.setVisible(true);
			}        		
		}
	});
		},
		getResetPromotion:function(){
			var $this = this;
			$this.getPromotionsearch().getForm().reset();
			var ALField = $this.getPromotionsearch().down("#academyLocationId");
			$this.setDefaultAcademyLocation(ALField);
			var form = $this.getPromotionsearch();
			var alinfomodel = Academia.model.authentication.ALInfoModel;
			var wheatherSchool = alinfomodel.get('wheatherSchool');
			var structure = $this.getPromotionstructure();
			var aLId = $this.getCurrentAcademyLocation();
			var programGroupCombo = $this.getPromotionsearch().down('#ProgramGroupItemId');
			var programGroupComboStore = programGroupCombo.getStore();
			var academicTermCombo = $this.getPromotionsearch().down('#academicTerm');
			var academicTermComboStore = academicTermCombo.getStore();
			var programCombo = $this.getPromotionsearch().down('#programId');
			var programComboStore = programCombo.getStore();
			var grid =  structure.down('grid'); 
			var programCoordinate = this.getPromotionsearch().down('#programCoordinatorId');
			
			if(!wheatherSchool){
				grid.columns[8].setVisible(true);
				grid.columns[12].setVisible(true);
			}
			if(wheatherSchool){
				form.down('#periodId').hide();
			}
			programGroupComboStore.getProxy().extraParams = {
				academyLocationId : aLId
			};
			academicTermComboStore.getProxy().extraParams = {
			};
			programComboStore.getProxy().extraParams = {
				academyLocationId : aLId
			};
			programComboStore.load();
			programGroupComboStore.load();
			academicTermComboStore.load({
				 callback: function(rec, success) {
					 if (success) {
						 for(var i in rec){
							 if(rec[i].get('sequence')==1){
								 academicTermCombo.setValue(rec[i].get('id'));
							 }
						 }
						
					 }
				 }
			 });
			$this.getPromotionsearch().down('#batchId').setDisabled(true);
			$this.getPromotionsearch().down('#periodId').setDisabled(true);
			$this.getPromotionsearch().down('#sectionId').setDisabled(true);
			Ext.defer(function(){
				$this.setParamsStudentCombo();
			},500)
			programCoordinate.reset();
			var programCoordinateStore = programCoordinate.getStore();
			programCoordinateStore.getProxy().extraParams = {
				academyLocationId : aLId,
			},
		    programCoordinateStore.load();
			
		},
		setDefaultAcademyLocation : function(){
			var this$ = this;
			var academyLocationIds;
			var accessibleLocations = new Array();
			var form = this$.getPromotionsearch();
			var aLId = this$.getCurrentAcademyLocation();
			var store = form.down('#academyLocationId').getStore();
			store.load({
				callback: function(records, operation, success) {
					for(var i=0; i<records.length; i++){
						if(records[i].get('id')==aLId){
							form.down('#academyLocationId').setValue(records[i].get('id'));
						}
						accessibleLocations.push(records[i].get('id'));
					}
				}
			});
			/*	var programGroupField = this$.getAttendancereportsearch().down("#ProgramGroupItemId");
			var programGroupStore = programGroupField.getStore();
			programGroupStore.getProxy().extraParams = {
				academyLocationId : aLId
			}
			programGroupStore.load();*/
		
		},
		onPromotionListCellClick: function(view, CellEl, ColIdx, record, RowEl, rowIndex, e,eopts){
			var this$ = this;
			var academyLocationId = this$.getCurrentAcademyLocation();
			var grid = view.up('grid');
			var columnName = grid.columnManager.columns[ColIdx].dataIndex;
			var portalInfo = Academia.model.authentication.StudentERPInfoModel;
			if(columnName=='studentId'){
				if (e.target.tagName == 'A') {
					var userId = record.raw.stdId; 
					var admissionId = record.data.fromAdmissionId; 

					if (!isNullOrEmpty(userId)) {
						Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');

						var url = SERVERURL.PATH_FIND_STUDENT_DETAILS_BY_STUDENT_ID_AND_ADMISSION_ID ;
						var params = {
								id : userId , 
								admissionId : admissionId
						};
						this$.sendGetAjaxRequest(url, 'GET', params, function(option, success, response) {
							if(success){
								var data = Ext.decode(response.responseText);
								if(!isEmpty(data)){
									var tabTitle = record.get(columnName);
									var personId = data.person.id;//record.data.personId;
									var programBatchSeatTypeConfigId = null;//record.data.progBatchSeatConfigId;

									Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
									var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
									var studentListController =  Academia.app.getController('Academia.controller.personinfo.student.StudentListController');
									
									Ext.Ajax.request({
		        	        			type: 'rest',
		        	        			url: SERVERURL.PATH_FIND_STUDENT_JOURNEY_DASHBOARD_SETTING_BY_AL_ID,
		        	        			method : 'GET',
		        	        			params:{
		        	        				academyLocationId:academyLocationId ,
		        	        			},
		        	        			success: function(f, action) {
		        	        				var data = f.responseText;
		        	        				if(data == "true"){	
		        	        					personController.addContentPanelTabWithSubTab("studentjourneystructureforcoreerp", tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
					        				
		        	        				}else{
		        	        					personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
		        	        				}
		        	        			},
		        	        			failure: function(result, request) {
		        	        				showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); //Error occured while performing transaction
		        	        				return false;
		        	        			}
		        	        		});
									//personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
									var studentProfile = studentListController.getTabReferenceByTabTitle(tabTitle);
									var studentPersonDetailsLinkPanel = studentProfile.down('#studentPersonDetailsLinkPanel');
									if(!isNullOrEmpty(studentPersonDetailsLinkPanel)){
										var studentLinkPanelObject = studentPersonDetailsLinkPanel.getStudentProfileLink();
										studentListController.loadPanellinkForStudent(studentProfile, studentLinkPanelObject);        	
									}
								}
							}
						});
						Ext.Ajax.request({
							type: 'rest',
							url: SERVERURL.BATCH_ID_BY_STUDENT_ID+'?studentId='+userId,
							method: 'GET',
							async: false,
							success: function(res, action) {
								var data = Ext.decode(res.responseText);
								if(!isEmpty(data)){
									portalInfo.set('admissionDetails',data[0].admissionDetails);
									portalInfo.set('student',data[0].student);
									portalInfo.set('userAacademyLocations',data[0].userAacademyLocations);
									portalInfo.set('programBatchDetails',data[0].programBatchDetails);
									portalInfo.set('pastProgramBatchDetails',data[0].pastProgramBatchDetails);
								}
							}
						});
					}

				}
			}
		},
		setParamsStudentCombo:function(){
			var me = this,
			form = me.getPromotionsearch(),
			ALField = form.down("#academyLocationId"),
			programCombo = form.down('#programId'),
			batchComboBox = form.down('#batchId'),
			periodComboBox = form.down('#periodId'),
			sectionCombo = form.down('#sectionId'),
			studentId = form.down('#studentId');
			studentId.reset();
			studentId.getStore().getProxy().extraParams = {
				academyLocationIds:ALField.getValue(),
				program:programCombo.getValue(),
				batch:batchComboBox.getValue(),
				period:periodComboBox.getValue(),
				section:sectionCombo.getValue()
			}
			studentId.getStore().load();
		},
		
		disableBulkPassoutStatusTab:function(structure,permissionsMap){
		   	 var associatedAcadLocationIds = new Array();
		   	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		   	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		   	 var ImportBulkPassoutStatusUpdateTab=false;
		   	 
		   	 for (var i = 0; i < permissionList.length; i++) {
		   		 if (permissionList[i] === "IMPORT_PASSOUT_STATUS_UPDATE") {
		   			ImportBulkPassoutStatusUpdateTab=true;
		   		 }
		   	 }
		   	 this.showmBulkPassoutStatusUpdateImportTab(ImportBulkPassoutStatusUpdateTab, structure);
		    
	   },
	   getImportListDownloadFile : function(documentId,fileType){

	    	if(!isNullOrEmpty(documentId)){
	    		var csvForm = Ext.create('Ext.form.Panel'); 
	    		csvForm.getForm().submit({
	    			target: '_blank',
	    			method:'POST',
	    			params :{
	    				access_token : Ext.Ajax.defaultHeaders.access_token
	    			},
	    			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	    			url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
	    			standardSubmit :true
	    		});
	    	}
	    },
	   showmBulkPassoutStatusUpdateImportTab: function(ImportBulkPassoutStatusUpdateTab,structure){

		   	 var panelItem = new Array();
		   	 var $this = this;
		   	 var newcont=structure.items.items.length;
		   	 var insertPosition=newcont+1;
		   	 if(ImportBulkPassoutStatusUpdateTab==true) {
		   		 panelItem.push({
		   			xtype:'tabpanel',
		   			plain: true,
		   			style:{overflow:'hidden !important',margin:'0!important'},
		   			bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
		   			frame: false,
		   			cls: 'promotionListCls',
		   			border:false,
		   			items:[{
		   				title :getCommonTranslation('SEARCH'),     
		   				items : [{
		   					xtype : 'promotionsearch'  
		   				},{
		   					xtype : 'promotionlist'
		   				}]
		   			},{
		   				xtype:'panel',
		   				title :getCommonTranslation('IMPORT_PASSOUT_STATUS_UPDATE'), 
		   				cls:'panelNoSpace',
		   				items:[{
		   					xtype: 'importpassoutstatusupdate',
		   					itemId: 'importpassoutstatusupdate'
		   				}]
		   			}]
		   		});
		   	 }else{
		   		 panelItem.push({
		   			xtype:'tabpanel',
		   			plain: true,
		   			style:{overflow:'hidden !important',margin:'0!important'},
		   			bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
		   			frame: false,
		   			cls: 'promotionListCls',
		   			border:false,
		   			items:[{
		   				title :getCommonTranslation('SEARCH'),     
		   				items : [{
		   					xtype : 'promotionsearch'  
		   				},{
		   					xtype : 'promotionlist'
		   				}]
		   			}]
		   		});
		   	 }
		   	 structure.insert(insertPosition,panelItem);
		  },
		  
});
