/**
 *  @author Rajkumar.patidar
 * 
 */
Ext.define('Academia.controller.coursetransaction.studymaterialdistribution.StudyMaterialDistributionController', {
	extend: 'Academia.controller.base.BaseController',
	models : ['coursetransaction.studymaterialdistribution.DistributionforCourseReadingModel',
	          'common.IdValueCodeDataModel',
	          'coursetransaction.studymaterialdistribution.CourseReadingSubmitModel',
	          'coursetransaction.studymaterialdistribution.StudentModel',
	          'course.CreateCourseModel','coursetransaction.studymaterialdistribution.DistributionforCourseReadingGridModel'
	          ],
  stores : ['coursetransaction.studymaterialdistribution.DistributionforCourseReadingStore',
            'coursetransaction.studymaterialdistribution.DistributionModeStore',
            'coursetransaction.sectionmanagement.CoruseSectionStore','coursetransaction.studymaterialdistribution.CourseVariantDropDown',
            'coursetransaction.studymaterialdistribution.CourseVarinatTempStore','coursetransaction.studymaterialdistribution.ReadingNameDropDown',
            'coursetransaction.studymaterialdistribution.CourseReadingGrid','coursetransaction.studymaterialdistribution.ReadingTypeDropDown',
            'coursetransaction.studymaterialdistribution.StudentGridStore',
            'coursetransaction.studymaterialdistribution.CoursesAllStore',
            'coursetransaction.studymaterialdistribution.AssignmentNameStore',
            'coursetransaction.studymaterialdistribution.AddStudentStore',
            //'coursetransaction.sectionmanagement.CoruseSectionStore',
            'coursetransaction.coursereading.TopicType','coursetransaction.coursereading.MaterialType',
            'coursetransaction.studymaterialdistribution.DistributionModeStore',
            'coursetransaction.studymaterialdistribution.CourseReading',
            'coursetransaction.studymaterialdistribution.ListName',
            'coursetransaction.studymaterialdistribution.SendingStatus',
            'coursetransaction.studymaterialdistribution.ReceivingStatus',
            'coursetransaction.studymaterialdistribution.DistributionListType',
            'common.ProgramStore','program.programDetails.programBatches.InheritFromBatchStore',
            'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
            'coursetransaction.studymaterialdistribution.StudentAdmission',
            'coursetransaction.studymaterialdistribution.StudentName',
            'coursetransaction.studymaterialdistribution.CourseVarinatEditStore'
            ],
    views  : [ 'baselayout.contentarea.ContentPanel',
              'coursetransaction.studymaterialdistribution.DistributionListforCourseReading',
              'coursetransaction.studymaterialdistribution.DistributionWinforCourseReading',
              'coursetransaction.studymaterialdistribution.StudyMaterialDistributionStructure',
              'coursetransaction.studymaterialdistribution.CourseReadingGrid',
              'coursetransaction.studymaterialdistribution.CourseReadingAndStudentStructure',
              'coursetransaction.studymaterialdistribution.CourseReading',
              'coursetransaction.studymaterialdistribution.StudentGrid',
              'coursetransaction.studymaterialdistribution.AddStudentWin',
              'coursetransaction.studymaterialdistribution.ApprovalFormWin',
              'coursetransaction.studymaterialdistribution.StudentStatusWin',
              'coursetransaction.studymaterialdistribution.StudyMaterialSearch',
              'coursetransaction.studymaterialdistribution.StudyMaterialListStructure',
              'coursetransaction.studymaterialdistribution.StudymaterialDistributionAdvListing',
              'coursetransaction.studymaterialdistribution.StudyMaterialSearchForCourse',
              'coursetransaction.studymaterialdistribution.StudyMaterialSearchForStudent',
              'coursetransaction.studymaterialdistribution.StudyMaterialListForStudentStructure',
              'coursetransaction.studymaterialdistribution.StudyMaterialListForCourseStructure'
              ],	   

          config: {
         	              
         	               	 /* CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
         	                		   	 
         	                	   	*//**
         	                	        * @cfg {Array} HOMEWORK_ASSIGNMENT_PERMISSIONS array (required)
         	                	        * The array of permissions to use for Access control wise enabling and disabling buttons.
         	                	        * @accessor
         	                	        */
        	            
             	 		STUDY_MATERIAL_DISTRIBUTION_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDY_MATERIAL_DISTRIBUTION_PRIVILEGES'),
             	 		STUDY_MATERIAL_COURSE_READING_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDY_MATERIAL_COURSE_READING_PRIVILEGES') 
          },
         	                  

      refs : [{
    	  ref : 'distributionlistforcoursereading',
    	  selector : 'distributionlistforcoursereading'
      },{
    	  ref : 'distributionwinforcoursereading',
    	  selector : 'distributionwinforcoursereading'
      },{
    	  ref : 'distributionWinforcourseReading',
    	  selector : 'distributionwinforcoursereading form'
      },{
    	  ref : 'contentPanel',
    	  selector : 'contentPanel'
      },{
    	  ref : 'coursereading',
    	  selector : 'coursereading'
      },{
    	  ref : 'courseReading',
    	  selector : 'coursereading form'
      },{
    	  ref : 'coursereadinggrid',
    	  selector : 'coursereadinggrid'
      },{
    	  ref:'studentgrid',
    	  selector:'studentgrid'
      },{
    	  ref : 'coursereadingandstudentstructure',
    	  selector : 'coursereadingandstudentstructure'
      },{
    	  ref : 'studymaterialdistributionstructure',
    	  selector : 'studymaterialdistributionstructure'	
      },{
    	  ref : 'addstudentwin',
    	  selector : 'addstudentwin'
      },{
    	  ref : 'addstudentWin',
    	  selector: 'addstudentwin form'			
      },{
    	  ref : 'approvalformWin',
    	  selector:'approvalformwin form'
      },{
    	  ref : 'approvalformwin',
    	  selector:'approvalformwin'
      },{
    	  ref:'studentstatuswin',
    	  selector:'studentstatuswin'
      },{
    	  ref:'studentstatusWin',
    	  selector:'studentstatuswin form'
      
      },{
    	  ref:'studymaterialsearch',
    	  selector:'studymaterialsearch'
      },{
    	  ref:'studymaterialsearchforcourse',
    	  selector:'studymaterialsearchforcourse'
      },{
    	  ref:'studymaterialsearchforstudent',
    	  selector:'studymaterialsearchforstudent'	  
      },{
    	  ref:'searchresultgrid',
    	  selector:'searchresultgrid[itemId=studyMaterialDisGridForCourse]'	
      },{
    	  ref:'searchresultgridforstudent',
    	  selector:'searchresultgrid[itemId=studyMaterialDisGridForStudent]'	
      }],
          init : function() {
        	  this.control({
        		  'studymaterialsearch radiogroup[itemId=studyMaterialRadioId]':{
         			  change:function(value,newValue,oldValue){
        				  var form = this.getStudymaterialsearch();
        				  
        				  if(!newValue.sectionType){
        					  form.down("#studymateriallistforstudentstructure").setVisible(true);
        					  form.down("#studymateriallistforcoursestructure").setVisible(false);
        					  form.down("#studymateriallistforcoursestructure").getForm().reset();
        				  }else{
        					  form.down("#studymateriallistforstudentstructure").setVisible(false);
        					  form.down("#studymateriallistforcoursestructure").setVisible(true);
        					  form.down("#studymateriallistforstudentstructure").getForm().reset();
        				  }
        			  }
        		  },
        		  'studymaterialsearchforcourse':{
        			  render:function(){
        				  var academyLocationId = this.getCurrentAcademyLocation();
        	        		  var store = this.getStore('attendance.StudentCourses');
        	        		  store.getProxy().extraParams = {
        	        			  academyLocationId:academyLocationId				
        	        		  };
        	        		  store.load();
        			  }
        		  },
        		  'studymaterialsearchforcourse customcombobox#courseId':{
        			  select:function(obj,record){
        				  var id = record[0].get("courseId");
        				  var listNameField = this.getStudymaterialsearchforcourse().down("#listNameId");
        				  var topicNameField = this.getStudymaterialsearchforcourse().down("#topicNameId");
        				  var componentField = this.getStudymaterialsearchforcourse().down("#componentId");
        				  listNameField.setDisabled(false);
        				  topicNameField.setDisabled(false);
        					 
        				  
         				 if(record[0].data.sectionAtComponentLevel){
         					 componentField.setVisible(true);
         					 //listNameField.setDisabled(true);
          				     topicNameField.setDisabled(true);
             				 if(id > 0){//section on the bases of component
             					 componentField.getStore().getProxy().extraParams = {
             						 id : id
             					 };
             					 componentField.getStore().load();
             				 }
         				 }else{
         					componentField.setVisible(false);
         					 componentField.reset();
         				 }
        				  
        				  var listNameStore = listNameField.getStore();
        				  listNameStore.getProxy().extraParams = {
        					  courseId:id
        				  };
        				  listNameStore.load();
        				  
        				  var topicStore = this.getStore('coursetransaction.coursereading.MaterialType');
        				  topicStore.getProxy().extraParams = {
        					  courseId : id
        				  };
        				  topicStore.load();
        				  
        			  }
        		  }, 
        		  'studymaterialsearchforcourse customcombobox#componentId':{
        			  select:function(obj,record){
        				  var id = record[0].get("id");
        				  var form = this.getStudymaterialsearchforcourse();
        				 // var listNameField = form.down("#listNameId");
        				  var topicNameField = form.down("#topicNameId");
        				  var values = form.getForm().getValues();
        				  var courseId = values.COURSE_ID;
        				  //var componentField = this.getStudymaterialsearchforcourse().down("#componentId");
        				  //listNameField.setDisabled(false);
        				  topicNameField.setDisabled(false);
        				  /*var listNameStore = listNameField.getStore();
        				  listNameStore.getProxy().extraParams = {
        					  courseId:courseId,
        					  componentId:id
        				  };
        				  listNameStore.load();*/
        				  
        				  var topicStore = this.getStore('coursetransaction.coursereading.MaterialType');
        				  topicStore.getProxy().extraParams = {
        					  courseId : courseId,
        					  componentId:id
        				  };
        				  topicStore.load();
        				  
        			  }
        		  },
        		  'studymaterialsearchforcourse customcombobox#readingtypeId':{
        			  select:function(obj,record){
        				  var id = record[0].get("id");
        				  var courseField = Ext.ComponentQuery.query('customcombobox#courseId')[0];
        				  var courseId = courseField.getValue();
        				  var readingNameField = Ext.ComponentQuery.query('customcombobox#readingNameId')[0];
        				  var readingStore = readingNameField.getStore();
        				  readingStore.getProxy().extraParams = {
        					  courseId:courseId,
        					  courseReadingTypeId:id
        				  };
        				  readingStore.load();
        			  }
        		  },
        		  'studymaterialsearchforstudent customcombobox#programId':{
        			  select:function(obj,record){
        				  var programId = record[0].get("id");
        				  var batchField = Ext.ComponentQuery.query('customcombobox#batchId')[0];
        				  var batchStore = batchField.getStore();
        				  batchStore.getProxy().extraParams = {
        					  id:programId
        				  };
        				  batchStore.load();
        			  }
        		  },
        		  'studymaterialsearchforstudent customcombobox#batchId':{
        			  select:function(obj,record){
        				  var batchId = record[0].get("id");
        				  var periodField = Ext.ComponentQuery.query('customcombobox#periodId')[0];
        				  var periodStore = periodField.getStore();
        				  periodStore.getProxy().extraParams = {
        					  id:batchId
        				  };
        				  periodStore.load();
        			  }
        		  },
        		  'studymaterialsearchforstudent customcombobox#periodId':{
        			  select:function(obj,record){
        				  var periodId = record[0].get("id");
        				  var studentField = Ext.ComponentQuery.query('customcombobox#periodId')[0];
        				  var studentStore = studentField.getStore();
        				  studentStore.getProxy().extraParams = {
        					  periodId:periodId
        				  };
        				  studentStore.load();
        			  }
        		  },
        		  'studymaterialsearchforcourse button[itemId=searchBtn]':{
        			  click:function(){
        				  var RESULT_GRID = this.getSearchresultgrid();
        				  //this.gridRenderFunction(RESULT_GRID);
        				  var SEARCH_FORM = this.getStudymaterialsearchforcourse().getForm();
        				  this.loadDynamicGridForSMD(CONSTANTS.CB.STUDY_MATERIAL_LIST_COURSEWISE_VIEWCODE,
                  			CONSTANTS.CB.STUDY_MATERIAL_LIST_COURSEWISE_CONFIGCODE,SEARCH_FORM,RESULT_GRID);
        			  }		
        		  },
        		  'studymaterialsearchforstudent button[itemId=searchBtn]':{
        			  click:function(){
        				  var RESULT_GRID = this.getSearchresultgridforstudent();
        				  //this.gridRenderFunctionForStudent(RESULT_GRID);
        				  var SEARCH_FORM = this.getStudymaterialsearchforstudent().getForm();
        				  this.loadDynamicGridForSMD(CONSTANTS.CB.STUDY_MATERIAL_LIST_STUDENTWISE_VIEWCODE,
                  			CONSTANTS.CB.STUDY_MATERIAL_LIST_STUDENTWISE_CONFIGCODE,SEARCH_FORM,RESULT_GRID);
        			  }		
        		  },
        		  'studymaterialsearchforcourse button[itemId=resetBtn]':{
        			  click:function(){
        				  var form = this.getStudymaterialsearchforcourse();
        				  form.getForm().reset();
        				  form.down("#topicNameId").setDisabled(true);
        				  form.down("#listNameId").setDisabled(true);
        				  form.down("#componentId").setVisible(false);
        			  }
        		  },
        		  'studymaterialsearchforstudent button[itemId=resetBtn]':{
        			  click:function(){
        				  this.getStudymaterialsearchforstudent().getForm().reset();
        			  }
        		  },
        		  'distributionlistforcoursereading' :{
        			  render : this.onGridRender
        		  },
        		  'distributionlistforcoursereading button[itemId=btnAdd]' :{
        			  click:this.showDLCRWindow 
        		  },
        		  'distributionlistforcoursereading button[itemId=btnEdit]':{
        			  click:this.editDLCRWindow 
        		  },
        		  'distributionlistforcoursereading button[itemId=btnDelete]':{
        			  click:this.deleteDLCRWindow
        		  },
        		  'distributionlistforcoursereading button[itemId=btnView]':{
        			  click:this.viewDLCRWindow
        		  },
        		  'distributionwinforcoursereading button[itemId=CancelBtn]':{
        			  click:this.closeCourseReadingWin
        		  },
        		  'distributionwinforcoursereading customcombobox#courses':{
        			  change : function(obj,record){
        				  var $this = this;
        				  
        				  var form = this.getDistributionwinforcoursereading().getForm();
        				  this.getDistributionwinforcoursereading().down('#courseVariants').setDisabled(false);
    					  var id = form.findField('id').getValue();
        				  var checkbox = Ext.ComponentQuery.query('checkboxfield#associateWithAssignment')[0];
        				  
        				  if(isNullOrEmpty(id)){
        					  if(!checkbox.checked){
//        						  if(isNullOrEmpty(id)){        						
        						  var course=[0];
        						  var cvStore = $this.getStore('coursetransaction.studymaterialdistribution.CourseVarinatTempStore');
        						  cvStore.getProxy().extraParams = {
        							  course:course
        						  };
        						  cvStore.load({
        							  /*params:{
                        					  course:course
                        					  },*/
        							  callback: function(rec, operation, success) {
        								  if (success) {
        									  if(rec.length==0){
        										  obj.nextSibling().nextSibling().reset();
        										  $this.getCourseVariant(obj,record);
        									  }
        								  }
        							  }
        						  });

        						  }else{
        							  $this.getCourseVariant(obj,record);  
        						  }
        					  }

        				  }
        		  },
        		  'distributionwinforcoursereading checkboxfield#associateWithAssignment':{
        			  change : function(obj,newValue,oldValue){
        				  var form = this.getDistributionwinforcoursereading();
        				  if(newValue){
        					  form.down("#assignmentName").setVisible(true);
        					  form.down("#courseVariants").setVisible(false);
        					  form.down("#courseVariants").allowBlank=true;
        				  }else{
        					  form.down("#assignmentName").setVisible(false);
        					  form.down("#courseVariants").setVisible(true);
        					  form.down("#courseVariants").allowBlank=false;
        				  }
        			  }
        		  },
        		  'distributionwinforcoursereading button[itemId=SubmitBtn]':{
        			  click:this.saveDLCRWin
        		  },
        		  'distributionlistforcoursereading menuitem[itemId=assignReadingLinked]':{
        			  click:this.getCourseReadingGrd
        		  },  
        		  'distributionlistforcoursereading menuitem[itemId=copyLinked]':{
        			  click:function(){
        				  var $this = this;
        	        	  var grid = $this.getDistributionlistforcoursereading();
        	        	  if (grid.getSelectionModel().getCount() > 0) {
        	        		  $this.copyDistributionLink(grid);
        	        	 }else{
        	        		 showWarningMessage(getCourseTxCommonTranslation('STUDY_MATERIAL_DISTRIBUTION'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        	        	 }
        		   }
        		  },
        		  'coursereadinggrid button[itemId=btnAdd]':{
        			  click:function(){
        				  this.showCourseReading();
        				  this.courseVariantDropDown();
        			  } 
        		  },
        		  'coursereadinggrid':{
        			  render:this.courseReadingGridRender
        		  },
        		  'coursereading button[itemId=SubmitBtn]':{
        			  click:this.saveCourseReading
        		  },
        		  'coursereading button[itemId=CancelBtn]':{
        			  click:this.closeCourseReading
        		  },
        		  'coursereadinggrid button[itemId=btnEdit]':{
        			  click:this.getEditCourseReading
        		  },
        		  'coursereadinggrid button[itemId=btnView]':{
        			  click:this.getViewCourseReading
        		  },
        		  'coursereadinggrid button[itemId=btnDelete]':{
        			  click:this.deleteCourseReading
        		  },
        		  'coursereading customcombobox#courseVariant_Id':{
        			  select : function(obj,record){
        				  var courseVariantId = record[0].get("id");

        				  var $this = this;
        				  var grid = $this.getDistributionlistforcoursereading();
        				  var records = grid.getSelectionModel().getSelection()[0];
        				  var distributionMode = records.get("distributionMode");
        				  var distributionModeId = distributionMode.id;
        				  
        				  var readingTypeComboBox = this.getCoursereading().down('customcombobox#readingType_Id');
        				  readingTypeComboBox.clearValue();

        				  var readingTypeStore = readingTypeComboBox.getStore();
        				  readingTypeStore.getProxy().extraParams = {
        					  courseVariantId:courseVariantId
        				  };
        				  readingTypeStore.load();
        				  
        				  var readingNameComboBox = $this.getCoursereading().down('customcombobox#readingName_Id');
        				  readingNameComboBox.clearValue();

        				  var readingNameStore = readingNameComboBox.getStore();
        				  readingNameStore.getProxy().extraParams = {
        					  courseVariantId:courseVariantId,
        					  distributionModeId:distributionModeId
        				  };
        				  readingNameStore.load();

        			  }
        		  },
        	/*	  'coursereading customcombobox#readingType_Id':{
        			  select : function(obj,record){
        				  var $this = this;
        				  var grid = $this.getDistributionlistforcoursereading();
        				  var records = grid.getSelectionModel().getSelection()[0];
        				  
        				  var courseReadTypeId = record[0].get("id");
        				  var distributionMode = records.get("distributionMode");
        				  var distributionModeId = distributionMode.id;
        				  
        				  var readingNameComboBox = $this.getCoursereading().down('customcombobox#readingName_Id');
        				  readingNameComboBox.clearValue();

        				  var readingNameStore = readingNameComboBox.getStore();
        				  readingNameStore.getProxy().extraParams = {
        					  courseReadTypeId:courseReadTypeId,
        					  distributionModeId:distributionModeId
        				  };
        				  readingNameStore.load();
        			  }
        		  },*/
        		  'studentgrid':{
        			  render:function(){
        				  this.studentGridRender();
        			  },
        			  cellclick: function (view, cell, cellIndex, record, row, rowIndex, e) {
        				  if(e.target.tagName=='A'){
        					  this.getsenderStatusWin();	
        				  }
        			  },
        			  /*itemclick:function(dv, record, item){
        			  }*/
        		  },
        		  'coursereadingandstudentstructure':{
        			  tabchange : function(tabPanel, newCard, oldCard){
        				  this.courseAndstudentTabChange(tabPanel, newCard, oldCard);
        			  }
        		  },
        		  'studentstatuswin button[itemId=SubmitBtn]':{
        			  click:this.setsenderStatusWin
        		  }, 
        		  'studentstatuswin button[itemId=CancelBtn]':{
        			  click:this.closeSenderStatusWin
        		  },
        		  'studentgrid button[itemId=btnAdd]' :{
        			  click:this.showAddStudentWindow 
        		  },
        		  'addstudentwin button[itemId=CancelBtn]' :{
        			  click:this.closeAddStudentWindow 
        		  },
        		  'studentgrid button[itemId=btnDelete]' :{
        			  click:this.deleteAddStudentWindow 
        		  },
        		  'studentgrid menuitem[itemId=approveLinked]':{
        			  click:this.getApprovedLink
        		  },
        		  'studentgrid menuitem[itemId=markAsSentLinked]':{
        			  click:this.getMarkAsSent
        		  },
        		  'approvalformwin button[itemId=SubmitBtn]':{
        		      click:this.setApprovedLink
        		  },
        		  'approvalformwin button[itemId=CancelBtn]':{
        		      click:this.closeApprovedLink
        		  },
        		  'addstudentwin button[itemId=SubmitBtn]':{
        			  click:this.saveStudent
        		  },
        		  'studentstatuswin datefield#sentDate':{
        			  change : function(obj,newValue,oldValue){
        				  var form = obj.up('form');
        				  var recievDate = Ext.ComponentQuery.query('datefield#receivedDate')[0];
        				  var returnDate = Ext.ComponentQuery.query('datefield#returnDate')[0];
        				  var checkbox = Ext.ComponentQuery.query('checkboxfield#whetherReturn')[0];
        				  form.down('#returnDate').setMinValue(newValue);
        				  if(newValue){
        					  recievDate.setVisible(true); 
        					  returnDate.setVisible(false);
        					  checkbox.setVisible(true); 
        					  checkbox.reset();
        				  }else{
        					  recievDate.setVisible(false); 
        					  checkbox.setVisible(false);
        					  recievDate.setValue(null);
        				  }
        			  }
        		  },
        		  'studentstatuswin datefield#receivedDate':{
        			  change : function(obj,newValue,oldValue){
        				  var returnDate = Ext.ComponentQuery.query('datefield#returnDate')[0];
        				  if(newValue){
        					  returnDate.setValue(null);  
        				  }
        			  }
        		  },
        		  'studentstatuswin checkboxfield#whetherReturn':{
        			  change : function(obj,newValue,oldValue){
        				  var form = this.getStudentstatuswin();
        				  if(newValue){
        					  form.down("#returnDate").setVisible(true);
        					  form.down("#receivedDate").setVisible(false);
        					  form.down("#receivedDate").reset();
        				  }else{
        					  form.down("#returnDate").reset();
        					  form.down("#returnDate").setVisible(false);
        					  form.down("#receivedDate").setVisible(true);
        				  }
        			  }
        		  },
        		  'addstudentwin textfield[itemId=admissionID]':{
        			  change:function(f){
        				  this.studentSearch(f);
        				  this.getStudentSearch();
        				  }
        		  },
        		  'addstudentwin textfield[itemId=studentName]':{
        			  change:function(f){
        				  this.studentSearch(f);
        				  this.getStudentSearch();
        			  }
        		  },
        		  'addstudentwin button[itemId=searchBtn]':{
        			  click:this.getStudentSearch
        		  },
        		  /*'studentstatuswin textfield[itemId=sentDate]':{
        			  change:function(value,newValue,oldValue){
        				  var grid = this.getDistributionlistforcoursereading();
        	        	  var selectedRecord = grid.getSelectionModel().getSelection()[0];
        	        	  var createdDate = selectedRecord.data.createdDate;
     					  var sentDate = Ext.Date.format(newValue,'d-m-y');
     					 
     					 var form = this.getStudentstatuswin();
     					 form.down("#sentDate").setMaxValue(createdDate);
     					
        			  }
        		  },*/
        		  'searchresultgrid[itemId=studyMaterialDisGridForCourse]':{
        			  render:function(grid){
        				  this.gridRenderFunction(grid);
        			  }
        		  },
        		  'searchresultgrid[itemId=studyMaterialDisGridForCourse]':{
        			  render:function(grid){
        				  this.gridRenderFunction(grid);
        			  }
        		  },
        		  'searchresultgrid[itemId=studyMaterialDisGridForCourse] button[itemId=btnAdd]':{
        			  click:this.getopenStudyMaterialDistributionStructure
        		  },
                  'searchresultgrid[itemId=studyMaterialDisGridForStudent] button[itemId=btnAdd]':{
                	  click:this.getopenStudyMaterialDistributionStructure 
        		  }
        	  });
          },
          getopenStudyMaterialDistributionStructure : function(){
        	  
        	  var CONTENTPANEL = this.getContentPanel();
        	  var STRUCTURE = Ext.widget('studymaterialdistributionstructure');
        	  var TABNAME = getCourseTxCommonTranslation('STUDY_MATERIAL_DISTRIBUTION_DETAILS');
        	   
        	  openTab(CONTENTPANEL,TABNAME,STRUCTURE,CONSTANTS.MENU_COLOR_THREE);
        	  
          },
          getStudentSearch : function(){
        	  
        	  var $this  = this;
        	  var grid = $this.getDistributionlistforcoursereading();
    		  var records = grid.getSelectionModel().getSelection()[0];
        	  var form = $this.getAddstudentWin().getForm();

        	  var distributionListId = records.get("id");
        	  var admissionNo = form.findField("admissionID").getValue();
        	  var studentName = form.findField("studentName").getValue();
        	  
        	  var store = $this.getStore('coursetransaction.studymaterialdistribution.AddStudentStore');
        	  store.getProxy().extraParams = {
        		  distributionListId:distributionListId,
        		  admissionId:admissionNo,
        		  studentName:studentName
      		  };
        	  store.load();
        	  
          },
          studentSearch : function(f){
        	  if(f.name=='admissionID'){
        		  if(f.getValue()){
        		     f.nextSibling().setDisabled(true);
        		  }else{
        			 f.nextSibling().setDisabled(false);
        		  }
        	  }else{
        		  if(f.getValue()){
        		   f.previousSibling().setDisabled(true);
        		  }else{
        			f.previousSibling().setDisabled(false);  
        		  }
        	  };
          },
          closeCourseReadingWin : function(){
        	  var form = this.getDistributionwinforcoursereading().getForm();
        	  form.reset();
          },
          getCourseVariant : function(obj,records){
        	  
        	  var $this = this;
        	  var form = this.getDistributionwinforcoursereading().getForm();
        	  var value = form.getValues();
        	  
        	  if(records.length>0){
        		  myArray = records.join();
        	  }else{
        		  myArray=0;
        	  }
        	  var course = myArray;
        	  if(value.associateWithAssignment==getCourseTxCommonTranslation('COURSE_READ')){
        	  var cvStore = $this.getStore('coursetransaction.studymaterialdistribution.CourseVarinatTempStore');
        	  cvStore.getProxy().extraParams = {
				  course:course
        	   };
        	  cvStore.load({
        		  /*params:{course:course},*/
  			  callback: function(record, operation, success) {
  					if (success) {
  						if(record.length==0){
  							obj.nextSibling().nextSibling().reset();
  					  }
  					}
  				}
  			  });
        	  }else{
        	  var aNStore = $this.getStore('coursetransaction.studymaterialdistribution.AssignmentNameStore');
        	  aNStore.getProxy().extraParams = {
        		  course:course
        	  };
        	  aNStore.load();
        	  }

          },
          showDLCRWindow : function(){
        	  var $this = this;
        	  var CONTENTPANEL = $this.getContentPanel();
        	  var CRSSTRUCTURE = Ext.widget('distributionwinforcoursereading');
        	  var TABNAME = getCourseTxCommonTranslation('COURSE_READING_DISTRIBUTION');
        	  $this.closeCourseReadingWin(); 
        	  openTab(CONTENTPANEL,TABNAME,CRSSTRUCTURE,CONSTANTS.MENU_COLOR_THREE);
        	  var form = $this.getDistributionwinforcoursereading();
    		  var cancelButton=form.down("#CancelBtn");
    		  if(cancelButton.isHidden()){
    			  cancelButton.setVisible(true);
    		  }
          },
          editDLCRWindow : function(){

        	  var $this = this; 

        	  var grid = $this.getDistributionlistforcoursereading();
        	  var grdStore = grid.getStore();  

        	  if(grid.getSelectionModel().getCount()>0){
        		  $this.showDLCRWindow();
        		  var form = $this.getDistributionwinforcoursereading();
        		  form.down("#associateWithAssignment").setVisible(false);
        		  var records = grid.getSelectionModel().getSelection();
        		  var id=records[0].get("id");
        		  
        		  form.down("#CancelBtn").setVisible(false);
        		  
        		  Ext.Ajax.request({
        			  method: "GET",
        			  type: 'rest',
        			  url: SERVERURL.DL_COURSEREADING_FIND_BY_ID,
        			  params:{
        				  id:id
        			  },
        			  headers: {
        				  'Content-Type': 'application/json'
        			  },
        			  success:function(response){

        				  var data = Ext.JSON.decode(response.responseText);
        				  var smdc = new Academia.model.coursetransaction.studymaterialdistribution.DistributionforCourseReadingModel(data);
        				  form.loadRecord(smdc);
        				  var courses = form.down('#courses');
        				  courses.setReadOnly(true);
        				  var courseVariants = form.down('#courseVariants');
        				  var courseVariantsEdit = form.down('#courseVariantsEdit');
        				  courseVariants.setReadOnly(true);
        				  courses.setVisible(true);
        				  courseVariants.allowBlank=true;
        				  courseVariants.setVisible(false);
        				  courseVariantsEdit.setVisible(true);
        				  
        				  var approveRadio=form.down("#autoApprove").items.items;
        				  if(data.whetherAutoApprove){
        					  approveRadio[0].setValue(true);
        					  approveRadio[1].setValue(false);
        				  }else{
        					  approveRadio[0].setValue(false);
        					  approveRadio[1].setValue(true);
        				  }
        				 
        				  
        				  var distributionMode = form.down("#distributionMode");
        				  var distributionId;
        				  if(smdc.data.distributionMode != null){
        					  distributionId = smdc.data.distributionMode.id; 
        				  }

        				  distributionMode.store.load({
        					  callback: function(r, operation, success) {
        						  if (success) {
        							  distributionMode.setValue(distributionId);
        						  }
        					  }
        				  });
        				
        				  
        				  Ext.Ajax.request({
               			   type : 'rest',
               			   url : SERVERURL.COURSES_BY_DISTRIBUTION_ID,
               			   params : {
               				distributionId:smdc.data.id
               			   },
               			   method : 'GET',
               			   success : function(form, action) {
               				   var res = Ext.JSON.decode(form.responseText);
               				   
               				   courses.store.load({
               					   callback: function(r, operation, success) {
               						   if (success) {
               							   courses.setValue(res);
               							   
               						   }
               					   }
               				   });
               				   
               			 /*var variantArray =[];
               				 courseVariants.store.getProxy().extraParams = {
               					 course:res
               				 };
           				  courseVariants.store.load({
           						params:{
           							//distributionId: smdc.data.distributionMode.id,
           							course: res//smdc.data.distributionMode.id
           						},
           					  callback: function(record, operation, success) {
           						  if (success) {
           							  console.log('records in callback',record);
           							  for(var i in record){
           								  variantArray.push(record[i].data.id);
           							  }
           							  console.log('variantArray',variantArray);
           							  courseVariants.setValue(variantArray);
           						  }
           					  }
           				  });*/

               			   }
               			   });
        				  
        				   var variantArray=[];
             				courseVariantsEdit.store.getProxy().extraParams = {
             					distributionId:smdc.data.id
             				 };
             				courseVariantsEdit.store.load({
           					   callback: function(res, operation, success) {
           						   if (success) {
           							   if(res.length > 0){
           							  for(var i in res){
           								  variantArray.push(res[i].data.id);
           							  }
           							  courseVariantsEdit.setValue(res);
           							 }
           							   
           						   }
           					   }
           				   });
        				  
        			  }
        		  }); 

        	  }else{
        		  showWarningMessage(getCourseTxCommonTranslation('STUDY_MATERIAL_DISTRIBUTION'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record 
        	  }

          },	 
          deleteDLCRWindow : function(){

        	  var $this = this; 

        	  var grid = $this.getDistributionlistforcoursereading();
        	  var grdStore = grid.getStore();  

        	  if(grid.getSelectionModel().getCount()>0){
        		  showConfirmMessage(getCourseTxCommonTranslation('COURSE_READING_DISTRIBUTION'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
        			  if (btn == getCourseTxCommonTranslation('yes')) {
        				  var records=grid.getSelectionModel().getSelection();						        
        				  var id=records[0].get("id");
        				  Ext.Ajax.request({
        					  method: "DELETE",
        					  type: 'rest',
        					  url: SERVERURL.DL_COURSEREADING_DELETE+'?id='+id,
        					  headers: {
        						  'Content-Type': 'application/json'
        					  },
        					  success:function(response){
        						  grdStore.reload();
        						  showSuccessMessage(getCourseTxCommonTranslation('COURSE_READING_DISTRIBUTION'),getCommonTranslation('SUCCESS'));//Section deleted successfully
        					  }
        				  });
        			  }
        		  });
        	  }else{
        		  showWarningMessage(getCourseTxCommonTranslation('STUDY_MATERIAL_DISTRIBUTION'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record
        	  }
          },
          viewDLCRWindow : function(){

        	  var $this = this;
        	  $this.editDLCRWindow();
        	  var form = this.getDistributionwinforcoursereading();
        	  if (form) {
        		  form.down("#SubmitBtn").setVisible(false);
        		  form.down("#CancelBtn").setVisible(false);
        		  form.down("#distributionMode").setReadOnly(true);
        		  form.down("#listName").setReadOnly(true);
        		  form.down("#createdDate").setReadOnly(true);
        		  form.down("#remarks").setReadOnly(true);
        		  form.down("#autoApprove").setReadOnly(true);
        	  }
          },
          saveDLCRWin : function(){
        	  var $this = this;

        	  var grid = $this.getDistributionlistforcoursereading();
        	  var grdStore = grid.getStore();
        	  var form = $this.getDistributionwinforcoursereading();
        	  var frm = form.getForm();
        	  var checked = frm.findField("associateWithAssignment").checked;
        	  var value = frm.getValues();

        	  var smdc = new Academia.model.coursetransaction.studymaterialdistribution.DistributionforCourseReadingModel();
        	  smdc.set("listName",value.listName);
        	  smdc.set("createdDate",value.createdDate);
        	  smdc.set("createdBy",$this.getIdValueJson("1","System Admin"));
        	  smdc.set("distributionMode",$this.getIdValueJson(value.distributionMode));
        	  smdc.set("distributionListType",value.associateWithAssignment);
        	  smdc.set("remarks",value.remarks);
        	  smdc.set("whetherAutoApprove",value.autoApprove);
        	  smdc.set("customFieldDatas",value.customFieldDatas);
        	  
        	  

        	  var submitUrl;
        	  if (value.id == null ||value.id == "") {
        		  if(checked){
        			  smdc.set("courseHomeWorkAssignment",$this.getIdValueJson(value.assignmentName));  
        			  smdc.set("courseDistributionLists",null);
        		  }else{
        			  var variantIds = value.courseVariants;
        			  						 
        				 var courseVariant = [];
        	        	 if(variantIds !=undefined && variantIds.length > 0){
        	        		 for(var i in variantIds){
        	        			 if(Ext.isObject(variantIds[0])){
        	        				 courseVariant.push(variantIds[i].get("id"));
        	        			 }else{
        	        				 courseVariant.push(variantIds[i]);
        	        			 }
        	        		 }
        	        	 }
        	        
        			  
        			  
        			  var courseDistributionLists=[];
        			  for(var i in courseVariant){
        				  courseDistributionLists.push({
        					  "courseVariant":{
        						  "id":courseVariant[i]
        					  }
        				  });
        			  };
        			  smdc.set("courseDistributionLists",courseDistributionLists);
        			  smdc.set("courseHomeWorkAssignment",null);
        		  }
        		  submitUrl = SERVERURL.DL_COURSEREADING_CREATE;

        	  } else {
        		  smdc.set("id",value.id);
        		  smdc.set("courseDistributionLists",null);
        		  smdc.set("courseHomeWorkAssignment",null);
        		  submitUrl = SERVERURL.DL_COURSEREADING_UPDATE;
        	  }

        	  var submitData = Ext.encode(smdc.data);
        	  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        	  Ext.Ajax.request({
        		  method: "POST",
        		  type: 'rest',
        		  jsonData: submitData,
        		  url: submitUrl,
        		  headers: {
        			  'Content-Type': 'application/json'
        		  },
        		  success:function(response){
        			  Ext.getBody().unmask();
        			  showSuccessMessage(getCourseTxCommonTranslation('COURSE_READING_DISTRIBUTION'),getCommonTranslation('SUCCESS'));
        			  grdStore.reload();
        			  $this.closeCourseReadingWin();
        		  }
        	  }); 
          },
          getCourseReadingGrd : function(){
        	  var $this = this;

        	  var grid = $this.getDistributionlistforcoursereading();

        	  if (grid.getSelectionModel().getCount() > 0) {		
        		  var CONTENTPANEL = $this.getContentPanel();
	        	  var CRSSTRUCTURE = Ext.widget('coursereadingandstudentstructure');
	        	  var TABNAME = getCourseTxCommonTranslation('COURSE_READING_AND_STUDENT');
	        	  openTab(CONTENTPANEL,TABNAME,CRSSTRUCTURE,CONSTANTS.MENU_COLOR_THREE);
	        	  
	        	  var records=grid.getSelectionModel().getSelection()[0];	
	        	  
	        	  if(records.get("distributionListType")=='Homework Assignment'){
	        	    var courseReadingTab = CRSSTRUCTURE.items.items[0]; 
	        	    var studentTab =  CRSSTRUCTURE.items.items[1];
	        	  
    	        	  courseReadingTab.setDisabled(true);
    	        	  CRSSTRUCTURE.setActiveTab(studentTab);
	        	  }

        		 
        	  }else{
        		  Ext.getBody().unmask();
        		  showWarningMessage(getCourseTxCommonTranslation('STUDY_MATERIAL_DISTRIBUTION'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        	  }

          },
          courseReadingGridRender : function(){
        	  var $this = this;
        	  var grid = $this.getDistributionlistforcoursereading();
    		  var records = grid.getSelectionModel().getSelection();
    		  $this.doAccessControlValidation($this.getCoursereadinggrid(), $this.getSTUDY_MATERIAL_COURSE_READING_PERMISSIONS());
    		  var id=records[0].get("id");
    		  var store = $this.getStore('coursetransaction.studymaterialdistribution.CourseReadingGrid');
    		  store.getProxy().extraParams = {
    			  distributionId:id
    		  };
    		  store.load();
        	  
          },
          onGridRender : function(){
        	  var $this = this;
        	  var grid = $this.getDistributionlistforcoursereading();
        	  $this.doAccessControlValidation(grid,$this.getSTUDY_MATERIAL_DISTRIBUTION_PERMISSIONS());
        	  $this.disableMoreActionPivileges(grid,$this.getSTUDY_MATERIAL_DISTRIBUTION_PERMISSIONS());
        	  var store = grid.getStore();
        	  store.load();  
          },
          showCourseReading:function(){
        	  var formWindow = this.getCoursereading();
        	  if (!formWindow) {
        		  Ext.widget('coursereading');
        		  formWindow = this.getCoursereading();
        	  }
        	  formWindow.show();
          },
          courseVariantDropDown:function(){
        	  var $this = this;
        	  var grid = $this.getDistributionlistforcoursereading();
        	  var records = grid.getSelectionModel().getSelection();
        	  var id=records[0].get("id");

        	  var courseVariantComboBox = this.getCoursereading().down('customcombobox#courseVariant_Id');
        	  courseVariantComboBox.clearValue();

        	  var courseVariantStore = courseVariantComboBox.getStore();
        	  courseVariantStore.getProxy().extraParams = {
        		  distributionId:id
        	  };
        	  courseVariantStore.load();
          },
          deleteCourseReading:function(){
        	  var $this = this;
        	  var grid = $this.getCoursereadinggrid();
        	  if (grid.getSelectionModel().getCount() > 0) {
        		  showConfirmMessage(getCourseTxCommonTranslation('DL_COURSE_READING'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
        				  function(btn, text) {
        			  if (btn == 'yes'){
        				  var records = grid.getSelectionModel().getSelection()[0];
        				  var id = records.data.id;
        				  Ext.Ajax
        				  .request({
        					  method : "DELETE",
        					  type : 'rest',
        					  url : SERVERURL.DL_COURSEREADING_CR_DELETE + '?id='+ id,
        					  headers : {
        						  'Content-Type' : 'application/json'
        					  },
        					  params : {
        						  id : id
        					  },
        					  success : function(form,action) {
        						  showSuccessMessage(getCourseTxCommonTranslation('DL_COURSE_READING'),getCommonTranslation('SUCCESS'));
        						  grid.getStore().reload();
        					  }
        				  });
        			  }
        		  });
        	  } else {
        		  Ext.getBody().unmask();
        		  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
        	  }
          },
          closeCourseReading : function(){
        	  this.getCoursereading().close();
          },
          saveCourseReading : function(){
        	  var $this = this;
        	  var courseGrid = $this.getCoursereadinggrid().getStore();
        	  var grid = $this.getDistributionlistforcoursereading();
        	  var records = grid.getSelectionModel().getSelection()[0];
        	  var distributionListId = records.get("id");

        	  var frm = $this.getCourseReading();
        	  var frmWin = frm.getForm();
        	  var value = frmWin.getValues();

        	  var crsm = new Academia.model.coursetransaction.studymaterialdistribution.CourseReadingSubmitModel();
        	  crsm.set("courseVariant",$this.getIdValueJson(value.courseVariant));
        	  crsm.set("distributionList",$this.getIdValueJson(distributionListId));
        	  crsm.set("courseReading",$this.getIdValueJson(value.readingName));

        	  var submitUrl;
        	  if (value.id == null ||value.id == "") {
        		  submitUrl = SERVERURL.DL_COURSEREADING_CR_CREATE;
        	  } else {
        		  crsm.set("id",value.id);
        		  submitUrl = SERVERURL.DL_COURSEREADING_CR_UPDATE;
        	  }

        	  var submitData = Ext.encode(crsm.data);

        	  Ext.Ajax.request({
        		  method: "POST",
        		  type: 'rest',
        		  jsonData: submitData,
        		  url: submitUrl,
        		  headers: {
        			  'Content-Type': 'application/json'
        		  },
        		  success:function(response){
        			  var mssg = response.responseText;
        			  if(mssg=='CourseReadingAlreadyExist'){
        				  showWarningMessage(getCourseTxCommonTranslation('COURSE_READING_DISTRIBUTION'),getCourseTxCommonTranslation('DUPLICATE_MSSG'));//Please select a record 	                            				  
        			  }else{
        			  showSuccessMessage(getCourseTxCommonTranslation('COURSE_READ'),getCommonTranslation('SUCCESS'));
        			  courseGrid.reload();
        			  $this.closeCourseReading();
        		  }}
        	  }); 

          },
          cancelCourseReading : function(){
        	  var $this = this;
        	  $this.getCourseReading().getForm().reset();
          },
          getEditCourseReading : function(){
        	  var $this = this;

        	  var courseGrid = $this.getDistributionlistforcoursereading();
        	  var rec = courseGrid.getSelectionModel().getSelection()[0];
        	  var distributionMode = rec.get("distributionMode");
        	  var distributionListId = distributionMode.id;

        	  var grid = $this.getCoursereadinggrid();
        	  var grdStore = grid.getStore();  

        	  if(grid.getSelectionModel().getCount()>0){
        		  $this.showCourseReading();

        		  var form = $this.getCourseReading();
        		  var records = grid.getSelectionModel().getSelection();
        		  var id=records[0].get("id");
        		  Ext.Ajax.request({
        			  method: "GET",
        			  type: 'rest',
        			  url: SERVERURL.DL_COURSEREADING_CR_FIND_BY_ID,
        			  params:{
        				  id:id
        			  },
        			  success:function(response){

        				  var data = Ext.JSON.decode(response.responseText);
        				  
        				  form.down("#hiddenId").setValue(data.id);
        				  if(data.distributionList!=null){
        					  var dbListId = data.distributionList.id;
        				  }

        				  if(data.courseVariant  != null){
        					  var cvId = data.courseVariant.id;
        				  }

        				  if(data.courseReadType!=null){
        					  var rtId = data.courseReadType.id;
        				  }

        				  if(data.courseReading!=null){
        					  var rnId = data.courseReading.id;
        				  }

        				  var courseVariant = form.down("#courseVariant_Id");
        				  var readingType = form.down("#readingType_Id");
        				  var readingName = form.down("#readingName_Id");

        				  courseVariant.store.load({params:{distributionId:dbListId},
        					  callback: function(r, operation, success) {
        						  if (success) {
        							  courseVariant.setValue(cvId);
        						  }
        					  }
        				  });

        				  readingType.store.load({
        							  params:{
        								  courseVariantId:cvId
        							  },
        							  callback: function(r, operation, success) {
        								  if (success) {
        									  readingType.setValue(rtId);
        								  }
        							  }
        						  });


        				  readingName.store.load({
        					  params:{
        					  //courseReadTypeId:rtId,
        						courseVariantId :cvId,
        					  distributionModeId:distributionListId	 
        				    },
        				  callback: function(r, operation, success) {
        					  if (success) {
        						  readingName.setValue(rnId);
        					  }
        				  }
        				  });
        			  }
        		  }); 

        	  }else{
        		  showWarningMessage(getCourseTxCommonTranslation('COURSE_READING_DISTRIBUTION'),getCommonTranslation('PLEASE_SELECT_RECORD'));//Please select a record 
        	  }


          },
          getViewCourseReading : function(){

        	  var $this = this;
        	  $this.getEditCourseReading();
        	  var form = $this.getCourseReading();
        	  if (form) {
        		  form.down("#SubmitBtn").setVisible(false);
        		  form = form.getForm();
        		  toggleReadOnlyFormItems(form, true);
        	  }
          },
          getsenderStatusWin : function(){
        	  var $this = this;
        	  
        	  var grid = $this.getStudentgrid();
        	  var grdStore = grid.getStore(); 
        	  var selected= grid.getSelectionModel().getSelection()[0];
        	  
        	  if((selected.get("recivingStatus")==getCourseTxCommonTranslation('RECIEVED_STATUS')) ||
        			  (selected.get("sendingStatus")=='Resent') || 
        			  (selected.get("sendingStatus") == getCourseTxCommonTranslation('RETURNED_STATUS'))){
        		  //showWarningMessage(getCourseTxCommonTranslation('STUDENT'),getCourseTxCommonTranslation('MATERIAL_WARN_MSSG'));
        		  $this.receiveStatusForStudent(grid,grdStore);
        		  var form = $this.getStudentstatuswin();
        		  form.down('#sentDate').setReadOnly(true);
        		  form.down('#serviceProvider').setReadOnly(true);
        		  form.down('#consignmentRef').setReadOnly(true);
        		  form.down('#remarks').setReadOnly(true);
        		  form.down('#SubmitBtn').setVisible(false);
        	  }else{
        		  $this.receiveStatusForStudent(grid,grdStore);
        		  /*
        		  
        	  var frmWin = $this.getStudentstatuswin();
        	  if(!frmWin){
        	      Ext.widget('studentstatuswin');
        	      frmWin = $this.getStudentstatuswin();
        	  }
        	  frmWin.show();
        	  
        	  var form = frmWin.down("#studentstatusform").getForm();
        	  
        	  var dlGrid = $this.getDistributionlistforcoursereading();
        	  var dlStore=this.getStore('coursetransaction.studymaterialdistribution.DistributionforCourseReadingStore');
        	  var selectedRecord = dlGrid.getSelectionModel().getSelection()[0];
        	  form.findField("sentDate").setMinValue(selectedRecord.data.createdDate);
        	  
        	  var row = dlStore.indexOf(selectedRecord);
              var data =dlStore.getAt(row);
              var rec = data.getData();
              
        	  var value = rec.distributionMode.value;
        	  
        	  
        	  if(value=='Courier' || value=='Post'){
        		  form.findField("serviceProvider").setVisible(true);
        		  form.findField("consignmentRef").setVisible(true);
        	  }
        	  var records = grid.getSelectionModel().getSelection();
        	  var id=records[0].get("id");
        	  Ext.Ajax.request({
        		  method: "GET",
        		  type: 'rest',
        		  url: SERVERURL.DL_STUDENT_FIND_BY_ID,
        		  params:{
        			  id:id
        		  },
        		  success:function(response){

        			  var data = Ext.JSON.decode(response.responseText);
        			  
        			  if(data.sender!=null){
        				  form.findField("sentById").setValue(data.sender.id);
        				  form.findField("sentByName").setValue(data.sender.value);
        			  }
        			  
        			  var checkbox = Ext.ComponentQuery.query('checkboxfield#whetherReturn')[0];
        			  checkbox.setValue(data.whetherReturn);
        			  var receiveDate =  form.findField("receivedDate");
        			  var returnDate = form.findField("returnDate");
        			  var sentDate = form.findField("sentDate");
        			  
        			  form.findField("id").setValue(data.id);
        			  form.findField("serviceProvider").setValue(data.serviceProvider);
        			  form.findField("consignmentRef").setValue(data.consignmentRef);
        			  form.findField("remarks").setValue(data.remarks);
        			  
        			  sentDate.setValue(data.sentDate);
        			  receiveDate.setValue(data.receivedDate);
        			  returnDate.setValue(data.returnDate);
        			 
        			  if(data.sentDate){
        				  sentDate.setReadOnly(true);
        			  }
        			  if(data.returnDate){
        				  returnDate.setVisible(true);
        				  receiveDate.setVisible(false);
        			  }
        			  if(data.receivedDate){
        				  receiveDate.setReadOnly(true);
        				  form.findField("whetherReturn").setVisible(false);
        			  }
        		  }
        	  });
        	  */}
          },
          receiveStatusForStudent:function(grid,grdStore){
        	  var  $this =this;
    		  
        	  var frmWin = $this.getStudentstatuswin();
        	  if(!frmWin){
        	      Ext.widget('studentstatuswin');
        	      frmWin = $this.getStudentstatuswin();
        	  }
        	  frmWin.show();
        	  
        	  var form = frmWin.down("#studentstatusform").getForm();
        	  
        	  var dlGrid = $this.getDistributionlistforcoursereading();
        	  var dlStore=this.getStore('coursetransaction.studymaterialdistribution.DistributionforCourseReadingStore');
        	  var selectedRecord = dlGrid.getSelectionModel().getSelection()[0];
        	  form.findField("sentDate").setMinValue(dateRender(selectedRecord.data.createdDate));
        	  
        	  var row = dlStore.indexOf(selectedRecord);
              var data =dlStore.getAt(row);
              var rec = data.getData();
              
        	  var value = rec.distributionMode.value;
        	  
        	  
        	  if(value=='Courier' || value=='Post'){
        		  form.findField("serviceProvider").setVisible(true);
        		  form.findField("consignmentRef").setVisible(true);
        	  }
        	  var records = grid.getSelectionModel().getSelection();
        	  var id=records[0].get("id");
        	  Ext.Ajax.request({
        		  method: "GET",
        		  type: 'rest',
        		  url: SERVERURL.DL_STUDENT_FIND_BY_ID,
        		  params:{
        			  id:id
        		  },
        		  success:function(response){

        			  var data = Ext.JSON.decode(response.responseText);
        			  
        			 /* if(data.sender!=null){
        				  form.findField("sentById").setValue(data.sender.id);
        				  form.findField("sentByName").setValue(data.sender.value);
        			  }*/
        			  
        			  var checkbox = Ext.ComponentQuery.query('checkboxfield#whetherReturn')[0];
        			  checkbox.setValue(data.whetherReturn);
        			  var receiveDate =  form.findField("receivedDate");
        			  var returnDate = form.findField("returnDate");
        			  var sentDate = form.findField("sentDate");
        			  
        			  form.findField("id").setValue(data.id);
        			  form.findField("serviceProvider").setValue(data.serviceProvider);
        			  form.findField("consignmentRef").setValue(data.consignmentRef);
        			  form.findField("remarks").setValue(data.remarks);
        			  
        			  sentDate.setValue(dateRender(data.sentDate));
        			  receiveDate.setValue(dateRender(data.receivedDate));
        			  returnDate.setValue(dateRender(data.returnDate));
        			 
        			  if(data.sentDate){
        				  sentDate.setReadOnly(true);
        			  }
        			  if(data.returnDate){
        				  returnDate.setVisible(true);
        				  receiveDate.setVisible(false);
        			  }
        			  if(data.receivedDate){
        				  receiveDate.setReadOnly(true);
        				  form.findField("whetherReturn").setVisible(false);
        			  }
        		  }
        	  });
        	    
          },
          closeSenderStatusWin : function(){
        	  this.getStudentstatuswin().close();
          },
          setsenderStatusWin : function(){
        	
        	  var $this = this;
        	  var frmWin = $this.getStudentstatusWin();
        	  var form = frmWin.getForm();
        	  var value = form.getValues();
        	  var sendStatus;
        	  var recevStatus;
        	  
        	  var grid = $this.getStudentgrid();
        	  var grdStore = grid.getStore();  
        	  
        		var store=this.getStore('coursetransaction.studymaterialdistribution.StudentGridStore');
            	var selectedRecord = grid.getSelectionModel().getSelection()[0];
            	var row = store.indexOf(selectedRecord);
            	var data =store.getAt(row);
            	var records = data.getData();
            	
        		  if(value.returnDate){
        		     sendStatus = getCourseTxCommonTranslation('RETURNED_STATUS');
        		     recevStatus = records.recivingStatus;
        		  }else{
        			  sendStatus = records.sendingStatus;
        			  
        			  if(value.receivedDate){
        				  recevStatus = getCourseTxCommonTranslation('RECIEVED_STATUS');
        			  }else{
        				  recevStatus = getCourseTxCommonTranslation('HW_PENDING');
        			  }
        			  
        		  }
        	  
        	  
        	  var studentModel = new Academia.model.coursetransaction.studymaterialdistribution.StudentModel();
        	  
            	 studentModel.set("whetherReturn",value.whetherReturn);
            	 studentModel.set("sender",$this.getIdValueJson(value.sentById, value.sentByName));
            	 studentModel.set("sentDate",value.sentDate);
            	 studentModel.set("consignmentRef",value.consignmentRef);
            	 studentModel.set("serviceProvider",value.serviceProvider);
            	 studentModel.set("receivedDate",value.receivedDate);
                 studentModel.set("remarks",value.remarks);
                 studentModel.set("returnDate",value.returnDate); 
            	   
        	     studentModel.set("approveDate",records.approveDate);
                 studentModel.set("approveReason",records.approveReason);
                 studentModel.set("approveFlag",records.approveFlag);
                 studentModel.set("approvedBy",records.approvedBy);
                 studentModel.set("id",records.id);
                 studentModel.set("admission",records.admission);
                 studentModel.set("distributionList",records.distributionList);
                 studentModel.set("handoverTo",records.handoverTo);
                 studentModel.set("recivingStatus",recevStatus);
                 studentModel.set("sendingStatus",sendStatus);
                 studentModel.set("sentSequence",records.sentSequence);
                 studentModel.set("student",records.student);
                 studentModel.set("customFieldDatas",value.customFieldDatas);
                 
                 var sudmitData = Ext.encode([studentModel.data]);
                 
                 Ext.Ajax.request({
                      method: "POST",
                      type: 'rest',
                      jsonData: sudmitData,
                      url: SERVERURL.DL_STUDENT_UPDATE,
                      headers: {
                          'Content-Type': 'application/json'
                      },
                      success:function(response){
                          showSuccessMessage(getCourseTxCommonTranslation('STUDENT'),getCommonTranslation('SUCCESS'));
                          grdStore.reload();
                          grid.getSelectionModel().deselectAll();
                          $this.closeSenderStatusWin();
                      }
                  });
        	  
          },
          showAddStudentWindow : function(){
        	  
        	  var $this = this;
        	  var grid = $this.getDistributionlistforcoursereading();
    		  var records = grid.getSelectionModel().getSelection()[0];
    		  var distributionListId = records.get("id");
        	  var admissionNo='';
        	  var studentName='';
        	  
        	  
        	  var store = $this.getStore('coursetransaction.studymaterialdistribution.AddStudentStore');
        	  store.getProxy().extraParams = {
        		  distributionListId:distributionListId,
        		  admissionId:admissionNo,
        		  studentName:studentName
      		  };
        	  store.load();
        	  
        	  var formWindow = $this.getAddstudentwin();
        	  if(!formWindow){
        	       Ext.widget('addstudentwin');
        	       formWindow = $this.getAddstudentwin();
        	    }
        	  formWindow.show();
          },
          closeAddStudentWindow : function(){
        	
        	  var formWindow = this.getAddstudentwin();
        	  formWindow.close(); 
          },
          deleteAddStudentWindow : function(){

        	  var $this = this;
        	  var grid = $this.getStudentgrid();
        	  if (grid.getSelectionModel().getCount() > 0) {

        		  showConfirmMessage(getCourseTxCommonTranslation('STUDENT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
        				  function(btn, text) {
        			  if (btn == 'yes'){
        				  var records = grid.getSelectionModel().getSelection();
        				  //var id = records.data.id;
        				  var ids = new Array();
        				  Ext.Array.each(records,function(record){
        					  ids.push(record.data.id);
        				  });
        				  
        				  Ext.Ajax.request({
        					  method : "DELETE",
        					  type : 'rest',
        					  url : SERVERURL.DL_STUDENT_DELETE + '?ids=' + ids,
        					  headers : {
        						  'Content-Type' : 'application/json'
        					  },
        					  params : {
        						  ids : ids
        					  },
        					  success : function(form,action) {
        						  showSuccessMessage(getCourseTxCommonTranslation('STUDENT'),getCommonTranslation('SUCCESS'));
        						  grid.getStore().reload();
        					  }
        				  });
        			  }
        		  });
        	  } else {
        		  showWarningMessage(getCourseTxCommonTranslation('STUDENT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
        	  }
          },
          studentGridRender : function(){
        	  var $this = this;
        	  
        	  var CRGrid = $this.getCoursereadinggrid();
        	  var rec = CRGrid.getStore().getRange();
        	  var studentGrid = $this.getStudentgrid();
        	  var buttonsToolBar = studentGrid.query('toolbar')[0];
        	  var addBtn = buttonsToolBar.query('#btnAdd')[0];
        	  
        	  if(rec.length==0){
        		  addBtn.hide();
        	  }
        	  
        	  var grid = $this.getDistributionlistforcoursereading();
        	  var records = grid.getSelectionModel().getSelection();
        	 
        	  var id=records[0].get("id");
        	  var assignmentId = records[0].get("courseHomeWorkAssignment");
        	  var store = $this.getStore('coursetransaction.studymaterialdistribution.StudentGridStore');
        	 
        	  if(assignmentId!=null && assignmentId>0){
        	   store.getProxy().extraParams = {
        		  distributionId:id,
        		  hwassignmentId:assignmentId.id
        	    };
        	  }else{
        		  store.getProxy().extraParams = {
            		  distributionId:id
            	    };  
        	  }
        	  store.load();
          },
          courseAndstudentTabChange:function(tabPanel, newCard, oldCard){
        	 
        	  var $this = this;
        	  var title = tabPanel.items.items[1].title;
        	  if(title==getCourseTxCommonTranslation('STUDENT')){
            	  var CRGrid = $this.getCoursereadinggrid();
            	  var rec = CRGrid.getStore().getRange();
            	  var studentGrid = $this.getStudentgrid();
            	  var buttonsToolBar = studentGrid.query('toolbar')[0];
            	  var addBtn = buttonsToolBar.query('#btnAdd')[0];
            	   if(rec.length==0){
            		  addBtn.hide();
            	   }else{
            		   addBtn.show();
            	   }
        	  }
          },
          getApprovedLink : function(){
        	  var $this = this;
        	  
        	  var frmWin = $this.getApprovalformwin();
        	  if(!frmWin){
        		  Ext.widget('approvalformwin');
        		  frmWin = $this.getApprovalformwin();
        	  }
        	  
        	  var dlGrid = $this.getDistributionlistforcoursereading();
        	  var selectedRecord = dlGrid.getSelectionModel().getSelection()[0];
        	  frmWin.down("#approveDate").setMaxValue(dateRender(selectedRecord.data.createdDate));
        	  
        	  var grid = $this.getStudentgrid();

        	  if (grid.getSelectionModel().getCount() > 0) {
        		  var record = grid.getSelectionModel().getSelection();
        		  var approvedStatus=[];
        		  for(var i in record){
        		     approvedStatus.push(record[i].get("autoApprovedStatus"));
        		   }
        		   var status = Ext.Array.contains(approvedStatus,true);
        		  if(!status){
        			  frmWin.show();  
        		  }else{
        			  showWarningMessage(getCourseTxCommonTranslation('STUDENT'),getCourseTxCommonTranslation('STUDENT_ALREADY_APPROVED'));
        		  }
        	  }else{
        		  showWarningMessage(getCourseTxCommonTranslation('STUDENT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        	  }
          },
          closeApprovedLink : function(){
        	  var frmWin = this.getApprovalformwin();
			  frmWin.close();
          },
          setApprovedLink:function(){
        	  
              var $this = this;
        	  var frmWin = $this.getApprovalformWin();
        	  var form = frmWin.getForm();
        	 
        	  var value = form.getValues();
        	  
        	  var grid = $this.getStudentgrid();
        	  var grdStore = grid.getStore();  
        	  var records = grid.getSelectionModel().getSelection();
        	  if(records.length>0){
            		 var sudmitData=[];
            		  for(var i in records){  
            			  sudmitData.push({
                    	 "approveDate":value.approveDate,
                    	 "approveReason":value.approvedReason,
                    	 "approveFlag":true,
                    	 "approvedBy":records[i].get("approvedBy"),
                    	 "id":records[i].get("id"),
                    	 "admission":records[i].get("admission"),
                    	 "consignmentRef":records[i].get("consignmentRef"),
                    	 "distributionList":records[i].get("distributionList"),
                    	 "handoverTo":records[i].get("handoverTo"),
                    	 "recivingStatus":records[i].get("recivingStatus"),
                    	 "receivedDate":records[i].get("receivedDate"),
                    	 "remarks":records[i].get("remarks"),
                    	 "returnDate":records[i].get("returnDate"),
                    	 "sender":records[i].get("sender"),
                    	 "sendingStatus":records[i].get("sendingStatus"),
                    	 "sentDate":records[i].get("sentDate"),
                    	 "sentSequence":records[i].get("sentSequence"),
                    	 "serviceProvider":records[i].get("serviceProvider"),
                    	 "student":records[i].get("student"),
                    	 "whetherReturn":records[i].get("whetherReturn")
            			  });
            		}
            	 
            	 Ext.Ajax.request({
            		  method: "POST",
            		  type: 'rest',
            		  jsonData: sudmitData,
            		  url: SERVERURL.DL_STUDENT_UPDATE,
            		  headers: {
            			  'Content-Type': 'application/json'
            		  },
            		  success:function(response){
            			  showSuccessMessage(getCourseTxCommonTranslation('STUDENT'),getCommonTranslation('SUCCESS'));
            			  grdStore.reload();
            			  grid.getSelectionModel().deselectAll();
            			  $this.closeApprovedLink();
            		  }
            	  }); 
            	  }
        	
          },
          saveStudent : function(){
        	  
        	  var $this = this;
        	  var crgrid = $this.getDistributionlistforcoursereading();
    		  var rec = crgrid.getSelectionModel().getSelection()[0];
        	  var distributionListId = rec.get("id");
        	  
        	  var frmWin = $this.getAddstudentwin();
        	  var studentGrid = $this.getStudentgrid();
        	  var grdStore = studentGrid.getStore(); 
        	  var grid = frmWin.down("#studentgridwin");
        	  var records = grid.selModel.getSelection();
        		 var studentJson=[];
        	     if(records.length>0){
        	    	 for(var i in records){
        	    	 studentJson.push({
        	    		"distributionList":$this.getIdValueJson(distributionListId),
        	    		"admission":$this.getIdValueJson(records[i].data.admission.id),
        	    		"recivingStatus":"PENDING",
        	    		"sendingStatus":"PENDING"
        	    	 });	
        	    	 }
        	    	 $this.applyWindowMask();
        	  Ext.Ajax.request({
        		  method: "POST",
        		  type: 'rest',
        		  jsonData: studentJson,
        		  url: SERVERURL.DL_STUDENT_CREATE,
        		  headers: {
        			  'Content-Type': 'application/json'
        		  },
        		  success:function(response){
        			  $this.hideWindowMask();
        			  showSuccessMessage(getCourseTxCommonTranslation('STUDENT'),getCommonTranslation('SUCCESS'));
        			  grdStore.reload();
        			  studentGrid.getSelectionModel().deselectAll();
        			  $this.closeAddStudentWindow();
        		  }
        	  }); 
        	 }else{
        		  $this.hideWindowMask();
        		 showWarningMessage(getCourseTxCommonTranslation('STUDENT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        	 }
          },
          getMarkAsSent : function(){
        	  var $this = this;
        	  var grid = $this.getStudentgrid();
        	  var grdStore = grid.getStore();  
        	  var records = grid.getSelectionModel().getSelection();
        	  if (grid.getSelectionModel().getCount() > 0) {
        	  var markAsSentStatus=[];
        	  var markAsStatus=[];
        	  
    		  for(var i in records){
    			  markAsStatus.push(records[i].get("sendingStatus"));
    			  markAsSentStatus.push(records[i].get("autoApprovedStatus"));
    		   }
    		   var sentStatus = Ext.Array.contains(markAsStatus,getCourseTxCommonTranslation('SENT'));
    		   
    		   var status = Ext.Array.contains(markAsSentStatus,null);
    		   if(sentStatus){
    			   showWarningMessage(getCourseTxCommonTranslation('STUDENT'),getCourseTxCommonTranslation('MATERIAL_ALREADY_SENT')); 
    		   }else{
    		   if(status){
    			  showWarningMessage(getCourseTxCommonTranslation('STUDENT'),getCourseTxCommonTranslation('STUDENT_NOT_APPROVED')); 
    		  }else{
        	  if(records.length>0){
        		 var sudmitData=[];
        		 
        		  for(var i in records){
        			  var sentSequence;
        			  
        			if(records[i].get("sendingStatus") == 'Resent'){
        				showWarningMessage(getCourseTxCommonTranslation('STUDENT'),getCourseTxCommonTranslation('MATERIAL_ALREADY_SENT'));
        				
        			}else if((records[i].get("sendingStatus") == 'Returned') &&
        		        		(records[i].get("recivingStatus") == 'Pending')){
        				  
        				  sentSequence = records[i].get("sentSequence"); + 1;
        				  
        				  sudmitData.push({
     	                	 "approveDate":records[i].get("approveDate"),
     	                	 "approveReason":records[i].get("approveReason"),
     	                	 "approveFlag":records[i].get("approveFlag"),
     	                	 "approvedBy":records[i].get("approvedBy"),
     	                	 "id":records[i].get("id"),
     	                	 "admission":records[i].get("admission"),
     	                	 "consignmentRef":records[i].get("consignmentRef"),
     	                	 "distributionList":records[i].get("distributionList"),
     	                	 "handoverTo":records[i].get("handoverTo"),
     	                	 "recivingStatus":getCourseTxCommonTranslation('HW_PENDING'),
     	                	 "receivedDate":records[i].get("receivedDate"),
     	                	 "remarks":records[i].get("remarks"),
     	                	 "returnDate":records[i].get("returnDate"),
     	                	 "sender":records[i].get("sender"),
     	                	 "sendingStatus":'Resent',//getCourseTxCommonTranslation('SENT'),
     	                	 "sentDate":records[i].get("sentDate"),
     	                	 "sentSequence":sentSequence,
     	                	 "serviceProvider":records[i].get("serviceProvider"),
     	                	 "student":records[i].get("student"),
     	                	 "whetherReturn":null
     	        			  });
     				  
//        				  var url;
//        				  if(records[i].get("sendingStatus") == 'Returned' &&
//  		        		   records[i].get("recivingStatus") == 'Pending'){
        				  sudmitData[0].sendingStatus='Resent';
        					  Ext.Ajax.request({
             		        		method: "POST",
             		        		type: 'rest',
             		        		jsonData: sudmitData,
             		        		url: SERVERURL.DL_STUDENT_UPDATE,
             		        		headers: {
             		        			'Content-Type': 'application/json'
             		        		},
             		        		success:function(response){
             		        			showSuccessMessage(getCourseTxCommonTranslation('STUDENT'),getCommonTranslation('SUCCESS'));
             		        			/*grdStore.reload();
             		        			grid.getSelectionModel().deselectAll();*/
             		        		}
             		        	});
        					  
        					var  sudmitData1=[];
        					  sudmitData1.push({
          	                	 "approveDate":null,
          	                	 "approveReason":null,
          	                	 "approveFlag":null,
          	                	 "approvedBy":null,
          	                	 "id":records[i].get("id"),
          	                	 "admission":records[i].get("admission"),
          	                	 "consignmentRef":null,
          	                	 "distributionList":records[i].get("distributionList"),
          	                	 "handoverTo":null,
          	                	 "recivingStatus":getCourseTxCommonTranslation('HW_PENDING'),
          	                	 "receivedDate":null,
          	                	 "remarks":null,
          	                	 "returnDate":null,
          	                	 "sender":null,
          	                	 "sendingStatus":getCourseTxCommonTranslation('SENT'),
          	                	 "sentDate":null,
          	                	 "sentSequence":sentSequence + 1,
          	                	 "serviceProvider":null,
          	                	 "student":records[i].get("student"),
          	                	 "whetherReturn":null
          	        			  });
        					  
//        					  sudmitData[0].sendingStatus='SENT';
//        						Object { distributionList={...}, admission={...}, recivingStatus="PENDING", more...}
        						
        						/*admission Object { id=22}
        						distributionList Object { id=6}
        						recivingStatus "PENDING"*/
        							
//        						sendingStatus
//        					  url = SERVERURL.DL_STUDENT_CREATE;
        				  
        					  Ext.Ajax.request({
             		        		method: "POST",
             		        		type: 'rest',
             		        		jsonData: sudmitData1,
             		        		url: SERVERURL.DL_STUDENT_CREATE,
             		        		headers: {
             		        			'Content-Type': 'application/json'
             		        		},
             		        		success:function(response){
             		        			showSuccessMessage(getCourseTxCommonTranslation('STUDENT'),getCommonTranslation('SUCCESS'));
             		        			grdStore.reload();
             		        			grid.getSelectionModel().deselectAll();
             		        		}
             		        	});
        				  
//        			  }
        			  /*else{
        				  showWarningMessage(getCourseTxCommonTranslation('STUDENT'),getCourseTxCommonTranslation('STUDENT_NOT_APPROVED')); 
        			  }  */
        			  }else{
        				  //sentSequence = records[i].get("sentSequence");
        				  sentSequence = records[i].get("sentSequence") + 1;
        			  
        			  sudmitData.push({
                	 "approveDate":records[i].get("approveDate"),
                	 "approveReason":records[i].get("approveReason"),
                	 "approveFlag":records[i].get("approveFlag"),
                	 "approvedBy":records[i].get("approvedBy"),
                	 "id":records[i].get("id"),
                	 "admission":records[i].get("admission"),
                	 "consignmentRef":records[i].get("consignmentRef"),
                	 "distributionList":records[i].get("distributionList"),
                	 "handoverTo":records[i].get("handoverTo"),
                	 "recivingStatus":getCourseTxCommonTranslation('HW_PENDING'),
                	 "receivedDate":records[i].get("receivedDate"),
                	 "remarks":records[i].get("remarks"),
                	 "returnDate":records[i].get("returnDate"),
                	 "sender":records[i].get("sender"),
                	 "sendingStatus":getCourseTxCommonTranslation('SENT'),
                	 "sentDate":records[i].get("sentDate"),
                	 "sentSequence":sentSequence,
                	 "serviceProvider":records[i].get("serviceProvider"),
                	 "student":records[i].get("student"),
                	 "whetherReturn":null
        			  });
        			  
        	Ext.Ajax.request({
      		  method: "POST",
      		  type: 'rest',
      		  jsonData: sudmitData,
      		  url: SERVERURL.DL_STUDENT_UPDATE,
      		  headers: {
      			  'Content-Type': 'application/json'
      		  },
      		  success:function(response){
      			  showSuccessMessage(getCourseTxCommonTranslation('STUDENT'),getCommonTranslation('SUCCESS'));
      			  grdStore.reload();
      			  grid.getSelectionModel().deselectAll();
      		  }
      	  }); 
       }

        			
        }
        	}
    		 }}
        	  }else{
        		  showWarningMessage(getCourseTxCommonTranslation('STUDENT'),getCommonTranslation('PLEASE_SELECT_RECORD'));  
        	  }
          },
          getIdValueJson: function(id, value) {
        	  if (id) return {
        		  id: id,
        		  value: value
        	  };
          },
          loadDynamicGridForSMD: function(respectiveLinkViewCode, respectiveLinkConfigCode,getSearchForm,getResultGrid,model,records) {
          

              var searchResultGrid = getResultGrid;
        	  var searchForm = getSearchForm;// getDynamic search form

              var jsonFormatFormData = this.createJsonFormat(searchForm,respectiveLinkConfigCode,records);
              var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
              resultViewUrl = resultViewUrl.concat(respectiveLinkViewCode); // CONSTANTS.CB.CR_COURSE_GROUP_ASSOCIATED_VIEWCODE);
              
              searchResultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
          
          },

          createJsonFormat: function(searchForm,respectiveLinkConfigCode,records) {
              var formValues = new Array();
              var values = new Object();
              var searchcriteria = new Array();

             values.configCode = respectiveLinkConfigCode;

               formValues = searchForm.getValues();
               
            /* var PROGRAM_ID = this.getJsonObject('PROGRAM_ID', formValues.PROGRAM_ID);
      	     this.pushJsonObjectInArray(PROGRAM_ID,searchcriteria);
      	
      	     var BATCH_ID = this.getJsonObject('BATCH_ID',formValues.PROGRAM_BATCH_ID);
      	     this.pushJsonObjectInArray(BATCH_ID,searchcriteria);
      	
      	     var PROGRAM_BATCH_PERIOD_CONFIG_ID = this.getJsonObject('PROGRAM_BATCH_PERIOD_CONFIG_ID',formValues.PROGRAM_BATCH_PERIOD_CONFIG_ID);
      	     this.pushJsonObjectInArray(PROGRAM_BATCH_PERIOD_CONFIG_ID, searchcriteria);*/
      	
      	     var ID = this.getJsonObject('ID',formValues.COURSE_ID);
      	     this.pushJsonObjectInArray(ID, searchcriteria);
      	     
      	     /*var topicType = searchForm.findField("TOPIC_TYPE_ID").getRawValue();
      	     
      	     var TOPIC_TYPE = this.getJsonObject('TOPIC_TYPE', topicType);
      	      this.pushJsonObjectInArray(TOPIC_TYPE, searchcriteria);*/
      	     
      	     var COURSE_TOPICS_ID = this.getJsonObject('COURSE_TOPICS_ID', formValues.TOPIC_NAME_ID);
      	     this.pushJsonObjectInArray(COURSE_TOPICS_ID, searchcriteria);
      	     
      	     var COURSE_READ_TYPE_ID = this.getJsonObject('COURSE_READ_TYPE_ID', formValues.READING_TYPE_ID);
      	     this.pushJsonObjectInArray(COURSE_READ_TYPE_ID, searchcriteria);
      	   
      	     var COURSE_READING_ID = this.getJsonObject('COURSE_READING_ID', formValues.READING_NAME_ID);
      	     this.pushJsonObjectInArray(COURSE_READING_ID, searchcriteria);
      	     
      	     var DISTRIBUTION_LIST_TYPE = this.getJsonObject('DISTRIBUTION_LIST_TYPE',formValues.LIST_NAME_ID);
      	     this.pushJsonObjectInArray(DISTRIBUTION_LIST_TYPE, searchcriteria);
      	     
      	     var SENDING_STATUS = this.getJsonObject('SENDING_STATUS', formValues.SENDER_STATUS_ID);
      	     this.pushJsonObjectInArray(SENDING_STATUS, searchcriteria);
      	     
      	     var RECIVING_STATUS = this.getJsonObject('RECIVING_STATUS', formValues.RECEIVING_STATUS);
      	     this.pushJsonObjectInArray(RECIVING_STATUS, searchcriteria);
      	     
      	     var DISTRIBUTION_MODE_ID = this.getJsonObject('DISTRIBUTION_MODE_ID', formValues.DISTRIBUTION_MODE_ID);
      	     this.pushJsonObjectInArray(DISTRIBUTION_MODE_ID, searchcriteria);
      	     
      	     var DISTRIBUTION_LIST_TYPE = this.getJsonObject('DISTRIBUTION_LIST_TYPE', formValues.LIST_TYPE_ID);
      	     this.pushJsonObjectInArray(DISTRIBUTION_LIST_TYPE, searchcriteria);
      	     
      	     var FROM_DATE = this.getJsonObject('CREATED_DATE_BEORE', formValues.FROM_DATE);
    	     this.pushJsonObjectInArray(FROM_DATE, searchcriteria);
    	     
    	     var TO_DATE = this.getJsonObject('CREATED_DATE_AFTER', formValues.TO_DATE);
    	     this.pushJsonObjectInArray(TO_DATE, searchcriteria);
      	     
              values.searchCriterias = searchcriteria;
              return values;
          },

          getJsonObject: function(key, value, additionalValue) {
              if (value != '' && value != null && additionalValue == undefined) {
                  return {
                      "paramCode": key,
                      "paramValues": [value]
                  };
              } else if (value != '' && additionalValue != undefined) {
                  return {
                      "paramCode": key,
                      "paramValues": [value, additionalValue]
                  };
              }
          },
          pushJsonObjectInArray: function(object, array) {
              if (object) {
                  array.push(object);
              }

          },
          gridRenderFunction: function(grid) {
              grid.addDocked({
                  xtype: 'toolbar',
                  dock: 'top',
                  items: [{
                      xtype: 'button',
                      itemId: 'btnAdd',
                      tooltip: getCommonTranslation('ADD'),
                      glyph: ICONGLYPH.ADDGLYPH
                  }]
              });
          },
          gridRenderFunctionForStudent: function(grid) {
              grid.addDocked({
                  xtype: 'toolbar',
                  dock: 'top',
                  items: [{
                      xtype: 'button',
                      itemId: 'btnAdd',
                      tooltip: getCommonTranslation('ADD'),
                      glyph: ICONGLYPH.ADDGLYPH
                  }]
              });
          },
          disableMoreActionPivileges: function(gridReference,permissionsMap) {
          	
          	var associatedAcadLocationIds = new Array();
          	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
          	
      		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
          	buttonsToolBar = gridReference.query('toolbar')[0];
          	 
          	var splitbuttons = buttonsToolBar.query('splitbutton')[0];
          	splitbuttons.setVisible(false);
      		
          	Ext.each(splitbuttons.menu.items.items, function(menuItems) {
      			menuItems.setVisible(false);
          	});
          	
          	Ext.each(permissionList, function(privilege) {
          		if (privilege === 'MOREACTIONS') {
              		var button = buttonsToolBar.query('#spBtnMoreActions')[0];
              		if(!isNullOrEmpty(button)){
              			button.setVisible(true);
              		}        		
              	}
          		if (privilege === 'ASSIGN') {
              		var button = buttonsToolBar.query('#assignReadingLinked')[0];
              		if(!isNullOrEmpty(button)){
              			button.setVisible(true);
              		}        		
              	}
          		if (privilege === 'COPY') {
              		var button = buttonsToolBar.query('#copyLinked')[0];
              		if(!isNullOrEmpty(button)){
              			button.setVisible(true);
              		}        		
              	}
          	});
          },
          copyDistributionLink:function(grid){
    		  var records = grid.getSelectionModel().getSelection()[0];
        	  var distributionListId = records.get("id");
        	  
        	  Ext.Ajax.request({
    			  method: "GET",
    			  type: 'rest',
    			  url: SERVERURL.DISTRIBUTION_LIST_COPY,
    			  params:{
    				  distributionListId:distributionListId
    			  },
    			  headers: {
    				  'Content-Type': 'application/json'
    			  },
    			  success:function(response){
    				  grid.getStore().load();
    				  grid.getSelectionModel().deselectAll(true);
    				  
    			  }
        	  });
          }
});
