/**
 * @author Rajkumar.patidar
 */
Ext.define('Academia.controller.enquiry.EnquiryReportsController', {
	extend: 'Academia.controller.base.BaseController',
	stores: ['enquiry.dashboard.ClosureRate','enquiry.dashboard.AverageTimeCloseEnquiry',
	         'department.ParentDepartmentStore','common.ProgramsByAcademyIdLocationId',
	         'common.UsersWithDepartmentStore','enquiry.dashboard.PendingEnquiryFormGrid',
	         'enquiry.dashboard.PendingEnquiry','enquiry.dashboard.ClosureRate',
	         'enquiry.reports.SummaryReport','enquiry.EnquiryTypeStore','enquiry.ProgramForEnquiryStore',
	         'enquiry.BatchForEnquiryStore','enquiry.SeatTypeForEnquiryStore','enquiry.reports.SummaryReportForPBST',
	         'enquiry.EnquiryReportTreeStore','criteriabuilder.userquicksearch.QuickSearchName','common.IntakeYearStore',
	         'hostel.roomallocation.UserSmartSearchByUserType', 'common.ProgramByAcademyLocationStore',
	         'enquiry.reports.EnquiryOwnerUserStore','program.ProgramGroupStore','program.ProgramCategoryStore','enquiry.dashboard.EnquirySummaryStore','program.ProgramCategoryByProgramGroupStore'],

	views: ['enquiry.dashboard.EnquiryDashboardManagementStructure','programCourseDashboard.organizationUnit.OrganizationUnit',
	         'enquiry.dashboard.FollowupScheduledStructure','enquiry.dashboard.FollowupScheduledForm',
	         'enquiry.dashboard.PendingEnquiryForm','enquiry.dashboard.PendingEnquiryGrid','enquiry.dashboard.CountOfEnquiriesFilter',
	         'enquiry.dashboard.GroupBarChartForCountofEnquiry','enquiry.dashboard.EnquiryClosureRateFilterForm',
	         'enquiry.dashboard.RichTipChartForClosureRate','reports.common.ColumnChartReport',
	         'enquiry.dashboard.DashBoardChartForClosureReason','enquiry.Reports.summaryreport.SummaryReportStructure',
	         'enquiry.Reports.summaryreport.SummaryReportForm','enquiry.Reports.summaryreport.SummaryReportGrid',
	         'enquiry.Reports.EnquiryReportTabPanel','enquiry.dashboard.PendingEnquiriesStructure',
	         'enquiry.dashboard.CountofEnquiriesStructure','enquiry.dashboard.ClosurRateStructure',
	         'enquiry.dashboard.ClosureReasonStructure','enquiry.dashboard.EnquirySummaryForm','enquiry.dashboard.EnquirySummaryStructure',
	         'enquiry.dashboard.EnquirySummaryGrid','enquiry.dashboard.ClouserRateGrid'],
	                 
	     refs: [{
	    	 ref : 'SummaryReportStructure',
	    	 selector : 'summaryreportstructure' 
	     },{
	    	 ref : 'datanullreportform',
	    	 selector : 'datanullreportform' 
	     },{
	    	 ref:'datanullreportgrid',
	    	 selector:'datanullreportgrid'
	     },{
	    	 ref:'summaryreportgrid',
	    	 selector:'summaryreportgrid'
	     },{
	    	 ref:'summaryreportform',
	    	 selector:'summaryreportform'
	     },{
	    	 ref:'enquiryDashboardManagementStructure',
	    	 selector:'enquirydashboardmanagementstructure'
	     },{
	 		ref: 'organizationunit',
	 		selector: 'organizationunit[itemId=orgEnqDashboardItemId]'
	     },{
	    	 ref:'enquirysummaryform',
	    	 selector:'enquirysummaryform'
	     },{
	    	 ref:'enquirysummarygrid',
	    	 selector:'enquirysummarygrid'
	     }],
	     config: {
	    	 ENQUIRY_FOLLOWUP_SCHEDULED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ENQUIRY_FOLLOWUP_SCHEDULED_PRIVILEGES'),
	    	 SUMMARY_REPORT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SUMMARY_REPORT_PRIVILEGES'),
	    	 ENQUIRY_DASHBOARD_FOLLOWUP_SCHEDULED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ENQUIRY_DASHBOARD_FOLLOWUP_SCHEDULED_PRIVILEGES'),
	    	 ENQUIRY_DASHBOARD_REPORT_PENDING_ENQ_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ENQUIRY_DASHBOARD_REPORT_PENDING_ENQ_PRIVILEGES'),
	    	 ENQUIRY_DASHBOARD_REPORT_COUNT_OF_ENQ_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ENQUIRY_DASHBOARD_REPORT_COUNT_OF_ENQ_PRIVILEGES'),
	    	 ENQUIRY_DASHBOARD_REPORT_ENQ_CLOSURE_RATE_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ENQUIRY_DASHBOARD_REPORT_ENQ_CLOSURE_RATE_PRIVILEGES'),
	    	 ENQUIRY_DASHBOARD_REPORT_CLOSURE_REASON_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ENQUIRY_DASHBOARD_REPORT_CLOSURE_REASON_PRIVILEGES'),
	    	 ENQUIRY_DASHBOARD_REPORT_ENQUIRY_SUMMARY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ENQUIRY_DASHBOARD_REPORT_ENQUIRY_SUMMARY_PRIVILEGES')
	     },
	     init: function() {

	    	 this.control({
	    		 /*'followupscheduledstructure':{
	    			 render : function(obj){
	    				 this.disableEnquiryFollowupScheduledDashboardWidgetPivileges(obj,this.getENQUIRY_FOLLOWUP_SCHEDULED_PERMISSIONS());
	    			 }
	    		 },*/
	    		 /*FixingHeaderColumn*/
	    		 
	    		 'followupscheduledstructure': {
	     			render:function(structure){
	     				var $this = this
	     				structure.body.on('click', function() {
	     					var filter = structure.down('followupscheduledform');
	     					$this.hideInvalidIconFromField(filter);
	     			       });
	     			}
	     		},
	    		 'summaryreportstructure':{
	    			 afterrender : function(structure){
	    				 var grid = structure.down('summaryreportgrid');
	    				 this.getGridHeaderFreeze(grid,structure);
	    			 }
	    		 },
	    		 'pendingenquiriesstructure':{
	    			 render:function(obj){
	    				// this.disablePendingEnquiryDashboardWidgetPivileges(obj,this.getPENDING_ENQUIRY_PERMISSIONS());
	    				 var organizationForm = this.getOrganizationunit().getForm();
	    				 var academyLocation = organizationForm.findField('multiselectAcademyLocation');

	    				 var pendingEnqFormGrid = obj.down('pendingenquiryform');
	    				 var pendingEnqGrid = obj.down('pendingenquirygrid');

	    				 var academyLocationIds=[];
	    				 Ext.Array.each(academyLocation.getValue(),function(value){
	    					 if(Ext.isObject(value)){
	    						 academyLocationIds.push(value.data.id);	
	    					 }else {
	    						 academyLocationIds.push(value);
	    					 }
	    				 });


	    				 pendingEnqFormGrid.getStore().getProxy().extraParams={
	    					 academyLocationIds: academyLocationIds.join()
	    				 };
	    				 pendingEnqFormGrid.getStore().load();
	    				 /*pendingEnqFormGrid.getStore().load({
	    					 callback: function(record, result){
	    						 pendingEnqFormGrid.getStore().removeAll();
	    					 }
	    				 });*/

	    				 pendingEnqGrid.getStore().getProxy().extraParams={
	    					 academyLocationIds: academyLocationIds.join(),
	    					 enquiryCategory:'totalPendingEnquiry'
	    				 };
	    				 pendingEnqGrid.getStore().load();
	    			 }
	    		 },
	    		 'summaryreportform button[itemId=trackenquiry_search]':{
	    			 click:function(obj){
	    				 var form=obj.up('form');
	    				 this.loadSummaryReportGrid(form);
	    			 }
	    		 },
	    		 'enquirysummaryform button[itemId=searchBtn]':{
	    			 click:function(obj){
	    				 //this.showInvalidIconOnField();
	    				 var form=obj.up('form');
	    				 this.showInvalidIconOnField(form);
	    				 this.loadSummaryReportGropingGrid(form);
	    			 }
	    		 },
	    		 'enquirysummaryform button[itemId=resetBtn]':{
	    			 click:function(obj){
	    				 this.resetLeadSummaryForm();
	    			 }
	    		 },
	    		 'enquirysummarygrid splitbutton[itemId=btnExportToPDFJasper] #exportPDFCurrentPage':{
	    			 click:function(obj){
	    				 this.getLeadPDFReport();
	    			 }
	    		 },
	    		 'enquirysummarygrid splitbutton[itemId=btnExportToExcelJasper] #exportExcelCurrentPage':{
	    			 click:function(obj){
	    				 this.getLeadExcelReport();
	    			 }
	    		 },
	    		 
	    		 
	             'enquirysummaryform customcombobox#programGroupItemId': {
	             	select: function(obj, record) {
	             		var form = this.getEnquirysummaryform();
	             		form.down("#programCategoryId").setDisabled(false);
	             		var programId = record[0].get("id");
	             		if(programId > 0){
	             			var store = this.getStore('program.ProgramCategoryByProgramGroupStore');
	             			store.getProxy().extraParams = {
	             				programGroupId: programId
	             			};
	             			store.load();
	             		}
	             	},
	             	change: function(value,newValue) {
	             		if(isNullOrEmpty(newValue)){
	             			var form = this.getEnquirysummaryform();             		
	             			form.down("#programCategoryId").setDisabled(true);
	             		}
	             	}
	             },
	    		 
	    		 'summaryreportform combo[itemId=trackEnquiry_enquiryType]':{
	    			 select:function(obj,record){
	    				 var type=record[0].data.code;
	    				 var grid=this.getSummaryreportgrid();
	    				 if(type=='Admission'){
	    					 grid.columns[4].setVisible(true);
	    				 }else{
	    					 grid.columns[4].setVisible(false);
	    				 }
	    				 grid.getStore().removeAll();
	    				 var this$ = this;
	    				 var form=this$.getSummaryreportform();
	    				 var program = form.down("#programItemId");
	    				 program.reset();
	    				// program.setDisabled(true);
	    				 var batchItemId = form.down("#batchItemId");
	    				 batchItemId.reset();
	    				 batchItemId.setDisabled(true);
	    				 var seatTypeItemId = form.down("#seatTypeItemId");
	    				 seatTypeItemId.reset();
	    				 seatTypeItemId.setDisabled(true);
	    			 }
	    		 },

	    		 'summaryreportform button[itemId=resetBtn]':{
	    			 click : function(){
	    				 var form = this.getSummaryreportform().getForm();
	    				 var this$ = this;
	    				 form.reset();
	    				 var program = form.findField("programId");
	    				// program.setDisabled(true);
	    				 var batchId = form.findField("batchId");
	    				 batchId.setDisabled(true);
	    				 var seatType = form.findField("seatType");
	    				 seatType.setDisabled(true);
	    				 var date = new Date();
	    				 var fromdate = new Date(date.setMonth(date.getMonth() - 3));
	    				 this.getSummaryreportform().down('#fromDate').setValue(fromdate);
	    				 this.getSummaryreportform().down('#toDate').setValue(new Date());
	    			 }
	    		 },
	    		 
	    		 'summaryreportform datefield[itemId=fromDate]':{
	    			 select:function(obj,val){
	    				// obj.nextSibling().setMinValue(val);
	    				 var this$ = this;
	    				 var form=this$.getSummaryreportform();
	    				 var program = form.down("#programItemId");
	    				 //var toDate = form.down("#toDate");
	    				 //toDate.reset();
	    				 program.reset();
	    				// program.setDisabled(true);
	    				 var batchItemId = form.down("#batchItemId");
	    				 batchItemId.reset();
	    				 batchItemId.setDisabled(true);
	    				 var seatTypeItemId = form.down("#seatTypeItemId");
	    				 seatTypeItemId.reset();
	    				 seatTypeItemId.setDisabled(true);
	    			 }
	    		 },
	    		 /*'summaryreportform datefield[itemId=toDate]':{
	    			 select:function(obj,val){
	    				 obj.previousSibling().setMaxValue(val);
	    			 }
	    		 },*/
	    		 'summaryreportform combo[itemId=programItemId]':{
	    			 select:function(obj,val){
	    				 var this$ = this;
	    				 var form=this$.getSummaryreportform();
	    				 var program = form.down("#programItemId");
	    				 var enqNo = form.down("#trackEnquiry_enquiryNo");
	    				 var enqType = form.down("#trackEnquiry_enquiryType");
	    				 var formDt = form.down("#fromDate");
	    				 var tillDt = form.down("#toDate");
	    				 var location = this$.getCurrentAcademyLocation();
	    				 var batchItemId = form.down("#batchItemId");
	    				 batchItemId.setDisabled(false);
	    				 batchItemId.getStore().getProxy().extraParams={
	    					 enquiryTypeId:enqType.getValue(),
	    					 enquiryType:enqType.getRawValue(),
	    					 fromDate:formDt.getValue(),
	    					 toDate:tillDt.getValue(),
	    					 academyLocationId:location,
	    					 enquiryNo:enqNo.getValue(),
	    					 programId:program.getValue()
	    				 };
	    				 batchItemId.getStore().load();
	    			 }
	    		 },
	    		 'summaryreportform combo[itemId=batchItemId]':{
	    			 select:function(obj,val){
	    				 var this$ = this;
	    				 var form=this$.getSummaryreportform();
	    				 var program = form.down("#programItemId");
	    				 var enqNo = form.down("#trackEnquiry_enquiryNo");
	    				 var enqType = form.down("#trackEnquiry_enquiryType");
	    				 var formDt = form.down("#fromDate");
	    				 var tillDt = form.down("#toDate");
	    				 var seatTypeItemId = form.down("#seatTypeItemId");
	    				 var location = this$.getCurrentAcademyLocation();
	    				 seatTypeItemId.setDisabled(false);
	    				 var batchItemId = form.down("#batchItemId");
	    				 seatTypeItemId.getStore().getProxy().extraParams={
	    					 enquiryTypeId:enqType.getValue(),
	    					 enquiryType:enqType.getRawValue(),
	    					 fromDate:formDt.getValue(),
	    					 toDate:tillDt.getValue(),
	    					 academyLocationId:location,
	    					 enquiryNo:enqNo.getValue(),
	    					 programId:program.getValue(),
	    					 batchId:batchItemId.getValue()
	    				 };
	    				 seatTypeItemId.getStore().load();
	    			 }
	    		 },
	    		 'summaryreportform':{
	    			 afterrender:function(){
	    				 var form=this.getSummaryreportform().getForm();
	    				 var enquiryTypeField=form.findField("enquiryType");
	    				 enquiryTypeField.store.load({
	    					 callback: function(records, operation, success) {
	    						 enquiryTypeField.setValue(records[0].data.id);  

	    					 }
	    				 });
	    				 var this$ = this;
	    				 var form=this$.getSummaryreportform();
	    				 var program = form.down("#programItemId");
	    				 var enqNo = form.down("#trackEnquiry_enquiryNo");
	    				 var enqType = form.down("#trackEnquiry_enquiryType");
	    				 var formDt = form.down("#fromDate");
	    				 var tillDt = form.down("#toDate");
	    				 var location = this$.getCurrentAcademyLocation();
	    				 program.setDisabled(false);
	    				 var store = program.getStore();
		      			 store.getProxy().extraParams = {
		      				academyLocationId: location
		      			 };
		      			 store.load();  
	    				 var grid=this.getSummaryreportgrid();
	    				 grid.getStore().removeAll();
	    				 var date = new Date();
	    				 var fromdate = new Date(date.setMonth(date.getMonth() - 3));
	    				 this.getSummaryreportform().down('#fromDate').setValue(fromdate);
	    				 this.getSummaryreportform().down('#toDate').setValue(new Date());
	    			 }
	    		 },
	    		 
	    		/* 'summaryreportform datefield[itemId=fromDate]':{ 
	     			  blur:function(field){
	     				  var fromDate = field.getValue();
	   				  var filter = this.getSummaryreportform();
	   				  var tillDateField = filter.down('#toDate');
	   				  var minTillDate = new Date(fromDate);
	   				  var tillDate = tillDateField.getValue();
	   				  if(tillDate <= field.getValue()){
	   					  tillDateField.setValue(minTillDate);
	   				  }
	   				}
	   			},*/
	   			
	   			/*'summaryreportform datefield[itemId=toDate]':{ 
	   	  			  blur:function(field){
	   	  				  var fromDate = field.getValue();
	   					  var filter = this.getSummaryreportform();
	   					  var tillDateField = filter.down('#fromDate');
	   					  var minTillDate = new Date(fromDate);
	   					  var tillDate = tillDateField.getValue();
	   					  if(tillDate <= field.getValue()){
	   						  tillDateField.setValue(minTillDate);
	   					  }
	   					}
	   				},
*/	    		 
	    		 'summaryreportgrid':{
	    			 render: function(grid){
	    				 this.doAccessControlValidation(grid, this.getSUMMARY_REPORT_PERMISSIONS());
	    			 },
	    			 cellclick:function(view, td,cellIndex, record, tr,rowIndex, e, eOpts){
	    				 var resultTitle = view.up('tabpanel').getActiveTab().title + ' - ' + view.getHeaderAtIndex(cellIndex).text;
	    				 var $this=this;
	    				 var summaryReportGrid=view.ownerCt;
	    				 var columnName = summaryReportGrid.columnManager.columns[cellIndex].dataIndex;
	    				 /**
	    				  * Load enquiry grids by calling enquiry controller and called same function 
	    				  * from enquiry controller to open tab and load grid.
	    				  */
	    				 if (columnName == "noOfEnquiryReceived") {
	    					 if (e.target.tagName == 'A') {
	    						 var enquiryType=record.get("enquiryType");
	    						 var enqIds = record.get("noOfEnquiryReceivedIds");
	    						 if (!isNullOrEmpty(enqIds)&&!isNullOrEmpty(enquiryType)) {
	    							 $this.getEnquiryController().openEnquiryMasterGridsTab(enquiryType,enqIds, resultTitle);
	    						 }
	    					 }
	    				 }
	    				 if (columnName == "noOfEnquiriesClosedSuccesfully") {
	    					 if (e.target.tagName == 'A') {
	    						 var enquiryType=record.get("enquiryType");
	    						 var enqIds = record.get("noOfEnquiriesClosedSuccesfullyIds");
	    						 if (!isNullOrEmpty(enqIds)&&!isNullOrEmpty(enquiryType)) {
	    							 $this.getEnquiryController().openEnquiryMasterGridsTab(enquiryType,enqIds, resultTitle);
	    						 }
	    					 }
	    				 }
	    				 if (columnName == "noOfEnquiriesClosedUnsuccesfully") {
	    					 if (e.target.tagName == 'A') {
	    						 var enquiryType=record.get("enquiryType");
	    						 var enqIds = record.get("noOfEnquiriesClosedUnsuccesfullyIds");
	    						 if (!isNullOrEmpty(enqIds)&&!isNullOrEmpty(enquiryType)) {
	    							 $this.getEnquiryController().openEnquiryMasterGridsTab(enquiryType,enqIds, resultTitle);
	    						 }
	    					 }
	    				 }
	    				 if (columnName == "noOfPendingEnquiry") {
	    					 if (e.target.tagName == 'A') {
	    						 var enquiryType=record.get("enquiryType");
	    						 var enqIds = record.get("noOfPendingEnquiryIds");
	    						 if (!isNullOrEmpty(enqIds)&&!isNullOrEmpty(enquiryType)) {
	    							 $this.getEnquiryController().openEnquiryMasterGridsTab(enquiryType,enqIds, resultTitle);
	    						 }
	    					 }
	    				 }
	    				 e.stopEvent();
	    				 e.stopPropagation();
	    				 return false;
	    			 }
	    		 },
	    		 'enquirydashboardmanagementstructure panel[itemId=enquiryReportView] treepanel[itemId=enquiryReportTreePanelItemId]' : {
	    			 itemclick : this.getOpenEnquiryReportStructure,
	    			 render: function(structure) {
	    				 this.doAccessEnqDashboardReportTreePnl(structure);
	    			 }
	    		 },
	    		 'enquirydashboardmanagementstructure' : {
	    			 afterrender : function(structure){
	    				 var $this = this;
	    				 structure.body.on('scroll', function(e, target) {
	    					 var activeTab = structure.down('#enquiryReportTabStructure').getActiveTab();
	    					 if(!isNullOrEmpty(activeTab)){
	    						 var baseStructure = activeTab;
	    						 var grid = activeTab.down('searchresultgrid');
	    						 if(grid != undefined){
	    							 $this.getMultipleCBGridHeaderFreezeForPaginationFix(grid,structure,true);
	    						 }else{
	    							 grid = activeTab.down('grid');
	    							 if(!isNullOrEmpty(grid)){
	    								 $this.getGridHeaderFreezeWithDisplayGrandTotal(grid,structure,true);
	    							 }
	    						 }
	    					 }
	    				 });
	    				 structure.body.on('click', function() {
	       					var filter = structure.down('organizationunit');
	       					$this.hideInvalidIconFromField(filter);
	       			       });
	    			 }
	    		 },
	    		 'enquirysummarystructure':{
	    			 render:function(structure){
	     				var $this = this
	     				structure.body.on('click', function() {
	     					var filter = structure.down('enquirysummaryform');
	     					$this.hideInvalidIconFromField(filter);
	     			       });
	     			}
	    		 }
	    	 });
	     },
	     getOpenEnquiryReportStructure : function(treePanel, record, item, index, e, eOpts){
	    	 var $this = this;
	    	 var reportstructure = $this.getEnquiryDashboardManagementStructure();
	    	 var treeTab = reportstructure.down('#enquiryReportTreePanelItemId');
	    	 var tabStructure =  reportstructure.down('enquiryreporttabpanel');
	    	 var tabDetail = record.data;
	    	 var structure = Ext.widget(tabDetail.reportXtype);
	    	 var tabs = tabStructure.items.items;

	    	 if (!isNullOrEmpty(tabDetail.text) && !isNullOrEmpty(tabDetail.reportXtype)
	    			 && !isNullOrEmpty(tabDetail.reportXtypeItemId)) {

	    		 treeTab.toggleCollapse();
	    		 openTab(tabStructure, tabDetail.text, structure);
	    		 treePanel.getSelectionModel().deselectAll();
	    	 }
	     },
	     getEnquiryController:function(){
	    	 return this.getController('enquiry.EnquiryController');
	     },
	     loadSummaryReportGrid:function(form){
	    	 var enquiryType=form.getForm().findField("enquiryType").getRawValue();
	    	 var enquiryTypeId=form.getForm().findField("enquiryType").getValue();
	    	 var fromdate=form.getForm().findField("FROM_DATE").getValue();
	    	 var todate=form.getForm().findField("TO_DATE").getValue();
	    	 var enquiryNo = form.getForm().findField("enquiryNo").getValue();
	    	 var fromDate = Ext.Date.format(new Date(fromdate), 'Y-m-d');
	    	 var toDate = Ext.Date.format(new Date(todate), 'Y-m-d');
	    	 var userIds=[];
	    	 for(var i in form.getForm().findField("ownerUser").getValue()){
	    		 userIds.push(!isNullOrEmpty(form.getForm().findField("ownerUser").getValue()[i])?form.getForm().findField("ownerUser").getValue()[i].data.id:null);
	    	 }
	    	 var program = form.down("#programItemId");
	    	 var seatTypeItemId = form.down("#seatTypeItemId");
	    	 var batchItemId = form.down("#batchItemId");

	    	 var grid = this.getSummaryreportgrid();
	    	 //var store = this.getStore('enquiry.reports.SummaryReportForPBST');
	    	 grid.getStore().getProxy().extraParams ={
	    		 enquiryTypeId:enquiryTypeId,
	    		 enquiryType:enquiryType,
	    		 fromDate:fromDate,
	    		 toDate:toDate,
	    		 academyLocationId: this.getCurrentAcademyLocation(),
	    		 enquiryNo:enquiryNo,
	    		 programId:program.getValue(),
	    		 batchId:batchItemId.getValue(),
	    		 seatTypeId:seatTypeItemId.getValue(),
	    		 ownerUserIds:userIds.join(),
	    		 intakeYearId : form.getForm().getValues().intakeYear
	    	 };
	    	 grid.getStore().load();
	     },
	     loadSummaryReportGropingGrid: function(form){
	    	 var formValue = form.getForm().getValues();
	    	 var enquirysummarygrid = this.getEnquirysummarygrid();
	    	 var academyLocationIds= this.getMultiSelectAcademyLocation();
	    	 if(academyLocationIds.length==0){
	    		 academyLocationIds = this.getCurrentAcademyLocation()
	    	 }
	    	 try{
	    		 enquirysummarygrid.getStore().removeAll();
	    	 }
	    	 catch(e){
	    		 console.log('removeAll');
	    	 }
	    	 enquirysummarygrid.getStore().getProxy().extraParams ={
	    		 intakeYearId:formValue.intakeYear,
	    		 programGroupId:formValue.programGroup,
	    		 startDate:formValue.fromDate,
	    		 endDate:formValue.toDate,
	    		 programCategoryId:formValue.programCategory,
	    		 academyLocationIds:academyLocationIds
	    	 };
	    	 try{
	    		 enquirysummarygrid.getStore().load();
	    	 }
	    	 catch(e){
	    		 console.log('removeMaskHere');
	    	 }
	    	 //var data=[{"brandCampusName":"Abbotts-Centurion","gradeName":"Grade 1","totalLead":7,"openLead":5,"closeLead":2,"contactedLead":7,"qualifiedLead":0,"successfullyCloseLead":2,"unSuccessfullyCloseLead":0,"notInterestedLead":0,"couldnNotContactLead":0,"weeklyMovmentLeads":1,"targetTotalDatabaseLeads":null,"percentageToAllLeads":null,"yoyVarianceTotalLead":null,"previousYearLead":null},{"brandCampusName":"Abbotts-Centurion","gradeName":"Grade 2","totalLead":30,"openLead":26,"closeLead":4,"contactedLead":27,"qualifiedLead":3,"successfullyCloseLead":1,"unSuccessfullyCloseLead":3,"notInterestedLead":2,"couldnNotContactLead":1,"weeklyMovmentLeads":-9,"targetTotalDatabaseLeads":900,"percentageToAllLeads":1.25,"yoyVarianceTotalLead":130.77,"previousYearLead":13},{"brandCampusName":"Abbotts-Centurion","gradeName":"Grade 3","totalLead":19,"openLead":19,"closeLead":0,"contactedLead":19,"qualifiedLead":0,"successfullyCloseLead":0,"unSuccessfullyCloseLead":0,"notInterestedLead":0,"couldnNotContactLead":0,"weeklyMovmentLeads":null,"targetTotalDatabaseLeads":200,"percentageToAllLeads":9.5,"yoyVarianceTotalLead":-5.0,"previousYearLead":20},{"brandCampusName":"Crawford-Lonehill","gradeName":"Grade 0000","totalLead":23,"openLead":22,"closeLead":1,"contactedLead":22,"qualifiedLead":1,"successfullyCloseLead":0,"unSuccessfullyCloseLead":1,"notInterestedLead":0,"couldnNotContactLead":0,"weeklyMovmentLeads":null,"targetTotalDatabaseLeads":21321,"percentageToAllLeads":0.11,"yoyVarianceTotalLead":null,"previousYearLead":null},{"brandCampusName":"Crawford-Lonehill","gradeName":"Grade 1","totalLead":12,"openLead":11,"closeLead":1,"contactedLead":12,"qualifiedLead":0,"successfullyCloseLead":1,"unSuccessfullyCloseLead":0,"notInterestedLead":0,"couldnNotContactLead":0,"weeklyMovmentLeads":-1,"targetTotalDatabaseLeads":43124,"percentageToAllLeads":0.03,"yoyVarianceTotalLead":null,"previousYearLead":null},{"brandCampusName":"Crawford-Lonehill","gradeName":"Grade 2","totalLead":1,"openLead":1,"closeLead":0,"contactedLead":0,"qualifiedLead":1,"successfullyCloseLead":0,"unSuccessfullyCloseLead":0,"notInterestedLead":0,"couldnNotContactLead":0,"weeklyMovmentLeads":null,"targetTotalDatabaseLeads":24124,"percentageToAllLeads":0.0,"yoyVarianceTotalLead":null,"previousYearLead":null},{"brandCampusName":"Crawford-Lonehill","gradeName":"Grade 8","totalLead":2,"openLead":2,"closeLead":0,"contactedLead":2,"qualifiedLead":0,"successfullyCloseLead":0,"unSuccessfullyCloseLead":0,"notInterestedLead":1,"couldnNotContactLead":0,"weeklyMovmentLeads":2,"targetTotalDatabaseLeads":2,"percentageToAllLeads":100.0,"yoyVarianceTotalLead":null,"previousYearLead":null},{"brandCampusName":"Crawford-Sandton","gradeName":"Grade 00","totalLead":7,"openLead":7,"closeLead":0,"contactedLead":4,"qualifiedLead":4,"successfullyCloseLead":0,"unSuccessfullyCloseLead":0,"notInterestedLead":1,"couldnNotContactLead":0,"weeklyMovmentLeads":3,"targetTotalDatabaseLeads":null,"percentageToAllLeads":null,"yoyVarianceTotalLead":null,"previousYearLead":null},{"brandCampusName":"Crawford-Sandton","gradeName":"Grade 0000","totalLead":2,"openLead":2,"closeLead":0,"contactedLead":1,"qualifiedLead":2,"successfullyCloseLead":0,"unSuccessfullyCloseLead":0,"notInterestedLead":1,"couldnNotContactLead":0,"weeklyMovmentLeads":2,"targetTotalDatabaseLeads":null,"percentageToAllLeads":null,"yoyVarianceTotalLead":null,"previousYearLead":null},{"brandCampusName":"Crawford-Sandton","gradeName":"Grade 1","totalLead":6,"openLead":5,"closeLead":1,"contactedLead":5,"qualifiedLead":2,"successfullyCloseLead":1,"unSuccessfullyCloseLead":0,"notInterestedLead":1,"couldnNotContactLead":0,"weeklyMovmentLeads":2,"targetTotalDatabaseLeads":null,"percentageToAllLeads":null,"yoyVarianceTotalLead":null,"previousYearLead":null}];
	    	 //enquirysummarygrid.getStore().add(data);
	    	 enquirysummarygrid.down('#btnExportToPDFJasper').setDisabled(false);
	    	 enquirysummarygrid.down('#btnExportToExcelJasper').setDisabled(false);
	     },
	     getLeadExcelReport:function(){
	    	 var $this=this;
	    	 var form=$this.getEnquirysummaryform();
	    	 var formValue = form.getForm().getValues();
	    	 var enquirysummarygrid = this.getEnquirysummarygrid();
	    	 var code = "LeadSummaryReport_Excel";
	         var reportParams =new Object();
	         reportParams.intakeYearId = formValue.intakeYear;
	         reportParams.programGroupId = formValue.programGroup;
	         reportParams.startDate = formValue.fromDate;
	         reportParams.endDate = formValue.toDate;
	         reportParams.programCategoryId = formValue.programCategory;
	         reportParams.academyLocationId =$this.getMultiSelectAcademyLocation();
	         reportParams.headerName = getCommonTranslation('ENQUIRY_SUMMARY_REPORT');
	         var reportTitle="";
	       $this.exportJRXMLReport(code,reportParams,code,'.vnd.ms-excel',SERVERURL.PATH_LEAD_EXCEL_SUMMARY_REPORT);
	     },
	     getLeadPDFReport:function(){
	    	var $this=this;
	    	 var form=$this.getEnquirysummaryform();
	    	 var formValue = form.getForm().getValues();
	    	 var enquirysummarygrid = this.getEnquirysummarygrid();
	    	 var code = "LeadSummaryReport";
	         var reportParams =new Object();
	         reportParams.intakeYearId = formValue.intakeYear;
	         reportParams.programGroupId = formValue.programGroup;
	         reportParams.startDate = formValue.fromDate;
	         reportParams.endDate = formValue.toDate;
	         reportParams.programCategoryId = formValue.programCategory;
	         reportParams.academyLocationId =$this.getMultiSelectAcademyLocation();
	         reportParams.headerName = getCommonTranslation('ENQUIRY_SUMMARY_REPORT');
	         var reportTitle="";
	       $this.exportJRXMLReport(code,reportParams,code,'.pdf',SERVERURL.PATH_LEAD_PDF_SUMMARY_REPORT);
	     },
	     getMultiSelectAcademyLocation:function(){
	    	 var organizationForm = this.getOrganizationunit().getForm();
			 var academyLocation = organizationForm.findField('multiselectAcademyLocation');
			 var academyLocationIds=[];
			 Ext.Array.each(academyLocation.getValue(),function(value){
				 if(Ext.isObject(value)){
					 academyLocationIds.push(value.data.id);	
				 }else{
					 academyLocationIds.push(value);
				 }
			 });
			 return academyLocationIds.join();
	     },
	     resetLeadSummaryForm:function(){
	    	 var $this=this;
	    	 var enquirysummarygrid = this.getEnquirysummarygrid();
	    	 var form=$this.getEnquirysummaryform();
			 form.getForm().reset();
			 enquirysummarygrid.down('#btnExportToPDFJasper').setDisabled(true);
	    	 enquirysummarygrid.down('#btnExportToExcelJasper').setDisabled(true);
	    	 if(form.down('#fromDate')){
	    		 form.down('#fromDate').setMinValue(false);
	    		 form.down('#fromDate').setMaxValue(false);
	    	 }
	    	 if(form.down('#toDate')){
	    		 form.down('#toDate').setMinValue(false);
	    		 form.down('#toDate').setMaxValue(false);
	    	 }
	     },
		   doAccessEnqDashboardReportTreePnl: function(structure) {
		    	var treePanel = structure;
		    	var treePnlRootNode = treePanel.getRootNode();
		    	this.checkPermissionAndRemoveEnqReportTreePnl(treePnlRootNode,this.getENQUIRY_DASHBOARD_FOLLOWUP_SCHEDULED_PERMISSIONS(), "ENQ_FOLLOWUP_SCHEDULED"); 
		    	this.checkPermissionAndRemoveEnqReportTreePnl(treePnlRootNode,this.getENQUIRY_DASHBOARD_REPORT_PENDING_ENQ_PERMISSIONS(), "ENQ_PENDING_ENQUIRIES");
		    	this.checkPermissionAndRemoveEnqReportTreePnl(treePnlRootNode,this.getENQUIRY_DASHBOARD_REPORT_COUNT_OF_ENQ_PERMISSIONS(), "ENQ_COUNT_OF_ENQUIRIES");
		    	this.checkPermissionAndRemoveEnqReportTreePnl(treePnlRootNode,this.getENQUIRY_DASHBOARD_REPORT_ENQ_CLOSURE_RATE_PERMISSIONS(), "ENQ_CLOSUR_RATE");
		    	this.checkPermissionAndRemoveEnqReportTreePnl(treePnlRootNode,this.getENQUIRY_DASHBOARD_REPORT_CLOSURE_REASON_PERMISSIONS(), "ENQ_CLOSURE_REASON");
		    	this.checkPermissionAndRemoveEnqReportTreePnl(treePnlRootNode,this.getENQUIRY_DASHBOARD_REPORT_ENQUIRY_SUMMARY_PERMISSIONS(), "ENQ_ENQUIRY_SUMMARY");

		    },
		    checkPermissionAndRemoveEnqReportTreePnl: function(treePnlRootNode, permissionMap, permissionKey){
		    	var associatedAcadLocationIds = new Array();
		    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionMap);
		    	var constView = 'VIEW';
		    	if(!isNullOrEmpty(permissionList)){
		    		if(!Ext.Array.contains(permissionList, constView)) {							
		    			var vacantNode = treePnlRootNode.findChild("permissionKey",permissionKey,true);
		    			if(!isNullOrEmpty(vacantNode)){
		    				vacantNode.remove(); 
		    			}
		    		} 
		    	}

		    }
});