/**
 * This controller is used for Enquiry Form Setup
 * @author Amit G
 * FIXME: [AKR] Extend the BASE CONTROLLER
 */
Ext.define('Academia.controller.enquiry.enquirySettings.CtrlPadmEnquiryFormSetupController', {
	extend: 'Academia.controller.base.BaseController',

	models: [],
	stores: ['user.UserAcademyLocationStore', 'program.ProgramByGroupIdStore','dynamicformrendering.configurescreen.ConfigureScreenGrid',
		'enquiryFormSetup.StoAdmEnquiryFormCustomColumnSetUpStore'],

		views: ['enquiry.enquirySettings.PAdmEnquiryFormSetupConfigureScreen','enquiry.enquirySettings.PadmEnquiryFormSetupSettings','enquiry.enquirySettings.VWPadmEnquirySetupFormConfigureScreenGrid',
			'enquiry.enquirySettings.PadmEnquiryFormSetupDataForm','enquiry.enquirySettings.PAdmEnquiryFormSetupDFRConfigureScreen','enquiry.enquirySettings.VWPAdmStudentEnquiryDetailSetupConfigureScreenGrid',
			'enquiry.enquirySettings.PAdmEnquiryFormSetupCustomColumnScreen','enquiry.enquirySettings.VWPadmEnquirySetupCustomColumnGrid','enquiry.enquirySettings.VWPAdmStudentEnquiryDetailCustomColumnGrid',
			'enquiry.enquirySettings.PadmEnquiryAdditionalSetupForm'],

			refs: [{
				ref: 'padmenquiryformsetupdataform',
				selector: 'padmenquiryformsetupdataform'
			},{
				ref: 'vwpadmenquirysetupformconfigurescreengrid',
				selector: 'vwpadmenquirysetupformconfigurescreengrid'
			},{
				ref: 'vwpadmstudentenquirydetailsetupconfigurescreengrid',
				selector: 'vwpadmstudentenquirydetailsetupconfigurescreengrid'
			},{
				ref: 'padmenquiryformsetupcustomcolumnscreen',
				selector: 'padmenquiryformsetupcustomcolumnscreen'
			},{
				ref: 'vwpadmenquirysetupcustomcolumngrid',
				selector: 'vwpadmenquirysetupcustomcolumngrid'
			},{
				ref: 'vwpadmstudentenquirydetailcustomcolumngrid',
				selector: 'vwpadmstudentenquirydetailcustomcolumngrid'
			},{
				ref: 'padmenquiryadditionalsetupform',
				selector: 'padmenquiryadditionalsetupform'
			},{
				ref:'padmenquiryformsetupconfigurescreen',
				selector:'padmenquiryformsetupconfigurescreen'
			},{
	        	 ref : 'contentPanel',
	        	 selector:'contentpanel'
	         }],
			init: function(application) {
				this.control({
					'vwpadmenquirysetupformconfigurescreengrid':{
						render : function(grid){
							var $this = this;
							grid.getStore().getProxy().extraParams={
								academyLocationId:this.getCurrentAcademyLocation(),
								screenName:'Manage Enquiry',
								screenMode:'Create'
							}
							grid.getStore().load();
						} 
					},
					'vwpadmstudentenquirydetailsetupconfigurescreengrid':{
						render : function(grid){
							var $this = this;
							grid.getStore().getProxy().extraParams={
								academyLocationId:this.getCurrentAcademyLocation(),
								screenName:'Student Enquiry Details',
								screenMode:'Create'
							}
							//grid.getStore().load();
						} 
					},
					'padmenquiryformsetupdfrconfigurescreen tabpanel#manageEnquiryStudentTabItemId':{
						tabchange:function(tabPanel, newCard, oldCard, eOpts){
							var newTabName=newCard;
							var $this = this;
							var grid =null;
							var screenName;
							var screenMode;
							if(newTabName.title==getCommonTranslation('MANAGE_ENQUIRY')){
								grid = $this.getVwpadmenquirysetupformconfigurescreengrid();
								screenName='Manage Enquiry';
								screenMode='Create';

							}else  if(newTabName.title==getCommonTranslation('STUDENT_ENQUIRY_DETAILS')){	
								grid = $this.getVwpadmenquirysetupformconfigurescreengrid();
								screenName='Student Enquiry Details';
								screenMode='Create';
							}
							grid.getStore().getProxy().extraParams={
								academyLocationId:this.getCurrentAcademyLocation(),
								screenName:screenName,
								screenMode:screenMode
							}
							grid.getStore().load();
						}
					},
					'padmenquiryformsetupdfrconfigurescreen button[itemId=btnSave]':{
						click:function(screenView){
							this.admSaveManageEnquiryConfigureScreenData(screenView);
						}
					},
					'padmenquiryformsetupcustomcolumnscreen tabpanel#manageEnquiryStudentTabCustomFieldItemId':{
						tabchange:function(tabPanel, newCard, oldCard, eOpts){
							var newTabName=newCard;
							var $this = this;
							var grid =null;
							var tableName;
							var screenMode;
							if(newTabName.title==getCommonTranslation('MANAGE_ENQUIRY')){
								grid = $this.getVwpadmenquirysetupcustomcolumngrid();
								tableName='enquiry';

							}else  if(newTabName.title==getCommonTranslation('STUDENT_ENQUIRY_DETAILS')){	
								grid = $this.getVwpadmstudentenquirydetailcustomcolumngrid();
								tableName='enq_student_details';
							}
							grid.getStore().getProxy().extraParams={
								academyLocationId:1,
								tableName: tableName
							}
							grid.getStore().load();
						}
					},
					'vwpadmenquirysetupcustomcolumngrid':{
						render: function(grid) {
							grid.getStore().getProxy().extraParams={
								academyLocationId:1,
								tableName: 'enquiry'
							}
							grid.getStore().load();
						}
					},
					'vwpadmenquirysetupcustomcolumngrid button[itemId=btnSave]':{
						click:function(){
							this.saveEnquiryCustomColumnSetup('Manage Enquiry');
						}
					},
					'vwpadmstudentenquirydetailcustomcolumngrid button[itemId=btnSave]':{
						click:function(){
							this.saveEnquiryCustomColumnSetup('Student Enquiry Details');
						}
					},
					'padmenquiryadditionalsetupform': {
						afterrender: function(form) {
							this.reloadFormFields(form);
						}
					},
					'padmenquiryadditionalsetupform button[itemId=SubmitBtn]':{
						click:function(obj, record){
							var $this = this;
							var form = $this.getPadmenquiryadditionalsetupform();
							$this.saveEnquiryFormAddtionalSetup(form);
						}
					},
					'padmenquiryadditionalsetupform button[itemId=removeLogoFile]':{
						click:function(obj, record){
							var $this = this;
							$this.removeFile('logo');
						}
					},
					'padmenquiryadditionalsetupform button[itemId=removeDocFile]':{
						click:function(obj, record){
							var $this = this;
							$this.removeFile('guidelineDoc');
						}
					},
					'padmenquiryadditionalsetupform button[itemId=removeBackgroundImage]':{
						click:function(obj, record){
							var $this = this;
							$this.removeFile('backgroundImage');
						}
					},
					'padmenquiryadditionalsetupform filefield[itemId=enquirySetupLogoItemId]':{
						change: function(fileField, value, eOpts) {
							var $this = this;
							$this.validateUploadFiles(fileField);
						}
					},
					'padmenquiryadditionalsetupform filefield[itemId=backgroundfileItemId]':{
						change: function(fileField, value, eOpts) {
							var $this = this;
							$this.validateUploadFiles(fileField);
						}
					},
					'padmenquiryformsetupconfigurescreen tabpanel':{
						tabchange:function(){
		            		var structure = this.getContentPanel();
		            		var activatedTab = structure.getActiveTab();
		            		var structureBody = activatedTab.body;
		            		structureBody.scrollBy(0,5);
		            		structureBody.setScrollTop();
						}
					},
					'padmenquiryadditionalsetupform filefield[itemId=OnlinePortalfileItemId]':{
						change: function(fileField, value, eOpts) {
							var $this = this;
							$this.validateOnlinePortalUploadFiles(fileField);
						}
					},
					'padmenquiryadditionalsetupform button[itemId=removeOnlineEnquiryLogoImage]':{
						click:function(obj, record){
							var $this = this;
							$this.removeFile('onlineEnquiryImage');
						}
					},
				});
			},
			/// Save methods
			admSaveManageEnquiryConfigureScreenData:function(screenView){
				var $this = this;
				var grid;
				var activeLayout = screenView.up('padmenquiryformsetupdfrconfigurescreen').down('tabpanel');
				var activeTab = activeLayout.getActiveTab();
				if(activeTab.itemId == 'enquirySetupTabItemId'){
					grid = $this.getVwpadmenquirysetupformconfigurescreengrid();
					screenMode = 'Create';
					languageId = 1;
					screenName = 'Manage Enquiry';
				}else{
					grid = $this.getVwpadmstudentenquirydetailsetupconfigurescreengrid(); 
					screenMode = 'Create';
					languageId = 1;
					screenName = 'Student Enquiry Details';
				}
				var languageId;
				var screenMode;
				var screenName;
				var configureArray = [];
				var selectedRecord = grid.getSelectionModel().getSelection().length;
				if(selectedRecord > 0){
					var record = grid.getSelectionModel().getSelection();
					if(record.length > 0) {
						for(var i=0;i<record.length;i++){
							var rec=record[i];
							var isVisibleField = rec.data.isVisible;
							var isVisible; 
							if(isVisibleField == null || isVisibleField == 'Yes'){
								isVisible = true;
							}else{
								isVisible =false;
							}

							var helpText;
							if(!isNullOrEmpty(rec.data.helpText)){
								helpText =rec.data.helpText;
							}else{
								helpText = null;
							}
							configureArray.push({
								"formFieldId": rec.data.formFieldId,
								"formFieldDisplaySettingId": rec.data.formFieldDisplaySettingId,
								"screenName": screenName,
								"screenMode": screenMode,
								"defaultLabel": rec.data.defaultLabel,
								"newLabel": rec.data.newLabel,
								"isFieldLocked": rec.data.isFieldLocked,
								"isMandatory": rec.data.isMandatory,
								"isVisible": isVisible,
								"helpText": helpText,
								"defaultValue": rec.data.defaultValue,
								"languageId": languageId,
								"academyLocationId": this.getCurrentAcademyLocation(),
								"whetherForAllAcademyLocation": false
							});
						}
					}
					if(configureArray.length > 0){
						Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
						Ext.Ajax.request({
							type : 'rest',
							url : SERVERURL.CONFIGURE_SCREEN_SAVE,
							jsonData : configureArray,
							method : 'POST',
							success : function(form, action) {
								Ext.getBody().unmask();
								showSuccessMessage(getCommonTranslation('DYNAMIC_FORM_RENDERING'),getCommonTranslation('SUCCESS'));
								grid.getStore().reload();
								grid.getSelectionModel().deselectAll();
							}
						});
					}else{
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
					}
				} 
				else{
					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
				}
			},
			saveEnquiryCustomColumnSetup:function(screenMode){
				var this$ = this;
				var setUpGrid = this$.getVwpadmstudentenquirydetailcustomcolumngrid();
				var entityType = 'enq_student_details';
				if (screenMode == 'Manage Enquiry') {
					setUpGrid = this$.getVwpadmenquirysetupcustomcolumngrid();
					entityType = 'enquiry';
				}
				var records = setUpGrid.getStore().data.items;
				if(records.length > 0) {        	
					var customColumnModuleSetup = new Array();
					var visibilityParam=null;
					var mandatoryParam = null;
					Ext.each(records, function(obj) {
						var mandatory;
						if (obj.data.isVisible == null || obj.data.isVisible == false) {
							mandatory = false;
						}else{
							mandatory = obj.data.isMandatory;
						}
						customColumnModuleSetup.push({
							"id" : obj.data.id,
							"academyLocation":this$.getIdValueJson(parseInt(1)),
							"customFieldConfig":this$.getIdValueJson(obj.data.customFieldConfig.id),
							"entityType" :entityType,
							"isVisible":obj.data.isVisible,
							"isMandatory":mandatory,
							"whetherCustomField":obj.data.whetherCustomField
						});

					});
					var recordsToUpdate = Ext.encode(customColumnModuleSetup);
					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					Ext.Ajax.request({
						type: 'rest',
						method: 'post',
						url: SERVERURL.PATH_SAVE_CUSTOM_ENQ_FORM_CONFIG,
						jsonData: recordsToUpdate,
						success : function(response, action) {
							var jsonData = Ext.JSON.decode(response.responseText);
							var response = response.responseText;
							Ext.getBody().unmask();
							showSuccessMessage(getCommonTranslation('ENQUIRY_PAGE_SETUP'), getCommonTranslation('SUCCESS'));
							if(setUpGrid.getStore().getRange().length>0){
								setUpGrid.getStore().removeAll();
							}
							setUpGrid.getStore().loadData(jsonData);
						}
					});
				}
			},
			getIdValueJson: function(id, value) {
				if (id) return {
					id: id,
					value: value
				};
			},
			reloadFormFields : function(form){
				var this$ = this;
				Ext.Ajax.request({
					type: 'rest',
					url: SERVERURL.PATH_FIND_ENQUIRY_FORM_ADDTIONAL_SETUP_RECORD+'?academyLocationId='+1,
					method: 'GET',
					callback : function(opt, success, response){
						var data = Ext.decode(response.responseText);
						this$.loadData(form, data);
					}
				});
			},
			loadData : function(form, data) {
				form.down('#Id').setValue(data.id);
				form.down('#logoPath').setValue(data.logoPath);
				form.down('#documentPath').setValue(data.documentPath);
				form.down('#backgroundImagePath').setValue(data.backgroundImagePath);
				form.down('#onlinePortalImagePath').setValue(data.onlinePortalImagePath);
				form.down('#captchaVerificationItemId').setValue(data.captchaVerification);
				form.down('#enquirySetupLogoItemId').setRawValue(data.logoPath);
				form.down('#docfileItemId').setRawValue(data.documentPath);
				form.down('#backgroundfileItemId').setRawValue(data.backgroundImagePath);
				form.down('#OnlinePortalfileItemId').setRawValue(data.onlinePortalImagePath);
				if (data.logoPath != null && data.logoPath != '') {
					form.down('#removeLogoFile').setVisible(true);
				}else{
					form.down('#removeLogoFile').setVisible(false);
				}
				if (data.documentPath != null && data.documentPath != '') {
					form.down('#removeDocFile').setVisible(true);
				}else{
					form.down('#removeDocFile').setVisible(false);
				}
				if (data.backgroundImagePath != null && data.backgroundImagePath != '') {
					form.down('#removeBackgroundImage').setVisible(true);
				}else{
					form.down('#removeBackgroundImage').setVisible(false);
				}
				if (data.onlinePortalImagePath != null && data.onlinePortalImagePath != '') {
					form.down('#removeOnlineEnquiryLogoImage').setVisible(true);
				}else{
					form.down('#removeOnlineEnquiryLogoImage').setVisible(false);
				}
			},
			saveEnquiryFormAddtionalSetup : function(form){
				var this$ = this;
				form.getForm().findField('moduleName').setValue('Enquiry');
				var logoPath = form.getForm().findField('logoPath').getValue();
				var docPath = form.getForm().findField('documentPath').getValue();
				var backgroundImgPath = form.getForm().findField('backgroundImagePath').getValue();
				var onlinePathImagePath =form.getForm().findField('onlinePortalImagePath').getValue();
				var logoPathField = form.down('#enquirySetupLogoItemId').getValue();
				var backgroudPathField = form.down('#backgroundfileItemId').getValue();
				var docPathField = form.down('#docfileItemId').getValue();
				var onlinePathImageId =form.down('#OnlinePortalfileItemId').getValue();
				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
				if (!isNullOrEmpty(logoPathField) || !isNullOrEmpty(backgroudPathField) ||!isNullOrEmpty(docPathField)||!isNullOrEmpty(onlinePathImageId)) {
					form.getForm().submit({
						method: 'POST',
						url: SERVERURL.PATH_UPLOAD_ENQUIRY_SETUP_ADDITIONAL_IMAGES,
						success: function(form1, action) {
							var responseData = Ext.decode(action.response.responseText);
							if(responseData.success) {
								var path = responseData.path;
								var pathForSecondFile = responseData.pathForSecondFile;
								var pathForThirdFile = responseData.pathForThirdFile;
								var pathForFourthFile = responseData.pathForFourthFile;
								if (path != null && path !='') {
									form.getForm().findField('logoPath').setValue(path);
								}else{
									form.getForm().findField('logoPath').setValue(logoPath);
								}
								if (pathForSecondFile != null && pathForSecondFile !='') {
									form.getForm().findField('backgroundImagePath').setValue(pathForSecondFile);
								}else{
									form.getForm().findField('backgroundImagePath').setValue(backgroundImgPath);
								}
								if (pathForThirdFile != null && pathForThirdFile !='') {
									form.getForm().findField('documentPath').setValue(pathForThirdFile);
								}else{
									form.getForm().findField('documentPath').setValue(docPath);
								}
								if (pathForFourthFile != null && pathForFourthFile !='') {
									form.getForm().findField('onlinePortalImagePath').setValue(pathForFourthFile);
								}else{
									form.getForm().findField('onlinePortalImagePath').setValue(onlinePathImagePath);
								}
							
								this$.saveEnquiryAdditionalSetupRecord(form);
							} 
						},
						failure: function(d, f, s) {
							console.log('hello');
						}
					});
				}else{
					this$.saveEnquiryAdditionalSetupRecord(form);
				}

			},
			saveEnquiryAdditionalSetupRecord: function(form) {
				var this$ = this;
				var id = form.down('#Id');
				if (isNullOrEmpty(id.getSubmitValue())) {
					isUpdate = false;
				} else {
					isUpdate = true;
				}
				var logoPath = form.getForm().findField('logoPath').getValue();
				var documentPath = form.getForm().findField('documentPath').getValue();
				var backgroundImagePath = form.getForm().findField('backgroundImagePath').getValue();
				var onlinePortalImage =form.getForm().findField('onlinePortalImagePath').getValue();
				var jsonFormatFormData = this$.getJsonEnquiryAdditionSetupSubmitData(form);
				this$.sendSaveAjaxRequest(SERVERURL.PATH_SAVE_ENQUIRY_ADDITIONAL_SETUP, 'POST', jsonFormatFormData, function(option, success, response) {
					Ext.getBody().unmask();
					if (success, form) {
						var data = Ext.decode(response.responseText);
						this$.loadData(form, data);
						showSuccessMessage(getCommonTranslation('ENQUIRY_PAGE_SETUP'), getCommonTranslation('SUCCESS'));
					} 
				});
			},
			getJsonEnquiryAdditionSetupSubmitData: function(form) {	
				var this$ = this;
				var jsonFormFieldData = new Object();
				var formData = form.getValues();
				var academyLocation = {
						id: 1
				};
				formData.academyLocation = academyLocation;
				delete formData.pageSize;
				delete formData.moduleName;
				delete formData.customData;
				jsonFormFieldData = Ext.encode(formData);
				return jsonFormFieldData;
			},
			removeFile : function(fileType) {
				var this$ = this;
				var form = this$.getPadmenquiryadditionalsetupform();
				Ext.Ajax.request({
					type: 'rest',
					url: SERVERURL.PATH_REMOVE_ENQUIRY_FORM_SETUP_FILE+'?documentType='+fileType,
					method: 'GET',
					callback : function(opt, success, response){
						var data = Ext.decode(response.responseText);
						this$.loadData(form, data);
					}
				});
			},
			validateUploadFiles: function(uploadField) {
				var this$ = this;
				var filePath = uploadField.getValue();
				if(!isNullOrEmpty(filePath)){
					var extension = filePath.substring(filePath.lastIndexOf('.') + 1).toLowerCase();
					if (extension == "gif" || extension == "png" || extension == "bmp"
						|| extension == "jpeg" || extension == "jpg") {

					}else{
						uploadField.reset();
						showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
					}
				}
			},
			validateOnlinePortalUploadFiles: function(uploadField) {
				var this$ = this;
				var filePath = uploadField.getValue();
				if(!isNullOrEmpty(filePath)){
					var extension = filePath.substring(filePath.lastIndexOf('.') + 1).toLowerCase();
					if (extension == "png" || extension == "jpeg" || extension == "jpg") {

					}else{
						uploadField.reset();
						showWarningMessage(getPersonModuleTranslation('PHOTO_UPLOAD'), getPersonModuleTranslation('UPLOAD_VALID_FILE'));
					}
				}
			}
});