/**
 * Rajkumar
 * @author rupesh.agrawal
 */
Ext.define('Academia.controller.enquiry.student.StudentDetailController', {
	extend : 'Academia.controller.base.BaseController',
	models : ['enquiry.studentDetail.StudentDetailModel',
	          'enquiry.studentDetail.StudentAddressModel'],
	          
	stores : ['enquiry.studentDetail.GenderStore', 'enquiry.studentDetail.BloodGroupStore',
            'enquiry.studentDetail.ReservationCategoryStore','organization.CountryRegionStore1',
            'enquiry.studentDetail.IncomeSlabStore','enquiry.studentDetail.StudentAddressStore',
            'organization.AddressTypeStore','organization.CityStore', 'organization.CountryRegionStore','organization.CityByCountryRegion',
            'enquiry.ReferredIdStore','enquiry.ReferredIdStore2',
	          'enquiry.ReferredIdStore3','enquiry.ReferredIdStore4','common.ExamBoardStore'],
            
	views : [ 'enquiry.student.StudentDetailStructure','enquiry.student.StudentDetailForm',
              'enquiry.student.StudentAddressFormWindow','enquiry.student.StudentAddressGrid'],
              
    alias : "widget.studentdetailcontroller",
    
              refs : [{
            	  ref : 'enquirytabstructure',
            	  selector : 'enquirytabstructure'
              },{
            	  ref : 'studentdetailform',
            	  selector : 'studentdetailform#enqStudentDetailForm'
              },{
            	  ref: 'studentAddress',
            	  selector: 'studentaddress[itemId=studentaddressId] form'
              },{
              	ref:'searchresultgrid',
            	selector:'searchresultgrid[itemId=trackenquirygrid]'
              },{
            	  ref: 'studentaddress',
            	  selector: 'studentaddress[itemId=studentaddressId]'   
              },{
            	  ref: 'studentaddressgrid',
            	  selector: 'studentaddressgrid'  		  
              },{
            	  ref: 'customfieldform',
            	  selector: 'customfieldform'  		  
              },{
            	  ref: 'studentdetailstructure',
            	  selector: 'studentdetailstructure'  		  
              }],
              
              init : function() {

            	  this.control({
            		  'studentdetailform button[itemId=studentdetail_submitbuttonId]':{
            			  click:this.saveStudentDetail
            		  },
            		  'studentdetailform button[itemId=studentdetail_cancelbuttonId]':{
            			  click:this.cancelStudentDetail
            		  },
            		  'studentdetailform button[itemId=studentdetail_addressId]':{
            			  click:this.openStudentDetailAddress
            		  },
            		  'studentdetailform radiogroup[itemId=SD_radioBtn_F]':{
            			  change:function(f){
            				  this.checkFatherEmployee(f);
            			  }
            		  },
            		  
               		  'studentdetailform livesearchcombo[itemId=studentDetails_memployeeIdF]':{
               			select:function(combo,data){
            				  this.setFatherEmployeeDetails(combo,data);
            			  }
            		  },
            		  
            		  'studentdetailform radiogroup[itemId=SD_radioBtn_M]':{
            			  change:function(f){
            				  this.checkMotherEmployee(f);
            			  }
            		  },
               		  
               		  'studentdetailform livesearchcombo[itemId=studentDetails_memployeeIdM]':{
               			select:function(combo,data){
            				  this.setMotherEmployeeDetails(combo,data);
            			  }
            		  },
            		  
            		  'studentdetailform radiogroup[itemId=SD_radioBtn_orgSiblling]':{
            			  change:function(radioGroup){
            				  this.checkOrgSiblling(radioGroup);
            			  }
            		  },
            		  
            		  'studentdetailform radiogroup[itemId=enq_radioBtn_uwcBefore]':{
            			  change:function(radioGroup){
            				  this.checkEnqUwcBefore(radioGroup);
            			  }
            		  },
            		  
            		  'studentdetailform radiogroup[itemId=enq_radioBtn_registeredBeforeSA]':{
            			  change:function(radioGroup){
            				  this.checkEnqRegisteredBeforeSA(radioGroup);
            			  }
            		  },
            		  'studentdetailform':{
            			  render:function(f){
            				  this.onStudentFormRender(f);
            			  }
            		  },
            		  'studentaddress[itemId=studentaddressId] button[itemId=studentWin_submitbuttonId]':{
            			  click:this.addStudentAddress
            		  },
            		  'studentaddress[itemId=studentaddressId] combo[itemId=countryId]':{
            			select:function(f,r){
            			  var countryId=r[0].data.id;	  
//            			  var store = this.getStore('organization.CityStore');
            			  var store = this.getStore('organization.CountryRegionStore');
              				store.getProxy().extraParams = {
              					cid: countryId
              				};
              				store.load();
              				 var form = this.getStudentAddress();
              				 var phoneCountryCode = form.down('customcombobox#phoneCountryCode');
              				 var cellCountryCode = form.down('customcombobox#cellCountryCode');
              				 var countryStore = form.down('customcombobox#countryId').getStore();
              				 var val = countryStore.getById(countryId);
               	        
              				 phoneCountryCode.setValue(val);
              				 cellCountryCode.setValue(val);
              				 
              				 var mobileField = form.down("numberfield#cellNo");
                        	 this.setMaximumMinimumDigitsForMobileNoValidation(form, cellCountryCode, mobileField, null);
            			  }
            		  },
            		  'studentaddress[itemId=studentaddressId] combo[itemId=parentCountryRegionId]':{
              			select:function(f,r){
              				 var countryRegionId=r[0].data.id;	  
               			  var store = this.getStore('organization.CityByCountryRegion');
                 				store.getProxy().extraParams = {
                 					id: countryRegionId
                 				};
                 				store.load();
              			}
              		  },
              		  'studentaddress[itemId=studentaddressId] combo[itemId=genericFieldId1]':{
                			select:function(f,r){
                			 var countryRegionId=r[0].data.id;
//                    	     var store = this.getStore('organization.CountryRegionStore1');
                			 var store = this.getStore('organization.CityByCountryRegion');
                  				store.getProxy().extraParams = {
                  					id: countryRegionId
                  				};
                  				store.load();
                			  }
                    		},
            		  'studentaddress[itemId=studentaddressId] button[itemId=studentWin_cancelbuttonId]':{
            			  click:function(f){
            				  var addressWin = this.getStudentaddress();
            				  if (addressWin) {
  								addressWin.close();
  							  }
            			  }
            		  },
            		  'studentaddress[itemId=studentaddressId]':{
            			  render:function(){
            				  var $this = this;
            				 var form = $this.getStudentAddress();
            				 var addressType = form.down('#addressTypeId');
            				 addressType.store.load({
      		                    callback: function(rec, operation, success) {
      		                        if (success) {
      		                        	addressType.setValue(rec[0].data.id);
      		                        	$this.addressTypeStudent(rec[0].data.id);
      		                        }
      		                    }
      		                });
            			  }
            		  },
            		  'studentaddress[itemId=studentaddressId] combo[itemId=addressTypeId]':{
            			  select:function(){
            				  this.addressTypeStudent();
            			  }
            		  },
            		  'studentaddress[itemId=studentaddressId] combo[itemId=phoneCountryCode]':{
          			  	select:function(rowModel,record){
          			  		var form = this.getStudentAddress();
               				var phoneCountryCode = form.down('customcombobox#phoneCountryCode');
               				var phoneNoField = form.down("numberfield#phoneNoField");
               				this.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, record);
            				}
          		      },
            		  'studentaddress[itemId=studentaddressId] combo[itemId=cellCountryCode]':{
            			  	select:function(rowModel,record){
            			  		var form = this.getStudentAddress();
                 				var countryCodeField = form.down('customcombobox#cellCountryCode');
                 				var mobileField = form.down("numberfield#cellNo");
                 				this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, record);
              				}
            		  },
            		  'studentaddress[itemId=studentaddressId] numberfield[itemId=cellNo]':{
                			change:function(record){
                				var form = this.getStudentAddress();
                 				var mobileField = form.down("numberfield#cellNo");
                 				mobileField.isValid();
                 				mobileField.isValid();
                    			form.getForm().checkValidity();
                			}
              		  },
            	
            		  'studentdetailform customcombobox[name=sibilingUser1]':{
            			  afterrender: function(combo){
            				  var me = this;
            				  combo.getStore().on('load',function(){
            					  var sform = me.getStudentdetailform();
            					  var combo1 = sform.down('[name=sibilingUser1]');
            					  var combo2 = sform.down('[name=sibilingUser2]');
            					  var combo3 = sform.down('[name=sibilingUser3]');
            					  
            					  combo1.getStore().clearFilter();
            					  if(!isNullOrEmpty(combo2.getValue()) && !isNullOrEmpty(combo3.getValue())){
            						  combo1.getStore().filterBy(function(record, id){
            							  return (record.get('id') != combo2.getValue() && record.get('id') != combo3.getValue());
            						  });
            					  }
            					  else if(!isNullOrEmpty(combo2.getValue())){
            						  combo1.getStore().filterBy(function(record, id){
            							  return record.get('id') != combo2.getValue();
            						  });
            					  }
            					  else if(!isNullOrEmpty(combo3.getValue())){
            						  combo1.getStore().filterBy(function(record, id){
            							  return record.get('id') != combo3.getValue();
            						  });
            					  }
            					  combo1.lastQuery = null;
            				  });
            			  }
            		  },
            		  'studentdetailform customcombobox[name=sibilingUser2]':{
            			  afterrender: function(combo){
            				  var me = this;
            				  combo.getStore().on('load',function(){
            					  var sform = me.getStudentdetailform();
            					  var combo1 = sform.down('[name=sibilingUser1]');
            					  var combo2 = sform.down('[name=sibilingUser2]');
            					  var combo3 = sform.down('[name=sibilingUser3]');
            					  
            					  combo2.getStore().clearFilter();
            					  if(!isNullOrEmpty(combo1.getValue()) && !isNullOrEmpty(combo3.getValue())){
            						  combo2.getStore().filterBy(function(record, id){
            							  return (record.get('id') != combo1.getValue() && record.get('id') != combo3.getValue());
            						  });
            					  }
            					  else if(!isNullOrEmpty(combo1.getValue())){
            						  combo2.getStore().filterBy(function(record, id){
            							  return record.get('id') != combo1.getValue();
            						  });
            					  }
            					  else if(!isNullOrEmpty(combo3.getValue())){
            						  combo2.getStore().filterBy(function(record, id){
            							  return record.get('id') != combo3.getValue();
            						  });
            					  }
            					  combo2.lastQuery = null;
            				  });
            			  }
            		  },
            		  'studentdetailform customcombobox[name=sibilingUser3]':{
            			  afterrender: function(combo){
            				  var me = this;
            				  combo.getStore().on('load',function(){
            					  var sform = me.getStudentdetailform();
            					  var combo1 = sform.down('[name=sibilingUser1]');
            					  var combo2 = sform.down('[name=sibilingUser2]');
            					  var combo3 = sform.down('[name=sibilingUser3]');
            					  
            					  combo3.getStore().clearFilter();
            					  if(!isNullOrEmpty(combo1.getValue()) && !isNullOrEmpty(combo2.getValue())){
            						  combo3.getStore().filterBy(function(record, id){
            							  return (record.get('id') != combo1.getValue() && record.get('id') != combo2.getValue());
            						  });
            					  }
            					  else if(!isNullOrEmpty(combo1.getValue())){
            						  combo3.getStore().filterBy(function(record, id){
            							  return record.get('id') != combo1.getValue();
            						  });
            					  }
            					  else if(!isNullOrEmpty(combo2.getValue())){
            						  combo3.getStore().filterBy(function(record, id){
            							  return record.get('id') != combo2.getValue();
            						  });
            					  }
            					  combo3.lastQuery = null;
            				  });
            			  }
            		  },
            		  'studentdetailform customcombobox[itemId=studentSibling1]':{
            			  render: function(combo){
                      		combo.getStore().getProxy().extraParams = { 
                          		 isMultiAccessAllowForSibiling:true
              				  };
                           }
            		  },
            		  'studentdetailform customcombobox[itemId=studentSibling2]':{
            			  render: function(combo){
                      		combo.getStore().getProxy().extraParams = { 
                          		 isMultiAccessAllowForSibiling:true
              				  };
                           }
            		  },
            		  'studentdetailform customcombobox[itemId=studentSibling3]':{
            			  render: function(combo){
                      		combo.getStore().getProxy().extraParams = { 
                          		 isMultiAccessAllowForSibiling:true
              				  };
                           }
            		  },
            		  'studentdetailform customcombobox[itemId=stdCountryCodeItemId]': {
  	                    select: function(rowModel, record) {
  	                    	var this$ = this;
  	                    	var form = this$.getStudentdetailform();
  	                    	var countryCodeField = form.down("#stdCountryCodeItemId");
  	                     	var mobileField = form.down("#stdMobileNumberItemId");
  	                     	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
  	                    }
  	                },
  	                'studentdetailform numberfield[itemId=stdMobileNumberItemId]': {
  	                    change: function(record) {
  	                    	var this$ = this;
  	                    	var form = this$.getStudentdetailform();
  	                     	var mobileField = form.down("#stdMobileNumberItemId");
  	                     	mobileField.isValid();
  	            			form.getForm().checkValidity();
  	                    }
  	                },
  	              'studentdetailform customcombobox[itemId=stdAlternateMobileCountryCode]': {
	                    select: function(rowModel, record) {
	                    	var this$ = this;
	                    	var form = this$.getStudentdetailform();
	                    	var countryCodeField = form.down("#stdAlternateMobileCountryCode");
	                     	var mobileField = form.down("#stdAlternateMobileNo");
	                     	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
	                    }
	                },
	                'studentdetailform numberfield[itemId=stdAlternateMobileNo]': {
	                    change: function(record) {
	                    	var this$ = this;
	                    	var form = this$.getStudentdetailform();
	                     	var mobileField = form.down("#stdAlternateMobileNo");
	                     	mobileField.isValid();
	            			form.getForm().checkValidity();
	                    }
	                },
	                'studentdetailform nestedJsonCombo[itemId=examBoardItemId]': {
	                	select: function(combo) {
                      		var this$ = this;
                      		var form = this$.getStudentdetailform();
                      		var examBoardOther = null;
                         	var enqStudentSubject = form.down("#enquiryStudentSchoolSubjectItemId");
                         	var store = enqStudentSubject.getStore();
                         	enqStudentSubject.reset();
                         	
                      		var id = combo.getValue();
                      		var value = combo.getRawValue();
                      		if(value == 'Others'){
                      			examBoardOther = true ;
                      		}else{
                      			examBoardOther = false ; 
                      		}
                      		store.getProxy().extraParams = {
                      			id:id ,
                      			examBoardOther:examBoardOther
                      		};
                      		store.load();
                      		form.getForm().checkValidity();
                      	}
	                },
	                'studentdetailform multiselectcombofield[itemId=enquiryStudentSchoolSubjectItemId]': {
	                	render: function(combo) {
              			  var this$ = this;
              			  var form = this$.getStudentdetailform();
                            if(form.down("#examBoardItemId").getValue()==null){
                                var store = combo.getStore();
                                store.getProxy().extraParams = {
                                    id: null,
                                    examBoardOther:null
                                };
                            }
                            store.load();
                        }
	                },
	                'studentdetailstructure': {
	        			render:function(structure){
	        				var $this = this
	        				structure.body.on('click', function() {
	        					var form = structure.down('studentdetailform');
//	        					$this.hideInvalidIconFromField(form);
	        			       });
	        			}
	        		},
	        		'studentdetailform customcombobox[itemId=currentGradeItemId]':{
            			select: function(obj, record) {
            				var studentForm = this.getStudentdetailform();
            				var gradeTwelveAverage = studentForm.down('#gradeTwelveAverageItemId');
            				if(!isNullOrEmpty(record[0].data) && record[0].data.code==='Gap Year'){
            					gradeTwelveAverage.setDisabled(false);
            					gradeTwelveAverage.reset();
            				}else{
            					gradeTwelveAverage.setDisabled(true);
            					gradeTwelveAverage.reset();
            				}
            			}
            		}
            	  });
              },

              openStudentDetailAddress : function(){
            	  var commonForm = this.getEnquirytabstructure().getForm();
        		  var commonVal = commonForm.getValues();
        		  var buttonId = commonVal.buttonType;
            	  var formWindow = this.getStudentaddress();
            	  if (!formWindow) {
            		  Ext.widget('studentaddress',{
              			  itemId:'studentaddressId'
              		  });
            		  formWindow = this.getStudentaddress();
            	  }
            	  formWindow.show();
            	  if(buttonId == 'View') {
            		  formWindow.down('#studentWin_submitbuttonId').hide();
            		  this$.toggleReadOnlyFormItems(formWindow.down('form').getForm(), true);
            		  
            	  }
            	  else {
            		  var countryCodeField = formWindow.down('#cellCountryCode');
            		  var mobileField = formWindow.down('#cellNo');
            		  this$.setMaximumMinimumDigitsForMobileNoValidation(formWindow,countryCodeField,mobileField,null);
            		  var phoneCountryCode = formWindow.down('#phoneCountryCode');
            		  var phoneNoField = formWindow.down('#phoneNoField');
            		  this$.setMaximumMinimumDigitsForPhoneNoValidation(formWindow,phoneCountryCode,phoneNoField,null);
              	  }
              },
              saveStudentDetail:function(f){
            	  var $this= this;
            	  var form = f.ownerCt.ownerCt.getForm();
                  var val = form.getValues();
            	  var studentModel = new Academia.model.enquiry.studentDetail.StudentDetailModel(val);
            	  studentModel.set('incomeSlabs',$this.getIdValueJson(val.incomeSlabs));
            	  studentModel.set('nationality',$this.getIdValueJson(val.nationality));
            	  studentModel.set('country',$this.getIdValueJson(val.country));
            	  studentModel.set("id", Ext.getCmp('studentDetails_id').getValue());
            	  studentModel.set("whetherDeleted",false);
            	  studentModel.set("currentGrade",$this.getIdValueJson(val.currentGrade));
            	  studentModel.set("gradeElevenAverage",val.gradeElevenAverage);
            	  studentModel.set("gradeTwelveAverage",val.gradeTwelveAverage);
            	  studentModel.set("studentFirstNameOtherLanguage",val.studentFirstNameOtherLanguage);
            	  studentModel.set("studentMiddleNameOtherLanguage",val.studentMiddleNameOtherLanguage);
            	  studentModel.set("studentLastNameOtherLanguage",val.studentLastNameOtherLanguage);
            	  
            	  if(!isNullOrEmpty(val.uwcStudentId) && !isNullOrEmpty(val.whetherUwcBefore) && val.whetherUwcBefore == true){
            		  studentModel.set("uwcStudentId", val.uwcStudentId);
            		  studentModel.set("whetherUwcBefore", val.whetherUwcBefore);
  	        	} else {
  	        		studentModel.set("whetherUwcBefore", val.whetherUwcBefore);
  	        		form.findField('uwcStudentId').reset();
  	        		delete studentModel.uwcStudentId
  	        	}
  	        	
  	        	if(!isNullOrEmpty(val.southAfricanStudentId) && !isNullOrEmpty(val.whetherRegisteredBeforeSA) && val.whetherRegisteredBeforeSA == true){
  	        		studentModel.set("southAfricanStudentId", val.southAfricanStudentId);
  	        		studentModel.set("whetherRegisteredBeforeSA", val.whetherRegisteredBeforeSA);
  	        	} else {
  	        		studentModel.set("whetherRegisteredBeforeSA", val.whetherRegisteredBeforeSA);
  	        		form.findField('southAfricanStudentId').reset();
  	        		delete studentModel.southAfricanStudentId
  	        	}
            	  
            	  
            	  if(typeof(val.examBoard)=="object") {
            		  studentModel.set("examBoard",val.examBoard);
            	  } else {
            		  studentModel.set("examBoard",$this.getIdValueJson(val.examBoard));
            	  }
            	  
            	  if( !isNullOrEmpty(val.enquiryStudentSchoolSubject) ){
            		  var enquiryStudentSchoolSubjectArr = [];
    				  var schoolSubjArr = val.enquiryStudentSchoolSubject;
    				  for( var p in schoolSubjArr ){
    					  var schoolSubj = {};
    					  var subject = {};
    					  if( !isNullOrEmpty(schoolSubjArr[p].data) ){
    						  subject.id = schoolSubjArr[p].data.id;  
    						  schoolSubj.subject = subject;
    					  } else {
    						  subject.id = schoolSubjArr[p];
    						  schoolSubj.subject = subject;
    					  }
    					  schoolSubj.enquiryStudentDetail = {"id":Ext.getCmp('studentDetails_id').getValue()};
    					  enquiryStudentSchoolSubjectArr.push(schoolSubj);
    				  }
    				  studentModel.set("enquiryStudentExamBoardSubject",enquiryStudentSchoolSubjectArr);
            	  }
            	  delete studentModel.data.enquiryStudentSchoolSubject;
            	
            	  //'sibilingUser1','sibilingUser2','sibilingUser3'
            	  if(!isNullOrEmpty(val.sibilingUser1) && !isNullOrEmpty(val.whetherSiblingStudying) && val.whetherSiblingStudying == true){
            		  studentModel.set('sibilingUser1',$this.getIdValueJson(val.sibilingUser1));
            	  } else {
            		  form.findField('sibilingUser1').reset();
            		  delete studentModel.data.sibilingUser1
            	  }
            	  if(!isNullOrEmpty(val.sibilingUser2) && !isNullOrEmpty(val.whetherSiblingStudying) && val.whetherSiblingStudying == true){
            		  studentModel.set('sibilingUser2',$this.getIdValueJson(val.sibilingUser2));
            	  } else {
            		  form.findField('sibilingUser2').reset();
            		  delete studentModel.data.sibilingUser2
            	  }
            	  if(!isNullOrEmpty(val.sibilingUser3) && !isNullOrEmpty(val.whetherSiblingStudying) && val.whetherSiblingStudying == true){
            		  studentModel.set('sibilingUser3',$this.getIdValueJson(val.sibilingUser3));
            	  } else {
            		  form.findField('sibilingUser3').reset();
            		  delete studentModel.data.sibilingUser3
            	  }
            	  
            	  if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
            		  studentModel.data.salutation =  {"id":1};
            		  studentModel.data.reservationCategory.id = 1;
            	  }
            	  
            	  if(val.gender!=null){
            		studentModel.set('genderCSM',$this.getIdValueJson(val.gender));
  	        	} else {
  	        		form.findField('gender').reset();
  	        		delete studentModel.data.genderCSM
  	        	}
            	  
            	  var grid = this.getStudentaddressgrid();
            	  var store = grid.getStore();
            	  var myItems = store.getRange();

            	  var myjson = [];
            	  for(var i in myItems){
            		  myjson.push({
            			  "id":'',
            			  "address":{
            				  "addressType" : myItems[i].get('addressType'),
            				  "addressText" : myItems[i].get('addressText'),
            				  "country" : myItems[i].get('country'),
            				  "city" : myItems[i].get('city'),
            				  "parentCountryRegion" : myItems[i].get('parentCountryRegion'),
            				  "countryRegion" : myItems[i].get('countryRegion'),			
            				  "phoneCountryCode" : myItems[i].get('phoneCountryCode'),
            				  "phoneAreaCode" : myItems[i].get('phoneAreaCode'),
            				  "phoneNo" : myItems[i].get('phoneNo'),
            				  "cellCountryCode" : myItems[i].get('cellCountryCode'),
            				  "cellNo" : myItems[i].get('cellNo'),
            				  "primaryEmailId" :  myItems[i].get('primaryeEmailId'),
            				  "alternateEmailId" : myItems[i].get('alternateEmailId')
            			  }
            			  });
            		  }
            		  this.deleteEmptyFields(studentModel.data);
            		  studentModel.set("gender",null);
            		  var submitData = Ext.encode(studentModel.data);
            		  var submitUrl =  SERVERURL.ENQUIRY_STUDENT_DETAIL_UPDATE;
            		  Ext.Ajax.request({
            			  url: submitUrl,
            			  jsonData: submitData,
            			  method: 'POST',
            			  success: function(response) {
            				  var TrackEnquiryController=  Academia.app.getController('Academia.controller.enquiry.TrackEnquiryController');
            				  var enquiryTabStructure = TrackEnquiryController.getEnquirytabstructure();
            				 // var studentDetailForm = $this.getStudentdetailform();
            				 // studentDetailFormValue = studentDetailForm.getValues();
            				  var enquiryTabForm = enquiryTabStructure.getForm();
            				  var displayStudentName = enquiryTabForm.findField("displayStudentName");
            				  displayStudentName.setValue(val.studentFirstName+" "+val.studentMiddleName+ " "+val.studentLastName);

            				  var grid=$this.getSearchresultgrid();
            				  if(grid!=undefined){
            					  grid.getStore().reload();
            				  }
            				  showSuccessMessage(getEnquiryTranslation('ENQUIRY_STUDENT_DETAILS'),getCommonTranslation('SUCCESS'));
            			  }
            		  });
            	  },
            	  
            	  deleteEmptyFields:function(object){
            		  for (var property in object) {
            			  if(isNullOrEmpty(object[property])){
            				  delete object[property];
            			  }
            			}
            	  },
            	  
            	  cancelStudentDetail:function(){
            		  var form = this.getStudentdetailform().getForm();
            		  form.reset();
            	  },
            	  
            	  checkFatherEmployee : function(radioGroup){
            		  var fatherComponent = radioGroup.up('studentdetailform').down('#studentDetails_memployeeIdF');
            		  var flag=radioGroup.getValue().fatherEmployed;
            		  if(flag){
            			  fatherComponent.allowBlank=false;
                		  fatherComponent.setVisible(flag); 
                		  fatherComponent.setFieldLabel(getEnquiryTranslation('ENQUIRY_EMPLOYEE_NAME') + '<span class="required" style="color:red"> *</span>');
                		  this.getStudentdetailform().isValid();
            		  }else{
            			  fatherComponent.allowBlank=true;
                		  fatherComponent.setVisible(flag);
                		  fatherComponent.setFieldLabel(getEnquiryTranslation('ENQUIRY_EMPLOYEE_NAME'));
                		  this.getStudentdetailform().isValid();
            		  }
            		  
            	  },
            	  
            	  setFatherEmployeeDetails : function(combo,data){
            		  
            		  var fatherDetailsContainer = combo.up('studentdetailform').down('#fatherDetailsContainer');
            		  var fatherFirstName=data[0].get('firstName');
            		  var fatherMiddleName=data[0].get('middleName');
            		  var fatherLastName=data[0].get('lastName');
            		//  var salutation =data[0].get('salutation');
            		 // fatherDetailsContainer.down('#studentDetails_father_salutation').setValue(salutation);
            		  fatherDetailsContainer.down('#studentDetails_fatherFirstName').setValue(fatherFirstName);
            		  fatherDetailsContainer.down('#studentDetails_fatherMiddleName').setValue(fatherMiddleName);
            		  fatherDetailsContainer.down('#studentDetails_fatherLastName').setValue(fatherLastName);
            	  },
            	  
            	  setMotherEmployeeDetails : function(combo,data){
            		  
            		  var fatherDetailsContainer = combo.up('studentdetailform');
            		  var motherFirstName=data[0].get('firstName');
            		  var motherMiddleName=data[0].get('middleName');
            		  var motherLastName=data[0].get('lastName');
            		//  var salutation =data[0].get('salutation');
            		  
             		 // fatherDetailsContainer.down('#studentDetails_father_salutation').setValue(salutation);
            		  fatherDetailsContainer.down('#studentDetails_motherFirstName').setValue(motherFirstName);
            		  fatherDetailsContainer.down('#studentDetails_motherMiddleName').setValue(motherMiddleName);
            		  fatherDetailsContainer.down('#studentDetails_motherLastName').setValue(motherLastName);
            	  },
            	  
            	  checkMotherEmployee : function(radioGroup){
            		  var motherComponent = radioGroup.up('studentdetailform').down('#studentDetails_memployeeIdM');
            		  var flag=radioGroup.getValue().motherEmployed;
            		  if(flag){
            			  motherComponent.allowBlank=false;
            			  motherComponent.setVisible(flag); 
            			  motherComponent.setFieldLabel(getEnquiryTranslation('ENQUIRY_EMPLOYEE_NAME') + '<span class="required" style="color:red"> *</span>');
                		  this.getStudentdetailform().isValid();
            		  }else{
            			  motherComponent.allowBlank=true;
            			  motherComponent.setVisible(flag);
            			  motherComponent.setFieldLabel(getEnquiryTranslation('ENQUIRY_EMPLOYEE_NAME'));
                		  this.getStudentdetailform().isValid();
            		  }
            	  },
            	  
            	  checkOrgSiblling : function(radioGroup){
            		  var siblingDetailsComponent = radioGroup.up('studentdetailform').down('#siblingDetailsComponent');
            		  siblingDetailsComponent.setVisible(radioGroup.getValue().whetherSiblingStudying);
            	  },
            	  
            	  checkEnqUwcBefore : function(radioGroup){
            		  var uwcDetailsComponent = radioGroup.up('studentdetailform').down('#uwcBefore');
            		  if(radioGroup.getValue().whetherUwcBefore==true)
            		  {
            			  uwcDetailsComponent.setVisible(true);
            			  uwcDetailsComponent.setFieldLabel(getEnquiryTranslation('STUDENT_ID_NUMBER')+ ' <span class="required" style="color:red"> *</span>');
            			  var form=uwcDetailsComponent.up('studentdetailform');
            			  uwcDetailsComponent.allowBlank=false;
            			  form.isValid();
            		  }
            		  else
            		  {
            			  uwcDetailsComponent.setVisible(false);
            			  uwcDetailsComponent.allowBlank=true;
            			  uwcDetailsComponent.setValue('');
            			  var form=uwcDetailsComponent.up('studentdetailform');
            			  form.isValid();
            		  }
            		  
            	  },
            	  checkEnqRegisteredBeforeSA: function(radioGroup){
            		  var registeredBeforeSA = radioGroup.up('studentdetailform').down('#registeredBeforeSA');
            		  if(radioGroup.getValue().whetherRegisteredBeforeSA==true)
            		  {
            			  registeredBeforeSA.setVisible(true);
            			  registeredBeforeSA.setFieldLabel(getEnquiryTranslation('STUDENT_ID_NUMBER')+ ' <span class="required" style="color:red"> *</span>');
            			  var form=registeredBeforeSA.up('studentdetailform');
            			  registeredBeforeSA.allowBlank=false;
            			  form.isValid();
            		  }
            		  else
            		  {
            			  registeredBeforeSA.setVisible(false);
            			  registeredBeforeSA.allowBlank=true;
            			  registeredBeforeSA.setValue('');
            			  var form=registeredBeforeSA.up('studentdetailform');
            			  form.isValid();
            		  }
            	  },
            	  
            	  onStudentFormRender:function(form){
            		  var this$ = this;
            		  var sform = this$.getStudentdetailform();
            		  var studentStructure = this$.getEnquirytabstructure();
            		  var commonForm = this$.getEnquirytabstructure().getForm();
            		  var commonVal = commonForm.getValues();
            		  var enquiryType = commonVal.enqTypes;
            		  var studentDetailId = commonVal.studentDetailId;
            		  var buttonId = commonVal.buttonType;
            		  var nationality = form.down('#nationalityCombo');
            		  var countryCombo = form.down('#countryItemId');
            		  var addressForm = form.down('#studentdetail_addressId');
            		  var studentDateofBirthField = form.down('#studentDetails_studentDateOfBirth');
            		  Ext.getCmp('studentDetails_enqRegByStudent').setVisible(false);
            		  nationality.getStore().load();
            		  countryCombo.getStore().load();
                  	  if(buttonId == 'View'){
                  		form.down('#studentdetail_submitbuttonId').setVisible(false);
                  		form.down('#studentdetail_cancelbuttonId').setVisible(false);
                  		this$.toggleReadOnlyFormItems(form.getForm(), true);
                  	 }
                  	  
                  	 if(studentDetailId > 0){
       				  Ext.Ajax.request({
       					  method: 'GET',
       					  // changed by utsav, bcoz above was getting student detail record on the basis of enquiry which is wrong
       					  // it should be on the basis of studentId
       					  //url: SERVERURL.ENQUIRY_STUDENT_DETAIL_FINDALL,
       					  url: SERVERURL.ENQUIRY_STUDENT_DETAIL_BYID,
       					  params:{id:studentDetailId},
       					  success: function(response) {
       						  if(response.responseText!=null &&  response.responseText!=""){
       							  if(enquiryType!='Admission'){
       							  form.down('#studentdetail_submitbuttonId').setVisible(false);
       		                  	  form.down('#studentdetail_cancelbuttonId').setVisible(false);
       		                  	  form.down('#studentdetail_addressId').setVisible(false);
       		                  	  this$.toggleReadOnlyFormItems(form.getForm(), true); 
       							  }else if(buttonId != 'View'){
       								 form.down('#studentdetail_submitbuttonId').setVisible(true);
          		                  	  form.down('#studentdetail_cancelbuttonId').setVisible(true);
          		                  	  this$.toggleReadOnlyFormItems(form.getForm(), false); 
          		                  	  var countryCodeField = form.down("#stdCountryCodeItemId");
          		                      var mobileField = form.down("#stdMobileNumberItemId");
          		                      this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
          		                      countryCodeField = form.down("#stdAlternateMobileCountryCode");
          		                      mobileField = form.down("#stdAlternateMobileNo");
          		                      this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
       							  }
       							  var data = Ext.decode(response.responseText);
       							  var enquiryStudentDetail = new Academia.model.enquiry.studentDetail.StudentDetailModel(data);
       		                      form.getForm().loadRecord(enquiryStudentDetail);
       		                      if(!isNullOrEmpty(data.nationality))
       		                        nationality.setValue(data.nationality.id);
       		                      
       		                      if(!isNullOrEmpty(data.country)){
       		                    	countryCombo.setValue(data.country.id);
       		                      }
       		                      
       							  Ext.getCmp('studentDetails_id').setValue(data.id);
       							  if(!isNullOrEmpty(data.enquiry)){
       								  Ext.getCmp('studentDetails_enquiryId').setValue(data.enquiry.id);  
       							  }
     								//  Ext.getCmp('studentDetails_registeredByType').setValue(data.registeredByType);
       							  if(data.genderCSM!=null && data.genderCSM!=undefined)	{
       								  Ext.getCmp('studentDetails_gender').setValue(data.genderCSM.id);
       							  }
       							  else {
       								  Ext.getCmp('studentDetails_gender').setValue(null);
       							  }
   								  Ext.getCmp('studentDetails_bloodGroup').setValue(data.bloodGroup);
   								  Ext.getCmp('studentDetails_studentDateOfBirth').setValue(dateRender(data.studentDateOfBirth));
   								  studentDateofBirthField.setValue(dateRender(data.studentDateOfBirth));
   								 var isLearnerSACitizenFld = form.getForm().findField('isLearnerSACitizen');
   								 var isLearnerSACitizenRadioGroup = form.down('#stdIsLearnerSACitizenItemId');
   								 if( !isNullOrEmpty(data.isLearnerSACitizen) && data.isLearnerSACitizen != undefined && data.isLearnerSACitizen == true ){
   			            		  isLearnerSACitizenRadioGroup.items.items[0].setValue(true);
   			            		  isLearnerSACitizenRadioGroup.items.items[1].setValue(false);
   								 }
   								 if( !isNullOrEmpty(data.isLearnerSACitizen) && data.isLearnerSACitizen != undefined && data.isLearnerSACitizen == false ){
   			            		  isLearnerSACitizenRadioGroup.items.items[0].setValue(false);
   			            		  isLearnerSACitizenRadioGroup.items.items[1].setValue(true);
   								 }
   			            	  
   								 isLearnerSACitizenFld.setValue(data.isLearnerSACitizen);
   								  
   								  // Read only true for this field
   								  Ext.getCmp('studentDetails_registeredByType').setReadOnly(true);
   								  Ext.getCmp('studentDetails_enqRegByStudent').setReadOnly(true);
   								  try{
   									  var reservationCategoryId = data.reservationCategory.id;
   									  var incomeslabId = data.incomeSlabs.id;
   								  }catch(e){
   								  }
   								  var IncomeStore = this$.getStore('enquiry.studentDetail.IncomeSlabStore');
   								  IncomeStore.load({
   									  callback: function(record, operation, success) {
   										  if (success) {
   											  form.down('#incomeSlab').setValue(incomeslabId);
   											 // Ext.getCmp('studentDetails_incomeSlabs').setValue(incomeslabId);
   										  }
   									  }
   								  });
   								form.down('#gradeTwelveAverageItemId').reset();
   								  if( !isNullOrEmpty(data.currentGrade) ){
   									  var currentGradeId = data.currentGrade.id;
   									  var currentGradeStore = this$.getStore('enquiry.EnquiryCurrentGradeStore');
   									  currentGradeStore.load({
   										  callback: function(record, operation, success) {
   											  if (success) {
   												  form.down('#currentGradeItemId').setValue(currentGradeId);
   												  if(data.currentGrade.code==='Gap Year'){
   													  form.down('#gradeTwelveAverageItemId').setValue(data.gradeTwelveAverage);
   													  form.down('#gradeTwelveAverageItemId').setDisabled(false);
   												  }else{
   													  form.down('#gradeTwelveAverageItemId').reset();
   													  form.down('#gradeTwelveAverageItemId').setDisabled(true);
   												  }
   											  }
   										  }
   									  });
   								  }
   								  var examBoardId = null;
   								  var examBoardOther=null;
   								  if( !isNullOrEmpty(data.examBoard) ){
 									  examBoardId = data.examBoard.id;
 									  var examBoardCode = data.examBoard.value;
 									  if(examBoardCode == 'Others'){
 	   			            			examBoardOther = true ;
 	   			            		  }else{
 	   			            			examBoardOther = false ; 
 	   			            		  }
 									  var examBoardStore = form.down('#examBoardItemId').getStore();
 									  examBoardStore.load({
 										  callback: function(record, operation, success) {
 											  if (success) {
 												  form.down('#examBoardItemId').setValue(examBoardId);
 											  }
 										  }
 									  });
 								  }
   								  
   								  form.down('#gradeElevenAverageItemId').setValue(data.gradeElevenAverage);
   								  form.down('#studentFirstNameOtherLanguageItemId').setValue(data.studentFirstNameOtherLanguage);
   								  form.down('#studentMiddleNameOtherLanguageItemId').setValue(data.studentMiddleNameOtherLanguage);
   								  form.down('#studentLastNameOtherLanguageItemId').setValue(data.studentLastNameOtherLanguage);
   								  var enquiryStudSchoolSubjStore = form.down('#enquiryStudentSchoolSubjectItemId').getStore();
   								  
   								  enquiryStudSchoolSubjStore.getProxy().extraParams = {
   									id:examBoardId ,
   			            			examBoardOther:examBoardOther
   								  };
   								  
   								  if(data.enquiryStudentExamBoardSubject != null) {
   									enquiryStudSchoolSubjStore.load({
   										  callback: function(records, operation, success) {
   											  if (success) {
   												  var haveDisabilitiesArray= [];
   												  if(records.length > 0){
   													data.enquiryStudentExamBoardSubject.forEach(function(disabilityObj){
   														  var result = records.filter(function (obj) {
   															  return obj.data.id === disabilityObj.subject.id;
   														  })[0];
   														  haveDisabilitiesArray.push(result.data.id);
   													  });
   													form.down('#enquiryStudentSchoolSubjectItemId').setValue(haveDisabilitiesArray);
   												  }
   											  }
   										  }
   									  });
   								  }
   								  
   								  var reservationCategory = this$.getStore('enquiry.studentDetail.ReservationCategoryStore');
   								  reservationCategory.load({
   									  callback: function(record, operation, success) {
   										  if (success) {
   											if(!isNullOrEmpty(data.reservationCategory)){
  												 Ext.getCmp('studentDetails_reservationCategory').setValue(data.reservationCategory);
  											 }else{
  												 this$.DefaultDFRForReservationCategory(this$.getStudentdetailform(),'studentdetailform');
  											 }
   										  }
   									  }
   								  });
   								  
   								  var registerByType = this$.getStore('enquiry.EnquiryRegisteredBy');
   								  registerByType.load({
   									  callback: function(record, operation, success) {
   										  if (success) {
   											  Ext.getCmp('studentDetails_registeredByType').setValue(data.registeredByType);
   										  }
   									  }
   								  });
   								  Ext.getCmp('studentDetails_enqRegByStudent').reset();
   								  if(!isNullOrEmpty(data.linkStudentId) && !isNullOrEmpty(data.linkStudentId.id)) {
	   								  var linkStudentIdStore = this$.getStore('enquiry.ReferredStudentId');
	   								  linkStudentIdStore.load({
	 									  callback: function(record, operation, success) {
	 										  if (success) {
	 											  Ext.getCmp('studentDetails_enqRegByStudent').setValue(data.linkStudentId.id);
	 										  }
	 									  }
	 								  });
   								  }
   								  var Salutation = this$.getStore('common.SalutationStore');
   								  Salutation.load({
   									  callback: function(record, operation, success) {
   										  if (success) {
   											  for(i in record) {
   												  if(record[i].get('id') == 1) {
   													Ext.getCmp('studentDetails_salutation').setValue(record[i].get('id'));  
   												  }
   											  }
   											  Ext.getCmp('studentDetails_mother_salutation').setValue(data.motherSalutationId);
   											  Ext.getCmp('studentDetails_father_salutation').setValue(data.fatherSalutationId);
   										  }
   									  }
   								  });
   								  if(!isNullOrEmpty(data.sibilingUser1)){
   									  var sibilingUser1 = this$.getStore('enquiry.ReferredIdStore2');
   									  sibilingUser1.getProxy().extraParams = {
   			              					name: data.sibilingUser1.code,
   			              				    isMultiAccessAllowForSibiling:true
   			              				};
       								  sibilingUser1.load({
       									  callback: function(record, operation, success) {
       										  if (success) {
       											  Ext.getCmp('studentDetails_addmissionIdofsiblling1').setValue(data.sibilingUser1.id);
       										  }
       									  }
       								  });
   								  }if(!isNullOrEmpty(data.sibilingUser2)){
   									  var sibilingUser2 = this$.getStore('enquiry.ReferredIdStore3');
   									  sibilingUser2.getProxy().extraParams = {
 			              					name: data.sibilingUser2.code,
 			              					isMultiAccessAllowForSibiling:true
 			              				};
       								  sibilingUser2.load({
       									  callback: function(record, operation, success) {
       										  if (success) {
       											  Ext.getCmp('studentDetails_addmissionIdofsiblling2').setValue(data.sibilingUser2.id);
       										  }
       									  }
       								  });
   								  }if(!isNullOrEmpty(data.sibilingUser3)){
   									  var sibilingUser3 = this$.getStore('enquiry.ReferredIdStore4');
   									  sibilingUser3.getProxy().extraParams = {
   			              					name: data.sibilingUser3.code,
   			              				    isMultiAccessAllowForSibiling:true
   			              				};
       								  sibilingUser3.load({
       									  callback: function(record, operation, success) {
       										  if (success) {
       											  Ext.getCmp('studentDetails_addmissionIdofsiblling3').setValue(data.sibilingUser3.id);
       										  }
       									  }
       								  });
   								  }
   								  
       						  }
       						  if((Ext.getCmp('studentDetails_registeredByType').getValue())!=undefined && !isNullOrEmpty(Ext.getCmp('studentDetails_registeredByType').getValue()) &&
       								  Ext.getCmp('studentDetails_registeredByType').getValue()=="STUDENT") {
       							  Ext.getCmp('studentDetails_enqRegByStudent').setVisible(true);
         					  }
         					  else{
         						  Ext.getCmp('studentDetails_enqRegByStudent').setVisible(false);
         						  Ext.getCmp('studentDetails_enqRegByStudent').allowBlank=true;
         					  }
       					  }
       				  });
                  	 }else{
                  	  form.down('#studentdetail_submitbuttonId').setVisible(false);
                  	  form.down('#studentdetail_cancelbuttonId').setVisible(false);
                  	  form.down('#studentdetail_addressId').setVisible(false);
                  	  form.down('#studentdetail_addressId').setDisabled(true);
                  	  Ext.getCmp('studentDetails_enqRegByStudent').reset();
                  	  Ext.getCmp('studentDetails_enqRegByStudent').setVisible(false);
					  Ext.getCmp('studentDetails_enqRegByStudent').allowBlank=true;
                  	  this$.toggleReadOnlyFormItems(form.getForm(), true); 
                  	 }
               	     
            		 /* if(enquiryType!='Admission'){
            			  form.down('#studentdetail_submitbuttonId').setVisible(false);
                    	  form.down('#studentdetail_cancelbuttonId').setVisible(false);
                    	  form.down('#studentdetail_addressId').setVisible(false);
                    	  this$.toggleReadOnlyFormItems(form.getForm(), true);
            		  }else if(enquiryType=='Admission' || enquiryType=='Counselling'){

            			  if(studentDetailId > 0){}
            		  }*/
            	  },
            	  addStudentAddress : function (){
            		  var $this = this;
            		  var form = this.getStudentAddress().getForm();
            		  $this.getStudentAddress().down('#studentWin_submitbuttonId').setDisabled(true);
            		  var values = form.getValues();
                      var studentId=Ext.getCmp('studentDetails_id').getValue();
                      var dataModel=new Academia.model.enquiry.studentDetail.StudentAddressModel();
                     
                      dataModel.set('id',values.addressId);
                      dataModel.set('version',values.version);
                      dataModel.set('addressText',values.addressText);
                      dataModel.set('country',$this.getIdValueJson(values.country));
                      dataModel.set('parentCountryRegion',$this.getIdValueJson(values.parentCountryRegion));
                      dataModel.set('city',$this.getIdValueJson(values.city));
                      dataModel.set('pincode',values.pincode);
                      dataModel.set('cellCountryCode',values.cellCountryCode);
                      dataModel.set('cellNo',values.cellNo);
                      dataModel.set('phoneCountryCode',values.phoneCountryCode);
                      dataModel.set('phoneAreaCode',values.phoneAreaCode);
                      dataModel.set('phoneNo',values.phoneNo);
                      dataModel.set('primaryeEmailId',values.primaryeEmailId);
                      dataModel.set('alternateEmailId',values.alternateEmailId);
                      dataModel.set('addressType',$this.getIdValueJson(values.addressType));
                      dataModel.set('countryRegion',$this.getIdValueJson(values.countryRegion));
                      dataModel.set('salutation',values.salutation);
                      var data={
                    		  "id":parseInt(values.id),
                    		  "addressTypeId":parseInt(values.addressType),
                    		  "studentDetailId":parseInt(studentId),
                    		  "address":dataModel.data,
                    		  "enquiryStudentDetail":$this.getIdValueJson(parseInt(studentId))
                               };
                      
                      Ext.Ajax.request({
    					  method: 'POST',
    					  url: SERVERURL.CREATE_ADDRESS_URL,
    					  jsonData:data,
    					  success: function(response) {
    						  showSuccessMessage(getCommonTranslation('ENQUIRY_ADDRESS'),getCommonTranslation('SUCCESS'));
    					    }
    					  });
            		  $this.getStudentaddress().close();
            	  },
            	  getIdValueJson: function(id, value) {
            		  if (id) return {
            			  id: id,
            			  value: value
            		  };
            	  },
            	  addressTypeStudent:function(renderId){
     				 var $this=this;
     				 var form = $this.getStudentAddress().getForm();
     				 var addressType = form.findField('addressType');
     				 var addId = form.findField('addressType').getValue();
     				 //console.log('addId',addId);
     				//console.log('renderId',renderId);
     				 var addressId; 
     				 if(renderId!=undefined && renderId !="" && renderId !=null){
     					addressId = renderId; 
     				 }else{
     					addressId = addId;
     				 }
     				 
     				 
     				 addressType.store.load({
     		                    callback: function(rec, operation, success) {
     		                        if (success) {
     		                        	addressType.setValue(addId);
     		                        }
     		                    }
     		                });
	            		  
     				 var studentId=Ext.getCmp('studentDetails_id').getValue();
     				  
     				  Ext.Ajax.request({
             			  url: SERVERURL.SELECT_ADDRESS_TYPE_URL,
             			  method: 'GET',
             			  params:{
             				  studentDetailId:studentId,
             				  addressTypeId:addId
             			  },
             			  success: function(f) {
             				if(f.responseText){
             				var  jData=Ext.JSON.decode(f.responseText);
             				//console.log('jData',jData);
             				var dataModel=new Academia.model.enquiry.studentDetail.StudentAddressModel(jData.address);
             				form.findField('addressType').allowBlank=true;
             				form.loadRecord(dataModel);
             				
             				if(jData.id!=null){
             					form.findField('id').setValue(jData.id);
             				}
             				if(jData.address!=null){
             					form.findField('addressId').setValue(jData.address.id);
             				}
             				
             				if(jData.enquiryStudentDetail!=null){
             					form.findField('enquiryStudentDetailId').setValue(jData.enquiryStudentDetail.id);
             				}
             				if(jData.address.version!=null){
             					form.findField('version').setValue(jData.address.version);
             				}

             				var addressTypeCombo=Ext.ComponentQuery.query('combo#addressTypeId')[0];
       						if(dataModel.data.addressType!=null){
       						addressTypeCombo.store.load({
       		                    callback: function(records, operation, success) {
       		                        if (success) {
       		                        	addressTypeCombo.setValue(dataModel.data.addressType.id);
       		                        }
       		                    }
       		                });
       						}
       						
       						if(dataModel.data.country!=null){
       						var countryCombo=form.findField('country');
       						countryCombo.store.load({
       		                    callback: function(records, operation, success) {
       		                        if (success) {
       		                        	countryCombo.setValue(dataModel.data.country.id);
       		                        }
       		                    }
       		                });
       						}
       						
       						if(dataModel.data.parentCountryRegion !=null && dataModel.data.city!=null){
       						var cityCombo=form.findField('city');
       						cityCombo.store.getProxy().extraParams = {
       							id:dataModel.data.parentCountryRegion.id
              				};
       						cityCombo.store.load({
       		                    callback: function(records, operation, success) {
       		                        if (success) {
       		                        	cityCombo.setValue(dataModel.data.city.id);
       		                        }
       		                    }
       		                });
       						}
       						
       						if(dataModel.data.country!=null && dataModel.data.parentCountryRegion!=null){
       						var parentCountryRegionCombo=form.findField('parentCountryRegion');
       						parentCountryRegionCombo.store.getProxy().extraParams = {
              					cid: dataModel.data.country.id
              				};
       						parentCountryRegionCombo.store.load({
       		                    callback: function(records, operation, success) {
       		                        if (success) {
       		                        	parentCountryRegionCombo.setValue(dataModel.data.parentCountryRegion.id);
       		                        }
       		                    }
       		                });
       						}
       						
       						if(dataModel.data.parentCountryRegion!=null && dataModel.data.countryRegion!=null){
       						var countryRegionCombo=form.findField('countryRegion');
       						countryRegionCombo.store.load({
       							params:{
       								pid:dataModel.data.parentCountryRegion.id
       							},
       		                    callback: function(records, operation, success) {
       		                        if (success) {
       		                        	countryRegionCombo.setValue(dataModel.data.countryRegion.id);
       		                        }
       		                    }
       		                });
       						}
             		     }
             			}
             		  });
            	   },
            	   DefaultDFRForReservationCategory : function(form, formAlias){
            		   var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
            		   var	formFieldsInfo = fieldInfo.get("formFieldsInfo");	
            		   var formfields = formFieldsInfo[formAlias];
            		   if(formfields != undefined){
            			   for(var i in formfields){
            				   if(formfields[i].formAliasName == formAlias){
            					   var formFieldName = formfields[i].formFieldName;
            					   var formFieldVisiable = formfields[i].isVisible;
            					   var formAliasName = formfields[i].formAliasName;
            					   if(formAliasName==formAlias && formFieldName =="reservationCategory" && !isNullOrEmpty(formfields[i].defaultValue)){
            						   form.down('#studentDetails_reservationCategory').setValue(parseInt(formfields[i].defaultValue));
            					   }
            				   }
            			   }
            		   }
            	   }
              });
